(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49314,       1102]
NotebookOptionsPosition[     45758,        982]
NotebookOutlinePosition[     47074,       1020]
CellTagsIndexPosition[     46988,       1015]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Adding, Removing and Modifying List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AddingRemovingAndModifyingListElements"], 
          "Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Adding, Removing and Modifying List Elements\"\>", 
       2->"\<\"Options for Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "None" :> Documentation`HelpLookup["paclet:ref/None"], "Full" :> 
          Documentation`HelpLookup["paclet:ref/Full"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Automatic\"\>", 2->"\<\"None\"\>", 
       3->"\<\"Full\"\>", 4->"\<\"Part\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup[
           "paclet:guide/PlottingAndImageRegions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Options & Styling\"\>", 
       2->"\<\"Plotting and Image Regions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["All", "ObjectName",
 CellID->10393],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]], "InlineFormula"],
     "\[LineSeparator]is a setting used for certain options. In ",
     Cell[BoxData[
      ButtonBox["Part",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Part"]], "InlineFormula"],
     " and related functions, ",
     Cell[BoxData[
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]], "InlineFormula"],
     " specifies all parts at a particular level. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30548]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", "All"}]], "InlineFormula"],
 " specifies that all points are to be included in a plot. "
}], "Notes",
 CellID->27273]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->181936191],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->69178442],

Cell["", "ExampleText",
 CellID->4542382],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " to extract the first column vector: "
}], "ExampleText",
 CellID->516158244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490106177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94405586]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " to extract the column matrix: "
}], "ExampleText",
 CellID->3503393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "All", ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532747884],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42366591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324867829],

Cell["Normally, plots drop outlying points:", "ExampleText",
 CellID->54891791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332427845],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135181353]
}, Open  ]],

Cell["Choose the range to show all the existing points :", "ExampleText",
 CellID->647264009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->516135077],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->390297738]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3690],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28211]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18792],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "Tutorials",
 CellID->16193],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->16032984],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->102562205]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"All - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 3.5643512}", "context" -> "System`", 
    "keywords" -> {
     "part selector", "row selector", "column selector", 
      "plotrange selector"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "All is a setting used for certain options. In Part and related \
functions, All specifies all parts at a particular level. ", "synonyms" -> {},
     "title" -> "All", "type" -> "Symbol", "uri" -> "ref/All"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4640, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->181936191]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46845, 1008}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2395, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3018, 82, 41, 1, 70, "ObjectName",
 CellID->10393],
Cell[3062, 85, 753, 23, 70, "Usage",
 CellID->30548]
}, Open  ]],
Cell[CellGroupData[{
Cell[3852, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4330, 130, 273, 9, 70, "Notes",
 CellID->27273]
}, Closed]],
Cell[CellGroupData[{
Cell[4640, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->181936191],
Cell[CellGroupData[{
Cell[5025, 158, 147, 5, 70, "ExampleSection",
 CellID->69178442],
Cell[5175, 165, 41, 1, 70, "ExampleText",
 CellID->4542382],
Cell[5219, 168, 215, 8, 70, "ExampleText",
 CellID->516158244],
Cell[CellGroupData[{
Cell[5459, 180, 295, 11, 28, "Input",
 CellID->490106177],
Cell[5757, 193, 202, 7, 36, "Output",
 CellID->94405586]
}, Open  ]],
Cell[5974, 203, 207, 8, 70, "ExampleText",
 CellID->3503393],
Cell[CellGroupData[{
Cell[6206, 215, 314, 11, 70, "Input",
 CellID->532747884],
Cell[6523, 228, 250, 9, 36, "Output",
 CellID->42366591]
}, Open  ]],
Cell[6788, 240, 125, 3, 70, "ExampleDelimiter",
 CellID->324867829],
Cell[6916, 245, 79, 1, 70, "ExampleText",
 CellID->54891791],
Cell[CellGroupData[{
Cell[7020, 250, 425, 15, 28, "Input",
 CellID->332427845],
Cell[7448, 267, 18468, 307, 161, "Output",
 Evaluatable->False,
 CellID->135181353]
}, Open  ]],
Cell[25931, 577, 93, 1, 70, "ExampleText",
 CellID->647264009],
Cell[CellGroupData[{
Cell[26049, 582, 475, 16, 28, "Input",
 CellID->516135077],
Cell[26527, 600, 16487, 274, 161, "Output",
 Evaluatable->False,
 CellID->390297738]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43075, 881, 310, 9, 70, "SeeAlsoSection",
 CellID->3690],
Cell[43388, 892, 919, 35, 70, "SeeAlso",
 CellID->28211]
}, Open  ]],
Cell[CellGroupData[{
Cell[44344, 932, 314, 9, 70, "TutorialsSection",
 CellID->18792],
Cell[44661, 943, 196, 4, 70, "Tutorials",
 CellID->16193],
Cell[44860, 949, 138, 3, 70, "Tutorials",
 CellID->12933]
}, Open  ]],
Cell[CellGroupData[{
Cell[45035, 957, 299, 8, 70, "MoreAboutSection"],
Cell[45337, 967, 162, 3, 70, "MoreAbout",
 CellID->16032984],
Cell[45502, 972, 161, 3, 70, "MoreAbout",
 CellID->102562205]
}, Open  ]],
Cell[45678, 978, 50, 0, 70, "History"],
Cell[45731, 980, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

