(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    454750,      10285]
NotebookOptionsPosition[    434632,       9594]
NotebookOutlinePosition[    436347,       9637]
CellTagsIndexPosition[    436260,       9632]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListAnimate" :> 
          Documentation`HelpLookup["paclet:ref/ListAnimate"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"], "Play" :> 
          Documentation`HelpLookup["paclet:ref/Play"], "Animator" :> 
          Documentation`HelpLookup["paclet:ref/Animator"], "Dynamic" :> 
          Documentation`HelpLookup["paclet:ref/Dynamic"], "AutorunSequencing" :> 
          Documentation`HelpLookup["paclet:ref/AutorunSequencing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListAnimate\"\>", 
       2->"\<\"Manipulate\"\>", 3->"\<\"Play\"\>", 4->"\<\"Animator\"\>", 
       5->"\<\"Dynamic\"\>", 
       6->"\<\"AutorunSequencing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Presentations with Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:guide/PresentationsWithMathematica"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dynamic Visualization\"\>", 
       2->"\<\"Interactive Manipulation\"\>", 
       3->"\<\"Presentations with Mathematica \"\>", 
       4->"\<\"Stand-Alone Interfaces\"\>", 
       5->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       6->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Animate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Animate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Animate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates an animation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in which ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " varies continuously from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Animate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Animate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["du", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " to vary in steps ",
     Cell[BoxData[
      StyleBox["du", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Animate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Animate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]makes ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " take on discrete values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Animate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Animate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["v", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]varies all the variables ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", \[Ellipsis]. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be any expression; it does not need to be a graphic. "
}], "Notes",
 CellID->16292],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " only for the specific literal values of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " it requires. "
}], "Notes",
 CellID->17591],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Animate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animate"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["0", "TR"]]}], "}"}], ",", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " takes ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " to have initial value ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3832],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " is finite, ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is taken to vary at such a rate as to make the animation last for the time \
given by the setting for ",
 Cell[BoxData[
  ButtonBox["DefaultDuration",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultDuration"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27123],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Animate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animate"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]], ",", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " makes an infinite animation in which the value of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " increases forever at a rate of one unit per second. "
}], "Notes",
 CellID->6461],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Animate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animate"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"-", 
       ButtonBox["Infinity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Infinity"]}], ",", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " also allows ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " to decrease forever if the animation is run in reverse."
}], "Notes",
 CellID->16991],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " generates a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object containing an ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->27330],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationDirection",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationDirection"], 
    ButtonBox["Forward",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Forward"], Cell[
    "the direction of the animation ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRate"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the rate at which to take variables to vary ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRepetitions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRepetitions"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "how many times to run before stopping", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRunning",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRunning"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the animation is running", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AppearanceElements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AppearanceElements"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "control elements to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the animator", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DefaultDuration",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DefaultDuration"], "5.", Cell[
    "the default duration in seconds ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Deinitialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deinitialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "an expression to evaluate if the output from the ",
     Cell[BoxData[
      ButtonBox["Animate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
     " is deleted"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayAllSteps",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayAllSteps"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to force all discrete steps to be displayed ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    RowBox[{"{", "}"}], Cell["specific values to be excluded", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Initialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Initialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "an expression to evaluate when output is first generated", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LabelStyle"], 
    RowBox[{"{", "}"}], Cell[
    "style specifications for the label area", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RefreshRate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RefreshRate"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the default number of times per second to refresh ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ShrinkingDelay",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShrinkingDelay"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
how long to delay before shrinking if the displayed object gets smaller\
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->28498],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  StyleBox["du", "TI"]], "InlineFormula"],
 " is determined by the setting for the ",
 Cell[BoxData[
  ButtonBox["RefreshRate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RefreshRate"]], "InlineFormula"],
 " option, and is negative if ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " is larger than ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17369],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["du", "TI"]], "InlineFormula"],
 " is given as ",
 Cell[BoxData["0"], "InlineFormula"],
 ", it is taken to be the minimum positive or negative value determined by \
the setting for ",
 Cell[BoxData[
  ButtonBox["RefreshRate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RefreshRate"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17291],

Cell[TextData[{
 "If an explicit setting is specified for ",
 Cell[BoxData[
  ButtonBox["AnimationRate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AnimationRate"]], "InlineFormula"],
 ", it takes precedence over the setting for ",
 Cell[BoxData[
  ButtonBox["DefaultDuration",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultDuration"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8400],

Cell[TextData[{
 "The following elements are included by default: ",
 Cell[BoxData["\"\<ProgressSlider\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<PlayPauseButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<FasterSlowerButtons\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DirectionButton\>\""], "InlineFormula"],
 ". These elements can be specified in any order in a list given as the \
setting for ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14179],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " are appended to the default styles typically given by the ",
 Cell[BoxData["\"\<Animate\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<AnimateLabel\>\""], "InlineFormula"],
 " styles in the current stylesheet. "
}], "Notes",
 CellID->55815475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77531100],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->372420783],

Cell[TextData[{
 "Animate by continuously changing the value of ",
 Cell[BoxData["a"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->365412034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250043689],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 3.9570913314819336`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 5}}, Typeset`size$$ = {180., {51., 55.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$1478$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$1478$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`x + $CellContext`a$$], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`a$$, 0, 5, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {88., 93.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228822919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55387033],

Cell[TextData[{
 "Animate by varying ",
 Cell[BoxData["n"], "InlineFormula"],
 " in discrete steps:"
}], "ExampleText",
 CellID->3357298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"n", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "All"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "255", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->346730662],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 0, 255, 1}}, Typeset`size$$ = {
    180., {45., 50.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$28334$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$28334$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ArrayPlot[
        CellularAutomaton[$CellContext`n$$, {{1}, 0}, {40, All}]], 
      "Specifications" :> {{$CellContext`n$$, 0, 255, 1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {82., 87.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1367374240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59764530],

Cell[TextData[{
 "Animate by continuously changing two parameters ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->46989047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"b", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->801178321],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 4.015668106079102, $CellContext`b$$ = 
    4.015668106079102, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 1, 5}, {
      Hold[$CellContext`b$$], 1, 5}}, Typeset`size$$ = {180., {55., 60.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$130707$$ = 0, $CellContext`b$130708$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$130707$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$130708$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`a$$ $CellContext`x] + 
        Sin[$CellContext`b$$ $CellContext`x], {$CellContext`x, 0, 10}, 
        PlotRange -> 2], 
      "Specifications" :> {{$CellContext`a$$, 1, 5, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}, {$CellContext`b$$, 1, 5, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {106., 111.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->756068560]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->109198024],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Animate Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65322756],

Cell["Animate a plot:", "ExampleText",
 CellID->1349705158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1266056862],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 5}}, Typeset`size$$ = {180., {51., 55.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$48731$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$48731$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`x + $CellContext`a$$], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`a$$, 0, 5, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {88., 93.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1663140108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288418841],

Cell["Animate any expression, not just a graphic:", "ExampleText",
 CellID->494462885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"FactorInteger", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "2000", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387653174],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
    53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$1661$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1661$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> FactorInteger[$CellContext`n$$], 
      "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {42., 47.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2025038493]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Subsuperscript", "[", 
       RowBox[{"#", ",", "#", ",", "#"}], "]"}], "&"}], ",", "x", ",", "n"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "5", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->354677824],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 4, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 5, 1}}, Typeset`size$$ = {
    89.5, {40.5, 48.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$2611$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$2611$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Nest[Subsuperscript[#, #, #]& , $CellContext`x, $CellContext`n$$], 
      "Specifications" :> {{$CellContext`n$$, 1, 5, 1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {81., 86.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74010893]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Animate Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->103229521],

Cell["Specify a range for animation:", "ExampleText",
 CellID->383340055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345363385],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 5}}, Typeset`size$$ = {180., {51., 55.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$48810$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$48810$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`x + $CellContext`a$$], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`a$$, 0, 5, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {88., 93.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2021597501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3175417],

Cell[TextData[{
 "Specify the animator controls using ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->336955567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{
     RowBox[{"FactorInteger", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "2000", ",", "1", ",", 
       RowBox[{"AppearanceElements", "\[Rule]", "a"}]}], "}"}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ProgressSlider\>\"", ",", "\"\<StepLeftButton\>\"", ",", 
       "\"\<StepRightButton\>\"", ",", "\"\<PlayPauseButton\>\"", ",", 
       "\"\<FasterSlowerButtons\>\"", ",", "\"\<DirectionButton\>\"", ",", 
       "\"\<ResetButton\>\"", ",", "\"\<PlayButton\>\"", ",", 
       "\"\<ResetPlayButton\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297837430],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1682$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1682$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "ProgressSlider"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{239., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1701$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1701$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "StepLeftButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{100., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1718$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1718$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "StepRightButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{100., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1735$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1735$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "PlayPauseButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{100., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1752$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1752$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "FasterSlowerButtons"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{100., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1769$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1769$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "DirectionButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{100., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1786$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1786$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "ResetButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{100., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1803$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1803$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "PlayButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{100., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`n$$], 1, 2000, 1}}, Typeset`size$$ = {
      53.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`n$1820$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {
          Hold[$CellContext`n$$, $CellContext`n$1820$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        FactorInteger[$CellContext`n$$], 
        "Specifications" :> {{$CellContext`n$$, 1, 2000, 1, AnimationRunning -> 
           False, AppearanceElements -> "ResetPlayButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{100., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{452, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1501114195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43424101],

Cell["Specify animation steps: ", "ExampleText",
 CellID->1650420120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "5", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1712172188],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 4, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 5, 1}}, Typeset`size$$ = {180., {53., 57.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$2930$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$2930$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        BesselJ[$CellContext`n$$, $CellContext`x], {$CellContext`x, 0, 20}, 
        PlotRange -> 1], 
      "Specifications" :> {{$CellContext`n$$, 1, 5, 1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {90., 95.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30119425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->409072142],

Cell["\<\
Specify an infinite animation, where the animation variable increases at unit \
speed: \
\>", "ExampleText",
 CellID->90550459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35696393],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 25.975976943969727`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 
      DirectedInfinity[1]}}, Typeset`size$$ = {180., {58., 63.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$3561$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$3561$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`x + $CellContext`a$$], {$CellContext`x, 0, 10}, 
        PlotLabel -> $CellContext`a$$], 
      "Specifications" :> {{$CellContext`a$$, 0, 
         DirectedInfinity[1], 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {92., 97.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75542499]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24158891],

Cell["Animate, using a discrete set of values: ", "ExampleText",
 CellID->296494773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Pi]", ",", 
       RowBox[{"2", "\[Pi]"}], ",", 
       RowBox[{"3", "\[Pi]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1392089528],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 3.141592653589793, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], {0, Pi, 2 Pi, 3 Pi}}}, Typeset`size$$ = {
    180., {51., 55.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`a$4179$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$4179$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`x + $CellContext`a$$], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`a$$, {0, Pi, 2 Pi, 3 Pi}, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {88., 93.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449769357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304192826],

Cell["Animate several variables at once:", "ExampleText",
 CellID->612038119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", "+", "a"}], "]"}], 
      RowBox[{"Sin", "[", 
       RowBox[{"y", "+", "b"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64160304],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.6289848536226965, $CellContext`b$$ =
     0.6289848536226965, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, Pi}, {
      Hold[$CellContext`b$$], 0, Pi}}, Typeset`size$$ = {180., {69., 74.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$6183$$ = 0, $CellContext`b$6184$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0, $CellContext`b$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$6183$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$6184$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot3D[Sin[$CellContext`x + $CellContext`a$$] 
        Sin[$CellContext`y + $CellContext`b$$], {$CellContext`x, 0, 2 
         Pi}, {$CellContext`y, 0, 2 Pi}, PlotRange -> 1], 
      "Specifications" :> {{$CellContext`a$$, 0, Pi, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}, {$CellContext`b$$, 0, Pi, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {120., 125.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 247},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50837115]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->193836991],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->33155791],

Cell["Use preset values:", "ExampleText",
 CellID->1894547371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", 
        RowBox[{"{", 
         RowBox[{"u", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
     RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1069319294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {30., {8., 12.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$22809$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$22809$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics[
          Disk[{$CellContext`u$$, 0}], PlotRange -> {{-1, 2}, {-1, 1}}, 
          ImageSize -> 30], 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         Alignment -> Left, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {45., 50.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {30., {8., 12.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$22830$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$22830$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics[
          Disk[{$CellContext`u$$, 0}], PlotRange -> {{-1, 2}, {-1, 1}}, 
          ImageSize -> 30], 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         Alignment -> Center, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {45., 50.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {30., {8., 12.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$22847$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$22847$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics[
          Disk[{$CellContext`u$$, 0}], PlotRange -> {{-1, 2}, {-1, 1}}, 
          ImageSize -> 30], 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         Alignment -> Right, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {45., 50.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201425501]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationDirection",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->40604843],

Cell["Control the direction of animation:", "ExampleText",
 CellID->1108710775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AnimationDirection", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Forward", ",", "Backward", ",", "ForwardBackward"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55466627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.8317487716674805, Typeset`show$$ =
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$23410$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$23410$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationDirection -> 
           Forward, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.16135082244873045`, 
      Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
      Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ =
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$23427$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$23427$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationDirection -> 
           Backward, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.16135082244873056`, 
      Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
      Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ =
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$23444$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$23444$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationDirection -> 
           ForwardBackward, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1883706341]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRate",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->578273666],

Cell["Control the rate of animation:", "ExampleText",
 CellID->1999728756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AnimationRate", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "0.5", ",", "1", ",", "1.5"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1472862678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.005048179626464843, 
      Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
      Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ =
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {70., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$91473$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$91473$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRate -> 
           Automatic, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.5126204490661621, Typeset`show$$ =
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {49., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$91490$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$91490$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRate -> 0.5, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.02524089813232422, 
      Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
      Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ =
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {63., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$91507$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$91507$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRate -> 1, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.5378613471993958, Typeset`show$$ =
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$91524$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$91524$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRate -> 1.5, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 379},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78323923]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRepetitions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->105287832],

Cell["Control the number of animation cycles:", "ExampleText",
 CellID->1949472372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AnimationRepetitions", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2104647758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.245, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {35., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$66215$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$66215$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRepetitions -> 
           1, AnimationRunning -> False, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.535, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {35., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$66232$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$66232$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRepetitions -> 
           2, AnimationRunning -> False, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.14, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {28., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$66249$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$66249$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRepetitions -> 
           3, AnimationRunning -> False, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1229102618]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRunning",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->35013813],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " starts running when evaluated: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1205777555],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.039095497131347655`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {63., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$23841$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$23841$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {42., 47.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1248549113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138241497],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AnimationRunning",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AnimationRunning"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " starts in a paused state: "
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1286170056],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$66141$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$66141$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> False,
          AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {42., 47.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123824802]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimatorElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30315736],

Cell["Specify the elements of the animator:", "ExampleText",
 CellID->937862426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
     RowBox[{"AnimatorElements", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ProgressSlider\>\"", ",", "\"\<StepLeftButton\>\"", ",", 
       "\"\<StepRightButton\>\"", ",", "\"\<PlayPauseButton\>\"", ",", 
       "\"\<FasterSlowerButtons\>\"", ",", "\"\<DirectionButton\>\"", ",", 
       "\"\<ResetButton\>\"", ",", "\"\<PlayButton\>\"", ",", 
       "\"\<ResetPlayButton\>\"", ",", "All"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1651027390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24264$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24264$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "ProgressSlider"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{239., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24283$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24283$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "StepLeftButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{61., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24300$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24300$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "StepRightButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{61., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24317$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24317$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "PlayPauseButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{61., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24334$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24334$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "FasterSlowerButtons"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{75., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24351$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24351$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "DirectionButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{59., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24368$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24368$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "ResetButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{61., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24385$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24385$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "PlayButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{68., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24402$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24402$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "ResetPlayButton"}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{68., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24419$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24419$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> All}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{451., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{469, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1302227354]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AppearanceElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->74343014],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " only contains an ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->701940153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1380478500],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$24687$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$24687$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {42., 47.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1529292101]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158675264],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 " to get additional controls:"
}], "ExampleText",
 CellID->1666052553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
     RowBox[{"AppearanceElements", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<HideControlsButton\>\"", ",", "\"\<SnapshotButton\>\"", ",", 
       "\"\<ResetButton\>\"", ",", "\"\<UpdateButton\>\"", ",", "All"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2044469172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24818$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24818$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         AppearanceElements -> "HideControlsButton", ControlType -> Animator, 
          AppearanceElements -> "HideControlsButton", SynchronousUpdating -> 
          True, ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{329., {49., 54.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24837$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24837$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         AppearanceElements -> "SnapshotButton", ControlType -> Animator, 
          AppearanceElements -> "SnapshotButton", SynchronousUpdating -> True,
           ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{329., {49., 54.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24854$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24854$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         AppearanceElements -> "ResetButton", ControlType -> Animator, 
          AppearanceElements -> "ResetButton", SynchronousUpdating -> True, 
          ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{329., {49., 54.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24871$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24871$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         AppearanceElements -> "UpdateButton", ControlType -> Animator, 
          AppearanceElements -> "UpdateButton", SynchronousUpdating -> True, 
          ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{329., {48., 53.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24888$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24888$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         AppearanceElements -> All, ControlType -> Animator, 
          AppearanceElements -> All, SynchronousUpdating -> True, 
          ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{329., {50., 55.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 553},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1728054211]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->40901516],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->201584103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Animate", "[", 
      RowBox[{"u", ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"AnimatorElements", "\[Rule]", "\"\<PlayPauseButton\>\""}], 
       ",", 
       RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1319776749],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$92360$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$92360$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "PlayPauseButton"}}, 
        "Options" :> {
         BaselinePosition -> Top, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{61., {89., 0.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], "xxx", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$92377$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$92377$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "PlayPauseButton"}}, 
        "Options" :> {
         BaselinePosition -> Center, ControlType -> Animator, 
          AppearanceElements -> None, SynchronousUpdating -> True, 
          ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{61., {44.5, 44.5}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], "xxx", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$92394$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$92394$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> "PlayPauseButton"}}, 
        "Options" :> {
         BaselinePosition -> Bottom, ControlType -> Animator, 
          AppearanceElements -> None, SynchronousUpdating -> True, 
          ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{61., {0., 89.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}],
  Row[{
    Manipulate[$CellContext`u, {$CellContext`u, 0, 1, AnimationRunning -> 
      False, AppearanceElements -> "PlayPauseButton"}, BaselinePosition -> 
     Top, ControlType -> Animator, AppearanceElements -> None, 
     SynchronousUpdating -> True, ShrinkingDelay -> 10.], 
    Manipulate[$CellContext`u, {$CellContext`u, 0, 1, AnimationRunning -> 
      False, AppearanceElements -> "PlayPauseButton"}, BaselinePosition -> 
     Center, ControlType -> Animator, AppearanceElements -> None, 
     SynchronousUpdating -> True, ShrinkingDelay -> 10.], 
    Manipulate[$CellContext`u, {$CellContext`u, 0, 1, AnimationRunning -> 
      False, AppearanceElements -> "PlayPauseButton"}, BaselinePosition -> 
     Bottom, ControlType -> Animator, AppearanceElements -> None, 
     SynchronousUpdating -> True, ShrinkingDelay -> 10.]}, "xxx"]]], "Output",\

 ImageSize->{241, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287780608]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControlPlacement",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4907458],

Cell["Specify the location of the controls:", "ExampleText",
 CellID->1528815672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "p"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Right", ",", "Bottom", ",", "Top"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369874048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25220$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25220$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlPlacement -> Left, ControlType -> Animator, 
          AppearanceElements -> None, SynchronousUpdating -> True, 
          ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{359., {26., 31.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25239$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25239$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlPlacement -> Right, ControlType -> Animator, 
          AppearanceElements -> None, SynchronousUpdating -> True, 
          ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{359., {26., 31.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25256$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25256$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlPlacement -> Bottom, ControlType -> Animator, 
          AppearanceElements -> None, SynchronousUpdating -> True, 
          ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25273$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25273$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlPlacement -> Top, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{377, 312},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->838282249]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DefaultDuration",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->151174201],

Cell["Control the time duration of one animation cycle: ", "ExampleText",
 CellID->1049336160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"DefaultDuration", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1057131956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 9.965896606445312, Typeset`show$$ = 
      True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 10}}, Typeset`size$$ = {42., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$92659$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$92659$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 10, DefaultDuration -> 1, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 2.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 9.982948303222656, Typeset`show$$ = 
      True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 10}}, Typeset`size$$ = {49., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$92676$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$92676$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 10, DefaultDuration -> 2, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 4.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 6.655298868815104, Typeset`show$$ = 
      True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 10}}, Typeset`size$$ = {42., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$92693$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$92693$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 10, DefaultDuration -> 3, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 6.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122804258]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Deployed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->104284388],

Cell["By default the contents can be selected and edited:", "ExampleText",
 CellID->1185264306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180107366],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.065, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {50., {23., 27.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$25392$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$25392$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Disk[], ImageSize -> 50], 
      "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {60., 65.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellAutoOverwrite->False,
 ImageSize->{333, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1517034623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103183483],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Deployed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deployed"]], "InlineFormula"],
 " to restrict the interactivity of the contents:"
}], "ExampleText",
 CellID->378569079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
   RowBox[{"Deployed", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->898456130],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.20312232971191407`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {50., {23., 27.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$25546$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$25546$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Disk[], ImageSize -> 50], 
      "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       Deployed -> True, ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {60., 65.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1875051577]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DisplayAllSteps",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21024239],

Cell["With the default setting some steps may be skipped: ", "ExampleText",
 CellID->963976181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], ",", 
         RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], 
          RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], "]"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"20", " ", "Pi"}], ",", ".1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1768282953],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 10.4, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 20 Pi, 0.1}}, Typeset`size$$ = {
    100., {48., 52.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$597$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$597$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Point[{
           Sin[$CellContext`x$$], Cos[$CellContext`x$$] 
           Sin[$CellContext`x$$]}]}, PlotRange -> 1, ImageSize -> Tiny], 
      "Specifications" :> {{$CellContext`x$$, 0, 20 Pi, 0.1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {85., 90.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->648874556]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DisplayAllSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayAllSteps"]], "InlineFormula"],
 " to prevent skipping: "
}], "ExampleText",
 CellID->931041099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], ",", 
         RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], 
          RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], "]"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"20", " ", "Pi"}], ",", ".1"}], "}"}], ",", 
   RowBox[{"DisplayAllSteps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->505400238],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 20 Pi, 0.1}}, Typeset`size$$ = {
    100., {48., 52.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$617$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$617$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Point[{
           Sin[$CellContext`x$$], Cos[$CellContext`x$$] 
           Sin[$CellContext`x$$]}]}, PlotRange -> 1, ImageSize -> Tiny], 
      "Specifications" :> {{$CellContext`x$$, 0, 20 Pi, 0.1, DisplayAllSteps -> 
         True, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {85., 90.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->511596560]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->206794484],

Cell["Exclude values from the range:", "ExampleText",
 CellID->175289357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1", ",", "0.2"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.8"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394705405],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1, 0.2}}, Typeset`size$$ = {21., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$1092$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$1092$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, 0.2, 
         Exclusions -> {0.4, 0.8}, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {42., 47.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101513562]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->49516647],

Cell["Use preset values:", "ExampleText",
 CellID->1824339175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{
     RowBox[{"Framed", "@", "u"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2135511060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17., {5., 13.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25875$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25875$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         FrameMargins -> Tiny, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {36., 41.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17., {5., 13.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25894$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25894$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         FrameMargins -> Small, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {37., 42.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17., {5., 13.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25911$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25911$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         FrameMargins -> Medium, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {40., 45.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17., {5., 13.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25928$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25928$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
           False, AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         FrameMargins -> Large, ControlType -> Animator, AppearanceElements -> 
          None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {45., 50.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1816818561]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->745796639],

Cell["Or use any values:", "ExampleText",
 CellID->27069804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Framed", "@", "u"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2044486006],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17., {5., 13.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$25955$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$25955$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Framed[$CellContext`u$$], 
      "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       FrameMargins -> 20, ControlType -> Animator, AppearanceElements -> 
        None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {55., 60.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199578034]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->614347287],

Cell["Use preset values:", "ExampleText",
 CellID->1091260091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Animate", "[", 
     RowBox[{"u", ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "f"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1931303231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`u$73330$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`u$$, $CellContext`u$73330$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`u$$, 
         "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
            False, AppearanceElements -> {
             "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
              "DirectionButton"}}}, 
         "Options" :> {
          ImageMargins -> Tiny, ControlType -> Animator, AppearanceElements -> 
           None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
         "DefaultOptions" :> {}],
        ImageSizeCache->{331., {43., 48.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`u$73347$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`u$$, $CellContext`u$73347$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`u$$, 
         "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
            False, AppearanceElements -> {
             "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
              "DirectionButton"}}}, 
         "Options" :> {
          ImageMargins -> Small, ControlType -> Animator, AppearanceElements -> 
           None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
         "DefaultOptions" :> {}],
        ImageSizeCache->{333., {44., 49.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`u$73364$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`u$$, $CellContext`u$73364$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`u$$, 
         "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
            False, AppearanceElements -> {
             "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
              "DirectionButton"}}}, 
         "Options" :> {
          ImageMargins -> Medium, ControlType -> Animator, AppearanceElements -> 
           None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
         "DefaultOptions" :> {}],
        ImageSizeCache->{339., {47., 52.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`u$73381$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`u$$, $CellContext`u$73381$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`u$$, 
         "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
            False, AppearanceElements -> {
             "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
              "DirectionButton"}}}, 
         "Options" :> {
          ImageMargins -> Large, ControlType -> Animator, AppearanceElements -> 
           None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
         "DefaultOptions" :> {}],
        ImageSizeCache->{349., {52., 57.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{377, 462},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->714955808]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177393569],

Cell["Or use any values:", "ExampleText",
 CellID->1415299773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Animate", "[", 
   RowBox[{"u", ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "20"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1414410639],

Cell[BoxData[
 FrameBox[
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`u$73561$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
       "ControllerVariables" :> {
         Hold[$CellContext`u$$, $CellContext`u$73561$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, 
       "Body" :> $CellContext`u$$, 
       "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> 
          False, AppearanceElements -> {
           "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
            "DirectionButton"}}}, 
       "Options" :> {
        ImageMargins -> 20, ControlType -> Animator, AppearanceElements -> 
         None, SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{369., {62., 67.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]],
  StripOnInput->False]], "Output",
 ImageSize->{383, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2105011549]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RefreshRate",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->361543898],

Cell["Control the refresh rate of the animation:", "ExampleText",
 CellID->184274304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"RefreshRate", "\[Rule]", "r"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->772271996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.2974538803100586, Typeset`show$$ =
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$1618$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$1618$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, RefreshRate -> 1, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0.2974538803100586, Typeset`show$$ =
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$1637$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$1637$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, RefreshRate -> 2, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{329., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{347, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7972562]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TrackedSymbols",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->688785845],

Cell["Specify symbols that will trigger the animation update:", "ExampleText",
 CellID->464772379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1", ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"TrackedSymbols", "->", 
    RowBox[{"{", "u", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2105120423],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.22, $CellContext`v$$ = 
    1.3094706535339355`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}, {
      Hold[$CellContext`v$$], 1, 2}}, Typeset`size$$ = {102.1875, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$1690$$ = 0, $CellContext`v$1691$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`u$$ = 0, $CellContext`v$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$1690$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$1691$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`u$$, $CellContext`v$$}, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}, {$CellContext`v$$, 1, 2, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       TrackedSymbols -> {$CellContext`u$$}, ControlType -> Animator, 
        AppearanceElements -> None, SynchronousUpdating -> True, 
        ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
     ImageSizeCache->{329., {56., 61.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17710956]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5230],

Cell["Animate a rolling circle:", "ExampleText",
 CellID->784468477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Translate", "[", 
      RowBox[{
       RowBox[{"Rotate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Circle", "[", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
         RowBox[{"-", "t"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", " ", ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Large", ",", "Tiny"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1159584006],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2 Pi}}, Typeset`size$$ = {300., {48., 52.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$3038$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$3038$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Translate[
         Rotate[{
           Circle[], 
           Point[{0, 1}]}, -$CellContext`t$$], {$CellContext`t$$, 0}], 
        PlotRange -> {{-2, 10}, {-2, 2}}, ImageSize -> {Large, Tiny}], 
      "Specifications" :> {{$CellContext`t$$, 0, 2 Pi, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{346., {85., 90.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{350, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135129751]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->451788016],

Cell[TextData[{
 "Animate the Taylor series of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->597058562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20", ",", "2"}], "}"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1368847924],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20, 2}}, Typeset`size$$ = {
    53.125, {2., 11.375}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$24654$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$24654$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Series[
        Sin[$CellContext`x], {$CellContext`x, 0, $CellContext`n$$}], 
      "Specifications" :> {{$CellContext`n$$, 1, 20, 2, AnimationDirection -> 
         ForwardBackward, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {42., 47.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83381173]
}, Open  ]],

Cell["Animate the series: ", "ExampleText",
 CellID->1395912380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"Normal", "[", 
         RowBox[{"Series", "[", 
          RowBox[{
           RowBox[{"Sin", "[", "x", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}], "]"}]}], "}"}],
       "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20", ",", "2"}], "}"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16095098],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20, 2}}, Typeset`size$$ = {180., {58., 62.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$34927$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$34927$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Evaluate[{
          Sin[$CellContext`x], 
          Normal[
           Series[
            
            Sin[$CellContext`x], {$CellContext`x, 
             0, $CellContext`n$$}]]}], {$CellContext`x, -10, 10}, PlotRange -> 
        3], "Specifications" :> {{$CellContext`n$$, 1, 20, 2, 
         AnimationDirection -> ForwardBackward, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {95., 100.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278409500]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->573532180],

Cell["Scan through a large space of cellular automata:", "ExampleText",
 CellID->189809102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "All"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "Infinity", ",", "2"}], "}"}], ",", 
   RowBox[{"AnimationRate", "\[Rule]", "4"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17157],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 58, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`i$$], 0, 
      DirectedInfinity[1], 2}}, Typeset`size$$ = {180., {24., 28.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$62877$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`i$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`i$$, $CellContext`i$62877$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ArrayPlot[
        CellularAutomaton[{$CellContext`i$$, 2, 2}, {{1}, 0}, {40, All}]], 
      "Specifications" :> {{$CellContext`i$$, 0, 
         DirectedInfinity[1], 2, AnimationRate -> 4, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{325., {58., 63.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{329, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208938944]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7387147],

Cell["Animate nonlinear slider motion:", "ExampleText",
 CellID->557320662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"u", "^", "2"}], "]"}], ",", 
     RowBox[{"Slider", "[", 
      RowBox[{"1", "-", 
       RowBox[{"Sqrt", "[", "u", "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {425.1875, {9., 14.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$5531$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$5531$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> {
        Slider[$CellContext`u$$^2], 
        Slider[1 - Sqrt[$CellContext`u$$]]}, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{472., {47., 52.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{476, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1337890625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->782913667],

Cell["Display the superposition of two waves:", "ExampleText",
 CellID->1475590712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"f1", " ", "x"}], "+", "t"}], "]"}], ",", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"f2", " ", "x"}], "-", "t"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[Pi]"}], ",", 
          RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1.1"}]}], "]"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"f2", " ", "x"}], "-", "t"}], "]"}], "+", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"f1", " ", "x"}], "+", "t"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[Pi]"}], ",", 
          RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f1", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f2", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1111941028],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`f1$$ = 1., $CellContext`f2$$ = 
    1., $CellContext`t$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`f1$$], 1, 10}, {
      Hold[$CellContext`f2$$], 1, 10}, {
      Hold[$CellContext`t$$], 0, 2 Pi}}, Typeset`size$$ = {
    180., {118.5, 123.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`f1$63744$$ = 
    0, $CellContext`f2$63745$$ = 0, $CellContext`t$63746$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`f1$$ = 1, $CellContext`f2$$ = 
        1, $CellContext`t$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`f1$$, $CellContext`f1$63744$$, 0], 
        Hold[$CellContext`f2$$, $CellContext`f2$63745$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$63746$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Plot[{
           Sin[$CellContext`f1$$ $CellContext`x + $CellContext`t$$], 
           
           Sin[$CellContext`f2$$ $CellContext`x - $CellContext`t$$]}, \
{$CellContext`x, (-2) Pi, 2 Pi}, PlotRange -> 1.1], 
         Plot[
         Sin[$CellContext`f2$$ $CellContext`x - $CellContext`t$$] + 
          Sin[$CellContext`f1$$ $CellContext`x + $CellContext`t$$], \
{$CellContext`x, (-2) Pi, 2 Pi}, PlotRange -> 2]}], 
      "Specifications" :> {{$CellContext`f1$$, 1, 10, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}, {$CellContext`f2$$, 1, 10, AnimationRunning -> 
         False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}, {$CellContext`t$$, 0, 2 Pi, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{331., {184., 189.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{335, 375},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560945142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17861407],

Cell[TextData[{
 "Animate a complex map ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", "s"], TraditionalForm]], "InlineMath"],
 " of the plane ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "\[LessEqual]", 
     RowBox[{"Re", "(", "z", ")"}], "\[LessEqual]", "2"}], "\[And]", 
    RowBox[{
     RowBox[{"-", "2"}], "\[LessEqual]", 
     RowBox[{"Im", "(", "z", ")"}], "\[LessEqual]", "2"}]}], 
   TraditionalForm]], "InlineMath"],
 " for different values of ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->869645839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Re", ",", "Im"}], "}"}], "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], ")"}], "^", "s"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      SuperscriptBox["z", "s"]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->363914591],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = 0.36601619720458983`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`s$$], 0, 1}}, Typeset`size$$ = {180., {97., 102.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`s$52634$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`s$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$52634$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ParametricPlot[
        Through[
         {
         Re, Im}[($CellContext`x + 
           I $CellContext`y)^$CellContext`s$$]], {$CellContext`x, -2, 
         2}, {$CellContext`y, -2, 2}, PerformanceGoal -> "Quality", 
        PlotLabel -> $CellContext`z^$CellContext`s$$, 
        PlotRange -> {{-2, 2}, {-2, 2}}], 
      "Specifications" :> {{$CellContext`s$$, 0, 1, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{327., {134., 139.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{331, 275},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18513465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->543100099],

Cell["Display a sphere-torus morphing:", "ExampleText",
 CellID->1314874640],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sphere", "[", 
    RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Theta]", "]"}], 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Phi]", "/", "2"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Phi]", "/", "2"}], "]"}]}], ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Phi]", "/", "2"}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1491346850],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"torus", "[", 
    RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "/", "3"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ")"}], " ", 
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "3"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ")"}], 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], "/", "3"}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1913582366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Lambda]"}], ")"}], 
       RowBox[{"sphere", "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
      RowBox[{"\[Lambda]", " ", 
       RowBox[{"torus", "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->558738150],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Lambda]$$ = 0.5092414855957031, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Lambda]$$], 0, 1}}, Typeset`size$$ = {
    180., {101., 106.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`\[Lambda]$52085$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Lambda]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Lambda]$$, $CellContext`\[Lambda]$52085$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot3D[(
          1 - $CellContext`\[Lambda]$$) $CellContext`sphere[$CellContext`\
\[Theta], $CellContext`\[Phi]] + $CellContext`\[Lambda]$$ \
$CellContext`torus[$CellContext`\[Theta], $CellContext`\[Phi]], \
{$CellContext`\[Theta], 0, 2 Pi}, {$CellContext`\[Phi], 0, 2 Pi}, PlotRange -> 
        1, Mesh -> True], 
      "Specifications" :> {{$CellContext`\[Lambda]$$, 0, 1, 
         AnimationDirection -> ForwardBackward, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {138., 143.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`sphere[
         Pattern[$CellContext`\[Theta], 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]]] := {
        Cos[$CellContext`\[Theta]] Sin[$CellContext`\[Phi]/2], 
         Sin[$CellContext`\[Theta]] Sin[$CellContext`\[Phi]/2], 
         Cos[$CellContext`\[Phi]/2]}, $CellContext`torus[
         Pattern[$CellContext`\[Theta], 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]]] := {(-Sin[$CellContext`\[Phi]])/
         3, (2 - Cos[$CellContext`\[Phi]]) (Sin[$CellContext`\[Theta]]/3), (2 - 
          Cos[$CellContext`\[Phi]]) (Cos[$CellContext`\[Theta]]/3)}}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->719549545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89632045],

Cell[TextData[{
 "Animate the roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "n"], "\[PlusMinus]", 
        SuperscriptBox["x", 
         RowBox[{"n", "-", "1"}]]}], "\[PlusMinus]"}], "..."}], 
     "\[PlusMinus]", "x"}], "+", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1579904422],

Cell[BoxData[
 RowBox[{
  RowBox[{"roots", "[", 
   RowBox[{"n_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", ",", "x", ",", "l"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"r", "=", 
      RowBox[{"Flatten", "@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"x", "/.", 
          RowBox[{"NSolve", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "^", "n"}], "+", 
              RowBox[{"l", ".", 
               RowBox[{"x", "^", 
                RowBox[{"Range", "[", 
                 RowBox[{"1", ",", 
                  RowBox[{"n", "-", "1"}]}], "]"}]}]}], "+", "c"}], 
             "\[Equal]", "0"}], ",", "x"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"l", ",", 
           RowBox[{"Tuples", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
             RowBox[{"n", "-", "1"}]}], "]"}]}], "}"}]}], "]"}]}]}], ";", " ",
      
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", "r", "]"}], ",", 
        RowBox[{"Im", "[", "r", "]"}]}], "}"}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157319175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Point", "[", 
      RowBox[{"roots", "[", 
       RowBox[{"n", ",", 
        RowBox[{"a", "+", 
         RowBox[{"\[ImaginaryI]", " ", "b"}]}]}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "7", ",", "\"\<degree n\>\""}], "}"}], ",", "2", ",", 
     "8", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "1", ",", "\"\<real constant a\>\""}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "\"\<imaginary constant b\>\""}], "}"}], 
     ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->89191103],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 
    1.3200000000000003`, $CellContext`b$$ = 1.92, $CellContext`n$$ = 8, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 7, "degree n"}, 2, 8, 1}, {{
       Hold[$CellContext`a$$], 1, "real constant a"}, -3, 3}, {{
       Hold[$CellContext`b$$], 0, "imaginary constant b"}, -3, 3}}, 
    Typeset`size$$ = {180., {90., 94.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`n$51742$$ = 0, $CellContext`a$51743$$ = 
    0, $CellContext`b$51744$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 
        0, $CellContext`n$$ = 7}, "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$51742$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$51743$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$51744$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Point[
         $CellContext`roots[$CellContext`n$$, $CellContext`a$$ + 
          I $CellContext`b$$]], PlotRange -> 2, Frame -> True], 
      "Specifications" :> {{{$CellContext`n$$, 7, "degree n"}, 2, 8, 1, 
         AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}, {{$CellContext`a$$, 1, "real constant a"}, -3,
          3, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}, {{$CellContext`b$$, 0, 
          "imaginary constant b"}, -3, 3, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{417., {154., 159.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`roots[
         Pattern[$CellContext`n, 
          Blank[]], 
         Pattern[$CellContext`c, 
          Blank[]]] := 
       Module[{$CellContext`r, $CellContext`x, $CellContext`l}, \
$CellContext`r = Flatten[
            Table[
             ReplaceAll[$CellContext`x, 
              
              NSolve[$CellContext`x^$CellContext`n + 
                Dot[$CellContext`l, $CellContext`x^
                  Range[1, $CellContext`n - 1]] + $CellContext`c == 
               0, $CellContext`x]], {$CellContext`l, 
              Tuples[{-1, 1}, $CellContext`n - 1]}]]; Transpose[{
            Re[$CellContext`r], 
            Im[$CellContext`r]}]]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{421, 315},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161267894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191760438],

Cell["Animate point light positions: ", "ExampleText",
 CellID->282485861],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p1", "[", "\[Theta]_", "]"}], ":=", 
   RowBox[{
    RowBox[{"RotationTransform", "[", 
     RowBox[{"\[Theta]", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2", "[", "\[Theta]_", "]"}], ":=", 
   RowBox[{
    RowBox[{"RotationTransform", "[", 
     RowBox[{
      RowBox[{"\[Theta]", "+", 
       RowBox[{"Pi", "/", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p3", "[", "\[Theta]_", "]"}], ":=", 
   RowBox[{
    RowBox[{"RotationTransform", "[", 
     RowBox[{
      RowBox[{"\[Theta]", "+", "Pi"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p4", "[", "\[Theta]_", "]"}], ":=", 
   RowBox[{
    RowBox[{"RotationTransform", "[", 
     RowBox[{
      RowBox[{"\[Theta]", "+", 
       RowBox[{"3", 
        RowBox[{"Pi", "/", "2"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->686768770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
          RowBox[{"p1", "[", "\[Theta]", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<Point\>\"", ",", "Green", ",", 
          RowBox[{"p2", "[", "\[Theta]", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<Point\>\"", ",", "Blue", ",", 
          RowBox[{"p3", "[", "\[Theta]", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<Point\>\"", ",", "Yellow", ",", 
          RowBox[{"p4", "[", "\[Theta]", "]"}]}], "}"}]}], "}"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9649783],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Theta]$$], 0, 2 Pi}}, Typeset`size$$ = {
    180., {95., 100.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`\[Theta]$66562$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$66562$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[
        Sphere[], Lighting -> {{"Point", Red, 
           $CellContext`p1[$CellContext`\[Theta]$$]}, {"Point", Green, 
           $CellContext`p2[$CellContext`\[Theta]$$]}, {"Point", Blue, 
           $CellContext`p3[$CellContext`\[Theta]$$]}, {"Point", Yellow, 
           $CellContext`p4[$CellContext`\[Theta]$$]}}], 
      "Specifications" :> {{$CellContext`\[Theta]$$, 0, 2 Pi, 
         AnimationDirection -> ForwardBackward, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {132., 137.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`p1[
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := 
       RotationTransform[$CellContext`\[Theta], {0, 0, 1}][{0, 2, 
         0}], $CellContext`p2[
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := 
       RotationTransform[$CellContext`\[Theta] + Pi/2, {1, 0, 1}][{0, 2, 
         0}], $CellContext`p3[
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := 
       RotationTransform[$CellContext`\[Theta] + Pi, {1, 0, 0}][{0, 2, 
         0}], $CellContext`p4[
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := 
       RotationTransform[$CellContext`\[Theta] + 3 (Pi/2), {1, 0, -1}][{0, 2, 
         0}]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->335329795]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->87647649],

Cell[TextData[{
 "Animated behavior can also be built using ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 " as a building block: "
}], "ExampleText",
 CellID->772513449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "=", "0"}], ",", 
     RowBox[{"xlis", "=", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "}"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Animator", "[", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "=", "#"}], ";", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"xlis", ",", 
             RowBox[{"{", 
              RowBox[{"#", ",", "#"}], "}"}]}], "]"}]}], ")"}], "&"}]}], 
       "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"Dynamic", "@", "xlis"}], "]"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1619804829],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 
  0.09890260696411132, $CellContext`xlis$$ = {{0, 0}, {0.06814746856689453, 
   0.06814746856689453}, {0.08551921844482421, 0.08551921844482421}, {
   0.0952986717224121, 0.0952986717224121}, {0.11913318634033203`, 
   0.11913318634033203`}, {0.1493462562561035, 0.1493462562561035}, {
   0.16124439239501953`, 0.16124439239501953`}, {0.17166824340820314`, 
   0.17166824340820314`}, {0.19035587310791016`, 0.19035587310791016`}, {
   0.3856374740600586, 0.3856374740600586}, {0.41257648468017577`, 
   0.41257648468017577`}, {0.4248774528503418, 0.4248774528503418}, {
   0.47140865325927733`, 0.47140865325927733`}, {0.5733068466186524, 
   0.5733068466186524}, {0.5852936744689942, 0.5852936744689942}, {
   0.7501510620117188, 0.7501510620117188}, {0.7786420822143555, 
   0.7786420822143555}, {0.7910633087158203, 0.7910633087158203}, {
   0.8020990371704102, 0.8020990371704102}, {0.8376822471618652, 
   0.8376822471618652}, {0.903948974609375, 0.903948974609375}, {
   0.9361222267150879, 0.9361222267150879}, {0.9663379669189454, 
   0.9663379669189454}, {0.9769430160522461, 0.9769430160522461}, {
   0.004298210144042969, 0.004298210144042969}, {0.025181961059570313`, 
   0.025181961059570313`}, {0.05001220703125, 0.05001220703125}, {
   0.0702174186706543, 0.0702174186706543}, {0.0808070182800293, 
   0.0808070182800293}, {0.1120112419128418, 0.1120112419128418}, {
   0.13622465133666992`, 0.13622465133666992`}, {0.1599130630493164, 
   0.1599130630493164}, {0.1826714515686035, 0.1826714515686035}, {
   0.19067459106445311`, 0.19067459106445311`}, {0.2224750518798828, 
   0.2224750518798828}, {0.2566333770751953, 0.2566333770751953}, {
   0.2800872802734375, 0.2800872802734375}, {0.30962324142456055`, 
   0.30962324142456055`}, {0.31774120330810546`, 0.31774120330810546`}, {
   0.4202077865600586, 0.4202077865600586}, {0.4284955978393555, 
   0.4284955978393555}, {0.4405326843261719, 0.4405326843261719}, {
   0.6805036544799805, 0.6805036544799805}, {0.8376363754272461, 
   0.8376363754272461}, {0.8495054244995117, 0.8495054244995117}, {
   0.861235237121582, 0.861235237121582}, {0.9919402122497558, 
   0.9919402122497558}, {0.019370651245117186`, 0.019370651245117186`}, {
   0.04272384643554687, 0.04272384643554687}, {0.06618537902832031, 
   0.06618537902832031}, {0.09480361938476563, 0.09480361938476563}, {
   0.12295665740966796`, 0.12295665740966796`}, {0.1519399642944336, 
   0.1519399642944336}, {0.16691884994506836`, 0.16691884994506836`}, {
   0.1798910140991211, 0.1798910140991211}, {0.32854881286621096`, 
   0.32854881286621096`}, {0.3404868125915527, 0.3404868125915527}, {
   0.349867057800293, 0.349867057800293}, {0.3621776580810547, 
   0.3621776580810547}, {0.5326766967773438, 0.5326766967773438}, {
   0.5483474731445312, 0.5483474731445312}, {0.563448429107666, 
   0.563448429107666}, {0.5787994384765625, 0.5787994384765625}, {
   0.599995231628418, 0.599995231628418}, {0.621091651916504, 
   0.621091651916504}, {0.630259895324707, 0.630259895324707}, {
   0.643393611907959, 0.643393611907959}, {0.9219488143920899, 
   0.9219488143920899}, {0.9321598052978516, 0.9321598052978516}, {
   0.944019889831543, 0.944019889831543}, {0.9550762176513672, 
   0.9550762176513672}, {0.9813348770141601, 0.9813348770141601}, {
   0.9914952278137207, 0.9914952278137207}, {0.0038974761962890627`, 
   0.0038974761962890627`}, {0.01842184066772461, 0.01842184066772461}, {
   0.029177284240722655`, 0.029177284240722655`}, {0.04870424270629883, 
   0.04870424270629883}, {0.058251380920410156`, 0.058251380920410156`}, {
   0.07064304351806641, 0.07064304351806641}, {0.0787506103515625, 
   0.0787506103515625}, {0.0914449691772461, 0.0914449691772461}, {
   0.10544862747192382`, 0.10544862747192382`}, {0.1155400276184082, 
   0.1155400276184082}, {0.12742176055908203`, 0.12742176055908203`}, {
   0.13556861877441406`, 0.13556861877441406`}, {0.14748144149780273`, 
   0.14748144149780273`}, {0.16134929656982422`, 0.16134929656982422`}, {
   0.17251043319702147`, 0.17251043319702147`}, {0.19822139739990235`, 
   0.19822139739990235`}, {0.20848522186279297`, 0.20848522186279297`}, {
   0.25162544250488283`, 0.25162544250488283`}, {0.2652132034301758, 
   0.2652132034301758}, {0.2914936065673828, 0.2914936065673828}, {
   0.30203800201416015`, 0.30203800201416015`}, {0.32262649536132815`, 
   0.32262649536132815`}, {0.34240121841430665`, 0.34240121841430665`}, {
   0.3615584373474121, 0.3615584373474121}, {0.38607158660888674`, 
   0.38607158660888674`}, {0.40896968841552733`, 0.40896968841552733`}, {
   0.4171733856201172, 0.4171733856201172}, {0.43404617309570315`, 
   0.43404617309570315`}, {0.4505446434020996, 0.4505446434020996}, {
   0.4620652198791504, 0.4620652198791504}, {0.47704429626464845`, 
   0.47704429626464845`}, {0.4860866546630859, 0.4860866546630859}, {
   0.4981557846069336, 0.4981557846069336}, {0.5113492965698242, 
   0.5113492965698242}, {0.5229700088500977, 0.5229700088500977}, {
   0.5422482490539551, 0.5422482490539551}, {0.5524472236633301, 
   0.5524472236633301}, {0.5646970748901368, 0.5646970748901368}, {
   0.5782640457153321, 0.5782640457153321}, {0.5897241592407226, 
   0.5897241592407226}, {0.6191880226135253, 0.6191880226135253}, {
   0.6297284126281738, 0.6297284126281738}, {0.6515684127807617, 
   0.6515684127807617}, {0.6628376007080078, 0.6628376007080078}, {
   0.6916766166687012, 0.6916766166687012}, {0.7121917724609375, 
   0.7121917724609375}, {0.7290290832519531, 0.7290290832519531}, {
   0.7485398292541504, 0.7485398292541504}, {0.7683832168579101, 
   0.7683832168579101}, {0.7821040153503418, 0.7821040153503418}, {
   0.7955638885498046, 0.7955638885498046}, {0.8363927841186524, 
   0.8363927841186524}, {0.8497756958007813, 0.8497756958007813}, {
   0.8758731842041015, 0.8758731842041015}, {0.8922435760498046, 
   0.8922435760498046}, {0.9035470962524415, 0.9035470962524415}, {
   0.9231552124023438, 0.9231552124023438}, {0.9338372230529786, 
   0.9338372230529786}, {0.9454362869262696, 0.9454362869262696}, {
   0.9590576171875, 0.9590576171875}, {0.9706527709960937, 
   0.9706527709960937}, {0.9903718948364257, 0.9903718948364257}, {
   0.00023555755615234375`, 0.00023555755615234375`}, {0.012042236328125, 
   0.012042236328125}, {0.020080184936523436`, 0.020080184936523436`}, {
   0.03469362258911133, 0.03469362258911133}, {0.04836559295654297, 
   0.04836559295654297}, {0.057439994812011716`, 0.057439994812011716`}, {
   0.08342504501342773, 0.08342504501342773}, {0.09255104064941407, 
   0.09255104064941407}, {0.10263938903808593`, 0.10263938903808593`}, {
   0.11919002532958985`, 0.11919002532958985`}, {0.13059864044189454`, 
   0.13059864044189454`}, {0.14525928497314453`, 0.14525928497314453`}, {
   0.15393600463867188`, 0.15393600463867188`}, {0.1639162063598633, 
   0.1639162063598633}, {0.1934326171875, 0.1934326171875}, {
   0.2087770462036133, 0.2087770462036133}, {0.22351322174072266`, 
   0.22351322174072266`}, {0.2315974235534668, 0.2315974235534668}, {
   0.24296417236328124`, 0.24296417236328124`}, {0.2741218566894531, 
   0.2741218566894531}, {0.2838172912597656, 0.2838172912597656}, {
   0.2963878631591797, 0.2963878631591797}, {0.3096946716308594, 
   0.3096946716308594}, {0.32103786468505857`, 0.32103786468505857`}, {
   0.34876861572265627`, 0.34876861572265627`}, {0.36222143173217775`, 
   0.36222143173217775`}, {0.3708791732788086, 0.3708791732788086}, {
   0.3805379867553711, 0.3805379867553711}, {0.38997802734375, 
   0.38997802734375}, {0.4034738540649414, 0.4034738540649414}, {
   0.4145618438720703, 0.4145618438720703}, {0.446933650970459, 
   0.446933650970459}, {0.45772686004638674`, 0.45772686004638674`}, {
   0.492215633392334, 0.492215633392334}, {0.5057390213012696, 
   0.5057390213012696}, {0.5144412040710449, 0.5144412040710449}, {
   0.5371524810791015, 0.5371524810791015}, {0.5633174896240234, 
   0.5633174896240234}, {0.5792522430419922, 0.5792522430419922}, {
   0.5901094436645508, 0.5901094436645508}, {0.5984504699707032, 
   0.5984504699707032}, {0.6101506233215332, 0.6101506233215332}, {
   0.6242137908935547, 0.6242137908935547}, {0.6350700378417968, 
   0.6350700378417968}, {0.6609025955200195, 0.6609025955200195}, {
   0.6710853576660156, 0.6710853576660156}, {0.6834684371948242, 
   0.6834684371948242}, {0.6917880058288575, 0.6917880058288575}, {
   0.7035703659057617, 0.7035703659057617}, {0.7172065734863281, 
   0.7172065734863281}, {0.7285466194152832, 0.7285466194152832}, {
   0.7482179641723633, 0.7482179641723633}, {0.7583200454711914, 
   0.7583200454711914}, {0.7744184494018554, 0.7744184494018554}, {
   0.8058954238891601, 0.8058954238891601}, {0.8153094291687012, 
   0.8153094291687012}, {0.8253028869628907, 0.8253028869628907}, {
   0.8423150062561036, 0.8423150062561036}, {0.8537633895874024, 
   0.8537633895874024}, {0.8650161743164062, 0.8650161743164062}, {
   0.8912717819213867, 0.8912717819213867}, {0.9022691726684571, 
   0.9022691726684571}, {0.9278453826904297, 0.9278453826904297}, {
   0.9513717651367187, 0.9513717651367187}, {0.9617998123168945, 
   0.9617998123168945}, {0.9881465911865235, 0.9881465911865235}, {
   0.998472023010254, 0.998472023010254}, {0.01087503433227539, 
   0.01087503433227539}, {0.024614238739013673`, 0.024614238739013673`}, {
   0.03572101593017578, 0.03572101593017578}, {0.05853595733642578, 
   0.05853595733642578}, {0.07221508026123047, 0.07221508026123047}, {
   0.10484905242919922`, 0.10484905242919922`}, {0.12489776611328125`, 
   0.12489776611328125`}, {0.13531436920166015`, 0.13531436920166015`}, {
   0.1780078887939453, 0.1780078887939453}, {0.20128116607666016`, 
   0.20128116607666016`}, {0.22182941436767578`, 0.22182941436767578`}, {
   0.24642887115478515`, 0.24642887115478515`}, {0.26499242782592775`, 
   0.26499242782592775`}, {0.2964766502380371, 0.2964766502380371}, {
   0.3187564849853516, 0.3187564849853516}, {0.3436406135559082, 
   0.3436406135559082}, {0.3621335983276367, 0.3621335983276367}, {
   0.3725790023803711, 0.3725790023803711}, {0.39583444595336914`, 
   0.39583444595336914`}, {0.4093212127685547, 0.4093212127685547}, {
   0.4367500305175781, 0.4367500305175781}, {0.4555961608886719, 
   0.4555961608886719}, {0.4662763595581055, 0.4662763595581055}, {
   0.49255523681640623`, 0.49255523681640623`}, {0.5031078338623047, 
   0.5031078338623047}, {0.5298337936401367, 0.5298337936401367}, {
   0.5392290115356445, 0.5392290115356445}, {0.5522689819335938, 
   0.5522689819335938}, {0.5631818771362305, 0.5631818771362305}, {
   0.5894227981567383, 0.5894227981567383}, {0.5995814323425293, 
   0.5995814323425293}, {0.6122302055358887, 0.6122302055358887}, {
   0.6259416580200196, 0.6259416580200196}, {0.6370643615722656, 
   0.6370643615722656}, {0.6625642776489258, 0.6625642776489258}, {
   0.6732248306274414, 0.6732248306274414}, {0.6994950294494628, 
   0.6994950294494628}, {0.7099504470825195, 0.7099504470825195}, {
   0.7427499771118165, 0.7427499771118165}, {0.763123893737793, 
   0.763123893737793}, {0.7734818458557129, 0.7734818458557129}, {
   0.7858758926391601, 0.7858758926391601}, {0.7995364189147949, 
   0.7995364189147949}, {0.8107448577880859, 0.8107448577880859}, {
   0.8302968978881836, 0.8302968978881836}, {0.840121078491211, 
   0.840121078491211}, {0.8569902420043946, 0.8569902420043946}, {
   0.8668724060058594, 0.8668724060058594}, {0.8792754173278808, 
   0.8792754173278808}, {0.888064956665039, 0.888064956665039}, {
   0.9009730339050293, 0.9009730339050293}, {0.9275239944458008, 
   0.9275239944458008}, {0.9374629974365234, 0.9374629974365234}, {
   0.9478969573974609, 0.9478969573974609}, {0.9795588493347168, 
   0.9795588493347168}, {0.9996570587158203, 0.9996570587158203}, {
   0.019864845275878906`, 0.019864845275878906`}, {0.043012237548828124`, 
   0.043012237548828124`}, {0.06313543319702149, 0.06313543319702149}, {
   0.08352909088134766, 0.08352909088134766}, {0.10311737060546874`, 
   0.10311737060546874`}, {0.12379989624023438`, 0.12379989624023438`}, {
   0.1485198974609375, 0.1485198974609375}, {0.1566404342651367, 
   0.1566404342651367}, {0.16991539001464845`, 0.16991539001464845`}, {
   0.17795562744140625`, 0.17795562744140625`}, {0.20477027893066407`, 
   0.20477027893066407`}, {0.214218807220459, 0.214218807220459}, {
   0.2389052391052246, 0.2389052391052246}, {0.2523656845092773, 
   0.2523656845092773}, {0.26169462203979493`, 0.26169462203979493`}, {
   0.27307567596435545`, 0.27307567596435545`}, {0.28110198974609374`, 
   0.28110198974609374`}, {0.29312801361083984`, 0.29312801361083984`}, {
   0.30118160247802733`, 0.30118160247802733`}, {0.314105224609375, 
   0.314105224609375}, {0.322539234161377, 0.322539234161377}, {
   0.3329122543334961, 0.3329122543334961}, {0.34102725982666016`, 
   0.34102725982666016`}, {0.35352363586425783`, 0.35352363586425783`}, {
   0.36159286499023435`, 0.36159286499023435`}, {0.37392139434814453`, 
   0.37392139434814453`}, {0.38474740982055666`, 0.38474740982055666`}, {
   0.40439643859863283`, 0.40439643859863283`}, {0.41617183685302733`, 
   0.41617183685302733`}, {0.47425384521484376`, 0.47425384521484376`}, {
   0.4941054344177246, 0.4941054344177246}, {0.5050082206726074, 
   0.5050082206726074}, {0.5313018798828125, 0.5313018798828125}, {
   0.5414384841918946, 0.5414384841918946}, {0.5540554046630859, 
   0.5540554046630859}, {0.5648604393005371, 0.5648604393005371}, {
   0.5913972854614258, 0.5913972854614258}, {0.6020050048828125, 
   0.6020050048828125}, {0.6278880119323731, 0.6278880119323731}, {
   0.6384738922119141, 0.6384738922119141}, {0.6485918045043946, 
   0.6485918045043946}, {0.6570941925048828, 0.6570941925048828}, {
   0.6675773620605469, 0.6675773620605469}, {0.6756719589233399, 
   0.6756719589233399}, {0.6982736587524414, 0.6982736587524414}, {
   0.7071738243103027, 0.7071738243103027}, {0.7175840377807617, 
   0.7175840377807617}, {0.7256673812866211, 0.7256673812866211}, {
   0.7793886184692382, 0.7793886184692382}, {0.7884030342102051, 
   0.7884030342102051}, {0.8008611679077149, 0.8008611679077149}, {
   0.8091248512268067, 0.8091248512268067}, {0.8213403701782227, 
   0.8213403701782227}, {0.8322402954101562, 0.8322402954101562}, {
   0.8585174560546875, 0.8585174560546875}, {0.8689313888549804, 
   0.8689313888549804}, {0.889217758178711, 0.889217758178711}, {
   0.89898681640625, 0.89898681640625}, {0.9171672821044922, 
   0.9171672821044922}, {0.9253383636474609, 0.9253383636474609}, {
   0.9382129669189453, 0.9382129669189453}, {0.9492084503173828, 
   0.9492084503173828}, {0.9694002151489258, 0.9694002151489258}, {
   0.9791616439819336, 0.9791616439819336}, {0.9889522552490234, 
   0.9889522552490234}, {0.5289570808410644, 0.5289570808410644}, {
   0.5570843696594239, 0.5570843696594239}, {0.5820862770080566, 
   0.5820862770080566}, {0.6070881843566894, 0.6070881843566894}, {
   0.6227143287658692, 0.6227143287658692}, {0.6445910453796386, 
   0.6445910453796386}, {0.6602171897888184, 0.6602171897888184}, {
   0.6852190971374512, 0.6852190971374512}, {0.7039706230163574, 
   0.7039706230163574}, {0.7258473396301269, 0.7258473396301269}, {
   0.7414734840393067, 0.7414734840393067}, {0.7633502006530761, 
   0.7633502006530761}, {0.788352108001709, 0.788352108001709}, {
   0.8102287292480469, 0.8102287292480469}, {0.8289801597595214, 
   0.8289801597595214}, {0.8477315902709961, 0.8477315902709961}, {
   0.8664830207824707, 0.8664830207824707}, {0.8883597373962402, 
   0.8883597373962402}, {0.9039858818054199, 0.9039858818054199}, {
   0.9258625984191895, 0.9258625984191895}, {0.9414887428283691, 
   0.9414887428283691}, {0.41340007781982424`, 0.41340007781982424`}, {
   0.43215150833129884`, 0.43215150833129884`}, {0.44465246200561526`, 
   0.44465246200561526`}, {0.4571534156799316, 0.4571534156799316}, {
   0.46965436935424804`, 0.46965436935424804`}, {0.48528051376342773`, 
   0.48528051376342773`}, {0.5009068489074707, 0.5009068489074707}, {
   0.5134078025817871, 0.5134078025817871}, {0.5259087562561036, 
   0.5259087562561036}, {0.5384097099304199, 0.5384097099304199}, {
   0.5509106636047363, 0.5509106636047363}, {0.5634116172790528, 
   0.5634116172790528}, {0.5790377616882324, 0.5790377616882324}, {
   0.600914478302002, 0.600914478302002}, {0.6165406227111816, 
   0.6165406227111816}, {0.6290415763854981, 0.6290415763854981}, {
   0.6415425300598144, 0.6415425300598144}, {0.6540434837341309, 
   0.6540434837341309}, {0.6665444374084473, 0.6665444374084473}, {
   0.6821707725524903, 0.6821707725524903}, {0.6946717262268066, 
   0.6946717262268066}, {0.7071726799011231, 0.7071726799011231}, {
   0.7227988243103027, 0.7227988243103027}, {0.7321745872497558, 
   0.7321745872497558}, {0.7446755409240723, 0.7446755409240723}, {
   0.7665521621704101, 0.7665521621704101}, {0.791554069519043, 
   0.791554069519043}, {0.8009298324584961, 0.8009298324584961}, {
   0.8165560722351074, 0.8165560722351074}, {0.8259318351745606, 
   0.8259318351745606}, {0.8415579795837402, 0.8415579795837402}, {
   0.8603093147277832, 0.8603093147277832}, {0.8759356498718261, 
   0.8759356498718261}, {0.8946869850158692, 0.8946869850158692}, {
   0.9071879386901855, 0.9071879386901855}, {0.9228141784667969, 
   0.9228141784667969}, {0.9384404182434082, 0.9384404182434082}, {
   0.9540665626525879, 0.9540665626525879}, {0.9728179931640625, 
   0.9728179931640625}, {0.0009451866149902344, 0.0009451866149902344}, {
   0.019696712493896484`, 0.019696712493896484`}, {0.03219766616821289, 
   0.03219766616821289}, {0.05094900131225586, 0.05094900131225586}, {
   0.22501726150512696`, 0.22501726150512696`}, {0.2781463623046875, 
   0.2781463623046875}, {0.30939884185791017`, 0.30939884185791017`}, {
   0.32502498626708987`, 0.32502498626708987`}, {0.3406511306762695, 
   0.3406511306762695}, {0.35002689361572265`, 0.35002689361572265`}, {
   0.36877832412719724`, 0.36877832412719724`}, {0.38127927780151366`, 
   0.38127927780151366`}, {0.4625354766845703, 0.4625354766845703}, {
   0.7031789779663086, 0.7031789779663086}, {0.31267757415771485`, 
   0.31267757415771485`}, {0.3564310073852539, 0.3564310073852539}, {
   0.8939722061157227, 0.8939722061157227}, {0.9502265930175782, 
   0.9502265930175782}, {0.6534055709838867, 0.6534055709838867}, {
   0.6752822875976563, 0.6752822875976563}, {0.700284194946289, 
   0.700284194946289}, {0.719035530090332, 0.719035530090332}, {
   0.7409122467041016, 0.7409122467041016}, {0.9002994537353516, 
   0.9002994537353516}, {0.912800407409668, 0.912800407409668}, {
   0.9284267425537109, 0.9284267425537109}, {0.9409276962280273, 
   0.9409276962280273}, {0.956553840637207, 0.956553840637207}, {
   0.9690547943115234, 0.9690547943115234}, {0.9815557479858399, 
   0.9815557479858399}, {0.990931510925293, 0.990931510925293}, {
   0.003432464599609375, 0.003432464599609375}, {0.015933418273925783`, 
   0.015933418273925783`}, {0.03781003952026367, 0.03781003952026367}, {
   0.05656147003173828, 0.05656147003173828}, {0.0659372329711914, 
   0.0659372329711914}, {0.09718971252441407, 0.09718971252441407}, {
   0.10969066619873047`, 0.10969066619873047`}, {0.12531681060791017`, 
   0.12531681060791017`}, {0.15031871795654297`, 0.15031871795654297`}, {
   0.1659449577331543, 0.1659449577331543}, {0.17532062530517578`, 
   0.17532062530517578`}, {0.19407205581665038`, 0.19407205581665038`}, {
   0.20344781875610352`, 0.20344781875610352`}, {0.2253244400024414, 
   0.2253244400024414}, {0.24095067977905274`, 0.24095067977905274`}, {
   0.25032634735107423`, 0.25032634735107423`}, {0.26595268249511717`, 
   0.26595268249511717`}, {0.28470401763916015`, 0.28470401763916015`}, {
   0.3065807342529297, 0.3065807342529297}, {0.3253321647644043, 
   0.3253321647644043}, {0.3378331184387207, 0.3378331184387207}, {
   0.35033407211303713`, 0.35033407211303713`}, {0.3597098350524902, 
   0.3597098350524902}, {0.37221078872680663`, 0.37221078872680663`}, {
   0.38471174240112305`, 0.38471174240112305`}, {0.4065883636474609, 
   0.4065883636474609}, {0.41908931732177734`, 0.41908931732177734`}, {
   0.43159027099609376`, 0.43159027099609376`}, {0.4440912246704102, 
   0.4440912246704102}, {0.45659217834472654`, 0.45659217834472654`}, {
   0.47221851348876953`, 0.47221851348876953`}, {0.5065959930419922, 
   0.5065959930419922}, {0.5159717559814453, 0.5159717559814453}, {
   0.5315979957580567, 0.5315979957580567}, {0.544098949432373, 
   0.544098949432373}, {0.5565999031066895, 0.5565999031066895}, {
   0.5659756660461426, 0.5659756660461426}, {0.5847270965576172, 
   0.5847270965576172}, {0.5941027641296387, 0.5941027641296387}, {
   0.6066038131713867, 0.6066038131713867}, {0.6316057205200195, 
   0.6316057205200195}, {0.6472318649291993, 0.6472318649291993}, {
   0.6566076278686523, 0.6566076278686523}, {0.6753589630126953, 
   0.6753589630126953}, {0.6941104888916015, 0.6941104888916015}, {
   0.706611442565918, 0.706611442565918}, {0.7316133499145507, 
   0.7316133499145507}, {0.7409891128540039, 0.7409891128540039}, {
   0.7566152572631836, 0.7566152572631836}, {0.7659910202026368, 
   0.7659910202026368}, {0.7816171646118164, 0.7816171646118164}, {
   0.7909929275512695, 0.7909929275512695}, {0.8097444534301758, 
   0.8097444534301758}, {0.8191200256347656, 0.8191200256347656}, {
   0.8316209793090821, 0.8316209793090821}, {0.8566228866577148, 
   0.8566228866577148}, {0.8691238403320313, 0.8691238403320313}, {
   0.8941258430480957, 0.8941258430480957}, {0.9066267967224121, 
   0.9066267967224121}, {0.9191277503967286, 0.9191277503967286}, {
   0.9316287040710449, 0.9316287040710449}, {0.941004467010498, 
   0.941004467010498}, {0.9628810882568359, 0.9628810882568359}, {
   0.972256851196289, 0.972256851196289}, {0.9847578048706055, 
   0.9847578048706055}, {0.9972587585449219, 0.9972587585449219}, {
   0.00975971221923828, 0.00975971221923828}, {0.022260665893554688`, 
   0.022260665893554688`}, {0.0472625732421875, 0.0472625732421875}, {
   0.059763526916503905`, 0.059763526916503905`}, {0.06913928985595703, 
   0.06913928985595703}, {0.09101600646972656, 0.09101600646972656}, {
   0.11601791381835938`, 0.11601791381835938`}, {0.12539358139038087`, 
   0.12539358139038087`}, {0.13789453506469726`, 0.13789453506469726`}, {
   0.16289644241333007`, 0.16289644241333007`}, {0.1722722053527832, 
   0.1722722053527832}, {0.18477325439453124`, 0.18477325439453124`}, {
   0.19414882659912108`, 0.19414882659912108`}, {0.21602554321289064`, 
   0.21602554321289064`}, {0.23477706909179688`, 0.23477706909179688`}, {
   0.24415264129638672`, 0.24415264129638672`}, {0.26290416717529297`, 
   0.26290416717529297`}, {0.294156551361084, 0.294156551361084}, {
   0.3035323143005371, 0.3035323143005371}, {0.325408935546875, 
   0.325408935546875}, {0.3441603660583496, 0.3441603660583496}, {
   0.356661319732666, 0.356661319732666}, {0.36916236877441405`, 
   0.36916236877441405`}, {0.3785381317138672, 0.3785381317138672}, {
   0.3941642761230469, 0.3941642761230469}, {0.4066652297973633, 
   0.4066652297973633}, {0.41916618347167967`, 0.41916618347167967`}, {
   0.4316671371459961, 0.4316671371459961}, {0.4472932815551758, 
   0.4472932815551758}, {0.4566690444946289, 0.4566690444946289}, {
   0.47229528427124023`, 0.47229528427124023`}, {0.5035476684570312, 
   0.5035476684570312}, {0.5160486221313476, 0.5160486221313476}, {
   0.5285495758056641, 0.5285495758056641}, {0.5379252433776855, 
   0.5379252433776855}, {0.56292724609375, 0.56292724609375}, {
   0.5879291534423828, 0.5879291534423828}, {0.5973049163818359, 
   0.5973049163818359}, {0.6129310607910157, 0.6129310607910157}, {
   0.6223068237304688, 0.6223068237304688}, {0.6379329681396484, 
   0.6379329681396484}, {0.6473087310791016, 0.6473087310791016}, {
   0.6629348754882812, 0.6629348754882812}, {0.6785611152648926, 
   0.6785611152648926}, {0.6973125457763671, 0.6973125457763671}, {
   0.7098134994506836, 0.7098134994506836}, {0.722314453125, 
   0.722314453125}, {0.7473163604736328, 0.7473163604736328}, {
   0.7629425048828125, 0.7629425048828125}, {0.7754434585571289, 
   0.7754434585571289}, {0.7879444122314453, 0.7879444122314453}, {
   0.8129463195800781, 0.8129463195800781}, {0.8285726547241211, 
   0.8285726547241211}, {0.8441987991333008, 0.8441987991333008}, {
   0.8598250389099121, 0.8598250389099121}, {0.8785764694213867, 
   0.8785764694213867}, {0.9098288536071777, 0.9098288536071777}, {
   0.9254550933837891, 0.9254550933837891}, {0.944206428527832, 
   0.944206428527832}, {0.9567073822021485, 0.9567073822021485}, {
   0.9754589080810547, 0.9754589080810547}, {0.9879598617553711, 
   0.9879598617553711}, {0.003586006164550781, 0.003586006164550781}, {
   0.01921224594116211, 0.01921224594116211}, {0.03483848571777344, 
   0.03483848571777344}, {0.050464630126953125`, 0.050464630126953125`}, {
   0.06609086990356446, 0.06609086990356446}, {0.09734325408935547, 
   0.09734325408935547}, {0.10984420776367188`, 0.10984420776367188`}, {
   0.1317209243774414, 0.1317209243774414}, {0.1473470687866211, 
   0.1473470687866211}, {0.16297321319580077`, 0.16297321319580077`}, {
   0.1754741668701172, 0.1754741668701172}, {0.19422569274902343`, 
   0.19422569274902343`}, {0.20985183715820313`, 0.20985183715820313`}, {
   0.22860336303710938`, 0.22860336303710938`}, {0.2411043167114258, 
   0.2411043167114258}, {0.2598557472229004, 0.2598557472229004}, {
   0.2754818916320801, 0.2754818916320801}, {0.30048389434814454`, 
   0.30048389434814454`}, {0.31298484802246096`, 0.31298484802246096`}, {
   0.3286109924316406, 0.3286109924316406}, {0.3442371368408203, 
   0.3442371368408203}, {0.3598634719848633, 0.3598634719848633}, {
   0.375489616394043, 0.375489616394043}, {0.3942409515380859, 
   0.3942409515380859}, {0.406742000579834, 0.406742000579834}, {
   0.4254934310913086, 0.4254934310913086}, {0.4504953384399414, 
   0.4504953384399414}, {0.49112348556518554`, 0.49112348556518554`}, {
   0.503624439239502, 0.503624439239502}, {0.5192506790161133, 
   0.5192506790161133}, {0.5317516326904297, 0.5317516326904297}, {
   0.5536283493041992, 0.5536283493041992}, {0.5692544937133789, 
   0.5692544937133789}, {0.5880059242248535, 0.5880059242248535}, {
   0.6005068778991699, 0.6005068778991699}, {0.6161331176757813, 
   0.6161331176757813}, {0.6286340713500976, 0.6286340713500976}, {
   0.6473855018615723, 0.6473855018615723}, {0.6817630767822266, 
   0.6817630767822266}, {0.7005146026611329, 0.7005146026611329}, {
   0.7192659378051758, 0.7192659378051758}, {0.7317668914794921, 
   0.7317668914794921}, {0.7473932266235351, 0.7473932266235351}, {
   0.7661445617675782, 0.7661445617675782}, {0.7848960876464843, 
   0.7848960876464843}, {0.7973970413208008, 0.7973970413208008}, {
   0.8130231857299804, 0.8130231857299804}, {0.8286494255065918, 
   0.8286494255065918}, {0.8474008560180664, 0.8474008560180664}, {
   0.8630270004272461, 0.8630270004272461}, {0.888028907775879, 
   0.888028907775879}, {0.9036552429199218, 0.9036552429199218}, {
   0.9192813873291016, 0.9192813873291016}, {0.931782341003418, 
   0.931782341003418}, {0.9536590576171875, 0.9536590576171875}, {
   0.9692852020263671, 0.9692852020263671}, {0.9880366325378418, 
   0.9880366325378418}, {0.0005375862121582032, 0.0005375862121582032}, {
   0.01616382598876953, 0.01616382598876953}, {0.031789970397949216`, 
   0.031789970397949216`}, {0.04741621017456055, 0.04741621017456055}, {
   0.06304244995117188, 0.06304244995117188}, {0.0849191665649414, 
   0.0849191665649414}, {0.10367050170898437`, 0.10367050170898437`}, {
   0.11929664611816407`, 0.11929664611816407`}, {0.13179759979248046`, 
   0.13179759979248046`}, {0.15054912567138673`, 0.15054912567138673`}, {
   0.16617536544799805`, 0.16617536544799805`}, {0.18180150985717775`, 
   0.18180150985717775`}, {0.20680341720581055`, 0.20680341720581055`}, {
   0.23180532455444336`, 0.23180532455444336`}, {0.24743156433105468`, 
   0.24743156433105468`}, {0.2630577087402344, 0.2630577087402344}, {
   0.29118499755859373`, 0.29118499755859373`}, {0.3130615234375, 
   0.3130615234375}, {0.3255624771118164, 0.3255624771118164}, {
   0.34743919372558596`, 0.34743919372558596`}, {0.3630654335021973, 
   0.3630654335021973}, {0.3786916732788086, 0.3786916732788086}, {
   0.391192626953125, 0.391192626953125}, {0.4099440574645996, 
   0.4099440574645996}, {0.4255702018737793, 0.4255702018737793}, {
   0.4443216323852539, 0.4443216323852539}, {0.47557411193847654`, 
   0.47557411193847654`}, {0.5068264007568359, 0.5068264007568359}, {
   0.5193273544311523, 0.5193273544311523}, {0.5349536895751953, 
   0.5349536895751953}, {0.550579833984375, 0.550579833984375}, {
   0.5662060737609863, 0.5662060737609863}, {0.5787070274353028, 
   0.5787070274353028}, {0.6005836486816406, 0.6005836486816406}, {
   0.616209888458252, 0.616209888458252}, {0.6318361282348632, 
   0.6318361282348632}, {0.6443370819091797, 0.6443370819091797}, {
   0.6630884170532226, 0.6630884170532226}, {0.6787147521972656, 
   0.6787147521972656}, {0.7005912780761718, 0.7005912780761718}, {
   0.7162176132202148, 0.7162176132202148}, {0.7349690437316895, 
   0.7349690437316895}, {0.7505951881408691, 0.7505951881408691}, {
   0.7693466186523438, 0.7693466186523438}, {0.7818475723266601, 
   0.7818475723266601}, {0.8005990028381348, 0.8005990028381348}, {
   0.8131000518798828, 0.8131000518798828}, {0.8287261962890625, 
   0.8287261962890625}, {0.8412271499633789, 0.8412271499633789}, {
   0.8599786758422852, 0.8599786758422852}, {0.8756048202514648, 
   0.8756048202514648}, {0.9037319183349609, 0.9037319183349609}, {
   0.9318591117858886, 0.9318591117858886}, {0.9443600654602051, 
   0.9443600654602051}, {0.9599863052368164, 0.9599863052368164}, {
   0.9756124496459961, 0.9756124496459961}, {0.9912386894226074, 
   0.9912386894226074}, {0.0037396430969238283`, 0.0037396430969238283`}, {
   0.022491073608398436`, 0.022491073608398436`}, {0.034992027282714847`, 
   0.034992027282714847`}, {0.05374355316162109, 0.05374355316162109}, {
   0.06936969757080078, 0.06936969757080078}, {0.0943716049194336, 
   0.0943716049194336}, {0.12249879837036133`, 0.12249879837036133`}, {
   0.15062589645385743`, 0.15062589645385743`}, {0.16625213623046875`, 
   0.16625213623046875`}, {0.18187828063964845`, 0.18187828063964845`}, {
   0.19437923431396484`, 0.19437923431396484`}, {0.21313076019287108`, 
   0.21313076019287108`}, {0.2256317138671875, 0.2256317138671875}, {
   0.2412578582763672, 0.2412578582763672}, {0.26938495635986326`, 
   0.26938495635986326`}, {0.28501129150390625`, 0.28501129150390625`}, {
   0.30688791275024413`, 0.30688791275024413`}, {0.32251415252685545`, 
   0.32251415252685545`}, {0.3412655830383301, 0.3412655830383301}, {
   0.35376653671264646`, 0.35376653671264646`}, {0.3725179672241211, 
   0.3725179672241211}, {0.3850189208984375, 0.3850189208984375}, {
   0.40377044677734375`, 0.40377044677734375`}, {0.43189754486083987`, 
   0.43189754486083987`}, {0.4475236892700195, 0.4475236892700195}, {
   0.4662752151489258, 0.4662752151489258}, {0.4850266456604004, 
   0.4850266456604004}, {0.5069032669067383, 0.5069032669067383}, {
   0.5225295066833496, 0.5225295066833496}, {0.5412809371948242, 
   0.5412809371948242}, {0.5537818908691406, 0.5537818908691406}, {
   0.5694080352783203, 0.5694080352783203}, {0.5975353240966796, 
   0.5975353240966796}, {0.6131614685058594, 0.6131614685058594}, {
   0.628787612915039, 0.628787612915039}, {0.6412885665893555, 
   0.6412885665893555}, {0.6600400924682617, 0.6600400924682617}, {
   0.6756662368774414, 0.6756662368774414}, {0.7006681442260743, 
   0.7006681442260743}, {0.7131690979003906, 0.7131690979003906}, {
   0.7319205284118653, 0.7319205284118653}, {0.7444214820861816, 
   0.7444214820861816}, {0.760047721862793, 0.760047721862793}, {
   0.7850496292114257, 0.7850496292114257}, {0.8006757736206055, 
   0.8006757736206055}, {0.8163021087646485, 0.8163021087646485}, {
   0.8288030624389648, 0.8288030624389648}, {0.8475543975830078, 
   0.8475543975830078}, {0.8600554466247559, 0.8600554466247559}, {
   0.8819320678710938, 0.8819320678710938}, {0.8975583076477051, 
   0.8975583076477051}, {0.9163097381591797, 0.9163097381591797}, {
   0.9288106918334961, 0.9288106918334961}, {0.9475621223449707, 
   0.9475621223449707}, {0.9600631713867187, 0.9600631713867187}, {
   0.9788145065307617, 0.9788145065307617}, {0.9944406509399414, 
   0.9944406509399414}, {0.013192176818847656`, 0.013192176818847656`}, {
   0.025693130493164063`, 0.025693130493164063`}, {0.04444456100463867, 
   0.04444456100463867}, {0.06007080078125, 0.06007080078125}, {
   0.08507270812988281, 0.08507270812988281}, {0.11632509231567383`, 
   0.11632509231567383`}, {0.13195133209228516`, 0.13195133209228516`}, {
   0.14757747650146485`, 0.14757747650146485`}, {0.16320362091064453`, 
   0.16320362091064453`}, {0.1788299560546875, 0.1788299560546875}, {
   0.1944561004638672, 0.1944561004638672}, {0.21008224487304689`, 
   0.21008224487304689`}, {0.22258319854736328`, 0.22258319854736328`}, {
   0.24133472442626952`, 0.24133472442626952`}, {0.25383567810058594`, 
   0.25383567810058594`}, {0.26946182250976564`, 0.26946182250976564`}, {
   0.29133853912353513`, 0.29133853912353513`}, {0.3100899696350098, 
   0.3100899696350098}, {0.32259092330932615`, 0.32259092330932615`}, {
   0.3382171630859375, 0.3382171630859375}, {0.35384330749511717`, 
   0.35384330749511717`}, {0.36946945190429686`, 0.36946945190429686`}, {
   0.38509578704833985`, 0.38509578704833985`}, {0.40072193145751955`, 
   0.40072193145751955`}, {0.4132228851318359, 0.4132228851318359}, {
   0.43197431564331057`, 0.43197431564331057`}, {0.44447526931762693`, 
   0.44447526931762693`}, {0.4663519859313965, 0.4663519859313965}, {
   0.4851034164428711, 0.4851034164428711}, {0.5069801330566406, 
   0.5069801330566406}, {0.519481086730957, 0.519481086730957}, {
   0.538232421875, 0.538232421875}, {0.553858757019043, 0.553858757019043}, {
   0.5694849014282226, 0.5694849014282226}, {0.5819858551025391, 
   0.5819858551025391}, {0.6007372856140136, 0.6007372856140136}, {
   0.6132382392883301, 0.6132382392883301}, {0.6319896697998046, 
   0.6319896697998046}, {0.6444906234741211, 0.6444906234741211}, {
   0.6632420539855957, 0.6632420539855957}, {0.6819934844970703, 
   0.6819934844970703}, {0.7101207733154297, 0.7101207733154297}, {
   0.7257469177246094, 0.7257469177246094}, {0.7413730621337891, 
   0.7413730621337891}, {0.7695001602172852, 0.7695001602172852}, {
   0.7976274490356445, 0.7976274490356445}, {0.8132535934448242, 
   0.8132535934448242}, {0.8320050239562988, 0.8320050239562988}, {
   0.8601322174072266, 0.8601322174072266}, {0.8788836479187012, 
   0.8788836479187012}, {0.9038856506347657, 0.9038856506347657}, {
   0.916386604309082, 0.916386604309082}, {0.935137939453125, 
   0.935137939453125}, {0.9476388931274414, 0.9476388931274414}, {
   0.9632650375366211, 0.9632650375366211}, {0.9913923263549804, 
   0.9913923263549804}, {0.003893280029296875, 0.003893280029296875}, {
   0.01951942443847656, 0.01951942443847656}, {0.03514566421508789, 
   0.03514566421508789}, {0.05077180862426758, 0.05077180862426758}, {
   0.06327276229858399, 0.06327276229858399}, {0.09139995574951172, 
   0.09139995574951172}, {0.1070261001586914, 0.1070261001586914}, {
   0.12265243530273437`, 0.12265243530273437`}, {0.1351533889770508, 
   0.1351533889770508}, {0.15077953338623046`, 0.15077953338623046`}, {
   0.16640567779541016`, 0.16640567779541016`}, {0.18203191757202147`, 
   0.18203191757202147`}, {0.19765815734863282`, 0.19765815734863282`}, {
   0.2132843017578125, 0.2132843017578125}, {0.2257852554321289, 
   0.2257852554321289}, {0.2445366859436035, 0.2445366859436035}, {
   0.27266387939453124`, 0.27266387939453124`}, {0.2945405960083008, 
   0.2945405960083008}, {0.31329193115234377`, 0.31329193115234377`}, {
   0.32579288482666013`, 0.32579288482666013`}, {0.3414192199707031, 
   0.3414192199707031}, {0.35392017364501954`, 0.35392017364501954`}, {
   0.37267160415649414`, 0.37267160415649414`}, {0.38517255783081056`, 
   0.38517255783081056`}, {0.40392398834228516`, 0.40392398834228516`}, {
   0.4164249420166016, 0.4164249420166016}, {0.43205108642578127`, 
   0.43205108642578127`}, {0.4476773262023926, 0.4476773262023926}, {
   0.4664287567138672, 0.4664287567138672}, {0.5008064270019531, 
   0.5008064270019531}, {0.5164325714111329, 0.5164325714111329}, {
   0.535184097290039, 0.535184097290039}, {0.5476850509643555, 
   0.5476850509643555}, {0.5633111953735351, 0.5633111953735351}, {
   0.5789374351501465, 0.5789374351501465}, {0.5945635795593261, 
   0.5945635795593261}, {0.6070645332336426, 0.6070645332336426}, {
   0.6226907730102539, 0.6226907730102539}, {0.6351917266845704, 
   0.6351917266845704}, {0.6539432525634765, 0.6539432525634765}, {
   0.6695693969726563, 0.6695693969726563}, {0.6883207321166992, 
   0.6883207321166992}, {0.7070722579956055, 0.7070722579956055}, {
   0.7258235931396484, 0.7258235931396484}, {0.7539508819580079, 
   0.7539508819580079}, {0.7664518356323242, 0.7664518356323242}, {
   0.7820779800415039, 0.7820779800415039}, {0.7977042198181152, 
   0.7977042198181152}, {0.8164556503295899, 0.8164556503295899}, {
   0.8289566040039062, 0.8289566040039062}, {0.8477081298828125, 
   0.8477081298828125}, {0.8602090835571289, 0.8602090835571289}, {
   0.8914613723754883, 0.8914613723754883}, {0.9102128982543946, 
   0.9102128982543946}, {0.9289642333984375, 0.9289642333984375}, {
   0.9539662361145019, 0.9539662361145019}, {0.9758428573608399, 
   0.9758428573608399}, {0.9914690971374511, 0.9914690971374511}, {
   0.007095241546630859, 0.007095241546630859}, {0.019596290588378907`, 
   0.019596290588378907`}, {0.032097244262695314`, 0.032097244262695314`}, {
   0.047723388671875, 0.047723388671875}, {0.07272529602050781, 
   0.07272529602050781}, {0.1008523941040039, 0.1008523941040039}, {
   0.11022815704345704`, 0.11022815704345704`}, {0.12897968292236328`, 
   0.12897968292236328`}, {0.13835535049438477`, 0.13835535049438477`}, {
   0.1539815902709961, 0.1539815902709961}, {0.1664825439453125, 
   0.1664825439453125}, {0.18210868835449218`, 0.18210868835449218`}, {
   0.1946096420288086, 0.1946096420288086}, {0.2102358818054199, 
   0.2102358818054199}, {0.22273693084716797`, 0.22273693084716797`}, {
   0.23836307525634765`, 0.23836307525634765`}, {0.25086402893066406`, 
   0.25086402893066406`}, {0.26649017333984376`, 0.26649017333984376`}, {
   0.2789911270141602, 0.2789911270141602}, {0.3102436065673828, 
   0.3102436065673828}, {0.32274456024169923`, 0.32274456024169923`}, {
   0.33837070465087893`, 0.33837070465087893`}, {0.3633726119995117, 
   0.3633726119995117}, {0.378998851776123, 0.378998851776123}, {
   0.39149980545043944`, 0.39149980545043944`}, {0.40712604522705076`, 
   0.40712604522705076`}, {0.4165018081665039, 0.4165018081665039}, {
   0.43837833404541016`, 0.43837833404541016`}, {0.45400466918945315`, 
   0.45400466918945315`}, {0.4665056228637695, 0.4665056228637695}, {
   0.49150753021240234`, 0.49150753021240234`}, {0.5040084838867187, 
   0.5040084838867187}, {0.5196346282958985, 0.5196346282958985}, {
   0.5321355819702148, 0.5321355819702148}, {0.5446365356445313, 
   0.5446365356445313}, {0.569638442993164, 0.569638442993164}, {
   0.5852646827697754, 0.5852646827697754}, {0.5977657318115235, 
   0.5977657318115235}, {0.6133918762207031, 0.6133918762207031}, {
   0.6258928298950195, 0.6258928298950195}, {0.638393783569336, 
   0.638393783569336}, {0.6508947372436523, 0.6508947372436523}, {
   0.6790218353271484, 0.6790218353271484}, {0.700898551940918, 
   0.700898551940918}, {0.7133995056152344, 0.7133995056152344}, {
   0.7290257453918457, 0.7290257453918457}, {0.7415266990661621, 
   0.7415266990661621}, {0.7540276527404786, 0.7540276527404786}, {
   0.7665286064147949, 0.7665286064147949}, {0.7852800369262696, 
   0.7852800369262696}, {0.7977809906005859, 0.7977809906005859}, {
   0.8196577072143555, 0.8196577072143555}, {0.841534423828125, 
   0.841534423828125}, {0.8571605682373047, 0.8571605682373047}, {
   0.869661521911621, 0.869661521911621}, {0.8977887153625488, 
   0.8977887153625488}, {0.9102896690368653, 0.9102896690368653}, {
   0.9259158134460449, 0.9259158134460449}, {0.9384167671203614, 
   0.9384167671203614}, {0.9509177207946777, 0.9509177207946777}, {
   0.9759197235107422, 0.9759197235107422}, {0.000921630859375, 
   0.000921630859375}, {0.02279834747314453, 0.02279834747314453}, {
   0.03842449188232422, 0.03842449188232422}, {0.05092544555664062, 
   0.05092544555664062}, {0.06655168533325195, 0.06655168533325195}, {
   0.08530311584472657, 0.08530311584472657}, {0.10717973709106446`, 
   0.10717973709106446`}, {0.11968069076538086`, 0.11968069076538086`}, {
   0.13218164443969727`, 0.13218164443969727`}, {0.1446826934814453, 
   0.1446826934814453}, {0.16655941009521485`, 0.16655941009521485`}, {
   0.1884359359741211, 0.1884359359741211}, {0.20406227111816405`, 
   0.20406227111816405`}, {0.21656322479248047`, 0.21656322479248047`}, {
   0.23218936920166017`, 0.23218936920166017`}, {0.24469032287597656`, 
   0.24469032287597656`}, {0.2665670394897461, 0.2665670394897461}, {
   0.2946941375732422, 0.2946941375732422}, {0.3071950912475586, 
   0.3071950912475586}, {0.32282133102416993`, 0.32282133102416993`}, {
   0.33532228469848635`, 0.33532228469848635`}, {0.35719890594482423`, 
   0.35719890594482423`}, {0.37282524108886717`, 0.37282524108886717`}, {
   0.38845138549804686`, 0.38845138549804686`}, {0.40407752990722656`, 
   0.40407752990722656`}, {0.416578483581543, 0.416578483581543}, {
   0.4322047233581543, 0.4322047233581543}, {0.4447056770324707, 
   0.4447056770324707}, {0.4634571075439453, 0.4634571075439453}, {
   0.47908334732055663`, 0.47908334732055663`}, {0.5040852546691894, 
   0.5040852546691894}, {0.5290871620178222, 0.5290871620178222}, {
   0.5540891647338867, 0.5540891647338867}, {0.5634647369384765, 
   0.5634647369384765}, {0.5790910720825195, 0.5790910720825195}, {
   0.5915920257568359, 0.5915920257568359}, {0.6103433609008789, 
   0.6103433609008789}, {0.6228443145751953, 0.6228443145751953}, {
   0.6384705543518067, 0.6384705543518067}, {0.650971508026123, 
   0.650971508026123}, {0.6665977478027344, 0.6665977478027344}, {
   0.6947248458862305, 0.6947248458862305}, {0.7166015625, 0.7166015625}, {
   0.7322277069091797, 0.7322277069091797}, {0.7478540420532227, 
   0.7478540420532227}, {0.7728559494018554, 0.7728559494018554}, {
   0.7978578567504883, 0.7978578567504883}, {0.813484001159668, 
   0.813484001159668}, {0.8259849548339844, 0.8259849548339844}, {
   0.844736385345459, 0.844736385345459}, {0.8572373390197754, 
   0.8572373390197754}, {0.8728635787963868, 0.8728635787963868}, {
   0.910366439819336, 0.910366439819336}, {0.9353683471679688, 
   0.9353683471679688}, {0.9509944915771484, 0.9509944915771484}, {
   0.9634954452514648, 0.9634954452514648}, {0.9791217803955078, 
   0.9791217803955078}, {0.9916227340698243, 0.9916227340698243}, {
   0.01349935531616211, 0.01349935531616211}, {0.03225078582763672, 
   0.03225078582763672}, {0.044751739501953124`, 0.044751739501953124`}, {
   0.057252693176269534`, 0.057252693176269534`}, {0.08225460052490234, 
   0.08225460052490234}, {0.113507080078125, 0.113507080078125}, {
   0.12288284301757812`, 0.12288284301757812`}, {0.1416341781616211, 
   0.1416341781616211}, {0.1666360855102539, 0.1666360855102539}, {
   0.19163799285888672`, 0.19163799285888672`}, {0.20726423263549804`, 
   0.20726423263549804`}, {0.21976518630981445`, 0.21976518630981445`}, {
   0.24164190292358398`, 0.24164190292358398`}, {0.2635185241699219, 
   0.2635185241699219}, {0.2853952407836914, 0.2853952407836914}, {
   0.3166477203369141, 0.3166477203369141}, {0.3260232925415039, 
   0.3260232925415039}, {0.34164962768554685`, 0.34164962768554685`}, {
   0.35415058135986327`, 0.35415058135986327`}, {0.36977672576904297`, 
   0.36977672576904297`}, {0.3822776794433594, 0.3822776794433594}, {
   0.3979039192199707, 0.3979039192199707}, {0.42290582656860354`, 
   0.42290582656860354`}, {0.432281494140625, 0.432281494140625}, {
   0.45415821075439455`, 0.45415821075439455`}, {0.4697843551635742, 
   0.4697843551635742}, {0.4979116439819336, 0.4979116439819336}, {
   0.5166629791259766, 0.5166629791259766}, {0.5322891235351562, 
   0.5322891235351562}, {0.5447900772094727, 0.5447900772094727}, {
   0.5604164123535156, 0.5604164123535156}, {0.5854183197021484, 
   0.5854183197021484}, {0.6010444641113282, 0.6010444641113282}, {
   0.6135454177856445, 0.6135454177856445}, {0.6322968482971192, 
   0.6322968482971192}, {0.6447978019714355, 0.6447978019714355}, {
   0.6604240417480469, 0.6604240417480469}, {0.6760501861572266, 
   0.6760501861572266}, {0.7073026657104492, 0.7073026657104492}, {
   0.7291793823242188, 0.7291793823242188}, {0.7541812896728516, 
   0.7541812896728516}, {0.7698074340820312, 0.7698074340820312}, {
   0.7823083877563477, 0.7823083877563477}, {0.8010598182678222, 
   0.8010598182678222}, {0.8135607719421387, 0.8135607719421387}, {
   0.8260617256164551, 0.8260617256164551}, {0.8385626792907714, 
   0.8385626792907714}, {0.8604394912719726, 0.8604394912719726}, {
   0.8823160171508789, 0.8823160171508789}, {0.9104433059692383, 
   0.9104433059692383}, {0.9229442596435546, 0.9229442596435546}, {
   0.9448208808898926, 0.9448208808898926}, {0.9698227882385254, 
   0.9698227882385254}, {0.9854490280151367, 0.9854490280151367}, {
   0.9979499816894531, 0.9979499816894531}, {0.013576126098632813`, 
   0.013576126098632813`}, {0.026077079772949218`, 0.026077079772949218`}, {
   0.044828605651855466`, 0.044828605651855466`}, {0.06045475006103516, 
   0.06045475006103516}, {0.07920627593994141, 0.07920627593994141}, {
   0.10420818328857422`, 0.10420818328857422`}, {0.1260848045349121, 
   0.1260848045349121}, {0.14796152114868164`, 0.14796152114868164`}, {
   0.16671295166015626`, 0.16671295166015626`}, {0.18233909606933593`, 
   0.18233909606933593`}, {0.19796533584594728`, 0.19796533584594728`}, {
   0.22296724319458008`, 0.22296724319458008`}, {0.24796924591064454`, 
   0.24796924591064454`}, {0.2635953903198242, 0.2635953903198242}, {
   0.28547210693359376`, 0.28547210693359376`}, {0.30422344207763674`, 
   0.30422344207763674`}, {0.3167243957519531, 0.3167243957519531}, {
   0.3323506355285645, 0.3323506355285645}, {0.35735254287719725`, 
   0.35735254287719725`}, {0.3667283058166504, 0.3667283058166504}, {
   0.385479736328125, 0.385479736328125}, {0.3979806900024414, 
   0.3979806900024414}, {0.4136068344116211, 0.4136068344116211}, {
   0.4261077880859375, 0.4261077880859375}, {0.44173412322998046`, 
   0.44173412322998046`}, {0.4542350769042969, 0.4542350769042969}, {
   0.4698612213134766, 0.4698612213134766}, {0.49798831939697263`, 
   0.49798831939697263`}, {0.5229903221130371, 0.5229903221130371}, {
   0.544866943359375, 0.544866943359375}, {0.5573678970336914, 
   0.5573678970336914}, {0.576119327545166, 0.576119327545166}, {
   0.5886202812194824, 0.5886202812194824}, {0.6042465209960938, 
   0.6042465209960938}, {0.6167474746704101, 0.6167474746704101}, {
   0.6354990005493164, 0.6354990005493164}, {0.6479999542236328, 
   0.6479999542236328}, {0.6636260986328125, 0.6636260986328125}, {
   0.6855028152465821, 0.6855028152465821}, {0.7042542457580566, 
   0.7042542457580566}, {0.7136299133300781, 0.7136299133300781}, {
   0.7323813438415527, 0.7323813438415527}, {0.7448822975158691, 
   0.7448822975158691}, {0.7605085372924805, 0.7605085372924805}, {
   0.7886356353759766, 0.7886356353759766}, {0.801136589050293, 
   0.801136589050293}, {0.8167629241943359, 0.8167629241943359}, {
   0.8292638778686523, 0.8292638778686523}, {0.844890022277832, 
   0.844890022277832}, {0.8698919296264649, 0.8698919296264649}, {
   0.9042695999145508, 0.9042695999145508}, {0.9167705535888672, 
   0.9167705535888672}, {0.9386471748352051, 0.9386471748352051}, {
   0.9636490821838379, 0.9636490821838379}, {0.9886510848999024, 
   0.9886510848999024}, {0.013652992248535157`, 0.013652992248535157`}, {
   0.026153945922851564`, 0.026153945922851564`}, {0.04178009033203125, 
   0.04178009033203125}, {0.06365680694580078, 0.06365680694580078}, {
   0.0824082374572754, 0.0824082374572754}, {0.1074101448059082, 
   0.1074101448059082}, {0.1199110984802246, 0.1199110984802246}, {
   0.13553733825683595`, 0.13553733825683595`}, {0.14803829193115234`, 
   0.14803829193115234`}, {0.16366443634033204`, 0.16366443634033204`}, {
   0.17616539001464843`, 0.17616539001464843`}, {0.19179172515869142`, 
   0.19179172515869142`}, {0.21679363250732422`, 0.21679363250732422`}, {
   0.24179553985595703`, 0.24179553985595703`}, {0.2511711120605469, 
   0.2511711120605469}, {0.26679744720458987`, 0.26679744720458987`}, {
   0.2980498313903809, 0.2980498313903809}, {0.31055078506469724`, 
   0.31055078506469724`}, {0.32617692947387694`, 0.32617692947387694`}, {
   0.3511789321899414, 0.3511789321899414}, {0.3636798858642578, 
   0.3636798858642578}, {0.3793060302734375, 0.3793060302734375}, {
   0.39180698394775393`, 0.39180698394775393`}, {0.40743312835693357`, 
   0.40743312835693357`}, {0.42305946350097656`, 0.42305946350097656`}, {
   0.43868560791015626`, 0.43868560791015626`}, {0.4511865615844727, 
   0.4511865615844727}, {0.466812801361084, 0.466812801361084}, {
   0.498065185546875, 0.498065185546875}, {0.5105661392211914, 
   0.5105661392211914}, {0.5261922836303711, 0.5261922836303711}, {
   0.5511941909790039, 0.5511941909790039}, {0.5730709075927735, 
   0.5730709075927735}, {0.5918224334716797, 0.5918224334716797}, {
   0.6043233871459961, 0.6043233871459961}, {0.623074722290039, 
   0.623074722290039}, {0.6355756759643555, 0.6355756759643555}, {
   0.6512019157409668, 0.6512019157409668}, {0.6637028694152832, 
   0.6637028694152832}, {0.6824542999267578, 0.6824542999267578}, {
   0.7043310165405273, 0.7043310165405273}, {0.723082447052002, 
   0.723082447052002}, {0.7355834007263183, 0.7355834007263183}, {
   0.7480844497680664, 0.7480844497680664}, {0.7730863571166993, 
   0.7730863571166993}, {0.798088264465332, 0.798088264465332}, {
   0.8137144088745117, 0.8137144088745117}, {0.8262153625488281, 
   0.8262153625488281}, {0.8418416023254395, 0.8418416023254395}, {
   0.8543425559997558, 0.8543425559997558}, {0.882469654083252, 
   0.882469654083252}, {0.9043463706970215, 0.9043463706970215}, {
   0.9199726104736328, 0.9199726104736328}, {0.9355987548828125, 
   0.9355987548828125}, {0.9480997085571289, 0.9480997085571289}, {
   0.9699764251708984, 0.9699764251708984}, {0.9856025695800781, 
   0.9856025695800781}, {0.9981035232543946, 0.9981035232543946}, {
   0.019980239868164062`, 0.019980239868164062`}, {0.03873167037963867, 
   0.03873167037963867}, {0.05123262405395508, 0.05123262405395508}, {
   0.06685886383056641, 0.06685886383056641}, {0.07935981750488282, 
   0.07935981750488282}, {0.1074869155883789, 0.1074869155883789}, {
   0.11998786926269531`, 0.11998786926269531`}, {0.13561420440673827`, 
   0.13561420440673827`}, {0.1481151580810547, 0.1481151580810547}, {
   0.16374130249023439`, 0.16374130249023439`}, {0.1887432098388672, 
   0.1887432098388672}, {0.21061992645263672`, 0.21061992645263672`}, {
   0.22312088012695314`, 0.22312088012695314`}, {0.2387470245361328, 
   0.2387470245361328}, {0.2512479782104492, 0.2512479782104492}, {
   0.26999940872192385`, 0.26999940872192385`}, {0.2825003623962402, 
   0.2825003623962402}, {0.30750236511230467`, 0.30750236511230467`}, {
   0.3200033187866211, 0.3200033187866211}, {0.34188003540039064`, 
   0.34188003540039064`}, {0.35750617980957033`, 0.35750617980957033`}, {
   0.3700071334838867, 0.3700071334838867}, {0.3856332778930664, 
   0.3856332778930664}, {0.3981342315673828, 0.3981342315673828}, {
   0.42001094818115237`, 0.42001094818115237`}, {0.44188766479492186`, 
   0.44188766479492186`}, {0.45751380920410156`, 0.45751380920410156`}, {
   0.4793905258178711, 0.4793905258178711}, {0.504392433166504, 
   0.504392433166504}, {0.5168933868408203, 0.5168933868408203}, {
   0.53251953125, 0.53251953125}, {0.5450204849243164, 0.5450204849243164}, {
   0.5606468200683594, 0.5606468200683594}, {0.5731477737426758, 
   0.5731477737426758}, {0.5887739181518554, 0.5887739181518554}, {
   0.6012748718261719, 0.6012748718261719}, {0.6231515884399415, 
   0.6231515884399415}, {0.6450282096862793, 0.6450282096862793}, {
   0.6700302124023437, 0.6700302124023437}, {0.6825311660766602, 
   0.6825311660766602}, {0.7075330734252929, 0.7075330734252929}, {
   0.7200340270996094, 0.7200340270996094}, {0.735660171508789, 
   0.735660171508789}, {0.7481611251831055, 0.7481611251831055}, {
   0.7669126510620117, 0.7669126510620117}, {0.7794136047363281, 
   0.7794136047363281}, {0.7950397491455078, 0.7950397491455078}, {
   0.8075407028198243, 0.8075407028198243}, {0.8231669425964355, 
   0.8231669425964355}, {0.835667896270752, 0.835667896270752}, {
   0.8512940406799316, 0.8512940406799316}, {0.8637950897216797, 
   0.8637950897216797}, {0.8856718063354492, 0.8856718063354492}, {
   0.9137989044189453, 0.9137989044189453}, {0.9262998580932618, 
   0.9262998580932618}, {0.9419260025024414, 0.9419260025024414}, {
   0.9544269561767578, 0.9544269561767578}, {0.9700531959533691, 
   0.9700531959533691}, {0.9825541496276855, 0.9825541496276855}, {
   0.9981803894042969, 0.9981803894042969}, {0.02318229675292969, 
   0.02318229675292969}, {0.03568325042724609, 0.03568325042724609}, {
   0.054434680938720705`, 0.054434680938720705`}, {0.06693572998046875, 
   0.06693572998046875}, {0.08568706512451171, 0.08568706512451171}, {
   0.12006473541259766`, 0.12006473541259766`}, {0.13256568908691407`, 
   0.13256568908691407`}, {0.14819183349609374`, 0.14819183349609374`}, {
   0.1606928825378418, 0.1606928825378418}, {0.1794443130493164, 
   0.1794443130493164}, {0.19194526672363282`, 0.19194526672363282`}, {
   0.2075714111328125, 0.2075714111328125}, {0.2200723648071289, 
   0.2200723648071289}, {0.23569860458374023`, 0.23569860458374023`}, {
   0.2481996536254883, 0.2481996536254883}, {0.263825798034668, 
   0.263825798034668}, {0.2825771331787109, 0.2825771331787109}, {
   0.30445384979248047`, 0.30445384979248047`}, {0.3325810432434082, 
   0.3325810432434082}, {0.35445775985717776`, 0.35445775985717776`}, {
   0.37320919036865235`, 0.37320919036865235`}, {0.38571014404296877`, 
   0.38571014404296877`}, {0.4013362884521484, 0.4013362884521484}, {
   0.42633819580078125`, 0.42633819580078125`}, {0.4357139587402344, 
   0.4357139587402344}, {0.4544654846191406, 0.4544654846191406}, {
   0.466966438293457, 0.466966438293457}, {0.4857177734375, 
   0.4857177734375}, {0.5107196807861328, 0.5107196807861328}, {
   0.5357216835021973, 0.5357216835021973}, {0.5607235908508301, 
   0.5607235908508301}, {0.5794750213623047, 0.5794750213623047}, {
   0.5919759750366211, 0.5919759750366211}, {0.6076021194458008, 
   0.6076021194458008}, {0.6201030731201171, 0.6201030731201171}, {
   0.6357294082641601, 0.6357294082641601}, {0.660731315612793, 
   0.660731315612793}, {0.6701068878173828, 0.6701068878173828}, {
   0.7044845581054687, 0.7044845581054687}, {0.7294865608215332, 
   0.7294865608215332}, {0.754488468170166, 0.754488468170166}, {
   0.776365089416504, 0.776365089416504}, {0.7888660430908203, 
   0.7888660430908203}, {0.8076175689697266, 0.8076175689697266}, {
   0.8326194763183594, 0.8326194763183594}, {0.8513708114624023, 
   0.8513708114624023}, {0.8638717651367187, 0.8638717651367187}, {
   0.8919990539550782, 0.8919990539550782}, {0.9201261520385742, 
   0.9201261520385742}, {0.9326271057128906, 0.9326271057128906}, {
   0.9513785362243652, 0.9513785362243652}, {0.9638794898986817, 
   0.9638794898986817}, {0.9795057296752929, 0.9795057296752929}, {
   0.004507637023925782, 0.004507637023925782}, {0.026384353637695312`, 
   0.026384353637695312`}, {0.04513568878173828, 0.04513568878173828}, {
   0.0701375961303711, 0.0701375961303711}, {0.09826488494873047, 
   0.09826488494873047}, {0.11389102935791015`, 0.11389102935791015`}, {
   0.13889293670654296`, 0.13889293670654296`}, {0.15139389038085938`, 
   0.15139389038085938`}, {0.1670201301574707, 0.1670201301574707}, {
   0.1795210838317871, 0.1795210838317871}, {0.19514732360839843`, 
   0.19514732360839843`}, {0.22014923095703126`, 0.22014923095703126`}, {
   0.24515113830566407`, 0.24515113830566407`}, {0.26077728271484374`, 
   0.26077728271484374`}, {0.27640352249145506`, 0.27640352249145506`}, {
   0.3014054298400879, 0.3014054298400879}, {0.3139063835144043, 
   0.3139063835144043}, {0.3295326232910156, 0.3295326232910156}, {
   0.34203357696533204`, 0.34203357696533204`}, {0.35765972137451174`, 
   0.35765972137451174`}, {0.3701606750488281, 0.3701606750488281}, {
   0.3857870101928711, 0.3857870101928711}, {0.4014131546020508, 
   0.4014131546020508}, {0.4170392990112305, 0.4170392990112305}, {
   0.44204120635986327`, 0.44204120635986327`}, {0.4514169692993164, 
   0.4514169692993164}, {0.4670431137084961, 0.4670431137084961}, {
   0.49517030715942384`, 0.49517030715942384`}, {0.5107965469360352, 
   0.5107965469360352}, {0.5264226913452148, 0.5264226913452148}, {
   0.5514245986938476, 0.5514245986938476}, {0.5701761245727539, 
   0.5701761245727539}, {0.5826770782470703, 0.5826770782470703}, {
   0.6014284133911133, 0.6014284133911133}, {0.6139293670654297, 
   0.6139293670654297}, {0.6295557022094727, 0.6295557022094727}, {
   0.6545576095581055, 0.6545576095581055}, {0.6826847076416016, 
   0.6826847076416016}, {0.7139370918273926, 0.7139370918273926}, {
   0.726438045501709, 0.726438045501709}, {0.7451894760131836, 
   0.7451894760131836}, {0.7576904296875, 0.7576904296875}, {
   0.7764419555664063, 0.7764419555664063}, {0.7889429092407226, 
   0.7889429092407226}, {0.8076942443847657, 0.8076942443847657}, {
   0.820195198059082, 0.820195198059082}, {0.835821533203125, 
   0.835821533203125}, {0.8483224868774414, 0.8483224868774414}, {
   0.8639486312866211, 0.8639486312866211}, {0.898326301574707, 
   0.898326301574707}, {0.9233282089233399, 0.9233282089233399}, {
   0.9420796394348144, 0.9420796394348144}, {0.9670816421508789, 
   0.9670816421508789}, {0.9827077865600586, 0.9827077865600586}, {
   0.995208740234375, 0.995208740234375}, {0.010834884643554688`, 
   0.010834884643554688`}, {0.0358367919921875, 0.0358367919921875}, {
   0.06083879470825195, 0.06083879470825195}, {0.07959022521972656, 
   0.07959022521972656}, {0.10459213256835938`, 0.10459213256835938`}, {
   0.1295940399169922, 0.1295940399169922}, {0.1420949935913086, 
   0.1420949935913086}, {0.16397171020507811`, 0.16397171020507811`}, {
   0.18897361755371095`, 0.18897361755371095`}, {0.20147457122802734`, 
   0.20147457122802734`}, {0.21710071563720704`, 0.21710071563720704`}, {
   0.23272695541381835`, 0.23272695541381835`}, {0.2483531951904297, 
   0.2483531951904297}, {0.2608541488647461, 0.2608541488647461}, {
   0.2889812469482422, 0.2889812469482422}, {0.313983154296875, 
   0.313983154296875}, {0.32648410797119143`, 0.32648410797119143`}, {
   0.34523563385009765`, 0.34523563385009765`}, {0.35773658752441406`, 
   0.35773658752441406`}, {0.37648792266845704`, 0.37648792266845704`}, {
   0.38898887634277346`, 0.38898887634277346`}, {0.4077404022216797, 
   0.4077404022216797}, {0.423366641998291, 0.423366641998291}, {
   0.4389927864074707, 0.4389927864074707}, {0.4514937400817871, 
   0.4514937400817871}, {0.4702451705932617, 0.4702451705932617}, {
   0.4889966011047363, 0.4889966011047363}, {0.5108734130859375, 
   0.5108734130859375}, {0.5358753204345703, 0.5358753204345703}, {
   0.5483762741088867, 0.5483762741088867}, {0.5671276092529297, 
   0.5671276092529297}, {0.5921295166015625, 0.5921295166015625}, {
   0.6046305656433105, 0.6046305656433105}, {0.6233819961547852, 
   0.6233819961547852}, {0.6358829498291015, 0.6358829498291015}, {
   0.6546343803405762, 0.6546343803405762}, {0.6671353340148926, 
   0.6671353340148926}, {0.6952625274658203, 0.6952625274658203}, {
   0.7077634811401368, 0.7077634811401368}, {0.7265148162841797, 
   0.7265148162841797}, {0.739015769958496, 0.739015769958496}, {
   0.754642105102539, 0.754642105102539}, {0.7796440124511719, 
   0.7796440124511719}, {0.8046459197998047, 0.8046459197998047}, {
   0.8265225410461425, 0.8265225410461425}, {0.8421487808227539, 
   0.8421487808227539}, {0.8671506881713867, 0.8671506881713867}, {
   0.8952777862548829, 0.8952777862548829}, {0.9202796936035156, 
   0.9202796936035156}, {0.932780647277832, 0.932780647277832}, {
   0.948406982421875, 0.948406982421875}, {0.9734088897705078, 
   0.9734088897705078}, {0.9984107971191406, 0.9984107971191406}, {
   0.023412704467773438`, 0.023412704467773438`}, {0.03591365814208984, 
   0.03591365814208984}, {0.05466508865356445, 0.05466508865356445}, {
   0.09216804504394531, 0.09216804504394531}, {0.11716995239257813`, 
   0.11716995239257813`}, {0.12967090606689452`, 0.12967090606689452`}, {
   0.14529705047607422`, 0.14529705047607422`}, {0.17029895782470703`, 
   0.17029895782470703`}, {0.19530086517333983`, 0.19530086517333983`}, {
   0.21405229568481446`, 0.21405229568481446`}, {0.22655324935913085`, 
   0.22655324935913085`}, {0.2484299659729004, 0.2484299659729004}, {
   0.267181396484375, 0.267181396484375}, {0.2953084945678711, 
   0.2953084945678711}, {0.3078094482421875, 0.3078094482421875}, {
   0.32343578338623047`, 0.32343578338623047`}, {0.3484376907348633, 
   0.3484376907348633}, {0.3734395980834961, 0.3734395980834961}, {
   0.3890657424926758, 0.3890657424926758}, {0.4140676498413086, 
   0.4140676498413086}, {0.4390695571899414, 0.4390695571899414}, {
   0.46407146453857423`, 0.46407146453857423`}, {0.4921987533569336, 
   0.4921987533569336}, {0.5172006607055664, 0.5172006607055664}, {
   0.5422025680541992, 0.5422025680541992}, {0.557828712463379, 
   0.557828712463379}, {0.5734549522399902, 0.5734549522399902}, {
   0.58908109664917, 0.58908109664917}, {0.6140830039978027, 
   0.6140830039978027}, {0.6234587669372559, 0.6234587669372559}, {
   0.6422101974487304, 0.6422101974487304}, {0.6672121047973633, 
   0.6672121047973633}, {0.682838249206543, 0.682838249206543}, {
   0.7078401565551757, 0.7078401565551757}, {0.7328421592712402, 
   0.7328421592712402}, {0.757844066619873, 0.757844066619873}, {
   0.7734703063964844, 0.7734703063964844}, {0.7859712600708008, 
   0.7859712600708008}, {0.8047226905822754, 0.8047226905822754}, {
   0.8172236442565918, 0.8172236442565918}, {0.8391002655029297, 
   0.8391002655029297}, {0.8609769821166993, 0.8609769821166993}, {
   0.8828536987304687, 0.8828536987304687}, {0.9141060829162597, 
   0.9141060829162597}, {0.9266070365905762, 0.9266070365905762}, {
   0.9422332763671875, 0.9422332763671875}, {0.9547342300415039, 
   0.9547342300415039}, {0.9734856605529785, 0.9734856605529785}, {
   0.9984875679016113, 0.9984875679016113}, {0.010988521575927734`, 
   0.010988521575927734`}, {0.029739952087402342`, 0.029739952087402342`}, {
   0.04224090576171875, 0.04224090576171875}, {0.060992431640625, 
   0.060992431640625}, {0.07661857604980468, 0.07661857604980468}, {
   0.1016204833984375, 0.1016204833984375}, {0.12662239074707032`, 
   0.12662239074707032`}, {0.1391233444213867, 0.1391233444213867}, {
   0.15474958419799806`, 0.15474958419799806`}, {0.17975149154663086`, 
   0.17975149154663086`}, {0.20475349426269532`, 0.20475349426269532`}, {
   0.22663002014160155`, 0.22663002014160155`}, {0.24225635528564454`, 
   0.24225635528564454`}, {0.2672582626342773, 0.2672582626342773}, {
   0.2860095977783203, 0.2860095977783203}, {0.31101160049438475`, 
   0.31101160049438475`}, {0.32351255416870117`, 0.32351255416870117`}, {
   0.33913869857788087`, 0.33913869857788087`}, {0.36414060592651365`, 
   0.36414060592651365`}, {0.3891426086425781, 0.3891426086425781}, {
   0.4016435623168945, 0.4016435623168945}, {0.4235202789306641, 
   0.4235202789306641}, {0.44852218627929685`, 0.44852218627929685`}, {
   0.47977447509765625`, 0.47977447509765625`}, {0.5047764778137207, 
   0.5047764778137207}, {0.5297783851623535, 0.5297783851623535}, {
   0.5547802925109864, 0.5547802925109864}, {0.5797821998596191, 
   0.5797821998596191}, {0.6079093933105468, 0.6079093933105468}, {
   0.6235355377197266, 0.6235355377197266}, {0.636036491394043, 
   0.636036491394043}, {0.6547880172729492, 0.6547880172729492}, {
   0.6891655921936035, 0.6891655921936035}, {0.7141674995422364, 
   0.7141674995422364}, {0.7266684532165527, 0.7266684532165527}, {
   0.7422946929931641, 0.7422946929931641}, {0.7672966003417969, 
   0.7672966003417969}, {0.7922985076904296, 0.7922985076904296}, {
   0.8141752243041992, 0.8141752243041992}, {0.8329265594482422, 
   0.8329265594482422}, {0.8454275131225586, 0.8454275131225586}, {
   0.8641790390014649, 0.8641790390014649}, {0.8798052787780761, 
   0.8798052787780761}, {0.9079323768615722, 0.9079323768615722}, {
   0.9204333305358887, 0.9204333305358887}, {0.9391847610473633, 
   0.9391847610473633}, {0.9516857147216797, 0.9516857147216797}, {
   0.9704372406005859, 0.9704372406005859}, {0.998564338684082, 
   0.998564338684082}, {0.007940101623535156, 0.007940101623535156}, {
   0.023566246032714844`, 0.023566246032714844`}, {0.04856815338134766, 
   0.04856815338134766}, {0.06731967926025391, 0.06731967926025391}, {
   0.0891963005065918, 0.0891963005065918}, {0.11419820785522461`, 
   0.11419820785522461`}, {0.13607492446899414`, 0.13607492446899414`}, {
   0.15482635498046876`, 0.15482635498046876`}, {0.18295345306396485`, 
   0.18295345306396485`}, {0.19232921600341796`, 0.19232921600341796`}, {
   0.21108074188232423`, 0.21108074188232423`}, {0.22358169555664062`, 
   0.22358169555664062`}, {0.23920783996582032`, 0.23920783996582032`}, {
   0.2642097473144531, 0.2642097473144531}, {0.28921165466308596`, 
   0.28921165466308596`}, {0.30796308517456056`, 0.30796308517456056`}, {
   0.3235893249511719, 0.3235893249511719}, {0.3360902786254883, 
   0.3360902786254883}, {0.3579669952392578, 0.3579669952392578}, {
   0.37984371185302734`, 0.37984371185302734`}, {0.4048456192016602, 
   0.4048456192016602}, {0.42984752655029296`, 0.42984752655029296`}, {
   0.45172414779663084`, 0.45172414779663084`}, {0.4704755783081055, 
   0.4704755783081055}, {0.4861018180847168, 0.4861018180847168}, {
   0.5079784393310547, 0.5079784393310547}, {0.5329803466796875, 
   0.5329803466796875}, {0.5579822540283204, 0.5579822540283204}, {
   0.5704832077026367, 0.5704832077026367}, {0.5861095428466797, 
   0.5861095428466797}, {0.6111114501953125, 0.6111114501953125}, {
   0.6361133575439453, 0.6361133575439453}, {0.6611152648925781, 
   0.6611152648925781}, {0.6798666954040528, 0.6798666954040528}, {
   0.7017433166503906, 0.7017433166503906}, {0.714244270324707, 
   0.714244270324707}, {0.7329957962036133, 0.7329957962036133}, {
   0.7454967498779297, 0.7454967498779297}, {0.7642480850219726, 
   0.7642480850219726}, {0.7767490386962891, 0.7767490386962891}, {
   0.7955005645751954, 0.7955005645751954}, {0.8205024719238281, 
   0.8205024719238281}, {0.8455043792724609, 0.8455043792724609}, {
   0.8642558097839356, 0.8642558097839356}, {0.8861325263977051, 
   0.8861325263977051}, {0.908009147644043, 0.908009147644043}, {
   0.9330110549926758, 0.9330110549926758}, {0.9580129623413086, 
   0.9580129623413086}, {0.9830149650573731, 0.9830149650573731}, {
   0.9986412048339843, 0.9986412048339843}, {0.011142158508300781`, 
   0.011142158508300781`}, {0.036144065856933597`, 0.036144065856933597`}, {
   0.05177021026611328, 0.05177021026611328}, {0.07989740371704102, 
   0.07989740371704102}, {0.11114978790283203`, 0.11114978790283203`}, {
   0.12365074157714843`, 0.12365074157714843`}, {0.1424022674560547, 
   0.1424022674560547}, {0.15490322113037108`, 0.15490322113037108`}, {
   0.17365455627441406`, 0.17365455627441406`}, {0.1861556053161621, 
   0.1861556053161621}, {0.20490703582763672`, 0.20490703582763672`}, {
   0.22990894317626953`, 0.22990894317626953`}, {0.25803604125976565`, 
   0.25803604125976565`}, {0.29241371154785156`, 0.29241371154785156`}, {
   0.3174156188964844, 0.3174156188964844}, {0.3424175262451172, 
   0.3424175262451172}, {0.36741943359375, 0.36741943359375}, {
   0.39242143630981446`, 0.39242143630981446`}, {0.40804758071899416`, 
   0.40804758071899416`}, {0.4361747741699219, 0.4361747741699219}, {
   0.44867572784423826`, 0.44867572784423826`}, {0.46430187225341796`, 
   0.46430187225341796`}, {0.48305339813232423`, 0.48305339813232423`}, {
   0.5049301147460937, 0.5049301147460937}, {0.5299320220947266, 
   0.5299320220947266}, {0.5424329757690429, 0.5424329757690429}, {
   0.5580591201782227, 0.5580591201782227}, {0.570560073852539, 
   0.570560073852539}, {0.5893115043640137, 0.5893115043640137}, {
   0.6018124580383301, 0.6018124580383301}, {0.6205638885498047, 
   0.6205638885498047}, {0.6455657958984375, 0.6455657958984375}, {
   0.6736930847167969, 0.6736930847167969}, {0.7080705642700196, 
   0.7080705642700196}, {0.7330724716186523, 0.7330724716186523}, {
   0.7486988067626953, 0.7486988067626953}, {0.7737007141113281, 
   0.7737007141113281}, {0.7862016677856445, 0.7862016677856445}, {
   0.8018278121948242, 0.8018278121948242}, {0.8268297195434571, 
   0.8268297195434571}, {0.8518316268920898, 0.8518316268920898}, {
   0.8830841064453125, 0.8830841064453125}, {0.9112112045288085, 
   0.9112112045288085}, {0.923712158203125, 0.923712158203125}, {
   0.9424636840820313, 0.9424636840820313}, {0.967465591430664, 
   0.967465591430664}, {0.9924674987792969, 0.9924674987792969}, {
   0.017469406127929688`, 0.017469406127929688`}, {0.03309555053710937, 
   0.03309555053710937}, {0.058097457885742186`, 0.058097457885742186`}, {
   0.09247512817382812, 0.09247512817382812}, {0.11747703552246094`, 
   0.11747703552246094`}, {0.1362285614013672, 0.1362285614013672}, {
   0.16123046875, 0.16123046875}, {0.1862323760986328, 0.1862323760986328}, {
   0.21435947418212892`, 0.21435947418212892`}, {0.23936138153076172`, 
   0.23936138153076172`}, {0.25811290740966797`, 0.25811290740966797`}, {
   0.27686424255371095`, 0.27686424255371095`}, {0.3081167221069336, 
   0.3081167221069336}, {0.3331186294555664, 0.3331186294555664}, {
   0.34874486923217773`, 0.34874486923217773`}, {0.36437101364135743`, 
   0.36437101364135743`}, {0.38624773025512693`, 0.38624773025512693`}, {
   0.4049991607666016, 0.4049991607666016}, {0.43000106811523436`, 
   0.43000106811523436`}, {0.4393768310546875, 0.4393768310546875}, {
   0.46437873840332033`, 0.46437873840332033`}, {0.4800048828125, 
   0.4800048828125}, {0.5081320762634277, 0.5081320762634277}, {
   0.5362592697143554, 0.5362592697143554}, {0.5612611770629883, 
   0.5612611770629883}, {0.5862630844116211, 0.5862630844116211}, {
   0.611264991760254, 0.611264991760254}, {0.6362668991088867, 
   0.6362668991088867}, {0.6643939971923828, 0.6643939971923828}, {
   0.6831455230712891, 0.6831455230712891}, {0.7081474304199219, 
   0.7081474304199219}, {0.7331493377685547, 0.7331493377685547}, {
   0.7581512451171875, 0.7581512451171875}, {0.7706521987915039, 
   0.7706521987915039}, {0.7894037246704102, 0.7894037246704102}, {
   0.8019046783447266, 0.8019046783447266}, {0.8175308227539062, 
   0.8175308227539062}, {0.842532730102539, 0.842532730102539}, {
   0.8675346374511719, 0.8675346374511719}, {0.8862861633300781, 
   0.8862861633300781}, {0.908162784576416, 0.908162784576416}, {
   0.9331646919250488, 0.9331646919250488}, {0.9487909317016602, 
   0.9487909317016602}, {0.973792839050293, 0.973792839050293}, {
   0.9862937927246094, 0.9862937927246094}, {0.005045318603515625, 
   0.005045318603515625}, {0.030047225952148437`, 0.030047225952148437`}, {
   0.05504913330078125, 0.05504913330078125}, {0.08317623138427735, 
   0.08317623138427735}, {0.10505294799804688`, 0.10505294799804688`}, {
   0.12067909240722656`, 0.12067909240722656`}, {0.14568099975585938`, 
   0.14568099975585938`}, {0.17380828857421876`, 0.17380828857421876`}, {
   0.1925596237182617, 0.1925596237182617}, {0.21756153106689452`, 
   0.21756153106689452`}, {0.23006248474121094`, 0.23006248474121094`}, {
   0.24881401062011718`, 0.24881401062011718`}, {0.27381591796875, 
   0.27381591796875}, {0.31131877899169924`, 0.31131877899169924`}, {
   0.336320686340332, 0.336320686340332}, {0.36132259368896485`, 
   0.36132259368896485`}, {0.38632450103759763`, 0.38632450103759763`}, {
   0.41132640838623047`, 0.41132640838623047`}, {0.4363283157348633, 
   0.4363283157348633}, {0.4550798416137695, 0.4550798416137695}, {
   0.48320693969726564`, 0.48320693969726564`}, {0.5144593238830566, 
   0.5144593238830566}, {0.539461326599121, 0.539461326599121}, {
   0.5644632339477539, 0.5644632339477539}, {0.5894651412963867, 
   0.5894651412963867}, {0.6082164764404296, 0.6082164764404296}, {
   0.6332184791564941, 0.6332184791564941}, {0.6613456726074218, 
   0.6613456726074218}, {0.6769718170166016, 0.6769718170166016}, {
   0.7019737243652344, 0.7019737243652344}, {0.7269756317138671, 
   0.7269756317138671}, {0.7519775390625, 0.7519775390625}, {
   0.7769794464111328, 0.7769794464111328}, {0.8019813537597656, 
   0.8019813537597656}, {0.8269833564758301, 0.8269833564758301}, {
   0.8457347869873046, 0.8457347869873046}, {0.8582357406616211, 
   0.8582357406616211}, {0.8894881248474121, 0.8894881248474121}, {
   0.9144901275634766, 0.9144901275634766}, {0.9394920349121094, 
   0.9394920349121094}, {0.9644939422607421, 0.9644939422607421}, {
   0.9926210403442383, 0.9926210403442383}, {0.011372566223144531`, 
   0.011372566223144531`}, {0.036374473571777345`, 0.036374473571777345`}, {
   0.06137638092041016, 0.06137638092041016}, {0.09262876510620117, 
   0.09262876510620117}, {0.1082550048828125, 0.1082550048828125}, {
   0.12388114929199219`, 0.12388114929199219`}, {0.148883056640625, 
   0.148883056640625}, {0.17388496398925782`, 0.17388496398925782`}, {
   0.19888696670532227`, 0.19888696670532227`}, {0.21763839721679687`, 
   0.21763839721679687`}, {0.2301393508911133, 0.2301393508911133}, {
   0.2520159721374512, 0.2520159721374512}, {0.277017879486084, 
   0.277017879486084}, {0.3020198822021484, 0.3020198822021484}, {
   0.32702178955078126`, 0.32702178955078126`}, {0.3395227432250977, 
   0.3395227432250977}, {0.3551488876342773, 0.3551488876342773}, {
   0.38015079498291016`, 0.38015079498291016`}, {0.4082779884338379, 
   0.4082779884338379}, {0.43015470504760744`, 0.43015470504760744`}, {
   0.4582818031311035, 0.4582818031311035}, {0.4770332336425781, 
   0.4770332336425781}, {0.5020351409912109, 0.5020351409912109}, {
   0.5270370483398438, 0.5270370483398438}, {0.5551643371582031, 
   0.5551643371582031}, {0.573915672302246, 0.573915672302246}, {
   0.5895419120788574, 0.5895419120788574}, {0.6051681518554688, 
   0.6051681518554688}, {0.6301700592041015, 0.6301700592041015}, {
   0.6551719665527344, 0.6551719665527344}, {0.6832990646362305, 
   0.6832990646362305}, {0.7145515441894531, 0.7145515441894531}, {
   0.7395534515380859, 0.7395534515380859}, {0.7676806449890137, 
   0.7676806449890137}, {0.78018159866333, 0.78018159866333}, {
   0.7958077430725098, 0.7958077430725098}, {0.8208096504211426, 
   0.8208096504211426}, {0.8458116531372071, 0.8458116531372071}, {
   0.8708135604858398, 0.8708135604858398}, {0.8989406585693359, 
   0.8989406585693359}, {0.9176921844482422, 0.9176921844482422}, {
   0.942694091796875, 0.942694091796875}, {0.9614455223083496, 
   0.9614455223083496}, {0.9864474296569824, 0.9864474296569824}, {
   0.9989483833312989, 0.9989483833312989}, {0.017699813842773436`, 
   0.017699813842773436`}, {0.04270172119140625, 0.04270172119140625}, {
   0.055202674865722653`, 0.055202674865722653`}, {0.07395420074462891, 
   0.07395420074462891}, {0.09895610809326172, 0.09895610809326172}, {
   0.11770744323730468`, 0.11770744323730468`}, {0.14270944595336915`, 
   0.14270944595336915`}, {0.16771135330200196`, 0.16771135330200196`}, {
   0.19271326065063477`, 0.19271326065063477`}, {0.2208404541015625, 
   0.2208404541015625}, {0.2458423614501953, 0.2458423614501953}, {
   0.26459369659423826`, 0.26459369659423826`}, {0.28022003173828125`, 
   0.28022003173828125`}, {0.3052219390869141, 0.3052219390869141}, {
   0.32084808349609373`, 0.32084808349609373`}, {0.3364743232727051, 
   0.3364743232727051}, {0.3614762306213379, 0.3614762306213379}, {
   0.3771023750305176, 0.3771023750305176}, {0.3958538055419922, 
   0.3958538055419922}, {0.4083547592163086, 0.4083547592163086}, {
   0.42710628509521487`, 0.42710628509521487`}, {0.43960723876953123`, 
   0.43960723876953123`}, {0.4583585739135742, 0.4583585739135742}, {
   0.4864858627319336, 0.4864858627319336}, {0.5146129608154297, 
   0.5146129608154297}, {0.5396148681640625, 0.5396148681640625}, {
   0.5646167755126953, 0.5646167755126953}, {0.592743968963623, 
   0.592743968963623}, {0.6177459716796875, 0.6177459716796875}, {
   0.630246925354004, 0.630246925354004}, {0.6458730697631836, 
   0.6458730697631836}, {0.6708749771118164, 0.6708749771118164}, {
   0.7083778381347656, 0.7083778381347656}, {0.720878791809082, 
   0.720878791809082}, {0.7396302223205566, 0.7396302223205566}, {
   0.752131175994873, 0.752131175994873}, {0.7740078926086426, 
   0.7740078926086426}, {0.786508846282959, 0.786508846282959}, {
   0.8052602767944336, 0.8052602767944336}, {0.8302621841430664, 
   0.8302621841430664}, {0.8427631378173828, 0.8427631378173828}, {
   0.8646398544311523, 0.8646398544311523}, {0.8802659988403321, 
   0.8802659988403321}, {0.9052680015563965, 0.9052680015563965}, {
   0.9302699089050293, 0.9302699089050293}, {0.9552718162536621, 
   0.9552718162536621}, {0.9802737236022949, 0.9802737236022949}, {
   0.9990251541137696, 0.9990251541137696}, {0.014651298522949219`, 
   0.014651298522949219`}, {0.03027763366699219, 0.03027763366699219}, {
   0.055279541015625, 0.055279541015625}, {0.0896571159362793, 
   0.0896571159362793}, {0.11778430938720703`, 0.11778430938720703`}, {
   0.14591140747070314`, 0.14591140747070314`}, {0.17091331481933594`, 
   0.17091331481933594`}, {0.19279003143310547`, 0.19279003143310547`}, {
   0.21779193878173828`, 0.21779193878173828`}, {0.2302928924560547, 
   0.2302928924560547}, {0.24904441833496094`, 0.24904441833496094`}, {
   0.28654727935791013`, 0.28654727935791013`}, {0.30842390060424807`, 
   0.30842390060424807`}, {0.33342580795288085`, 0.33342580795288085`}, {
   0.3584278106689453, 0.3584278106689453}, {0.38342971801757814`, 
   0.38342971801757814`}, {0.4084316253662109, 0.4084316253662109}, {
   0.42093257904052733`, 0.42093257904052733`}, {0.4396839141845703, 
   0.4396839141845703}, {0.4584354400634766, 0.4584354400634766}, {
   0.4803121566772461, 0.4803121566772461}, {0.4990635871887207, 
   0.4990635871887207}, {0.5178150177001953, 0.5178150177001953}, {
   0.5303159713745117, 0.5303159713745117}, {0.5490674018859864, 
   0.5490674018859864}, {0.5771945953369141, 0.5771945953369141}, {
   0.5896955490112304, 0.5896955490112304}, {0.6084468841552735, 
   0.6084468841552735}, {0.6334487915039062, 0.6334487915039062}, {
   0.6615760803222657, 0.6615760803222657}, {0.6803275108337402, 
   0.6803275108337402}, {0.7022041320800781, 0.7022041320800781}, {
   0.727206039428711, 0.727206039428711}, {0.7522079467773437, 
   0.7522079467773437}, {0.7772098541259765, 0.7772098541259765}, {
   0.789710807800293, 0.789710807800293}, {0.8115875244140625, 
   0.8115875244140625}, {0.8365894317626953, 0.8365894317626953}, {
   0.8615914344787597, 0.8615914344787597}, {0.8803428649902344, 
   0.8803428649902344}, {0.9022194862365722, 0.9022194862365722}, {
   0.9272214889526367, 0.9272214889526367}, {0.9522233963012695, 
   0.9522233963012695}, {0.9772253036499023, 0.9772253036499023}, {
   0.0022272109985351563`, 0.0022272109985351563`}, {0.027229118347167968`, 
   0.027229118347167968`}, {0.05223102569580078, 0.05223102569580078}, {
   0.0834834098815918, 0.0834834098815918}, {0.11161060333251953`, 
   0.11161060333251953`}, {0.1303621292114258, 0.1303621292114258}, {
   0.14598827362060546`, 0.14598827362060546`}, {0.15848922729492188`, 
   0.15848922729492188`}, {0.17724056243896485`, 0.17724056243896485`}, {
   0.2022425651550293, 0.2022425651550293}, {0.22724447250366211`, 
   0.22724447250366211`}, {0.2553716659545898, 0.2553716659545898}, {
   0.26787261962890624`, 0.26787261962890624`}, {0.2897492408752441, 
   0.2897492408752441}, {0.3241270065307617, 0.3241270065307617}, {
   0.3428783416748047, 0.3428783416748047}, {0.3553792953491211, 
   0.3553792953491211}, {0.3741308212280273, 0.3741308212280273}, {
   0.39913272857666016`, 0.39913272857666016`}, {0.424134635925293, 
   0.424134635925293}, {0.44913654327392577`, 0.44913654327392577`}, {
   0.46788797378540037`, 0.46788797378540037`}, {0.5022655487060547, 
   0.5022655487060547}, {0.5147665023803711, 0.5147665023803711}, {
   0.5335180282592773, 0.5335180282592773}, {0.5585199356079101, 
   0.5585199356079101}, {0.5710208892822266, 0.5710208892822266}, {
   0.5897723197937011, 0.5897723197937011}, {0.614774227142334, 
   0.614774227142334}, {0.6397761344909668, 0.6397761344909668}, {
   0.6554023742675781, 0.6554023742675781}, {0.6772790908813476, 
   0.6772790908813476}, {0.7116567611694335, 0.7116567611694335}, {
   0.7366586685180664, 0.7366586685180664}, {0.7616605758666992, 
   0.7616605758666992}, {0.786662483215332, 0.786662483215332}, {
   0.8116643905639649, 0.8116643905639649}, {0.8366662979125976, 
   0.8366662979125976}, {0.8616682052612304, 0.8616682052612304}, {
   0.8804197311401367, 0.8804197311401367}, {0.9054216384887696, 
   0.9054216384887696}, {0.9210477828979492, 0.9210477828979492}, {
   0.9397991180419922, 0.9397991180419922}, {0.9648011207580567, 
   0.9648011207580567}, {0.980427360534668, 0.980427360534668}, {
   0.9960535049438477, 0.9960535049438477}, {0.02105541229248047, 
   0.02105541229248047}, {0.0491826057434082, 0.0491826057434082}, {
   0.07730979919433593, 0.07730979919433593}, {0.10543689727783204`, 
   0.10543689727783204`}, {0.13043880462646484`, 0.13043880462646484`}, {
   0.15544071197509765`, 0.15544071197509765`}, {0.1804427146911621, 
   0.1804427146911621}, {0.19919414520263673`, 0.19919414520263673`}, {
   0.22419605255126954`, 0.22419605255126954`}, {0.24919795989990234`, 
   0.24919795989990234`}, {0.280450439453125, 0.280450439453125}, {
   0.3085775375366211, 0.3085775375366211}, {0.33357944488525393`, 
   0.33357944488525393`}, {0.3585813522338867, 0.3585813522338867}, {
   0.38358325958251954`, 0.38358325958251954`}, {0.4085851669311523, 
   0.4085851669311523}, {0.43358707427978516`, 0.43358707427978516`}, {
   0.458588981628418, 0.458588981628418}, {0.4804656982421875, 
   0.4804656982421875}, {0.5054676055908203, 0.5054676055908203}, {
   0.5304695129394531, 0.5304695129394531}, {0.5585967063903808, 
   0.5585967063903808}, {0.5710976600646973, 0.5710976600646973}, {
   0.5898490905761719, 0.5898490905761719}, {0.6148509979248047, 
   0.6148509979248047}, {0.6398529052734375, 0.6398529052734375}, {
   0.6648548126220704, 0.6648548126220704}, {0.6867315292358398, 
   0.6867315292358398}, {0.7086082458496094, 0.7086082458496094}, {
   0.7211091995239258, 0.7211091995239258}, {0.7398606300354004, 
   0.7398606300354004}, {0.7648625373840332, 0.7648625373840332}, {
   0.789864444732666, 0.789864444732666}, {0.8148664474487305, 
   0.8148664474487305}, {0.8273674011230469, 0.8273674011230469}, {
   0.8461187362670899, 0.8461187362670899}, {0.8742460250854492, 
   0.8742460250854492}, {0.9054983139038086, 0.9054983139038086}, {
   0.9305003166198731, 0.9305003166198731}, {0.9555022239685058, 
   0.9555022239685058}, {0.9805041313171386, 0.9805041313171386}, {
   0.005506134033203125, 0.005506134033203125}, {0.030508041381835938`, 
   0.030508041381835938`}, {0.049259376525878903`, 0.049259376525878903`}, {
   0.06488552093505859, 0.06488552093505859}, {0.08988752365112304, 
   0.08988752365112304}, {0.11176424026489258`, 0.11176424026489258`}, {
   0.1305156707763672, 0.1305156707763672}, {0.155517578125, 
   0.155517578125}, {0.1805194854736328, 0.1805194854736328}, {
   0.2086465835571289, 0.2086465835571289}, {0.2211475372314453, 
   0.2211475372314453}, {0.23989906311035156`, 0.23989906311035156`}, {
   0.26490097045898436`, 0.26490097045898436`}, {0.2961533546447754, 
   0.2961533546447754}, {0.3211552619934082, 0.3211552619934082}, {
   0.34928245544433595`, 0.34928245544433595`}, {0.37428436279296873`, 
   0.37428436279296873`}, {0.393035888671875, 0.393035888671875}, {
   0.411787223815918, 0.411787223815918}, {0.43991432189941404`, 
   0.43991432189941404`}, {0.4649163246154785, 0.4649163246154785}, {
   0.48366775512695315`, 0.48366775512695315`}, {0.508669662475586, 
   0.508669662475586}, {0.5211706161499023, 0.5211706161499023}, {
   0.539922046661377, 0.539922046661377}, {0.5774250030517578, 
   0.5774250030517578}, {0.6024269104003906, 0.6024269104003906}, {
   0.6274288177490235, 0.6274288177490235}, {0.6524307250976562, 
   0.6524307250976562}, {0.6930588722229004, 0.6930588722229004}, {
   0.7180607795715332, 0.7180607795715332}, {0.746187973022461, 
   0.746187973022461}, {0.7649393081665039, 0.7649393081665039}, {
   0.7899412155151367, 0.7899412155151367}, {0.8149431228637696, 
   0.8149431228637696}, {0.8430704116821289, 0.8430704116821289}, {
   0.8618218421936035, 0.8618218421936035}, {0.8805732727050781, 
   0.8805732727050781}, {0.9149508476257324, 0.9149508476257324}, {
   0.9337022781372071, 0.9337022781372071}, {0.9462032318115234, 
   0.9462032318115234}, {0.9649547576904297, 0.9649547576904297}, {
   0.9899566650390625, 0.9899566650390625}, {0.014958572387695313`, 
   0.014958572387695313`}, {0.039960479736328124`, 0.039960479736328124`}, {
   0.06496238708496094, 0.06496238708496094}, {0.09621477127075195, 
   0.09621477127075195}, {0.12746715545654297`, 0.12746715545654297`}, {
   0.13996810913085939`, 0.13996810913085939`}, {0.1618448257446289, 
   0.1618448257446289}, {0.189971923828125, 0.189971923828125}, {
   0.20247287750244142`, 0.20247287750244142`}, {0.22122440338134766`, 
   0.22122440338134766`}, {0.2493515968322754, 0.2493515968322754}, {
   0.2774786949157715, 0.2774786949157715}, {0.31498165130615235`, 
   0.31498165130615235`}, {0.3462339401245117, 0.3462339401245117}, {
   0.36498546600341797`, 0.36498546600341797`}, {0.3899873733520508, 
   0.3899873733520508}, {0.4149892807006836, 0.4149892807006836}, {
   0.427490234375, 0.427490234375}, {0.44936695098876955`, 
   0.44936695098876955`}, {0.4774940490722656, 0.4774940490722656}, {
   0.4962454795837402, 0.4962454795837402}, {0.524372673034668, 
   0.524372673034668}, {0.5493745803833008, 0.5493745803833008}, {
   0.5650007247924804, 0.5650007247924804}, {0.58687744140625, 
   0.58687744140625}, {0.5993783950805665, 0.5993783950805665}, {
   0.6212551116943359, 0.6212551116943359}, {0.6462570190429687, 
   0.6462570190429687}, {0.6712589263916016, 0.6712589263916016}, {
   0.7056365966796875, 0.7056365966796875}, {0.718137550354004, 
   0.718137550354004}, {0.7368890762329101, 0.7368890762329101}, {
   0.7681413650512695, 0.7681413650512695}, {0.780642318725586, 
   0.780642318725586}, {0.7993938446044921, 0.7993938446044921}, {
   0.8275209426879883, 0.8275209426879883}, {0.855648136138916, 
   0.855648136138916}, {0.8900257110595703, 0.8900257110595703}, {
   0.9181529998779296, 0.9181529998779296}, {0.9431549072265625, 
   0.9431549072265625}, {0.9681568145751953, 0.9681568145751953}, {
   0.9931587219238281, 0.9931587219238281}, {0.021285820007324218`, 
   0.021285820007324218`}, {0.049413013458251956`, 0.049413013458251956`}, {
   0.08379058837890625, 0.08379058837890625}, {0.10879249572753906`, 
   0.10879249572753906`}, {0.13379440307617188`, 0.13379440307617188`}, {
   0.15254592895507812`, 0.15254592895507812`}, {0.17442264556884765`, 
   0.17442264556884765`}, {0.19317407608032228`, 0.19317407608032228`}, {
   0.21505069732666016`, 0.21505069732666016`}, {0.24005260467529296`, 
   0.24005260467529296`}, {0.26505451202392577`, 0.26505451202392577`}, {
   0.29630699157714846`, 0.29630699157714846`}, {0.3306846618652344, 
   0.3306846618652344}, {0.34943599700927735`, 0.34943599700927735`}, {
   0.3806884765625, 0.3806884765625}, {0.3931894302368164, 
   0.3931894302368164}, {0.4244418144226074, 0.4244418144226074}, {
   0.5056980133056641, 0.5056980133056641}, {0.5306999206542968, 
   0.5306999206542968}, {0.5588271141052246, 0.5588271141052246}, {
   0.5838290214538574, 0.5838290214538574}, {0.605705738067627, 
   0.605705738067627}, {0.6244571685791016, 0.6244571685791016}, {
   0.6432086944580078, 0.6432086944580078}, {0.6650852203369141, 
   0.6650852203369141}, {0.6807115554809571, 0.6807115554809571}, {
   0.7088386535644531, 0.7088386535644531}, {0.7244647979736328, 
   0.7244647979736328}, {0.7494668006896973, 0.7494668006896973}, {
   0.7682182312011718, 0.7682182312011718}, {0.7932201385498047, 
   0.7932201385498047}, {0.8150967597961426, 0.8150967597961426}, {
   0.8369735717773438, 0.8369735717773438}, {0.85885009765625, 
   0.85885009765625}, {0.8901025772094726, 0.8901025772094726}, {
   0.9151044845581054, 0.9151044845581054}, {0.936981201171875, 
   0.936981201171875}, {0.9557326316833497, 0.9557326316833497}, {
   0.9869850158691407, 0.9869850158691407}, {0.01511211395263672, 
   0.01511211395263672}, {0.03698883056640625, 0.03698883056640625}, {
   0.06199073791503906, 0.06199073791503906}, {0.09324321746826172, 
   0.09324321746826172}, {0.11199455261230469`, 0.11199455261230469`}, {
   0.14949750900268555`, 0.14949750900268555`}, {0.17137413024902343`, 
   0.17137413024902343`}, {0.19325084686279298`, 0.19325084686279298`}, {
   0.21200237274169922`, 0.21200237274169922`}, {0.23387889862060546`, 
   0.23387889862060546`}, {0.25263042449951173`, 0.25263042449951173`}, {
   0.2776323318481445, 0.2776323318481445}, {0.31513519287109376`, 
   0.31513519287109376`}, {0.33388662338256836`, 0.33388662338256836`}, {
   0.3557633399963379, 0.3557633399963379}, {0.3776399612426758, 
   0.3776399612426758}, {0.3995166778564453, 0.3995166778564453}, {
   0.42139339447021484`, 0.42139339447021484`}, {0.4432701110839844, 
   0.4432701110839844}, {0.4651466369628906, 0.4651466369628906}, {
   0.49014863967895506`, 0.49014863967895506`}, {0.5182758331298828, 
   0.5182758331298828}, {0.5432777404785156, 0.5432777404785156}, {
   0.5620291709899903, 0.5620291709899903}, {0.5839057922363281, 
   0.5839057922363281}, {0.6026573181152344, 0.6026573181152344}, {
   0.6276592254638672, 0.6276592254638672}, {0.6432853698730469, 
   0.6432853698730469}, {0.6682872772216797, 0.6682872772216797}, {
   0.6995397567749023, 0.6995397567749023}, {0.7245416641235352, 
   0.7245416641235352}, {0.749543571472168, 0.749543571472168}, {
   0.7776706695556641, 0.7776706695556641}, {0.7964221954345703, 
   0.7964221954345703}, {0.8182989120483398, 0.8182989120483398}, {
   0.8495512008666992, 0.8495512008666992}, {0.8808036804199219, 
   0.8808036804199219}, {0.8995551109313965, 0.8995551109313965}, {
   0.9214317321777343, 0.9214317321777343}, {0.940183162689209, 
   0.940183162689209}, {0.9589345932006836, 0.9589345932006836}, {
   0.9901870727539063, 0.9901870727539063}, {0.008938407897949219, 
   0.008938407897949219}, {0.3433391571044922, 0.3433391571044922}, {
   0.3558401107788086, 0.3558401107788086}, {0.3808420181274414, 
   0.3808420181274414}, {0.39959354400634767`, 0.39959354400634767`}, {
   0.42772064208984373`, 0.42772064208984373`}, {0.45272254943847656`, 
   0.45272254943847656`}, {0.4777244567871094, 0.4777244567871094}, {
   0.5089768409729004, 0.5089768409729004}, {0.527728271484375, 
   0.527728271484375}, {0.5464797973632812, 0.5464797973632812}, {
   0.5714817047119141, 0.5714817047119141}, {0.5996088027954102, 
   0.5996088027954102}, {0.6183603286743165, 0.6183603286743165}, {
   0.6433622360229492, 0.6433622360229492}, {0.668364143371582, 
   0.668364143371582}, {0.6964912414550781, 0.6964912414550781}, {
   0.721493148803711, 0.721493148803711}, {0.7402446746826172, 
   0.7402446746826172}, {0.76524658203125, 0.76524658203125}, {
   0.7871232986450195, 0.7871232986450195}, {0.8121252059936523, 
   0.8121252059936523}, {0.8340018272399903, 0.8340018272399903}, {
   0.8558785438537597, 0.8558785438537597}, {0.8871309280395507, 
   0.8871309280395507}, {0.9183834075927735, 0.9183834075927735}, {
   0.9433853149414062, 0.9433853149414062}, {0.968387222290039, 
   0.968387222290039}, {0.9933891296386719, 0.9933891296386719}, {
   0.015265750885009765`, 0.015265750885009765`}, {0.027766704559326172`, 
   0.027766704559326172`}, {0.046518135070800784`, 0.046518135070800784`}, {
   0.07152004241943359, 0.07152004241943359}, {0.09964733123779297, 
   0.09964733123779297}, {0.12464923858642578`, 0.12464923858642578`}, {
   0.14652576446533203`, 0.14652576446533203`}, {0.16840248107910155`, 
   0.16840248107910155`}, {0.19652967453002929`, 0.19652967453002929`}, {
   0.22153158187866212`, 0.22153158187866212`}, {0.24653348922729493`, 
   0.24653348922729493`}, {0.26841020584106445`, 0.26841020584106445`}, {
   0.30278778076171875`, 0.30278778076171875`}, {0.3277896881103516, 
   0.3277896881103516}, {0.3465412139892578, 0.3465412139892578}, {
   0.37154312133789064`, 0.37154312133789064`}, {0.39341983795166013`, 
   0.39341983795166013`}, {0.41842174530029297`, 0.41842174530029297`}, {
   0.43717317581176757`, 0.43717317581176757`}, {0.4653003692626953, 
   0.4653003692626953}, {0.4778013229370117, 0.4778013229370117}, {
   0.5059284210205078, 0.5059284210205078}, {0.5309303283691407, 
   0.5309303283691407}, {0.5559322357177734, 0.5559322357177734}, {
   0.5653079986572266, 0.5653079986572266}, {0.5871847152709961, 
   0.5871847152709961}, {0.6121866226196289, 0.6121866226196289}, {
   0.6340632438659668, 0.6340632438659668}, {0.6590652465820312, 
   0.6590652465820312}, {0.6965681076049804, 0.6965681076049804}, {
   0.71844482421875, 0.71844482421875}, {0.7371961593627929, 
   0.7371961593627929}, {0.7621981620788574, 0.7621981620788574}, {
   0.7872000694274902, 0.7872000694274902}, {0.812201976776123, 
   0.812201976776123}, {0.834078598022461, 0.834078598022461}, {
   0.8528301239013671, 0.8528301239013671}, {0.87783203125, 0.87783203125}, {
   0.9122097015380859, 0.9122097015380859}, {0.9340863227844238, 
   0.9340863227844238}, {0.9528377532958985, 0.9528377532958985}, {
   0.9778396606445312, 0.9778396606445312}, {0.0028415679931640624`, 
   0.0028415679931640624`}, {0.024718284606933594`, 0.024718284606933594`}, {
   0.046595001220703126`, 0.046595001220703126`}, {0.08097267150878906, 
   0.08097267150878906}, {0.11222496032714843`, 0.11222496032714843`}, {
   0.13722696304321289`, 0.13722696304321289`}, {0.1591035842895508, 
   0.1591035842895508}, {0.18723077774047853`, 0.18723077774047853`}, {
   0.21223268508911133`, 0.21223268508911133`}, {0.2341093063354492, 
   0.2341093063354492}, {0.2622365951538086, 0.2622365951538086}, {
   0.2903636932373047, 0.2903636932373047}, {0.3153656005859375, 
   0.3153656005859375}, {0.3434927940368652, 0.3434927940368652}, {
   0.3622442245483398, 0.3622442245483398}, {0.38724613189697266`, 
   0.38724613189697266`}, {0.41537322998046877`, 0.41537322998046877`}, {
   0.44037513732910155`, 0.44037513732910155`}, {0.4622518539428711, 
   0.4622518539428711}, {0.4841285705566406, 0.4841285705566406}, {
   0.5153809547424316, 0.5153809547424316}, {0.5403828620910645, 
   0.5403828620910645}, {0.5653847694396973, 0.5653847694396973}, {
   0.5841361999511718, 0.5841361999511718}, {0.6091381072998047, 
   0.6091381072998047}, {0.6185138702392579, 0.6185138702392579}, {
   0.637265396118164, 0.637265396118164}, {0.6622673034667969, 
   0.6622673034667969}, {0.6810186386108399, 0.6810186386108399}, {
   0.7028953552246093, 0.7028953552246093}, {0.7153963088989258, 
   0.7153963088989258}, {0.7341477394104003, 0.7341477394104003}, {
   0.7622749328613281, 0.7622749328613281}, {0.7716506004333497, 
   0.7716506004333497}, {0.7904020309448242, 0.7904020309448242}, {
   0.815403938293457, 0.815403938293457}, {0.8404058456420899, 
   0.8404058456420899}, {0.8654077529907227, 0.8654077529907227}, {
   0.8872845649719239, 0.8872845649719239}, {0.9154116630554199, 
   0.9154116630554199}, {0.9404135704040527, 0.9404135704040527}, {
   0.9591650009155274, 0.9591650009155274}, {0.9841669082641602, 
   0.9841669082641602}, {0.00916881561279297, 0.00916881561279297}, {
   0.0310455322265625, 0.0310455322265625}, {0.05292224884033203, 
   0.05292224884033203}, {0.07792415618896484, 0.07792415618896484}, {
   0.10292606353759766`, 0.10292606353759766`}, {0.12792797088623048`, 
   0.12792797088623048`}, {0.1529298782348633, 0.1529298782348633}, {
   0.17168140411376953`, 0.17168140411376953`}, {0.19668331146240234`, 
   0.19668331146240234`}, {0.22168521881103515`, 0.22168521881103515`}, {
   0.24668712615966798`, 0.24668712615966798`}, {0.2654385566711426, 
   0.2654385566711426}, {0.2966909408569336, 0.2966909408569336}, {
   0.32169284820556643`, 0.32169284820556643`}, {0.34982004165649416`, 
   0.34982004165649416`}, {0.37169666290283204`, 0.37169666290283204`}, {
   0.39357337951660154`, 0.39357337951660154`}, {0.4123249053955078, 
   0.4123249053955078}, {0.43732681274414065`, 0.43732681274414065`}, {
   0.4623287200927734, 0.4623287200927734}, {0.4842053413391113, 
   0.4842053413391113}, {0.5154577255249023, 0.5154577255249023}, {
   0.5404596328735352, 0.5404596328735352}, {0.5623363494873047, 
   0.5623363494873047}, {0.5842130661010743, 0.5842130661010743}, {
   0.609214973449707, 0.609214973449707}, {0.6310916900634765, 
   0.6310916900634765}, {0.6498431205749512, 0.6498431205749512}, {
   0.6779702186584473, 0.6779702186584473}, {0.7092226028442383, 
   0.7092226028442383}, {0.740475082397461, 0.740475082397461}, {
   0.7686021804809571, 0.7686021804809571}, {0.7904788970947265, 
   0.7904788970947265}, {0.8123556137084961, 0.8123556137084961}, {
   0.8404827117919922, 0.8404827117919922}, {0.8623594284057617, 
   0.8623594284057617}, {0.8936118125915528, 0.8936118125915528}, {
   0.9217390060424805, 0.9217390060424805}, {0.9467409133911133, 
   0.9467409133911133}, {0.971742820739746, 0.971742820739746}, {
   0.9904941558837891, 0.9904941558837891}, {0.015496158599853515`, 
   0.015496158599853515`}, {0.03424758911132812, 0.03424758911132812}, {
   0.059249496459960936`, 0.059249496459960936`}, {0.08112621307373047, 
   0.08112621307373047}, {0.11237869262695313`, 0.11237869262695313`}, {
   0.13738059997558594`, 0.13738059997558594`}, {0.1592571258544922, 
   0.1592571258544922}, {0.184259033203125, 0.184259033203125}, {
   0.20926103591918946`, 0.20926103591918946`}, {0.22488727569580078`, 
   0.22488727569580078`}, {0.24988918304443358`, 0.24988918304443358`}, {
   0.2780162811279297, 0.2780162811279297}, {0.3030181884765625, 
   0.3030181884765625}, {0.3280200958251953, 0.3280200958251953}, {
   0.33739585876464845`, 0.33739585876464845`}, {0.35614738464355467`, 
   0.35614738464355467`}, {0.3811492919921875, 0.3811492919921875}, {
   0.40615119934082033`, 0.40615119934082033`}, {0.4311531066894531, 
   0.4311531066894531}, {0.453029727935791, 0.453029727935791}, {
   0.47803173065185545`, 0.47803173065185545`}, {0.5061588287353516, 
   0.5061588287353516}, {0.5311607360839844, 0.5311607360839844}, {
   0.5561626434326172, 0.5561626434326172}, {0.5811646461486817, 
   0.5811646461486817}, {0.5999160766601562, 0.5999160766601562}, {
   0.6280431747436523, 0.6280431747436523}, {0.646794605255127, 
   0.646794605255127}, {0.6655460357666015, 0.6655460357666015}, {
   0.6874227523803711, 0.6874227523803711}, {0.7092994689941406, 
   0.7092994689941406}, {0.7280508041381836, 0.7280508041381836}, {
   0.7530527114868164, 0.7530527114868164}, {0.7780547142028809, 
   0.7780547142028809}, {0.8030566215515137, 0.8030566215515137}, {
   0.8311838150024414, 0.8311838150024414}, {0.8593109130859375, 
   0.8593109130859375}, {0.881187629699707, 0.881187629699707}, {
   0.915565299987793, 0.915565299987793}, {0.943692398071289, 
   0.943692398071289}, {0.9686944007873535, 0.9686944007873535}, {
   0.9936963081359863, 0.9936963081359863}, {0.01869821548461914, 
   0.01869821548461914}, {0.043700122833251955`, 0.043700122833251955`}, {
   0.06245155334472656, 0.06245155334472656}, {0.08120307922363282, 
   0.08120307922363282}, {0.10620498657226562`, 0.10620498657226562`}, {
   0.13120689392089843`, 0.13120689392089843`}, {0.15620880126953124`, 
   0.15620880126953124`}, {0.18121070861816407`, 0.18121070861816407`}, {
   0.19996213912963867`, 0.19996213912963867`}, {0.2124630928039551, 
   0.2124630928039551}, {0.2312145233154297, 0.2312145233154297}, {
   0.2562164306640625, 0.2562164306640625}, {0.29059410095214844`, 
   0.29059410095214844`}, {0.31872119903564455`, 0.31872119903564455`}, {
   0.3468483924865723, 0.3468483924865723}, {0.3749755859375, 
   0.3749755859375}, {0.3999774932861328, 0.3999774932861328}, {
   0.42497940063476564`, 0.42497940063476564`}, {0.44373092651367185`, 
   0.44373092651367185`}, {0.4687328338623047, 0.4687328338623047}, {
   0.4937347412109375, 0.4937347412109375}, {0.5156113624572753, 
   0.5156113624572753}, {0.5406132698059082, 0.5406132698059082}, {
   0.565615177154541, 0.565615177154541}, {0.5843666076660157, 
   0.5843666076660157}, {0.6031181335449218, 0.6031181335449218}, {
   0.6249948501586914, 0.6249948501586914}, {0.6468713760375977, 
   0.6468713760375977}, {0.6968752861022949, 0.6968752861022949}, {
   0.7218771934509277, 0.7218771934509277}, {0.7500043869018554, 
   0.7500043869018554}, {0.7687558174133301, 0.7687558174133301}, {
   0.7937577247619629, 0.7937577247619629}, {0.8218849182128907, 
   0.8218849182128907}, {0.8437616348266601, 0.8437616348266601}, {
   0.868763542175293, 0.868763542175293}, {0.8968906402587891, 
   0.8968906402587891}, {0.9250178337097168, 0.9250178337097168}, {
   0.9437692642211915, 0.9437692642211915}, {0.9718963623046875, 
   0.9718963623046875}, {0.9968982696533203, 0.9968982696533203}, {
   0.021900177001953125`, 0.021900177001953125`}, {0.040651702880859376`, 
   0.040651702880859376`}, {0.06565361022949219, 0.06565361022949219}, {
   0.0969059944152832, 0.0969059944152832}, {0.12503318786621093`, 
   0.12503318786621093`}, {0.14690980911254883`, 0.14690980911254883`}, {
   0.1719118118286133, 0.1719118118286133}, {0.1969137191772461, 
   0.1969137191772461}, {0.2219156265258789, 0.2219156265258789}, {
   0.2375417709350586, 0.2375417709350586}, {0.2656689643859863, 
   0.2656689643859863}, {0.2969213485717773, 0.2969213485717773}, {
   0.32192325592041016`, 0.32192325592041016`}, {0.346925163269043, 
   0.346925163269043}, {0.3656766891479492, 0.3656766891479492}, {
   0.3969289779663086, 0.3969289779663086}, {0.4156805038452148, 
   0.4156805038452148}, {0.4375572204589844, 0.4375572204589844}, {
   0.45630855560302735`, 0.45630855560302735`}, {0.4813105583190918, 
   0.4813105583190918}, {0.515688133239746, 0.515688133239746}, {
   0.5406900405883789, 0.5406900405883789}, {0.5531909942626954, 
   0.5531909942626954}, {0.5750677108764648, 0.5750677108764648}, {
   0.6000696182250976, 0.6000696182250976}, {0.6250715255737305, 
   0.6250715255737305}, {0.6438230514526367, 0.6438230514526367}, {
   0.6688249588012696, 0.6688249588012696}, {0.6969520568847656, 
   0.6969520568847656}, {0.7250792503356933, 0.7250792503356933}, {
   0.7469558715820312, 0.7469558715820312}, {0.7594568252563476, 
   0.7594568252563476}, {0.7782083511352539, 0.7782083511352539}, {
   0.8032102584838867, 0.8032102584838867}, {0.8282121658325196, 
   0.8282121658325196}, {0.8532140731811524, 0.8532140731811524}, {
   0.8719655036926269, 0.8719655036926269}, {0.9000926971435547, 
   0.9000926971435547}, {0.9219694137573242, 0.9219694137573242}, {
   0.9407207489013671, 0.9407207489013671}, {0.96572265625, 0.96572265625}, {
   0.9907245635986328, 0.9907245635986328}, {0.012601280212402343`, 
   0.012601280212402343`}, {0.031352806091308597`, 0.031352806091308597`}, {
   0.059479904174804685`, 0.059479904174804685`}, {0.08135662078857422, 
   0.08135662078857422}, {0.11260900497436524`, 0.11260900497436524`}, {
   0.12511005401611328`, 0.12511005401611328`}, {0.14386138916015626`, 
   0.14386138916015626`}, {0.16886329650878906`, 0.16886329650878906`}, {
   0.19386520385742187`, 0.19386520385742187`}, {0.21886720657348632`, 
   0.21886720657348632`}, {0.24386911392211913`, 0.24386911392211913`}, {
   0.26262054443359373`, 0.26262054443359373`}, {0.28762245178222656`, 
   0.28762245178222656`}, {0.3157495498657227, 0.3157495498657227}, {
   0.34387683868408203`, 0.34387683868408203`}, {0.37200393676757815`, 
   0.37200393676757815`}, {0.39075527191162107`, 0.39075527191162107`}, {
   0.40950679779052734`, 0.40950679779052734`}, {0.4376339912414551, 
   0.4376339912414551}, {0.4563854217529297, 0.4563854217529297}, {
   0.47826204299926756`, 0.47826204299926756`}, {0.5095144271850586, 
   0.5095144271850586}, {0.5313911437988281, 0.5313911437988281}, {
   0.5501426696777344, 0.5501426696777344}, {0.5782697677612305, 
   0.5782697677612305}, {0.6032716751098632, 0.6032716751098632}, {
   0.6282735824584961, 0.6282735824584961}, {0.6564007759094238, 
   0.6564007759094238}, {0.6814026832580566, 0.6814026832580566}, {
   0.7064046859741211, 0.7064046859741211}, {0.7376569747924805, 
   0.7376569747924805}, {0.7564085006713868, 0.7564085006713868}, {
   0.7720346450805664, 0.7720346450805664}, {0.8001618385314941, 
   0.8001618385314941}, {0.825163745880127, 0.825163745880127}, {
   0.8501656532287598, 0.8501656532287598}, {0.8720422744750976, 
   0.8720422744750976}, {0.900169563293457, 0.900169563293457}, {
   0.9282966613769531, 0.9282966613769531}, {0.9501733779907227, 
   0.9501733779907227}, {0.9751752853393555, 0.9751752853393555}, {
   0.00017719268798828126`, 0.00017719268798828126`}, {0.01892862319946289, 
   0.01892862319946289}, {0.04080524444580078, 0.04080524444580078}, {
   0.059556770324707034`, 0.059556770324707034`}, {0.08768386840820312, 
   0.08768386840820312}, {0.11268577575683594`, 0.11268577575683594`}, {
   0.1314373016357422, 0.1314373016357422}, {0.156439208984375, 
   0.156439208984375}, {0.1720653533935547, 0.1720653533935547}, {
   0.20019254684448243`, 0.20019254684448243`}, {0.22831964492797852`, 
   0.22831964492797852`}, {0.25332164764404297`, 0.25332164764404297`}, {
   0.2751983642578125, 0.2751983642578125}, {0.3033254623413086, 
   0.3033254623413086}, {0.32520217895507814`, 0.32520217895507814`}, {
   0.3439535140991211, 0.3439535140991211}, {0.36895551681518557`, 
   0.36895551681518557`}, {0.39395742416381835`, 0.39395742416381835`}, {
   0.41270885467529295`, 0.41270885467529295`}, {0.4377107620239258, 
   0.4377107620239258}, {0.4627126693725586, 0.4627126693725586}, {
   0.4845893859863281, 0.4845893859863281}, {0.5127164840698242, 
   0.5127164840698242}, {0.5439689636230469, 0.5439689636230469}, {
   0.5689708709716796, 0.5689708709716796}, {0.5939727783203125, 
   0.5939727783203125}, {0.6189746856689453, 0.6189746856689453}, {
   0.6377262115478516, 0.6377262115478516}, {0.6564775466918945, 
   0.6564775466918945}, {0.6908552169799804, 0.6908552169799804}, {
   0.7096065521240235, 0.7096065521240235}, {0.7314833641052246, 
   0.7314833641052246}, {0.7502347946166992, 0.7502347946166992}, {
   0.7783618927001953, 0.7783618927001953}, {0.7971133232116699, 
   0.7971133232116699}, {0.8158647537231445, 0.8158647537231445}, {
   0.8408666610717773, 0.8408666610717773}, {0.8596181869506836, 
   0.8596181869506836}, {0.8814949035644531, 0.8814949035644531}, {
   0.9096220016479493, 0.9096220016479493}, {0.934623908996582, 
   0.934623908996582}, {0.9596258163452148, 0.9596258163452148}, {
   0.9846277236938477, 0.9846277236938477}, {0.009629631042480468, 
   0.009629631042480468}, {0.040882110595703125`, 0.040882110595703125`}, {
   0.06900920867919921, 0.06900920867919921}, {0.10026168823242188`, 
   0.10026168823242188`}, {0.12526359558105468`, 0.12526359558105468`}, {
   0.1440150260925293, 0.1440150260925293}, {0.1658916473388672, 
   0.1658916473388672}, {0.19401884078979492`, 0.19401884078979492`}, {
   0.21902084350585938`, 0.21902084350585938`}, {0.24402275085449218`, 
   0.24402275085449218`}, {0.269024658203125, 0.269024658203125}, {
   0.300277042388916, 0.300277042388916}, {0.3190284729003906, 
   0.3190284729003906}, {0.34090509414672854`, 0.34090509414672854`}, {
   0.3659070014953613, 0.3659070014953613}, {0.39403419494628905`, 
   0.39403419494628905`}, {0.42216129302978517`, 0.42216129302978517`}, {
   0.44716320037841795`, 0.44716320037841795`}, {0.4721652030944824, 
   0.4721652030944824}, {0.5096680641174316, 0.5096680641174316}, {
   0.5284194946289062, 0.5284194946289062}, {0.5471709251403809, 
   0.5471709251403809}, {0.5690476417541503, 0.5690476417541503}, {
   0.5940496444702148, 0.5940496444702148}, {0.6159261703491211, 
   0.6159261703491211}, {0.6378028869628907, 0.6378028869628907}, {
   0.6659300804138184, 0.6659300804138184}, {0.684681510925293, 
   0.684681510925293}, {0.7128087043762207, 0.7128087043762207}, {
   0.7378106117248535, 0.7378106117248535}, {0.7659378051757812, 
   0.7659378051757812}, {0.7909397125244141, 0.7909397125244141}, {
   0.8159416198730469, 0.8159416198730469}, {0.8378183364868164, 
   0.8378183364868164}, {0.8628202438354492, 0.8628202438354492}, {
   0.9003231048583984, 0.9003231048583984}, {0.919074535369873, 
   0.919074535369873}, {0.9440764427185059, 0.9440764427185059}, {
   0.9628278732299804, 0.9628278732299804}, {0.9815793991088867, 
   0.9815793991088867}, {0.006581306457519531, 0.006581306457519531}, {
   0.031583213806152345`, 0.031583213806152345`}, {0.05658512115478516, 
   0.05658512115478516}, {0.07846174240112305, 0.07846174240112305}, {
   0.10658893585205079`, 0.10658893585205079`}, {0.1284656524658203, 
   0.1284656524658203}, {0.15346755981445312`, 0.15346755981445312`}, {
   0.17846946716308593`, 0.17846946716308593`}, {0.1972208023071289, 
   0.1972208023071289}, {0.21597232818603515`, 0.21597232818603515`}, {
   0.23784904479980468`, 0.23784904479980468`}, {0.2628509521484375, 
   0.2628509521484375}, {0.2847275733947754, 0.2847275733947754}, {
   0.3128547668457031, 0.3128547668457031}, {0.3347314834594727, 
   0.3347314834594727}, {0.3566082000732422, 0.3566082000732422}, {
   0.37535953521728516`, 0.37535953521728516`}, {0.39411106109619143`, 
   0.39411106109619143`}, {0.4159876823425293, 0.4159876823425293}, {
   0.44411487579345704`, 0.44411487579345704`}, {0.47536725997924806`, 
   0.47536725997924806`}, {0.5159954071044922, 0.5159954071044922}, {
   0.5441225051879883, 0.5441225051879883}, {0.569124412536621, 
   0.569124412536621}, {0.5972516059875488, 0.5972516059875488}, {
   0.6097525596618653, 0.6097525596618653}, {0.6285039901733398, 
   0.6285039901733398}, {0.6472554206848145, 0.6472554206848145}, {
   0.6660068511962891, 0.6660068511962891}, {0.6847582817077636, 
   0.6847582817077636}, {0.7128854751586914, 0.7128854751586914}, {
   0.7410125732421875, 0.7410125732421875}, {0.7597640991210938, 
   0.7597640991210938}, {0.7816408157348633, 0.7816408157348633}, {
   0.806642723083496, 0.806642723083496}, {0.8316446304321289, 
   0.8316446304321289}, {0.8535212516784668, 0.8535212516784668}, {
   0.8910242080688476, 0.8910242080688476}, {0.9410280227661133, 
   0.9410280227661133}, {0.9660299301147461, 0.9660299301147461}, {
   0.9910318374633789, 0.9910318374633789}, {0.009783267974853516, 
   0.009783267974853516}, {0.03791046142578125, 0.03791046142578125}, {
   0.06603755950927734, 0.06603755950927734}, {0.09103946685791016, 
   0.09103946685791016}, {0.12229194641113281`, 0.12229194641113281`}, {
   0.14729385375976561`, 0.14729385375976561`}, {0.17542095184326173`, 
   0.17542095184326173`}, {0.19729766845703126`, 0.19729766845703126`}, {
   0.21604909896850585`, 0.21604909896850585`}, {0.24730148315429687`, 
   0.24730148315429687`}, {0.27542877197265625`, 0.27542877197265625`}, {
   0.31293163299560545`, 0.31293163299560545`}, {0.3379335403442383, 
   0.3379335403442383}, {0.3660606384277344, 0.3660606384277344}, {
   0.3973130226135254, 0.3973130226135254}, {0.42544021606445315`, 
   0.42544021606445315`}, {0.44419164657592775`, 0.44419164657592775`}, {
   0.46294307708740234`, 0.46294307708740234`}, {0.49732074737548826`, 
   0.49732074737548826`}, {0.5223226547241211, 0.5223226547241211}, {
   0.5598255157470703, 0.5598255157470703}, {0.5848274230957031, 
   0.5848274230957031}, {0.609829330444336, 0.609829330444336}, {
   0.6348312377929688, 0.6348312377929688}, {0.6567079544067382, 
   0.6567079544067382}, {0.6910856246948243, 0.6910856246948243}, {
   0.7192127227783203, 0.7192127227783203}, {0.747339916229248, 
   0.747339916229248}, {0.7660913467407227, 0.7660913467407227}, {
   0.7848427772521973, 0.7848427772521973}, {0.80984468460083, 
   0.80984468460083}, {0.8504728317260742, 0.8504728317260742}, {
   0.8879756927490234, 0.8879756927490234}, {0.9192281723022461, 
   0.9192281723022461}, {0.9473552703857422, 0.9473552703857422}, {
   0.972357177734375, 0.972357177734375}, {0.0036095619201660157`, 
   0.0036095619201660157`}, {0.02548637390136719, 0.02548637390136719}, {
   0.07861537933349609, 0.07861537933349609}, {0.10361728668212891`, 
   0.10361728668212891`}, {0.13174448013305665`, 0.13174448013305665`}, {
   0.15987157821655273`, 0.15987157821655273`}, {0.18799877166748047`, 
   0.18799877166748047`}, {0.20987548828125, 0.20987548828125}, {
   0.22862682342529297`, 0.22862682342529297`}, {0.25675411224365235`, 
   0.25675411224365235`}, {0.2786306381225586, 0.2786306381225586}, {
   0.30675792694091797`, 0.30675792694091797`}, {0.338010311126709, 
   0.338010311126709}, {0.3880141258239746, 0.3880141258239746}, {
   0.4098907470703125, 0.4098907470703125}, {0.44114322662353517`, 
   0.44114322662353517`}, {0.46614513397216795`, 0.46614513397216795`}, {
   0.4911470413208008, 0.4911470413208008}, {0.5192742347717285, 
   0.5192742347717285}, {0.5536518096923828, 0.5536518096923828}, {
   0.5786537170410156, 0.5786537170410156}, {0.6005304336547852, 
   0.6005304336547852}, {0.6286575317382812, 0.6286575317382812}, {
   0.6505342483520508, 0.6505342483520508}, {0.6880372047424317, 
   0.6880372047424317}, {0.7161643028259277, 0.7161643028259277}, {
   0.7411662101745605, 0.7411662101745605}, {0.766168212890625, 
   0.766168212890625}, {0.7911701202392578, 0.7911701202392578}, {
   0.8161720275878906, 0.8161720275878906}, {0.8380487442016602, 
   0.8380487442016602}, {0.859925365447998, 0.859925365447998}, {
   0.8880525588989258, 0.8880525588989258}, {0.9099291801452637, 
   0.9099291801452637}, {0.9349310874938965, 0.9349310874938965}, {
   0.9536825180053711, 0.9536825180053711}, {0.9786844253540039, 
   0.9786844253540039}, {0.0005611419677734375, 0.0005611419677734375}, {
   0.02556304931640625, 0.02556304931640625}, {0.04743976593017578, 
   0.04743976593017578}, {0.06931648254394532, 0.06931648254394532}, {
   0.10369405746459961`, 0.10369405746459961`}, {0.12557077407836914`, 
   0.12557077407836914`}, {0.14744739532470702`, 0.14744739532470702`}, {
   0.16932411193847657`, 0.16932411193847657`}, {0.18807563781738282`, 
   0.18807563781738282`}, {0.20995216369628905`, 0.20995216369628905`}, {
   0.22870368957519532`, 0.22870368957519532`}, {0.2505804061889648, 
   0.2505804061889648}, {0.27245702743530276`, 0.27245702743530276`}, {
   0.3005842208862305, 0.3005842208862305}, {0.32246084213256837`, 
   0.32246084213256837`}, {0.3474628448486328, 0.3474628448486328}, {
   0.3662141799926758, 0.3662141799926758}, {0.3880908966064453, 
   0.3880908966064453}, {0.4068424224853516, 0.4068424224853516}, {
   0.42871904373168945`, 0.42871904373168945`}, {0.44747047424316405`, 
   0.44747047424316405`}, {0.4693471908569336, 0.4693471908569336}, {
   0.5005995750427246, 0.5005995750427246}, {0.5224761962890625, 
   0.5224761962890625}, {0.544352912902832, 0.544352912902832}, {
   0.5662296295166016, 0.5662296295166016}, {0.588106346130371, 
   0.588106346130371}, {0.6099828720092774, 0.6099828720092774}, {
   0.6318596839904785, 0.6318596839904785}, {0.6537363052368164, 
   0.6537363052368164}, {0.672487735748291, 0.672487735748291}, {
   0.7068654060363769, 0.7068654060363769}, {0.7287420272827149, 
   0.7287420272827149}, {0.7537439346313477, 0.7537439346313477}, {
   0.7724954605102539, 0.7724954605102539}, {0.7974973678588867, 
   0.7974973678588867}, {0.8224992752075195, 0.8224992752075195}, {
   0.8412507057189942, 0.8412507057189942}, {0.8631274223327636, 
   0.8631274223327636}, {0.8881293296813965, 0.8881293296813965}, {
   0.9162565231323242, 0.9162565231323242}, {0.9381332397460938, 
   0.9381332397460938}, {0.960009765625, 0.960009765625}, {0.9850116729736328,
    0.9850116729736328}, {0.0037631988525390625`, 0.0037631988525390625`}, {
   0.025639915466308595`, 0.025639915466308595`}, {0.0443913459777832, 
   0.0443913459777832}, {0.0662679672241211, 0.0662679672241211}, {
   0.0912698745727539, 0.0912698745727539}, {0.12252235412597656`, 
   0.12252235412597656`}, {0.1443990707397461, 0.1443990707397461}, {
   0.16627559661865235`, 0.16627559661865235`}, {0.18815231323242188`, 
   0.18815231323242188`}, {0.2100290298461914, 0.2100290298461914}, {
   0.22878046035766603`, 0.22878046035766603`}, {0.2506571769714355, 
   0.2506571769714355}, {0.27253379821777346`, 0.27253379821777346`}, {
   0.3069114685058594, 0.3069114685058594}, {0.32878818511962893`, 
   0.32878818511962893`}, {0.3506649017333984, 0.3506649017333984}, {
   0.3694162368774414, 0.3694162368774414}, {0.39441823959350586`, 
   0.39441823959350586`}, {0.41316967010498046`, 0.41316967010498046`}, {
   0.4381715774536133, 0.4381715774536133}, {0.4600482940673828, 
   0.4600482940673828}, {0.4913005828857422, 0.4913005828857422}, {
   0.5194278717041015, 0.5194278717041015}, {0.5413043975830079, 
   0.5413043975830079}, {0.5663064002990723, 0.5663064002990723}, {
   0.5881831169128418, 0.5881831169128418}, {0.6131850242614746, 
   0.6131850242614746}, {0.6350616455078125, 0.6350616455078125}, {
   0.6538131713867188, 0.6538131713867188}, {0.6881908416748047, 
   0.6881908416748047}, {0.7100673675537109, 0.7100673675537109}, {
   0.7319440841674805, 0.7319440841674805}, {0.7600712776184082, 
   0.7600712776184082}, {0.785073184967041, 0.785073184967041}, {
   0.8100750923156739, 0.8100750923156739}, {0.8350769996643066, 
   0.8350769996643066}, {0.8569538116455078, 0.8569538116455078}, {
   0.8819557189941406, 0.8819557189941406}, {0.9132080078125, 
   0.9132080078125}, {0.9413352012634277, 0.9413352012634277}, {
   0.9632119178771973, 0.9632119178771973}, {0.9850885391235351, 
   0.9850885391235351}, {0.006965255737304688, 0.006965255737304688}, {
   0.02884197235107422, 0.02884197235107422}, {0.05384387969970703, 
   0.05384387969970703}, {0.08509616851806641, 0.08509616851806641}, {
   0.11009807586669922`, 0.11009807586669922`}, {0.13822536468505858`, 
   0.13822536468505858`}, {0.1569767951965332, 0.1569767951965332}, {
   0.18197870254516602`, 0.18197870254516602`}, {0.2101058006286621, 
   0.2101058006286621}, {0.23198261260986328`, 0.23198261260986328`}, {
   0.25073394775390623`, 0.25073394775390623`}, {0.27886104583740234`, 
   0.27886104583740234`}, {0.3069883346557617, 0.3069883346557617}, {
   0.32886495590209963`, 0.32886495590209963`}, {0.35074167251586913`, 
   0.35074167251586913`}, {0.372618293762207, 0.372618293762207}, {
   0.4288726806640625, 0.4288726806640625}, {0.4538745880126953, 
   0.4538745880126953}, {0.47887649536132815`, 0.47887649536132815`}, {
   0.5101288795471192, 0.5101288795471192}, {0.535130786895752, 
   0.535130786895752}, {0.5570075035095214, 0.5570075035095214}, {
   0.5788841247558594, 0.5788841247558594}, {0.6070114135742187, 
   0.6070114135742187}, {0.6257627487182618, 0.6257627487182618}, {
   0.6507646560668945, 0.6507646560668945}, {0.6695161819458008, 
   0.6695161819458008}, {0.7007685661315918, 0.7007685661315918}, {
   0.7257704734802246, 0.7257704734802246}, {0.7476470947265625, 
   0.7476470947265625}, {0.769523811340332, 0.769523811340332}, {
   0.7914005279541015, 0.7914005279541015}, {0.8132772445678711, 
   0.8132772445678711}, {0.8382791519165039, 0.8382791519165039}, {
   0.8601556777954101, 0.8601556777954101}, {0.8882829666137695, 
   0.8882829666137695}, {0.9226605415344238, 0.9226605415344238}, {
   0.9507877349853515, 0.9507877349853515}, {0.9726644515991211, 
   0.9726644515991211}, {0.9976663589477539, 0.9976663589477539}, {
   0.02266826629638672, 0.02266826629638672}, {0.050795364379882815`, 
   0.050795364379882815`}, {0.08204784393310546, 0.08204784393310546}, {
   0.11642541885375976`, 0.11642541885375976`}, {0.13830213546752929`, 
   0.13830213546752929`}, {0.1601787567138672, 0.1601787567138672}, {
   0.18830604553222657`, 0.18830604553222657`}, {0.21330795288085938`, 
   0.21330795288085938`}, {0.24143505096435547`, 0.24143505096435547`}, {
   0.2664369583129883, 0.2664369583129883}, {0.3039398193359375, 
   0.3039398193359375}, {0.32894172668457033`, 0.32894172668457033`}, {
   0.3539436340332031, 0.3539436340332031}, {0.37582035064697267`, 
   0.37582035064697267`}, {0.39769706726074217`, 0.39769706726074217`}, {
   0.4195737838745117, 0.4195737838745117}, {0.4414504051208496, 
   0.4414504051208496}, {0.46957759857177733`, 0.46957759857177733`}, {
   0.5008299827575684, 0.5008299827575684}, {0.5289570808410644, 
   0.5289570808410644}, {0.5570842742919921, 0.5570842742919921}, {
   0.582086181640625, 0.582086181640625}, {0.6070880889892578, 
   0.6070880889892578}, {0.6320899963378906, 0.6320899963378906}, {
   0.6539667129516602, 0.6539667129516602}, {0.6914695739746094, 
   0.6914695739746094}, {0.722722053527832, 0.722722053527832}, {
   0.7508491516113281, 0.7508491516113281}, {0.7727258682250977, 
   0.7727258682250977}, {0.7977277755737304, 0.7977277755737304}, {
   0.8227296829223633, 0.8227296829223633}, {0.8477315902709961, 
   0.8477315902709961}, {0.8789839744567871, 0.8789839744567871}, {
   0.913361644744873, 0.913361644744873}, {0.9383636474609375, 
   0.9383636474609375}, {0.9664907455444336, 0.9664907455444336}, {
   0.9946178436279297, 0.9946178436279297}, {0.019619846343994142`, 
   0.019619846343994142`}, {0.04149646759033203, 0.04149646759033203}, {
   0.06649837493896485, 0.06649837493896485}, {0.09150028228759766, 
   0.09150028228759766}, {0.11650218963623046`, 0.11650218963623046`}, {
   0.14150409698486327`, 0.14150409698486327`}, {0.1665060043334961, 
   0.1665060043334961}, {0.18838272094726563`, 0.18838272094726563`}, {
   0.21338472366333008`, 0.21338472366333008`}, {0.2383866310119629, 
   0.2383866310119629}, {0.266513729095459, 0.266513729095459}, {
   0.3008913993835449, 0.3008913993835449}, {0.32901859283447266`, 
   0.32901859283447266`}, {0.3540205001831055, 0.3540205001831055}, {
   0.37902240753173827`, 0.37902240753173827`}, {0.407149600982666, 
   0.407149600982666}, {0.4352766990661621, 0.4352766990661621}, {
   0.4602786064147949, 0.4602786064147949}, {0.48528060913085935`, 
   0.48528060913085935`}, {0.5227834701538085, 0.5227834701538085}, {
   0.554035758972168, 0.554035758972168}, {0.5821630477905273, 
   0.5821630477905273}, {0.6071649551391601, 0.6071649551391601}, {
   0.6290415763854981, 0.6290415763854981}, {0.6509182929992676, 
   0.6509182929992676}, {0.6727949142456054, 0.6727949142456054}, {
   0.7009222030639648, 0.7009222030639648}, {0.7227987289428711, 
   0.7227987289428711}, {0.747800636291504, 0.747800636291504}, {
   0.7696773529052734, 0.7696773529052734}, {0.791554069519043, 
   0.791554069519043}, {0.822806453704834, 0.822806453704834}, {
   0.8446831703186035, 0.8446831703186035}, {0.8665597915649415, 
   0.8665597915649415}, {0.8946870803833008, 0.8946870803833008}, {
   0.9196889877319336, 0.9196889877319336}, {0.9415655136108398, 
   0.9415655136108398}, {0.963442325592041, 0.963442325592041}, {
   0.985318946838379, 0.985318946838379}, {0.007195663452148437, 
   0.007195663452148437}, {0.03219757080078125, 0.03219757080078125}, {
   0.05407428741455078, 0.05407428741455078}, {0.07595100402832031, 
   0.07595100402832031}, {0.11032848358154297`, 0.11032848358154297`}, {
   0.1322052001953125, 0.1322052001953125}, {0.16033239364624025`, 
   0.16033239364624025`}, {0.18220911026000977`, 0.18220911026000977`}, {
   0.20408573150634765`, 0.20408573150634765`}, {0.22596244812011718`, 
   0.22596244812011718`}, {0.25096435546875, 0.25096435546875}, {
   0.2728410720825195, 0.2728410720825195}, {0.3040933609008789, 
   0.3040933609008789}, {0.32909536361694336`, 0.32909536361694336`}, {
   0.3509720802307129, 0.3509720802307129}, {0.3759739875793457, 
   0.3759739875793457}, {0.39785060882568357`, 0.39785060882568357`}, {
   0.4197273254394531, 0.4197273254394531}, {0.4384788513183594, 
   0.4384788513183594}, {0.4634807586669922, 0.4634807586669922}, {
   0.5259855270385743, 0.5259855270385743}, {0.550987434387207, 
   0.550987434387207}, {0.5759893417358398, 0.5759893417358398}, {
   0.5978659629821778, 0.5978659629821778}, {0.6197426795959473, 
   0.6197426795959473}, {0.6447446823120118, 0.6447446823120118}, {
   0.6697465896606445, 0.6697465896606445}, {0.6978736877441406, 
   0.6978736877441406}, {0.7228755950927734, 0.7228755950927734}, {
   0.7478775024414063, 0.7478775024414063}, {0.7697542190551758, 
   0.7697542190551758}, {0.7947561264038085, 0.7947561264038085}, {
   0.8572608947753906, 0.8572608947753906}, {0.8947637557983399, 
   0.8947637557983399}, {0.9197657585144043, 0.9197657585144043}, {
   0.9478928565979003, 0.9478928565979003}, {0.9697695732116699, 
   0.9697695732116699}, {0.9947714805603027, 0.9947714805603027}, {
   0.019773483276367188`, 0.019773483276367188`}, {0.06665191650390626, 
   0.06665191650390626}, {0.10102968215942383`, 0.10102968215942383`}, {
   0.12290630340576172`, 0.12290630340576172`}, {0.14790821075439453`, 
   0.14790821075439453`}, {0.17291011810302734`, 0.17291011810302734`}, {
   0.19478683471679686`, 0.19478683471679686`}, {0.22291393280029298`, 
   0.22291393280029298`}, {0.2479158401489258, 0.2479158401489258}, {
   0.2729178428649902, 0.2729178428649902}, {0.30104503631591795`, 
   0.30104503631591795`}, {0.3260469436645508, 0.3260469436645508}, {
   0.3510488510131836, 0.3510488510131836}, {0.3760507583618164, 
   0.3760507583618164}, {0.40105266571044923`, 0.40105266571044923`}, {
   0.426054573059082, 0.426054573059082}, {0.45105648040771484`, 
   0.45105648040771484`}, {0.4729331970214844, 0.4729331970214844}, {
   0.5073108673095703, 0.5073108673095703}, {0.5291874885559082, 
   0.5291874885559082}, {0.5510642051696777, 0.5510642051696777}, {
   0.5791913986206054, 0.5791913986206054}, {0.601068115234375, 
   0.601068115234375}, {0.6260700225830078, 0.6260700225830078}, {
   0.6479466438293457, 0.6479466438293457}, {0.6729485511779785, 
   0.6729485511779785}, {0.6979504585266113, 0.6979504585266113}, {
   0.7229523658752441, 0.7229523658752441}, {0.7698310852050781, 
   0.7698310852050781}, {0.794832992553711, 0.794832992553711}, {
   0.8167095184326172, 0.8167095184326172}, {0.8417115211486816, 
   0.8417115211486816}, {0.8635882377624512, 0.8635882377624512}, {
   0.8917153358459473, 0.8917153358459473}, {0.9260930061340332, 
   0.9260930061340332}, {0.9823472976684571, 0.9823472976684571}, {
   0.013599777221679687`, 0.013599777221679687`}, {0.0386016845703125, 
   0.0386016845703125}, {0.06672878265380859, 0.06672878265380859}, {
   0.0979811668395996, 0.0979811668395996}, {0.12298316955566406`, 
   0.12298316955566406`}, {0.15111026763916016`, 0.15111026763916016`}, {
   0.17611217498779297`, 0.17611217498779297`}, {0.20111408233642578`, 
   0.20111408233642578`}, {0.2292412757873535, 0.2292412757873535}, {
   0.2542431831359863, 0.2542431831359863}, {0.28237037658691405`, 
   0.28237037658691405`}, {0.31362276077270507`, 0.31362276077270507`}, {
   0.33549938201904295`, 0.33549938201904295`}, {0.3605012893676758, 
   0.3605012893676758}, {0.38237800598144533`, 0.38237800598144533`}, {
   0.4073799133300781, 0.4073799133300781}, {0.43238191604614257`, 
   0.43238191604614257`}, {0.5042623519897461, 0.5042623519897461}, {
   0.5323896408081055, 0.5323896408081055}, {0.5573915481567383, 
   0.5573915481567383}, {0.5823934555053711, 0.5823934555053711}, {
   0.6136458396911622, 0.6136458396911622}, {0.6355224609375, 
   0.6355224609375}, {0.6605243682861328, 0.6605243682861328}, {
   0.6949020385742187, 0.6949020385742187}, {0.7261545181274414, 
   0.7261545181274414}, {0.7449058532714844, 0.7449058532714844}, {
   0.7636573791503907, 0.7636573791503907}, {0.7855340003967285, 
   0.7855340003967285}, {0.8042854309082031, 0.8042854309082031}, {
   0.8355378150939942, 0.8355378150939942}, {0.8636650085449219, 
   0.8636650085449219}, {0.8855417251586915, 0.8855417251586915}, {
   0.9105436325073242, 0.9105436325073242}, {0.9417959213256836, 
   0.9417959213256836}, {0.9699232101440429, 0.9699232101440429}, {
   0.998050308227539, 0.998050308227539}, {0.029302692413330077`, 
   0.029302692413330077`}, {0.05742988586425781, 0.05742988586425781}, {
   0.09493274688720703, 0.09493274688720703}, {0.12618522644042968`, 
   0.12618522644042968`}, {0.1543123245239258, 0.1543123245239258}, {
   0.18243951797485353`, 0.18243951797485353`}, {0.20744142532348633`, 
   0.20744142532348633`}, {0.23556852340698242`, 0.23556852340698242`}, {
   0.26369571685791016`, 0.26369571685791016`}, {0.288697624206543, 
   0.288697624206543}, {0.3105743408203125, 0.3105743408203125}, {
   0.3355762481689453, 0.3355762481689453}, {0.36370344161987306`, 
   0.36370344161987306`}, {0.3918305397033691, 0.3918305397033691}, {
   0.41995773315429685`, 0.41995773315429685`}, {0.44808483123779297`, 
   0.44808483123779297`}, {0.4762121200561523, 0.4762121200561523}, {
   0.5137149810791015, 0.5137149810791015}, {0.5355916023254395, 
   0.5355916023254395}, {0.5543430328369141, 0.5543430328369141}, {
   0.5824702262878418, 0.5824702262878418}, {0.6105973243713378, 
   0.6105973243713378}, {0.6387245178222656, 0.6387245178222656}, {
   0.6668516159057617, 0.6668516159057617}, {0.685603141784668, 
   0.685603141784668}, {0.7137302398681641, 0.7137302398681641}, {
   0.7418574333190918, 0.7418574333190918}, {0.7699846267700196, 
   0.7699846267700196}, {0.7981117248535157, 0.7981117248535157}, {
   0.8231136322021484, 0.8231136322021484}, {0.8512409210205079, 
   0.8512409210205079}, {0.8824932098388671, 0.8824932098388671}, {
   0.9199961662292481, 0.9199961662292481}, {0.9449980735778809, 
   0.9449980735778809}, {0.9731251716613769, 0.9731251716613769}, {
   0.004377555847167969, 0.004377555847167969}, {0.02937946319580078, 
   0.02937946319580078}, {0.08875904083251954, 0.08875904083251954}, {
   0.11063575744628906`, 0.11063575744628906`}, {0.14188814163208008`, 
   0.14188814163208008`}, {0.16689004898071289`, 0.16689004898071289`}, {
   0.1887667655944824, 0.1887667655944824}, {0.20751819610595704`, 
   0.20751819610595704`}, {0.23252010345458984`, 0.23252010345458984`}, {
   0.2512716293334961, 0.2512716293334961}, {0.27002296447753904`, 
   0.27002296447753904`}, {0.2918996810913086, 0.2918996810913086}, {
   0.31690158843994143`, 0.31690158843994143`}, {0.335653018951416, 
   0.335653018951416}, {0.3544044494628906, 0.3544044494628906}, {
   0.3731558799743652, 0.3731558799743652}, {0.3919073104858398, 
   0.3919073104858398}, {0.4106588363647461, 0.4106588363647461}, {
   0.43253555297851565`, 0.43253555297851565`}, {0.4606626510620117, 
   0.4606626510620117}, {0.48878984451293944`, 0.48878984451293944`}, {
   0.5200422286987305, 0.5200422286987305}, {0.5544198036193848, 
   0.5544198036193848}, {0.5731712341308594, 0.5731712341308594}, {
   0.6294256210327148, 0.6294256210327148}, {0.6513023376464844, 
   0.6513023376464844}, {0.6731789588928223, 0.6731789588928223}, {
   0.6950556755065918, 0.6950556755065918}, {0.729433250427246, 
   0.729433250427246}, {0.7544351577758789, 0.7544351577758789}, {
   0.7763118743896484, 0.7763118743896484}, {0.8044389724731446, 
   0.8044389724731446}, {0.8325662612915039, 0.8325662612915039}, {
   0.860693359375, 0.860693359375}, {0.926323413848877, 0.926323413848877}, {
   0.9513253211975098, 0.9513253211975098}, {0.9700767517089843, 
   0.9700767517089843}, {0.9919534683227539, 0.9919534683227539}, {
   0.02008056640625, 0.02008056640625}, {0.048207759857177734`, 
   0.048207759857177734`}, {0.06695919036865235, 0.06695919036865235}, {
   0.08883590698242187, 0.08883590698242187}, {0.12321348190307617`, 
   0.12321348190307617`}, {0.1544658660888672, 0.1544658660888672}, {
   0.18259315490722655`, 0.18259315490722655`}, {0.21072025299072267`, 
   0.21072025299072267`}, {0.22947168350219727`, 0.22947168350219727`}, {
   0.2513484001159668, 0.2513484001159668}, {0.28260078430175783`, 
   0.28260078430175783`}, {0.3076026916503906, 0.3076026916503906}, {
   0.32947940826416017`, 0.32947940826416017`}, {0.34823074340820315`, 
   0.34823074340820315`}, {0.36698226928710936`, 0.36698226928710936`}, {
   0.3888589859008789, 0.3888589859008789}, {0.4107355117797852, 
   0.4107355117797852}, {0.43261232376098635`, 0.43261232376098635`}, {
   0.45448894500732423`, 0.45448894500732423`}, {0.47636566162109373`, 
   0.47636566162109373`}, {0.5076180458068847, 0.5076180458068847}, {
   0.5263694763183594, 0.5263694763183594}, {0.548246192932129, 
   0.548246192932129}, {0.5701229095458984, 0.5701229095458984}, {
   0.5919994354248047, 0.5919994354248047}, {0.6201267242431641, 
   0.6201267242431641}, {0.642003345489502, 0.642003345489502}, {
   0.6638800621032714, 0.6638800621032714}, {0.6857566833496094, 
   0.6857566833496094}, {0.7138839721679687, 0.7138839721679687}, {
   0.7388858795166016, 0.7388858795166016}, {0.7732633590698242, 
   0.7732633590698242}, {0.7951400756835938, 0.7951400756835938}, {
   0.8170167922973632, 0.8170167922973632}, {0.8482691764831543, 
   0.8482691764831543}, {0.8795215606689453, 0.8795215606689453}, {
   0.9045234680175781, 0.9045234680175781}, {0.9264001846313477, 
   0.9264001846313477}, {0.9451517105102539, 0.9451517105102539}, {
   0.9701536178588868, 0.9701536178588868}, {0.9889049530029297, 
   0.9889049530029297}, {0.010781669616699218`, 0.010781669616699218`}, {
   0.02953310012817383, 0.02953310012817383}, {0.05140981674194336, 
   0.05140981674194336}, {0.08266220092773438, 0.08266220092773438}, {
   0.11078929901123047`, 0.11078929901123047`}, {0.132666015625, 
   0.132666015625}, {0.15454273223876952`, 0.15454273223876952`}, {
   0.17329416275024415`, 0.17329416275024415`}, {0.19517087936401367`, 
   0.19517087936401367`}, {0.21392230987548827`, 0.21392230987548827`}, {
   0.23579893112182618`, 0.23579893112182618`}, {0.2576756477355957, 
   0.2576756477355957}, {0.28267765045166016`, 0.28267765045166016`}, {
   0.31080474853515627`, 0.31080474853515627`}, {0.33268146514892577`, 
   0.33268146514892577`}, {0.35143280029296875`, 0.35143280029296875`}, {
   0.3795599937438965, 0.3795599937438965}, {0.40143671035766604`, 
   0.40143671035766604`}, {0.4233133316040039, 0.4233133316040039}, {
   0.4420647621154785, 0.4420647621154785}, {0.4639415740966797, 
   0.4639415740966797}, {0.4889434814453125, 0.4889434814453125}, {
   0.5108200073242187, 0.5108200073242187}, {0.5326967239379883, 
   0.5326967239379883}, {0.5545734405517578, 0.5545734405517578}, {
   0.5764501571655274, 0.5764501571655274}, {0.5983267784118652, 
   0.5983267784118652}, {0.6170782089233399, 0.6170782089233399}, {
   0.6389549255371094, 0.6389549255371094}, {0.7045848846435547, 
   0.7045848846435547}, {0.7295867919921875, 0.7295867919921875}, {
   0.7483383178710937, 0.7483383178710937}, {0.7670897483825684, 
   0.7670897483825684}, {0.7889664649963379, 0.7889664649963379}, {
   0.8264693260192871, 0.8264693260192871}, {0.8452207565307617, 
   0.8452207565307617}, {0.8670974731445312, 0.8670974731445312}, {
   0.8983497619628906, 0.8983497619628906}, {0.9233517646789551, 
   0.9233517646789551}, {0.9421031951904297, 0.9421031951904297}, {
   0.9608546257019043, 0.9608546257019043}, {0.988981819152832, 
   0.988981819152832}, {0.010858440399169922`, 0.010858440399169922`}, {
   0.032735252380371095`, 0.032735252380371095`}, {0.05148658752441406, 
   0.05148658752441406}, {0.0733633041381836, 0.0733633041381836}, {
   0.10461559295654296`, 0.10461559295654296`}, {0.12649240493774414`, 
   0.12649240493774414`}, {0.14524383544921876`, 0.14524383544921876`}, {
   0.16712045669555664`, 0.16712045669555664`}, {0.19524765014648438`, 
   0.19524765014648438`}, {0.22650012969970704`, 0.22650012969970704`}, {
   0.2577524185180664, 0.2577524185180664}, {0.28275432586669924`, 
   0.28275432586669924`}, {0.310881519317627, 0.310881519317627}, {
   0.33588342666625975`, 0.33588342666625975`}, {0.3640106201171875, 
   0.3640106201171875}, {0.3827620506286621, 0.3827620506286621}, {
   0.40776405334472654`, 0.40776405334472654`}, {0.43589115142822266`, 
   0.43589115142822266`}, {0.46401824951171877`, 0.46401824951171877`}, {
   0.4921454429626465, 0.4921454429626465}, {0.5140221595764161, 
   0.5140221595764161}, {0.5358987808227539, 0.5358987808227539}, {
   0.5577754974365234, 0.5577754974365234}, {0.5859025955200196, 
   0.5859025955200196}, {0.6077793121337891, 0.6077793121337891}, {
   0.6296560287475585, 0.6296560287475585}, {0.660908317565918, 
   0.660908317565918}, {0.6827850341796875, 0.6827850341796875}, {
   0.7484150886535644, 0.7484150886535644}, {0.7765422821044922, 
   0.7765422821044922}, {0.8046693801879883, 0.8046693801879883}, {
   0.8265460968017578, 0.8265460968017578}, {0.8484228134155274, 
   0.8484228134155274}, {0.8671742439270019, 0.8671742439270019}, {
   0.8921761512756348, 0.8921761512756348}, {0.9140528678894043, 
   0.9140528678894043}, {0.9359294891357421, 0.9359294891357421}, {
   0.9578062057495117, 0.9578062057495117}, {0.9796829223632812, 
   0.9796829223632812}, {0.0015596389770507813`, 0.0015596389770507813`}, {
   0.02343616485595703, 0.02343616485595703}, {0.04218769073486328, 
   0.04218769073486328}, {0.06406440734863281, 0.06406440734863281}, {
   0.08906631469726563, 0.08906631469726563}, {0.11406822204589843`, 
   0.11406822204589843`}, {0.14219532012939454`, 0.14219532012939454`}, {
   0.16407203674316406`, 0.16407203674316406`}, {0.18907394409179687`, 
   0.18907394409179687`}, {0.21720104217529296`, 0.21720104217529296`}, {
   0.2390777587890625, 0.2390777587890625}, {0.26407976150512696`, 
   0.26407976150512696`}, {0.28595638275146484`, 0.28595638275146484`}, {
   0.3140835762023926, 0.3140835762023926}, {0.3422107696533203, 
   0.3422107696533203}, {0.36408748626708987`, 0.36408748626708987`}, {
   0.38596401214599607`, 0.38596401214599607`}, {0.4078407287597656, 
   0.4078407287597656}, {0.4265922546386719, 0.4265922546386719}, {
   0.4484688758850098, 0.4484688758850098}, {0.4672203063964844, 
   0.4672203063964844}, {0.4953474998474121, 0.4953474998474121}, {
   0.5203494071960449, 0.5203494071960449}, {0.5422260284423828, 
   0.5422260284423828}, {0.560977554321289, 0.560977554321289}, {
   0.5828542709350586, 0.5828542709350586}, {0.6047307968139648, 
   0.6047307968139648}, {0.6328580856323243, 0.6328580856323243}, {
   0.6547347068786621, 0.6547347068786621}, {0.6797366142272949, 
   0.6797366142272949}, {0.7047385215759278, 0.7047385215759278}, {
   0.7266153335571289, 0.7266153335571289}, {0.7484918594360351, 
   0.7484918594360351}, {0.7766191482543945, 0.7766191482543945}, {
   0.8016210556030273, 0.8016210556030273}, {0.8234976768493653, 
   0.8234976768493653}, {0.8484995841979981, 0.8484995841979981}, {
   0.8703763008117675, 0.8703763008117675}, {0.9016286849975585, 
   0.9016286849975585}, {0.9297557830810547, 0.9297557830810547}, {
   0.957883071899414, 0.957883071899414}, {0.9828849792480469, 
   0.9828849792480469}, {0.011012077331542969`, 0.011012077331542969`}, {
   0.0391392707824707, 0.0391392707824707}, {0.057890701293945315`, 
   0.057890701293945315`}, {0.0860177993774414, 0.0860177993774414}, {
   0.11101970672607422`, 0.11101970672607422`}, {0.12977123260498047`, 
   0.12977123260498047`}, {0.15789833068847656`, 0.15789833068847656`}, {
   0.17977504730224608`, 0.17977504730224608`}, {0.1985264778137207, 
   0.1985264778137207}, {0.22352838516235352`, 0.22352838516235352`}, {
   0.25165557861328125`, 0.25165557861328125`}, {0.27040700912475585`, 
   0.27040700912475585`}, {0.2985342025756836, 0.2985342025756836}, {
   0.329786491394043, 0.329786491394043}, {0.35791378021240233`, 
   0.35791378021240233`}, {0.3766651153564453, 0.3766651153564453}, {
   0.3954166412353516, 0.3954166412353516}, {0.42354373931884765`, 
   0.42354373931884765`}, {0.4454204559326172, 0.4454204559326172}, {
   0.4641718864440918, 0.4641718864440918}, {0.49229907989501953`, 
   0.49229907989501953`}, {0.5141757965087891, 0.5141757965087891}, {
   0.5423028945922852, 0.5423028945922852}, {0.5673048019409179, 
   0.5673048019409179}, {0.5954319953918457, 0.5954319953918457}, {
   0.6235590934753418, 0.6235590934753418}, {0.6516862869262695, 
   0.6516862869262695}, {0.6829387664794921, 0.6829387664794921}, {
   0.7173162460327148, 0.7173162460327148}, {0.7391929626464844, 
   0.7391929626464844}, {0.7579444885253906, 0.7579444885253906}, {
   0.7860715866088868, 0.7860715866088868}, {0.8110734939575195, 
   0.8110734939575195}, {0.8423259735107422, 0.8423259735107422}, {
   0.867327880859375, 0.867327880859375}, {0.8985801696777344, 
   0.8985801696777344}, {0.9267074584960937, 0.9267074584960937}, {
   0.9548345565795898, 0.9548345565795898}, {0.9860869407653808, 
   0.9860869407653808}, {0.0017131805419921876`, 0.0017131805419921876`}, {
   0.02358980178833008, 0.02358980178833008}, {0.04234123229980469, 
   0.04234123229980469}, {0.06421794891357421, 0.06421794891357421}, {
   0.08921985626220703, 0.08921985626220703}, {0.11422176361083984`, 
   0.11422176361083984`}, {0.1329732894897461, 0.1329732894897461}, {
   0.1579751968383789, 0.1579751968383789}, {0.186102294921875, 
   0.186102294921875}, {0.21422948837280273`, 0.21422948837280273`}, {
   0.23298091888427735`, 0.23298091888427735`}, {0.2611080169677734, 
   0.2611080169677734}, {0.28298473358154297`, 0.28298473358154297`}, {
   0.3142372131347656, 0.3142372131347656}, {0.33298864364624026`, 
   0.33298864364624026`}, {0.35486526489257814`, 0.35486526489257814`}, {
   0.38299245834350587`, 0.38299245834350587`}, {0.4111196517944336, 
   0.4111196517944336}, {0.43924674987792967`, 0.43924674987792967`}, {
   0.4673738479614258, 0.4673738479614258}, {0.49550113677978513`, 
   0.49550113677978513`}, {0.5236282348632812, 0.5236282348632812}, {
   0.5423796653747559, 0.5423796653747559}, {0.5705068588256836, 
   0.5705068588256836}, {0.5986339569091796, 0.5986339569091796}, {
   0.6298864364624024, 0.6298864364624024}, {0.6486377716064453, 
   0.6486377716064453}, {0.6673892974853516, 0.6673892974853516}, {
   0.7017669677734375, 0.7017669677734375}, {0.7236435890197754, 
   0.7236435890197754}, {0.74239501953125, 0.74239501953125}, {
   0.7705222129821777, 0.7705222129821777}, {0.7892736434936524, 
   0.7892736434936524}, {0.8174007415771485, 0.8174007415771485}, {
   0.8455280303955078, 0.8455280303955078}, {0.8642793655395508, 
   0.8642793655395508}, {0.8861560821533203, 0.8861560821533203}, {
   0.9236589431762695, 0.9236589431762695}, {0.9455356597900391, 
   0.9455356597900391}, {0.9736627578735352, 0.9736627578735352}, {
   0.9924142837524415, 0.9924142837524415}, {0.011165618896484375`, 
   0.011165618896484375`}, {0.03929290771484375, 0.03929290771484375}, {
   0.06742000579833984, 0.06742000579833984}, {0.08929672241210937, 
   0.08929672241210937}, {0.11742382049560547`, 0.11742382049560547`}, {
   0.1455510139465332, 0.1455510139465332}, {0.16430244445800782`, 
   0.16430244445800782`}, {0.1924295425415039, 0.1924295425415039}, {
   0.2205568313598633, 0.2205568313598633}, {0.23930816650390624`, 
   0.23930816650390624`}, {0.2611848831176758, 0.2611848831176758}, {
   0.28618679046630857`, 0.28618679046630857`}, {0.3143139839172363, 
   0.3143139839172363}, {0.3424410820007324, 0.3424410820007324}, {
   0.361192512512207, 0.361192512512207}, {0.3830692291259766, 
   0.3830692291259766}, {0.41119632720947263`, 0.41119632720947263`}, {
   0.4330730438232422, 0.4330730438232422}, {0.45182456970214846`, 
   0.45182456970214846`}, {0.48620214462280276`, 0.48620214462280276`}, {
   0.523705005645752, 0.523705005645752}, {0.5455817222595215, 
   0.5455817222595215}, {0.5674583435058593, 0.5674583435058593}, {
   0.5924602508544922, 0.5924602508544922}, {0.6112117767333984, 
   0.6112117767333984}, {0.633088493347168, 0.633088493347168}, {
   0.6549651145935058, 0.6549651145935058}, {0.6893427848815918, 
   0.6893427848815918}, {0.7143446922302246, 0.7143446922302246}, {
   0.7393465995788574, 0.7393465995788574}, {0.7674737930297851, 
   0.7674737930297851}, {0.7893505096435547, 0.7893505096435547}, {
   0.8174776077270508, 0.8174776077270508}, {0.8362290382385253, 
   0.8362290382385253}, {0.85498046875, 0.85498046875}, {0.8799823760986328, 
   0.8799823760986328}, {0.9081095695495606, 0.9081095695495606}, {
   0.9393619537353516, 0.9393619537353516}, {0.9674890518188477, 
   0.9674890518188477}, {0.9862405776977539, 0.9862405776977539}, {
   0.004991912841796875, 0.004991912841796875}, {0.026868724822998048`, 
   0.026868724822998048`}, {0.045620155334472653`, 0.045620155334472653`}, {
   0.07374725341796876, 0.07374725341796876}, {0.1049997329711914, 
   0.1049997329711914}, {0.12375106811523437`, 0.12375106811523437`}, {
   0.15187835693359375`, 0.15187835693359375`}, {0.18000545501708984`, 
   0.18000545501708984`}, {0.20813255310058593`, 0.20813255310058593`}, {
   0.23625974655151366`, 0.23625974655151366`}, {0.2581364631652832, 
   0.2581364631652832}, {0.283138370513916, 0.283138370513916}, {
   0.32064132690429686`, 0.32064132690429686`}, {0.33939266204833984`, 
   0.33939266204833984`}, {0.3581441879272461, 0.3581441879272461}, {
   0.3862712860107422, 0.3862712860107422}, {0.40814800262451173`, 
   0.40814800262451173`}, {0.4300246238708496, 0.4300246238708496}, {
   0.45815181732177734`, 0.45815181732177734`}, {0.49252948760986326`, 
   0.49252948760986326`}, {0.5144062042236328, 0.5144062042236328}, {
   0.5331575393676757, 0.5331575393676757}, {0.5550342559814453, 
   0.5550342559814453}, {0.5800361633300781, 0.5800361633300781}, {
   0.6019128799438477, 0.6019128799438477}, {0.6206643104553222, 
   0.6206643104553222}, {0.6425409317016602, 0.6425409317016602}, {
   0.6644176483154297, 0.6644176483154297}, {0.683169174194336, 
   0.683169174194336}, {0.7206720352172852, 0.7206720352172852}, {
   0.7487991333007813, 0.7487991333007813}, {0.7675505638122558, 
   0.7675505638122558}, {0.7863019943237305, 0.7863019943237305}, {
   0.8081787109375, 0.8081787109375}, {0.8300553321838379, 
   0.8300553321838379}, {0.8519320487976074, 0.8519320487976074}, {
   0.8706834793090821, 0.8706834793090821}, {0.8956853866577148, 
   0.8956853866577148}, {0.9175621032714844, 0.9175621032714844}, {
   0.9425640106201172, 0.9425640106201172}, {0.9706912040710449, 
   0.9706912040710449}, {0.998818302154541, 0.998818302154541}, {
   0.02694549560546875, 0.02694549560546875}, {0.048822212219238284`, 
   0.048822212219238284`}, {0.07069892883300781, 0.07069892883300781}, {
   0.09257545471191406, 0.09257545471191406}, {0.11757736206054688`, 
   0.11757736206054688`}, {0.13632888793945314`, 0.13632888793945314`}, {
   0.16445608139038087`, 0.16445608139038087`}, {0.19258317947387696`, 
   0.19258317947387696`}, {0.22383556365966797`, 0.22383556365966797`}, {
   0.2457122802734375, 0.2457122802734375}, {0.2738393783569336, 
   0.2738393783569336}, {0.3113422393798828, 0.3113422393798828}, {
   0.33321895599365237`, 0.33321895599365237`}, {0.35509567260742186`, 
   0.35509567260742186`}, {0.38947334289550783`, 0.38947334289550783`}, {
   0.40822477340698243`, 0.40822477340698243`}, {0.43635196685791017`, 
   0.43635196685791017`}, {0.4801052093505859, 0.4801052093505859}, {
   0.5051071166992187, 0.5051071166992187}, {0.5269838333129883, 
   0.5269838333129883}, {0.5488605499267578, 0.5488605499267578}, {
   0.5738624572753906, 0.5738624572753906}, {0.5988643646240235, 
   0.5988643646240235}, {0.6207409858703613, 0.6207409858703613}, {
   0.6457428932189941, 0.6457428932189941}, {0.6676197052001953, 
   0.6676197052001953}, {0.6957468032836914, 0.6957468032836914}, {
   0.7238739013671875, 0.7238739013671875}, {0.7488758087158203, 
   0.7488758087158203}, {0.7676273345947265, 0.7676273345947265}, {
   0.7926291465759278, 0.7926291465759278}, {0.8176310539245606, 
   0.8176310539245606}, {0.8457581520080566, 0.8457581520080566}, {
   0.8738853454589843, 0.8738853454589843}, {0.8957620620727539, 
   0.8957620620727539}, {0.9145134925842285, 0.9145134925842285}, {
   0.9363901138305664, 0.9363901138305664}, {0.9520163536071777, 
   0.9520163536071777}, {0.9770182609558106, 0.9770182609558106}, {
   0.9957697868347168, 0.9957697868347168}, {0.02389688491821289, 
   0.02389688491821289}, {0.0488987922668457, 0.0488987922668457}, {
   0.07390069961547852, 0.07390069961547852}, {0.09890260696411132, 
   0.09890260696411132}}}, 
  RowBox[{"{", 
   RowBox[{
    AnimatorBox[
     Dynamic[$CellContext`x$$, ($CellContext`x$$ = #; 
      AppendTo[$CellContext`xlis$$, {#, #}])& ],
     PausedTime->335.6976537704468], ",", 
    GraphicsBox[LineBox[Dynamic[$CellContext`xlis$$]],
     Axes->True,
     PlotRange->{{0, 1}, {0, 1}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{536, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1097557876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77122752],

Cell[TextData[{
 "Animating a fixed list of expressions can be done directly with ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->543530855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1", ",", "0.01"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->924018453],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 99, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 101, 1}}, Typeset`size$$ = 
    Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`i$11431$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 101, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->349.96437549591064`]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[LineBox[{{0, 0}, {0., 0.}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 2->
                GraphicsBox[LineBox[{{0, 0}, {0.01, 0.01}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 3->
                GraphicsBox[LineBox[{{0, 0}, {0.02, 0.02}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 4->
                GraphicsBox[LineBox[{{0, 0}, {0.03, 0.03}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 5->
                GraphicsBox[LineBox[{{0, 0}, {0.04, 0.04}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 6->
                GraphicsBox[LineBox[{{0, 0}, {0.05, 0.05}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 7->
                GraphicsBox[LineBox[{{0, 0}, {0.06, 0.06}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 8->
                GraphicsBox[LineBox[{{0, 0}, {0.07, 0.07}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 9->
                GraphicsBox[LineBox[{{0, 0}, {0.08, 0.08}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 10->
                GraphicsBox[LineBox[{{0, 0}, {0.09, 0.09}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 11->
                GraphicsBox[LineBox[{{0, 0}, {0.1, 0.1}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 12->
                GraphicsBox[LineBox[{{0, 0}, {0.11, 0.11}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 13->
                GraphicsBox[LineBox[{{0, 0}, {0.12, 0.12}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 14->
                GraphicsBox[LineBox[{{0, 0}, {0.13, 0.13}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 15->
                GraphicsBox[LineBox[{{0, 0}, {0.14, 0.14}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 16->
                GraphicsBox[LineBox[{{0, 0}, {0.15, 0.15}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 17->
                GraphicsBox[LineBox[{{0, 0}, {0.16, 0.16}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 18->
                GraphicsBox[LineBox[{{0, 0}, {0.17, 0.17}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 19->
                GraphicsBox[LineBox[{{0, 0}, {0.18, 0.18}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 20->
                GraphicsBox[LineBox[{{0, 0}, {0.19, 0.19}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 21->
                GraphicsBox[LineBox[{{0, 0}, {0.2, 0.2}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 22->
                GraphicsBox[LineBox[{{0, 0}, {0.21, 0.21}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 23->
                GraphicsBox[LineBox[{{0, 0}, {0.22, 0.22}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 24->
                GraphicsBox[LineBox[{{0, 0}, {0.23, 0.23}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 25->
                GraphicsBox[LineBox[{{0, 0}, {0.24, 0.24}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 26->
                GraphicsBox[LineBox[{{0, 0}, {0.25, 0.25}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 27->
                GraphicsBox[LineBox[{{0, 0}, {0.26, 0.26}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 28->
                GraphicsBox[LineBox[{{0, 0}, {0.27, 0.27}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 29->
                GraphicsBox[LineBox[{{0, 0}, {0.28, 0.28}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 30->
                GraphicsBox[LineBox[{{0, 0}, {0.29, 0.29}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 31->
                GraphicsBox[LineBox[{{0, 0}, {0.3, 0.3}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 32->
                GraphicsBox[LineBox[{{0, 0}, {0.31, 0.31}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 33->
                GraphicsBox[LineBox[{{0, 0}, {0.32, 0.32}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 34->
                GraphicsBox[LineBox[{{0, 0}, {0.33, 0.33}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 35->
                GraphicsBox[LineBox[{{0, 0}, {0.34, 0.34}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 36->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.35000000000000003`, 
                   0.35000000000000003`}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 37->
                GraphicsBox[LineBox[{{0, 0}, {0.36, 0.36}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 38->
                GraphicsBox[LineBox[{{0, 0}, {0.37, 0.37}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 39->
                GraphicsBox[LineBox[{{0, 0}, {0.38, 0.38}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 40->
                GraphicsBox[LineBox[{{0, 0}, {0.39, 0.39}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 41->
                GraphicsBox[LineBox[{{0, 0}, {0.4, 0.4}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 42->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.41000000000000003`, 
                   0.41000000000000003`}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 43->
                GraphicsBox[LineBox[{{0, 0}, {0.42, 0.42}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 44->
                GraphicsBox[LineBox[{{0, 0}, {0.43, 0.43}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 45->
                GraphicsBox[LineBox[{{0, 0}, {0.44, 0.44}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 46->
                GraphicsBox[LineBox[{{0, 0}, {0.45, 0.45}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 47->
                GraphicsBox[LineBox[{{0, 0}, {0.46, 0.46}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 48->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.47000000000000003`, 
                   0.47000000000000003`}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 49->
                GraphicsBox[LineBox[{{0, 0}, {0.48, 0.48}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 50->
                GraphicsBox[LineBox[{{0, 0}, {0.49, 0.49}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 51->
                GraphicsBox[LineBox[{{0, 0}, {0.5, 0.5}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 52->
                GraphicsBox[LineBox[{{0, 0}, {0.51, 0.51}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 53->
                GraphicsBox[LineBox[{{0, 0}, {0.52, 0.52}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 54->
                GraphicsBox[LineBox[{{0, 0}, {0.53, 0.53}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 55->
                GraphicsBox[LineBox[{{0, 0}, {0.54, 0.54}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 56->
                GraphicsBox[LineBox[{{0, 0}, {0.55, 0.55}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 57->
                GraphicsBox[LineBox[{{0, 0}, {0.56, 0.56}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 58->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.5700000000000001, 0.5700000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 59->
                GraphicsBox[LineBox[{{0, 0}, {0.58, 0.58}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 60->
                GraphicsBox[LineBox[{{0, 0}, {0.59, 0.59}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 61->
                GraphicsBox[LineBox[{{0, 0}, {0.6, 0.6}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 62->
                GraphicsBox[LineBox[{{0, 0}, {0.61, 0.61}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 63->
                GraphicsBox[LineBox[{{0, 0}, {0.62, 0.62}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 64->
                GraphicsBox[LineBox[{{0, 0}, {0.63, 0.63}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 65->
                GraphicsBox[LineBox[{{0, 0}, {0.64, 0.64}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 66->
                GraphicsBox[LineBox[{{0, 0}, {0.65, 0.65}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 67->
                GraphicsBox[LineBox[{{0, 0}, {0.66, 0.66}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 68->
                GraphicsBox[LineBox[{{0, 0}, {0.67, 0.67}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 69->
                GraphicsBox[LineBox[{{0, 0}, {0.68, 0.68}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 70->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.6900000000000001, 0.6900000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 71->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.7000000000000001, 0.7000000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 72->
                GraphicsBox[LineBox[{{0, 0}, {0.71, 0.71}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 73->
                GraphicsBox[LineBox[{{0, 0}, {0.72, 0.72}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 74->
                GraphicsBox[LineBox[{{0, 0}, {0.73, 0.73}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 75->
                GraphicsBox[LineBox[{{0, 0}, {0.74, 0.74}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 76->
                GraphicsBox[LineBox[{{0, 0}, {0.75, 0.75}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 77->
                GraphicsBox[LineBox[{{0, 0}, {0.76, 0.76}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 78->
                GraphicsBox[LineBox[{{0, 0}, {0.77, 0.77}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 79->
                GraphicsBox[LineBox[{{0, 0}, {0.78, 0.78}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 80->
                GraphicsBox[LineBox[{{0, 0}, {0.79, 0.79}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 81->
                GraphicsBox[LineBox[{{0, 0}, {0.8, 0.8}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 82->
                GraphicsBox[LineBox[{{0, 0}, {0.81, 0.81}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 83->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.8200000000000001, 0.8200000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 84->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.8300000000000001, 0.8300000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 85->
                GraphicsBox[LineBox[{{0, 0}, {0.84, 0.84}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 86->
                GraphicsBox[LineBox[{{0, 0}, {0.85, 0.85}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 87->
                GraphicsBox[LineBox[{{0, 0}, {0.86, 0.86}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 88->
                GraphicsBox[LineBox[{{0, 0}, {0.87, 0.87}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 89->
                GraphicsBox[LineBox[{{0, 0}, {0.88, 0.88}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 90->
                GraphicsBox[LineBox[{{0, 0}, {0.89, 0.89}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 91->
                GraphicsBox[LineBox[{{0, 0}, {0.9, 0.9}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 92->
                GraphicsBox[LineBox[{{0, 0}, {0.91, 0.91}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 93->
                GraphicsBox[LineBox[{{0, 0}, {0.92, 0.92}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 94->
                GraphicsBox[LineBox[{{0, 0}, {0.93, 0.93}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 95->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.9400000000000001, 0.9400000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 96->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.9500000000000001, 0.9500000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 97->
                GraphicsBox[LineBox[{{0, 0}, {0.96, 0.96}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 98->
                GraphicsBox[LineBox[{{0, 0}, {0.97, 0.97}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 99->
                GraphicsBox[LineBox[{{0, 0}, {0.98, 0.98}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 100->
                GraphicsBox[LineBox[{{0, 0}, {0.99, 0.99}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 101->
                GraphicsBox[LineBox[{{0, 0}, {1., 1.}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$11431$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 101, 1}, 101, 
            1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {115.5, 120.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{2, 2}, {5, 0}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{321, 251},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1918177849]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15567],

Cell[TextData[{
 "Fix ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to stop animations from jiggling:"
}], "ExampleText",
 CellID->358202118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"x", " ", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59671182],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2}}, Typeset`size$$ = {180., {58., 62.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$48495$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$48495$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sinc[$CellContext`x $CellContext`t$$], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`t$$, 0, 2, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {95., 100.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202761377]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"x", " ", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54263586],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2}}, Typeset`size$$ = {180., {53., 57.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$48525$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$48525$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sinc[$CellContext`x $CellContext`t$$], {$CellContext`x, 0, 10}, 
        PlotRange -> {-1, 1}], 
      "Specifications" :> {{$CellContext`t$$, 0, 2, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {90., 95.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1901399097]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->406721149],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " to make sure different labels do not make the image size change:"
}], "ExampleText",
 CellID->478887018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "n"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118462967],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1.9946652412414552`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 4}}, Typeset`size$$ = {180., {49., 53.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$32623$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$32623$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`x^$CellContext`n$$ 
        Sin[$CellContext`x], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`n$$, 1, 4, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {86., 91.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1693805613]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "n"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "25"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->693782640],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 3.2039137840270993`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 4}}, Typeset`size$$ = {180., {63., 67.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$32651$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$32651$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`x^$CellContext`n$$ 
        Sin[$CellContext`x], {$CellContext`x, 0, 10}, ImagePadding -> 25], 
      "Specifications" :> {{$CellContext`n$$, 1, 4, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {100., 105.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->747713059]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->166210904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110472272],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 6}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$48627$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$48627$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Circle[], 
         Point[{
           Cos[$CellContext`t$$], 
           Sin[$CellContext`t$$]}]}], 
      "Specifications" :> {{$CellContext`t$$, 0, 6, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {125., 130.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352371431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153719460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"t", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "1"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"-", 
         SuperscriptBox["x", "2"]}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], ",", ".3"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", ".3"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0.6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1.6"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ",", 
     
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "->", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102342208],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0.08393077850341797, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 1}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$43097$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$43097$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`t$$ ($CellContext`x^2 - 1) + (
          1 - $CellContext`t$$) (-$CellContext`x^2), {$CellContext`x, -1, 1}, 
        Axes -> False, Epilog -> {
          Circle[{0, 1}, 3], 
          Disk[{1, 2}, 0.3], 
          Disk[{-1, 2}, 0.3], 
          Line[{{0, 0.6}, {0, 1.6}}]}, PlotRange -> {{-3, 3}, {-2, 4}}, 
        AspectRatio -> 1], 
      "Specifications" :> {{$CellContext`t$$, 0, 1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {125., 130.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->700400067]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1441],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListAnimate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListAnimate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Play",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Play"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AutorunSequencing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutorunSequencing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5936]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24117],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->9420325],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->308484314],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->136011677],

Cell[TextData[ButtonBox["Presentations with Mathematica ",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PresentationsWithMathematica"]], "MoreAbout",
 CellID->140899468],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->25861062],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->16991917],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->201513202]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Animate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 12.2676990}", "context" -> "System`", 
    "keywords" -> {
     "animating algorithms", "animating anything", "animating computations", 
      "animating formulas", "animating graphics", "animating plots", 
      "animation", "flip book animation", "key frame animation", 
      "movie making", "movies"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Animate[expr, {u, u_min, u_max}] generates an animation of expr in which \
u varies continuously from u_min to u_max. Animate[expr, {u, u_min, u_max, \
du}] takes u to vary in steps du. Animate[expr, {u, {u_1, u_2, ...}}] makes u \
take on discrete values u_1, u_2, .... Animate[expr, {u, ...}, {v, ...}, ...] \
varies all the variables u, v, .... ", "synonyms" -> {}, "title" -> "Animate",
     "type" -> "Symbol", "uri" -> "ref/Animate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21130, 671, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->77531100]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 436117, 9625}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3383, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4006, 101, 1572, 37, 70, "ObjectNameGrid"],
Cell[5581, 140, 3818, 128, 70, "Usage",
 CellID->26611]
}, Open  ]],
Cell[CellGroupData[{
Cell[9436, 273, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9914, 290, 166, 5, 70, "Notes",
 CellID->16292],
Cell[10083, 297, 358, 13, 70, "Notes",
 CellID->17591],
Cell[10444, 312, 815, 32, 70, "Notes",
 CellID->3832],
Cell[11262, 346, 477, 17, 70, "Notes",
 CellID->27123],
Cell[11742, 365, 665, 23, 70, "Notes",
 CellID->6461],
Cell[12410, 390, 673, 24, 70, "Notes",
 CellID->16991],
Cell[13086, 416, 454, 17, 70, "Notes",
 CellID->31461],
Cell[13543, 435, 361, 12, 70, "Notes",
 CellID->27330],
Cell[13907, 449, 4680, 125, 70, "3ColumnTableMod",
 CellID->28498],
Cell[18590, 576, 555, 21, 70, "Notes",
 CellID->17369],
Cell[19148, 599, 393, 14, 70, "Notes",
 CellID->17291],
Cell[19544, 615, 403, 13, 70, "Notes",
 CellID->8400],
Cell[19950, 630, 595, 17, 70, "Notes",
 CellID->14179],
Cell[20548, 649, 545, 17, 70, "Notes",
 CellID->55815475]
}, Closed]],
Cell[CellGroupData[{
Cell[21130, 671, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77531100],
Cell[CellGroupData[{
Cell[21514, 685, 148, 5, 70, "ExampleSection",
 CellID->372420783],
Cell[21665, 692, 148, 5, 70, "ExampleText",
 CellID->365412034],
Cell[CellGroupData[{
Cell[21838, 701, 366, 12, 28, "Input",
 CellID->250043689],
Cell[22207, 715, 1902, 42, 204, "Output",
 CellID->228822919]
}, Open  ]],
Cell[24124, 760, 124, 3, 70, "ExampleDelimiter",
 CellID->55387033],
Cell[24251, 765, 137, 5, 70, "ExampleText",
 CellID->3357298],
Cell[CellGroupData[{
Cell[24413, 774, 458, 14, 70, "Input",
 CellID->346730662],
Cell[24874, 790, 1895, 42, 70, "Output",
 CellID->1367374240]
}, Open  ]],
Cell[26784, 835, 124, 3, 70, "ExampleDelimiter",
 CellID->59764530],
Cell[26911, 840, 197, 7, 70, "ExampleText",
 CellID->46989047],
Cell[CellGroupData[{
Cell[27133, 851, 575, 18, 70, "Input",
 CellID->801178321],
Cell[27711, 871, 2333, 50, 70, "Output",
 CellID->756068560]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30093, 927, 220, 7, 70, "ExampleSection",
 CellID->109198024],
Cell[CellGroupData[{
Cell[30338, 938, 235, 7, 70, "ExampleSubsection",
 CellID->65322756],
Cell[30576, 947, 59, 1, 70, "ExampleText",
 CellID->1349705158],
Cell[CellGroupData[{
Cell[30660, 952, 367, 12, 70, "Input",
 CellID->1266056862],
Cell[31030, 966, 1915, 42, 70, "Output",
 CellID->1663140108]
}, Open  ]],
Cell[32960, 1011, 125, 3, 70, "ExampleDelimiter",
 CellID->288418841],
Cell[33088, 1016, 86, 1, 70, "ExampleText",
 CellID->494462885],
Cell[CellGroupData[{
Cell[33199, 1021, 239, 7, 70, "Input",
 CellID->387653174],
Cell[33441, 1030, 1877, 41, 70, "Output",
 CellID->2025038493]
}, Open  ]],
Cell[CellGroupData[{
Cell[35355, 1076, 371, 12, 70, "Input",
 CellID->354677824],
Cell[35729, 1090, 1885, 42, 70, "Output",
 CellID->74010893]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37663, 1138, 236, 7, 70, "ExampleSubsection",
 CellID->103229521],
Cell[37902, 1147, 73, 1, 70, "ExampleText",
 CellID->383340055],
Cell[CellGroupData[{
Cell[38000, 1152, 366, 12, 70, "Input",
 CellID->345363385],
Cell[38369, 1166, 1915, 42, 70, "Output",
 CellID->2021597501]
}, Open  ]],
Cell[40299, 1211, 123, 3, 70, "ExampleDelimiter",
 CellID->3175417],
Cell[40425, 1216, 240, 8, 70, "ExampleText",
 CellID->336955567],
Cell[CellGroupData[{
Cell[40690, 1228, 770, 20, 70, "Input",
 CellID->297837430],
Cell[41463, 1250, 15650, 322, 70, "Output",
 CellID->1501114195]
}, Open  ]],
Cell[57128, 1575, 124, 3, 70, "ExampleDelimiter",
 CellID->43424101],
Cell[57255, 1580, 69, 1, 70, "ExampleText",
 CellID->1650420120],
Cell[CellGroupData[{
Cell[57349, 1585, 431, 13, 70, "Input",
 CellID->1712172188],
Cell[57783, 1600, 1917, 43, 70, "Output",
 CellID->30119425]
}, Open  ]],
Cell[59715, 1646, 125, 3, 70, "ExampleDelimiter",
 CellID->409072142],
Cell[59843, 1651, 137, 4, 70, "ExampleText",
 CellID->90550459],
Cell[CellGroupData[{
Cell[60005, 1659, 422, 13, 70, "Input",
 CellID->35696393],
Cell[60430, 1674, 1994, 45, 70, "Output",
 CellID->75542499]
}, Open  ]],
Cell[62439, 1722, 124, 3, 70, "ExampleDelimiter",
 CellID->24158891],
Cell[62566, 1727, 84, 1, 70, "ExampleText",
 CellID->296494773],
Cell[CellGroupData[{
Cell[62675, 1732, 488, 16, 70, "Input",
 CellID->1392089528],
Cell[63166, 1750, 1930, 42, 70, "Output",
 CellID->449769357]
}, Open  ]],
Cell[65111, 1795, 125, 3, 70, "ExampleDelimiter",
 CellID->304192826],
Cell[65239, 1800, 77, 1, 70, "ExampleText",
 CellID->612038119],
Cell[CellGroupData[{
Cell[65341, 1805, 693, 22, 70, "Input",
 CellID->64160304],
Cell[66037, 1829, 2364, 50, 70, "Output",
 CellID->50837115]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[68462, 1886, 222, 7, 70, "ExampleSection",
 CellID->193836991],
Cell[CellGroupData[{
Cell[68709, 1897, 229, 7, 70, "ExampleSubsection",
 CellID->33155791],
Cell[68941, 1906, 62, 1, 70, "ExampleText",
 CellID->1894547371],
Cell[CellGroupData[{
Cell[69028, 1911, 982, 30, 70, "Input",
 CellID->1069319294],
Cell[70013, 1943, 5837, 121, 70, "Output",
 CellID->201425501]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75899, 2070, 238, 7, 70, "ExampleSubsection",
 CellID->40604843],
Cell[76140, 2079, 79, 1, 70, "ExampleText",
 CellID->1108710775],
Cell[CellGroupData[{
Cell[76244, 2084, 449, 14, 70, "Input",
 CellID->55466627],
Cell[76696, 2100, 5635, 121, 70, "Output",
 CellID->1883706341]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82380, 2227, 234, 7, 70, "ExampleSubsection",
 CellID->578273666],
Cell[82617, 2236, 74, 1, 70, "ExampleText",
 CellID->1999728756],
Cell[CellGroupData[{
Cell[82716, 2241, 441, 14, 70, "Input",
 CellID->1472862678],
Cell[83160, 2257, 7367, 156, 70, "Output",
 CellID->78323923]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[90576, 2419, 241, 7, 70, "ExampleSubsection",
 CellID->105287832],
Cell[90820, 2428, 83, 1, 70, "ExampleText",
 CellID->1949472372],
Cell[CellGroupData[{
Cell[90928, 2433, 368, 11, 70, "Input",
 CellID->2104647758],
Cell[91299, 2446, 5651, 121, 70, "Output",
 CellID->1229102618]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96999, 2573, 236, 7, 70, "ExampleSubsection",
 CellID->35013813],
Cell[97238, 2582, 223, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[97486, 2594, 186, 6, 70, "Input",
 CellID->1205777555],
Cell[97675, 2602, 1841, 41, 70, "Output",
 CellID->1248549113]
}, Open  ]],
Cell[99531, 2646, 125, 3, 70, "ExampleDelimiter",
 CellID->138241497],
Cell[99659, 2651, 465, 17, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[100149, 2672, 245, 7, 70, "Input",
 CellID->1286170056],
Cell[100397, 2681, 1883, 42, 70, "Output",
 CellID->123824802]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102329, 2729, 236, 7, 70, "ExampleSubsection",
 CellID->30315736],
Cell[102568, 2738, 80, 1, 70, "ExampleText",
 CellID->937862426],
Cell[CellGroupData[{
Cell[102673, 2743, 783, 20, 70, "Input",
 CellID->1651027390],
Cell[103459, 2765, 17047, 357, 70, "Output",
 CellID->1302227354]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[120555, 3128, 238, 7, 70, "ExampleSubsection",
 CellID->74343014],
Cell[120796, 3137, 334, 13, 70, "ExampleText",
 CellID->701940153],
Cell[CellGroupData[{
Cell[121155, 3154, 245, 7, 70, "Input",
 CellID->1380478500],
Cell[121403, 3163, 1847, 41, 70, "Output",
 CellID->1529292101]
}, Open  ]],
Cell[123265, 3207, 125, 3, 70, "ExampleDelimiter",
 CellID->158675264],
Cell[123393, 3212, 235, 8, 70, "ExampleText",
 CellID->1666052553],
Cell[CellGroupData[{
Cell[123653, 3224, 607, 17, 70, "Input",
 CellID->2044469172],
Cell[124263, 3243, 9330, 193, 70, "Output",
 CellID->1728054211]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[133642, 3442, 236, 7, 70, "ExampleSubsection",
 CellID->40901516],
Cell[133881, 3451, 75, 1, 70, "ExampleText",
 CellID->201584103],
Cell[CellGroupData[{
Cell[133981, 3456, 670, 19, 70, "Input",
 CellID->1319776749],
Cell[134654, 3477, 6183, 126, 70, "Output",
 CellID->287780608]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[140886, 3609, 235, 7, 70, "ExampleSubsection",
 CellID->4907458],
Cell[141124, 3618, 81, 1, 70, "ExampleText",
 CellID->1528815672],
Cell[CellGroupData[{
Cell[141230, 3623, 506, 15, 70, "Input",
 CellID->369874048],
Cell[141739, 3640, 7409, 155, 70, "Output",
 CellID->838282249]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[149197, 3801, 236, 7, 70, "ExampleSubsection",
 CellID->151174201],
Cell[149436, 3810, 94, 1, 70, "ExampleText",
 CellID->1049336160],
Cell[CellGroupData[{
Cell[149555, 3815, 364, 11, 70, "Input",
 CellID->1057131956],
Cell[149922, 3828, 5558, 118, 70, "Output",
 CellID->122804258]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[155529, 3952, 229, 7, 70, "ExampleSubsection",
 CellID->104284388],
Cell[155761, 3961, 95, 1, 70, "ExampleText",
 CellID->1185264306],
Cell[CellGroupData[{
Cell[155881, 3966, 375, 11, 70, "Input",
 CellID->180107366],
Cell[156259, 3979, 1908, 43, 70, "Output",
 CellID->1517034623]
}, Open  ]],
Cell[158182, 4025, 125, 3, 70, "ExampleDelimiter",
 CellID->103183483],
Cell[158310, 4030, 233, 8, 70, "ExampleText",
 CellID->378569079],
Cell[CellGroupData[{
Cell[158568, 4042, 425, 12, 70, "Input",
 CellID->898456130],
Cell[158996, 4056, 1914, 42, 70, "Output",
 CellID->1875051577]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[160959, 4104, 235, 7, 70, "ExampleSubsection",
 CellID->21024239],
Cell[161197, 4113, 95, 1, 70, "ExampleText",
 CellID->963976181],
Cell[CellGroupData[{
Cell[161317, 4118, 636, 19, 70, "Input",
 CellID->1768282953],
Cell[161956, 4139, 1981, 44, 70, "Output",
 CellID->648874556]
}, Open  ]],
Cell[163952, 4186, 222, 8, 70, "ExampleText",
 CellID->931041099],
Cell[CellGroupData[{
Cell[164199, 4198, 692, 20, 70, "Input",
 CellID->505400238],
Cell[164894, 4220, 2005, 44, 70, "Output",
 CellID->511596560]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[166948, 4270, 231, 7, 70, "ExampleSubsection",
 CellID->206794484],
Cell[167182, 4279, 73, 1, 70, "ExampleText",
 CellID->175289357],
Cell[CellGroupData[{
Cell[167280, 4284, 301, 9, 70, "Input",
 CellID->394705405],
Cell[167584, 4295, 1866, 42, 70, "Output",
 CellID->101513562]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[169499, 4343, 232, 7, 70, "ExampleSubsection",
 CellID->49516647],
Cell[169734, 4352, 62, 1, 70, "ExampleText",
 CellID->1824339175],
Cell[CellGroupData[{
Cell[169821, 4357, 536, 16, 70, "Input",
 CellID->2135511060],
Cell[170360, 4375, 7430, 155, 70, "Output",
 CellID->1816818561]
}, Open  ]],
Cell[177805, 4533, 125, 3, 70, "ExampleDelimiter",
 CellID->745796639],
Cell[177933, 4538, 60, 1, 70, "ExampleText",
 CellID->27069804],
Cell[CellGroupData[{
Cell[178018, 4543, 326, 9, 70, "Input",
 CellID->2044486006],
Cell[178347, 4554, 1877, 41, 70, "Output",
 CellID->199578034]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[180273, 4601, 233, 7, 70, "ExampleSubsection",
 CellID->614347287],
Cell[180509, 4610, 62, 1, 70, "ExampleText",
 CellID->1091260091],
Cell[CellGroupData[{
Cell[180596, 4615, 478, 15, 70, "Input",
 CellID->1931303231],
Cell[181077, 4632, 7693, 163, 70, "Output",
 CellID->714955808]
}, Open  ]],
Cell[188785, 4798, 125, 3, 70, "ExampleDelimiter",
 CellID->177393569],
Cell[188913, 4803, 62, 1, 70, "ExampleText",
 CellID->1415299773],
Cell[CellGroupData[{
Cell[189000, 4808, 270, 8, 70, "Input",
 CellID->1414410639],
Cell[189273, 4818, 1947, 44, 70, "Output",
 CellID->2105011549]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[191269, 4868, 232, 7, 70, "ExampleSubsection",
 CellID->361543898],
Cell[191504, 4877, 85, 1, 70, "ExampleText",
 CellID->184274304],
Cell[CellGroupData[{
Cell[191614, 4882, 358, 11, 70, "Input",
 CellID->772271996],
Cell[191975, 4895, 3753, 81, 70, "Output",
 CellID->7972562]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[195777, 4982, 235, 7, 70, "ExampleSubsection",
 CellID->688785845],
Cell[196015, 4991, 98, 1, 70, "ExampleText",
 CellID->464772379],
Cell[CellGroupData[{
Cell[196138, 4996, 438, 13, 70, "Input",
 CellID->2105120423],
Cell[196579, 5011, 2276, 48, 70, "Output",
 CellID->17710956]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[198916, 5066, 222, 7, 70, "ExampleSection",
 CellID->5230],
Cell[199141, 5075, 68, 1, 70, "ExampleText",
 CellID->784468477],
Cell[CellGroupData[{
Cell[199234, 5080, 1135, 35, 70, "Input",
 CellID->1159584006],
Cell[200372, 5117, 2049, 46, 70, "Output",
 CellID->135129751]
}, Open  ]],
Cell[202436, 5166, 125, 3, 70, "ExampleDelimiter",
 CellID->451788016],
Cell[202564, 5171, 188, 7, 70, "ExampleText",
 CellID->597058562],
Cell[CellGroupData[{
Cell[202777, 5182, 482, 13, 70, "Input",
 CellID->1368847924],
Cell[203262, 5197, 1969, 43, 70, "Output",
 CellID->83381173]
}, Open  ]],
Cell[205246, 5243, 64, 1, 70, "ExampleText",
 CellID->1395912380],
Cell[CellGroupData[{
Cell[205335, 5248, 880, 25, 70, "Input",
 CellID->16095098],
Cell[206218, 5275, 2134, 49, 70, "Output",
 CellID->278409500]
}, Open  ]],
Cell[208367, 5327, 125, 3, 70, "ExampleDelimiter",
 CellID->573532180],
Cell[208495, 5332, 91, 1, 70, "ExampleText",
 CellID->189809102],
Cell[CellGroupData[{
Cell[208611, 5337, 635, 18, 70, "Input",
 CellID->17157],
Cell[209249, 5357, 1999, 44, 70, "Output",
 CellID->208938944]
}, Open  ]],
Cell[211263, 5404, 123, 3, 70, "ExampleDelimiter",
 CellID->7387147],
Cell[211389, 5409, 75, 1, 70, "ExampleText",
 CellID->557320662],
Cell[CellGroupData[{
Cell[211489, 5414, 448, 14, 70, "Input",
 CellID->41],
Cell[211940, 5430, 1971, 44, 70, "Output",
 CellID->1337890625]
}, Open  ]],
Cell[213926, 5477, 125, 3, 70, "ExampleDelimiter",
 CellID->782913667],
Cell[214054, 5482, 83, 1, 70, "ExampleText",
 CellID->1475590712],
Cell[CellGroupData[{
Cell[214162, 5487, 1566, 46, 70, "Input",
 CellID->1111941028],
Cell[215731, 5535, 3053, 64, 70, "Output",
 CellID->560945142]
}, Open  ]],
Cell[218799, 5602, 124, 3, 70, "ExampleDelimiter",
 CellID->17861407],
Cell[218926, 5607, 606, 21, 70, "ExampleText",
 CellID->869645839],
Cell[CellGroupData[{
Cell[219557, 5632, 1162, 35, 70, "Input",
 CellID->363914591],
Cell[220722, 5669, 2171, 48, 70, "Output",
 CellID->18513465]
}, Open  ]],
Cell[222908, 5720, 125, 3, 70, "ExampleDelimiter",
 CellID->543100099],
Cell[223036, 5725, 76, 1, 70, "ExampleText",
 CellID->1314874640],
Cell[223115, 5728, 567, 18, 70, "Input",
 CellID->1491346850],
Cell[223685, 5748, 711, 24, 70, "Input",
 CellID->1913582366],
Cell[CellGroupData[{
Cell[224421, 5776, 1054, 28, 70, "Input",
 CellID->558738150],
Cell[225478, 5806, 2988, 63, 70, "Output",
 CellID->719549545]
}, Open  ]],
Cell[228481, 5872, 124, 3, 70, "ExampleDelimiter",
 CellID->89632045],
Cell[228608, 5877, 494, 19, 70, "ExampleText",
 CellID->1579904422],
Cell[229105, 5898, 1318, 40, 70, "Input",
 CellID->157319175],
Cell[CellGroupData[{
Cell[230448, 5942, 1075, 31, 70, "Input",
 CellID->89191103],
Cell[231526, 5975, 3654, 78, 70, "Output",
 CellID->161267894]
}, Open  ]],
Cell[235195, 6056, 125, 3, 70, "ExampleDelimiter",
 CellID->191760438],
Cell[235323, 6061, 74, 1, 70, "ExampleText",
 CellID->282485861],
Cell[235400, 6064, 1605, 52, 70, "Input",
 CellID->686768770],
Cell[CellGroupData[{
Cell[237030, 6120, 1130, 29, 70, "Input",
 CellID->9649783],
Cell[238163, 6151, 2999, 64, 70, "Output",
 CellID->335329795]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[241211, 6221, 236, 7, 70, "ExampleSection",
 CellID->87647649],
Cell[241450, 6230, 246, 8, 70, "ExampleText",
 CellID->772513449],
Cell[CellGroupData[{
Cell[241721, 6242, 1167, 38, 70, "Input",
 CellID->1619804829],
Cell[242891, 6282, 150267, 2201, 70, "Output",
 CellID->1097557876]
}, Open  ]],
Cell[393173, 8486, 124, 3, 70, "ExampleDelimiter",
 CellID->77122752],
Cell[393300, 8491, 254, 8, 70, "ExampleText",
 CellID->543530855],
Cell[CellGroupData[{
Cell[393579, 8503, 786, 25, 70, "Input",
 CellID->924018453],
Cell[394368, 8530, 18932, 429, 70, "Output",
 CellID->1918177849]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[413349, 8965, 226, 7, 70, "ExampleSection",
 CellID->15567],
Cell[413578, 8974, 222, 8, 70, "ExampleText",
 CellID->358202118],
Cell[CellGroupData[{
Cell[413825, 8986, 366, 12, 70, "Input",
 CellID->59671182],
Cell[414194, 9000, 1913, 42, 70, "Output",
 CellID->202761377]
}, Open  ]],
Cell[CellGroupData[{
Cell[416144, 9047, 495, 16, 70, "Input",
 CellID->54263586],
Cell[416642, 9065, 1944, 43, 70, "Output",
 CellID->1901399097]
}, Open  ]],
Cell[418601, 9111, 125, 3, 70, "ExampleDelimiter",
 CellID->406721149],
Cell[418729, 9116, 259, 8, 70, "ExampleText",
 CellID->478887018],
Cell[CellGroupData[{
Cell[419013, 9128, 393, 13, 70, "Input",
 CellID->118462967],
Cell[419409, 9143, 1952, 43, 70, "Output",
 CellID->1693805613]
}, Open  ]],
Cell[CellGroupData[{
Cell[421398, 9191, 447, 14, 70, "Input",
 CellID->693782640],
Cell[421848, 9207, 1973, 43, 70, "Output",
 CellID->747713059]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[423870, 9256, 228, 7, 70, "ExampleSection",
 CellID->166210904],
Cell[CellGroupData[{
Cell[424123, 9267, 475, 16, 70, "Input",
 CellID->110472272],
Cell[424601, 9285, 1956, 45, 70, "Output",
 CellID->352371431]
}, Open  ]],
Cell[426572, 9333, 125, 3, 70, "ExampleDelimiter",
 CellID->153719460],
Cell[CellGroupData[{
Cell[426722, 9340, 1779, 57, 70, "Input",
 CellID->102342208],
Cell[428504, 9399, 2187, 49, 70, "Output",
 CellID->700400067]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[430752, 9455, 310, 9, 70, "SeeAlsoSection",
 CellID->1441],
Cell[431065, 9466, 1448, 53, 70, "SeeAlso",
 CellID->5936]
}, Open  ]],
Cell[CellGroupData[{
Cell[432550, 9524, 314, 9, 70, "TutorialsSection",
 CellID->24117],
Cell[432867, 9535, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[433029, 9540, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[433239, 9548, 317, 9, 70, "MoreAboutSection",
 CellID->9420325],
Cell[433559, 9559, 153, 3, 70, "MoreAbout",
 CellID->308484314],
Cell[433715, 9564, 159, 3, 70, "MoreAbout",
 CellID->136011677],
Cell[433877, 9569, 171, 3, 70, "MoreAbout",
 CellID->140899468],
Cell[434051, 9574, 153, 3, 70, "MoreAbout",
 CellID->25861062],
Cell[434207, 9579, 171, 3, 70, "MoreAbout",
 CellID->16991917],
Cell[434381, 9584, 179, 3, 70, "MoreAbout",
 CellID->201513202]
}, Open  ]],
Cell[434575, 9590, 27, 0, 70, "History"],
Cell[434605, 9592, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

