(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95510,       3196]
NotebookOptionsPosition[     81508,       2708]
NotebookOutlinePosition[     83155,       2750]
CellTagsIndexPosition[     83069,       2745]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Animate" :> Documentation`HelpLookup["paclet:ref/Animate"], 
          "ListAnimate" :> Documentation`HelpLookup["paclet:ref/ListAnimate"],
           "Trigger" :> Documentation`HelpLookup["paclet:ref/Trigger"], 
          "Slider" :> Documentation`HelpLookup["paclet:ref/Slider"], "Clock" :> 
          Documentation`HelpLookup["paclet:ref/Clock"], "Pause" :> 
          Documentation`HelpLookup["paclet:ref/Pause"], "Manipulator" :> 
          Documentation`HelpLookup["paclet:ref/Manipulator"], 
          "ProgressIndicator" :> 
          Documentation`HelpLookup["paclet:ref/ProgressIndicator"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Animate\"\>", 
       2->"\<\"ListAnimate\"\>", 3->"\<\"Trigger\"\>", 4->"\<\"Slider\"\>", 
       5->"\<\"Clock\"\>", 6->"\<\"Pause\"\>", 7->"\<\"Manipulator\"\>", 
       8->"\<\"ProgressIndicator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/InteractiveManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Interactive Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Animator", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Animator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Animator"], "[", 
       StyleBox["u", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an object which displays with the value of ",
     
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " being continually increased from ",
     Cell[BoxData["0"], "InlineFormula"],
     " to ",
     Cell[BoxData["1"], "InlineFormula"],
     " with time. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Animator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Animator"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " vary from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Animator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Animator"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["du", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " vary in steps ",
     Cell[BoxData[
      StyleBox["du", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Animator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Animator"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["ups", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes the value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " increase at a rate of ",
     Cell[BoxData[
      StyleBox["ups", "TI"]], "InlineFormula"],
     " units per second. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27692]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The default duration is 5 seconds. ", "Notes",
 CellID->25293],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["s", "TI"], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " makes the value of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " be continually reset with time. "
}], "Notes",
 CellID->5117],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]], ",", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " will run forever, with ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " increasing by 1 every second. "
}], "Notes",
 CellID->7717],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       ButtonBox["Infinity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Infinity"]}], ",", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " also allows ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " to decrease forever if the animation is run in reverse."
}], "Notes",
 CellID->20403],

Cell["The following options can be given: ", "Notes",
 CellID->3943],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationDirection",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationDirection"], 
    ButtonBox["Forward",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Forward"], Cell[
    "the direction of the animation ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRunning",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRunning"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the animation is running", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRate"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the rate at which to take variables to vary", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRepetitions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRepetitions"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "how many times to run before stopping", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the animator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AppearanceElements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AppearanceElements"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "elements to include in the displayed animator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "specific ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " values to exclude"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DefaultDuration",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DefaultDuration"], "5.", Cell[
    "the default duration in seconds ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayAllSteps",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayAllSteps"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to force all discrete steps to be displayed ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the animator is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed animator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed animator ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, {None}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->17893],

Cell[TextData[{
 "The following elements are included in a default animator: ",
 Cell[BoxData["\"\<ProgressSlider\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<PlayPauseButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<FasterSlowerButtons\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DirectionButton\>\""], "InlineFormula"],
 ". These elements can be specified in any order in a list given as the \
setting for ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10639],

Cell[TextData[{
 "Additional possible elements include: ",
 Cell[BoxData["\"\<PlayButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ResetPlayButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<PauseButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ResetButton\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->371172049],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"], "[", "0", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29011]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67916813],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->12624592],

Cell[TextData[{
 "An animator set at ",
 Cell[BoxData[
  FormBox["0.8`", TraditionalForm]], "InlineMath"],
 " in the default range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->258827707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", "0.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348675845],

Cell[BoxData[
 AnimatorBox[0.4126265525817871]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41343240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29117962],

Cell["A animator with its value updated dynamically:", "ExampleText",
 CellID->186407634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156176220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{63., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{419, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50571261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53042664],

Cell[TextData[{
 "A animator with integer values in the range ",
 Cell[BoxData["0"], "InlineFormula"],
 " to 100:"
}], "ExampleText",
 CellID->10336265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "n", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129400021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[Dynamic[Cell$$12382`n], {0, 100, 1}], ",", 
   DynamicBox[ToBoxes[Cell$$12382`n, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{363, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->506217012]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12036],

Cell[CellGroupData[{

Cell[TextData[{
 "Animator Content",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSubsection",
 CellID->848778408],

Cell["Include different appearance elements: ", "ExampleText",
 CellID->725025028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"AppearanceElements", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ProgressSlider\>\"", ",", "\"\<StepLeftButton\>\"", ",", 
       "\"\<StepRightButton\>\"", ",", "\"\<PlayPauseButton\>\"", ",", 
       "\"\<FasterSlowerButtons\>\"", ",", "\"\<DirectionButton\>\"", ",", 
       "\"\<ResetButton\>\"", ",", "\"\<PlayButton\>\"", ",", 
       "\"\<ResetPlayButton\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1832319882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.2147589683532715,
    AppearanceElements->"ProgressSlider"], ",", 
   AnimatorBox[0.2147589683532715,
    AppearanceElements->"StepLeftButton"], ",", 
   AnimatorBox[0.2147589683532715,
    AppearanceElements->"StepRightButton"], ",", 
   AnimatorBox[0.9053563117980957,
    AppearanceElements->"PlayPauseButton",
    PausedTime->Automatic], ",", 
   AnimatorBox[0.031955083847044825`,
    AnimationRate->0.25000000000000006`,
    AppearanceElements->"FasterSlowerButtons"], ",", 
   AnimatorBox[0.2147589683532715,
    AppearanceElements->"DirectionButton"], ",", 
   AnimatorBox[0.2147589683532715,
    AppearanceElements->"ResetButton"], ",", 
   AnimatorBox[0.2147589683532715,
    AppearanceElements->"PlayButton"], ",", 
   AnimatorBox[0.3752127647399902,
    AppearanceElements->"ResetPlayButton",
    PausedTime->Automatic]}], "}"}]], "Output",
 ImageSize->{510, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1432146553]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Animator Control",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSubsection",
 CellID->453261931],

Cell["Specify an initial value:", "ExampleText",
 CellID->508492494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1035450289],

Cell[BoxData[
 AnimatorBox[0.6938121795654297]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1090400695]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179028742],

Cell["Specify a range:", "ExampleText",
 CellID->1604733481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->964278930],

Cell[BoxData[
 AnimatorBox[3.4690608978271484`, {0, 5}]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1886521014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277010606],

Cell["Specify a range with discrete jump:", "ExampleText",
 CellID->2036162887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1299783871],

Cell[BoxData[
 AnimatorBox[4, {0, 5, 1}]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1003225239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->494829541],

Cell["Specify a range with refresh rate:", "ExampleText",
 CellID->1637726864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->978184214],

Cell[BoxData[
 AnimatorBox[2.267172336578369, {0, 5},
  AnimationRate->5]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1312479276]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->434342822],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationDirection",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->411961585],

Cell["Control the  direction of the slider:", "ExampleText",
 CellID->1108710775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"AnimationDirection", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Forward", ",", "Backward", ",", "ForwardBackward"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55466627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.4508467674255371,
    AnimationDirection->Forward], ",", 
   AnimatorBox[0.5491532325744629,
    AnimationDirection->Backward], ",", 
   AnimatorBox[0.5491532325744628,
    AnimationDirection->ForwardBackward]}], "}"}]], "Output",
 ImageSize->{344, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2037498584]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRate",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->350429089],

Cell["Control the rate of the slider:", "ExampleText",
 CellID->1999728756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"AnimationRate", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "0.5", ",", "1", ",", "1.5"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1472862678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.9079440116882325,
    AnimationRate->Automatic], ",", 
   AnimatorBox[0.26986002922058105`,
    AnimationRate->0.5], ",", 
   AnimatorBox[0.5397200584411621,
    AnimationRate->1], ",", 
   AnimatorBox[0.8095800876617432,
    AnimationRate->1.5]}], "}"}]], "Output",
 ImageSize->{344, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->464466226]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRepetitions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->735447112],

Cell["Control the number of slider repetitions:", "ExampleText",
 CellID->1949472372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"AnimationRepetitions", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2104647758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[1.,
    AnimationRepetitions->1,
    PausedTime->0.], ",", 
   AnimatorBox[1.,
    AnimationRepetitions->2,
    PausedTime->0.], ",", 
   AnimatorBox[1.,
    AnimationRepetitions->3,
    PausedTime->0.]}], "}"}]], "Output",
 ImageSize->{344, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->652089045]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRunning",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->685790894],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 " starts with a moving slider:"
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1205777555],

Cell[BoxData[
 AnimatorBox[0.4595954895019531]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75685854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216688405],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AnimationRunning",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AnimationRunning"]], "InlineFormula"],
 ", the slider remains stationary:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1286170056],

Cell[BoxData[
 AnimatorBox[0,
  PausedTime->0]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->741829154]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->290510161],

Cell["Different sizes:", "ExampleText",
 CellID->48195337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751528992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.7189935684204102,
    Appearance->Tiny], ",", 
   AnimatorBox[0.7189935684204102,
    Appearance->Small], ",", 
   AnimatorBox[0.7189935684204102,
    Appearance->Medium], ",", 
   AnimatorBox[0.7189935684204102,
    Appearance->Large]}], "}"}]], "Output",
 ImageSize->{344, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1780020443]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AppearanceElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->507720369],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 " consists of a slider and a set of buttons:"
}], "ExampleText",
 CellID->701940153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1380478500],

Cell[BoxData[
 AnimatorBox[0.6545275688171387]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1979634010]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->303943965],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 ", specify which controls are displayed:"
}], "ExampleText",
 CellID->1666052553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"AppearanceElements", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ProgressSlider\>\"", ",", "\"\<StepLeftButton\>\"", ",", 
       "\"\<StepRightButton\>\"", ",", "\"\<PlayPauseButton\>\"", ",", 
       "\"\<FasterSlowerButtons\>\"", ",", "\"\<DirectionButton\>\"", ",", 
       "\"\<ResetButton\>\"", ",", "\"\<PlayButton\>\"", ",", 
       "\"\<ResetPlayButton\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1135002766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"ProgressSlider"], ",", 
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"StepLeftButton"], ",", 
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"StepRightButton"], ",", 
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"PlayPauseButton"], ",", 
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"FasterSlowerButtons"], ",", 
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"DirectionButton"], ",", 
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"ResetButton"], ",", 
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"PlayButton"], ",", 
   AnimatorBox[0.6545275688171387,
    AppearanceElements->"ResetPlayButton"]}], "}"}]], "Output",
 ImageSize->{510, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->744663099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56924131],

Cell["See all the controls together:", "ExampleText",
 CellID->222098497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"AppearanceElements", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1199183565],

Cell[BoxData[
 AnimatorBox[0.8823146820068359,
  AppearanceElements->All]], "Output",
 ImageSize->{416, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18010177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->785111787],

Cell[TextData[{
 "Construct a customized ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->826174799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"AppearanceElements", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<StepLeftButton\>\"", ",", "\"\<StepRightButton\>\"", ",", 
      "\"\<ProgressSlider\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2038068938],

Cell[BoxData[
 AnimatorBox[0.6482769966125488,
  AppearanceElements->{
   "StepLeftButton", "StepRightButton", "ProgressSlider"}]], "Output",
 ImageSize->{248, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2049334259]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3385024],

Cell["Change the background colors:", "ExampleText",
 CellID->187974734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155850066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.019289302825927734`,
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   AnimatorBox[0.019289302825927734`,
    Background->RGBColor[0, 1, 0]], ",", 
   AnimatorBox[0.019289302825927734`,
    Background->GrayLevel[0.5]], ",", 
   AnimatorBox[0.019289302825927734`,
    Background->RGBColor[1, 1, 0]]}], "}"}]], "Output",
 ImageSize->{344, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1818160427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->443680215],

Cell["Change the background color dynamically:", "ExampleText",
 CellID->375560463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Hue", "[", "x", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179308],

Cell[BoxData[
 AnimatorBox[Dynamic[$CellContext`x],
  Background->Dynamic[
    Hue[$CellContext`x]]]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1277483426]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->114830278],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->33784897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Animator", "[", 
      RowBox[{"0", ",", 
       RowBox[{"AppearanceElements", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<PlayPauseButton\>\"", ",", "\"\<StepRightButton\>\""}], 
         "}"}]}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340562913],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   AnimatorBox[0.4000358581542969,
    AppearanceElements->{"PlayPauseButton", "StepRightButton"},
    BaselinePosition->Top], "xxx", 
   AnimatorBox[0.4000358581542969,
    AppearanceElements->{"PlayPauseButton", "StepRightButton"},
    BaselinePosition->Center], "xxx", 
   AnimatorBox[0.4000358581542969,
    AppearanceElements->{"PlayPauseButton", "StepRightButton"},
    BaselinePosition->Bottom]}],
  Row[{
    Animator[
    0, AppearanceElements -> {"PlayPauseButton", "StepRightButton"}, 
     BaselinePosition -> Top], 
    Animator[
    0, AppearanceElements -> {"PlayPauseButton", "StepRightButton"}, 
     BaselinePosition -> Center], 
    Animator[
    0, AppearanceElements -> {"PlayPauseButton", "StepRightButton"}, 
     BaselinePosition -> Bottom]}, "xxx"]]], "Output",
 ImageSize->{178, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->140349344]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DefaultDuration",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->244835540],

Cell["Control the time duration of the slider:", "ExampleText",
 CellID->1049336160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"DefaultDuration", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1057131956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.298245906829834,
    DefaultDuration->1], ",", 
   AnimatorBox[0.649122953414917,
    DefaultDuration->2], ",", 
   AnimatorBox[0.09941530227661133,
    DefaultDuration->3]}], "}"}]], "Output",
 ImageSize->{344, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147981284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->251653051],

Cell["The duration is equivalent to 1/rate: ", "ExampleText",
 CellID->127393980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"AnimationRate", "\[Rule]", 
      RowBox[{"1", "/", "a"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->481286671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.12635517120361328`,
    AnimationRate->1], ",", 
   AnimatorBox[0.5631775856018066,
    AnimationRate->Rational[1, 2]], ",", 
   AnimatorBox[0.04211839040120443,
    AnimationRate->Rational[1, 3]]}], "}"}]], "Output",
 ImageSize->{344, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325155535]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DisplayAllSteps",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->872326991],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DisplayAllSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayAllSteps"]], "InlineFormula"],
 " to force every intermediate step to be performed:"
}], "ExampleText",
 CellID->329211532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5000", ",", "5"}], "}"}], ",", 
     RowBox[{"DisplayAllSteps", "\[Rule]", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5137226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[585, {0, 5000, 5},
    DisplayAllSteps->True], ",", 
   AnimatorBox[3745, {0, 5000, 5},
    DisplayAllSteps->False]}], "}"}]], "Output",
 ImageSize->{344, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1066304845]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1011363901],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->1600039704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 AnimatorBox[0.2250202178955078]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->634495700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41257146],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the animator is disabled but visible in its current state:"
}], "ExampleText",
 CellID->1677501360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 AnimatorBox[0.9438344955444335,
  Enabled->False]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1712922545]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->149799147],

Cell["Exclude values from the range:", "ExampleText",
 CellID->175289357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0.2"}], "}"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.4", ",", "0.8"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394705405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[Dynamic[$CellContext`x], {0, 1, 0.2},
    Exclusions->{0.4, 0.8}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{370, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2070925780]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->342235385],

Cell["Use predefined sizes: ", "ExampleText",
 CellID->92076458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Animator", "[", 
     RowBox[{"0", ",", 
      RowBox[{"ImageSize", "\[Rule]", "s"}], ",", 
      RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->807926503],

Cell[BoxData[
 TagBox[GridBox[{
    {
     AnimatorBox[0.5875526428222656,
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->Tiny]},
    {
     AnimatorBox[0.5875526428222656,
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->Small]},
    {
     AnimatorBox[0.5875526428222656,
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->Medium]},
    {
     AnimatorBox[0.5875526428222656,
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->Large]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{530, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1094918808]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RefreshRate",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->625909917],

Cell["Control the refresh rate of the slider:", "ExampleText",
 CellID->184274304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animator", "[", 
    RowBox[{"0", ",", 
     RowBox[{"RefreshRate", "\[Rule]", "r"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->772271996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[0.2062685012817383,
    RefreshRate->1], ",", 
   AnimatorBox[0.2062685012817383,
    RefreshRate->2], ",", 
   AnimatorBox[0.21251907348632812`,
    RefreshRate->3], ",", 
   AnimatorBox[0.21251907348632812`,
    RefreshRate->4]}], "}"}]], "Output",
 ImageSize->{344, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->513034913]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27722146],

Cell["Animate a plotting process: ", "ExampleText",
 CellID->409431585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "n", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Animator", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "n", "]"}], ",", 
       RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"n", " ", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1677257559],

Cell[BoxData[
 DynamicModuleBox[{Cell$$12269`n$$ = 0.}, 
  RowBox[{"{", 
   RowBox[{
    AnimatorBox[Dynamic[Cell$$12269`n$$],
     PausedTime->0], ",", 
    DynamicBox[ToBoxes[
      Plot[
       Sin[Cell$$12269`n$$ Cell$$12269`x], {Cell$$12269`x, 0, 6}, PlotRange -> 
       1], StandardForm],
     ImageSizeCache->{180., {53., 58.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{536, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61767387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Animator", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "t", "]"}], ",", 
       RowBox[{"AnimationDirection", "\[Rule]", "ForwardBackward"}], ",", 
       RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], ",", 
          RowBox[{"Sin", "[", "x", "]"}], ",", 
          RowBox[{
           RowBox[{"t", " ", 
            RowBox[{"Cos", "[", "x", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "t"}], ")"}], 
            RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1513874022],

Cell[BoxData[
 DynamicModuleBox[{Cell$$12251`t$$ = 0.}, 
  RowBox[{"{", 
   RowBox[{
    AnimatorBox[Dynamic[Cell$$12251`t$$],
     AnimationDirection->ForwardBackward,
     PausedTime->0], ",", 
    DynamicBox[ToBoxes[
      Plot[{
        Cos[Cell$$12251`x], 
        Sin[Cell$$12251`x], 
        Cell$$12251`t$$ Cos[Cell$$12251`x] + (1 - Cell$$12251`t$$) 
         Sin[Cell$$12251`x]}, {Cell$$12251`x, 0, 6}, PlotRange -> 1], 
      StandardForm],
     ImageSizeCache->{180., {53., 58.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{536, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->117817295]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360008507],

Cell["Animate any process: ", "ExampleText",
 CellID->313488700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "n", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Animator", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "20", ",", "2"}], "}"}], ",", 
       RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Expand", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "+", "y"}], ")"}], "^", "n"}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285084262],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 7}, 
  RowBox[{"{", 
   RowBox[{
    AnimatorBox[Dynamic[$CellContext`n$$], {1, 20, 2},
     PausedTime->1.5789473684210527`], ",", 
    DynamicBox[ToBoxes[
      Expand[($CellContext`x + $CellContext`y)^$CellContext`n$$], 
      StandardForm],
     ImageSizeCache->{358.375, {2., 11.375}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{377, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91844285]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "n", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Animator", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "10000", ",", "1"}], "}"}], ",", 
       RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Prime", "[", "n", "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132779615],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 5680}, 
  RowBox[{"{", 
   RowBox[{
    AnimatorBox[Dynamic[$CellContext`n$$], {1000, 10000, 1},
     PausedTime->2.6], ",", 
    DynamicBox[ToBoxes[
      Prime[$CellContext`n$$], StandardForm],
     ImageSizeCache->{37.125, {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{393, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136366687]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->617359884],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " use ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 " controls: "
}], "ExampleText",
 CellID->308691124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Animator", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1602447664],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.6183032035827637}, 
  RowBox[{"{", 
   RowBox[{
    AnimatorBox[Dynamic[$CellContext`x$$]], ",", 
    GraphicsBox[
     LineBox[Dynamic[{{0, 0}, {$CellContext`x$$, $CellContext`x$$}}]],
     Axes->True,
     PlotRange->{{0, 1}, {0, 1}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{536, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->790599379]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "x"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->100639615],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.6183032035827637, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {180., {87., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$12469$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$12469$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Line[{{0, 0}, {$CellContext`x$$, $CellContext`x$$}}], Axes -> True, 
        PlotRange -> {{0, 1}, {0, 1}}], 
      "Specifications" :> {{$CellContext`x$$, 0, 1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {124., 129.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1122438864]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1", ",", "0.01"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1060906608],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 77, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 101, 1}}, Typeset`size$$ = 
    Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`i$12489$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 101, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[LineBox[{{0, 0}, {0., 0.}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 2->
                GraphicsBox[LineBox[{{0, 0}, {0.01, 0.01}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 3->
                GraphicsBox[LineBox[{{0, 0}, {0.02, 0.02}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 4->
                GraphicsBox[LineBox[{{0, 0}, {0.03, 0.03}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 5->
                GraphicsBox[LineBox[{{0, 0}, {0.04, 0.04}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 6->
                GraphicsBox[LineBox[{{0, 0}, {0.05, 0.05}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 7->
                GraphicsBox[LineBox[{{0, 0}, {0.06, 0.06}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 8->
                GraphicsBox[LineBox[{{0, 0}, {0.07, 0.07}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 9->
                GraphicsBox[LineBox[{{0, 0}, {0.08, 0.08}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 10->
                GraphicsBox[LineBox[{{0, 0}, {0.09, 0.09}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 11->
                GraphicsBox[LineBox[{{0, 0}, {0.1, 0.1}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 12->
                GraphicsBox[LineBox[{{0, 0}, {0.11, 0.11}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 13->
                GraphicsBox[LineBox[{{0, 0}, {0.12, 0.12}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 14->
                GraphicsBox[LineBox[{{0, 0}, {0.13, 0.13}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 15->
                GraphicsBox[LineBox[{{0, 0}, {0.14, 0.14}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 16->
                GraphicsBox[LineBox[{{0, 0}, {0.15, 0.15}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 17->
                GraphicsBox[LineBox[{{0, 0}, {0.16, 0.16}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 18->
                GraphicsBox[LineBox[{{0, 0}, {0.17, 0.17}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 19->
                GraphicsBox[LineBox[{{0, 0}, {0.18, 0.18}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 20->
                GraphicsBox[LineBox[{{0, 0}, {0.19, 0.19}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 21->
                GraphicsBox[LineBox[{{0, 0}, {0.2, 0.2}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 22->
                GraphicsBox[LineBox[{{0, 0}, {0.21, 0.21}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 23->
                GraphicsBox[LineBox[{{0, 0}, {0.22, 0.22}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 24->
                GraphicsBox[LineBox[{{0, 0}, {0.23, 0.23}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 25->
                GraphicsBox[LineBox[{{0, 0}, {0.24, 0.24}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 26->
                GraphicsBox[LineBox[{{0, 0}, {0.25, 0.25}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 27->
                GraphicsBox[LineBox[{{0, 0}, {0.26, 0.26}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 28->
                GraphicsBox[LineBox[{{0, 0}, {0.27, 0.27}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 29->
                GraphicsBox[LineBox[{{0, 0}, {0.28, 0.28}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 30->
                GraphicsBox[LineBox[{{0, 0}, {0.29, 0.29}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 31->
                GraphicsBox[LineBox[{{0, 0}, {0.3, 0.3}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 32->
                GraphicsBox[LineBox[{{0, 0}, {0.31, 0.31}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 33->
                GraphicsBox[LineBox[{{0, 0}, {0.32, 0.32}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 34->
                GraphicsBox[LineBox[{{0, 0}, {0.33, 0.33}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 35->
                GraphicsBox[LineBox[{{0, 0}, {0.34, 0.34}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 36->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.35000000000000003`, 
                   0.35000000000000003`}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 37->
                GraphicsBox[LineBox[{{0, 0}, {0.36, 0.36}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 38->
                GraphicsBox[LineBox[{{0, 0}, {0.37, 0.37}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 39->
                GraphicsBox[LineBox[{{0, 0}, {0.38, 0.38}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 40->
                GraphicsBox[LineBox[{{0, 0}, {0.39, 0.39}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 41->
                GraphicsBox[LineBox[{{0, 0}, {0.4, 0.4}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 42->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.41000000000000003`, 
                   0.41000000000000003`}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 43->
                GraphicsBox[LineBox[{{0, 0}, {0.42, 0.42}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 44->
                GraphicsBox[LineBox[{{0, 0}, {0.43, 0.43}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 45->
                GraphicsBox[LineBox[{{0, 0}, {0.44, 0.44}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 46->
                GraphicsBox[LineBox[{{0, 0}, {0.45, 0.45}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 47->
                GraphicsBox[LineBox[{{0, 0}, {0.46, 0.46}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 48->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.47000000000000003`, 
                   0.47000000000000003`}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 49->
                GraphicsBox[LineBox[{{0, 0}, {0.48, 0.48}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 50->
                GraphicsBox[LineBox[{{0, 0}, {0.49, 0.49}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 51->
                GraphicsBox[LineBox[{{0, 0}, {0.5, 0.5}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 52->
                GraphicsBox[LineBox[{{0, 0}, {0.51, 0.51}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 53->
                GraphicsBox[LineBox[{{0, 0}, {0.52, 0.52}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 54->
                GraphicsBox[LineBox[{{0, 0}, {0.53, 0.53}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 55->
                GraphicsBox[LineBox[{{0, 0}, {0.54, 0.54}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 56->
                GraphicsBox[LineBox[{{0, 0}, {0.55, 0.55}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 57->
                GraphicsBox[LineBox[{{0, 0}, {0.56, 0.56}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 58->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.5700000000000001, 0.5700000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 59->
                GraphicsBox[LineBox[{{0, 0}, {0.58, 0.58}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 60->
                GraphicsBox[LineBox[{{0, 0}, {0.59, 0.59}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 61->
                GraphicsBox[LineBox[{{0, 0}, {0.6, 0.6}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 62->
                GraphicsBox[LineBox[{{0, 0}, {0.61, 0.61}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 63->
                GraphicsBox[LineBox[{{0, 0}, {0.62, 0.62}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 64->
                GraphicsBox[LineBox[{{0, 0}, {0.63, 0.63}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 65->
                GraphicsBox[LineBox[{{0, 0}, {0.64, 0.64}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 66->
                GraphicsBox[LineBox[{{0, 0}, {0.65, 0.65}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 67->
                GraphicsBox[LineBox[{{0, 0}, {0.66, 0.66}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 68->
                GraphicsBox[LineBox[{{0, 0}, {0.67, 0.67}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 69->
                GraphicsBox[LineBox[{{0, 0}, {0.68, 0.68}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 70->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.6900000000000001, 0.6900000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 71->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.7000000000000001, 0.7000000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 72->
                GraphicsBox[LineBox[{{0, 0}, {0.71, 0.71}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 73->
                GraphicsBox[LineBox[{{0, 0}, {0.72, 0.72}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 74->
                GraphicsBox[LineBox[{{0, 0}, {0.73, 0.73}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 75->
                GraphicsBox[LineBox[{{0, 0}, {0.74, 0.74}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 76->
                GraphicsBox[LineBox[{{0, 0}, {0.75, 0.75}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 77->
                GraphicsBox[LineBox[{{0, 0}, {0.76, 0.76}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 78->
                GraphicsBox[LineBox[{{0, 0}, {0.77, 0.77}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 79->
                GraphicsBox[LineBox[{{0, 0}, {0.78, 0.78}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 80->
                GraphicsBox[LineBox[{{0, 0}, {0.79, 0.79}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 81->
                GraphicsBox[LineBox[{{0, 0}, {0.8, 0.8}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 82->
                GraphicsBox[LineBox[{{0, 0}, {0.81, 0.81}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 83->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.8200000000000001, 0.8200000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 84->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.8300000000000001, 0.8300000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 85->
                GraphicsBox[LineBox[{{0, 0}, {0.84, 0.84}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 86->
                GraphicsBox[LineBox[{{0, 0}, {0.85, 0.85}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 87->
                GraphicsBox[LineBox[{{0, 0}, {0.86, 0.86}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 88->
                GraphicsBox[LineBox[{{0, 0}, {0.87, 0.87}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 89->
                GraphicsBox[LineBox[{{0, 0}, {0.88, 0.88}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 90->
                GraphicsBox[LineBox[{{0, 0}, {0.89, 0.89}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 91->
                GraphicsBox[LineBox[{{0, 0}, {0.9, 0.9}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 92->
                GraphicsBox[LineBox[{{0, 0}, {0.91, 0.91}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 93->
                GraphicsBox[LineBox[{{0, 0}, {0.92, 0.92}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 94->
                GraphicsBox[LineBox[{{0, 0}, {0.93, 0.93}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 95->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.9400000000000001, 0.9400000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 96->
                
                GraphicsBox[
                 LineBox[{{0, 0}, {0.9500000000000001, 0.9500000000000001}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 97->
                GraphicsBox[LineBox[{{0, 0}, {0.96, 0.96}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 98->
                GraphicsBox[LineBox[{{0, 0}, {0.97, 0.97}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 99->
                GraphicsBox[LineBox[{{0, 0}, {0.98, 0.98}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 100->
                GraphicsBox[LineBox[{{0, 0}, {0.99, 0.99}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}], 101->
                GraphicsBox[LineBox[{{0, 0}, {1., 1.}}],
                 Axes->True,
                 PlotRange->{{0, 1}, {0, 1}}]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$12489$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 101, 1}, 101, 
            1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {115.5, 120.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{2, 2}, {5, 0}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{321, 251},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1333632000]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2850],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListAnimate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListAnimate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trigger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trigger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pause",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pause"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProgressIndicator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProgressIndicator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26925],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->260174562],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->125036510],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->313793545]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Animator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 19.3147544}", "context" -> "System`", 
    "keywords" -> {
     "frames", "movie", "animator controls", "animation controls", 
      "dynamic animation", "controlling animation", "dynamic controls", 
      "frame rate", "animation rate"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Animator[u] represents an object which displays with the value of u \
being continually increased from 0 to 1 with time. Animator[u, {u_min, \
u_max}] makes u vary from u_min to u_max. Animator[u, {u_min, u_max, du}] \
makes u vary in steps du. Animator[u, {u_min, u_max}, ups] makes the value of \
u increase at a rate of ups units per second. ", "synonyms" -> {}, "title" -> 
    "Animator", "type" -> "Symbol", "uri" -> "ref/Animator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15870, 489, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->67916813]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 82926, 2738}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2795, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3418, 88, 1573, 37, 70, "ObjectNameGrid"],
Cell[4994, 127, 3103, 104, 70, "Usage",
 CellID->27692]
}, Open  ]],
Cell[CellGroupData[{
Cell[8134, 236, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8612, 253, 68, 1, 70, "Notes",
 CellID->25293],
Cell[8683, 256, 507, 18, 70, "Notes",
 CellID->5117],
Cell[9193, 276, 582, 22, 70, "Notes",
 CellID->7717],
Cell[9778, 300, 639, 23, 70, "Notes",
 CellID->20403],
Cell[10420, 325, 68, 1, 70, "Notes",
 CellID->3943],
Cell[10491, 328, 3992, 107, 70, "3ColumnTableMod",
 CellID->17893],
Cell[14486, 437, 606, 17, 70, "Notes",
 CellID->10639],
Cell[15095, 456, 344, 11, 70, "Notes",
 CellID->371172049],
Cell[15442, 469, 391, 15, 70, "Notes",
 CellID->29011]
}, Closed]],
Cell[CellGroupData[{
Cell[15870, 489, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67916813],
Cell[CellGroupData[{
Cell[16254, 503, 147, 5, 70, "ExampleSection",
 CellID->12624592],
Cell[16404, 510, 314, 12, 70, "ExampleText",
 CellID->258827707],
Cell[CellGroupData[{
Cell[16743, 526, 106, 3, 28, "Input",
 CellID->348675845],
Cell[16852, 531, 188, 6, 46, "Output",
 CellID->41343240]
}, Open  ]],
Cell[17055, 540, 124, 3, 70, "ExampleDelimiter",
 CellID->29117962],
Cell[17182, 545, 89, 1, 70, "ExampleText",
 CellID->186407634],
Cell[CellGroupData[{
Cell[17296, 550, 222, 7, 70, "Input",
 CellID->156176220],
Cell[17521, 559, 327, 10, 70, "Output",
 CellID->50571261]
}, Open  ]],
Cell[17863, 572, 124, 3, 70, "ExampleDelimiter",
 CellID->53042664],
Cell[17990, 577, 152, 5, 70, "ExampleText",
 CellID->10336265],
Cell[CellGroupData[{
Cell[18167, 586, 313, 10, 70, "Input",
 CellID->129400021],
Cell[18483, 598, 338, 10, 70, "Output",
 CellID->506217012]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18870, 614, 216, 7, 70, "ExampleSection",
 CellID->12036],
Cell[CellGroupData[{
Cell[19111, 625, 153, 5, 70, "ExampleSubsection",
 CellID->848778408],
Cell[19267, 632, 82, 1, 70, "ExampleText",
 CellID->725025028],
Cell[CellGroupData[{
Cell[19374, 637, 637, 16, 70, "Input",
 CellID->1832319882],
Cell[20014, 655, 1041, 28, 70, "Output",
 CellID->1432146553]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21104, 689, 153, 5, 70, "ExampleSubsection",
 CellID->453261931],
Cell[21260, 696, 68, 1, 70, "ExampleText",
 CellID->508492494],
Cell[CellGroupData[{
Cell[21353, 701, 107, 3, 70, "Input",
 CellID->1035450289],
Cell[21463, 706, 190, 6, 70, "Output",
 CellID->1090400695]
}, Open  ]],
Cell[21668, 715, 125, 3, 70, "ExampleDelimiter",
 CellID->179028742],
Cell[21796, 720, 60, 1, 70, "ExampleText",
 CellID->1604733481],
Cell[CellGroupData[{
Cell[21881, 725, 176, 6, 70, "Input",
 CellID->964278930],
Cell[22060, 733, 199, 6, 70, "Output",
 CellID->1886521014]
}, Open  ]],
Cell[22274, 742, 125, 3, 70, "ExampleDelimiter",
 CellID->277010606],
Cell[22402, 747, 79, 1, 70, "ExampleText",
 CellID->2036162887],
Cell[CellGroupData[{
Cell[22506, 752, 187, 6, 70, "Input",
 CellID->1299783871],
Cell[22696, 760, 184, 6, 70, "Output",
 CellID->1003225239]
}, Open  ]],
Cell[22895, 769, 125, 3, 70, "ExampleDelimiter",
 CellID->494829541],
Cell[23023, 774, 78, 1, 70, "ExampleText",
 CellID->1637726864],
Cell[CellGroupData[{
Cell[23126, 779, 186, 6, 70, "Input",
 CellID->978184214],
Cell[23315, 787, 217, 7, 70, "Output",
 CellID->1312479276]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[23593, 801, 222, 7, 70, "ExampleSection",
 CellID->434342822],
Cell[CellGroupData[{
Cell[23840, 812, 239, 7, 70, "ExampleSubsection",
 CellID->411961585],
Cell[24082, 821, 81, 1, 70, "ExampleText",
 CellID->1108710775],
Cell[CellGroupData[{
Cell[24188, 826, 377, 12, 70, "Input",
 CellID->55466627],
Cell[24568, 840, 471, 14, 70, "Output",
 CellID->2037498584]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25088, 860, 234, 7, 70, "ExampleSubsection",
 CellID->350429089],
Cell[25325, 869, 75, 1, 70, "ExampleText",
 CellID->1999728756],
Cell[CellGroupData[{
Cell[25425, 874, 369, 12, 70, "Input",
 CellID->1472862678],
Cell[25797, 888, 455, 15, 70, "Output",
 CellID->464466226]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26301, 909, 241, 7, 70, "ExampleSubsection",
 CellID->735447112],
Cell[26545, 918, 85, 1, 70, "ExampleText",
 CellID->1949472372],
Cell[CellGroupData[{
Cell[26655, 923, 296, 9, 70, "Input",
 CellID->2104647758],
Cell[26954, 934, 409, 16, 70, "Output",
 CellID->652089045]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27412, 956, 237, 7, 70, "ExampleSubsection",
 CellID->685790894],
Cell[27652, 965, 222, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[27899, 977, 105, 3, 70, "Input",
 CellID->1205777555],
Cell[28007, 982, 188, 6, 70, "Output",
 CellID->75685854]
}, Open  ]],
Cell[28210, 991, 125, 3, 70, "ExampleDelimiter",
 CellID->216688405],
Cell[28338, 996, 241, 8, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[28604, 1008, 177, 5, 70, "Input",
 CellID->1286170056],
Cell[28784, 1015, 189, 7, 70, "Output",
 CellID->741829154]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29022, 1028, 231, 7, 70, "ExampleSubsection",
 CellID->290510161],
Cell[29256, 1037, 58, 1, 70, "ExampleText",
 CellID->48195337],
Cell[CellGroupData[{
Cell[29339, 1042, 369, 12, 70, "Input",
 CellID->751528992],
Cell[29711, 1056, 445, 15, 70, "Output",
 CellID->1780020443]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30205, 1077, 239, 7, 70, "ExampleSubsection",
 CellID->507720369],
Cell[30447, 1086, 236, 8, 70, "ExampleText",
 CellID->701940153],
Cell[CellGroupData[{
Cell[30708, 1098, 105, 3, 70, "Input",
 CellID->1380478500],
Cell[30816, 1103, 190, 6, 70, "Output",
 CellID->1979634010]
}, Open  ]],
Cell[31021, 1112, 125, 3, 70, "ExampleDelimiter",
 CellID->303943965],
Cell[31149, 1117, 253, 8, 70, "ExampleText",
 CellID->1666052553],
Cell[CellGroupData[{
Cell[31427, 1129, 637, 16, 70, "Input",
 CellID->1135002766],
Cell[32067, 1147, 942, 25, 70, "Output",
 CellID->744663099]
}, Open  ]],
Cell[33024, 1175, 124, 3, 70, "ExampleDelimiter",
 CellID->56924131],
Cell[33151, 1180, 73, 1, 70, "ExampleText",
 CellID->222098497],
Cell[CellGroupData[{
Cell[33249, 1185, 177, 5, 70, "Input",
 CellID->1199183565],
Cell[33429, 1192, 215, 7, 70, "Output",
 CellID->18010177]
}, Open  ]],
Cell[33659, 1202, 125, 3, 70, "ExampleDelimiter",
 CellID->785111787],
Cell[33787, 1207, 206, 8, 70, "ExampleText",
 CellID->826174799],
Cell[CellGroupData[{
Cell[34018, 1219, 313, 9, 70, "Input",
 CellID->2038068938],
Cell[34334, 1230, 273, 8, 70, "Output",
 CellID->2049334259]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34656, 1244, 229, 7, 70, "ExampleSubsection",
 CellID->3385024],
Cell[34888, 1253, 72, 1, 70, "ExampleText",
 CellID->187974734],
Cell[CellGroupData[{
Cell[34985, 1258, 368, 12, 70, "Input",
 CellID->155850066],
Cell[35356, 1272, 507, 15, 70, "Output",
 CellID->1818160427]
}, Open  ]],
Cell[35878, 1290, 125, 3, 70, "ExampleDelimiter",
 CellID->443680215],
Cell[36006, 1295, 83, 1, 70, "ExampleText",
 CellID->375560463],
Cell[CellGroupData[{
Cell[36114, 1300, 267, 8, 70, "Input",
 CellID->179308],
Cell[36384, 1310, 244, 8, 70, "Output",
 CellID->1277483426]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36677, 1324, 237, 7, 70, "ExampleSubsection",
 CellID->114830278],
Cell[36917, 1333, 74, 1, 70, "ExampleText",
 CellID->33784897],
Cell[CellGroupData[{
Cell[37016, 1338, 615, 18, 70, "Input",
 CellID->340562913],
Cell[37634, 1358, 1014, 27, 70, "Output",
 CellID->140349344]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38697, 1391, 236, 7, 70, "ExampleSubsection",
 CellID->244835540],
Cell[38936, 1400, 84, 1, 70, "ExampleText",
 CellID->1049336160],
Cell[CellGroupData[{
Cell[39045, 1405, 291, 9, 70, "Input",
 CellID->1057131956],
Cell[39339, 1416, 381, 13, 70, "Output",
 CellID->147981284]
}, Open  ]],
Cell[39735, 1432, 125, 3, 70, "ExampleDelimiter",
 CellID->251653051],
Cell[39863, 1437, 81, 1, 70, "ExampleText",
 CellID->127393980],
Cell[CellGroupData[{
Cell[39969, 1442, 315, 10, 70, "Input",
 CellID->481286671],
Cell[40287, 1454, 405, 13, 70, "Output",
 CellID->325155535]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40741, 1473, 236, 7, 70, "ExampleSubsection",
 CellID->872326991],
Cell[40980, 1482, 250, 8, 70, "ExampleText",
 CellID->329211532],
Cell[CellGroupData[{
Cell[41255, 1494, 414, 13, 70, "Input",
 CellID->5137226],
Cell[41672, 1509, 323, 11, 70, "Output",
 CellID->1066304845]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42044, 1526, 229, 7, 70, "ExampleSubsection",
 CellID->1011363901],
Cell[42276, 1535, 206, 8, 70, "ExampleText",
 CellID->1600039704],
Cell[CellGroupData[{
Cell[42507, 1547, 103, 3, 70, "Input",
 CellID->94729581],
Cell[42613, 1552, 189, 6, 70, "Output",
 CellID->634495700]
}, Open  ]],
Cell[42817, 1561, 124, 3, 70, "ExampleDelimiter",
 CellID->41257146],
Cell[42944, 1566, 357, 12, 70, "ExampleText",
 CellID->1677501360],
Cell[CellGroupData[{
Cell[43326, 1582, 167, 5, 70, "Input",
 CellID->227336428],
Cell[43496, 1589, 208, 7, 70, "Output",
 CellID->1712922545]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43753, 1602, 231, 7, 70, "ExampleSubsection",
 CellID->149799147],
Cell[43987, 1611, 73, 1, 70, "ExampleText",
 CellID->175289357],
Cell[CellGroupData[{
Cell[44085, 1616, 423, 13, 70, "Input",
 CellID->394705405],
Cell[44511, 1631, 370, 11, 70, "Output",
 CellID->2070925780]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44930, 1648, 230, 7, 70, "ExampleSubsection",
 CellID->342235385],
Cell[45163, 1657, 64, 1, 70, "ExampleText",
 CellID->92076458],
Cell[CellGroupData[{
Cell[45252, 1662, 460, 14, 70, "Input",
 CellID->807926503],
Cell[45715, 1678, 679, 25, 70, "Output",
 CellID->1094918808]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46443, 1709, 232, 7, 70, "ExampleSubsection",
 CellID->625909917],
Cell[46678, 1718, 82, 1, 70, "ExampleText",
 CellID->184274304],
Cell[CellGroupData[{
Cell[46785, 1723, 286, 9, 70, "Input",
 CellID->772271996],
Cell[47074, 1734, 437, 15, 70, "Output",
 CellID->513034913]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[47572, 1756, 226, 7, 70, "ExampleSection",
 CellID->27722146],
Cell[47801, 1765, 71, 1, 70, "ExampleText",
 CellID->409431585],
Cell[CellGroupData[{
Cell[47897, 1770, 654, 20, 70, "Input",
 CellID->1677257559],
Cell[48554, 1792, 516, 16, 70, "Output",
 CellID->61767387]
}, Open  ]],
Cell[CellGroupData[{
Cell[49107, 1813, 1045, 30, 70, "Input",
 CellID->1513874022],
Cell[50155, 1845, 672, 20, 70, "Output",
 CellID->117817295]
}, Open  ]],
Cell[50842, 1868, 125, 3, 70, "ExampleDelimiter",
 CellID->360008507],
Cell[50970, 1873, 64, 1, 70, "ExampleText",
 CellID->313488700],
Cell[CellGroupData[{
Cell[51059, 1878, 604, 19, 70, "Input",
 CellID->285084262],
Cell[51666, 1899, 521, 15, 70, "Output",
 CellID->91844285]
}, Open  ]],
Cell[CellGroupData[{
Cell[52224, 1919, 519, 15, 70, "Input",
 CellID->132779615],
Cell[52746, 1936, 468, 14, 70, "Output",
 CellID->136366687]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53263, 1956, 237, 7, 70, "ExampleSection",
 CellID->617359884],
Cell[53503, 1965, 450, 17, 70, "ExampleText",
 CellID->308691124],
Cell[CellGroupData[{
Cell[53978, 1986, 914, 29, 70, "Input",
 CellID->1602447664],
Cell[54895, 2017, 471, 14, 70, "Output",
 CellID->790599379]
}, Open  ]],
Cell[CellGroupData[{
Cell[55403, 2036, 714, 23, 70, "Input",
 CellID->100639615],
Cell[56120, 2061, 1953, 43, 70, "Output",
 CellID->1122438864]
}, Open  ]],
Cell[CellGroupData[{
Cell[58110, 2109, 787, 25, 70, "Input",
 CellID->1060906608],
Cell[58900, 2136, 18880, 428, 70, "Output",
 CellID->1333632000]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77841, 2571, 310, 9, 70, "SeeAlsoSection",
 CellID->2850],
Cell[78154, 2582, 1931, 71, 70, "SeeAlso",
 CellID->22892]
}, Open  ]],
Cell[CellGroupData[{
Cell[80122, 2658, 314, 9, 70, "TutorialsSection",
 CellID->26925],
Cell[80439, 2669, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[80601, 2674, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[80811, 2682, 319, 9, 70, "MoreAboutSection",
 CellID->260174562],
Cell[81133, 2693, 141, 3, 70, "MoreAbout",
 CellID->125036510],
Cell[81277, 2698, 159, 3, 70, "MoreAbout",
 CellID->313793545]
}, Open  ]],
Cell[81451, 2704, 27, 0, 70, "History"],
Cell[81481, 2706, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

