(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28884,        891]
NotebookOptionsPosition[     24441,        743]
NotebookOutlinePosition[     25840,        782]
CellTagsIndexPosition[     25755,        777]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tooltip" :> Documentation`HelpLookup["paclet:ref/Tooltip"], 
          "Mouseover" :> Documentation`HelpLookup["paclet:ref/Mouseover"], 
          "StatusArea" :> Documentation`HelpLookup["paclet:ref/StatusArea"], 
          "WindowStatusArea" :> 
          Documentation`HelpLookup["paclet:ref/WindowStatusArea"], 
          "MouseAnnotation" :> 
          Documentation`HelpLookup["paclet:ref/MouseAnnotation"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], "TagBox" :> 
          Documentation`HelpLookup["paclet:ref/TagBox"], "CellTags" :> 
          Documentation`HelpLookup["paclet:ref/CellTags"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tooltip\"\>", 
       2->"\<\"Mouseover\"\>", 3->"\<\"StatusArea\"\>", 
       4->"\<\"WindowStatusArea\"\>", 5->"\<\"MouseAnnotation\"\>", 
       6->"\<\"CurrentValue\"\>", 7->"\<\"TagBox\"\>", 
       8->"\<\"CellTags\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Creating Web Pages\"\>", 3->"\<\"Dynamic Visualization\"\>", 
       4->"\<\"Graphics Annotation & Appearance\"\>", 
       5->"\<\"Symbolic Graphics Language\"\>", 
       6->"\<\"Viewers and Annotation\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Annotation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Annotation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Annotation"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", with annotation ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Annotation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Annotation"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["data", "TI"], ",", "\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies the type of annotation being given."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->8363]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Annotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Annotation"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 " displays as ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4651],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 " can be used with graphics or any other expression. "
}], "Notes",
 CellID->1219],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 " acts an inert wrapper for storing annotations in expressions."
}], "Notes",
 CellID->12285670],

Cell[TextData[{
 "With particular ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\""], "InlineFormula"],
 " specifications, annotations are picked up by various built-in functions:"
}], "Notes",
 CellID->211911514],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Hyperlink\>\"", Cell[
    "hyperlink for exported image maps, etc.", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Mouse\>\"", Cell[TextData[{
     "annotation for ",
     Cell[BoxData[
      ButtonBox["MouseAnnotation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MouseAnnotation"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Region\>\"", Cell[TextData[{
     "regions for ",
     Cell[BoxData[
      ButtonBox["Rasterize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Rasterize"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Export",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Export"]], "InlineFormula"],
     ", etc."
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Tooltip\>\"", Cell[TextData[{
     "tooltip specification for ",
     Cell[BoxData[
      ButtonBox["Export",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Export"]], "InlineFormula"],
     ", etc."
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->495086163]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88642780],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->437353015],

Cell["\<\
Dynamically get the annotation when the mouse enters the disk:\
\>", "ExampleText",
 CellID->341000987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Annotation", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", "\"\<An annotation\>\"", ",", 
     "\"\<Mouse\>\""}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"MouseAnnotation", "[", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350669698],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    GraphicsBox[DiskBox[{0, 0}]],
    Annotation[#, "An annotation", "Mouse"]& ], ",", 
   DynamicBox[ToBoxes[
     MouseAnnotation[], StandardForm],
    ImageSizeCache->{28., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{158, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->451106228]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->711395896],

Cell["Annotate curves in a plot: ", "ExampleText",
 CellID->555119878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Annotation", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", "\"\<Sine\>\"", ",", 
       "\"\<Mouse\>\""}], "]"}], ",", 
     RowBox[{"Annotation", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", "\"\<Cosine\>\"", ",", 
       "\"\<Mouse\>\""}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2546918],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39653224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"MouseAnnotation", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->217450152],

Cell[BoxData[
 DynamicBox[ToBoxes[
   MouseAnnotation[], StandardForm],
  ImageSizeCache->{28., {0., 8.}}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84707788]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 " annotations can be replaced by their respective functions:"
}], "ExampleText",
 CellID->640676973],

Cell[BoxData[
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Annotation", "[", 
       RowBox[{
        RowBox[{"Disk", "[", "]"}], ",", "\"\<http://www.wolfram.com\>\"", 
        ",", "\"\<Hyperlink\>\""}], "]"}], ",", 
      RowBox[{"Annotation", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "\"\<A Disk\>\"", ",", 
        "\"\<Tooltip\>\""}], "]"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177492848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<test1.html\>\""}], "]"}], ",", 
   "g1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->312926642],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test1.html\"\>"], "Output",
 ImageSize->{438, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491364766]
}, Open  ]],

Cell["An equivalent expression: ", "ExampleText",
 CellID->151730019],

Cell[BoxData[
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hyperlink", "[", 
       RowBox[{
        RowBox[{"Disk", "[", "]"}], ",", "\"\<http://www.wolfram.com\>\""}], 
       "]"}], ",", 
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "\"\<A Disk\>\""}], 
       "]"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->351450732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<test2.html\>\""}], "]"}], ",", 
   "g2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->297827013],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test2.html\"\>"], "Output",
 ImageSize->{438, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->458603110]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27252],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mouseover",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mouseover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowStatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowStatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MouseAnnotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MouseAnnotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellTags",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellTags"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25917],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->117678406],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->35383405],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout",
 CellID->150245492],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->64257048],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->547755885],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->215892482],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->872591297],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->164962379]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Annotation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 20.6272880}", "context" -> "System`", 
    "keywords" -> {
     "annotations", "annotations for objects", "annotations for graphics", 
      "annotations for typesetting"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Annotation[expr, data] represents an expression expr, with annotation \
data. Annotation[expr, data, \" type\"] specifies the type of annotation \
being given.", "synonyms" -> {}, "title" -> "Annotation", "type" -> "Symbol", 
    "uri" -> "ref/Annotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9864, 286, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->88642780]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25613, 770}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3584, 79, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4207, 106, 1575, 37, 70, "ObjectNameGrid"],
Cell[5785, 145, 1122, 35, 70, "Usage",
 CellID->8363]
}, Open  ]],
Cell[CellGroupData[{
Cell[6944, 185, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7422, 202, 353, 14, 70, "Notes",
 CellID->4651],
Cell[7778, 218, 222, 7, 70, "Notes",
 CellID->1219],
Cell[8003, 227, 236, 7, 70, "Notes",
 CellID->12285670],
Cell[8242, 236, 226, 6, 70, "Notes",
 CellID->211911514],
Cell[8471, 244, 1356, 37, 70, "2ColumnTableMod",
 CellID->495086163]
}, Closed]],
Cell[CellGroupData[{
Cell[9864, 286, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88642780],
Cell[CellGroupData[{
Cell[10248, 300, 148, 5, 70, "ExampleSection",
 CellID->437353015],
Cell[10399, 307, 113, 3, 70, "ExampleText",
 CellID->341000987],
Cell[CellGroupData[{
Cell[10537, 314, 368, 11, 47, "Input",
 CellID->350669698],
Cell[10908, 327, 442, 14, 123, "Output",
 CellID->451106228]
}, Open  ]],
Cell[11365, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->711395896],
Cell[11493, 349, 70, 1, 70, "ExampleText",
 CellID->555119878],
Cell[CellGroupData[{
Cell[11588, 354, 594, 18, 47, "Input",
 CellID->2546918],
Cell[12185, 374, 4575, 79, 128, "Output",
 Evaluatable->False,
 CellID->39653224]
}, Open  ]],
Cell[CellGroupData[{
Cell[16797, 458, 140, 4, 70, "Input",
 CellID->217450152],
Cell[16940, 464, 247, 8, 70, "Output",
 CellID->84707788]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17236, 478, 233, 7, 70, "ExampleSection",
 CellID->31993],
Cell[17472, 487, 365, 12, 70, "ExampleText",
 CellID->640676973],
Cell[17840, 501, 576, 17, 70, "Input",
 CellID->177492848],
Cell[CellGroupData[{
Cell[18441, 522, 225, 7, 70, "Input",
 CellID->312926642],
Cell[18669, 531, 245, 6, 36, "Output",
 CellID->491364766]
}, Open  ]],
Cell[18929, 540, 69, 1, 70, "ExampleText",
 CellID->151730019],
Cell[19001, 543, 520, 17, 70, "Input",
 CellID->351450732],
Cell[CellGroupData[{
Cell[19546, 564, 225, 7, 70, "Input",
 CellID->297827013],
Cell[19774, 573, 245, 6, 36, "Output",
 CellID->458603110]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20080, 586, 311, 9, 70, "SeeAlsoSection",
 CellID->27252],
Cell[20394, 597, 1958, 71, 70, "SeeAlso",
 CellID->3586]
}, Open  ]],
Cell[CellGroupData[{
Cell[22389, 673, 314, 9, 70, "TutorialsSection",
 CellID->25917],
Cell[22706, 684, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[22889, 692, 319, 9, 70, "MoreAboutSection",
 CellID->117678406],
Cell[23211, 703, 172, 3, 70, "MoreAbout",
 CellID->35383405],
Cell[23386, 708, 146, 3, 70, "MoreAbout",
 CellID->150245492],
Cell[23535, 713, 152, 3, 70, "MoreAbout",
 CellID->64257048],
Cell[23690, 718, 175, 3, 70, "MoreAbout",
 CellID->547755885],
Cell[23868, 723, 162, 3, 70, "MoreAbout",
 CellID->215892482],
Cell[24033, 728, 154, 3, 70, "MoreAbout",
 CellID->872591297],
Cell[24190, 733, 179, 3, 70, "MoreAbout",
 CellID->164962379]
}, Open  ]],
Cell[24384, 739, 27, 0, 70, "History"],
Cell[24414, 741, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

