(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37069,       1388]
NotebookOptionsPosition[     30200,       1150]
NotebookOutlinePosition[     31588,       1189]
CellTagsIndexPosition[     31502,       1184]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric2F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric2F1"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypergeometric2F1\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/HypergeometricFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Hypergeometric Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AppellF1", "ObjectName",
 CellID->15618],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AppellF1",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AppellF1"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["c", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the Appell hypergeometric function of two variables \
",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["F", "1"], 
        RowBox[{"(", 
         RowBox[{"a", ";", 
          SubscriptBox["b", "1"], ",", 
          SubscriptBox["b", "2"], ";", "c", ";", "x", ",", "y"}], ")"}]}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25013]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "1"], 
    RowBox[{"(", 
     RowBox[{"a", ";", 
      SubscriptBox["b", "1"], ",", 
      SubscriptBox["b", "2"], ";", "c", ";", "x", ",", "y"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 " has series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"m", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    SubscriptBox[
     RowBox[{"(", "a", ")"}], 
     RowBox[{"m", "+", "n"}]], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["b", "1"], ")"}], "m"], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["b", "2"], ")"}], "n"], "/", 
    RowBox[{"(", 
     RowBox[{"m", "!", "n", "!", 
      SubscriptBox[
       RowBox[{"(", "c", ")"}], 
       RowBox[{"m", "+", "n"}]]}], ")"}], 
    SuperscriptBox["x", "m"], 
    SuperscriptBox["y", "n"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->15712],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "1"], 
    RowBox[{"(", 
     RowBox[{"a", ";", 
      SubscriptBox["b", "1"], ",", 
      SubscriptBox["b", "2"], ";", "c", ";", "x", ",", "y"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 " reduces to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "2"], 
    SubscriptBox["F", "1"], 
    RowBox[{"(", 
     RowBox[{"a", ",", "b", ";", "c", ";", "z"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27896],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["AppellF1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppellF1"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AppellF1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppellF1"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AppellF1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppellF1"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["b", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["b", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["c", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " has singular lines in two\[Hyphen]variable complex ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " space at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    ButtonBox["Re",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Re"], 
    RowBox[{"(", "x", ")"}], "=", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    ButtonBox["Re",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Re"], 
    RowBox[{"(", "y", ")"}], "=", "1"}], TraditionalForm]], "InlineMath"],
 ", and has branch cut discontinuities along the rays from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->21909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " include transformation rules for ",
 Cell[BoxData[
  ButtonBox["AppellF1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppellF1"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27841]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->211390227],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->404715636],

Cell["Evaluate numerically:", "ExampleText",
 CellID->242785238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppellF1", "[", 
  RowBox[{"2", ",", "1", ",", "1", ",", "3", ",", "0.7", ",", "0.3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->888018],

Cell[BoxData["2.6552233462063838619497215288327085559`20.954552856728842"], \
"Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358688881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731263426],

Cell["Evaluate symbolically:", "ExampleText",
 CellID->19728343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AppellF1", "[", 
   RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "x", ",", "y"}], "]"}], "//",
   "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219186450],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Log", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", "y"}]], "]"}], 
   RowBox[{"x", "-", "y"}]]}]], "Output",
 ImageSize->{75, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290018208]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40931094],

Cell["The defining sum:", "ExampleText",
 CellID->41622778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["y", "n"], 
    FractionBox[
     RowBox[{"Pochhammer", "[", 
      RowBox[{"a", ",", 
       RowBox[{"m", "+", "n"}]}], "]"}], 
     RowBox[{"Pochhammer", "[", 
      RowBox[{"c", ",", 
       RowBox[{"m", "+", "n"}]}], "]"}]], 
    FractionBox[
     RowBox[{"  ", 
      RowBox[{
       RowBox[{"Pochhammer", "[", 
        RowBox[{"b1", ",", "m"}], "]"}], " ", 
       RowBox[{"Pochhammer", "[", 
        RowBox[{"b2", ",", "n"}], "]"}]}]}], 
     RowBox[{
      RowBox[{"m", "!"}], " ", 
      RowBox[{"n", "!"}], " "}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2909851],

Cell[BoxData[
 RowBox[{"AppellF1", "[", 
  RowBox[{"a", ",", "b1", ",", "b2", ",", "c", ",", "x", ",", "y"}], 
  "]"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3503992]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5416],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->18128668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppellF1", "[", 
  RowBox[{
   RowBox[{"1", "+", "I"}], ",", "1", ",", "1", ",", "5", ",", "0.5", ",", 
   RowBox[{"0.3", "+", 
    RowBox[{"0.7", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68716854],

Cell[BoxData[
 RowBox[{"0.93899003035546850690506831520059482202`21.08309784478648", "+", 
  RowBox[{
  "0.30543835426192050237946215525449215534`20.59542841877597", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299791328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->485772819],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->452828497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AppellF1", "[", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"2", "/", "3"}], ",", "3", ",", 
     RowBox[{"1", "/", "5"}], ",", 
     RowBox[{"2", "/", "5"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9671113],

Cell[BoxData["1.\
4418435572012925152219027117892789337259746904078152874227001391777`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200806511]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->94035775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppellF1", "[", 
  RowBox[{"2", ",", "1", ",", 
   RowBox[{"2", "/", "3"}], ",", "3", ",", 
   RowBox[{"1", "/", "5"}], ",", "0.4000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->397981456],

Cell[BoxData["1.441843557201292515221902711789278933725401112012`35.\
6020230778658"], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->538241000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->321540067],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->222155598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppellF1", "[", 
  RowBox[{
   RowBox[{"-", "2"}], ",", "1", ",", "1", ",", "1", ",", "x", ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->719694762],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"x", " ", "y"}], "+", 
  SuperscriptBox["y", "2"], "-", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}]}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336577742]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppellF1", "[", 
  RowBox[{"a", ",", "0", ",", "b", ",", "c", ",", "x", ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->325941863],

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "y"}], "]"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->203294731]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppellF1", "[", 
  RowBox[{"a", ",", "b", ",", "b", ",", "c", ",", "x", ",", 
   RowBox[{"-", "x"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->312118459],

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], "+", 
      FractionBox["a", "2"]}], ",", 
     FractionBox["a", "2"], ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], "+", 
      FractionBox["c", "2"]}], ",", 
     FractionBox["c", "2"]}], "}"}], ",", 
   SuperscriptBox["x", "2"]}], "]"}]], "Output",
 ImageSize->{333, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3276572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180137226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->301865644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AppellF1", "[", 
   RowBox[{"a", ",", 
    SubscriptBox["b", "1"], ",", 
    SubscriptBox["b", "2"], ",", "c", ",", "x", ",", "y"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->505226124],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox[
    SubscriptBox["F", "1"],
    AppellF1,
    Editable->False,
    Selectable->False], "(", 
   RowBox[{
    RowBox[{"a", ";", 
     SubscriptBox["b", "1"]}], ",", 
    RowBox[{
     SubscriptBox["b", "2"], ";", "c", ";", "x"}], ",", "y"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->665823287]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30971],

Cell[TextData[{
 "The Appell system of PDEs for the Picard modular function associated with \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox["GL", "3"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->18433817],

Cell[BoxData[
 RowBox[{
  RowBox[{"pde", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "+", 
       RowBox[{"y", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           FractionBox["3", "2"], " ", "x"}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", "y", " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "-", 
       RowBox[{
        FractionBox["1", "16"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "y"}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "y"}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           FractionBox["3", "2"], " ", "y"}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "-", 
       RowBox[{
        FractionBox["1", "4"], "x", " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "-", 
       RowBox[{
        FractionBox["1", "16"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}]}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176897231],

Cell[TextData[{
 "Check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    InterpretationBox[
     SubscriptBox["F", "1"],
     AppellF1,
     Editable->False,
     Selectable->False], "(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], ";", 
      FractionBox["1", "4"]}], ",", 
     RowBox[{
      FractionBox["1", "4"], ";", "1", ";", "x"}], ",", "y"}], ")"}], 
   TraditionalForm]], "InlineMath"],
 " is a solution:"
}], "ExampleText",
 CellID->110790840],

Cell[BoxData[
 RowBox[{
  RowBox[{"pde", "/.", 
   RowBox[{"f", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"AppellF1", "[", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", 
        RowBox[{"1", "/", "4"}], ",", 
        RowBox[{"1", "/", "4"}], ",", "1", ",", "x", ",", "y"}], "]"}]}], 
     "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402124992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "\[Rule]", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->462439141],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7815333]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10844],

Cell[TextData[{
 "Evaluate integrals in terms of ",
 Cell[BoxData[
  ButtonBox["AppellF1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppellF1"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->168439760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SqrtBox["x"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "2"}], ")"}], "k"]}], " ", ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95294694],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  SuperscriptBox["2", 
   RowBox[{"1", "+", "k"}]], " ", 
  SuperscriptBox["x", 
   RowBox[{"3", "/", "2"}]], " ", 
  RowBox[{"AppellF1", "[", 
   RowBox[{
    FractionBox["3", "2"], ",", 
    RowBox[{"-", "n"}], ",", 
    RowBox[{"-", "k"}], ",", 
    FractionBox["5", "2"], ",", 
    RowBox[{"-", "x"}], ",", 
    RowBox[{"-", 
     FractionBox["x", "2"]}]}], "]"}]}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360031297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"1", "/", "2"}]], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"1", "/", "2"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "-", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}], 
     RowBox[{"1", "/", "2"}]]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->811757318],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox["2"], " ", 
   RowBox[{"AppellF1", "[", 
    RowBox[{
     FractionBox["3", "4"], ",", 
     FractionBox["1", "4"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["7", "4"], ",", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"], ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"], "2"]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"3", "/", "2"}]]}], 
  RowBox[{"3", " ", 
   SqrtBox[
    RowBox[{"Cos", "[", "x", "]"}]]}]]], "Output",
 ImageSize->{447, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->357338384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29180063],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify some expressions involving ",
 Cell[BoxData[
  ButtonBox["AppellF1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppellF1"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->298754235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "5"], " ", 
    RowBox[{"AppellF1", "[", 
     RowBox[{
      FractionBox["3", "2"], ",", "1", ",", "2", ",", 
      FractionBox["5", "2"], ",", 
      SuperscriptBox["x", "3"], ",", 
      SuperscriptBox["x", "5"]}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"AppellF1", "[", 
     RowBox[{
      FractionBox["3", "2"], ",", "2", ",", "1", ",", 
      FractionBox["5", "2"], ",", 
      SuperscriptBox["x", "3"], ",", 
      SuperscriptBox["x", "5"]}], "]"}]}], "-", 
   FractionBox[
    RowBox[{"3", "/", "2"}], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "3"], "-", 
     SuperscriptBox["x", "5"], "+", 
     SuperscriptBox["x", "8"]}]]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->359765893],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["3", "2"]}], " ", 
  RowBox[{"AppellF1", "[", 
   RowBox[{
    FractionBox["1", "2"], ",", "1", ",", "1", ",", 
    FractionBox["3", "2"], ",", 
    SuperscriptBox["x", "3"], ",", 
    SuperscriptBox["x", "5"]}], "]"}]}]], "Output",
 ImageSize->{213, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271028096]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6286],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->3523]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20130],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->9090]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->9034],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/AppellHypergeometricFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/AppellF1/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->50416042],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->317417537],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->173471334],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->67474370]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AppellF1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 27.4399624}", "context" -> "System`", 
    "keywords" -> {
     "Appell hypergeometric function", "hypergeometric functions", 
      "multivariate hypergeometric function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AppellF1[a, b_1, b_2, c, x, y] is the Appell hypergeometric function of \
two variables F_1 (a; b_1, b_2; c; x, y). ", 
    "synonyms" -> {"appell f1", "Appell F1", "F1"}, "title" -> "AppellF1", 
    "type" -> "Symbol", "uri" -> "ref/AppellF1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8701, 311, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->211390227]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31359, 1177}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2060, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2683, 78, 46, 1, 70, "ObjectName",
 CellID->15618],
Cell[2732, 81, 1104, 36, 70, "Usage",
 CellID->25013]
}, Open  ]],
Cell[CellGroupData[{
Cell[3873, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4351, 139, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4474, 145, 1084, 38, 70, "Notes",
 CellID->15712],
Cell[5561, 185, 733, 29, 70, "Notes",
 CellID->27896],
Cell[6297, 216, 243, 8, 70, "Notes",
 CellID->9487],
Cell[6543, 226, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6764, 235, 1421, 52, 70, "Notes",
 CellID->21909],
Cell[8188, 289, 476, 17, 70, "Notes",
 CellID->27841]
}, Closed]],
Cell[CellGroupData[{
Cell[8701, 311, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->211390227],
Cell[CellGroupData[{
Cell[9086, 325, 148, 5, 70, "ExampleSection",
 CellID->404715636],
Cell[9237, 332, 64, 1, 70, "ExampleText",
 CellID->242785238],
Cell[CellGroupData[{
Cell[9326, 337, 171, 5, 28, "Input",
 CellID->888018],
Cell[9500, 344, 218, 6, 36, "Output",
 CellID->358688881]
}, Open  ]],
Cell[9733, 353, 125, 3, 70, "ExampleDelimiter",
 CellID->731263426],
Cell[9861, 358, 64, 1, 70, "ExampleText",
 CellID->19728343],
Cell[CellGroupData[{
Cell[9950, 363, 202, 6, 70, "Input",
 CellID->219186450],
Cell[10155, 371, 370, 14, 65, "Output",
 CellID->290018208]
}, Open  ]],
Cell[10540, 388, 124, 3, 70, "ExampleDelimiter",
 CellID->40931094],
Cell[10667, 393, 59, 1, 70, "ExampleText",
 CellID->41622778],
Cell[CellGroupData[{
Cell[10751, 398, 852, 28, 70, "Input",
 CellID->2909851],
Cell[11606, 428, 259, 8, 36, "Output",
 CellID->3503992]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11914, 442, 215, 7, 70, "ExampleSection",
 CellID->5416],
Cell[12132, 451, 88, 1, 70, "ExampleText",
 CellID->18128668],
Cell[CellGroupData[{
Cell[12245, 456, 245, 7, 70, "Input",
 CellID->68716854],
Cell[12493, 465, 337, 9, 36, "Output",
 CellID->299791328]
}, Open  ]],
Cell[12845, 477, 125, 3, 70, "ExampleDelimiter",
 CellID->485772819],
Cell[12973, 482, 70, 1, 70, "ExampleText",
 CellID->452828497],
Cell[CellGroupData[{
Cell[13068, 487, 298, 9, 70, "Input",
 CellID->9671113],
Cell[13369, 498, 235, 7, 36, "Output",
 CellID->200806511]
}, Open  ]],
Cell[13619, 508, 112, 3, 70, "ExampleText",
 CellID->94035775],
Cell[CellGroupData[{
Cell[13756, 515, 250, 7, 70, "Input",
 CellID->397981456],
Cell[14009, 524, 227, 6, 36, "Output",
 CellID->538241000]
}, Open  ]],
Cell[14251, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->321540067],
Cell[14379, 538, 91, 1, 70, "ExampleText",
 CellID->222155598],
Cell[CellGroupData[{
Cell[14495, 543, 189, 6, 70, "Input",
 CellID->719694762],
Cell[14687, 551, 354, 12, 36, "Output",
 CellID->336577742]
}, Open  ]],
Cell[CellGroupData[{
Cell[15078, 568, 170, 5, 70, "Input",
 CellID->325941863],
Cell[15251, 575, 245, 7, 36, "Output",
 CellID->203294731]
}, Open  ]],
Cell[CellGroupData[{
Cell[15533, 587, 186, 5, 70, "Input",
 CellID->312118459],
Cell[15722, 594, 566, 20, 51, "Output",
 CellID->3276572]
}, Open  ]],
Cell[16303, 617, 125, 3, 70, "ExampleDelimiter",
 CellID->180137226],
Cell[16431, 622, 203, 7, 70, "ExampleText",
 CellID->301865644],
Cell[CellGroupData[{
Cell[16659, 633, 257, 8, 70, "Input",
 CellID->505226124],
Cell[16919, 643, 484, 18, 50, "Output",
 CellID->665823287]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17452, 667, 223, 7, 70, "ExampleSection",
 CellID->30971],
Cell[17678, 676, 227, 8, 70, "ExampleText",
 CellID->18433817],
Cell[17908, 686, 3289, 109, 70, "Input",
 CellID->176897231],
Cell[21200, 797, 468, 19, 70, "ExampleText",
 CellID->110790840],
Cell[21671, 818, 461, 15, 70, "Input",
 CellID->402124992],
Cell[CellGroupData[{
Cell[22157, 837, 441, 15, 70, "Input",
 CellID->462439141],
Cell[22601, 854, 207, 7, 36, "Output",
 CellID->7815333]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22857, 867, 233, 7, 70, "ExampleSection",
 CellID->10844],
Cell[23093, 876, 214, 8, 70, "ExampleText",
 CellID->168439760],
Cell[CellGroupData[{
Cell[23332, 888, 335, 13, 70, "Input",
 CellID->95294694],
Cell[23670, 903, 567, 20, 51, "Output",
 CellID->360031297]
}, Open  ]],
Cell[CellGroupData[{
Cell[24274, 928, 502, 17, 70, "Input",
 CellID->811757318],
Cell[24779, 947, 898, 31, 68, "Output",
 CellID->357338384]
}, Open  ]],
Cell[25692, 981, 124, 3, 70, "ExampleDelimiter",
 CellID->29180063],
Cell[25819, 986, 359, 13, 70, "ExampleText",
 CellID->298754235],
Cell[CellGroupData[{
Cell[26203, 1003, 832, 26, 70, "Input",
 CellID->359765893],
Cell[27038, 1031, 418, 14, 51, "Output",
 CellID->271028096]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27517, 1052, 310, 9, 70, "SeeAlsoSection",
 CellID->6286],
Cell[27830, 1063, 213, 6, 70, "SeeAlso",
 CellID->3523]
}, Open  ]],
Cell[CellGroupData[{
Cell[28080, 1074, 314, 9, 70, "TutorialsSection",
 CellID->20130],
Cell[28397, 1085, 143, 3, 70, "Tutorials",
 CellID->9090]
}, Open  ]],
Cell[CellGroupData[{
Cell[28577, 1093, 320, 9, 70, "RelatedLinksSection",
 CellID->9034],
Cell[28900, 1104, 199, 4, 70, "RelatedLinks"],
Cell[29102, 1110, 204, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29343, 1119, 318, 9, 70, "MoreAboutSection",
 CellID->50416042],
Cell[29664, 1130, 159, 3, 70, "MoreAbout",
 CellID->317417537],
Cell[29826, 1135, 155, 3, 70, "MoreAbout",
 CellID->173471334],
Cell[29984, 1140, 144, 3, 70, "MoreAbout",
 CellID->67474370]
}, Open  ]],
Cell[30143, 1146, 27, 0, 70, "History"],
Cell[30173, 1148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

