(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23507,        844]
NotebookOptionsPosition[     18671,        672]
NotebookOutlinePosition[     19875,        707]
CellTagsIndexPosition[     19790,        702]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Adding, Removing and Modifying List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AddingRemovingAndModifyingListElements"], 
          "Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Adding, Removing and Modifying List Elements\"\>", 
       2->"\<\"Manipulating Lists by Their Indices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Prepend" :> Documentation`HelpLookup["paclet:ref/Prepend"], 
          "Insert" :> Documentation`HelpLookup["paclet:ref/Insert"], 
          "AppendTo" :> Documentation`HelpLookup["paclet:ref/AppendTo"], 
          "PadRight" :> Documentation`HelpLookup["paclet:ref/PadRight"], 
          "Sow" :> Documentation`HelpLookup["paclet:ref/Sow"], "Join" :> 
          Documentation`HelpLookup["paclet:ref/Join"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Prepend\"\>", 2->"\<\"Insert\"\>", 
       3->"\<\"AppendTo\"\>", 4->"\<\"PadRight\"\>", 5->"\<\"Sow\"\>", 
       6->"\<\"Join\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Elements of Lists\"\>", 3->"\<\"Expressions\"\>", 
       4->"\<\"Handling Arrays of Data\"\>", 5->"\<\"List Manipulation\"\>", 
       6->"\<\"Parts of Expressions\"\>", 
       7->"\<\"Rearranging & Restructuring Lists\"\>", 
       8->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Append", "ObjectName",
 CellID->2670],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Append",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Append"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " appended. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In iteratively building a list, it is usually more efficient to use ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " than to use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Append",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Append"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["new", "TI"]}], "]"}]], "InlineFormula"],
 " at each step. "
}], "Notes",
 CellID->10506],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Append",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Append"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, returning ordinary lists if necessary. "
}], "Notes",
 CellID->9088]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->397285050],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->525607261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Append", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "x"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30858]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28290],

Cell[TextData[{
 "Use a head other than ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Append", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1707],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8234]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11462],

Cell["Append a row to a matrix:", "ExampleText",
 CellID->19402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Append", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8239],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\:f3a2", GridBox[{
     {"a", "b"},
     {"c", "d"},
     {"x", "y"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
      "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->3426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19095],

Cell["Append to each row in a matrix:", "ExampleText",
 CellID->30906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Append", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8314],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVc0OgjAMLn+KwkVjUBMPnD145wX05EMsxgQORoO8P3Zj6FI7MhKPkmxd
y9efre12Fk15vYmmuoj8VItHWV2e+fFeoyjwAKDAsdsArltcqVG0LdJujuQc
SKn6YE/4UKFCRirZFGmENEbqI/U1nRB8wFpR0ujNKwzA3C4NP7oAU3cfBp+y
1hMdd8zapDaoj2GbM4L27Tb5XZu67EnQqHkPMtOhEZfenPz9lT96trzFNeFX
TlqZ9pE5oQ9/lJG/vtciXQfjczZQZw4951ZpY3yM65K+hn9hyx5lf6omOnY8
C9tNmRj6ANST+525JDztQV5roX1sWbTbG9C9F+C9ABqDVdA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->441709865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4586],

Cell["Append a vector to a matrix:", "ExampleText",
 CellID->5279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MapThread", "[", 
   RowBox[{"Append", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17776],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVcEKwjAMzbZOp86DIlPBw/AkHrz7A3ryI8YQ9CDK9P9r2nVaYyoVPDpo
05emL12StrvidtifituxLPJtVVwOx/Kab84VqqIAANbYZhPAscSRbmspUS6w
Fwj7GsWqj9Ss/mBOMJ0XepVgtAqmKGOUPTLfIjhiWbQ2fmBtA9BltcpTiLLt
z2zhlOW0dw1ObspFfX3gFk+rd/bQzc7HxF7rjJOfF5VlYXapuMyv6kAkss6t
Sb35aEZ53jHBI69VmdlF5mW9+ltZWVQFkBjZNXEMJX9Wvq44XvtS1cnPfTQ1
2fGOgfgRl3uXTVRt68QzFq67074h6jNG8+d3iw4JpmeQXzUwPqasNX0Fllyk
oH5fILgDottquw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->272558185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6879],

Cell["Successively append to a list:", "ExampleText",
 CellID->32301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Append", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"{", "a", "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15812],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5676]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Append", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "x", ",", "y"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10144]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14199],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prepend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prepend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppendTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppendTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12674]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23256],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "Tutorials",
 CellID->25107],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->8266]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->111019201],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->162228678],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->522333907],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->195517875],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->370584672],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->135413143],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->786786895],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->175712662],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->258637721]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Append - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 27.7837212}", "context" -> "System`", 
    "keywords" -> {"addition", "appending", "join lists"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Append[expr, elem] gives expr with elem appended. ", "synonyms" -> {}, 
    "title" -> "Append", "type" -> "Symbol", "uri" -> "ref/Append"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6441, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->397285050]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19647, 695}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3590, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4213, 105, 43, 1, 70, "ObjectName",
 CellID->2670],
Cell[4259, 108, 675, 23, 70, "Usage",
 CellID->10845]
}, Open  ]],
Cell[CellGroupData[{
Cell[4971, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5449, 153, 601, 22, 70, "Notes",
 CellID->10506],
Cell[6053, 177, 351, 12, 70, "Notes",
 CellID->9088]
}, Closed]],
Cell[CellGroupData[{
Cell[6441, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->397285050],
Cell[CellGroupData[{
Cell[6826, 208, 148, 5, 70, "ExampleSection",
 CellID->525607261],
Cell[CellGroupData[{
Cell[6999, 217, 193, 7, 28, "Input",
 CellID->29832],
Cell[7195, 226, 229, 7, 36, "Output",
 CellID->30858]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7473, 239, 239, 7, 70, "ExampleSection",
 CellID->28290],
Cell[7715, 248, 192, 8, 70, "ExampleText",
 CellID->3967],
Cell[CellGroupData[{
Cell[7932, 260, 208, 7, 70, "Input",
 CellID->1707],
Cell[8143, 269, 248, 8, 36, "Output",
 CellID->8234]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8440, 283, 223, 7, 70, "ExampleSection",
 CellID->11462],
Cell[8666, 292, 64, 1, 70, "ExampleText",
 CellID->19402],
Cell[CellGroupData[{
Cell[8755, 297, 366, 13, 70, "Input",
 CellID->8239],
Cell[9124, 312, 606, 19, 78, "Output",
 CellID->3426]
}, Open  ]],
Cell[9745, 334, 121, 3, 70, "ExampleDelimiter",
 CellID->19095],
Cell[9869, 339, 70, 1, 70, "ExampleText",
 CellID->30906],
Cell[CellGroupData[{
Cell[9964, 344, 398, 15, 70, "Input",
 CellID->8314],
Cell[10365, 361, 576, 13, 70, "Output",
 Evaluatable->False,
 CellID->441709865]
}, Open  ]],
Cell[10956, 377, 120, 3, 70, "ExampleDelimiter",
 CellID->4586],
Cell[11079, 382, 66, 1, 70, "ExampleText",
 CellID->5279],
Cell[CellGroupData[{
Cell[11170, 387, 445, 16, 70, "Input",
 CellID->17776],
Cell[11618, 405, 605, 14, 70, "Output",
 Evaluatable->False,
 CellID->272558185]
}, Open  ]],
Cell[12238, 422, 120, 3, 70, "ExampleDelimiter",
 CellID->6879],
Cell[12361, 427, 69, 1, 70, "ExampleText",
 CellID->32301],
Cell[CellGroupData[{
Cell[12455, 432, 237, 8, 70, "Input",
 CellID->15812],
Cell[12695, 442, 611, 19, 36, "Output",
 CellID->5676]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13355, 467, 225, 7, 70, "ExampleSection",
 CellID->7357],
Cell[CellGroupData[{
Cell[13605, 478, 229, 8, 70, "Input",
 CellID->32570],
Cell[13837, 488, 268, 9, 36, "Output",
 CellID->6038]
}, Open  ]],
Cell[CellGroupData[{
Cell[14142, 502, 99, 3, 70, "Input",
 CellID->24312],
Cell[14244, 507, 229, 7, 36, "Output",
 CellID->10144]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14534, 521, 311, 9, 70, "SeeAlsoSection",
 CellID->14199],
Cell[14848, 532, 1407, 53, 70, "SeeAlso",
 CellID->12674]
}, Open  ]],
Cell[CellGroupData[{
Cell[16292, 590, 314, 9, 70, "TutorialsSection",
 CellID->23256],
Cell[16609, 601, 196, 4, 70, "Tutorials",
 CellID->25107],
Cell[16808, 607, 178, 4, 70, "Tutorials",
 CellID->8266]
}, Open  ]],
Cell[CellGroupData[{
Cell[17023, 616, 319, 9, 70, "MoreAboutSection",
 CellID->111019201],
Cell[17345, 627, 147, 3, 70, "MoreAbout",
 CellID->162228678],
Cell[17495, 632, 144, 3, 70, "MoreAbout",
 CellID->522333907],
Cell[17642, 637, 134, 3, 70, "MoreAbout",
 CellID->195517875],
Cell[17779, 642, 155, 3, 70, "MoreAbout",
 CellID->370584672],
Cell[17937, 647, 145, 3, 70, "MoreAbout",
 CellID->135413143],
Cell[18085, 652, 150, 3, 70, "MoreAbout",
 CellID->786786895],
Cell[18238, 657, 177, 3, 70, "MoreAbout",
 CellID->175712662],
Cell[18418, 662, 181, 3, 70, "MoreAbout",
 CellID->258637721]
}, Open  ]],
Cell[18614, 668, 27, 0, 70, "History"],
Cell[18644, 670, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

