(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33039,       1258]
NotebookOptionsPosition[     25852,       1005]
NotebookOutlinePosition[     27079,       1041]
CellTagsIndexPosition[     26993,       1036]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Append" :> Documentation`HelpLookup["paclet:ref/Append"], 
          "PrependTo" :> Documentation`HelpLookup["paclet:ref/PrependTo"], 
          "Sow" :> Documentation`HelpLookup["paclet:ref/Sow"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Append\"\>", 2->"\<\"PrependTo\"\>",
        3->"\<\"Sow\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Constructing Lists\"\>", 3->"\<\"Elements of Lists\"\>", 
       4->"\<\"Procedural Programming\"\>", 
       5->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AppendTo", "ObjectName",
 CellID->28469],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AppendTo",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AppendTo"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]appends ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " to the value of ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", and resets ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " to the result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AppendTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppendTo"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "=", 
   RowBox[{
    ButtonBox["Append",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Append"], "[", 
    RowBox[{
     StyleBox["s", "TI"], ",", 
     StyleBox["elem", "TI"]}], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28504],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AppendTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppendTo"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " does not evaluate ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4798],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["AppendTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppendTo"]], "InlineFormula"],
 " repeatedly to build up a list, though ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " will usually be more efficient. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->713662435,
  ButtonNote->"713662435"]
}], "Notes",
 CellID->4202],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AppendTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppendTo"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, returning ordinary lists if necessary. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->23105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31050444],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->464639978],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 " to a list:"
}], "ExampleText",
 CellID->11494944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "4", ",", "9"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127216836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "9"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80854844]
}, Open  ]],

Cell["Include a new value at the end of the list:", "ExampleText",
 CellID->145088879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"l", ",", " ", "16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6478896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "9", ",", "16"}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->209175990]
}, Open  ]],

Cell[TextData[{
 "The value assigned to ",
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 " has changed:"
}], "ExampleText",
 CellID->79900755],

Cell[CellGroupData[{

Cell[BoxData["l"], "Input",
 CellLabel->"In[3]:=",
 CellID->360550079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "9", ",", "16"}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->87595789]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6140],

Cell[TextData[{
 "Use a head other than ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3967],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"e", " ", "=", " ", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", " ", "c"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"AppendTo", "[", 
  RowBox[{"e", ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1707],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135262207]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->554012073],

Cell[TextData[{
 "This assigns ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " to a sparse matrix:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23105,
  ButtonNote->"23105"]
}], "ExampleText",
 CellID->433833737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", "i"}], "}"}], ",", 
    "3"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135393557],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549451380]
}, Open  ]],

Cell["Add a row to the matrix:", "ExampleText",
 CellID->132199243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"s", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54625957],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 6, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100804175]
}, Open  ]],

Cell["\<\
Appending an element with inconsistent dimensions requires converting to \
ordinary lists:\
\>", "ExampleText",
 CellID->91811606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"s", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->233977205],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8840407]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28488],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " to be a 2\[Times]2 matrix:"
}], "ExampleText",
 CellID->94389399],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405629810],

Cell[TextData[{
 "Append a row to ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->48465141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"m", ",", " ", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18615598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38549382]
}, Open  ]],

Cell[TextData[{
 "Append a column to ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->65755977],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"col", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"AppendTo", "[", 
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
     RowBox[{"col", "[", 
      RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->345528288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->800874553]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is now a 3\[Times]3 matrix:"
}], "ExampleText",
 CellID->322977225],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[4]:=",
 CellID->190164334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->220299051]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5589],

Cell["The first argument must be a variable:", "ExampleText",
 CellID->79233537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->650378038],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendTo", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\({1, 2}\\) is not a variable with a value, so its value \
cannot be changed. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/rvalue\\\", ButtonNote -> \
\\\"AppendTo::rvalue\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->83039666],

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "3"}], "]"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338123061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23707779],

Cell["The first argument must be a variable with a value:", "ExampleText",
 CellID->167906277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"k", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219291365],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendTo", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(k\\) is not a variable with a value, so its value cannot be \
changed. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/rvalue\\\", \
ButtonNote -> \\\"AppendTo::rvalue\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->706592418],

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"k", ",", "2"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->872884253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185065819],

Cell["\<\
The first argument must be assigned to something which can be appended to:\
\>", "ExampleText",
 CellID->170551083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", " ", "=", " ", "1"}], ";", 
  RowBox[{"AppendTo", "[", 
   RowBox[{"k", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340162720],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendTo", "::", "\<\"normal\"\>"}], ":", 
  " ", "\<\"Nonatomic expression expected at position \\!\\(1\\) in \
\\!\\(AppendTo[\\(\\(k, 2\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/normal\\\", \
ButtonNote -> \\\"AppendTo::normal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->147243110],

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"k", ",", "2"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342963570]
}, Open  ]],

Cell[TextData[{
 "Something for which",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["AtomQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AtomQ"]}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " cannot be appended to:"
}], "ExampleText",
 CellID->73529949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "k", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175591933],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22388064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427776523],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["AppendTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppendTo"]], "InlineFormula"],
 " to accumulate values in large loops can be slow:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->713662435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"sum", " ", "=", " ", "0"}], ";", 
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{"sum", " ", "<", " ", 
       RowBox[{"10", "^", "5"}]}], ",", 
      RowBox[{
       RowBox[{"r", " ", "=", " ", 
        RowBox[{"RandomInteger", "[", "9", "]"}]}], ";", 
       RowBox[{"sum", " ", "+=", " ", "r"}], ";", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"a", ",", " ", "r"}], "]"}]}]}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Length", "[", "a", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462277309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.425000000000008`", ",", "22250"}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367745048]
}, Open  ]],

Cell[TextData[{
 "There are many alternatives, such as using ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->107902303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{"sum", " ", "=", " ", "0"}], ";", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{"{", "a", "}"}]}], "}"}], " ", "=", " ", 
     RowBox[{"Reap", "[", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"sum", " ", "<", " ", 
         RowBox[{"10", "^", "5"}]}], ",", " ", 
        RowBox[{
         RowBox[{"r", " ", "=", " ", 
          RowBox[{"RandomInteger", "[", "9", "]"}]}], ";", " ", 
         RowBox[{"sum", " ", "+=", " ", "r"}], ";", " ", 
         RowBox[{"Sow", "[", "r", "]"}]}]}], "]"}], "]"}]}], ";", 
    RowBox[{"Length", "[", "a", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125230519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2699999999999897`", ",", "22250"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179188321]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14481],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Append",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Append"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrependTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrependTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1238],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->15032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with AppendTo",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=AppendTo"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->336171429],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->247409137],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->8901733],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->63995391],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->514443302],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->45939056]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AppendTo - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 28.0962292}", "context" -> "System`", 
    "keywords" -> {"list append"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AppendTo[s, elem] appends elem to the value of s, and resets s to the \
result. ", "synonyms" -> {"append to"}, "title" -> "AppendTo", "type" -> 
    "Symbol", "uri" -> "ref/AppendTo"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6474, 220, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->31050444]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26851, 1029}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2549, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3172, 87, 46, 1, 70, "ObjectName",
 CellID->28469],
Cell[3221, 90, 778, 26, 70, "Usage",
 CellID->22897]
}, Open  ]],
Cell[CellGroupData[{
Cell[4036, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4514, 138, 557, 22, 70, "Notes",
 CellID->28504],
Cell[5074, 162, 349, 14, 70, "Notes",
 CellID->4798],
Cell[5426, 178, 604, 22, 70, "Notes",
 CellID->4202],
Cell[6033, 202, 404, 13, 70, "Notes",
 CellID->23105]
}, Closed]],
Cell[CellGroupData[{
Cell[6474, 220, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31050444],
Cell[CellGroupData[{
Cell[6858, 234, 148, 5, 70, "ExampleSection",
 CellID->464639978],
Cell[7009, 241, 137, 6, 70, "ExampleText",
 CellID->11494944],
Cell[CellGroupData[{
Cell[7171, 251, 169, 5, 28, "Input",
 CellID->127216836],
Cell[7343, 258, 222, 7, 36, "Output",
 CellID->80854844]
}, Open  ]],
Cell[7580, 268, 86, 1, 70, "ExampleText",
 CellID->145088879],
Cell[CellGroupData[{
Cell[7691, 273, 131, 4, 28, "Input",
 CellID->6478896],
Cell[7825, 279, 235, 7, 36, "Output",
 CellID->209175990]
}, Open  ]],
Cell[8075, 289, 154, 6, 70, "ExampleText",
 CellID->79900755],
Cell[CellGroupData[{
Cell[8254, 299, 70, 2, 70, "Input",
 CellID->360550079],
Cell[8327, 303, 234, 7, 36, "Output",
 CellID->87595789]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8610, 316, 238, 7, 70, "ExampleSection",
 CellID->6140],
Cell[8851, 325, 192, 8, 70, "ExampleText",
 CellID->3967],
Cell[CellGroupData[{
Cell[9068, 337, 298, 10, 70, "Input",
 CellID->1707],
Cell[9369, 349, 253, 8, 36, "Output",
 CellID->135262207]
}, Open  ]],
Cell[9637, 360, 125, 3, 70, "ExampleDelimiter",
 CellID->554012073],
Cell[9765, 365, 259, 10, 70, "ExampleText",
 CellID->433833737],
Cell[CellGroupData[{
Cell[10049, 379, 288, 10, 70, "Input",
 CellID->135393557],
Cell[10340, 391, 479, 17, 36, "Output",
 CellID->549451380]
}, Open  ]],
Cell[10834, 411, 67, 1, 70, "ExampleText",
 CellID->132199243],
Cell[CellGroupData[{
Cell[10926, 416, 185, 6, 70, "Input",
 CellID->54625957],
Cell[11114, 424, 479, 17, 36, "Output",
 CellID->100804175]
}, Open  ]],
Cell[11608, 444, 140, 4, 70, "ExampleText",
 CellID->91811606],
Cell[CellGroupData[{
Cell[11773, 452, 176, 6, 70, "Input",
 CellID->233977205],
Cell[11952, 460, 517, 17, 36, "Output",
 CellID->8840407]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12518, 483, 223, 7, 70, "ExampleSection",
 CellID->28488],
Cell[12744, 492, 153, 6, 70, "ExampleText",
 CellID->94389399],
Cell[12900, 500, 275, 10, 70, "Input",
 CellID->405629810],
Cell[13178, 512, 136, 6, 70, "ExampleText",
 CellID->48465141],
Cell[CellGroupData[{
Cell[13339, 522, 180, 6, 70, "Input",
 CellID->18615598],
Cell[13522, 530, 360, 13, 36, "Output",
 CellID->38549382]
}, Open  ]],
Cell[13897, 546, 139, 6, 70, "ExampleText",
 CellID->65755977],
Cell[CellGroupData[{
Cell[14061, 556, 481, 16, 70, "Input",
 CellID->345528288],
Cell[14545, 574, 391, 13, 36, "Output",
 CellID->800874553]
}, Open  ]],
Cell[14951, 590, 143, 5, 70, "ExampleText",
 CellID->322977225],
Cell[CellGroupData[{
Cell[15119, 599, 70, 2, 70, "Input",
 CellID->190164334],
Cell[15192, 603, 391, 13, 36, "Output",
 CellID->220299051]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15632, 622, 225, 7, 70, "ExampleSection",
 CellID->5589],
Cell[15860, 631, 80, 1, 70, "ExampleText",
 CellID->79233537],
Cell[CellGroupData[{
Cell[15965, 636, 181, 6, 70, "Input",
 CellID->650378038],
Cell[16149, 644, 412, 8, 70, "Message",
 CellID->83039666],
Cell[16564, 654, 265, 9, 36, "Output",
 CellID->338123061]
}, Open  ]],
Cell[16844, 666, 124, 3, 70, "ExampleDelimiter",
 CellID->23707779],
Cell[16971, 671, 94, 1, 70, "ExampleText",
 CellID->167906277],
Cell[CellGroupData[{
Cell[17090, 676, 127, 4, 70, "Input",
 CellID->219291365],
Cell[17220, 682, 406, 7, 70, "Message",
 CellID->706592418],
Cell[17629, 691, 216, 7, 36, "Output",
 CellID->872884253]
}, Open  ]],
Cell[17860, 701, 125, 3, 70, "ExampleDelimiter",
 CellID->185065819],
Cell[17988, 706, 125, 3, 70, "ExampleText",
 CellID->170551083],
Cell[CellGroupData[{
Cell[18138, 713, 184, 6, 70, "Input",
 CellID->340162720],
Cell[18325, 721, 426, 8, 70, "Message",
 CellID->147243110],
Cell[18754, 731, 216, 7, 36, "Output",
 CellID->342963570]
}, Open  ]],
Cell[18985, 741, 358, 14, 70, "ExampleText",
 CellID->73529949],
Cell[CellGroupData[{
Cell[19368, 759, 101, 3, 70, "Input",
 CellID->175591933],
Cell[19472, 764, 160, 5, 36, "Output",
 CellID->22388064]
}, Open  ]],
Cell[19647, 772, 125, 3, 70, "ExampleDelimiter",
 CellID->427776523],
Cell[19775, 777, 285, 9, 70, "ExampleText",
 CellID->713662435],
Cell[CellGroupData[{
Cell[20085, 790, 704, 20, 70, "Input",
 CellID->462277309],
Cell[20792, 812, 225, 7, 36, "Output",
 CellID->367745048]
}, Open  ]],
Cell[21032, 822, 337, 13, 70, "ExampleText",
 CellID->107902303],
Cell[CellGroupData[{
Cell[21394, 839, 754, 21, 70, "Input",
 CellID->125230519],
Cell[22151, 862, 225, 7, 36, "Output",
 CellID->179188321]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22437, 876, 311, 9, 70, "SeeAlsoSection",
 CellID->14481],
Cell[22751, 887, 684, 26, 70, "SeeAlso",
 CellID->15579]
}, Open  ]],
Cell[CellGroupData[{
Cell[23472, 918, 313, 9, 70, "TutorialsSection",
 CellID->1238],
Cell[23788, 929, 162, 3, 70, "Tutorials",
 CellID->15032]
}, Open  ]],
Cell[CellGroupData[{
Cell[23987, 937, 305, 8, 70, "RelatedLinksSection"],
Cell[24295, 947, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24693, 964, 319, 9, 70, "MoreAboutSection",
 CellID->336171429],
Cell[25015, 975, 134, 3, 70, "MoreAbout",
 CellID->247409137],
Cell[25152, 980, 145, 3, 70, "MoreAbout",
 CellID->8901733],
Cell[25300, 985, 143, 3, 70, "MoreAbout",
 CellID->63995391],
Cell[25446, 990, 155, 3, 70, "MoreAbout",
 CellID->514443302],
Cell[25604, 995, 176, 3, 70, "MoreAbout",
 CellID->45939056]
}, Open  ]],
Cell[25795, 1001, 27, 0, 70, "History"],
Cell[25825, 1003, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

