(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57088,       2266]
NotebookOptionsPosition[     44298,       1805]
NotebookOutlinePosition[     45596,       1842]
CellTagsIndexPosition[     45510,       1837]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsToListsAndOtherExpressions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Lists and Other Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Map" :> Documentation`HelpLookup["paclet:ref/Map"], "Scan" :> 
          Documentation`HelpLookup["paclet:ref/Scan"], "Level" :> 
          Documentation`HelpLookup["paclet:ref/Level"], "Operate" :> 
          Documentation`HelpLookup["paclet:ref/Operate"], "MapThread" :> 
          Documentation`HelpLookup["paclet:ref/MapThread"], "Total" :> 
          Documentation`HelpLookup["paclet:ref/Total"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"], "Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Map\"\>", 2->"\<\"Scan\"\>", 
       3->"\<\"Level\"\>", 4->"\<\"Operate\"\>", 5->"\<\"MapThread\"\>", 
       6->"\<\"Total\"\>", 7->"\<\"Sequence\"\>", 
       8->"\<\"Function\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Functional Programming\"\>", 
       3->"\<\"List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Apply ",
 StyleBox["(@@)", "OperatorCharacter"]
}], "ObjectName",
 CellID->16439],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Apply",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Apply"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "@@", 
       StyleBox["expr", "TI"]}]], "InlineFormula"],
     " replaces the head of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Apply",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Apply"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces heads in parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->27441]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->6648],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->26804],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "0", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27834],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "@@@", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19368],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->31441],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8872],

Cell[TextData[{
 "Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " consists of numbers, symbols and other objects that do not have subparts."
}], "Notes",
 CellID->32668],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->19974],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " always effectively constructs a complete new expression, and then \
evaluates it."
}], "Notes",
 CellID->5137],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " operates on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects just as it would on the corresponding ordinary lists. "
}], "Notes",
 CellID->20633]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8966117],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->84297105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6966],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15581]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8144],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32240]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15296],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17846455],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " gets rid of a level of lists:"
}], "ExampleText",
 CellID->100728201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", "c", "}"}], ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614400659],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", "d"}], "]"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290876417]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1205],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Level Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1181],

Cell["Apply at level 0 (default):", "ExampleText",
 CellID->794993555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1117655561],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "]"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->637683842]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93460457],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "]"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->114314126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->494878403],

Cell["Apply at level 1:", "ExampleText",
 CellID->16191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"d", ",", "e"}], "]"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35964762]
}, Open  ]],

Cell[TextData[{
 "The short form ",
 Cell[BoxData["@@@"], "InlineFormula"],
 " is equivalent to applying at level 1:"
}], "ExampleText",
 CellID->1115576733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1519920741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"d", ",", "e"}], "]"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->671804155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17876704],

Cell["Apply at levels 0 and 1:", "ExampleText",
 CellID->125206985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371627961],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"d", ",", "e"}], "]"}]}], "]"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85450617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371779205],

Cell["Apply down to level 2 (excluding level 0):", "ExampleText",
 CellID->358613875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->909254777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "]"}], "]"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259563980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->547179970],

Cell["Apply at levels 0 through 2:", "ExampleText",
 CellID->1744321283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2081362204],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"{", "a", "}"}], "}"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144321187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47936059],

Cell["Apply at all levels, starting at level 1:", "ExampleText",
 CellID->15813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "Infinity"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "a", "]"}], "]"}], "]"}], "]"}], "}"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262097936]
}, Open  ]],

Cell["Apply also at level 0:", "ExampleText",
 CellID->318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3580],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "a", "]"}], "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75444016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347937255],

Cell["Negative levels:", "ExampleText",
 CellID->8387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "a", "]"}], "]"}], "]"}], "]"}], "}"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360426405]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "a", "]"}], "]"}], "]"}], "]"}], "}"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->191911005]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"{", "a", "}"}], "]"}], "]"}], "]"}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->189175566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->432487459],

Cell["Positive and negative levels can be mixed:", "ExampleText",
 CellID->7152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"{", "a", "}"}], "]"}], "]"}], "}"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1025773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->209718750],

Cell["Different heads at each level:", "ExampleText",
 CellID->19885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"h0", "[", 
    RowBox[{"h1", "[", 
     RowBox[{"h2", "[", 
      RowBox[{"h3", "[", 
       RowBox[{"h4", "[", "a", "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337],

Cell[BoxData[
 RowBox[{"h0", "[", 
  RowBox[{"h1", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"h4", "[", "a", "]"}], "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40193492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->404112784],

Cell["Apply also inside heads at the levels specified:", "ExampleText",
 CellID->897462386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"p", "[", "x", "]"}], "[", 
    RowBox[{"q", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324662433],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "[", 
  RowBox[{"f", "[", "y", "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67006155]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2016],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"g", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14624],

Cell[BoxData[
 RowBox[{"x", "+", "y", "+", "z"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31693045]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418852255],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " works on sparse arrays:"
}], "ExampleText",
 CellID->113503104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"List", ",", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "1"}], ",", 
      RowBox[{"2", "\[Rule]", "2"}], ",", 
      RowBox[{"10", "\[Rule]", "10"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->903576251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "10"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->533109349]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15896],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Heads",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3210],

Cell["Apply inside heads as well as arguments:", "ExampleText",
 CellID->17776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"p", "[", "x", "]"}], "[", 
    RowBox[{"q", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5692],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "[", 
  RowBox[{"f", "[", "y", "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261921893]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"p", "[", "x", "]"}], "[", 
    RowBox[{"q", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15290],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "x", "]"}], "[", 
  RowBox[{"f", "[", "y", "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170134205]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13852],

Cell["Display the factorization of an integer using superscripts:", \
"ExampleText",
 CellID->17350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"20", "!"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->240931907]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CenterDot", "@@", 
  RowBox[{"(", 
   RowBox[{"Superscript", "@@@", "%"}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29361],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1VdtugkAQXdjFS+ulFbU0auLXtE/9CGKa6EPTxvqp/s92B2bL9jACiZaE
HebKmdnl8Jaf9u8f+emwy7evx/xrf9h9b18+j86kI6XU2d3TTLln656K+2yt
k+GqdCno0u7OnEpywXJJbnqwxaVStyROjVnOWGqOn7NuGvLIPPzzdlpjyCAE
KvnVGWYqWhdSbqAjmjnocaeqWAX9Cei9og729eiW2E8gsN+12Acd7YjynuP6
EjqhHsZhV13rFXnlBgfWVcsMcWdQb9tJRJG2dIP5hNf47mpvy7h3/3U8XYnW
cD38ytpQyue1xIy5z6DPhJ6aJnbtxNv8Tb1c4geKMKr+bY3EWngGJ0KHpI7F
bM9YD9JcTBhNqVi7QNiDmhw7/afYyHre0Z6J+/VIxWg1TEjx24zA4iNbsXho
p3g6x0kgQ/84sGuh7oT9xlZ/E8l/Kb/seNjQaXhqPbcbgePXoCNfoR/1AAnu
VkeWUwIf3BBVx/ksbcV0oX1zEyQDW+1301xwDuhfcZ01yw1Ipo/oB8Tcuj4=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413123549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9984],

Cell["Create a table from a list of range specifications:", "ExampleText",
 CellID->8729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "^", "j"}], ",", "##"}], "]"}], "&"}], "@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "27", ",", "81"}], "}"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182599097]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->453406583],

Cell["\<\
Turn a function that takes several arguments into one that takes a list of \
arguments:\
\>", "ExampleText",
 CellID->358798615],

Cell[BoxData[
 RowBox[{
  RowBox[{"cplus", "[", "list_", "]"}], ":=", 
  RowBox[{"Plus", "@@", "list"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1437853734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cplus", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2116411461],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->295213297]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28082],

Cell["Leaves are visited before roots:", "ExampleText",
 CellID->1937044645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Apply", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"{", "##", "}"}], "]"}], ";", 
       RowBox[{"{", "##", "}"}]}], ")"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", 
        RowBox[{"{", "c", "}"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1474531211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", "c", "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->65595182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", 
   RowBox[{"{", "c", "}"}]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->905009221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", "c", "}"}]}], "}"}]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->50358876]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1874508941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Total",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Total"]], "InlineFormula"],
 " does effectively the same as applying ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " to a list:"
}], "ExampleText",
 CellID->16806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1936],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70176294]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10790],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->425697744]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50319268],

Cell[TextData[{
 "Using ",
 Cell[BoxData["##"], "InlineFormula"],
 " in a pure function has the same effect as does ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1737293725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1053458311],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282613735]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Plus", "[", "##", "]"}], "&"}], "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1709343232],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->442599443]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223023250],

Cell["Three ways to apply a function at level 1:", "ExampleText",
 CellID->449587393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1864629346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30925480]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Apply", "[", 
    RowBox[{"f", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1058763651],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22079716]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1928556858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->46199832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->451313710],

Cell["\<\
Ordinary function application takes the list as a single argument:\
\>", "ExampleText",
 CellID->1576886905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1603636697],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98336800]
}, Open  ]],

Cell["Apply takes the element of the list as separate arguments:", \
"ExampleText",
 CellID->1095458339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1416033256],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70926405]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27623603],

Cell["\<\
Applying to atomic objects that do not have subparts effectively does \
nothing:\
\>", "ExampleText",
 CellID->408297524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97168050],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->432547416]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "\"\<string\>\"", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1234043840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "\<\"string\"\>", ",", "3"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18659314]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22974],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Level",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Level"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Operate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Operate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapThread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapThread"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3241],

Cell[TextData[ButtonBox["Applying Functions to Lists and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToListsAndOtherExpressions"]], "Tutorials",\

 CellID->5745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->684637922],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->10052820],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->378794534],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->19857540]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Apply (@@) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 28.4556134}", "context" -> "System`", 
    "keywords" -> {"applying functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Apply[f, expr] or f @@ expr replaces the head of expr by f. Apply[f, \
expr, levelspec] replaces heads in parts of expr specified by levelspec. ", 
    "synonyms" -> {"@@", "@@@"}, "title" -> "Apply", "type" -> "Symbol", 
    "uri" -> "ref/Apply"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9582, 334, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8966117]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45369, 1830}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2752, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3375, 88, 99, 4, 70, "ObjectName",
 CellID->16439],
Cell[3477, 94, 1359, 46, 70, "Usage",
 CellID->27441]
}, Open  ]],
Cell[CellGroupData[{
Cell[4873, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5351, 162, 196, 7, 70, "Notes",
 CellID->6648],
Cell[5550, 171, 1664, 55, 70, "2ColumnTableMod",
 CellID->26804],
Cell[7217, 228, 334, 14, 70, "Notes",
 CellID->27834],
Cell[7554, 244, 427, 17, 70, "Notes",
 CellID->19368],
Cell[7984, 263, 303, 12, 70, "Notes",
 CellID->31441],
Cell[8290, 277, 311, 13, 70, "Notes",
 CellID->8872],
Cell[8604, 292, 189, 6, 70, "Notes",
 CellID->32668],
Cell[8796, 300, 134, 5, 70, "Notes",
 CellID->19974],
Cell[8933, 307, 242, 8, 70, "Notes",
 CellID->5137],
Cell[9178, 317, 367, 12, 70, "Notes",
 CellID->20633]
}, Closed]],
Cell[CellGroupData[{
Cell[9582, 334, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8966117],
Cell[CellGroupData[{
Cell[9965, 348, 147, 5, 70, "ExampleSection",
 CellID->84297105],
Cell[CellGroupData[{
Cell[10137, 357, 188, 6, 28, "Input",
 CellID->6966],
Cell[10328, 365, 224, 7, 36, "Output",
 CellID->15581]
}, Open  ]],
Cell[CellGroupData[{
Cell[10589, 377, 155, 5, 28, "Input",
 CellID->8144],
Cell[10747, 384, 224, 7, 36, "Output",
 CellID->32240]
}, Open  ]],
Cell[CellGroupData[{
Cell[11008, 396, 159, 5, 28, "Input",
 CellID->15296],
Cell[11170, 403, 196, 6, 36, "Output",
 CellID->11876]
}, Open  ]],
Cell[11381, 412, 124, 3, 70, "ExampleDelimiter",
 CellID->17846455],
Cell[11508, 417, 201, 7, 70, "ExampleText",
 CellID->100728201],
Cell[CellGroupData[{
Cell[11734, 428, 226, 8, 70, "Input",
 CellID->614400659],
Cell[11963, 438, 292, 10, 36, "Output",
 CellID->290876417]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12304, 454, 216, 7, 70, "ExampleSection",
 CellID->1205],
Cell[CellGroupData[{
Cell[12545, 465, 237, 7, 70, "ExampleSubsection",
 CellID->1181],
Cell[12785, 474, 70, 1, 70, "ExampleText",
 CellID->794993555],
Cell[CellGroupData[{
Cell[12880, 479, 290, 10, 70, "Input",
 CellID->1117655561],
Cell[13173, 491, 317, 11, 36, "Output",
 CellID->637683842]
}, Open  ]],
Cell[CellGroupData[{
Cell[13527, 507, 251, 9, 70, "Input",
 CellID->93460457],
Cell[13781, 518, 317, 11, 36, "Output",
 CellID->114314126]
}, Open  ]],
Cell[14113, 532, 125, 3, 70, "ExampleDelimiter",
 CellID->494878403],
Cell[14241, 537, 56, 1, 70, "ExampleText",
 CellID->16191],
Cell[CellGroupData[{
Cell[14322, 542, 319, 11, 70, "Input",
 CellID->22471],
Cell[14644, 555, 321, 11, 36, "Output",
 CellID->35964762]
}, Open  ]],
Cell[14980, 569, 157, 5, 70, "ExampleText",
 CellID->1115576733],
Cell[CellGroupData[{
Cell[15162, 578, 254, 9, 70, "Input",
 CellID->1519920741],
Cell[15419, 589, 322, 11, 36, "Output",
 CellID->671804155]
}, Open  ]],
Cell[15756, 603, 124, 3, 70, "ExampleDelimiter",
 CellID->17876704],
Cell[15883, 608, 67, 1, 70, "ExampleText",
 CellID->125206985],
Cell[CellGroupData[{
Cell[15975, 613, 348, 12, 70, "Input",
 CellID->371627961],
Cell[16326, 627, 326, 11, 36, "Output",
 CellID->85450617]
}, Open  ]],
Cell[16667, 641, 125, 3, 70, "ExampleDelimiter",
 CellID->371779205],
Cell[16795, 646, 85, 1, 70, "ExampleText",
 CellID->358613875],
Cell[CellGroupData[{
Cell[16905, 651, 267, 10, 70, "Input",
 CellID->909254777],
Cell[17175, 663, 288, 10, 36, "Output",
 CellID->259563980]
}, Open  ]],
Cell[17478, 676, 125, 3, 70, "ExampleDelimiter",
 CellID->547179970],
Cell[17606, 681, 72, 1, 70, "ExampleText",
 CellID->1744321283],
Cell[CellGroupData[{
Cell[17703, 686, 314, 11, 70, "Input",
 CellID->2081362204],
Cell[18020, 699, 294, 10, 36, "Output",
 CellID->144321187]
}, Open  ]],
Cell[18329, 712, 124, 3, 70, "ExampleDelimiter",
 CellID->47936059],
Cell[18456, 717, 80, 1, 70, "ExampleText",
 CellID->15813],
Cell[CellGroupData[{
Cell[18561, 722, 270, 10, 70, "Input",
 CellID->27415],
Cell[18834, 734, 299, 10, 36, "Output",
 CellID->262097936]
}, Open  ]],
Cell[19148, 747, 59, 1, 70, "ExampleText",
 CellID->318],
Cell[CellGroupData[{
Cell[19232, 752, 315, 11, 70, "Input",
 CellID->3580],
Cell[19550, 765, 303, 10, 36, "Output",
 CellID->75444016]
}, Open  ]],
Cell[19868, 778, 125, 3, 70, "ExampleDelimiter",
 CellID->347937255],
Cell[19996, 783, 54, 1, 70, "ExampleText",
 CellID->8387],
Cell[CellGroupData[{
Cell[20075, 788, 279, 10, 70, "Input",
 CellID->13444],
Cell[20357, 800, 299, 10, 36, "Output",
 CellID->360426405]
}, Open  ]],
Cell[CellGroupData[{
Cell[20693, 815, 279, 10, 70, "Input",
 CellID->14507],
Cell[20975, 827, 299, 10, 36, "Output",
 CellID->191911005]
}, Open  ]],
Cell[CellGroupData[{
Cell[21311, 842, 279, 10, 70, "Input",
 CellID->17827],
Cell[21593, 854, 294, 10, 36, "Output",
 CellID->189175566]
}, Open  ]],
Cell[21902, 867, 125, 3, 70, "ExampleDelimiter",
 CellID->432487459],
Cell[22030, 872, 80, 1, 70, "ExampleText",
 CellID->7152],
Cell[CellGroupData[{
Cell[22135, 877, 330, 12, 70, "Input",
 CellID->30271],
Cell[22468, 891, 286, 10, 36, "Output",
 CellID->1025773]
}, Open  ]],
Cell[22769, 904, 125, 3, 70, "ExampleDelimiter",
 CellID->209718750],
Cell[22897, 909, 69, 1, 70, "ExampleText",
 CellID->19885],
Cell[CellGroupData[{
Cell[22991, 914, 358, 12, 70, "Input",
 CellID->337],
Cell[23352, 928, 306, 10, 36, "Output",
 CellID->40193492]
}, Open  ]],
Cell[23673, 941, 125, 3, 70, "ExampleDelimiter",
 CellID->404112784],
Cell[23801, 946, 91, 1, 70, "ExampleText",
 CellID->897462386],
Cell[CellGroupData[{
Cell[23917, 951, 289, 9, 70, "Input",
 CellID->324662433],
Cell[24209, 962, 240, 8, 36, "Output",
 CellID->67006155]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[24510, 977, 238, 7, 70, "ExampleSection",
 CellID->2016],
Cell[24751, 986, 314, 12, 70, "ExampleText",
 CellID->1943],
Cell[CellGroupData[{
Cell[25090, 1002, 187, 6, 70, "Input",
 CellID->14624],
Cell[25280, 1010, 189, 6, 36, "Output",
 CellID->31693045]
}, Open  ]],
Cell[25484, 1019, 125, 3, 70, "ExampleDelimiter",
 CellID->418852255],
Cell[25612, 1024, 195, 7, 70, "ExampleText",
 CellID->113503104],
Cell[CellGroupData[{
Cell[25832, 1035, 328, 10, 70, "Input",
 CellID->903576251],
Cell[26163, 1047, 292, 9, 36, "Output",
 CellID->533109349]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26504, 1062, 218, 7, 70, "ExampleSection",
 CellID->15896],
Cell[CellGroupData[{
Cell[26747, 1073, 221, 7, 70, "ExampleSubsection",
 CellID->3210],
Cell[26971, 1082, 79, 1, 70, "ExampleText",
 CellID->17776],
Cell[CellGroupData[{
Cell[27075, 1087, 284, 9, 70, "Input",
 CellID->5692],
Cell[27362, 1098, 241, 8, 36, "Output",
 CellID->261921893]
}, Open  ]],
Cell[CellGroupData[{
Cell[27640, 1111, 243, 8, 70, "Input",
 CellID->15290],
Cell[27886, 1121, 241, 8, 36, "Output",
 CellID->170134205]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28188, 1136, 223, 7, 70, "ExampleSection",
 CellID->13852],
Cell[28414, 1145, 100, 2, 70, "ExampleText",
 CellID->17350],
Cell[CellGroupData[{
Cell[28539, 1151, 123, 4, 70, "Input",
 CellID->8315],
Cell[28665, 1157, 661, 23, 36, "Output",
 CellID->240931907]
}, Open  ]],
Cell[CellGroupData[{
Cell[29363, 1185, 156, 5, 70, "Input",
 CellID->29361],
Cell[29522, 1192, 761, 17, 70, "Output",
 Evaluatable->False,
 CellID->413123549]
}, Open  ]],
Cell[30298, 1212, 120, 3, 70, "ExampleDelimiter",
 CellID->9984],
Cell[30421, 1217, 89, 1, 70, "ExampleText",
 CellID->8729],
Cell[CellGroupData[{
Cell[30535, 1222, 340, 13, 70, "Input",
 CellID->2534],
Cell[30878, 1237, 424, 13, 36, "Output",
 CellID->182599097]
}, Open  ]],
Cell[31317, 1253, 125, 3, 70, "ExampleDelimiter",
 CellID->453406583],
Cell[31445, 1258, 138, 4, 70, "ExampleText",
 CellID->358798615],
Cell[31586, 1264, 160, 5, 70, "Input",
 CellID->1437853734],
Cell[CellGroupData[{
Cell[31771, 1273, 159, 5, 70, "Input",
 CellID->2116411461],
Cell[31933, 1280, 190, 6, 36, "Output",
 CellID->295213297]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32172, 1292, 233, 7, 70, "ExampleSection",
 CellID->28082],
Cell[32408, 1301, 76, 1, 70, "ExampleText",
 CellID->1937044645],
Cell[CellGroupData[{
Cell[32509, 1306, 531, 19, 70, "Input",
 CellID->1474531211],
Cell[CellGroupData[{
Cell[33065, 1329, 112, 3, 70, "Print",
 CellID->65595182],
Cell[33180, 1334, 160, 5, 70, "Print",
 CellID->905009221],
Cell[33343, 1341, 210, 7, 70, "Print",
 CellID->50358876]
}, Open  ]]
}, Open  ]],
Cell[33580, 1352, 126, 3, 70, "ExampleDelimiter",
 CellID->1874508941],
Cell[33709, 1357, 333, 12, 70, "ExampleText",
 CellID->16806],
Cell[CellGroupData[{
Cell[34067, 1373, 163, 5, 70, "Input",
 CellID->1936],
Cell[34233, 1380, 199, 6, 36, "Output",
 CellID->70176294]
}, Open  ]],
Cell[CellGroupData[{
Cell[34469, 1391, 159, 5, 70, "Input",
 CellID->10790],
Cell[34631, 1398, 200, 6, 36, "Output",
 CellID->425697744]
}, Open  ]],
Cell[34846, 1407, 124, 3, 70, "ExampleDelimiter",
 CellID->50319268],
Cell[34973, 1412, 276, 10, 70, "ExampleText",
 CellID->1737293725],
Cell[CellGroupData[{
Cell[35274, 1426, 164, 5, 70, "Input",
 CellID->1053458311],
Cell[35441, 1433, 159, 5, 36, "Output",
 CellID->282613735]
}, Open  ]],
Cell[CellGroupData[{
Cell[35637, 1443, 192, 6, 70, "Input",
 CellID->1709343232],
Cell[35832, 1451, 159, 5, 36, "Output",
 CellID->442599443]
}, Open  ]],
Cell[36006, 1459, 125, 3, 70, "ExampleDelimiter",
 CellID->223023250],
Cell[36134, 1464, 85, 1, 70, "ExampleText",
 CellID->449587393],
Cell[CellGroupData[{
Cell[36244, 1469, 314, 11, 70, "Input",
 CellID->1864629346],
Cell[36561, 1482, 311, 11, 36, "Output",
 CellID->30925480]
}, Open  ]],
Cell[CellGroupData[{
Cell[36909, 1498, 319, 12, 70, "Input",
 CellID->1058763651],
Cell[37231, 1512, 311, 11, 36, "Output",
 CellID->22079716]
}, Open  ]],
Cell[CellGroupData[{
Cell[37579, 1528, 244, 9, 70, "Input",
 CellID->1928556858],
Cell[37826, 1539, 311, 11, 36, "Output",
 CellID->46199832]
}, Open  ]],
Cell[38152, 1553, 125, 3, 70, "ExampleDelimiter",
 CellID->451313710],
Cell[38280, 1558, 118, 3, 70, "ExampleText",
 CellID->1576886905],
Cell[CellGroupData[{
Cell[38423, 1565, 150, 5, 70, "Input",
 CellID->1603636697],
Cell[38576, 1572, 241, 8, 36, "Output",
 CellID->98336800]
}, Open  ]],
Cell[38832, 1583, 104, 2, 70, "ExampleText",
 CellID->1095458339],
Cell[CellGroupData[{
Cell[38961, 1589, 151, 5, 70, "Input",
 CellID->1416033256],
Cell[39115, 1596, 217, 7, 36, "Output",
 CellID->70926405]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39381, 1609, 229, 7, 70, "ExampleSection",
 CellID->27623603],
Cell[39613, 1618, 131, 4, 70, "ExampleText",
 CellID->408297524],
Cell[CellGroupData[{
Cell[39769, 1626, 123, 4, 70, "Input",
 CellID->97168050],
Cell[39895, 1632, 158, 5, 36, "Output",
 CellID->432547416]
}, Open  ]],
Cell[CellGroupData[{
Cell[40090, 1642, 251, 8, 70, "Input",
 CellID->1234043840],
Cell[40344, 1652, 225, 7, 36, "Output",
 CellID->18659314]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40630, 1666, 311, 9, 70, "SeeAlsoSection",
 CellID->22974],
Cell[40944, 1677, 1891, 71, 70, "SeeAlso",
 CellID->19252]
}, Open  ]],
Cell[CellGroupData[{
Cell[42872, 1753, 313, 9, 70, "TutorialsSection",
 CellID->3241],
Cell[43188, 1764, 207, 5, 70, "Tutorials",
 CellID->5745]
}, Open  ]],
Cell[CellGroupData[{
Cell[43432, 1774, 319, 9, 70, "MoreAboutSection",
 CellID->684637922],
Cell[43754, 1785, 144, 3, 70, "MoreAbout",
 CellID->10052820],
Cell[43901, 1790, 155, 3, 70, "MoreAbout",
 CellID->378794534],
Cell[44059, 1795, 144, 3, 70, "MoreAbout",
 CellID->19857540]
}, Open  ]],
Cell[44218, 1801, 50, 0, 70, "History"],
Cell[44271, 1803, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

