(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55956,       1816]
NotebookOptionsPosition[     46528,       1484]
NotebookOutlinePosition[     47913,       1524]
CellTagsIndexPosition[     47827,       1519]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cot" :> Documentation`HelpLookup["paclet:ref/Cot"], "ArcTan" :> 
          Documentation`HelpLookup["paclet:ref/ArcTan"], "ArcCoth" :> 
          Documentation`HelpLookup["paclet:ref/ArcCoth"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cot\"\>", 2->"\<\"ArcTan\"\>", 
       3->"\<\"ArcCoth\"\>", 4->"\<\"Degree\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcCot", "ObjectName",
 CellID->1360],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcCot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcCot"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arc cotangent ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["cot", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2814]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["All results are given in radians. ", "Notes",
 CellID->18012],

Cell[TextData[{
 "For real ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", the results are always in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ", excluding ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->19752],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcCot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCot"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "i"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "i"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->3338]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->435662835],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->25182991],

Cell["Results are in radians:", "ExampleText",
 CellID->250710325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428486734],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560872980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123082177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCot", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137176944],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtOwzAMzZaWy7jvDgg2JEBDQuIJxCsv8MRHTBMSPCAQ8H/7tNA0KStn
7px0HddN2lLbx47tXOpkt/23+7vH/tvDoN+9eek/3z8MXrvXTy8RS5aEKPWE
EJ22iJ5V9BR/9eck+ppH81SOfsti1NaiVkbtJvAPJvCFTKwrsQHyjtWrAv8U
6EbsjdS/wcia8UeEHxzDFCvQa3lMbwEQ7Zx2QkDsAO1vYXdqC8djiGbcBDaX
bcAvAZ3gkI+eZektMjlZdtTD/lz1ji2/9Suj1n4GxNzLwu9b/kJKrtt1Ra+Y
hpWj/XEk5Zl00sTVxeWCtxCPJbs+eTv7RFYnR72qqH2wCSjUkoBHeQvoCqPP
ZZTrH/WbZD59vdjzxJtc7pB945zY9MzYhlOE2IubFtcX5gHlJm69k0jCGhVp
4Ohr6IBrKXrd5ouix3h/yFjh5EdzLz+jUnRjSq/XPO1h/3o9axIrjr8RXRzV
2NoPnGKNqzI5HA6F+ej1G9MWpeXhx46YjcPMSgYvAV+ZUT/lb+pnxfYTMnr4
pskbj9sc8LX+/9bDPFZ336d919Tnvn+L73qOFfc2/BkVid7Z9HBUFV1bBpaP
542sWjTBU+ePPHisnbPwGG0WzkSNI1gHGr1EK9RJ2UefvI0qUB+zxulj9jj8
PItfl0X0AvFUJaTP4r52kMY9uTpje3ha5ewlcW4r+sYltHyNq0RtaSbZRvnW
lFlK1/f6zVj7YVlHugM01llYGc9mFIqeq0WPatGjkNwN478txWSfuon2GQ3M
FmePoqkdzNcO5xdmy8Wv9NrMl/0kuuRevqZS9/cp61WQ44lnkjytX8+Qd4l+
s72+Au65MrXwhW0vrbUzNdp1k9Yomf8XRekdGz5KIg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{296, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153230223]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->393984745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcCot", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->844442752],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15085665]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8421],

Cell["Evaluate numerically:", "ExampleText",
 CellID->232677270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", "2.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128608674],

Cell[BoxData["0.3805063771123649`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549510194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231006955],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->507311309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", 
  RowBox[{"1.5", "+", 
   RowBox[{"0.3", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205379023],

Cell[BoxData[
 RowBox[{"0.5753589292128496`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.09080570072746583`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132495300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199690185],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->84559065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcCot", "[", 
    RowBox[{"2", "/", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97427775],

Cell[BoxData["0.\
9827937232473290679857106110146660144968774536316285567614253098485`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36356128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->321979404],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->3366741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", "0.66666666666666666666666666666666666666666667", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8853262],

Cell[BoxData["0.9827937232473290679857106110146660144968774513239362490766`44.\
15216321700059"], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101187050]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->888142906],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->21512378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", 
  SqrtBox["3"], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97680866],

Cell[BoxData[
 FractionBox["\[Pi]", "6"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->573350884]
}, Open  ]],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->87059713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCot", "[", 
    RowBox[{"-", "x"}], "]"}], ",", 
   RowBox[{"ArcCot", "[", 
    RowBox[{"I", " ", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34409777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"ArcCot", "[", "x", "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{"ArcCoth", "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->988087236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89768520],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->339553716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", 
  RowBox[{"{", 
   RowBox[{"0.5", ",", "1.5", ",", "2.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32413303],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.1071487177940904`", ",", "0.5880026035475675`", ",", 
   "0.3805063771123649`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126425841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->526397206],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->959288426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCot", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3101689],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["cot", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{44, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->87264338]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14145],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->104876922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159159392],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487701533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287937181],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->68190708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cot", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "10"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1294035],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "-", 
   FractionBox["x", "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "45"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "945"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "4725"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], "93555"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, -1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 3], 0, 
    Rational[-1, 45], 0, 
    Rational[-2, 945], 0, 
    Rational[-1, 4725], 0, 
    Rational[-2, 93555]}, -1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{259, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385759209]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269126107],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "12"],
    SeriesData[$CellContext`x, 0, {}, 1, 12, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1}, 1, 12, 1],
  Editable->False]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132267926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366756755],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 " can deal with real-valued intervals:"
}], "ExampleText",
 CellID->97758880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCot", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SqrtBox["3"]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20487026],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["\[Pi]", "6"], ",", 
    FractionBox["\[Pi]", "4"]}], "}"}], "]"}]], "Output",
 ImageSize->{124, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442108]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1969],

Cell[TextData[{
 "Find angles of the right triangle with sides ",
 Cell[BoxData["3"], "InlineFormula"],
 ", ",
 Cell[BoxData["4"], "InlineFormula"],
 " and hypotenuse ",
 Cell[BoxData["5"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->240083676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"4", "/", "3"}], "]"}], ",", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"3", "/", "4"}], "]"}]}], "}"}], "/", "Degree"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314912519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"36.86989764584402`", ",", "53.13010235415598`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5039077]
}, Open  ]],

Cell[TextData[{
 "They total to ",
 Cell[BoxData[
  SuperscriptBox["90", "\[Degree]"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->257310361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->645679116],

Cell[BoxData["90.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69990431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->732296731],

Cell["Addition theorem for cotangent function:", "ExampleText",
 CellID->183417949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cot", "[", 
    RowBox[{
     RowBox[{"ArcCot", "[", "x", "]"}], "+", 
     RowBox[{"ArcCot", "[", "y", "]"}]}], "]"}], "//", "TrigExpand"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87639809],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"x", " ", "y"}]}], 
  RowBox[{"x", "+", "y"}]]], "Output",
 ImageSize->{53, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12736365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7791063],

Cell["Solve a differential equation:", "ExampleText",
 CellID->353107707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}], ")"}], " ", 
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{"ArcCot", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270483439],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox["\[Pi]", "2"]}], "+", 
       RowBox[{"6", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", "x", "]"}], "2"]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"ArcTan", "[", "x", "]"}]}], "+", 
       RowBox[{"6", " ", "\[Pi]", " ", 
        RowBox[{"Log", "[", "2", "]"}]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"ArcCot", "[", "x", "]"}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            RowBox[{"ArcCot", "[", "x", "]"}]}]]}], "]"}]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"ArcCot", "[", "x", "]"}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}], "]"}]}], "+", 
       RowBox[{"6", " ", "\[ImaginaryI]", " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            RowBox[{"ArcCot", "[", "x", "]"}]}]]}], "]"}]}]}], ")"}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{569, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66328854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->910005128],

Cell[TextData[{
 "Branch-cut of ",
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 " runs along the imaginary axis:"
}], "ExampleText",
 CellID->286484814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5918093],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114872531]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21839],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express ",
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->205968855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"ArcCot", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16938],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     FractionBox["\[ImaginaryI]", "z"]}], "]"}]}]}]], "Output",
 ImageSize->{201, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140714519]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpToTrig", "[", "%", "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->986050146],

Cell[BoxData[
 RowBox[{"ArcCot", "[", "z", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15747836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20920],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions with ",
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->106708612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"16", " ", 
    RowBox[{"ArcCot", "[", "5", "]"}]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{"ArcCot", "[", "239", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18366],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->240234774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112398708],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve inequalities involving ",
 Cell[BoxData[
  ButtonBox["ArcCot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8823338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCot", "[", "x", "]"}], ">", 
    RowBox[{"Pi", "/", "3"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232768942],

Cell[BoxData[
 RowBox[{"0", "\[LessEqual]", "x", "<", 
  FractionBox["1", 
   SqrtBox["3"]]}]], "Output",
 ImageSize->{74, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134493677]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23179],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCoth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCoth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8706],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->12525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->30630],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseCotangent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcCot/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->215450274],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->644398640]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcCot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 32.9244778}", "context" -> "System`", 
    "keywords" -> {
     "acot", "arccotangent", "arcctg", "arcus cotangens", 
      "inverse cotangent"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcCot[z] gives the arc cotangent cot -1 (z) of the complex number z. ", 
    "synonyms" -> {
     "acot", "acotan", "arc cot", "arccot", "arccotangent", "arccotg", 
      "arcctg", "arctan", "invcot"}, "title" -> "ArcCot", "type" -> "Symbol", 
    "uri" -> "ref/ArcCot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6086, 212, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->435662835]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47684, 1512}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2269, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2892, 80, 43, 1, 70, "ObjectName",
 CellID->1360],
Cell[2938, 83, 745, 25, 70, "Usage",
 CellID->2814]
}, Open  ]],
Cell[CellGroupData[{
Cell[3720, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4198, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4321, 136, 67, 1, 70, "Notes",
 CellID->18012],
Cell[4391, 139, 465, 18, 70, "Notes",
 CellID->19752],
Cell[4859, 159, 239, 8, 70, "Notes",
 CellID->9487],
Cell[5101, 169, 214, 7, 70, "Notes",
 CellID->31226],
Cell[5318, 178, 197, 7, 70, "Notes",
 CellID->28162],
Cell[5518, 187, 531, 20, 70, "Notes",
 CellID->3338]
}, Closed]],
Cell[CellGroupData[{
Cell[6086, 212, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->435662835],
Cell[CellGroupData[{
Cell[6471, 226, 147, 5, 70, "ExampleSection",
 CellID->25182991],
Cell[6621, 233, 66, 1, 70, "ExampleText",
 CellID->250710325],
Cell[CellGroupData[{
Cell[6712, 238, 102, 3, 28, "Input",
 CellID->428486734],
Cell[6817, 243, 182, 6, 49, "Output",
 CellID->560872980]
}, Open  ]],
Cell[7014, 252, 125, 3, 70, "ExampleDelimiter",
 CellID->123082177],
Cell[CellGroupData[{
Cell[7164, 259, 226, 7, 28, "Input",
 CellID->137176944],
Cell[7393, 268, 1110, 22, 52, "Output",
 Evaluatable->False,
 CellID->153230223]
}, Open  ]],
Cell[8518, 293, 125, 3, 70, "ExampleDelimiter",
 CellID->393984745],
Cell[CellGroupData[{
Cell[8668, 300, 237, 8, 28, "Input",
 CellID->844442752],
Cell[8908, 310, 2342, 42, 135, "Output",
 Evaluatable->False,
 CellID->15085665]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11299, 358, 215, 7, 70, "ExampleSection",
 CellID->8421],
Cell[11517, 367, 64, 1, 70, "ExampleText",
 CellID->232677270],
Cell[CellGroupData[{
Cell[11606, 372, 104, 3, 70, "Input",
 CellID->128608674],
Cell[11713, 377, 176, 5, 36, "Output",
 CellID->549510194]
}, Open  ]],
Cell[11904, 385, 125, 3, 70, "ExampleDelimiter",
 CellID->231006955],
Cell[12032, 390, 74, 1, 70, "ExampleText",
 CellID->507311309],
Cell[CellGroupData[{
Cell[12131, 395, 148, 5, 70, "Input",
 CellID->205379023],
Cell[12282, 402, 274, 7, 36, "Output",
 CellID->132495300]
}, Open  ]],
Cell[12571, 412, 125, 3, 70, "ExampleDelimiter",
 CellID->199690185],
Cell[12699, 417, 69, 1, 70, "ExampleText",
 CellID->84559065],
Cell[CellGroupData[{
Cell[12793, 422, 179, 6, 70, "Input",
 CellID->97427775],
Cell[12975, 430, 234, 7, 36, "Output",
 CellID->36356128]
}, Open  ]],
Cell[13224, 440, 125, 3, 70, "ExampleDelimiter",
 CellID->321979404],
Cell[13352, 445, 111, 3, 70, "ExampleText",
 CellID->3366741],
Cell[CellGroupData[{
Cell[13488, 452, 148, 4, 70, "Input",
 CellID->8853262],
Cell[13639, 458, 238, 6, 36, "Output",
 CellID->101187050]
}, Open  ]],
Cell[13892, 467, 125, 3, 70, "ExampleDelimiter",
 CellID->888142906],
Cell[14020, 472, 90, 1, 70, "ExampleText",
 CellID->21512378],
Cell[CellGroupData[{
Cell[14135, 477, 113, 4, 70, "Input",
 CellID->97680866],
Cell[14251, 483, 182, 6, 49, "Output",
 CellID->573350884]
}, Open  ]],
Cell[14448, 492, 89, 1, 70, "ExampleText",
 CellID->87059713],
Cell[CellGroupData[{
Cell[14562, 497, 227, 8, 70, "Input",
 CellID->34409777],
Cell[14792, 507, 350, 12, 36, "Output",
 CellID->988087236]
}, Open  ]],
Cell[15157, 522, 124, 3, 70, "ExampleDelimiter",
 CellID->89768520],
Cell[15284, 527, 214, 7, 70, "ExampleText",
 CellID->339553716],
Cell[CellGroupData[{
Cell[15523, 538, 164, 5, 70, "Input",
 CellID->32413303],
Cell[15690, 545, 275, 9, 36, "Output",
 CellID->126425841]
}, Open  ]],
Cell[15980, 557, 125, 3, 70, "ExampleDelimiter",
 CellID->526397206],
Cell[16108, 562, 203, 7, 70, "ExampleText",
 CellID->959288426],
Cell[CellGroupData[{
Cell[16336, 573, 138, 4, 70, "Input",
 CellID->3101689],
Cell[16477, 579, 277, 9, 52, "Output",
 CellID->87264338]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16803, 594, 239, 7, 70, "ExampleSection",
 CellID->14145],
Cell[17045, 603, 84, 1, 70, "ExampleText",
 CellID->104876922],
Cell[CellGroupData[{
Cell[17154, 608, 116, 3, 70, "Input",
 CellID->159159392],
Cell[17273, 613, 158, 5, 36, "Output",
 CellID->487701533]
}, Open  ]],
Cell[17446, 621, 125, 3, 70, "ExampleDelimiter",
 CellID->287937181],
Cell[17574, 626, 206, 7, 70, "ExampleText",
 CellID->68190708],
Cell[CellGroupData[{
Cell[17805, 637, 173, 6, 70, "Input",
 CellID->1294035],
Cell[17981, 645, 906, 31, 54, "Output",
 CellID->385759209]
}, Open  ]],
Cell[CellGroupData[{
Cell[18924, 681, 102, 3, 70, "Input",
 CellID->269126107],
Cell[19029, 686, 420, 14, 36, "Output",
 CellID->132267926]
}, Open  ]],
Cell[19464, 703, 125, 3, 70, "ExampleDelimiter",
 CellID->366756755],
Cell[19592, 708, 209, 7, 70, "ExampleText",
 CellID->97758880],
Cell[CellGroupData[{
Cell[19826, 719, 200, 7, 70, "Input",
 CellID->20487026],
Cell[20029, 728, 291, 10, 49, "Output",
 CellID->442108]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20369, 744, 222, 7, 70, "ExampleSection",
 CellID->1969],
Cell[20594, 753, 251, 9, 70, "ExampleText",
 CellID->240083676],
Cell[CellGroupData[{
Cell[20870, 766, 303, 11, 70, "Input",
 CellID->314912519],
Cell[21176, 779, 238, 8, 36, "Output",
 CellID->5039077]
}, Open  ]],
Cell[21429, 790, 149, 6, 70, "ExampleText",
 CellID->257310361],
Cell[CellGroupData[{
Cell[21603, 800, 101, 3, 70, "Input",
 CellID->645679116],
Cell[21707, 805, 160, 5, 36, "Output",
 CellID->69990431]
}, Open  ]],
Cell[21882, 813, 125, 3, 70, "ExampleDelimiter",
 CellID->732296731],
Cell[22010, 818, 83, 1, 70, "ExampleText",
 CellID->183417949],
Cell[CellGroupData[{
Cell[22118, 823, 263, 9, 70, "Input",
 CellID->87639809],
Cell[22384, 834, 266, 10, 53, "Output",
 CellID->12736365]
}, Open  ]],
Cell[22665, 847, 123, 3, 70, "ExampleDelimiter",
 CellID->7791063],
Cell[22791, 852, 73, 1, 70, "ExampleText",
 CellID->353107707],
Cell[CellGroupData[{
Cell[22889, 857, 749, 24, 70, "Input",
 CellID->270483439],
Cell[23641, 883, 1507, 42, 95, "Output",
 CellID->66328854]
}, Open  ]],
Cell[25163, 928, 125, 3, 70, "ExampleDelimiter",
 CellID->910005128],
Cell[25291, 933, 223, 8, 70, "ExampleText",
 CellID->286484814],
Cell[CellGroupData[{
Cell[25539, 945, 415, 14, 70, "Input",
 CellID->5918093],
Cell[25957, 961, 13279, 222, 70, "Output",
 Evaluatable->False,
 CellID->114872531]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39285, 1189, 233, 7, 70, "ExampleSection",
 CellID->21839],
Cell[39521, 1198, 442, 18, 70, "ExampleText",
 CellID->205968855],
Cell[CellGroupData[{
Cell[39988, 1220, 134, 4, 70, "Input",
 CellID->16938],
Cell[40125, 1226, 499, 16, 51, "Output",
 CellID->140714519]
}, Open  ]],
Cell[CellGroupData[{
Cell[40661, 1247, 140, 4, 70, "Input",
 CellID->986050146],
Cell[40804, 1253, 189, 6, 36, "Output",
 CellID->15747836]
}, Open  ]],
Cell[41008, 1262, 121, 3, 70, "ExampleDelimiter",
 CellID->20920],
Cell[41132, 1267, 345, 13, 70, "ExampleText",
 CellID->106708612],
Cell[CellGroupData[{
Cell[41502, 1284, 248, 8, 70, "Input",
 CellID->18366],
Cell[41753, 1294, 162, 5, 36, "Output",
 CellID->240234774]
}, Open  ]],
Cell[41930, 1302, 125, 3, 70, "ExampleDelimiter",
 CellID->112398708],
Cell[42058, 1307, 334, 13, 70, "ExampleText",
 CellID->8823338],
Cell[CellGroupData[{
Cell[42417, 1324, 210, 7, 70, "Input",
 CellID->232768942],
Cell[42630, 1333, 235, 8, 55, "Output",
 CellID->134493677]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42926, 1348, 311, 9, 70, "SeeAlsoSection",
 CellID->23179],
Cell[43240, 1359, 1416, 53, 70, "SeeAlso",
 CellID->5447]
}, Open  ]],
Cell[CellGroupData[{
Cell[44693, 1417, 313, 9, 70, "TutorialsSection",
 CellID->8706],
Cell[45009, 1428, 182, 4, 70, "Tutorials",
 CellID->12525]
}, Open  ]],
Cell[CellGroupData[{
Cell[45228, 1437, 321, 9, 70, "RelatedLinksSection",
 CellID->30630],
Cell[45552, 1448, 187, 4, 70, "RelatedLinks"],
Cell[45742, 1454, 198, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45977, 1463, 319, 9, 70, "MoreAboutSection",
 CellID->215450274],
Cell[46299, 1474, 157, 3, 70, "MoreAbout",
 CellID->644398640]
}, Open  ]],
Cell[46471, 1480, 27, 0, 70, "History"],
Cell[46501, 1482, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

