(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     70218,       2220]
NotebookOptionsPosition[     59714,       1847]
NotebookOutlinePosition[     61105,       1887]
CellTagsIndexPosition[     61019,       1882]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Csc" :> Documentation`HelpLookup["paclet:ref/Csc"], "ArcSec" :> 
          Documentation`HelpLookup["paclet:ref/ArcSec"], "ArcCsch" :> 
          Documentation`HelpLookup["paclet:ref/ArcCsch"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Csc\"\>", 2->"\<\"ArcSec\"\>", 
       3->"\<\"ArcCsch\"\>", 4->"\<\"Degree\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcCsc", "ObjectName",
 CellID->5865],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcCsc",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcCsc"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arc cosecant ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["csc", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25686]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["All results are given in radians. ", "Notes",
 CellID->259],

Cell[TextData[{
 "For real ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " outside the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", the results are always in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ", excluding ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->22313],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcCsc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCsc"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->2435]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89657682],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->108076414],

Cell["Results are in radians:", "ExampleText",
 CellID->372251549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43031184],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->864553662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194902031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcCsc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74810407],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300474356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36830441],

Cell["Series expansion:", "ExampleText",
 CellID->355435412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCsc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186533823],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "-", 
   RowBox[{
    SqrtBox["2"], " ", 
    SqrtBox[
     RowBox[{"x", "-", "1"}]]}], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], 
    RowBox[{"6", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"43", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"5", "/", "2"}]]}], 
    RowBox[{"80", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"177", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"7", "/", "2"}]]}], 
    RowBox[{"448", " ", 
     SqrtBox["2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], 
     RowBox[{"9", "/", "2"}]],
    SeriesData[$CellContext`x, 1, {}, 0, 9, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   Rational[1, 2] Pi, -2^Rational[1, 2], 0, Rational[5, 6] 2^Rational[-1, 2], 
    0, Rational[-43, 80] 2^Rational[-1, 2], 0, Rational[177, 448] 
    2^Rational[-1, 2]}, 0, 9, 2],
  Editable->False]], "Output",
 ImageSize->{445, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55982090]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30843],

Cell["Evaluate numerically:", "ExampleText",
 CellID->167291019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", "3.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5074726],

Cell[BoxData["0.28975170143604745`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74631187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260293824],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->5459904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", 
  RowBox[{"0.5", "+", 
   RowBox[{"2.3", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2611997],

Cell[BoxData[
 RowBox[{"0.08340852248840484`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.4054135307241786`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266927431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3922382],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->878622293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcCsc", "[", "5", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328809851],

Cell[BoxData["0.\
2013579207903307914551255522176234102400380814022283862572512456557`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149005868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8135257],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->437032725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", "5.00000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->818603725],

Cell[BoxData["0.2013579207903307914551255522176234102400380814022283862521`41.\
693044343256815"], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399456941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->521595534],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->542428298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", 
  FractionBox[
   RowBox[{"2", 
    SqrtBox["3"]}], "3"], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39026668],

Cell[BoxData[
 FractionBox["\[Pi]", "3"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134669856]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->214329760],

Cell["Parity transformations are automatically applied:", "ExampleText",
 CellID->343430862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222883681],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcCsc", "[", "x", "]"}]}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313624181]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->77778900],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"ArcCsch", "[", "x", "]"}]}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248165134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6068268],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->26329708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCsc", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12156846],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["csc", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{44, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->11586757]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31274],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->23855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27804],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ArcSin", "[", 
     FractionBox["1", "3"], "]"}], ",", 
    FractionBox["\[Pi]", "6"]}], "}"}], "]"}]], "Output",
 ImageSize->{179, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14537420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16909],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->19381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12779],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529205647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsc", "[", 
  RowBox[{"x", "+", 
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{
    RowBox[{"O", "[", 
     RowBox[{"x", ",", "Infinity"}], "]"}], "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10532],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWt1O2zAUdpuk/HRbS2GUboIWCSom7WJXE09Ar3iIqpoEFxOI8X59tOCT
nJbwxebEbpcUSKXGPvb5sb/jc+y4vZ4+3vz5O328nU1Hk4fp/c3t7N/o6u5B
NwUNpRpXSqnhkdL1WNeSL30m+ptW09qOfjZ1Z5PLc0f6VJeBLrvQPtRlpMsO
tP8Eei8ZRUTPYDHGOOlV4TOd5/i2kRIDekRLOmVSbWc9R2vSM85x9JIiBL6Q
vbFlGkdVfLn573paQdxscmNu3/8AGA2ALip3wu2tTH9zYTeHWRDj+msJs90c
idAQcbIk5owdZw0nBk+8lECfbCfNgcFSNtOincMN4+8DbcL+NXlEHlGS5I8d
+c2odwQU1t2Paxvj2KgvlzVwlaIUYoP9m4EF5bSgwGz6zCdh9TZmfS70n9Wz
LG2Wn4DGHOSq7zPQX1dEAcdHOY1IPDfW6FA1QSWXK/GMUwyrlJ7P5yr90Iae
0NzfBH7KTWTatIu9ZT1t1tMS5HBF+o63LDvF1oqr9jru7FjWOapqrKre0w/q
uX/IuVMMlXdqqXq2fidXWgnP+599tGXx4X0TvqPZ5GzvajZ+RMvGZ0YNuaTZ
Vs0voVrInngbIGlBzCX+94E93jdtryiPJ43/gzruEJhDTedhInsecsu7dAe5
kO3tecjl9sdXIqPo+HFVoJddx9WPzffqEbcbfwnz8lqWdvUe0t2S5bPjp4yE
p2Yfb2b17TPaeMfs6s0R0G2wE3h5D/lXjQVXeRp16BGDSGMMusaOtApWjcVi
3pO0SN7F2JPkMW+jFyT5LL1Y667yy8wt/gZdVFtvLdoQmyHQ+HacZs82jyH7
Lk7WB0L7Fy5NfDF7NuI4sfUv9k6TnZGlPV1330HbBdA/gB6ztUvW+pvpX0ZM
qJr+A0Q1ngA+dGd0\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->914002005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27842],

Cell["Find series expansions at branch points and branch cuts:", "ExampleText",
 CellID->8724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCsc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31149],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"Floor", "[", 
       FractionBox[
        RowBox[{"\[Pi]", "-", 
         RowBox[{"Arg", "[", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], "]"}], "+", 
         RowBox[{"Arg", "[", "x", "]"}], "-", 
         RowBox[{"2", " ", "\[Pi]", " ", 
          RowBox[{"Floor", "[", 
           RowBox[{
            FractionBox["1", "2"], "+", 
            FractionBox[
             RowBox[{"Arg", "[", "x", "]"}], 
             RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]}], 
        RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"x", "-", "1"}]]}]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           RowBox[{"x", "-", "1"}], "]"}], 
          RowBox[{"3", "/", "2"}]],
         SeriesData[$CellContext`x, 1, {}, 1, 3, 2],
         Editable->False]}],
       SeriesData[$CellContext`x, 1, {(-2) 2^Rational[1, 2]}, 1, 3, 2],
       Editable->False], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{493, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51312459]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCsc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13590],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{"Arg", "[", 
      RowBox[{"2", "+", 
       FractionBox["1", "x"]}], "]"}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"Floor", "[", 
     FractionBox[
      RowBox[{"Arg", "[", 
       RowBox[{"2", "+", 
        FractionBox["1", "x"]}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       RowBox[{"ArcCsc", "[", 
        FractionBox["1", "2"], "]"}]}], "+", 
      FractionBox[
       RowBox[{"4", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"x", "+", 
          FractionBox["1", "2"]}], ")"}]}], 
       SqrtBox["3"]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         RowBox[{"x", "+", 
          FractionBox["1", "2"]}], "]"}], "2"],
       SeriesData[$CellContext`x, 
        Rational[-1, 2], {}, 0, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      Rational[-1, 2], {-ArcCsc[
         Rational[1, 2]], Complex[0, 4] 3^Rational[-1, 2]}, 0, 2, 1],
     Editable->False], ")"}]}]}]], "Output",
 ImageSize->{499, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->480232103]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26099],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 " threads over explicit lists as well as over sparse arrays:"
}], "ExampleText",
 CellID->6161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "3"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     RowBox[{"-", "2"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "1"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11047],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273004376]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15290],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->197509496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29959],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", 
      RowBox[{"ArcSec", "[", "3", "]"}]},
     {"0", "0", "0"},
     {"0", "0", 
      FractionBox[
       RowBox[{"2", " ", "\[Pi]"}], "3"]},
     {"0", "\[Pi]", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{118, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->114003870]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10415],

Cell[TextData[{
 "Branch cut of ",
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 " runs along the real axis:"
}], "ExampleText",
 CellID->81690184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcCsc", "[", 
     RowBox[{"x", "-", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->491732723],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->550902357]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3644],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->109338042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCsc", "[", 
    RowBox[{"Csc", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Csc", "[", 
    RowBox[{"ArcCsc", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397577163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCsc", "[", 
    RowBox[{"Csc", "[", "z", "]"}], "]"}], ",", "z"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415286138]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the ",
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->177493682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156358924]
}, Open  ]],

Cell["Alternatively, evaluate under additional assumptions:", "ExampleText",
 CellID->409086740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"ArcCsc", "[", 
    RowBox[{"Csc", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"0", "<", "z", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->404146284],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->515153501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268743644],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express through logarithm:"
}], "ExampleText",
 CellID->147381088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCsc", "[", "z", "]"}], "//", "TrigToExp"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20026373],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["z", "2"]]}]], "+", 
    FractionBox["\[ImaginaryI]", "z"]}], "]"}]}]], "Output",
 ImageSize->{139, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445039612]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " to convert back:"
}], "ExampleText",
 CellID->415210615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300744173],

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  FractionBox["1", "z"], "]"}]], "Output",
 ImageSize->{72, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->421169815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37957409],

Cell["Integrals:", "ExampleText",
 CellID->41963669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "k"}], " ", 
    RowBox[{"ArcCsc", "[", "z", "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165822859],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["z", "k"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "k"}], ")"}], " ", "z", " ", 
      RowBox[{"ArcCsc", "[", "z", "]"}]}], "+", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["z", "2"]}]], " ", 
       RowBox[{"Hypergeometric2F1", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "+", "k"}], "2"], ",", 
         FractionBox["1", "2"], ",", 
         FractionBox[
          RowBox[{"3", "+", "k"}], "2"], ",", 
         SuperscriptBox["z", "2"]}], "]"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        FractionBox["1", 
         SuperscriptBox["z", "2"]]}]]]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "k"}], ")"}], "2"]]], "Output",
 ImageSize->{377, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->955707205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299368825],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to convert trigs of arctrigs into algebraic function:"
}], "ExampleText",
 CellID->693964864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{"5", 
    RowBox[{"ArcCsc", "[", "z", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79294649],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{299, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202292582]
}, Open  ]],

Cell["Simplify result:", "ExampleText",
 CellID->559293108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50403847],

Cell[BoxData[
 FractionBox[
  RowBox[{"16", "-", 
   RowBox[{"20", " ", 
    SuperscriptBox["z", "2"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["z", "4"]}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     FractionBox["1", 
      SuperscriptBox["z", "2"]]}]], " ", "z", " ", 
   RowBox[{"(", 
    RowBox[{"16", "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     SuperscriptBox["z", "4"]}], ")"}]}]]], "Output",
 ImageSize->{171, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->397304130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->823034384],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve equations involving ",
 Cell[BoxData[
  ButtonBox["ArcCsc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsc"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29135040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCsc", "[", "z", "]"}], "+", 
      RowBox[{"ArcCsc", "[", 
       RowBox[{"z", "+", "1"}], "]"}]}], "\[Equal]", 
     RowBox[{"Pi", "/", "2"}]}], ",", "z"}], "]"}], "//", "Quiet"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->53629881],

Cell[BoxData[
 RowBox[{"z", "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"5", "+", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}]]}], ")"}]}]}]], "Output",
 ImageSize->{156, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323270]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->456],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Csc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Csc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSec",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCsch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCsch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1028],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->4101]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->10468],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseCosecant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcCsc/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->66371429],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->191445272]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcCsc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 35.6745482}", "context" -> "System`", 
    "keywords" -> {
     "acsc", "arccosec", "arccosecant", "arcosec", "arcus cosecans", 
      "inverse cosecant"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcCsc[z] gives the arc cosecant csc -1 (z) of the complex number z. ", 
    "synonyms" -> {
     "acosecans", "acsc", "arc csc", "arccosec", "arccosecans", "arccosecant",
       "arccsc", "invcsc"}, "title" -> "ArcCsc", "type" -> "Symbol", "uri" -> 
    "ref/ArcCsc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6260, 219, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89657682]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60877, 1875}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2269, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2892, 80, 43, 1, 70, "ObjectName",
 CellID->5865],
Cell[2938, 83, 745, 25, 70, "Usage",
 CellID->25686]
}, Open  ]],
Cell[CellGroupData[{
Cell[3720, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4198, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4321, 136, 65, 1, 70, "Notes",
 CellID->259],
Cell[4389, 139, 641, 25, 70, "Notes",
 CellID->22313],
Cell[5033, 166, 239, 8, 70, "Notes",
 CellID->9487],
Cell[5275, 176, 214, 7, 70, "Notes",
 CellID->31226],
Cell[5492, 185, 197, 7, 70, "Notes",
 CellID->28162],
Cell[5692, 194, 531, 20, 70, "Notes",
 CellID->2435]
}, Closed]],
Cell[CellGroupData[{
Cell[6260, 219, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89657682],
Cell[CellGroupData[{
Cell[6644, 233, 148, 5, 70, "ExampleSection",
 CellID->108076414],
Cell[6795, 240, 66, 1, 70, "ExampleText",
 CellID->372251549],
Cell[CellGroupData[{
Cell[6886, 245, 101, 3, 28, "Input",
 CellID->43031184],
Cell[6990, 250, 182, 6, 49, "Output",
 CellID->864553662]
}, Open  ]],
Cell[7187, 259, 125, 3, 70, "ExampleDelimiter",
 CellID->194902031],
Cell[CellGroupData[{
Cell[7337, 266, 236, 8, 28, "Input",
 CellID->74810407],
Cell[7576, 276, 2270, 41, 139, "Output",
 Evaluatable->False,
 CellID->300474356]
}, Open  ]],
Cell[9861, 320, 124, 3, 70, "ExampleDelimiter",
 CellID->36830441],
Cell[9988, 325, 60, 1, 70, "ExampleText",
 CellID->355435412],
Cell[CellGroupData[{
Cell[10073, 330, 293, 9, 70, "Input",
 CellID->186533823],
Cell[10369, 341, 1375, 48, 58, "Output",
 CellID->55982090]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11793, 395, 216, 7, 70, "ExampleSection",
 CellID->30843],
Cell[12012, 404, 64, 1, 70, "ExampleText",
 CellID->167291019],
Cell[CellGroupData[{
Cell[12101, 409, 102, 3, 70, "Input",
 CellID->5074726],
Cell[12206, 414, 176, 5, 36, "Output",
 CellID->74631187]
}, Open  ]],
Cell[12397, 422, 125, 3, 70, "ExampleDelimiter",
 CellID->260293824],
Cell[12525, 427, 72, 1, 70, "ExampleText",
 CellID->5459904],
Cell[CellGroupData[{
Cell[12622, 432, 146, 5, 70, "Input",
 CellID->2611997],
Cell[12771, 439, 274, 7, 36, "Output",
 CellID->266927431]
}, Open  ]],
Cell[13060, 449, 123, 3, 70, "ExampleDelimiter",
 CellID->3922382],
Cell[13186, 454, 70, 1, 70, "ExampleText",
 CellID->878622293],
Cell[CellGroupData[{
Cell[13281, 459, 155, 5, 70, "Input",
 CellID->328809851],
Cell[13439, 466, 235, 7, 36, "Output",
 CellID->149005868]
}, Open  ]],
Cell[13689, 476, 123, 3, 70, "ExampleDelimiter",
 CellID->8135257],
Cell[13815, 481, 113, 3, 70, "ExampleText",
 CellID->437032725],
Cell[CellGroupData[{
Cell[13953, 488, 147, 4, 70, "Input",
 CellID->818603725],
Cell[14103, 494, 239, 6, 36, "Output",
 CellID->399456941]
}, Open  ]],
Cell[14357, 503, 125, 3, 70, "ExampleDelimiter",
 CellID->521595534],
Cell[14485, 508, 91, 1, 70, "ExampleText",
 CellID->542428298],
Cell[CellGroupData[{
Cell[14601, 513, 155, 6, 70, "Input",
 CellID->39026668],
Cell[14759, 521, 182, 6, 49, "Output",
 CellID->134669856]
}, Open  ]],
Cell[14956, 530, 125, 3, 70, "ExampleDelimiter",
 CellID->214329760],
Cell[15084, 535, 92, 1, 70, "ExampleText",
 CellID->343430862],
Cell[CellGroupData[{
Cell[15201, 540, 120, 4, 70, "Input",
 CellID->222883681],
Cell[15324, 546, 208, 7, 36, "Output",
 CellID->313624181]
}, Open  ]],
Cell[CellGroupData[{
Cell[15569, 558, 124, 4, 70, "Input",
 CellID->77778900],
Cell[15696, 564, 244, 8, 36, "Output",
 CellID->248165134]
}, Open  ]],
Cell[15955, 575, 123, 3, 70, "ExampleDelimiter",
 CellID->6068268],
Cell[16081, 580, 202, 7, 70, "ExampleText",
 CellID->26329708],
Cell[CellGroupData[{
Cell[16308, 591, 139, 4, 70, "Input",
 CellID->12156846],
Cell[16450, 597, 277, 9, 52, "Output",
 CellID->11586757]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16776, 612, 239, 7, 70, "ExampleSection",
 CellID->31274],
Cell[17018, 621, 214, 7, 70, "ExampleText",
 CellID->23855],
Cell[CellGroupData[{
Cell[17257, 632, 182, 6, 70, "Input",
 CellID->27804],
Cell[17442, 640, 325, 11, 51, "Output",
 CellID->14537420]
}, Open  ]],
Cell[17782, 654, 121, 3, 70, "ExampleDelimiter",
 CellID->16909],
Cell[17906, 659, 80, 1, 70, "ExampleText",
 CellID->19381],
Cell[CellGroupData[{
Cell[18011, 664, 112, 3, 70, "Input",
 CellID->12779],
Cell[18126, 669, 158, 5, 36, "Output",
 CellID->529205647]
}, Open  ]],
Cell[18299, 677, 121, 3, 70, "ExampleDelimiter",
 CellID->10083],
Cell[18423, 682, 199, 7, 70, "ExampleText",
 CellID->692],
Cell[CellGroupData[{
Cell[18647, 693, 242, 8, 70, "Input",
 CellID->10532],
Cell[18892, 703, 1143, 23, 70, "Output",
 Evaluatable->False,
 CellID->914002005]
}, Open  ]],
Cell[20050, 729, 121, 3, 70, "ExampleDelimiter",
 CellID->27842],
Cell[20174, 734, 94, 1, 70, "ExampleText",
 CellID->8724],
Cell[CellGroupData[{
Cell[20293, 739, 214, 7, 70, "Input",
 CellID->31149],
Cell[20510, 748, 1440, 45, 76, "Output",
 CellID->51312459]
}, Open  ]],
Cell[CellGroupData[{
Cell[21987, 798, 262, 9, 70, "Input",
 CellID->13590],
Cell[22252, 809, 1407, 47, 68, "Output",
 CellID->480232103]
}, Open  ]],
Cell[23674, 859, 121, 3, 70, "ExampleDelimiter",
 CellID->26099],
Cell[23798, 864, 227, 7, 70, "ExampleText",
 CellID->6161],
Cell[CellGroupData[{
Cell[24050, 875, 645, 23, 70, "Input",
 CellID->11047],
Cell[24698, 900, 489, 17, 36, "Output",
 CellID->273004376]
}, Open  ]],
Cell[CellGroupData[{
Cell[25224, 922, 98, 3, 70, "Input",
 CellID->15290],
Cell[25325, 927, 479, 17, 36, "Output",
 CellID->197509496]
}, Open  ]],
Cell[CellGroupData[{
Cell[25841, 949, 131, 4, 70, "Input",
 CellID->29959],
Cell[25975, 955, 878, 27, 102, "Output",
 CellID->114003870]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26902, 988, 223, 7, 70, "ExampleSection",
 CellID->10415],
Cell[27128, 997, 217, 8, 70, "ExampleText",
 CellID->81690184],
Cell[CellGroupData[{
Cell[27370, 1009, 413, 14, 70, "Input",
 CellID->491732723],
Cell[27786, 1025, 18228, 303, 70, "Output",
 Evaluatable->False,
 CellID->550902357]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46063, 1334, 232, 7, 70, "ExampleSection",
 CellID->3644],
Cell[46298, 1343, 74, 1, 70, "ExampleText",
 CellID->109338042],
Cell[CellGroupData[{
Cell[46397, 1348, 247, 8, 70, "Input",
 CellID->397577163],
Cell[46647, 1358, 270, 9, 36, "Output",
 CellID->415286138]
}, Open  ]],
Cell[46932, 1370, 350, 13, 70, "ExampleText",
 CellID->177493682],
Cell[CellGroupData[{
Cell[47307, 1387, 102, 3, 70, "Input",
 CellID->1064],
Cell[47412, 1392, 203, 7, 36, "Output",
 CellID->156358924]
}, Open  ]],
Cell[47630, 1402, 96, 1, 70, "ExampleText",
 CellID->409086740],
Cell[CellGroupData[{
Cell[47751, 1407, 251, 8, 70, "Input",
 CellID->404146284],
Cell[48005, 1417, 158, 5, 36, "Output",
 CellID->515153501]
}, Open  ]],
Cell[48178, 1425, 125, 3, 70, "ExampleDelimiter",
 CellID->268743644],
Cell[48306, 1430, 218, 8, 70, "ExampleText",
 CellID->147381088],
Cell[CellGroupData[{
Cell[48549, 1442, 133, 4, 70, "Input",
 CellID->20026373],
Cell[48685, 1448, 394, 14, 60, "Output",
 CellID->445039612]
}, Open  ]],
Cell[49094, 1465, 205, 8, 70, "ExampleText",
 CellID->415210615],
Cell[CellGroupData[{
Cell[49324, 1477, 105, 3, 70, "Input",
 CellID->300744173],
Cell[49432, 1482, 211, 7, 51, "Output",
 CellID->421169815]
}, Open  ]],
Cell[49658, 1492, 124, 3, 70, "ExampleDelimiter",
 CellID->37957409],
Cell[49785, 1497, 52, 1, 70, "ExampleText",
 CellID->41963669],
Cell[CellGroupData[{
Cell[49862, 1502, 212, 7, 70, "Input",
 CellID->165822859],
Cell[50077, 1511, 982, 34, 98, "Output",
 CellID->955707205]
}, Open  ]],
Cell[51074, 1548, 125, 3, 70, "ExampleDelimiter",
 CellID->299368825],
Cell[51202, 1553, 252, 8, 70, "ExampleText",
 CellID->693964864],
Cell[CellGroupData[{
Cell[51479, 1565, 193, 6, 70, "Input",
 CellID->79294649],
Cell[51675, 1573, 2363, 43, 70, "Output",
 Evaluatable->False,
 CellID->202292582]
}, Open  ]],
Cell[54053, 1619, 59, 1, 70, "ExampleText",
 CellID->559293108],
Cell[CellGroupData[{
Cell[54137, 1624, 103, 3, 70, "Input",
 CellID->50403847],
Cell[54243, 1629, 579, 21, 80, "Output",
 CellID->397304130]
}, Open  ]],
Cell[54837, 1653, 125, 3, 70, "ExampleDelimiter",
 CellID->823034384],
Cell[54965, 1658, 332, 13, 70, "ExampleText",
 CellID->29135040],
Cell[CellGroupData[{
Cell[55322, 1675, 342, 12, 70, "Input",
 CellID->53629881],
Cell[55667, 1689, 388, 15, 53, "Output",
 CellID->323270]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56116, 1711, 309, 9, 70, "SeeAlsoSection",
 CellID->456],
Cell[56428, 1722, 1417, 53, 70, "SeeAlso",
 CellID->14771]
}, Open  ]],
Cell[CellGroupData[{
Cell[57882, 1780, 313, 9, 70, "TutorialsSection",
 CellID->1028],
Cell[58198, 1791, 181, 4, 70, "Tutorials",
 CellID->4101]
}, Open  ]],
Cell[CellGroupData[{
Cell[58416, 1800, 321, 9, 70, "RelatedLinksSection",
 CellID->10468],
Cell[58740, 1811, 186, 4, 70, "RelatedLinks"],
Cell[58929, 1817, 198, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59164, 1826, 318, 9, 70, "MoreAboutSection",
 CellID->66371429],
Cell[59485, 1837, 157, 3, 70, "MoreAbout",
 CellID->191445272]
}, Open  ]],
Cell[59657, 1843, 27, 0, 70, "History"],
Cell[59687, 1845, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

