(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59900,       1799]
NotebookOptionsPosition[     50859,       1481]
NotebookOutlinePosition[     52241,       1521]
CellTagsIndexPosition[     52155,       1516]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tanh" :> Documentation`HelpLookup["paclet:ref/Tanh"], 
          "ArcCoth" :> Documentation`HelpLookup["paclet:ref/ArcCoth"], 
          "ArcTan" :> Documentation`HelpLookup["paclet:ref/ArcTan"], 
          "TrigToExp" :> Documentation`HelpLookup["paclet:ref/TrigToExp"], 
          "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tanh\"\>", 2->"\<\"ArcCoth\"\>", 
       3->"\<\"ArcTan\"\>", 4->"\<\"TrigToExp\"\>", 
       5->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Hyperbolic Functions\"\>", 
       3->"\<\"Inverse Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcTanh", "ObjectName",
 CellID->3576],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcTanh",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcTanh"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the hyperbolic arc tangent ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["tanh", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4854]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcTanh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTanh"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->11134]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3091265],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->32788124],

Cell["Evaluate numerically:", "ExampleText",
 CellID->105100970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->293810858],

Cell[BoxData["0.5493061443340549`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10259811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16850736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcTanh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402851884],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226647148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156765057],

Cell["Series expansion about the origin:", "ExampleText",
 CellID->647431814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcTanh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->703253],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWEtv1DAQ9sYJLaoA8dr3dre/oCdKWyS0Eqg99cIVLqsKqT0gUOn/258W
4sckk89O7GxAomqkXWfe83nGdpKrzf3N9x+b+9vrzerybvPr5vb69+ri513B
kgMhBl+FEEdjUdznxZ3+qetb8TO35m5a/EtRjTPFlaSdi4nlqzErxsSOQztK
Kx8BPbZ0Cv6GzI9if9BZKO8iK7U0z/hwuVPwOAd6DDRmgPKkOXZQa9IxVgb0
qfazAC4ixCiIeNQxiyeemrTJ0T+iQDnav98JpaLTHeb4X6OTNq8zjUqtl4St
H2839u6b1EZBO1ptOJchDP5uPvPWCW298t4IQ1WTQCPikH0bYv/u4+vHBq3e
6OP2oNAc9NnJzEzw0yBluzjxFS7Vh1le9SPRtOsTnTI6tX5GoH+uo6ocPlrJ
gR1f1CQ8/wOgn2lNZZNYW+wFPNNw3kL0CuhlRxrtCb1epSmvBEeBPWNwGqOS
WVx7/zlajcPpN0SX1OeCgLp1zqsaZ2Wtt9utMNdT9SfX6zWLnpXewnohf7Kn
3vPI/Jr0Qv5i43bNL66KMvevwHrt9kH6MDu2HeujX6eiqrdiHzd777gDqtt3
UbniSUHvHOYgNZe08YzSSV7tzPw08tXemRVNfPFJHM23gHQE9DggR3oO9CIg
R/o0KuuhU/uJw5lG6LicQ4ezjNBxORxHWWgHB80ePbvPgaZxZccjoGk8r8fn
vfLXYnx+IDP/Kff1NY2vgca6vArIX0b65St7v/ihHa58Tr8J6OKaCPnuqs9p
8zS+BA/8SV4I913T9+2mbVXjieJ9v9jj/V3FxlhdfZ9oP4cBBL4zMNkhOsrR
HrPrOnO1fdRbt0S4aLGefecUdoC82nmCWBuq7H6fUlzMY9Yij8bVkIHO3jnp
Fy0WsyAerAN945yxkb7p0G7E92x8GuB6Euw4TV9xTBbK1HyDFYM/10DyYw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{347, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51814434]
}, Open  ]],

Cell["Sum the series:", "ExampleText",
 CellID->364016490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", "n"}], "-", "1"}]], 
    RowBox[{
     RowBox[{"2", "n"}], "-", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->412904645],

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "x", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->839592491]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28366],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->40174808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116882886],

Cell[BoxData[
 RowBox[{"0.35133563902264625`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.4159448545236684`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523328395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223317723],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->88315731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcTanh", "[", 
    RowBox[{"1", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406380963],

Cell[BoxData["0.\
5493061443340548456976226184612628523237452789113751480222732250999`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->649072194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18455232],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->18659275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "0.50000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399269772],

Cell[BoxData["0.5493061443340548456976226184612628523237453296602665595152`40.\
614875720296645"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120718182]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245924666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->397001889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", 
  RowBox[{"{", 
   RowBox[{"0.1", ",", "0.2", ",", "0.3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216118936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.10033534773107558`", ",", "0.2027325540540822`", ",", 
   "0.30951960420311175`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21486875]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112109847],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->306540079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220994862],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216094242]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->404749289],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266961330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14152207],

Cell["Parity transformations are automatically applied:", "ExampleText",
 CellID->295677626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235359564],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcTanh", "[", "x", "]"}]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->547140394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->405471749],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"ArcTan", "[", "x", "]"}]}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->254839132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126267430],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->31444290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcTan", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181184912],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["tan", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{44, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->4166970]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2885],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->564284357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Tanh", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "10"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->855448809],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "15"], "-", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "7"]}], "315"], "+", 
   FractionBox[
    RowBox[{"62", " ", 
     SuperscriptBox["x", "9"]}], "2835"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 3], 0, 
    Rational[2, 15], 0, 
    Rational[-17, 315], 0, 
    Rational[62, 2835]}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{224, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548040139]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->244496156],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->432646727]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->467730006],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->41998822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "3"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523584972],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcTanh", "[", 
      FractionBox["1", "3"], "]"}]}], ",", 
    RowBox[{"ArcTanh", "[", 
     FractionBox["1", "2"], "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{256, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309733457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3426384],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->123689926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", 
  RowBox[{"{", 
   RowBox[{"Infinity", ",", 
    RowBox[{"I", " ", "Infinity"}], ",", 
    RowBox[{"-", "Infinity"}], ",", 
    RowBox[{
     RowBox[{"-", "I"}], " ", "Infinity"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101125233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]}], ",", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"], ",", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]}]}], "}"}]], "Output",
 ImageSize->{160, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274871093]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2718],

Cell["\<\
Find the rapidity corresponding to a speed of 0.999 of the speed of light:\
\>", "ExampleText",
 CellID->473802079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "0.999", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296190599],

Cell[BoxData["3.8002011672501994`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475039421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95346333],

Cell[TextData[{
 "Branch cuts of ",
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->169625854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108025290],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30606177]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9107],

Cell[TextData[{
 "Express ",
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->765776941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"ArcTanh", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408300678],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "z"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "z"}], "]"}]}]}]], "Output",
 ImageSize->{176, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289759745]
}, Open  ]],

Cell["Convert back:", "ExampleText",
 CellID->383796518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37471775],

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "z", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->746517018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101319019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"ArcTanh", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41484],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcTanh", "[", "x", "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{178, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126473129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->312599383],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTanh"]], "InlineFormula"],
 " is a special case of some special functions:"
}], "ExampleText",
 CellID->139566708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", "1", ",", 
    RowBox[{"3", "/", "2"}], ",", 
    RowBox[{"x", "^", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213173150],

Cell[BoxData[
 RowBox[{"ArcTanh", "[", "x", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128289259]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1852],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tanh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tanh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCoth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCoth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20747]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23016],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->25050]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->9193],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseHyperbolicTangent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcTanh/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->633120306],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->256539716],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->740722230],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->118813267]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcTanh - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 40.0340348}", "context" -> "System`", 
    "keywords" -> {
     "arcth", "artanh", "arth", "atanh", "inverse hyperbolic tangent", 
      "inverse tanh", "inverse th"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcTanh[z] gives the hyperbolic arc tangent tanh -1 (z) of the complex \
number z. ", 
    "synonyms" -> {
     "arc tanh", "arctanh", "arctgh", "areatanh", "atgh", "invtanh"}, "title" -> 
    "ArcTanh", "type" -> "Symbol", "uri" -> "ref/ArcTanh"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5977, 202, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3091265]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52014, 1509}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2471, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3094, 85, 44, 1, 70, "ObjectName",
 CellID->3576],
Cell[3141, 88, 757, 25, 70, "Usage",
 CellID->4854]
}, Open  ]],
Cell[CellGroupData[{
Cell[3935, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4413, 135, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4536, 141, 241, 8, 70, "Notes",
 CellID->9487],
Cell[4780, 151, 216, 7, 70, "Notes",
 CellID->31226],
Cell[4999, 160, 199, 7, 70, "Notes",
 CellID->28162],
Cell[5201, 169, 739, 28, 70, "Notes",
 CellID->11134]
}, Closed]],
Cell[CellGroupData[{
Cell[5977, 202, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3091265],
Cell[CellGroupData[{
Cell[6360, 216, 147, 5, 70, "ExampleSection",
 CellID->32788124],
Cell[6510, 223, 64, 1, 70, "ExampleText",
 CellID->105100970],
Cell[CellGroupData[{
Cell[6599, 228, 105, 3, 28, "Input",
 CellID->293810858],
Cell[6707, 233, 175, 5, 36, "Output",
 CellID->10259811]
}, Open  ]],
Cell[6897, 241, 124, 3, 70, "ExampleDelimiter",
 CellID->16850736],
Cell[CellGroupData[{
Cell[7046, 248, 238, 8, 28, "Input",
 CellID->402851884],
Cell[7287, 258, 2291, 42, 132, "Output",
 Evaluatable->False,
 CellID->226647148]
}, Open  ]],
Cell[9593, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->156765057],
Cell[9721, 308, 77, 1, 70, "ExampleText",
 CellID->647431814],
Cell[CellGroupData[{
Cell[9823, 313, 217, 7, 28, "Input",
 CellID->703253],
Cell[10043, 322, 1187, 24, 54, "Output",
 Evaluatable->False,
 CellID->51814434]
}, Open  ]],
Cell[11245, 349, 58, 1, 70, "ExampleText",
 CellID->364016490],
Cell[CellGroupData[{
Cell[11328, 354, 320, 12, 70, "Input",
 CellID->412904645],
Cell[11651, 368, 191, 6, 36, "Output",
 CellID->839592491]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11891, 380, 216, 7, 70, "ExampleSection",
 CellID->28366],
Cell[12110, 389, 73, 1, 70, "ExampleText",
 CellID->40174808],
Cell[CellGroupData[{
Cell[12208, 394, 128, 4, 70, "Input",
 CellID->116882886],
Cell[12339, 400, 274, 7, 36, "Output",
 CellID->523328395]
}, Open  ]],
Cell[12628, 410, 125, 3, 70, "ExampleDelimiter",
 CellID->223317723],
Cell[12756, 415, 69, 1, 70, "ExampleText",
 CellID->88315731],
Cell[CellGroupData[{
Cell[12850, 420, 181, 6, 70, "Input",
 CellID->406380963],
Cell[13034, 428, 235, 7, 36, "Output",
 CellID->649072194]
}, Open  ]],
Cell[13284, 438, 124, 3, 70, "ExampleDelimiter",
 CellID->18455232],
Cell[13411, 443, 112, 3, 70, "ExampleText",
 CellID->18659275],
Cell[CellGroupData[{
Cell[13548, 450, 148, 4, 70, "Input",
 CellID->399269772],
Cell[13699, 456, 239, 6, 36, "Output",
 CellID->120718182]
}, Open  ]],
Cell[13953, 465, 125, 3, 70, "ExampleDelimiter",
 CellID->245924666],
Cell[14081, 470, 208, 7, 70, "ExampleText",
 CellID->397001889],
Cell[CellGroupData[{
Cell[14314, 481, 166, 5, 70, "Input",
 CellID->216118936],
Cell[14483, 488, 276, 9, 36, "Output",
 CellID->21486875]
}, Open  ]],
Cell[14774, 500, 125, 3, 70, "ExampleDelimiter",
 CellID->112109847],
Cell[14902, 505, 91, 1, 70, "ExampleText",
 CellID->306540079],
Cell[CellGroupData[{
Cell[15018, 510, 103, 3, 70, "Input",
 CellID->220994862],
Cell[15124, 515, 158, 5, 36, "Output",
 CellID->216094242]
}, Open  ]],
Cell[CellGroupData[{
Cell[15319, 525, 103, 3, 70, "Input",
 CellID->404749289],
Cell[15425, 530, 168, 5, 36, "Output",
 CellID->266961330]
}, Open  ]],
Cell[15608, 538, 124, 3, 70, "ExampleDelimiter",
 CellID->14152207],
Cell[15735, 543, 92, 1, 70, "ExampleText",
 CellID->295677626],
Cell[CellGroupData[{
Cell[15852, 548, 121, 4, 70, "Input",
 CellID->235359564],
Cell[15976, 554, 209, 7, 36, "Output",
 CellID->547140394]
}, Open  ]],
Cell[CellGroupData[{
Cell[16222, 566, 126, 4, 70, "Input",
 CellID->405471749],
Cell[16351, 572, 225, 7, 36, "Output",
 CellID->254839132]
}, Open  ]],
Cell[16591, 582, 125, 3, 70, "ExampleDelimiter",
 CellID->126267430],
Cell[16719, 587, 202, 7, 70, "ExampleText",
 CellID->31444290],
Cell[CellGroupData[{
Cell[16946, 598, 140, 4, 70, "Input",
 CellID->181184912],
Cell[17089, 604, 276, 9, 52, "Output",
 CellID->4166970]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17414, 619, 238, 7, 70, "ExampleSection",
 CellID->2885],
Cell[17655, 628, 207, 7, 70, "ExampleText",
 CellID->564284357],
Cell[CellGroupData[{
Cell[17887, 639, 176, 6, 70, "Input",
 CellID->855448809],
Cell[18066, 647, 845, 29, 54, "Output",
 CellID->548040139]
}, Open  ]],
Cell[CellGroupData[{
Cell[18948, 681, 103, 3, 70, "Input",
 CellID->244496156],
Cell[19054, 686, 420, 14, 36, "Output",
 CellID->432646727]
}, Open  ]],
Cell[19489, 703, 125, 3, 70, "ExampleDelimiter",
 CellID->467730006],
Cell[19617, 708, 219, 7, 70, "ExampleText",
 CellID->41998822],
Cell[CellGroupData[{
Cell[19861, 719, 261, 9, 70, "Input",
 CellID->523584972],
Cell[20125, 730, 382, 13, 51, "Output",
 CellID->309733457]
}, Open  ]],
Cell[20522, 746, 123, 3, 70, "ExampleDelimiter",
 CellID->3426384],
Cell[20648, 751, 84, 1, 70, "ExampleText",
 CellID->123689926],
Cell[CellGroupData[{
Cell[20757, 756, 289, 9, 70, "Input",
 CellID->101125233],
Cell[21049, 767, 518, 17, 51, "Output",
 CellID->274871093]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21616, 790, 222, 7, 70, "ExampleSection",
 CellID->2718],
Cell[21841, 799, 125, 3, 70, "ExampleText",
 CellID->473802079],
Cell[CellGroupData[{
Cell[21991, 806, 107, 3, 70, "Input",
 CellID->296190599],
Cell[22101, 811, 176, 5, 36, "Output",
 CellID->475039421]
}, Open  ]],
Cell[22292, 819, 124, 3, 70, "ExampleDelimiter",
 CellID->95346333],
Cell[22419, 824, 196, 8, 70, "ExampleText",
 CellID->169625854],
Cell[CellGroupData[{
Cell[22640, 836, 414, 14, 70, "Input",
 CellID->108025290],
Cell[23057, 852, 20984, 348, 70, "Output",
 Evaluatable->False,
 CellID->30606177]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44090, 1206, 232, 7, 70, "ExampleSection",
 CellID->9107],
Cell[44325, 1215, 310, 13, 70, "ExampleText",
 CellID->765776941],
Cell[CellGroupData[{
Cell[44660, 1232, 139, 4, 70, "Input",
 CellID->408300678],
Cell[44802, 1238, 403, 15, 51, "Output",
 CellID->289759745]
}, Open  ]],
Cell[45220, 1256, 56, 1, 70, "ExampleText",
 CellID->383796518],
Cell[CellGroupData[{
Cell[45301, 1261, 104, 3, 70, "Input",
 CellID->37471775],
Cell[45408, 1266, 191, 6, 36, "Output",
 CellID->746517018]
}, Open  ]],
Cell[45614, 1275, 125, 3, 70, "ExampleDelimiter",
 CellID->101319019],
Cell[CellGroupData[{
Cell[45764, 1282, 159, 5, 70, "Input",
 CellID->41484],
Cell[45926, 1289, 367, 13, 51, "Output",
 CellID->126473129]
}, Open  ]],
Cell[46308, 1305, 125, 3, 70, "ExampleDelimiter",
 CellID->312599383],
Cell[46436, 1310, 220, 7, 70, "ExampleText",
 CellID->139566708],
Cell[CellGroupData[{
Cell[46681, 1321, 255, 8, 70, "Input",
 CellID->213173150],
Cell[46939, 1331, 191, 6, 36, "Output",
 CellID->128289259]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47191, 1344, 310, 9, 70, "SeeAlsoSection",
 CellID->1852],
Cell[47504, 1355, 1178, 44, 70, "SeeAlso",
 CellID->20747]
}, Open  ]],
Cell[CellGroupData[{
Cell[48719, 1404, 314, 9, 70, "TutorialsSection",
 CellID->23016],
Cell[49036, 1415, 182, 4, 70, "Tutorials",
 CellID->25050]
}, Open  ]],
Cell[CellGroupData[{
Cell[49255, 1424, 320, 9, 70, "RelatedLinksSection",
 CellID->9193],
Cell[49578, 1435, 195, 4, 70, "RelatedLinks"],
Cell[49776, 1441, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50012, 1450, 319, 9, 70, "MoreAboutSection",
 CellID->633120306],
Cell[50334, 1461, 151, 3, 70, "MoreAbout",
 CellID->256539716],
Cell[50488, 1466, 151, 3, 70, "MoreAbout",
 CellID->740722230],
Cell[50642, 1471, 145, 3, 70, "MoreAbout",
 CellID->118813267]
}, Open  ]],
Cell[50802, 1477, 27, 0, 70, "History"],
Cell[50832, 1479, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

