(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     70925,       2137]
NotebookOptionsPosition[     61709,       1819]
NotebookOutlinePosition[     63268,       1862]
CellTagsIndexPosition[     63132,       1856]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticK" :> Documentation`HelpLookup["paclet:ref/EllipticK"],
           "Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], 
          "GeometricMean" :> 
          Documentation`HelpLookup["paclet:ref/GeometricMean"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EllipticK\"\>", 2->"\<\"Mean\"\>", 
       3->"\<\"GeometricMean\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArithmeticGeometricMean", "ObjectName",
 CellID->10666],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArithmeticGeometricMean",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArithmeticGeometricMean"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arithmetic\[Hyphen]geometric mean of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26250]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->74113875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 " is a homogeneous function of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", and has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "/", "b"}], TraditionalForm]], "InlineMath"],
 " plane, with a branch cut running from from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->610987526],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->754756657],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->179537336],

Cell["Evaluate numerically:", "ExampleText",
 CellID->38567372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArithmeticGeometricMean", "[", 
  RowBox[{"1.8", ",", " ", "1.2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97421215],

Cell[BoxData["1.4848082617417828`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2032388712]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25241815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArithmeticGeometricMean", "[", 
    RowBox[{"1", ",", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", " ", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243528026],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmGuIlUUYx8c9l80id02sDakWW7AipDtS0pW0C4uJZRdLWjdxF9E1dy3S
LialSGaoGdptu1jQ5YORGIFBJERCJERCVBAGYR+SIOnDQnD6zTzv7Hln5jln
d89i9KED+553Zv7zn//zzPM8M2c7uwZ6lq7oGujt7mqfu7prVU9vd3/7nL7V
dBUmGGP28dffZniv8Ob+9lUqfKfPDp5NAAq2VbBI22uM7Wvl3XY15cbsa60x
P6+F92KNedpYvF5Bmef6zPn2WayOGNMcYSdF7UIyozVClKP26ZGyYsLQEiFi
DfEKTQlD079mzfgZ/kvWtFRG0jI5QpQUDTaeSqO2opTNiJlHVl/MZp4xZtWF
GjPTNeuprreLo1Of7F4wI82MFBPrGNkXYpGvS83Zd0v2Xc6+WxsYL+TGpZ7k
K2Fs/5t1em2N2DPMomZInXZS38bZHi/f/3rG1nYxnez6WSe5ra9aL0p9DrwV
Yo4d+1OZeRJ6lbUPfvGzMvOD979Vetet/VTpnT/v7aGhv6NVTEGIbedgiP/x
h9+7l3yYZ8mqDfRMeqPaX5J+zHhg0Xt2jcFkjA9ad2z/MjfW5GtW4en1Bz47
8JN9fa06s3l4Jh9Ye3v2IimPSCLtxImhDPWqQ2Vlxn20e1pcYwWDHX0rP7Ys
rwi27tkcx3jRK4Hj8De/mpdHyVEY1sPcNQP7cYjZ3cD6cvLjL5xq/b1L4fAn
c2z/Ka7NRqEdFealGnPrnXYTXRvLiQVr/85kJ/zJEs881bWPH/+L1Qdf/9q8
GESK3C7pZ4fZIbNdjQNBHfnuN0L3k/3fm20qSk5bLNy08XNczZIvqDhpH/rq
F2yxbFtV1OSQ7ejRP7aouCmeDW3v7Dlsngvsm+pY2Lfduw4BwITNKsuZDkd0
4gcWRPsmFdfmcKhGOzsK8bMq7myvnmABSmY/o+KmORyeJ/0lPTYE+s914+w4
4kXXepXnPK/r7rveZTdZ+EkV1+79AUhMeELFTXc4lkM/lOhfp+I6cvqRiNDH
Av0zvF8xTlL3UZXnAm8nIKiYsEbFXeRwyGExwfVLChSrmaD/0osz7OKE6WFH
oZ7W6T0zh5iZMPWNgckCLkkYVjSo5bKEaXmDTFckTL0NMl2VY2J7SdVllbh6
+XtwvEuzfFxQApgOydIgvq7x8SXxR3nvVuNmtn2UwFG/iWcSxZ6oD6rYax2W
mCbhwJIjtmovVrHXO+xwnpBVvJv7VeyNDgsXKLCwU9TMfYE9NzsM2qTEYJWt
9veofHO9X3EqZQvbF6q4Wx0npU9s/2jvEWv7AhV7u7f9+S0HudpglT0V5qvY
Tm8PHoIXdtYw81TsHU4rEhEqWjsDuxeEGqW0mttUrju9RtShkcpuNd6iYhd6
jRwNVY1zVOy9Disa5aCzGm5SsYt8PEmMoMHu+w2BTYt9bLA2OkHata9T+Vwk
llgyWHt2LqG02lbrxrUkVJdF5dUVLX/j/2nE4w95K2DBisyDsxriWpbzMNFN
JNrMunLUXLbpqlCJzCFCsY2nzaLLVQ7/H4/YP8t9VKAAHeQPWWQurclRr73S
cZGl5Cp62Gvr65mVuMLVup+t8tFMDIl/KZByOiVR0u/9RzWsVqYLg6h7xPNJ
dmRRN0Plc2dxWaqNJKYEXoeKXlvJchROmDPPT1exj4celpSX20eCfcrzYns1
n88JrNrgo1DyOLvJT1P53E2rhBcDvjYVu9F5IM8rHpiqojd75sADU1Ssu4eW
8x4Q5lYVvTXxrd21SYEPtuUY8wl0msq4I5cn1TiYqGJ3hnEgzDTLKtr99ikI
s+XUUdrvbjPhHymNSv0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->371926923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192430638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArithmeticGeometricMean", "[", 
    RowBox[{"1", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"x", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65570],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", 
    RowBox[{
     RowBox[{"Log", "[", "16", "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", "x", "]"}]}]}]], "+", 
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Log", "[", 
        FractionBox["x", "4"], "]"}]}], ")"}], " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       FractionBox["x", "4"], "]"}], "2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Pi/(Log[16] - 2 Log[$CellContext`x]), 
    0, ((Rational[1, 8] Pi) Log[Rational[1, 4] $CellContext`x]^(-2)) (1 + 
     Log[Rational[1, 4] $CellContext`x])}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{290, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1768707283]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6763],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->3460088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArithmeticGeometricMean", "[", 
  RowBox[{
   RowBox[{"1", "-", "I"}], ",", 
   RowBox[{"2.5", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425298927],

Cell[BoxData[
 RowBox[{"1.8346288381532843`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.19146162519713708`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1194663607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->295781222],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->42669059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArithmeticGeometricMean", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101603872],

Cell[BoxData["1.45679103104690686918643238326285793709`20.000000000000007"], \
"Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1886627046]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->260423164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArithmeticGeometricMean", "[", 
  RowBox[{"1", ",", "2.0000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29032865],

Cell[BoxData["1.45679103104690686918643238326508197497`22.53420088765922"], \
"Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->944714167]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76831976],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->651564906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArithmeticGeometricMean", "[", 
  RowBox[{"a", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256965757],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1464402498]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArithmeticGeometricMean", "[", 
  RowBox[{"0", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->615327514],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2050189266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235873642],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->431669465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArithmeticGeometricMean", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.0", ",", "2.0", ",", "3.0"}], "}"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317879528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.6040081905309407`", ",", "3.3289971432731074`", ",", 
   "3.9362355036495558`"}], "}"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1155877547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->661719855],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->520020912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArithmeticGeometricMean", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387648565],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["agm",
    ArithmeticGeometricMean,
    Editable->False,
    Selectable->False], "(", 
   RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->696861667]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23934],

Cell["\<\
Explicit form of the iterations yielding the arithmetic\[Hyphen]geometric \
mean:\
\>", "ExampleText",
 CellID->533469040],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"b", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}], ")"}], "/", "2"}]}], ";", 
  RowBox[{
   RowBox[{"b", "[", "n_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "-", "1"}], "]"}], " ", 
     RowBox[{"b", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"a", "[", "0", "]"}], "=", "1."}], ";", 
  RowBox[{
   RowBox[{"b", "[", "0", "]"}], "=", "2."}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37611789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], ",", 
     RowBox[{"b", "[", "n", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29808865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "1.4142135623730951`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4571067811865475`", ",", "1.4564753151219703`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4567910481542587`", ",", "1.456791013939555`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4567910310469068`", ",", "1.4567910310469068`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4567910310469068`", ",", "1.4567910310469068`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{410, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1925710178]
}, Open  ]],

Cell[TextData[{
 "Compare with ",
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29858773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArithmeticGeometricMean", "[", 
   RowBox[{"1.", ",", " ", "2."}], "]"}], " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->355739080],

Cell[BoxData["1.4567910310469068`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->684917709]
}, Open  ]],

Cell["\<\
Functional implementation of the previous iterative procedure:\
\>", "ExampleText",
 CellID->481150593],

Cell[BoxData[
 RowBox[{
  RowBox[{"agmIterations", "[", 
   RowBox[{
    RowBox[{"a_", "?", "InexactNumberQ"}], ",", 
    RowBox[{"b_", "?", "InexactNumberQ"}]}], "]"}], ":=", 
  RowBox[{"FixedPointList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", "2"}], ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->281808187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"agmIterations", "[", 
  RowBox[{"1.", ",", " ", "2."}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->164110777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "2.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "1.4142135623730951`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4571067811865475`", ",", "1.4564753151219703`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4567910481542587`", ",", "1.456791013939555`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4567910310469068`", ",", "1.4567910310469068`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4567910310469068`", ",", "1.4567910310469068`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{410, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->899587243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199880645],

Cell[TextData[{
 "Closed form of the iteration steps for calculating the \
arithmetic\[Hyphen]geometric mean expressed through ",
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4610016],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArithmeticGeometricMeanIteration", "[", 
   RowBox[{"n_", ",", "a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"z", "=", 
      RowBox[{"EllipticNomeQ", "[", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "/", "a"}], ")"}], "2"]}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"ArithmeticGeometricMean", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"3", ",", "0", ",", 
          SuperscriptBox["z", 
           SuperscriptBox["2", "n"]]}], "]"}], "2"], ",", 
       SuperscriptBox[
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"4", ",", "0", ",", 
          SuperscriptBox["z", 
           SuperscriptBox["2", "n"]]}], "]"}], "2"]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146848071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ArithmeticGeometricMeanIteration", "[", 
    RowBox[{"n", ",", "1.", ",", "2."}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->80846961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999994`", ",", "2.000000000000001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4999999999999998`", ",", "1.414213562373095`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4571067811865475`", ",", "1.4564753151219703`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4567910481542585`", ",", "1.456791013939555`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4567910310469068`", ",", "1.4567910310469068`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1077918221]
}, Open  ]],

Cell["\<\
Show convergence speed using arbitrary\[Hyphen]precision arithmetic:\
\>", "ExampleText",
 CellID->67092172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"N", "[", 
        RowBox[{"1", ",", "2000"}], "]"}]}], ",", 
      RowBox[{"b", "=", 
       RowBox[{"N", "[", 
        RowBox[{"2", ",", "2000"}], "]"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"ArithmeticGeometricMeanIteration", "[", 
        RowBox[{"n", ",", "a", ",", "b"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], "-", 
     RowBox[{"ArithmeticGeometricMean", "[", 
      RowBox[{"a", ",", "b"}], "]"}]}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"SetPrecision", "[", 
    RowBox[{"#", ",", "3"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->619735361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4567910310469068692`2.9999999999999996"}], ",", 
     "0.5432089689530931308`2.9999999999999996"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0432089689530931308`2.9999999999999996", ",", 
     RowBox[{"-", "0.0425774686738118204`3.0000000000000018"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.0003157501396406552`3.0000000000000018", ",", 
     RowBox[{"-", "0.0003157159249366083`2.9999999999999996"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"1.710735202343957073903`2.9999999999999973*^-8", ",", 
     RowBox[{"-", "1.710735192299225698628`3.0000000000000018*^-8"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"5.022365687637`2.9999999999999996*^-17", ",", 
     RowBox[{"-", "5.022365687637`2.9999999999999996*^-17"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.32871917845121`3.0000000000000018*^-34", ",", 
     RowBox[{"-", "4.32871917845121`3.0000000000000018*^-34"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"3.215596699621626548`2.9999999999999996*^-68", ",", 
     RowBox[{"-", "3.215596699621626548`2.9999999999999996*^-68"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.77445870997481449`2.9999999999999996*^-136", ",", 
     RowBox[{"-", "1.77445870997481449`2.9999999999999996*^-136"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"5.4034924129487218`2.9999999999999996*^-273", ",", 
     RowBox[{"-", "5.4034924129487218`2.9999999999999996*^-273"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"5.0106243164834`3.0000000000000018*^-546", ",", 
     RowBox[{"-", "5.0106243164834`3.0000000000000018*^-546"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"4.3085033312726806`3.0000000000000018*^-1092", ",", 
     RowBox[{"-", "4.3085033312726806`3.0000000000000018*^-1092"}]}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{572, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->399494255]
}, Open  ]],

Cell[TextData[{
 "Compute a thousand digits of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->537101318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "=", "1``1010"}], ",", 
     RowBox[{"b", "=", 
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
     RowBox[{"o", "=", "9"}]}], "}"}], ",", 
   RowBox[{"2", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ArithmeticGeometricMeanIteration", "[", 
        RowBox[{
         RowBox[{"o", "+", "1"}], ",", "a", ",", "b"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "^", "n"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}]}], "}"}], ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ArithmeticGeometricMeanIteration", "[", 
               RowBox[{"n", ",", "a", ",", "b"}], "]"}], "^", "2"}], ")"}]}], 
           ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "0", ",", "o"}], "}"}]}], "]"}]}], ")"}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6730895],

Cell[BoxData["3.\
141592653589793238462643383279502884197169399375105820974944592307816406286208\
998628034825342117067982148086513282306647093844609550582231725359408128481117\
450284102701938521105559644622948954930381964428810975665933446128475648233786\
783165271201909145648566923460348610454326648213393607260249141273724587006606\
315588174881520920962829254091715364367892590360011330530548820466521384146951\
941511609433057270365759591953092186117381932611793105118548074462379962749567\
351885752724891227938183011949129833673362440656643086021394946395224737190702\
179860943702770539217176293176752384674818467669405132000568127145263560827785\
771342757789609173637178721468440901224953430146549585371050792279689258923542\
019956112129021960864034418159813629774771309960518707211349999998372978049951\
059731732816096318595024459455346908302642522308253344685035261931188171010003\
137838752886587533208381420617177669147303598253490428755468731159562863882353\
787593751957781857780532171226806613001927876611195909216420198938095257201165\
8063786`1006.4477428457523"], "Output",
 ImageSize->{585, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1266063263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", "Pi"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->246657716],

Cell[BoxData["0``1005.9505929730581"], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1457286765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20769318],

Cell["Plot the absolute value in the parameter plane:", "ExampleText",
 CellID->419085205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"ArithmeticGeometricMean", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195312689],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159454686]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7301],

Cell[TextData[{
 "Derivative of ",
 Cell[BoxData[
  ButtonBox["InverseJacobiCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCD"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->95942521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"ArithmeticGeometricMean", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "2"}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->463371221],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"ArithmeticGeometricMean", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"ArithmeticGeometricMean", "[", 
       RowBox[{"a", ",", "b"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"EllipticE", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "2"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}], "2"]], "]"}], "2"]}], "-", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           RowBox[{"4", " ", "a", " ", "b"}], "+", 
           SuperscriptBox["b", "2"]}], ")"}], " ", 
         RowBox[{"EllipticE", "[", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "2"], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "2"]], "]"}]}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         RowBox[{"EllipticK", "[", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "2"], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "2"]], "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{456, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1628673266]
}, Open  ]],

Cell[TextData[{
 "Derivative of ",
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4928619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"ArithmeticGeometricMean", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "2"}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->384092964],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], "2"], " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"ArithmeticGeometricMean", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"ArithmeticGeometricMean", "[", 
       RowBox[{"a", ",", "b"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"EllipticE", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "2"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}], "2"]], "]"}], "2"]}], "-", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           RowBox[{"4", " ", "a", " ", "b"}], "+", 
           SuperscriptBox["b", "2"]}], ")"}], " ", 
         RowBox[{"EllipticE", "[", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "2"], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "2"]], "]"}]}], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", 
         RowBox[{"EllipticK", "[", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "2"], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "2"]], "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{456, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1285017000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19980516],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 " to other functions:"
}], "ExampleText",
 CellID->851060326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"ArithmeticGeometricMean", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31499287],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], " ", "\[Pi]"}], 
  RowBox[{"4", " ", 
   RowBox[{"EllipticK", "[", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], "2"]], "]"}]}]]], "Output",
 ImageSize->{130, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37681121]
}, Open  ]],

Cell[TextData[{
 "Show that ",
 Cell[BoxData[
  ButtonBox["ArithmeticGeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFormula"],
 " obeys a hypergeometric\[Hyphen]type differential equation:"
}], "ExampleText",
 CellID->201821916],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "a_", "]"}], " ", ":=", " ", 
  RowBox[{"ArithmeticGeometricMean", "[", 
   RowBox[{"a", ",", " ", "b"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->486694592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], " ", "-", " ", 
        RowBox[{"a", "^", "2"}]}], ")"}], " ", 
      RowBox[{
       RowBox[{
        RowBox[{"w", "'"}], "[", "a", "]"}], "^", "2"}]}], " ", "+", " ", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"a", "^", "2"}]}], " ", "-", " ", 
           RowBox[{"b", "^", "2"}]}], ")"}], " ", 
         RowBox[{
          RowBox[{"w", "'"}], "[", "a", "]"}]}], " ", "+", "\n", 
        "             ", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], " ", "-", " ", 
           RowBox[{"b", "^", "2"}]}], ")"}], " ", 
         RowBox[{
          RowBox[{"w", "''"}], "[", "a", "]"}]}]}], ")"}]}], " ", "-", " ", 
     RowBox[{"a", " ", 
      RowBox[{
       RowBox[{"w", "[", "a", "]"}], "^", "2"}]}]}], " ", "==", " ", "0"}], 
   ",", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->214346063],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1946408429]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->598030051],

Cell["\<\
Proof that iterations lie between the arithmetic and the geometric means:\
\>", "ExampleText",
 CellID->738775823],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"b", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}], ")"}], "/", "2"}]}], ";", 
  RowBox[{
   RowBox[{"b", "[", "n_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "-", "1"}], "]"}], " ", 
     RowBox[{"b", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"a", "[", "0", "]"}], "=", "a0"}], ";", 
  RowBox[{
   RowBox[{"b", "[", "0", "]"}], "=", "b0"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241827271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a0", ",", "b0"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a0", ",", "b0"}], "}"}], "\[Element]", " ", "Reals"}], "&&", 
     RowBox[{"a0", ">", "0"}], "&&", 
     RowBox[{"b0", ">", "0"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a0", "+", "b0"}], ")"}], "/", "2"}], ">=", 
     RowBox[{"a", "[", "3", "]"}], ">=", 
     RowBox[{"b", "[", "3", "]"}], ">=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a0", " ", "b0"}], "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114204247],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->668071452]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5874],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticK"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeometricMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricMean"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25667]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12670],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->13145]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3925],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ArithmeticGeometricMean.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/\
ArithmeticGeometricMean/"], None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ArithmeticGeometricMean"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->137556416],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->738358227]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArithmeticGeometricMean - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 43.8466324}", "context" -> "System`", 
    "keywords" -> {
     "arithmetic-geometric mean", "calculation of pi", "Gauss AGM"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ArithmeticGeometricMean[a, b] gives the arithmetic-geometric mean of a \
and b. ", "synonyms" -> {"arithmetic geometric mean", "AGM"}, "title" -> 
    "ArithmeticGeometricMean", "type" -> "Symbol", "uri" -> 
    "ref/ArithmeticGeometricMean"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5457, 182, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->754756657]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[48134, 1320, 255, 9, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->95942521]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 62835, 1845},
 {"XRef-2005-4-26-23-37-1.8558342", 62992, 1849}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2003, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2626, 77, 61, 1, 70, "ObjectName",
 CellID->10666],
Cell[2690, 80, 728, 23, 70, "Usage",
 CellID->26250]
}, Open  ]],
Cell[CellGroupData[{
Cell[3455, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3933, 125, 277, 8, 70, "Notes",
 CellID->74113875],
Cell[4213, 135, 248, 7, 70, "Notes",
 CellID->31226],
Cell[4464, 144, 722, 24, 70, "Notes",
 CellID->610987526],
Cell[5189, 170, 231, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5457, 182, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->754756657],
Cell[CellGroupData[{
Cell[5842, 196, 148, 5, 70, "ExampleSection",
 CellID->179537336],
Cell[5993, 203, 63, 1, 70, "ExampleText",
 CellID->38567372],
Cell[CellGroupData[{
Cell[6081, 208, 150, 4, 28, "Input",
 CellID->97421215],
Cell[6234, 214, 177, 5, 36, "Output",
 CellID->2032388712]
}, Open  ]],
Cell[6426, 222, 124, 3, 70, "ExampleDelimiter",
 CellID->25241815],
Cell[CellGroupData[{
Cell[6575, 229, 268, 8, 28, "Input",
 CellID->243528026],
Cell[6846, 239, 2063, 38, 136, "Output",
 Evaluatable->False,
 CellID->371926923]
}, Open  ]],
Cell[8924, 280, 125, 3, 70, "ExampleDelimiter",
 CellID->192430638],
Cell[CellGroupData[{
Cell[9074, 287, 326, 10, 70, "Input",
 CellID->65570],
Cell[9403, 299, 1046, 33, 69, "Output",
 CellID->1768707283]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10498, 338, 215, 7, 70, "ExampleSection",
 CellID->6763],
Cell[10716, 347, 72, 1, 70, "ExampleText",
 CellID->3460088],
Cell[CellGroupData[{
Cell[10813, 352, 192, 6, 70, "Input",
 CellID->425298927],
Cell[11008, 360, 275, 7, 36, "Output",
 CellID->1194663607]
}, Open  ]],
Cell[11298, 370, 125, 3, 70, "ExampleDelimiter",
 CellID->295781222],
Cell[11426, 375, 69, 1, 70, "ExampleText",
 CellID->42669059],
Cell[CellGroupData[{
Cell[11520, 380, 197, 6, 70, "Input",
 CellID->101603872],
Cell[11720, 388, 220, 6, 36, "Output",
 CellID->1886627046]
}, Open  ]],
Cell[11955, 397, 113, 3, 70, "ExampleText",
 CellID->260423164],
Cell[CellGroupData[{
Cell[12093, 404, 164, 4, 70, "Input",
 CellID->29032865],
Cell[12260, 410, 218, 6, 36, "Output",
 CellID->944714167]
}, Open  ]],
Cell[12493, 419, 124, 3, 70, "ExampleDelimiter",
 CellID->76831976],
Cell[12620, 424, 91, 1, 70, "ExampleText",
 CellID->651564906],
Cell[CellGroupData[{
Cell[12736, 429, 142, 4, 70, "Input",
 CellID->256965757],
Cell[12881, 435, 159, 5, 36, "Output",
 CellID->1464402498]
}, Open  ]],
Cell[CellGroupData[{
Cell[13077, 445, 142, 4, 70, "Input",
 CellID->615327514],
Cell[13222, 451, 159, 5, 36, "Output",
 CellID->2050189266]
}, Open  ]],
Cell[13396, 459, 125, 3, 70, "ExampleDelimiter",
 CellID->235873642],
Cell[13524, 464, 240, 7, 70, "ExampleText",
 CellID->431669465],
Cell[CellGroupData[{
Cell[13789, 475, 210, 7, 70, "Input",
 CellID->317879528],
Cell[14002, 484, 276, 9, 36, "Output",
 CellID->1155877547]
}, Open  ]],
Cell[14293, 496, 125, 3, 70, "ExampleDelimiter",
 CellID->661719855],
Cell[14421, 501, 340, 11, 70, "ExampleText",
 CellID->520020912],
Cell[CellGroupData[{
Cell[14786, 516, 181, 5, 70, "Input",
 CellID->387648565],
Cell[14970, 523, 353, 12, 50, "Output",
 CellID->696861667]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15372, 541, 223, 7, 70, "ExampleSection",
 CellID->23934],
Cell[15598, 550, 132, 4, 70, "ExampleText",
 CellID->533469040],
Cell[15733, 556, 698, 24, 70, "Input",
 CellID->37611789],
Cell[CellGroupData[{
Cell[16456, 584, 283, 10, 70, "Input",
 CellID->29808865],
Cell[16742, 596, 647, 18, 54, "Output",
 CellID->1925710178]
}, Open  ]],
Cell[17404, 617, 225, 8, 70, "ExampleText",
 CellID->29858773],
Cell[CellGroupData[{
Cell[17654, 629, 168, 5, 70, "Input",
 CellID->355739080],
Cell[17825, 636, 176, 5, 36, "Output",
 CellID->684917709]
}, Open  ]],
Cell[18016, 644, 113, 3, 70, "ExampleText",
 CellID->481150593],
Cell[18132, 649, 839, 27, 70, "Input",
 CellID->281808187],
Cell[CellGroupData[{
Cell[18996, 680, 139, 4, 70, "Input",
 CellID->164110777],
Cell[19138, 686, 709, 20, 54, "Output",
 CellID->899587243]
}, Open  ]],
Cell[19862, 709, 125, 3, 70, "ExampleDelimiter",
 CellID->199880645],
Cell[19990, 714, 320, 9, 70, "ExampleText",
 CellID->4610016],
Cell[20313, 725, 975, 30, 70, "Input",
 CellID->146848071],
Cell[CellGroupData[{
Cell[21313, 759, 279, 8, 70, "Input",
 CellID->80846961],
Cell[21595, 769, 660, 18, 36, "Output",
 CellID->1077918221]
}, Open  ]],
Cell[22270, 790, 118, 3, 70, "ExampleText",
 CellID->67092172],
Cell[CellGroupData[{
Cell[22413, 797, 804, 25, 70, "Input",
 CellID->619735361],
Cell[23220, 824, 2001, 50, 96, "Output",
 CellID->399494255]
}, Open  ]],
Cell[25236, 877, 161, 6, 70, "ExampleText",
 CellID->537101318],
Cell[CellGroupData[{
Cell[25422, 887, 1198, 38, 70, "Input",
 CellID->6730895],
Cell[26623, 927, 1230, 19, 241, "Output",
 CellID->1266063263]
}, Open  ]],
Cell[CellGroupData[{
Cell[27890, 951, 93, 3, 70, "Input",
 CellID->246657716],
Cell[27986, 956, 179, 5, 36, "Output",
 CellID->1457286765]
}, Open  ]],
Cell[28180, 964, 124, 3, 70, "ExampleDelimiter",
 CellID->20769318],
Cell[28307, 969, 90, 1, 70, "ExampleText",
 CellID->419085205],
Cell[CellGroupData[{
Cell[28422, 974, 404, 13, 70, "Input",
 CellID->195312689],
Cell[28829, 989, 19021, 316, 70, "Output",
 Evaluatable->False,
 CellID->159454686]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47899, 1311, 232, 7, 70, "ExampleSection",
 CellID->7301],
Cell[48134, 1320, 255, 9, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->95942521],
Cell[CellGroupData[{
Cell[48414, 1333, 281, 9, 70, "Input",
 CellID->463371221],
Cell[48698, 1344, 1972, 62, 132, "Output",
 CellID->1628673266]
}, Open  ]],
Cell[50685, 1409, 225, 8, 70, "ExampleText",
 CellID->4928619],
Cell[CellGroupData[{
Cell[50935, 1421, 281, 9, 70, "Input",
 CellID->384092964],
Cell[51219, 1432, 1972, 62, 132, "Output",
 CellID->1285017000]
}, Open  ]],
Cell[53206, 1497, 124, 3, 70, "ExampleDelimiter",
 CellID->19980516],
Cell[53333, 1502, 383, 13, 70, "ExampleText",
 CellID->851060326],
Cell[CellGroupData[{
Cell[53741, 1519, 283, 9, 70, "Input",
 CellID->31499287],
Cell[54027, 1530, 501, 18, 67, "Output",
 CellID->37681121]
}, Open  ]],
Cell[54543, 1551, 281, 8, 70, "ExampleText",
 CellID->201821916],
Cell[54827, 1561, 211, 6, 70, "Input",
 CellID->486694592],
Cell[CellGroupData[{
Cell[55063, 1571, 1283, 41, 70, "Input",
 CellID->214346063],
Cell[56349, 1614, 162, 5, 36, "Output",
 CellID->1946408429]
}, Open  ]],
Cell[56526, 1622, 125, 3, 70, "ExampleDelimiter",
 CellID->598030051],
Cell[56654, 1627, 124, 3, 70, "ExampleText",
 CellID->738775823],
Cell[56781, 1632, 699, 24, 70, "Input",
 CellID->241827271],
Cell[CellGroupData[{
Cell[57505, 1660, 670, 21, 70, "Input",
 CellID->114204247],
Cell[58178, 1683, 161, 5, 36, "Output",
 CellID->668071452]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58400, 1695, 310, 9, 70, "SeeAlsoSection",
 CellID->5874],
Cell[58713, 1706, 700, 26, 70, "SeeAlso",
 CellID->25667]
}, Open  ]],
Cell[CellGroupData[{
Cell[59450, 1737, 314, 9, 70, "TutorialsSection",
 CellID->12670],
Cell[59767, 1748, 192, 4, 70, "Tutorials",
 CellID->13145]
}, Open  ]],
Cell[CellGroupData[{
Cell[59996, 1757, 320, 9, 70, "RelatedLinksSection",
 CellID->3925],
Cell[60319, 1768, 194, 4, 70, "RelatedLinks"],
Cell[60516, 1774, 211, 4, 70, "RelatedLinks"],
Cell[60730, 1780, 401, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61168, 1798, 319, 9, 70, "MoreAboutSection",
 CellID->137556416],
Cell[61490, 1809, 147, 3, 70, "MoreAbout",
 CellID->738358227]
}, Open  ]],
Cell[61652, 1815, 27, 0, 70, "History"],
Cell[61682, 1817, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

