(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    476766,      11827]
NotebookOptionsPosition[    443192,      10623]
NotebookOutlinePosition[    444934,      10673]
CellTagsIndexPosition[    444815,      10667]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatrixPlot" :> 
          Documentation`HelpLookup["paclet:ref/MatrixPlot"], "ReliefPlot" :> 
          Documentation`HelpLookup["paclet:ref/ReliefPlot"], 
          "ListDensityPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListDensityPlot"], 
          "DensityPlot" :> Documentation`HelpLookup["paclet:ref/DensityPlot"],
           "Raster" :> Documentation`HelpLookup["paclet:ref/Raster"], 
          "ListPlot3D" :> Documentation`HelpLookup["paclet:ref/ListPlot3D"], 
          "Grid" :> Documentation`HelpLookup["paclet:ref/Grid"], 
          "GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], 
          "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"], "ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"], "GraphPlot" :> 
          Documentation`HelpLookup["paclet:ref/GraphPlot"], "ClickPane" :> 
          Documentation`HelpLookup["paclet:ref/ClickPane"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MatrixPlot\"\>", 
       2->"\<\"ReliefPlot\"\>", 3->"\<\"ListDensityPlot\"\>", 
       4->"\<\"DensityPlot\"\>", 5->"\<\"Raster\"\>", 6->"\<\"ListPlot3D\"\>",
        7->"\<\"Grid\"\>", 8->"\<\"GraphicsGrid\"\>", 
       9->"\<\"SparseArray\"\>", 10->"\<\"CellularAutomaton\"\>", 
       11->"\<\"PadLeft\"\>", 12->"\<\"ArrayFlatten\"\>", 
       13->"\<\"GraphPlot\"\>", 14->"\<\"ClickPane\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Computational Systems\"\>", 
       2->"\<\"Data Visualization\"\>", 3->"\<\"Handling Arrays of Data\"\>", 
       4->"\<\"Image Processing\"\>", 5->"\<\"Numerical Data\"\>", 
       6->"\<\"New in 6.0: Data Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ArrayPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayPlot"], "[", 
       StyleBox["array", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a plot in which the values in an array are \
shown in a discrete array of squares. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16344]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayPlot"], "[", 
   StyleBox["array", "TI"], "]"}]], "InlineFormula"],
 " by default arranges successive rows of ",
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " down the page, and successive columns across, just as a table or grid \
would normally be formatted. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24387,
  ButtonNote->"24387"]
}], "Notes",
 CellID->11830],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " contains 0s and 1s, the 1s will appear as black squares and the 0s as \
white squares. "
}], "Notes",
 CellID->6382],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " by default generates grayscale output, in which zero values are shown \
white, and the maximum positive or negative value is shown black. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->30219,
  ButtonNote->"30219"]
}], "Notes",
 CellID->27261],

Cell[TextData[{
 "With an explicit setting for ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " by default makes the minimum value white and the maximum black."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26395],

Cell[TextData[{
 "The following special entries can be used: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19801,
  ButtonNote->"19801"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27151],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["background color", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], Cell["color directive", "TableText"], Cell[
    "specified color", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->20666],

Cell[TextData[{
 "If ",
 StyleBox["array", "TI"],
 " is ragged, shorter rows are treated as padded on the right with \
background. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16028,
  ButtonNote->"16028"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->83],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->28710],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ClippingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ClippingStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to show cells whose values are clipped", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how each cell should be colored ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale the argument to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorRules"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "rules for determining colors from values ", "TableText"]},
   {Cell[" ", "TableRowIcon"], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " values to assume "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["DataReversed",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataReversed"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to reverse the order of rows", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to draw a frame around the plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "labels for rows and columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameTicks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameTicks"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what ticks to include on the frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxPlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxPlotPoints"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "the maximum number of points to include ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw a mesh ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", 
     RowBox[{
      ButtonBox["GoldenRatio",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GoldenRatio"], "-", "1"}], "]"}], Cell[
    "the style to use for a mesh ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PixelConstrained",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PixelConstrained"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "how to constrain cells to align with pixels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the range of values to plot ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, None, None, None, 
     None, None, {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True}}}},
 CellID->26758],

Cell[TextData[{
 "The rules given by ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " are applied to the value ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " of each cell. The rules can involve patterns. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->4953,
  ButtonNote->"4953"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->7372],

Cell[TextData[{
 "If none of the rules in ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " applies, then ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " is used to determine the color. "
}], "Notes",
 CellID->2295],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorRules"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", an explicit setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " is used instead of ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17906],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", each value ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is supplied as the argument to any function given for ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16594,
  ButtonNote->"16594"]
}], "Notes",
 CellID->30014],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the values are scaled to lie between 0 and 1. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->30503,
  ButtonNote->"30503"]
}], "Notes",
 CellID->13452],

Cell[TextData[{
 "If the color determined for a particular cell is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", the cell is rendered in the background color."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->20284],

Cell["\<\
If no color is determined for a particular cell, the cell is rendered in a \
default dark red color.\
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29905],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataReversed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataReversed"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the order of rows is reversed, so that rows run from bottom to top, with \
the last row at the top. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25812],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrameTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicks"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ticks are placed at round integers, typically multiples of 5 or 10. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25352,
  ButtonNote->"25352"]
}], "Notes",
 CellID->28021],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrameTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicks"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ticks are also placed at the minimum and maximum ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21793,
  ButtonNote->"21793"]
}], "Notes",
 CellID->6341],

Cell[TextData[{
 "In explicit ",
 Cell[BoxData[
  ButtonBox["FrameTicks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicks"]], "InlineFormula"],
 " specifications, the tick coordinates are taken to refer to ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->564445753],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataReversed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataReversed"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", tick values decrease from top to bottom. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6575],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["max", "TI"]]}]], "InlineFormula"],
 " specifies that only those ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " between 0 and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " should be shown. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->14331,
  ButtonNote->"14331"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->22290],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["max", "TI"]]}], "}"}]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " between ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " should be shown. "
}], "Notes",
 CellID->17525],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " shows only elements with ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " in the specified ranges. The top\[Hyphen]left element has ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"j", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataReversed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataReversed"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " increases down the page; ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " increases to the right. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6611],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["ispec", "TI"], ",", 
     StyleBox["jspec", "TI"], ",", 
     StyleBox["aspec", "TI"]}], "}"}]}]], "InlineFormula"],
 " shows only elements in the specified ranges of ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " and value. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28052,
  ButtonNote->"28052"]
}], "Notes",
 CellID->22167],

Cell[TextData[{
 "With the default setting for ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["max", "TI"]]}], "}"}]}]], "InlineFormula"],
 " specifies that values from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " should be shown with grayscales varying from white to black. "
}], "Notes",
 CellID->26982],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " draws mesh lines between each cell in the array. "
}], "Notes",
 CellID->5783],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["i", "TI"]], ",", 
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["j", "TI"]]}], "}"}]}]], "InlineFormula"],
 " gives mesh specifications for the ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " directions respectively. "
}], "Notes",
 CellID->587951441],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", a frame is drawn only when ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23387],

Cell[TextData[{
 "For purposes of combining with other graphics, the array element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is taken to cover a unit square centered at coordinate position ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "j", "-", "1", "/", "2"}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["i", 
     StyleBox["max", "TI"]], "-", "i", "+", "1", "/", "2"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->156382324],

Cell[TextData[{
 "A setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies that the centers of successive cells should be at equally spaced \
positions between ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " in the horizontal direction, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " in the vertical direction. With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataReversed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataReversed"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "11"], TraditionalForm]], "InlineMath"],
 " is centered at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->402621626],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataReversed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataReversed"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the array element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " will be taken to cover a unit square centered at coordinate position ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "j", "-", "1", "/", "2"}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["i", 
     StyleBox["max", "TI"]], "-", "i", "+", "1", "/", "2"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->28793],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28050],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PixelConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PixelConstrained"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " generates a ",
 Cell[BoxData[
  ButtonBox["Raster",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Raster"]], "InlineFormula"],
 " with an absolute size that aligns cells with pixels, so that each cell is \
an integer number of pixels across, or each pixel is an integer number of \
cells across. The cells are each taken to be as large as possible given the \
",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " setting specified. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->5312,
  ButtonNote->"5312"]
}], "Notes",
 CellID->19679],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2851,
  ButtonNote->"2851"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->18268]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->649688704],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->121525386],

Cell["Plot an array of numbers:", "ExampleText",
 CellID->423618593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0", ",", "0.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1", ",", "0.7"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27550],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAOxugQDkP0fyAJj
kBAQMIPYYMCgDyQYUURBTG4QBrJ5gDSPj48P46iqIalKDCQLUrV58+ZRFYNH
BSj2xEdV0FEFalkHLQcZAVcQnCc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{51, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8517297]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8060],

Cell["\<\
Give explicit color directives to specify colors for individual cells:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->19801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "Pink"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0", ",", "Pink"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1", ",", "Red"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30759],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAOxugQDkP0fyAJj
kBAQMIPYYMCgDyQYUURBTG4QBrJ5gDQPUIRxVNWQVCUGlgWq+l9fP6pi8KgA
xZ74qAo6qkAt66DlICMAc3ea5w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{51, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->10338215]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2923],

Cell["Specify overall color rules:", "ExampleText",
 CellID->67],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0.7"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "Pink"}], ",", 
      RowBox[{"0", "\[Rule]", "Yellow"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7300],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAOxugQDkP0fyAJj
kBAQMIPYYMCgDyQYUUXr6xm4gQQ3UJYHSPP4+PgwjqoakqrEQLIgVZs3bx5V
MXhUgGJPfFQFPVWglHXQcpARAM4WHGM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{51, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->279756211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8256],

Cell["Include a mesh:", "ExampleText",
 CellID->19140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0.7"}], "}"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10048],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAOxugQDkP0fyAJj
4///QTQzkOLn5weyGPSAmJGTk5MRIcMAAdwgDOTygmgfHx+QkaOqBpMqfayi
4lC9DMxAxmYwYOAEEtjNGFU9fFRjTw/cyGb8BwMGTqLNHNU9qpteusF1EbBe
gshA6ypGAMPNUp0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{51, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->658582804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1807],

Cell["Plot a table of data:", "ExampleText",
 CellID->14449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8491],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmEsobVEYx5fD/5POQB6DoyQDpeSRFPJIxLmF41EGIuo4Ts6J4zyuJAxk
IsJEkgEhjyglhJEieWSCiTxnipRHCXnd+63VHbizOz3dvWr/99qrvb/fGvz7
vm8vk7nJZnWYm+wWc+QPj9lls1t+RhqdHl7y9RFCuPlKNwie/+KZuuQSD185
V0M4WHz+YXVqakqABZWVlfDz86P19XXs7+9TVlYWTk5OcHl5SYGBgdjZ2cHN
zQ3t7u6iuroaoaGhFBMTg+PjYyouLkZdXR1ycnKI7zqN4iWUq6srARZkZGRI
Eq2treH5+ZlGR0fx8PCgPzs7Q3Z2NjIzM0mn06GgoABbW1skdxUXF0fX19d4
eXlBQ0MDDQ4OaoT/lxAeHi7Ags7OTgwMDND4+Diqqqqov78fYWFhOD8/p/Ly
csTGxsJoNJJ8t6OjA/f39yTv0tEOhwMWiwVut5t6e3s1irdQDAaDAAs8Hg/4
maanp9He3k59fX1oaWmBzWYjk8mEtLQ0cAQaGRmReUtSKSAgAC6Xi9ra2uTO
MDQ0RCkpKRpFo3ynWK1WARbs7e0pdy4vL6O7u5tyc3OxtLSkap90sayFPJSr
k5OT8fT0RJzXlHtlTby9vcXj4yO9vr5qFG+hFBUVCbBAdkCyu0lKSgLnJbq7
u0Nzc7NcJ71ej6ioKJSVlZH02tvbG4KDg2lychLDw8NUW1urdvH19UX+/v4a
xVsom5ubAiyqkrE/SGaKjY0N+vz8hPST9JWsVpxpsLi4SKurq8pjnHXI6XQq
jx0cHEhfqu+4j9EoGuU7paenR4BFObW+vp4SExORmppKNTU12N7eRklJiXJq
QkKC6oPf39/x8fGBxsZGqqiowMXFBRUWFuLw8BClpaUUEhKiUbyFcnR0JMCi
PCYjyuiyb1lYWEBXVxdOT08pIiICMzMzsNvtFB0drXpmOc/Ly0N+fj7Fx8er
XXBI4lymUbyFwoGEihYUFATOGKpitba20uzsrKLLM5T5+XlZtVSG4b8myPOX
lZUVkv/Fc3NzZDabMTY2homJCeIKp1E0ynfK3yewf85sfX4D6wn3Ug==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->355634617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->825369802],

Cell["Use a standard blend as a color function:", "ExampleText",
 CellID->21049225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->55105224],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmO1PU2cYxg8j1/U3LKFNZNkmkKkDFDBAT1tnLQr4xoQEnZQXtUNsherU
sAVxAzudU4aAsjHGItUIRWYBpbQsvkQr2Lole3UCIpz+Gew55QtL9mnfmp2T
PFee8zx37t+XO/d9nVNkcx2qqbO57FW2VVvqbc5D9qqGVRZHvThKTJAkySVW
/uuS2C+J3fJKXFpSN+rjFCth+TVRvYs9klNIwnLAfzhdPLhWghBU6a/w/IQd
i7XrqDRlQqlbx3P+D3FwqJ3N40dZkOKDYfdT/uHNR9Bv5Z5eLwo+f8DijgAC
E1a+6s5BZMTEA97Lr2mUOKG8LE6VIASv9r5Dp+4ClNb13K//GtET6fxtyICh
4HZOiCzlnn78estAh4iRi6coGx/hR/8WlvQMw9IcosN3Fn3BUu7Vf6tRNMpK
yvOBfAlCoHwmst/ohbxjmnLBE9QOX+DL3o2YyXqL0VMZ3NF1F4WXJnlxogZt
gSpW67rQHqjkkdtudAT201AWgelwhAd0HRolXijtAZskom0w7AnTVBfBfM9G
Tt0xo3qwi3OWFFQOdNNcH+ZiVw4sZ0L8ZVgWWSt4erwef93M44mkFsyXpDHa
mAGlOZMt/jqNolFWUhYq1kgQAlP2fRa4H6JTVOWsaTVqdJ2x+SdXP+Ok6Fel
fYMwlEZ4b9yCk2ONvBZ8Hx8ltVI5nYmGkU/5XbAMypn1DI+aNEq8UESpSFDr
ZW5rKuVNjxE9nk6TIwzZEqLifBdqD7ssasp+6xJmzaspVzyD6G9svHMS1rRR
hu5uQlnfAK0tj1DuuUazK6xRNMpKSnm/R4IQiGjK1hCUi1kUDhzy1iec7c9F
UfIg1b6lunGb/irFTIUnWMIG3TkUveHlvuvf4/hok3BMP2CX3sPosXSNEi+U
6TGzBCGY25bK58nJUNwbYv7YmjbC7Z1+OHxudbpRuCP85DNyn74HC1dyeCzJ
DaevlTPXcyEXTsW8dZm+j3ObUzSKRllJMebclyAEfw7m80X6m1A6srnz6pja
2yjcNZSPMzgQ3MnfvQbM5L3NgN8KpS2LR3Rf4qz/MN3+Wvx828j53Wlizn7A
hco1GiVeKMpX2RKEwGiPcCywDZubphhUM53fwBlPLkSf4nufTIuv9C9i2Ww3
v8Gu7hG+uJGHwrZJCo+s1ijFHUQPo7nhX6aYRvk/U/75/9e1fJfwN3hojuE=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{116, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84210091]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4836],

Cell["By default, absolute values go from white to black: ", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->30219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30270],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwBAKxuQQDkP0fyAJj
kBAQMIPYYMDgCyQYUUTr6+sZJIGEpL29vRRQiHFUxaiKURUUqNi/fz+DJJCQ
BLKlgPSoilEVoypoq+I/St0GrfcYAd6Eu0c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{81, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->360441916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6631],

Cell["Unknown or symbolic values are shown dark red:", "ExampleText",
 CellID->8324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "x"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25807],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwBAKxuQQDkP0fyAJj
kBAQMIPYYMDgCyQYUURDQ0MZJIGEJJArVc/AwDiqYlTFqAoKVKxatYpBEkhI
AtlSQHpUxaiKURW0VfEfpW6D1nuMAD7FiWs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{81, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{159., Automatic}},
 CellLabel->"Out[1]=",
 CellID->468147397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22301],

Cell["Specify explicit colors for each cell:", "ExampleText",
 CellID->30283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3969],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwVAKxvQQDkP0fyAJj
kBAQMIPYYMBQCiQYiRTlBhrCAzQHRCsDRZH5IJppVNeoLpJ0KUFlxYEieqOq
hqwqcXBMM/znAarmBrLBNIgPEx/VOaqTdjrhOqDlDjINNWlU56jOwaaTG1yu
QlK+1aiqQaiKUOsY2p5mBADws9Bb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{121, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{177., Automatic}},
 CellLabel->"Out[1]=",
 CellID->252572751]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24955],

Cell["Plot a ragged array, padding on the right:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->16028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Cyan"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1661],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpIKwBAOQ/R/IAmOQ
EBAwg4j//0EoEUgwEikaD2QxjcqMytBJRgLIEv///z+IlhpVMapiVAVeFfpA
ltGozKgMnWRAKdFzVGZUhk4yiFYptB3LCADsDs1+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{101, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{101., Automatic}},
 CellLabel->"Out[1]=",
 CellID->173169589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21164],

Cell[TextData[{
 "Cells with value ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " are rendered like the background:"
}], "ExampleText",
 CellID->13963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "==", "y"}], ",", "None", ",", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"x", "-", "y"}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "Cyan"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24124],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt1zEKwyAUBuAnucCzU8ecJp06dugooZAMoSXN7n28hEez/wuFth6gIPyi
T/n9XEXPYZtuS9jmMfSnNTymeXz2w31F1DkRudo4CtYFq31YhNZZKcX6BcX9
pDlnURSfUvIxRo/0QEX1V4VN0S/hkdnsKCmbkgCilbJTlJRtSataKbvFKSkb
k+haKY83CSVle/Lzh3v/79wLzBIBxA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{89, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{164., Automatic}},
 CellLabel->"Out[1]=",
 CellID->180834107]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27770],

Cell["Plot a sparse array:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->2851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "x_"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"x", "-", "y"}], "]"}], "<", "3"}]}], ")"}], "->", 
        ".5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13997],

Cell[BoxData[
 GraphicsBox[{
   RasterBox[SparseArray[
    Automatic, {10, 10}, 1, {
     1, {{0, 3, 7, 12, 17, 22, 27, 32, 37, 41, 44}, {{8}, {9}, {10}, {8}, {
       7}, {10}, {9}, {7}, {8}, {9}, {10}, {6}, {6}, {5}, {7}, {9}, {8}, {
       5}, {4}, {7}, {6}, {8}, {4}, {5}, {6}, {7}, {3}, {2}, {3}, {4}, {5}, {
       6}, {1}, {2}, {3}, {4}, {5}, {2}, {3}, {4}, {1}, {1}, {2}, {3}}}, {
      0.5, 0.5, 0, 0.5, 0.5, 0.5, 0, 0.5, 0, 0.5, 0.5, 0.5, 0.5, 0.5, 0, 0.5, 
       0.5, 0.5, 0.5, 0.5, 0, 0.5, 0.5, 0, 0.5, 0.5, 0.5, 0.5, 0.5, 0, 0.5, 
       0.5, 0.5, 0.5, 0, 0.5, 0.5, 0, 0.5, 0.5, 0.5, 0, 0.5, 0.5}}], {{0, 
    0}, {10, 10}}], 
   {GrayLevel[-1 + GoldenRatio], 
    LineBox[{{{0, 10}, {10, 10}}, {{0, 9}, {10, 9}}, {{0, 8}, {10, 8}}, {{0, 
     7}, {10, 7}}, {{0, 6}, {10, 6}}, {{0, 5}, {10, 5}}, {{0, 4}, {10, 4}}, {{
     0, 3}, {10, 3}}, {{0, 2}, {10, 2}}, {{0, 1}, {10, 1}}, {{0, 0}, {10, 
     0}}, {{0, 0}, {0, 10}}, {{1, 0}, {1, 10}}, {{2, 0}, {2, 10}}, {{3, 0}, {
     3, 10}}, {{4, 0}, {4, 10}}, {{5, 0}, {5, 10}}, {{6, 0}, {6, 10}}, {{7, 
     0}, {7, 10}}, {{8, 0}, {8, 10}}, {{9, 0}, {9, 10}}, {{10, 0}, {10, 
     10}}}]}},
  AspectRatio->Automatic,
  Frame->False,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{89., Automatic},
  PlotRegion->{{0., 1.}, {0., 1.}}]], "Output",
 ImageSize->{93, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->23724]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(40)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->153527982],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16139],

Cell["Make all cells square:", "ExampleText",
 CellID->32666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "32"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22237],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyFkdENgEAIQ8FJdCVHuAXc/8+oR4SjFAhpGiAvhGNc59hEZJ/VhjYpykub
ehBM3ymin9SqjdqZlZ9ZevlZ0DsW9OKngQ/TwEebvTZ+fXeaj5n6y7/zfqy8
H/+N+F4R3yvie0X8im3cim3ceru+2/NJm7KNz/d53DhjBPY=
   "], {{0, 0}, {32, 32}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->32048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24848],

Cell["Use a different aspect ratio:", "ExampleText",
 CellID->2061226372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "32"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"AspectRatio", "->", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24404],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyFkdENgEAIQ8FJdCVHuAXc/8+oR4SjFAhpGiAvhGNc59hEZJ/VhjYpykub
ehBM3ymin9SqjdqZlZ9ZevlZ0DsW9OKngQ/TwEebvTZ+fXeaj5n6y7/zfqy8
H/+N+F4R3yvie0X8im3cim3ceru+2/NJm7KNz/d53DhjBPY=
   "], {{0, 0}, {32, 32}}],
  AspectRatio->Rational[1, 2],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{154, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->7048]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22133],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " is normally visible only around the edges:"
}], "ExampleText",
 CellID->13175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0.7"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "->", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6241],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{0, 1, 0, 0.3}, {0, 0, 1, 0.7}, {0, 1, 1, 0.7}}, {{0, 0}, {4, 
   3}}],
  Background->RGBColor[0, 0, 1],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{154, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->32514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12147],

Cell[TextData[{
 "The background \"shows through\" whenever an explicit entry is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "None"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "None"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "None", ",", "1", ",", "0.7"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "->", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23954],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwNABxogQDkP0fyAJj
kBAQMIPJ/yBUAyQYiRSVBzLkgAwgZpD38fFhGlU1qmpU1agqGqqyBan6//+/
4qjsqOyo7CCUBeVjm1HZUdlR2QGTJdSKb4DIMQIA9r9JnA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{128, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{128., Automatic}},
 CellLabel->"Out[1]=",
 CellID->406335879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3454],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " also by default shows through for values outside the plot range:"
}], "ExampleText",
 CellID->21658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0.7"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "->", "Blue"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{"0.2", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1721],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt178OQDAQBvCWlzDhQViZPMRFJAwNwWboo5+vNRjYDb6m9yd3v7lJO9nH
wck+9VK2qyzj1G9lM68YpdYY4xGSGfSKLoaPNSxw0pg13APJPqY5GoQWoTrn
EioqKqrPVYUGQnNVpaCg+I8IL0RNQUHxO/H+T7mn/trZE9WdjeM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{127, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{127., Automatic}},
 CellLabel->"Out[1]=",
 CellID->291746426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10688],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClippingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClippingStyle"]], "InlineFormula"],
 " overrides background color:"
}], "ExampleText",
 CellID->10466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0.7"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "->", "Blue"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{"0.2", ",", "1"}], "}"}]}], ",", 
   RowBox[{"ClippingStyle", "->", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16116],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt1zEOgCAMBVCQS7jBSRh18hCEmMhANMjs4MVrIRoHB91cPqHlp3kzSQeX
pzG6HLwzfXLLFPxqujnxSEkhxM7lW8GZONUqIz6qdip34yY/TjUHzam+McYG
CgoK6ndlL0VEEBAQELcof4eFgICAeIi3DejcmeQBK/Of/w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{130, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{130., Automatic}},
 CellLabel->"Out[1]=",
 CellID->126265801]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ClippingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30180],

Cell["\<\
The default is to show values outside the plot range in the background color:\
\
\>", "ExampleText",
 CellID->26429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24537],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2kFKw1AQBuCE8gbBIggiBgSLYAVBEAIiCHanm3iALEMxtAtRmm5cSC/Q
C/QCvUAP0AvkArlALtAD1HllHkqJnQfVmtgJJIRAv3/xOhPekMeo33l6jvrd
dtR46EWvnW47ady/9PBRzXUc512fRw7ez/FucepHeNT0/eJw3vDirvVUDQYD
SJIE4jhWYRhCEATQarWU7/vQbDbB8zxVr9cBf3IrwiphOBwCKQoVIEWhAqQo
VAAVhT+7FmXzymg0ApIUrbaWFK22ltTSal+JVA5pPB4DaVy1mn+C1i5E+0lt
MpkAiVxNmnU1NXkmYrXE6XQKpHJ1XPSePBG1+mqapkAy10mK3sVa9kT+SznL
MiCd6xFFb2XTIw5E3x49z3OgBK6vcLulPUnY7oTZbAaUwnU5bmenU3YkpUop
eAFK4noWtz80PasmSZJkkbRLSVyPs539SYqkLKfs44XrpLazS0koc8Ih07ds
J52ib49+vKIH2c5lRf6f8uk3Hct2jivqJtXzgj5hO3EVsVri5VLN285mRSuv
5n/pCrazU5HWkW7mdvsvU5eibF65m/O7JlNjIvyu8Pl9Hn3n534A3D6Rsw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{125, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{125., Automatic}},
 CellLabel->"Out[1]=",
 CellID->479464228]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18389],

Cell["Show values outside the plot range in red:", "ExampleText",
 CellID->9843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], ",", 
   RowBox[{"ClippingStyle", "->", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7004],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmjGOgkAUhiEk8xo6m6XSRiorbayk223cA1gSs0SLjRuxp9tiwwW4gBfw
AF7AC3gBL+ABdueRZ0I2m6zCxCD8JJDJJPN9FD/zT8FruFm8vYeb5TzsvazD
j8VyHveeV2s95diWZX3x/WTp8bce5TdP6cvhcX5Zn/phV5pVSZKoOI4piiI1
m83UdDpVQRDQaDRSvu8rz/OU67qkl0z0Wzig3J+SpimTSJNUgUSapAok0iSl
l41Bqg8pyzKmkSThQiNJwoVGkgSmDUFrE2273TKRJHMXIhX2CyZSYb9g4gDE
xyPudjumkiToln7og9oM6n6/ZzJJum7tmi7IzSUfDgemkySvTNN4oINujn48
HtlAkvmyndiBAYbT6cQWksRW6VcXFlj+spzPZzaRpLlqVyuYYLrWpB9sI0m6
iWaGCaa6mazcRvJdmTg3wATTNSbufZKkmzhPwALLb0tH0mzi3ABDuw1ewVCl
mUEH3Qy9a6CrQW4muV+xX0F9fOqgQieC2HbisGR3gVZf2rhE34BUD9Lkxo4A
5f6U//7Wlr++7R+m26gI\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{138., Automatic}},
 CellLabel->"Out[1]=",
 CellID->742732782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29384],

Cell["Show low values in blue and high values in red:", "ExampleText",
 CellID->12920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], ",", 
   RowBox[{"ClippingStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31987],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt1M0JwkAQBeCANViANVjA9GAJgl6tRzuwBM+eBAVBEAQPiiKKIpYgyROE
GdY/ko3ZfQPhySzGZObDRrvX6tSSJKk/rvQzaiM6Z9O01iYH/bRWJrtZLU02
s1qYxO/MTeJ+E5P43tgkzkeOHJpMXtbNcR5eH/PYik6c0kPR8y+rjzntRCc9
hO0B+9mLTnoI2wPmehCd9BCDh6PopIewPeC5TqITp/QQqgc871l00kPYHjCn
i+ikh7A94P2uopMeYvLwTHqIwcN7B/QQg4fP/xfooZoefts7PVTdQ757p4eq
ePCzd1efHsry4Ge/3/bpwY+HoveYV58e8vLgZ19F9+nhWw9+9lJWnx5cHvzM
/9/69HAHj+qtHg==
   "], {{0, 0}, {21, 21}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{138., Automatic}]], "Output",
 ImageSize->{142, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{138., Automatic}},
 CellLabel->"Out[1]=",
 CellID->39406103]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29052],

Cell[TextData[{
 "Map values from 0 to 1 onto colors according to ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1528],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUtIVGEUx88wxf8SITmESJC4KEYoIrBISnqbFiTmogdJOU2KRpLZtIho
EwQlShQxRbYrekAPMDSoNmmrFhUZBrWKHvQggwhiep3+59BWWkRciO/CmXO+
8/p9m3PvN/euzeTaWjoyufZspry2K9PZ1p7dU75qVxddyYSI5Cn1pUJbabmY
i1fSbL/kOH8Sf+XFR4oukEh0EHqAtkyD6FHKMcoWXGRc1mskBWUsA9Pv6Hsu
tq5AsUqkc5ij3Vx/SgZKoMRDEd3J6LPIuqsUsJLVojORZqzadlAiyFqnMdtB
L2PnoVdoF1ibUmxlTAathtS3EiiBEhdlAzNqlZR+Zubx3ckn0UjadZ+JIsol
xhswl7E6+h5Yzn3GngqWGEXfoMx8OQ2UQImJkmfVmPDO3sSqLOfgFrOHrXuL
PxWkSNFinV7bTPTR3wHtttmZjbu+o4ZomHqWz1lfoARKTBStExw2ShmzOii7
FctZ8cViMh1ym8SpvPP7Xf80pQr93r0KNZ7TF8lixXyfrYOBEigxUZqs4ggp
OhF6T7CO2c1WcY3+yCrZKcF5ecUdTKacUCeLjlAuMJ6LVjjhEHTjeGeYQAmU
f00pYcYUmxf9CjnH6mWKq1Y1Q7Cf+onPRivjaSwy/3auB6jTNisP8cKeCvOM
shryfrwzTKAEyv9BGaWk/dz+GWdp13rXD+hmx5SffirsVBTxGYRSnz5OYw91
r+AHc0dYe8NqqhVnJFACJS6KaDEqbV5+Koas6zdKo3XfBOk0naI8iix3QP3f
Ktf1/n6mx+1t0Sjrlro9IVACJTZKK/Ql56VEcdPP8Keww/VeaI3FKyGT7D3N
Ztzx/H2UDB67vQYypFEz7YU+S5cDJVDiofzpq+Pvr5eJX/bZHuY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->24415271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1472],

Cell["Use a pure function as the color function:", "ExampleText",
 CellID->29193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"#", "^", "4"}], "/", "2"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26958],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmT1oFUEQx+dyyqwfeRGCqFFMkIBRCxHjB0hAMUYbPxIQhEDg5SG+lyBK
8lCwsBCL1Io2RgRB0BR2WiqoiAhiYeIHiCBYWIi2FobxP7vzeKWIhAOZg//N
7Ozc/K64vdvdO1yuV0+eLtdrlXLXwYny2WqtMtk1cGYCoTwjouvQkdUEX+BF
aQhHrn486ApO2T9FGZX5sVBQK09Su1Pjb4nHYTnlBFlMTHKI32h7FXQj5Uob
+s7B5tAY5U5xSjEUkkcsc8hsQdYANKmxGssGKsUqS+wO1kLfoBIUoMzoe4l/
xTpVJzhhgQly0TKPapakK3dC64xwzwhroEtxDKT4TQroUN8re+W/rTwC9eLq
DthpaIp4VOP9pM82y24j98E+iD7uoLv5zGfa/sLS6QQnLDhhOfEpzBtIpli+
pgqyrVlNxrXCpyDX4K+02HGzTDpfCPIhjadhcYpTCqPkNhZem/+KeLPGMeOV
fUoYYlmGfu3Tt/0OaJPGR1mWwm9HX8x7yTLrFKcURtlCOtsNsgK2QvZWf8+y
Ff4gtJ34ua71WuHXbZzo+OilNEseRN8w7AvSeYtTnPJfU2439ja6id/FFeEP
HoEdglq17wA1vyH3oatG+q65t1ieGSV9j5zilIIocgFahMz9xPPaPq9XP+Q7
tsMX90r0LtpgNzbG01PoJ8se9UsBK9jGHolTnFIQZSyOkbtBjiGrwyp/htYn
/4TSLoMyA7uLONLaKc7xSXp0Hybo10E+kq4fnOKUYih/+tNnfwyz3yG88M8=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->459131135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376159212],

Cell[TextData[{
 "Use a named color gradient from ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->627316388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Pastel\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302081367],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmU1PE0EYx0s4/OcjeOTT6Em/AyEmcvAlQNQY44EbJipB3S1QSgGLAaUU
CGBBEGhLoZa2vNNCKZS29L27O7tcdWbrlXgwpImZSWYzmZ2d31z+z/yfZ+82
dzy4/7C5o7WluelOW/OTB60t7U23H7exqcYGi8UisX7vloWNf7GR2fkUa418
bDZLD3s0/NMstnooCpqb2CIadvIhnJTXcFRah3Eho7xsg34koXuDEv1YQlab
RVFzYd+WhFHqw5uAhs4VhZyPe3CVk2GcyY2CIij1oWTdX/BsoULojozQO4rS
90GoP61Ifl5Fbtppfq3ST8T7QoVeqVG9zxUc2mPQTyQkq8ukuOAAVeywbumC
Iih1oujVAVB1kFwVrLjUZnBQ3DC1Es1F4EmcI5COYSaeIWdjSzAyMqre3po2
0jL4ybp8GjuBguVkElrkOr0IiqDcNGWzS0Os5CdsBYqeIaQnpmEUemEk2U6n
MjuFneuCcJ2UFgexfhFHRp2HfighfLmNvf4UCWYOzJvAfXQpKIJSJ4oWrUV2
Tnk0W4Zzt4xAp2rqhr+juxKUgJUknH5wzahBKyp0DMHXGrjGyksDJDfjRH52
BGmXW1AEpU4UdyzLIr+DvFyqYu08wVZOQT+QQDUHIh8pyj9sMFIyUTetJvXQ
HkeZjsPIshPsSTDOZRIv+1Bh6xKVFUERlDpRzEhf6iM9mxSnoz7uQ6DRIWRc
boQ/sJxzbhjMbZPKSj+L8hfcuUOPMQ35esHzSW/qhByPhDAdzyAz6RIUQfm/
KaqHux/C7hCk1EXTu8eHw9DCMndQmD1Ow/9KJVFJRXWtD08Zhd8ndFs23VF8
OELY7tz785qOoAhKnSg8E2VennDnw/29J5HCVd6KEv3KcgCHWXcpzI2Q90Fq
OqPOVQV5RslOTmCrm+JyaowwzZjuyX9xLCiCUicKr7lQxU72bWc4HDyCUeyF
Qp2wR1U4ogqL7ovoC9dq49z/8xuiMD+M3PQoonIVzGGR9m8VswoZenudXgRF
UG6Y8re/jn/+Xjb8BrceC0o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->45508453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28983],

Cell["\<\
Show elements with value 1 as black, and all others as white:\
\>", "ExampleText",
 CellID->5987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "==", "1"}], ",", "Black", ",", "White"}], "]"}], "&"}], 
     ")"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10823],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmrEKwjAQhlM6tDjUSXFQcHfzCZzs5OpeiqCDKNUX8AkEB19XL3KBQ1IV
WyQmf6H+l+Ty/aBHekIXxXG92hbHTVmM86rYrzflYTzfVTQVR0qpq74HiuIb
RY9bT9EV6/hxqQt9RI1mEwoTClLSHqkZy3kzNuspawfEwIknsSP2PkOv9J++
t97XvwRIoZMq3tGvrTifMmynjE1frX9+vsEBDk0cMpGRkWashpgJBclXkq2O
ZOfUbgWDDLImLzlzquqepT5ltNdPgfS/pJwzZrV1ElaGPEVc/fcPoqtE09nI
Tkdr92ks8+x1CNL/kj7pRNrvgeAAh28cJpwp1V7XIWe62LuB9GvSiHcMWUdC
saPpDh9OUzjAoS0HF3tbkH5N8qGS4RCKw7m2jl1eeffmFr8BFt0B6XQwYg==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->139948800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14520],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the values are first scaled to lie between 0 and 1:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->30503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", "Hue"}], ",", 
   RowBox[{"ColorFunctionScaling", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13472],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWrFqwzAQvZDBmtytlNBA9m6F7J2aqZCpuwmFhFBa3PxAl6yFDt39H/6P
/Ed+QJXOkiUnkZuSBjfOMzinu3u6BxfpfBZ+SBbTp+dkMZskg1GavE5nk7fB
/UuqTN0OEX3p+4rUWKoR39qkrq4e80Wf6qdzkDVSkSM5JsFyTVEuWY+sriXJ
lfB17WdcoQulx0p2wQCGozK88wwaR2eBcPnMXB7nzq5yuSzz7ds9vPJl1g4W
sLSZJS121PoyuKPahNiqtmXOuMoOa/05SVttbXUGC1iaYYkZlZlZknd9zDMy
1oUZs21OchOPqIi6z/odl3rUkxW94u8V69Y9dxwOLGBphuWRK+5Q3spQP9Am
hMuZ3uHmuVL2hWuyfSHnlJZeLh1eeHiwgKUZlpFG0UreBdf6eSG2qmFerZKm
s1xtVVMPJzwcWMDSDIvtQG2XGhfo5YWvGymUPXyqiUinG6m61n75hmz8R34P
BwtY9mC50d5eVQIZ/i8CJ9l+1xg6yfbsYAFLMyx97VUdz7WR/Q2JWceaVVuv
Pb3Of+BTAyxgORmWnd26kju7dSMRqW2Rqmtp423ek3X+A07zwQKWP2L5CK7x
/+z56atS83Vq5xu/4REU\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->396529706]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorRules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1932],

Cell["Specify color rules for explicit values or patterns:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->4953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"2", "->", "Blue"}], ",", 
      RowBox[{"3", "->", "Yellow"}], ",", 
      RowBox[{"_", "->", "Gray"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10824],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWNsNgzAMjMQKXYBJ2KEjVOo3KzMCI1RV259IjvMw8jk9Swh0nC62MbFh
fez355JSun2P9/XHzi1V2Y8n8Y+t7Wyl78XP7WyMv1ffyn/imLjVc5R4Wh1J
/FE/JX2v/UHTR8kPWn3+G+61r0o8r3qjvq2+huf3e9et1Wn1pzfeUX9Q86xZ
bV8Z5Vv106v5UfKJ1o/Q8Fm/OySe1X5ozUebV9HyI/k7G848lHlR+qlXf4wS
79VzZvR5NVpcmnm/L9S31Wd/LONR/LSaDzV+brP/70XzR7o/invVOdct8yVd
6s+hH2XOpE4fXrse+TH5xKPjL7Mfdzk=
   "], {{0, 0}, {20, 20}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5033]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30057],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " is used if no color rules apply:"
}], "ExampleText",
 CellID->15665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{"1", "->", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2732],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWFFqAkEMXfAKXqBn6AFyB48g6G/PozfwCP3ul1ChIAiCH5aKtNiPHqHs
pl8Z32A0O5u1CchbniHzkh12MnkYP40mg6qqhn+/+pnthyphq9favkki8p/P
avsiifzvZ4K28VN/tj2dx9vj5/Wn+drGR/kiQ/7Be+N5XyxIojYO2j+PjZ0S
1O63aWNHkqjVw/m9J9iVHqv6cB7PJFGrB/kHX4bn9/9CEttet+3zURuf8/4g
iX3Rz/GWJLEr/YhH3598nLTfuC6OVk+6rm1eiH+j81i+zshfu3+s/BkPAMvr
Qf5c7zVJ9FZP5B88G/dZG5LoTaeW1/aH2u+/tl9F8W371S1J7Ht9kP+98vwe
diTRm862edvv/+3zq+vOl8vnV/8tX8SX6Xu185x0vhF55Xlv90euU3/vv970
d8Wj+1HotOX7Mn8OPXk9yN+Wv3yuEuuWWdfb+RXxy5y/3vrMiJOPg3hv89Lw
t/UP/j74XxXcmWI=
   "], {{0, 0}, {20, 20}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->12280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25167],

Cell["The array can contain symbolic values:", "ExampleText",
 CellID->16966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"Permutations", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "->", "Red"}], ",", 
      RowBox[{"b", "->", "Yellow"}], ",", 
      RowBox[{"c", "->", "Blue"}]}], "}"}]}], ",", 
   RowBox[{"Mesh", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25690],

Cell[BoxData[
 GraphicsBox[{
   RasterBox[{{{0., 0., 1.}, {1., 1., 0.}, {0., 0., 1.}, {1., 0., 0.}, {1., 
    1., 0.}, {1., 0., 0.}}, {{1., 1., 0.}, {0., 0., 1.}, {1., 0., 0.}, {0., 
    0., 1.}, {1., 0., 0.}, {1., 1., 0.}}, {{1., 0., 0.}, {1., 0., 0.}, {1., 
    1., 0.}, {1., 1., 0.}, {0., 0., 1.}, {0., 0., 1.}}}, {{0, 0}, {6, 3}}], 
   {GrayLevel[-1 + GoldenRatio], 
    LineBox[{{{0, 3}, {6, 3}}, {{0, 2}, {6, 2}}, {{0, 1}, {6, 1}}, {{0, 0}, {
     6, 0}}, {{0, 0}, {0, 3}}, {{1, 0}, {1, 3}}, {{2, 0}, {2, 3}}, {{3, 0}, {
     3, 3}}, {{4, 0}, {4, 3}}, {{5, 0}, {5, 3}}, {{6, 0}, {6, 3}}}]}},
  AspectRatio->Automatic,
  Frame->False,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{154, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29926],

Cell[TextData[{
 "Implement a \"default color\" by adding a rule for ",
 Cell[BoxData["_"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "Blue"}], ",", 
      RowBox[{"0", "->", "Green"}], ",", 
      RowBox[{"_", "->", "Black"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21479],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw2IKwBAOQ/R/IAmOQ
EBAwg9hgwGAJJBhRREFKhYCEMJAWBgoxjqoYVTGAKhhAKv6PqhhVMZAq/o+q
GFUxQCpQ62loHc4IACesQFI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{61, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->264692365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29703],

Cell[TextData[{
 "Use any patterns in ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"_", "?", "EvenQ"}], "\[Rule]", "Red"}], ",", 
      RowBox[{
       RowBox[{"1", "|", 
        RowBox[{"-", "1"}]}], "\[Rule]", "Blue"}], ",", 
      RowBox[{
       RowBox[{"x_", "/;", 
        RowBox[{"x", "<", 
         RowBox[{"-", "1"}]}]}], "->", "Black"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->18833],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwuICwBAOQ/R/IAmOQ
EBAwg9hgwOAAJBhRREFKRYCEGJAlCqQZR1WMqhiSKkBJXgRIiKWlpQFVMIyq
GFUxXFUMljw3qmJUBYWlNkqrBNpiYQQAMxad8w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{68, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->3311126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22910],

Cell["Rules are used in the order given:", "ExampleText",
 CellID->3240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"0", "->", "Blue"}], ",", 
      RowBox[{"1", "->", "Black"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21027],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwhACxpQQDkP0fyAJj
kBAQMIPYYMAQACQYUUWBlAmQkAbyGEdlR2VHuKwUkJAC8qSB9KiKURWjKgZc
BUq9Ba3TGAGNuSis\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{84, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429192562]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataReversed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19251],

Cell["Reverse the order of rows:", "ExampleText",
 CellID->27318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"DataReversed", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12081],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiJAkGIPs/kAXG
ICEgYAaxwYBhA5BgpIFoEJDgBHJDR4isF5CQBHJ9R4isE5AQAHIFgTQHkHYd
VYVXlRVUFQeQVgTStqOq8KoygqoS+A/JdRLQ0DUdVU0T1VposQKiJYC07qjq
QaBaEUgIQuMSFIeKUBoWtyqjugaVLkmoLlCsKjBA6gZDIC0zqpomqkGyyHUw
qKwDtV00oXyRUV2DShfnf8zSDzmXgWIfVBryjOoeurpZ4Lr/o7ZEFKB6QGYq
YDGLZdSMkWAGxeMN0NEMRgCb2uYW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15392878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28103],

Cell["The frame ticks give the original row numbers:", "ExampleText",
 CellID->6358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"FrameTicks", "->", "Automatic"}], ",", 
   RowBox[{"DataReversed", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15238],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWVFr2zAQVqw4TgbtGCRru3RtWdlDoXQrg8EeNvYw1qf9iFAG7cNY6fpL
9tBf0v+n3Vkny7pIshyHNjAHovPJd59O0neSbP9Y3F39/LW4u75cHF3cLm6u
ri//HH3/fQtVciCEeID/za6AawVX5f9BKZCh8h2UGZjtg8xBZqTvefQhSEn6
q9L7DEusVuUPLl6jyKsaXVmiCGntdpOsXjJdLrW2V4pzZjdPj6GmD5m+w/Qs
0LoZwYOVWjXjmxbzTtVivbbFmPP+8PtO/2I9lsQZjH2oLCeMLsma3w8z8TmU
90JLKmvRHXbUnzF96wlb+Ztk9Q2KAtSL3npF689QzED96rUulF7ReN47Xpb9
ZD2ufOs+udKMN75fSJfMblJ6j1ltNIJIxupYJqyWtxlC43aF7ZmT89HoGled
UdVjXAHyFj1F+4l3Xj9CsQ3qttJs+OSd395r/V7vodgSmiVzkB+8XjhrPvY3
eUvy00zka2lGdznKOdWPmL1mHlrlqbE42Z5XkTTnhBetRW6YWpGKHVgVRLVC
4RxkHrQTQjPzPiV56pmLrELjPEhF8bOo917F+43SGYus2Sc+TEG+9XrjXelZ
caMoDv9ltf428z+KmpgH/lbQLIR+rGrrjONpd+l1jUHTnp06O/49fExtdUGV
wWydEwoyA/mG5/ZRjYcHzN7Pvx5l81GmhGL2CvQ+AcmfZbV36FSWiuKe0sL5
G8Kbqeb8ja870Ug7nk3XOQqbHTNnEXrxfWpG6zBy8gWz93OxR9k8FJ1q+ieF
fbvHeVQo98xZKPu0MKLMxX2oPKMvnZoNqm6sLBt5zfVWEfCnWm9r+Hp0gLJl
VOaJJCUas4/na49iM8fmMaMyrDJvEztx1rMWGlzN2qV8E3ZvnpPkLZn7/Fkz
kME94n+DeNhRf+q31/a9fPxrUv9NydX7b0q8f4/1TUkM/gHGQXri\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22628163]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->397656376],

Cell["Reverse the order of rows and columns:", "ExampleText",
 CellID->37924591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"FrameTicks", "->", "Automatic"}], ",", 
   RowBox[{"DataReversed", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1256446094],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1O3DAQ9uaHQBFIHBZQge5KRRyQQIA4IHFo1QNVD32IFaoEhwq05Vk4
8By8n5mxx5vJxM5Pl4UFstJ6MvHMNxPn89hJfo/urv78Hd1dX46GP8ej26vr
y3/Di5sxnIp7SqlH+I83FRxrODL/R61Blts+tAkYRCAjkNsgY5AqMd30c2ed
1Q7px8ZoHdsUoxgXckRbFVsdDz8LPfb1J7leRtgR+qEx26j1m1XkTXb2Ja+4
Udwcl92z6mhbZGnvKjJDLXD7itFNeTTM6UujaFw/0o5LmEOscz5GREeUW6J/
QNJ6h1i+Au2DspJaFnlZ6AOhD1vqy68Y5b6R1QU0Gai/OuuG1qm2dTIRvd+g
6YP6Q5xH28x4LrAeVYeQiXlEPhYpE56ynoRykTPPZKQWPVaoOpTvpKfCLg16
N8lF5pxORrdYLSpHqbKupJNRjzzZB3DI2lxViRln2jJjFeQqyHPR7+dT59Xe
q47huDJt03xAlFPR72f6bFBDFaEOLa8MnJuKuOp2VRzhROe7L25v2RpiujeP
AOOfA2M2oyx5tK8tj/q6yKcDYednYec9e+8Ql75qW3kzwYM9HeZU/brQEFWF
1onXioBmIeRdzeZ7wTOvG76VuTJTPjML875Qm9oglvb8S9rVgajtOIo6EE2u
VXIRnwccB1FyHdEGwt7P6A5l/lBCdQOrzj55c96Yp+D/rhsNUaeoG9NG4OMR
U/X14a1Tv3sifp8jMC0jJEcdN11VkmvbmrD3M71DmT+U4ptLt5pIDmUBTLk6
fSpxKmaoZo/rWacln6XeKrrEKUXCV749lG82m5iiNMlikeyTdzoWL5UNkdf8
3NrxfLOEv6O1geTsDuH5dgzyWdJfLzrEj4P41t/Z518jQt8suu9z00buvs9N
os3t9znVewKbHC+n\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91976504]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->781706421],

Cell["Reverse the order of columns:", "ExampleText",
 CellID->1319406549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"FrameTicks", "->", "Automatic"}], ",", 
   RowBox[{"DataReversed", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351150676],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1O4zAQdpukKaCtxAGo+NlWAu0BCQSIAxIHEAcQBx6iQkhwWO2q8Cx7
4Dl4P+/4r55Mx21CSCkllerx2DPfTJzPP0nuBi+PD78HL0/3g/7NcPD38en+
uX/9ZwhNUUMI8Qb/YVdAXUJN/9+kBDlerkEZg0ETZBPkNsgIpIh1t/25Vme1
Y/VjbbSuykRF0S7WUdmKyOiqukn0iOuPvT6OsEP0Q222MdWvqshd1DrLK84V
1+OiezY52pa1NHdVMUO0sP2E0U1wNJXTz1zRsH4kHZdUDpH0fGxaOiq5Rfp7
VhrvEMt/QPkqjLQlirxC9B7R+wX1lU+M8i+XVQrVDlQ6IFOQ21amdsRxP2Vt
jfjdELN7gdsDEhoHijVh1o1QTKUvS7o64Z1FZ2DWiomrB9ULRac4Y5HUJtpQ
8stmE9koebJoW/t4QcdiVtlY8uqf258+bpbgXc8EojO9YzF3AzFWiT2/XtQo
84fSCrBJee9bb8yeLsuetsZKsn1u3hdHZWZbMqMIeDwiO4oc3rrtd/NmMUeg
LCMoR/GpgDsl9Ig9z/QaZf5QQqxxqxHdhX7JMutITtQSs6iaCMoshLwn/Xk1
65mOEKOiI4zfEYzGt0V6Cl372PP4kpap9E/T78nOndLNtVJO7kvDQbqnHRA7
ntG1d/XeKWmlz3vH5P6fMvcf660KUdUMihmuTkOLM3MRvydzc5MinEg0p5G9
n4fcmsnmEVgrPwKjmlGmfDqTWR6dk36ehbVXca8Qvy+kWYuvSLvnNd4ZxDSE
FLPJ+xikaZwK5cJzqc1YKdWhXEp+b0yC3nlyoTnnPTtk8EqcuAM4ctIJ+1oa
htySdp5PtfXivbP3XyNC3yzq73NlI9ff50bR5vb7nGj8B0kwL6c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425406777]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Epilog",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17464],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " to superimpose other graphics:"
}], "ExampleText",
 CellID->17457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "4"}], "}"}], ",", "3"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6572],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 
   0}, {1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1}, {1, 1,
    0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 0, 0, 
   1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 0, 1, 1, 
   0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 
   0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 
   0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 
   1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
   1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}, {{0, 0}, {21, 
   11}}, {0, 1}],
  Epilog->{
    RGBColor[1, 0, 0], 
    DiskBox[{4, 4}, 3]},
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542262072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16922],

Cell["The graphics can be translucent:", "ExampleText",
 CellID->25756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".5", "]"}], ",", "Red", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "4"}], "}"}], ",", "3"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10867],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 
   0}, {1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1}, {1, 1,
    0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 0, 0, 
   1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 0, 1, 1, 
   0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 
   0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 
   0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 
   1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
   1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}, {{0, 0}, {21, 
   11}}, {0, 1}],
  Epilog->{
    Opacity[0.5], 
    RGBColor[1, 0, 0], 
    DiskBox[{4, 4}, 3]},
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216761815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9298],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " uses the standard ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " coordinate system:"
}], "ExampleText",
 CellID->25343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10.5", ",", "10.5"}], "}"}], ",", "1"}], "]"}]}], "}"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5234],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmLtOAkEUhg8uctnFWyIRG11jozEmJMZIY9RGidHOGCsDAXRJNBKkIDbY
8Rg8giUlJY9AZWFlSUk5nrnswnDZbDQq6Eyy88+e+b+5MLszG87TJSt3ny7l
M2nzpJguWPnMo3n8UMSQ5gOAN7yeYoBlgiV20RAmjZZZglfMfN8QncIsireL
qDrqplADdRNVR11EjYq4X7WiWhmTViKiFb2H6m11FXUVdVbRiv4ivSSeSOo2
UFeEe0fQy4r6t9SaoOwni+5a+6jryv3H3VtEPqfsc8y+31bUv6V2yeB5Q/eS
PeWeOPcB6X4r2OcC1SPlnjj3KZF3+DPl+jHXBZF30kvlGjPXNeH7YOoXag0W
m0cLwAstNmhWB7AAYlg0XGmdxRBt8z/RAjTTOgBlbg+70iEWw17qnNYZ3QTY
4PagKx20R/7O6QijcSAmtwc80DWGUnCG2JPnadqVDrBY0qHnGG05tH8knaWZ
RmIxiSShEGm37fpBKsOpRkNQC5yq1XrqR1KVikylUl4odEnU4aEX6urqM5Rl
yVQy6YWqVmUKW/FAtVoyVa+7UmK9Egl5vUyTdDqj1yvr9IUL26Vw/br1g1Su
b14zffPKDaVuOIW/NKcMTsXjYoQ3Q6lbpy8+wjCnymVB3Q6lLGderDvxvtO+
mk1alXeoe0aaAAWAZyxO0UwrO+/2HRffB8+OjF0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8041371]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frame",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2430381],

Cell["Don't use a frame: ", "ExampleText",
 CellID->84973523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "32"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181395948],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyFkdENgEAIQ8FJdCVHuAXc/8+oR4SjFAhpGiAvhGNc59hEZJ/VhjYpykub
ehBM3ymin9SqjdqZlZ9ZevlZ0DsW9OKngQ/TwEebvTZ+fXeaj5n6y7/zfqy8
H/+N+F4R3yvie0X8im3cim3ceru+2/NJm7KNz/d53DhjBPY=
   "], {{0, 0}, {32, 32}}, {0, 1}],
  Frame->False,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->71070408]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameTicks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24019],

Cell["Put frame ticks at round numbers:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "32"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"FrameTicks", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14062],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyFkdENgEAIQ8FJdCVHuAXc/8+oR4SjFAhpGiAvhGNc59hEZJ/VhjYpykub
ehBM3ymin9SqjdqZlZ9ZevlZ0DsW9OKngQ/TwEebvTZ+fXeaj5n6y7/zfqy8
H/+N+F4R3yvie0X8im3cim3ceru+2/NJm7KNz/d53DhjBPY=
   "], {{0, 0}, {32, 32}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{{{9.5, 
      FormBox["10", StandardForm]}, {19.5, 
      FormBox["20", StandardForm]}, {29.5, 
      FormBox["30", StandardForm]}}, {{22.5, 
      FormBox["10", StandardForm]}, {12.5, 
      FormBox["20", StandardForm]}, {2.5, 
      FormBox["30", StandardForm]}}}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16811],

Cell["Include frame ticks for end points:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "32"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"FrameTicks", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17405],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyFkdENgEAIQ8FJdCVHuAXc/8+oR4SjFAhpGiAvhGNc59hEZJ/VhjYpykub
ehBM3ymin9SqjdqZlZ9ZevlZ0DsW9OKngQ/TwEebvTZ+fXeaj5n6y7/zfqy8
H/+N+F4R3yvie0X8im3cim3ceru+2/NJm7KNz/d53DhjBPY=
   "], {{0, 0}, {32, 32}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{{{0.5, 
      FormBox["1", StandardForm]}, {9.5, 
      FormBox["10", StandardForm]}, {19.5, 
      FormBox["20", StandardForm]}, {31.5, 
      FormBox["32", StandardForm]}}, {{31.5, 
      FormBox["1", StandardForm]}, {22.5, 
      FormBox["10", StandardForm]}, {12.5, 
      FormBox["20", StandardForm]}, {0.5, 
      FormBox["32", StandardForm]}}},
  ImageMargins->0.]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3651],

Cell["Frame ticks at specific values:", "ExampleText",
 CellID->25760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "32"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"FrameTicks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "15", ",", "20", ",", "25"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "24", ",", "48"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17898],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyFkdENgEAIQ8FJdCVHuAXc/8+oR4SjFAhpGiAvhGNc59hEZJ/VhjYpykub
ehBM3ymin9SqjdqZlZ9ZevlZ0DsW9OKngQ/TwEebvTZ+fXeaj5n6y7/zfqy8
H/+N+F4R3yvie0X8im3cim3ceru+2/NJm7KNz/d53DhjBPY=
   "], {{0, 0}, {32, 32}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{{{11.5, 
      FormBox["12", StandardForm]}, {23.5, 
      FormBox["24", StandardForm]}, {47.5, 
      FormBox["48", StandardForm]}}, {{22.5, 
      FormBox["10", StandardForm]}, {17.5, 
      FormBox["15", StandardForm]}, {12.5, 
      FormBox["20", StandardForm]}, {7.5, 
      FormBox["25", StandardForm]}}}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->21271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16500],

Cell["Frame ticks without a visible frame:", "ExampleText",
 CellID->10955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "8"}], "}"}], ",", "0"}], "]"}], ",", "2"}], "]"}], 
   ",", 
   RowBox[{"FrameStyle", "->", 
    RowBox[{"Opacity", "[", "0", "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "1", "]"}]}], ",", 
   RowBox[{"FrameTicks", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31155],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1uEzEQdnY3paVJaUgplXpZqSocuPTCj8SlEqI9ICQuCCQujaq2qRCi
KlU5cOHEI/QJeE/jyY6b8Xjs3e5mUQ6JlJ0d+5vx/Nlr+/3oanzybXR1fjzK
Dy9HF+Pz4x/5wfdL05R2lFI35v93S5l3bd4m/xutDfWfA/NMDaBnaIYU+AfQ
Cy968lOr2N43NDF0jfXb9o2J1oest0d4JWjvMZ5rX4FHNuULOzwNDmIoWsLl
+Ej3MQ7cQt8CLrla0QJJLmEeQYzW72xBL5oDCS1JryGNVUIVP32cpEmqJcky
V1Mo2wPmQz/gQ5/0U5xbxaE5UzyHgs4Yz70qw5fxgzmyAjL5WxW0PqfSgsBv
GXuWMCPY5eT8HmK6XjUkddBkdMD8wab/P7rse5MYr+N6ItHtuUbZuMBzuURi
k9VmMiMNCWtdKtHymOE7ohYwaxjRAhTgWSVt9WzyazSm41GodrNp7ZZr2US/
krmuO0DlhsuRPmu1lc9+inii42sQxe4GM9RcCpK8Q6RymkdBOhV82UWZ1PFa
48zkXsszMRE8eIrt05pqK3dQIXtIX7faauNHe5478UtZjLoM/cpQOA7AXO/M
SAIiPCQSe2hR15PkNU3HeeHWtLBCU2S8Dij6pVcHbeVr33DvGnHSCg69h6w9
vN6H0RnGBhBvdXGisV9DdXvCgJy9MXRfk5lM+t3s2DyCzgMxf2HE3axvEl+6
kn9ptZXOT9vzUVeZnxb9WVedn2EJvmulO4oPxJp4LugYn8Sc1PClND5t5is3
3NdGnJ1D0HKinTmE+x3tfE1PSYTULVaKNqDPKkUZpOGbe6RDq6yUF9A/9itF
3AOAZ1XOI9ZD9zxSN8qQq1+NOHnPea3p3jJU6T/F2If25xe6zj682hizREvf
22svY3ViPR93DAsrplbEb6YWd7ouv7jTXdzphu90VecfmxYAwA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->324874581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650],

Cell[TextData[{
 "With a mesh included, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is required for frame ticks to be drawn:"
}], "ExampleText",
 CellID->6688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "8"}], "}"}], ",", "0"}], "]"}], ",", "2"}], "]"}], 
   ",", 
   RowBox[{"Mesh", "->", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5939],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM1unDAQgGeBVm3DJk3aQ495mvbUh1hFlZJDlSrNA+TUR8hxT33PrQ12
AWMvxpjxGI2lxRj/8DEM9jBr8/3wfP/j5+H54e5w++3p8Ov+4e737dfHJ3Go
3AHAq/j9/QJi/yT2mt/r6STi8fZabEtRoBZxpWKZvpK5cufUBLhQx/ciLkR8
aeTr45+bVm+M3LqXBkvrtZE2W38vN1WXbjlGLQxKfLKSmPXMM31QcjAJxwRm
zQtPAlu9wrgiKaOPswnqs/fAVtpW+1LF5zTB5zrH5Wwt2XTJRjZsyXW3r41r
2DuuYd/L75cbarHrmXkntn+gjdW217aZNjXOqrkzyk+lzfO/zZjy5Xg8Fu6S
nQaIclfyoSnFDrRhP5GuZ5a3piuRVlwDfWCyjZBB2UYyvCFIKfGKDnPQJ1YE
eYshkz6SM7mhIeXCM0cjBx1YR5KTZ9WL0O2NmWxzZEutPVWutS8tDCq/nsif
qt/kz5Muk2VHpvtpuT3TTyejbPB6T8dwdMmL2nzSS4LklcG4c5I7rT5sdtDB
nz0PqXtbf8m43XZrG/XuCzFyrcEtL93+mck2Rxbb22cyTV2DZ/0A6TJZdmSB
7+lolJE8OWi80T05BMm9/X1rs4MOLnZJSlGrCyVFpdV+bzPJaN1vMwVRXa4U
26R1l4yQ+rjAZIFksb17c6/Bs34E25nJyJNNjH/J6Ibjn3V8IUYspSgnmknP
zG5j1N6evLW5QYcxt+d7SjJJG+8pYf5pVNogiy4ZsbdFl4yQ+ljAZIFk2LPz
5jDHtZeZjDzZjH+zkpEu/h+OGHkFUedeRaOVEq2gm3HV0snTRJ2Vt5QXdOhr
QNO44lZJiDpTLJqU7ZZdHrT5PnN0e2Am2xwZ9ow8POkyWXZkM312aHTRfHZo
xFF9dgmpvddbYDODDsFWRzIp262OPPUjjx6Dbo/LZJsjw55jhyddJsuObKb/
CI3O8B+pOdu9BDHe/ugM/7kX+DjQyP2tjWhz65aygw6LrOhkErdY0WvNwIzG
HHktLRp38FpaNELqIwSTBZJhz7bDky6TZUcWvOoNjXO46m2BnwaNeIX1qGuz
DzUg5npUglJn8nXJV5r3GI3a2/ZLRkh91CBO5m9hZfetPbqU3bcWXV9k5G+Z
2s7E3zLlb5m6v2UKu3+bCopx\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->703778151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26017],

Cell["Make the frame invisible:", "ExampleText",
 CellID->14932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "8"}], "}"}], ",", "0"}], "]"}], ",", "2"}], "]"}], 
   ",", 
   RowBox[{"Mesh", "->", "True"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameStyle", "->", 
    RowBox[{"Opacity", "[", "0", "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "1", "]"}]}], ",", 
   RowBox[{"FrameTicks", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14948],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM1ymzAQgGUMbVPjtG566DFP0576EJ5MZ5JDp500D9CnyNGnvieVkLCR
kECS9bNilhlLCCT5YxGrZVn4fnx5/PHz+PL0cLz/9nz8/fj08Of+669numm7
IYS80t+/L4Sud3St/712Hc2n6YGmW1qhpXktclb+wPayla5fyE5s39O8ovmt
sn/Y/rnv9ZOytx2Viab3Vimrvd+wpL6UOcekB6nGnZZEbaf+03shB5VwSqC2
3FkS6NpVyhExGX10Jmhnz4Gutq71rcjnRoLNcU7r6XrSjSUdmdyT6WwflGPY
G45hP9o/riePYtM1w9M7TZ9zZfWoluovlQ+AKNiZ/Hs6nXbnEtnSIuHLniUO
5daxvrEsGG+QahVUZMsztrwDRlgLzSEQJd30FhhrzygRViVTj0ZF03E9np27
vpQ5II6N3GMDtsaAqXGRag1UFpaZaLNf2N9e2f68305ySFUI1aBnWWrUs5kI
606+Y5FnhnKIK2XrG2DUjcK30VIzsRsttJTkkoWmSlzPXobELS21TMxm+5Jn
fIFGXYtRy1lh6mCkWgOVhxfN0KeR0bK9o+SQqhAqr3viRIRBvGiJWAN7SkBR
D/NddnLJSqsM7IwU2kge7Fwxkm3uNjKRmu822JUIbfw2gmvBEstEB1nvI5Ub
lYfXzJXRsv2VNixSAaWanbcykcnzVp+O5oYGGC3zyLCAJ+b52KyEuOocPGQx
qSXbq5lwW91HZJKych/h4+tNSOphfWWitbS+MtFB1vVI5UYVIZrMk+lKuxWp
gFJZP93JRGn3PK0Maua0CRYzFIiUGQWMa3geTM6R10GjyK6hnXq/RpSybcOW
YBFOgSSst8Lgk5Z5jcHUski1BqoIEWRpJIdUhVA5+cISkQXyhSWiDegLy0Zs
Hcufkngmlj9ahFggCesthfLGBXztAFOrItUaqCLEhKWRHFIVQuXkn0lEpvhn
RHwwT6Gxjp/ikDOztx8hEbWddTD7PDIl+cLzSGurJpO0NdZunEjBQLxB36lM
xOz5TmUiOsgzAFK5UUWIDksjOaQqhMrzjahEjPIbUd5+kES0Ed5NjEke891E
UBJH6njUUeLzAhFb2mmZ6CDPCnCpLhYRjG+SIcWFYv5LdvgNSLmM34DEb0Ca
vwFJNv8BzFlmaw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->388735625]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxPlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3495],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " to limit the number of elements explicitly plotted in each direction:"
}], "ExampleText",
 CellID->26419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"60", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "200"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14648],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdmYGNWzEMQ33dpCt1hFugc3arIuj5gDJIGH2RspQXfBiG4dBObOkT+vn5
+9fnj7XWn69nffxjt1HazN9c/J6PNvP35/IXdZm/vp7LX9Rl/n4uf1GX+Znz
2Wp+5ny2mp/7PRrNT35Pn/krSXIdOv2V/KQ3otLfcfjqk96ISn8ln/RGVPr7
nF1t0xtR6e9zdrVNb0Slv/d1tc0i08d8Em2zyPQxHkf7WWT6GI+j/fRGVPoY
j6P9LDJ9jMfRfhaZPp63aD+LTB/PW7SfRaaP+4v2s8j0H+WVV/tZZPoP3+9f
HM8i02f+Qu0/bPrMX6j9h01/wRMdzyLTf/h+/+J4Fpk+8xdq/2HTZ/5C7T9s
+gva6HgWmT6Lz678Iddn8dmVP+T6LD678odcn8VnV/6Q67Pz57wfUn12/pz3
Q6rP9uv9P4T6r+YZFzJ9fN93+w+b/sv1BxMyfXzfd/sPmz6+77v9h00f3/fd
/sOm765/lOm/XH8wIdPH9323/7DpY7yuyh9yfXf9o0zfXf8o08d4XZU/5Pp4
Hivvh1TfXf8o03fXP8r0cV7xPnT61f7Dpl/tP2z61f7Dpl/tP2z61f7Dpl/t
P2z61f7Dpl/tP2z6p/KHXP9U/pDrn8ofcv1T+UOuf/J+SPVP3g+p/tn/Q6h/
eB86/efVCT+qfdz5geqPbiPr7KPbyOFHt5H1vD7hbnUbAT9Q3eo2ss62Mtbh
VgbG8+q+biMQz6v7Mlh9wt2XgfG8ui8Dz2t1Xwae1+q+DFafcPdl4PdW92Uw
f+Ael8H8gXtcBvMH7nEZC57qcRnMH7jHZTB/4B6XwfyBe1zGgrZ6XAaL7+5x
GSy+u8dlsPjuHpfB4rt7XAY7v+5xGez8usdlsN/LPS6D6bjHZaBfiPqH7HwZ
2fpFdr4M9AtR/5CdLwP9QtQ/ZOfLQL8Q9Q/Z+TKy9Yuy+gddyHreuufLQL8Q
9Q/Z+TIw3kfjf3a+jGz9oqz+QRcC8T4a/8vqH3QhH/+f52j8z86Xgec5er6z
82Vk6xdl9Q+6kPW8754vA3Wj68jOl5H1D8f8x91Ckv7hmP+4W0jSPxzzH3cL
gad6voysfzjmP+4WkvQPx/zH3UKS/uGY/0Cy/uGY/0Cy8f94/vheSDL+H88f
3wtJxv/j+WOTjf/H88cme75b3I8b2fPd4n7cyP6eTf6P/Pnusg9a32CcXv83
rL7Rpv7BYPWNNvUPBvqJ6NMG9BPRtg2svtGm/sFg9Y029Q8G+olo2wbMB9F+
G1h9o039g8HqG23qHwzMB9F+G/C8R/ttYPWNNvUPBqtvtKl/MHBd0X4bmL9o
6z8Q5i/a+g+E+Yu2/gNh/qKt/0CYv2jrPxDmL9r6D4T5i7b+A2H+oq3/QFh+
aJ8/Niw/tM8fG5Yf2uePDcsP7fPHhp3/EffjBjv/I+7HDfZ7D/k/+Pmfsg9a
Hzm9vpcZU/9gjKl/MNBvjPEfyJj6B2NM/YMxpv7BQL8xxn8gY+ofjDH1D8aY
+gdjTP2DMab+wRhT/2CMqX8wxtQ/GGP9BzLWfyBj/Qcy1n8gY/0HMtZ/IGP9
BzLWfyDj88dmfP7YjM8fm/H5Y/MW9+PGW9yPG2/yf7zJ/bjxF7Xkkls=
   "], {{0, 0}, {201, 201}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388670963]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"60", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "200"}], "]"}], ",", 
   RowBox[{"MaxPlotPoints", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10171],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmitPA0EUhTfIajQJDjSaVKJbjSJBA7ZoNBosHo2Gv9AEQ5o0QHgVgsHD
lp4mnHA6+7g7d2jZpPnS6c7emdN53D27qzt73d2lLMvWJ5/Tk/x4aoPZ+Hg3
I1933uJkk+Nw+Xxr2Os3Hnd9+/jyY+1mwpF5nKuPta8r37cvVo5eOheDCd/M
44w6+ZWHU6IccVvXZ/ubrYdpe6y+f/9Pd+2Dzbzk1bxfIMdrqj/4zvGhI+J3
xwWPU71RD79vjI/b9rCXFzwH6zc1/phop3X7ub6Kj/mG+ihHPBDl3B7MH/xf
iN/0+FPjkeNjXUE59Kva/5COvN+o+mgP4uJ86Btr/DExbkC0i7/X7X9IR+gQ
Gr+4PnRE/djjj8nrI/7v0P5Ztv+h66j1U+noPf6YaD+vf9b9V+T9O8RY+29Z
YjwW1a9q/2fr0qe8a0D5HtN//DE5f5zd/hsz/UDE/dmOt2mcVMcfk9dHtQ/W
nb8hHTn/j53/1SXnjyhnHZuKz+PcK/+rS84fy+Z/dcn7/l8Zf0zOH2PpB6aS
/9Ulr4+x40NHngecz6b+e1P7R1GiHZx/8X0LyPt3KvW99AOV/8g+COvO7Vf+
X8h/tIrvTeU/cv4AYpzw+Zx/4nyVv6G+uv/l+Rry/7yp/Dd1vvLvlP/MOha9
/y3r/3lT+W+Kyn9U54f8P8XY+Z+Vjuy/KRbVj3VEvbJxvPUpqyP7byrfKPv8
iHVhH9jK//Om8t9Yx6rP33he8/ph5f95U+UPdfUDoaNaf1PLX6pS+Y9Wz39/
zx/t/T9vKv/R6vqx/D9vNv3+QSz/z5vKf/y5Pg4q//7X8pe6OrL/yPNd7bs8
X738P28q/1E9/2UfBuXe/p83lf+o7t9S9f+8qfw/dX6q/p83y77/mKr/582q
7z96tzs1Wr3/t+i0ev9v0Wn1/t+ic178P2/Oi//nzf/8xYafQ5e94w==
   "], {{0, 0}, {41, 41}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13302610]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3695],

Cell["Insert mesh lines between all cells:", "ExampleText",
 CellID->11223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3637],

Cell[BoxData[
 GraphicsBox[{
   RasterBox[{{0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 
    0}, {1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1}, {1, 
    1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 0, 
    0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 0, 1, 
    1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 
    0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 
    1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 
    1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
    1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}, {{0, 
    0}, {21, 11}}], {{
     {GrayLevel[-1 + GoldenRatio]}, 
     LineBox[{{{0, 11}, {21, 11}}, {{0, 10}, {21, 10}}, {{0, 9}, {21, 9}}, {{
      0, 8}, {21, 8}}, {{0, 7}, {21, 7}}, {{0, 6}, {21, 6}}, {{0, 5}, {21, 
      5}}, {{0, 4}, {21, 4}}, {{0, 3}, {21, 3}}, {{0, 2}, {21, 2}}, {{0, 1}, {
      21, 1}}, {{0, 0}, {21, 0}}}]}, {
     {GrayLevel[-1 + GoldenRatio]}, 
     LineBox[{{{0, 0}, {0, 11}}, {{1, 0}, {1, 11}}, {{2, 0}, {2, 11}}, {{3, 
      0}, {3, 11}}, {{4, 0}, {4, 11}}, {{5, 0}, {5, 11}}, {{6, 0}, {6, 
      11}}, {{7, 0}, {7, 11}}, {{8, 0}, {8, 11}}, {{9, 0}, {9, 11}}, {{10, 
      0}, {10, 11}}, {{11, 0}, {11, 11}}, {{12, 0}, {12, 11}}, {{13, 0}, {13, 
      11}}, {{14, 0}, {14, 11}}, {{15, 0}, {15, 11}}, {{16, 0}, {16, 11}}, {{
      17, 0}, {17, 11}}, {{18, 0}, {18, 11}}, {{19, 0}, {19, 11}}, {{20, 0}, {
      20, 11}}, {{21, 0}, {21, 11}}}]}}},
  Frame->False,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15800],

Cell["Insert 15 row mesh lines and 5 column mesh lines:", "ExampleText",
 CellID->24407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Mesh", "->", 
    RowBox[{"{", 
     RowBox[{"15", ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28134],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtPG0EQXnJGGEcG5GDZCCzOJBJOR0kTiSqhiWjpwEKRoIhskUhIafIT
+AmUlJQuXVJSRS4RFSUl5eWbx+K7xQZDbOsCe5LnZmZ3v1nP43bO8LX+c//b
9/rPg716+OWw3tw/2PsRfm4cQhVMGGOu8PlVNuAjcPy5iiLc79Ma0aDZbLbb
bWKrLG9vb3c6na68trYW8WVClq+vrzc3N7vjFxcXu7u7xK4y6iToPMzO8iiG
Tk5OmAXJQT/PwsbGhlotqH6S9bRfsUbzP0LMKV4xPs9bedVWMjwFEEauP0QC
gaShNy/uG4/HCqEXjfVv0opdVVRrOfZ5GIaKvASybHeYSqTBsiaNO/dIT4kw
TqREhM/OzhIRXojhvXVyYFHxphnp8vJSTOlZh3koMbs3WrvgEVONmImN4jIF
ELaAu1hAf6NjiyBsgYRgfX09m80SW2UZ8+bm5pjVtfMs9Dx1oGQruIuV4+Pj
Nl9mEYStkBCcnp6Wy2ViqyxjHgwxq2sJY3JE3vkQySmQ00pzT4s8yCcj89I0
241qBYRX486rOTJgdDwPQquX+0ZsGUpGwJ0ROARgNGp5EEa4i0Z6vDF6T+OJ
qp6UWkDK1mo1WwvW8yZAgUg5GSocelbPOpEoqd4EUly2JkmXcepsheVWq3Uv
Wu85OngNOTo6srVio8cIUm4mC8K7cKJZUj1/E9UVVJdx6nCF5dvb28Qu5N0p
eVZZr8b7sGwkZ9as4+VSdP8ssz1bPLuJXfUWX5BFX1FprSh68hWdc3Uq6vag
dL7OvEIk8d75+XmfjM1rTxXvpab0JM5pTzXTMxOBmcgBsYTM0AyqOlmZ174q
3k9N6Ymd075q5lnZlgY//w9IpSjZg1Z4HP2mkWsan/IDWdTpdPpkUcnpzCu2
C48j98wit597LItKTndesZ143FLPLLq5uXkwi57vHY/ks8h6R97ZaFNyFUy3
W4+fbuFAvvZog6Hd9WW/+TJVIpQlW1tbXRkocXToBB2ppOtCnrezs4OpxK6w
DNwe2YVMGIk1n2EjRov1otSj9nqHpr7zsV9j4pmHWY/lAsJMbBaErbIejK7L
g7BV1jcaDUkTXT+0jBzqLvCtB8vUoXrcW0mnFV8Jg1cCvdtS3/5uKPHzaMPJ
yAIIoz8r5uO1lma/jxeN/oqYeA8ZI9pTnzZLIIw+lgx7mjX3SZpmv3u0f0GD
Vl4ydFar1ZKf2FTu/s1dOmsMys/OOo7Fal1Q+/2Pmpn4CxWQ7tU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->80344429]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14812],

Cell["Insert mesh lines around the first ten columns:", "ExampleText",
 CellID->20641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Mesh", "->", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25304],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnL1OwlAUx4v4ATiYICQ6IB1MDIshcXExIQ46MctIQ0wgxkiAyYVH4BF4
BEZGHqEjI+EJOjLW//3Q20KrRIkx8m9yP84995zzK8PtvYemVafXfHx2eq2G
Y993nHaz1ejady8dDCUTlmXNUV5PLPR99GSZ+z7a1XpX1MnhcDgYDET3QMrT
6bRWq4luSsrlctmXl9ZDiSlGhjFcGNl13Xq9vr59v98fjUZGnkwm7XbbyJ7n
VSoV0e0FqGFlqesYJS3HMA3GIc96TkpUSeXG6MVvE5SX7XEboTuDEPJn27a2
F3dawlAGbQ5tHm0G7R6JSUxiEpOYxD8k3gGMeqIiRIBcytrL/hL1hdQrBKM3
FMI+pyMV0RbRHjEiIzIiIy5H1LtwIeelVyhDXsNzDiPJIlZEfVpQ8mw202QF
lCvt55REJCIRiUj0baLI3ar2lJUk4d1tSY6ZHWoW1Q2GzhmJkRiJkTYfKebs
HX8+x8Ko56jztFoo/Y+1FGulgrMKvtrjvp+rL0lIQhKSkIRbQ7h+/sRQivyJ
yMmKvMg1CUhAAhL8V4KV/EVE3jgmF5FGOfNVLuKWVKQiFalI9Sepvs7yROzK
A0+fKslIRjKSkYxkv0MWk0NSpOH/H0Su6IF0pCMd6UhHupg3sMXbMw7JSEYy
kpFsu8g+yb89kZSkJCUpSbeWVGpc1zUzF4vFeDw2kdUnC4weSkwxMozhwsie
52myTdt3JXXcNx6sxBtfqxU9\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->106792977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23162],

Cell["Use a sequence of colors for the mesh lines:", "ExampleText",
 CellID->12537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Mesh", "->", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Hue", "[", 
           RowBox[{"i", "/", "10"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18551],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3E9r02AcB/BnrbI/Mjxsgh7mepCJFxnsoodB8KCnnu0xZVg2RBxrL3pp
wRfQl5CXUNBDL4N4qadCbtZb3KC3QU5SCsLX35N0zZPULp0Xq/0Wkie/JE/z
+e6SPE9Yi+Xa4as35drRQbnw4qR8fHh0UC08f3siu/JLSqkzWd7fVbIN2QqX
M0DayfUNvc7DcdBs6s3lqA56OC3pzZWw/opdhJ/R8Xco+ejFdROnDjpx7QF2
dH7Uf/cDkv1L8HtG3a8jaBk13D6Ov5ieAJalN2umul5vqPCzrFd5a0e51bBe
CesuVOKqFVhduHFdx0fV2Iv7Kyu8xlitKkl1xULXNervNi4cU+18c5Qdf19B
/u6Fgj60KqtHsmtN2k1p70i7Ju1NpmEapmEapmEapvnjNDkJE10VfTedQpkp
d1yVlUK5btxfUiT7K3ddWXHdUE5WCj/qvyrL5ki+Le22tLeZgAmYgAmYgAn+
5wT4FI7eo/o3CdYtoxa+hIgFEi79ZJFOkPVkAfuzUfv+KMGWLHuy75a09yin
nHLKKaf8X5ADxjfL6NyQ5wQ+uttPjsrT4vTdv2je7W31dMqofENW+7LrAbXU
UksttdQupva64+9k/8l58bQ6/cwwUm8hGntfzoc/pp566qmnnvoF0OcEH50n
u7LmuLPUU+a4N1T03lnPbT+hmGKKKaaY4nkQX3c0PONctH6vex/RXPQziimm
mGKKKZ5HcbKfhawZ4Cnih7IUKaWUUkoppZTSWeZ6r3ifqud4X1JLLbXUUkvt
vGln/C8XPX9bppRSSimllNK/Kb1ivvU1pZRSSimlCysNj8DzjDN/DnDejq8c
oJW4cgftIQZx7eHcx0VcBwjzjPu3vKS808ZwYNQ/PAx9Ux4M9Y/5jfujdXn9
aqie9ruEaukXkDCmig==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->20282337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278954835],

Cell["Insert mesh lines after the first and second rows:", "ExampleText",
 CellID->8658608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268138055],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiJAkGIPs/kAXG
W/7/B9K4SBYgKQBUJgCkOYC0IpTmBNIKUBpZnnVU14Dq4oGKcgBpRSgtiKRK
EkhLAGneUdVUUS0CVS0IlZUA0pJAWhPKFx1VhaJKBqoKlopBqg2BtOwwlVVB
Sz2wXAwLJdVRVSiqdKCqkHMfKBXpjkhZ0/+IMp4TmqdAYWU2TGVt/6OWvXaD
XNT1P2qZ5zZoRJlBJPPbt2/ngQHDKhAB4v8HAwZGsCpfaGrzoxkP4o7Pnz9v
BwMGdyAhWV5e7gXiML969QrFPaA2T+Dz5885NTQ0goA0A/OfP39QVIRC000Y
nXiYLWIGRgCd6+Oi\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40867824]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31565],

Cell["Default mesh style:", "ExampleText",
 CellID->18938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27445],

Cell[BoxData[
 GraphicsBox[{RasterBox[CompressedData["
1:eJwtlPs/FIgCxWeUVzueYQlTiV1jXMy2pZSOthBJtm6lUFJs69HIs6lWaTeZ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    "], {{0, 0}, {20, 10}}], {{
     {GrayLevel[-1 + GoldenRatio]}, 
     LineBox[{{{0, 10}, {20, 10}}, {{0, 9}, {20, 9}}, {{0, 8}, {20, 8}}, {{0, 
      7}, {20, 7}}, {{0, 6}, {20, 6}}, {{0, 5}, {20, 5}}, {{0, 4}, {20, 
      4}}, {{0, 3}, {20, 3}}, {{0, 2}, {20, 2}}, {{0, 1}, {20, 1}}, {{0, 0}, {
      20, 0}}}]}, {
     {GrayLevel[-1 + GoldenRatio]}, 
     LineBox[{{{0, 0}, {0, 10}}, {{1, 0}, {1, 10}}, {{2, 0}, {2, 10}}, {{3, 
      0}, {3, 10}}, {{4, 0}, {4, 10}}, {{5, 0}, {5, 10}}, {{6, 0}, {6, 
      10}}, {{7, 0}, {7, 10}}, {{8, 0}, {8, 10}}, {{9, 0}, {9, 10}}, {{10, 
      0}, {10, 10}}, {{11, 0}, {11, 10}}, {{12, 0}, {12, 10}}, {{13, 0}, {13, 
      10}}, {{14, 0}, {14, 10}}, {{15, 0}, {15, 10}}, {{16, 0}, {16, 10}}, {{
      17, 0}, {17, 10}}, {{18, 0}, {18, 10}}, {{19, 0}, {19, 10}}, {{20, 0}, {
      20, 10}}}]}}},
  Frame->False,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->21228]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8194],

Cell["Make the mesh pink:", "ExampleText",
 CellID->14526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}], ",", 
   RowBox[{"MeshStyle", "->", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2178],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnVuopXMYh3/bnvfNhUOUGpF2EeVQIhJFCZMLInFBDttumLnANIaQNEm5
cUFyikIiam4wLpQohyi5cSynkFByuEAiLev5zf8/Vt98u1ysu/0+NY951GTN
b30X3/rW923nLW/btPG65W2bV5aXNmxd3rJp88qNS+fcsHX6rxYXJO2c/rpi
vaa/n0x/5187J5PpP/f0uql3TLZvX7e7tDjNP4wC0acZJaKfNgpEP2+UiD7U
KBF9l1Eg+jajRPQnRoHou40S0VcZBaKfM0pEv2aUiP7ZKBB9nFEi+gWjQPQh
RonoT40S0ZcbBaIvNUpEbzAKRE+M9qpVa9VatVatVWvVWnWNrzpynnW6USD6
MKNE9HtGgei/jBLNvAfZ34MjjQLRC0aJ6F+NAtGPGCWiDzIKRF9klIg+wyjR
zEbRN/rHKBF9rVEgeskoEf2mUSL6C6NA9LFGicaOkfEjt1atVWvVWrVWrVVr
1Vq1Vp3DqiNnr8MNHzRKRJ9qFIgenmFfb5SIftcoEP2YUSJ6i1GgmdeY/fU8
ZRSIvsQo0dh/7zKjQPTnRonojUaBxo6J9okm+yeatmn0TT82SkQvGgVa/cit
VWvVWrVWrVVr1Vp1za06cp71klEg+hujRPTfRoHo+4wS0Q8bJaK/NgpEP26U
iP7AKBA9vLJ6plEg+lmjRPQpRonoZ4wC0ecaJaJfNwo09p7eapRo5piIfkzs
a5SI3t8o0OpHbq1aq9aqtWqtWqvWqrVqrTqHVUfOXt8yCkQfb5SIfsUoEH2/
USL6d6NE9C1GgWY6ez9qFIg+yigR/aJRIPoIo0R0+0SQ/RNBu9Ib/Upv+4SR
/ROGdhFo5j3O/h63+wKy3xdwvlEg+iujRPQJRoFWP3Jr1Vq1Vq1Va9VatVat
VWvVOaw6cvb6m1Eg+mKjRPQ9RoHoE40S0cO7YH8wCjT2dxheL9+FEtHDTwi/
GCWih3fpXmAUiB7ed7DeKBB9k1EieviJqL2e6K/nbKNE9L1GgVY/cmvVWrVW
rVVr1Vq1Vl1zq46cZ11pFIhuVzazX9ls38tH/17+TqNE9NFGiWZec/TX/I5R
Inp4v+MOo0R0u48h+n0MDxklog80SkR/ZhSIHj4d1P589D+/YpSIfsAoEX27
USB6eJ/B/3uGq1atVWvVWrVWrVVr1Vq1Vp3DqiNnr+1Z9ujPsr9hlIj+3ijQ
2GavGiWi7zAKNLZRO0OPfob+pVEiun2vH/17/eHTQcOnjS40CkR/aJSI3s8o
EH2SUSK63feQ/b6H9okg+ieCq40S0ccYBVr9yK1Va9VatVatVWvVWnXNrTpy
nvWEUSC6faOb/Rvdk40C0e1pm+xP2+xjlIj+0ygQ/ZFRIvoao0D0WUaJ6L2N
Ao29508aJaKHT20Pz1VvNgpEf2uUaOw9ftsoED28A6BdeY5+5Xn8yK1Va9Va
tVatVWvVWrVWrVXnsOrI2Wt7Oif60znDZ8lfNgpEt59Qmf0nVLa/Y/a/4+FG
gejhs+YHGAWifzRKRA9/plG7Upz9SvHBRolmXs/un5j5k1Ei+jujQPT7Rono
4dNQw/sI2tNF2Z8uGj7dNH7k1qq1aq1aq9aqtWqtWqvWqnNY9b+z1z3/nzFa
+BfGldmn\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27294806]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PixelConstrained",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6928],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PixelConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PixelConstrained"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to force cells to line up with screen pixels:"
}], "ExampleText",
 CellID->4205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], ",", 
   RowBox[{"PixelConstrained", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15149],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5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   "], {{0, 0}, Offset[{201, 101}, {0, 0}]}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  PlotRange->{{0, 201}, {0, 101}}]], "Output",
 ImageSize->{205, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{201, 101}},
 CellLabel->"Out[1]=",
 CellID->15257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2728699],

Cell["\<\
By default cells do not necessarily line up exactly with screen pixels:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->5312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9401],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5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   "], {{0, 0}, {201, 101}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{364, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24727],

Cell["Use exactly 1 pixel for each cell:", "ExampleText",
 CellID->32692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], ",", 
   RowBox[{"PixelConstrained", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22353],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5
65+/fv3RWvv799+/bRoRvz8xH3z9n7+mg/nO17352jx5uRqxPOfztsyev75u
aYk8bXicM+bT+XZul3O9vy43bsZJ86IZmJ5sWn3ZKa9mbIHzyNnz0tpKBCRP
S7iYIUZEY4YjnIAMTgB4CZJkajqpS+4VUi4TXtPS5i0SkCou4Rq5/pvG/GeC
TIr0CMZP4URmc/gRmu5scmzID0lr+kiA8y0TwshNns9NLS5IMYa2HCBxVnwi
6nxcxEGIIRS6YqoViXKDAsFeNJ8yvpICPbwANVn1iQ+TxiJO06opuiRN8KaS
KVMEor1gvvA0kGKj5x0i2faJvWupJWZSaZvaetaP3tAuC1tdksF8XqsjhfIG
cQx8Yi4JN+crExlWQ4TNOcmUWdh6SLLmfQN7I6kpb6s4Bj5xJgCurkoazXBa
IuEgotMDSysme5h7ByJB5vU4Bj6B8xSI8qMx5lyh1YCU+qwPUZaWbvkV2Bsp
o4x3zq5rsuoTOU9L2XreMmeYF9EhVfKia4CX9WYqCUlO1DOWk01NVn0i3bVU
zuGWzqUuIOVctTacQ3Ngd9mmnGmB9bHrE/Nr71KcOuMhoAzVU0VycaJBwTwW
RRJj/o4mqz7xoXKE4iAzyItlkxrOcl0zxIi6u/LdZ87a7bHrkyTJGQ36kWNY
DeTJ88gZX6v57t0Vtc/gt30k2z4JxwK4rVxtGLa8sxar4ppZxu7BqFUdit8O
aLLqE8TC8BhZNHzSBmLIdEBZRaiPHtUEVwdFMRq7PgFdDo+RtcBHtQYq1izx
NT6IR7VNcO5YD2qy6hPRhfByjhUTw7xPgjplIUq08mgpJp57BMfAJ8mFttcc
KQaGA08pm8QrSasPCkQtJp57bOz6JP0YPlb+SRsYWrKlZq5BJq170Ou5bgDA
URwDn/hwObY4mYOGrwxyfLmsQXYP5lO6GdrNqL6pyapPHGMLwF2mg890r8FA
F1LjBzUZHorcLUn8ztj1iWIMwk2+G+HnUohP80SN7R/YUh4SHuP6gSarPonC
WAYaDhDpU8AUXZoBV246D4XX+64e1GTVJ33VySgUoCQsFim6hMEVbqyLVill
4idItn1Sq06CcYAZrsGUvEF9SifXSkBjV9l/hmTbJ2JMJasEGMRX48OJmBJe
E9e8CrP8p0i2fSJ7+xgFlPhQJfSVqqmccnWkYEHwUxwDn/jQ5Gm/gg9VwidN
E3MJGL+Uq4aVnkCy7ZNMNx2nSK3HZ8g6MUlaondcK/s/oUckOVs+yQy2BJaD
+Iw+T5aFpEaURaNcEDnPjV2frPQTp0NU9NEMSMUNTHeO82Xk6rNItn1isZTd
LJOJPgSApVjyKONsMgsAYp5H8q1+4uBSkJYAAt1A6iJwmYwCgJjnkWz7RCwW
RlHHUg+pwEqgNaBFUI8F3ktwDHzizMCxy5H0yJBKJdA5tKh6aJlXIdn2yUM/
CeFNWLxfK50MQJNlZuZ4GY6BTxyJjtUtlFZKtVLpwsSo6hqWPq9Fsu2TjuUw
0ASRkaI4o4hpkcbFWgDfS5Ec7idNQeYkE1AkEKK8hzlBYl6MZNsnFit8Ex5C
BQNwK4S8VLF4Wf9YQXK4n7hU1UiDVQCImJfZa1yh34Bk2yfJnUkV+ZUApBcQ
IS9Dq79FDwWZO/Q+yU6QYfleIaCklxBZVAv1Lj0WJNs+Kf1E99wcpJRjVx7K
GhDqbXoEQhr1E9yLcJLUAsAkTchqjO/UY9nuUD/xPTWHdI5Ao3QnWvWO9+qh
eGPcT3RPErIA6Exp5FLn4vx2JIf6CQSyIzK+JB9p5Nbzrv6xguRQPwm5OIUK
x5dFAGkkbG/3B4I40k/g4pztNLLBlYY2zUf00P6543Y/aWW6WgOqtNBXwT6F
42g/KdPVIFilM+5OsI/hONpPPB0NwiJaPEn6/v6xgmTYTzRUjvJJWchluJDw
YSTDfgJHRLWMCq7LcFrswziO9RPnWbVMc9wiQxY7A8mwnzRAdKYZgqyRWXoC
jmP9hBDVwg0BZHyyf/TjSD8hxMw0QMiqEInmNCSDfuLcYqbR6hGAdiaSQT/x
5Xl+B0Et5Uw95shG/QR1y9qpd2ROnquH4o29flLesgQBrfCk/tGPUT+pb1lq
jW6Fp/WPfoz6iV5EZOtYZuvt9wJ6TGPQT/Qi0iya9JhnXQPHqJ9EvojkgV4V
9fwZQa+O/X4S0R00vQ+f3j/6seeThoSSaVKjy/gjx45PgA4lyoXs3MAfxrZP
iA4t0IXsYmPTJ0F0rlzn/f4YjS2fFHThynWd/tGPLZ84cFcu6XTJse4TvJm4
hM3zzwx2d6z7BG8myrir9Y9+rPmkEZZ+Yl1Zj2ms+QRvJnp1v7Ye01jziTqK
O/rF9ZjGo0/Kjyf9Srn+ePSJX+cXgDfQYxqPPokC4B56TOPRJxXAXXA8+iR7
4vV+f4xG75PsI9fvH/3ofSJ9bqXHNDqfZJbdTI9pdD5Jp5wd1g9G9cmVf3+M
RusQ3FOPafQI7oqj+OSm/sgBn9xYj2nYJ/fGAZ+cHcjT4z6/P0bjvv2jH/8P
PabxERz/AVU1PXE=
   "], {{0, 0}, Offset[{201, 101}, {0, 0}]}],
  Frame->Automatic,
  FrameTicks->{None, None},
  PlotRange->{{0, 201}, {0, 101}}]], "Output",
 ImageSize->{205, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{201, 101}},
 CellLabel->"Out[1]=",
 CellID->27795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94429312],

Cell["\<\
Use a 2\[Times]2 block of pixels for each cell:\
\>", "ExampleText",
 CellID->26542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], ",", 
   RowBox[{"PixelConstrained", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22567],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5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   "], {{0, 0}, Offset[{402, 202}, {0, 0}]}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageSize->{402, 202},
  PlotRange->{{0, 402}, {0, 202}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{406, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104860292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->264472866],

Cell["\<\
Use a 1\[Times]2 block of pixels for each cell:\
\>", "ExampleText",
 CellID->12376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], ",", 
   RowBox[{"PixelConstrained", "->", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14255],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5
65+/fv3RWvv799+/bRoRvz8xH3z9n7+mg/nO17352jx5uRqxPOfztsyev75u
aYk8bXicM+bT+XZul3O9vy43bsZJ86IZmJ5sWn3ZKa9mbIHzyNnz0tpKBCRP
S7iYIUZEY4YjnIAMTgB4CZJkajqpS+4VUi4TXtPS5i0SkCou4Rq5/pvG/GeC
TIr0CMZP4URmc/gRmu5scmzID0lr+kiA8y0TwshNns9NLS5IMYa2HCBxVnwi
6nxcxEGIIRS6YqoViXKDAsFeNJ8yvpICPbwANVn1iQ+TxiJO06opuiRN8KaS
KVMEor1gvvA0kGKj5x0i2faJvWupJWZSaZvaetaP3tAuC1tdksF8XqsjhfIG
cQx8Yi4JN+crExlWQ4TNOcmUWdh6SLLmfQN7I6kpb6s4Bj5xJgCurkoazXBa
IuEgotMDSysme5h7ByJB5vU4Bj6B8xSI8qMx5lyh1YCU+qwPUZaWbvkV2Bsp
o4x3zq5rsuoTOU9L2XreMmeYF9EhVfKia4CX9WYqCUlO1DOWk01NVn0i3bVU
zuGWzqUuIOVctTacQ3Ngd9mmnGmB9bHrE/Nr71KcOuMhoAzVU0VycaJBwTwW
RRJj/o4mqz7xoXKE4iAzyItlkxrOcl0zxIi6u/LdZ87a7bHrkyTJGQ36kWNY
DeTJ88gZX6v57t0Vtc/gt30k2z4JxwK4rVxtGLa8sxar4ppZxu7BqFUdit8O
aLLqE8TC8BhZNHzSBmLIdEBZRaiPHtUEVwdFMRq7PgFdDo+RtcBHtQYq1izx
NT6IR7VNcO5YD2qy6hPRhfByjhUTw7xPgjplIUq08mgpJp57BMfAJ8mFttcc
KQaGA08pm8QrSasPCkQtJp57bOz6JP0YPlb+SRsYWrKlZq5BJq170Ou5bgDA
URwDn/hwObY4mYOGrwxyfLmsQXYP5lO6GdrNqL6pyapPHGMLwF2mg890r8FA
F1LjBzUZHorcLUn8ztj1iWIMwk2+G+HnUohP80SN7R/YUh4SHuP6gSarPonC
WAYaDhDpU8AUXZoBV246D4XX+64e1GTVJ33VySgUoCQsFim6hMEVbqyLVill
4idItn1Sq06CcYAZrsGUvEF9SifXSkBjV9l/hmTbJ2JMJasEGMRX48OJmBJe
E9e8CrP8p0i2fSJ7+xgFlPhQJfSVqqmccnWkYEHwUxwDn/jQ5Gm/gg9VwidN
E3MJGL+Uq4aVnkCy7ZNMNx2nSK3HZ8g6MUlaondcK/s/oUckOVs+yQy2BJaD
+Iw+T5aFpEaURaNcEDnPjV2frPQTp0NU9NEMSMUNTHeO82Xk6rNItn1isZTd
LJOJPgSApVjyKONsMgsAYp5H8q1+4uBSkJYAAt1A6iJwmYwCgJjnkWz7RCwW
RlHHUg+pwEqgNaBFUI8F3ktwDHzizMCxy5H0yJBKJdA5tKh6aJlXIdn2yUM/
CeFNWLxfK50MQJNlZuZ4GY6BTxyJjtUtlFZKtVLpwsSo6hqWPq9Fsu2TjuUw
0ASRkaI4o4hpkcbFWgDfS5Ec7idNQeYkE1AkEKK8hzlBYl6MZNsnFit8Ex5C
BQNwK4S8VLF4Wf9YQXK4n7hU1UiDVQCImJfZa1yh34Bk2yfJnUkV+ZUApBcQ
IS9Dq79FDwWZO/Q+yU6QYfleIaCklxBZVAv1Lj0WJNs+Kf1E99wcpJRjVx7K
GhDqbXoEQhr1E9yLcJLUAsAkTchqjO/UY9nuUD/xPTWHdI5Ao3QnWvWO9+qh
eGPcT3RPErIA6Exp5FLn4vx2JIf6CQSyIzK+JB9p5Nbzrv6xguRQPwm5OIUK
x5dFAGkkbG/3B4I40k/g4pztNLLBlYY2zUf00P6543Y/aWW6WgOqtNBXwT6F
42g/KdPVIFilM+5OsI/hONpPPB0NwiJaPEn6/v6xgmTYTzRUjvJJWchluJDw
YSTDfgJHRLWMCq7LcFrswziO9RPnWbVMc9wiQxY7A8mwnzRAdKYZgqyRWXoC
jmP9hBDVwg0BZHyyf/TjSD8hxMw0QMiqEInmNCSDfuLcYqbR6hGAdiaSQT/x
5Xl+B0Et5Uw95shG/QR1y9qpd2ROnquH4o29flLesgQBrfCk/tGPUT+pb1lq
jW6Fp/WPfoz6iV5EZOtYZuvt9wJ6TGPQT/Qi0iya9JhnXQPHqJ9EvojkgV4V
9fwZQa+O/X4S0R00vQ+f3j/6seeThoSSaVKjy/gjx45PgA4lyoXs3MAfxrZP
iA4t0IXsYmPTJ0F0rlzn/f4YjS2fFHThynWd/tGPLZ84cFcu6XTJse4TvJm4
hM3zzwx2d6z7BG8myrir9Y9+rPmkEZZ+Yl1Zj2ms+QRvJnp1v7Ye01jziTqK
O/rF9ZjGo0/Kjyf9Srn+ePSJX+cXgDfQYxqPPokC4B56TOPRJxXAXXA8+iR7
4vV+f4xG75PsI9fvH/3ofSJ9bqXHNDqfZJbdTI9pdD5Jp5wd1g9G9cmVf3+M
RusQ3FOPafQI7oqj+OSm/sgBn9xYj2nYJ/fGAZ+cHcjT4z6/P0bjvv2jH/8P
PabxERz/AVU1PXE=
   "], {{0, 0}, Offset[{402, 101}, {0, 0}]}],
  Frame->Automatic,
  FrameTicks->{None, None},
  PlotRange->{{0, 402}, {0, 101}}]], "Output",
 ImageSize->{406, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{402, 101}},
 CellLabel->"Out[1]=",
 CellID->26742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16748],

Cell["\<\
Pick the number of pixels per cell to be as large as possible in the given \
image size:\
\>", "ExampleText",
 CellID->30103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], ",", 
   RowBox[{"PixelConstrained", "->", "True"}], ",", 
   RowBox[{"ImageSize", "->", "Large"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22815],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5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   "], {{0, 0}, Offset[{402, 202}, {0, 0}]}],
  Frame->Automatic,
  FrameTicks->{None, None},
  PlotRange->{{0, 402}, {0, 202}}]], "Output",
 ImageSize->{406, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{402, 202}},
 CellLabel->"Out[1]=",
 CellID->14047]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11073],

Cell["Plot all elements:", "ExampleText",
 CellID->28965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"GCD", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4749],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmTEOgjAUhktwhlUSB2ZXFr2ALjh6gIZIZDAaZOcEDg4OnINrcI5eQ/tI
IUJMYw2JaP6XlL99731Mfc1ruuHZfnfgWRJxf53y0z6Jzv7qmEqXbTHGbjSm
TM7vclYPckmzaV4bu8qPZe6dtF5pjhDCqaqq1TzP3ec1Kf0KPHjwg/Mzipdl
SeoqdTzPIw4MmF9lOvu/KArSti6CIGji4MGDH57fUjwMw7mmRpHzfzntvpHn
dLN/3DiO+37w4MGPj19QnrxDLJUiD3m6PG2foNYf9xngwYPX8i/vxnTGC8P7
NBgwI2I6ddH0Mb3123UFHjx4I/6iqU3EvhYzeGdV77XWA9t2c7s=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{149, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{149., Automatic}},
 CellLabel->"Out[1]=",
 CellID->19224512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32169],

Cell["\<\
Plot only elements with values up to 3, leaving the rest white:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->14331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7970],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmbEKwjAQhlPi3ODmInT3CfQBdHKseyhCO4hS+yAODn2GvKTelVgqtoFA
oEj+g/TP/bmvUw6a5qib8nzRTVXo7FDrW1kV92x/rcmSiRCi5bESNH/RrBts
UUiedyGe9Ej83UXvUqTGGJXnOWtKqthj/eSkS7BgwTrZNdeQMVRl3ynBgImI
+eojyof9M8zBgwcfnj/ZHt04ehQ1cdb0e4vMsT2lrA8ePPjw/Nb26M5MnyVQ
E2fN3N8N4MHHzI+edUm9z8dgwPw58/MvdELBgwcfnn84ehNrs6153LPa+9rk
DXVZ0BY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{152., Automatic}},
 CellLabel->"Out[1]=",
 CellID->597899402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8768],

Cell[TextData[{
 "The first two entries in ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " specify the range of rows and columns to include:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->28052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "6"}], "}"}], ",", "All", ",", "3"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13178],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwTANiPwkGIPs/kAXG
ICEgYAaxwYBhEpBgxCfKAhcFAr5Vq1bxhYaG8gEF+UE0iA8U50cSB9HMo/pH
9Y/qp7p+S6h6EC04qmZUDba0BaT5kfj8UL0wPsG0Oap/VP+ofpL1y4DkgQKy
aDRI36ieUT1DVQ9KvoC1WWD5Aok/qn9U/6j+QaGfhP49dESAEQCiGDNa\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->93260406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24981],

Cell[TextData[{
 "With specific plot range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "min"], ",", 
     SubscriptBox["a", "max"]}], "}"}], TraditionalForm]], "InlineMath"],
 " the colors range from white at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "min"], TraditionalForm]], "InlineMath"],
 " to black at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "max"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->312815653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[{{1, 0}, {2, 1}}, {{0, 0}, {2, 2}}, {0, 4}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    PlotRangeClipping->True], ",", 
   GraphicsBox[RasterBox[{{1, 0}, {2, 1}}, {{0, 0}, {2, 2}}, {0, 2}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    PlotRangeClipping->True]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->742576207]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731],

Cell["Plot positive elements only:", "ExampleText",
 CellID->4278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "All"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17859],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmb+LWkEQx5/cFTMQhQhikupIJKhBgsRWBAsjyBX+A6IewglKwsvZqliI
VoI/GkEbLQVTHPovKNqIhYKNICiohYWioHDZnZNwgcsRDiGE7MK+mTf75vOa
LzO77KXv5joQ9t0Er3wXn2Xf1+vg1bcLxxeZhc4UkiTdsul5JTH/jnk0eYiN
M+7TkL6zh+JU0fOfUTYgGo1iLBZ7w/3FYvGSWdztdqjVasFisWC9XgeWQPFc
Lod2ux1Go5FG8ATvebwHqkT+Vbvdhlar9YH7nOD1enk2rNdrZH+AVCr1UWSL
7PvsbrcL3Pb7fdTpdDAej0lrnU6Hr0OxWCRtbrdbDAQCFIvH40/oTxAF8c+J
v1bDw+GAkUiEGOl0mtgGg4HrGzUazVv+rtfrKR4Oh98LjuCchvNA2e/4ajKZ
pCq62WyQLZFyZ7MZqXm1WqEsyzidTmEymfB+DYVC4VzQBO2v0yyctt/v4ah1
HAwGkM1msdfrgc1mw0ajASaTiZPR4XC8EJT/mkKr+Xwe3W43zOdz9Hg8RDQa
jbyWgtlsprpZrVZJlU6n8/EdgSAJ0slJLpcL1Wr1p7v7XeXro5Yps1Kp4HK5
fELXIvsfyqYTRTAYhHK5zE8WWCqVgNc11v9gOBzSCVelUpF6EokEWK3Wx3ug
IAnSKUnUaZvNJmQyGaKGQiGqaUqlkmytVqOdGt+lcev3+wVJkH5Het5Nw/Ee
Q/EDpOdZww==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->553879007]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8752],

Cell["Plot a 2-color cellular automaton evolution:", "ExampleText",
 CellID->5089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31958],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1lVFSwzAMRCVuwhm4CUdghm/u/0eLrd2VsWM3iUPJtImj9dNKyvvXz+fX
m5l9PP6/7Xm4Pz7PU/3+OD//vP76u1dXxMVyo1zFfSsRLBaXBYxZbnpdEI8b
49TdaKi4+vcLUjVK2WeNkjaHBVgXcTxwPQHWy+YiFYtlg7I5wwKsi1wiB1ge
YQ3wErMBTZsb+IIoVHGgCTyhkQpNAFm6voSd4gDRAE9opCInYOKLR0KQO0FD
4VnwMxU5ARNfkH4XeT5pjImNwtJWZdovJvLMHsPDisi8t8dKv6h8fCS8bJQ3
+ixH/aLykT0JHxXiodRVmfQL86XZU9vdRXakMukXXmb2JDxaZsQx9cU1X6bM
6I3I85hj6oucPDNHAbLYDjTm/ZKnFtqSbdjtjxHLqF8wPGBxJeMUnnAoy6Bf
MDyMsODwyPSKykG/eAyP+IKxiOcXNGb94t58Mczlw/4YsfR8MUkSTAq2JT9a
lo4voiylxIJb1jjyRZWl/Vhwr6n0fUnKrLD++2OVpfUlKTsrbK0/RiytLwzK
CgPfGZWOLzJNWGpl/QmNkS8yTZDFV/pjxKK+mEri9XWWQ1nUF5kmGO/nOZRF
fUHHsNMvcCiLjlyO/MC4ptHzhSO/il/kUBadJhr8OgdCuvqSg9+h8d+X6MfX
3h8LKsmX6JNr/dFRSb6A6zaOqqK+ROZu5Kgq6ks4c6tG68vZ98eCSop+P0dV
SdF3aCRfNvghKuHLJo6qgjG/79Axv1Vlox+ispmjqOzXOMXxC/ECEP0=
   "], {{0, 0}, {101, 51}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7054],

Cell["Plot a 3-color cellular automaton evolution:", "ExampleText",
 CellID->27972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1635", ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "80"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4208],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzNWouBGzkIBTq5knIlpIHUdJ3GA+/xkWfiVc5em2STlVaDGMQDnrz//Pz1
708TkR+3r/9uXypidkzc/hdVfmtiqsdPjsmbSIne/hgevP1Vzh3D0GWGmdt/
viZWc456XC+2iFW+s7p6gS61MBKPmJYVvpJmNMWu4qbDn46XMwyxqeaM75+r
ddEjsMD3zZ1NywhX4I9hG2pw/YdCE1leHCr8z6HcHw0fH6YbzMDM8fNavehJ
C5TvA7+FNeK2uYePt3TPKl8xvB8a6uGuwuKF4kCg9DAvzAjvRNC01UMN9MZG
6TZzOzSMspDjXFyNKmyPHXEkMwTh+pjUiEJGqRuTD2lEYFu9qOFDiveJnTWG
YRREwo3ua9h/rIzooXu6CyP2FRCqKC0zjJuM1YsHI7Zu+yCAfTe3S0NBSmDZ
3zfsjJWa7kGY8t3DLQkhY3Q1M5Rv3leXcWLpZA2/wDLYBQXlQ39zDxgEn0dT
uWccM7Abj6UCGWbkm4/VdbzNyRbQx97HM5oKyofIYpFEYJfBVuS2GYVCCEU2
6qbDVg/Rsbq9osOBJym1LTKp2ioBm3iEMYmzR24b4ZP/KrNR/EAzFAJ9y+r2
inE6uQ+3lYHf4cOIOY049CGi0O4yjZtMEArBFMAyDrI8tNX9FeEU7uPxp7rg
d/jQn1BaLzkTaWqtAolcxKI7KwIeA2Knr05PhydwxtxS9Q6/w4dMwsqEgRlt
9UfSKuXRMTNHUkZaiSiMFZq21hHAEywoEV2sv1ciTMJ+1CxaeG6tJsA2I9AP
JjqJlrcVeDWbj5cnJPfKZH5pX9blOGHJmbWhEWA0MiayZGRRjUyGTIfs1nGe
QRyWa9ur199LH0Zu5hkir60NjRCjyNXAgPvQ+K0ApDpw3oIY1bv2usTv8CHQ
j1Ph+WWayZICR7khLFvuw/zWEx2XzYdTo429LvE7fFgpMZNsTzNa2LAoN6bZ
nkp2dhoDA1qJlnpPaAzsZ/J75D+zrMvVK8pIMx0bUaUst4u6Wi1sdF/a0UL7
qBHYx5aP/RfrPAgzAmWmmWg9LdIYCmkm4wg5yblYYXBm1aPSGFF4Xn8vfYgo
YgTONIMOGGnMspVCP42emnPGRCrstReNVpt9zX/uQ00y1JMC397Qb2f7lw0V
Taw5Ib3i/J1GkquH+B0+jCpsFXcVPXQaA4heaA7tc8qmDL6612h/qr+XPowq
nCHdoyfQShICpwKMcChHmUgF2bVHMo39c/299GH1do0vS4YLyZLRqQDjMuKK
zK6lZuW/u1IRuBDGRGsFEAEP7PYRVxgZc4/k1Phl/A4fMmQaYbTs5KwFaQIe
YddHDDHLrjJDj9l7C7/Dh6d8WUApe5C2K4W7EUNMNf0bBp7w320fnvJlQLAF
KVMgY3aMMsTKv9f8d9uHdsaXSSlbD1Xp734EzoU7mgf8d9uHbDUGX44esPdQ
Zi1Ql1GAOnpDZAC75r+7Iqd8GVcuA9qdV84R2G602g/5766c82XVvLnJKGzD
5Z4jWmowlof8d1fO+TJubpqXxvD+hzjRr/DfXTnnyz3IEqsXIzQ0X+a/u4KU
t/Dl9a5Bh4GTRud9MVU84L+7cs6X0c7RBM0iETkkLRes3eG/uyKnfFnRxqNc
VZFAtxh/s7/e4r+7cs6XSXpR11oeRL1L6rzPf3flnC+3G8TRqqjkbO+vt/jv
rpzyZatq2Jlpellmf53PPg2/XaRSYvWK4ZxAT2ctisypY+Um/92Ve77MksFm
uXM21I+5cpP/7orc8WU0e9I+iaAHQVvmyl3+uysrX2ZsESiVpwGQu5XPqr9X
svJlYbMnNvgGaN9oGf+O/+7Kwpclm727DwpVl5aR5OQF+O0yqIiIsLXTUX2j
dpv1S/+/5b+7MuJKqrWbl9ia7VWbtdfht0tFICknW+7uQWtNZHYUL8Rvl+LL
Olq76cHeRJITvhK/XYov22jtBkhGE/l/+e+uFF/mJabZ+jkI1oHPvar+Xknx
ZVJMmz1+Nd9ggN+B3y7Fl3ub3Oyr5vtJ/HdXJPlyb5Nn9sFPnsR/d6U1h9Um
zzxj5b3vwm+X4stglIsHg5s+k//uSqW6uyyTJPO5/HdXKtXJ7GWiaoRvvx2/
XYov6+LAvIO278dvF0m+vDow76DfgN8uxZdlQTF8+xb8dim+vKL4Vfx3V4ov
ryj+7vp7JcWXlxB8K367JF8W4Qcf8lr+uyvuL6m7rvjO3ozfLoq+NW6Q+N27
8dslPqfBLzDgtwTej98u/HCMxslH4LeLEBLgc5+B3y5xa40PHj8Gv10El0j8
pcHPE+WxfhR+u+SxfhR+uyjl3YZcCjv9zxVcqn+wfCZ+uzzdf78BfpBJ1w==

   "], {{0, 0}, {161, 81}}, {0, 2}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{229, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->222206474]
}, Open  ]],

Cell["Use colors rather than gray levels: ", "ExampleText",
 CellID->126333391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1635", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "80"}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "->", "Black"}], ",", 
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"2", "->", "Yellow"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24171],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->982759361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8503],

Cell["\<\
Plot the imaginary parts of a discrete Fourier transform matrix: \
\>", "ExampleText",
 CellID->19511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Im", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"2.", " ", "Pi", " ", "I", " ", "i", " ", 
       RowBox[{"j", "/", "32"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "32"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "32"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32174],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnE1OAkEQhYcwEw/AxiV77qHJJB5iQkxgYRTkJC5cciSuhPUqr7FZ4UKw
anyTADPV9fOZVMPrmY5Pw271/DLs1sth/rgd3lbr5fv84XVrpumkaZpPvO4b
Oz/amb9gsmOKcz+aD3ubJLK29tYdDod2v9+3m82m6/u+XSwW7Ww261o7zBUf
nV273cY783N/i+ssvmW82xnv/oz3PIz3/IxH3TtRjZcKFeANElAgA6rDjqrI
wHGvwnG3c9z9Oe55OH4pv6hGTIXuY3d6ttK96G5kQZeyuz1b6V7MDlAx3u2M
d3/Ge54yOzDOeNQVlahuTAVPVEdFVOG123ndcfy3/UU1YipqhLNuLBoA2dDV
6FZ2s2uMogFQpWgMzgafNdQgXr1ojHo2wd/iRDViqloDgKLWAKhaawBUqTUA
x08ag/EnjXEhv6hGTMXuPluDlO5FFswC/hp7tvJri+4FVZkdXAP57ODs8b+i
zI56DQV/CxOVqG5MhcrIjgz8vJVdVCOmitntospOFVMziEpU16CKufISVXaq
PuSdIlFlp4p5Z1tUoroGVa0BQFFrgOOfPbUUVXaqmLssRJWYSru9RDUSqpjf
2aLKThVTY4pKVNrtJaosVDHvd4oqO1WtAZowz2dEJSrtQRNVFipUPobbKySq
7FQxu11UotIeNFFloYq58hJVdqo+5J0iUYlKe9BElYWq1gCgqDUAqtYaoPnn
z1JF9XOqmLssRCWq1HvQvq3872mTLyzE2LA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->81169542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26107],

Cell["\<\
Plot the inverse of a matrix, shading according to absolute value:\
\>", "ExampleText",
 CellID->12205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Inverse", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"i", " ", "j"}], ",", "19"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22599],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm0tLW1EQxyMu5qxSuintrp+hu36BdtVPoBsJhbgolTZ7N+7FLroJ6E5c
Kigoik8QlWjAN2LAB77jK76f7fyGm66aPmhKH4wQczk585sD+Z85M3NvXtWk
kq/f1KRqEzVPX76rqUvWJt4/ffH2nQ5VVsRisY+8Hsf0+pNe2Ysh/avk2v5i
H/RfxS+NSqFQeKYX8bu7O97D8fExY7K2tlbpFr9o8ZzZ9/f3NpuZ+hEWPvtH
Z8ve3p5cX1+H29tbubq6kpubG8nn87K7uyvT09NSV1cnyWQyTExMyPLysqyv
r4samt3R0ZGcnJyEs7Mz+570+3Iv7uW/9qIesAoao8way8XFRdnc3JR0Oi2J
REKqqqpCQ0ODLCwsyMDAgH3GXFZ0eXkZ1NNDpzu9PHSoGu8Ds9Evej4/Pzfr
jo4OGRkZkcHBwdDc3Gxj6LvoXe3wEHRFTnd6mehoFr1DPD09NYuNjY0veiav
U+sQ7QuZmZmxOUTkSPdBV+R0p5eRrjoPh4eHZp3L5eLZbFaamprQuQwNDYX6
+nrp7e2Vnp4eGRsbM3qk+SdOderXqURG/TSQcZJpzs7OyvDwsBFTqZR0dnZK
V1dXqK6ulra2NmltbTU6+sVWz/qgGi6hW6c7/WfpRE+NlA/QONodHR01HeNt
Z2dHtre3g2aUNgZd9R5nrmaeQesipzq1BHVra0symUygmiaDbG9vl8bGRuqb
eLGCRp+Q0S7RlPOaLFJrGypvJzv5ryFz0nd3d4eVlRWrfubn52V8fFz29/ct
3yTeTk5OUnuzY4jJZAlWvxOrqdmTyaTtIl1ZiY6Re3Evv9tLf3+/9PX1hdXV
Vbm4uJClpSWZmpqSg4MDq+/ZO+qJmt3iPxkGdFZArZ9IJAL9UffiXv6sFzpR
UOiDEu3ZPy0tLVRvcbwozTyQyZArU71R2dG1SqfTnBIlor2TnVyKTGTWCGz5
MpEaLUd9TtO3RmvrPDGGprPZrOXLVHFawTnVqSWoREosodB5InrOzc0ZHe0S
QTUfCGS0VGn0AehK0ftkRVq9hXw+73Snl4ke9QECPQL0SwcKD2ieiMq5rllq
oM6id0B3KpfLmV10r5yVOd3pZaLzxIZeWHSlisdDsUvPOc9+UF1/uX+Od95Z
Dec+tro6pzv9n6DrrrAsAzoW0b1Pe/Yj2lXW7WKMXBbPxbvz6pEnnJzs5J8k
66ePilZ0n+g40X3Smt46VJlMxrpO3E2PNGzxO9oHTnXqN56uQHvMJHLyHkVI
O/3pHGmWEOjko+lCoRCPbOyJTebgqfRTyu7BPZTJw/d+vRH9CqTiM+LE86E=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->365770297]
}, Open  ]],

Cell["Show positive entries as black, and others as white:", "ExampleText",
 CellID->13261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Inverse", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"i", " ", "j"}], ",", "19"}], "]"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"i", "+", "j"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", ">", "0"}], ",", "Black", ",", "White"}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29045],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr8KwjAQxlM6VBzaqcWl0MFN8B1cdPIhigh1EKX6JA6+brxIAuf/alCv
+gWay4X7fkuuzZF0Wm6r+bLcLmZlManLdbWYbYrxqqapMFBK7c3TUzTWNDo+
ZopaaMbHpnbUBV6zEXURuZm1zo/Jdpifkk2YH4L2JzSjyliUsTHZDvNTson1
u6C0lJKzvDDq0d28QLRvNH9Pzeq4VRxA9WaVi3Lr9NrbBvX31BlUH1K5NfLf
X0BqMUk3rykjRvOvUEFrFy1hqviMzvPufp6BIp8iOQtB+yGautzFckZOrU1u
ZywIIIDwDoIW/N0ATRDtVs0RW+tXuYAihyI5C0GTVslF+vp5xPM7F0jtIMk/
84QKKgmqvj691Wr2lYXKX3V+k+v2vyGiG0Y/+gvJ/s0UHABD4mkp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->541496659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7492],

Cell["Create a list of array plots:", "ExampleText",
 CellID->5732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"Binomial", "[", 
         RowBox[{"i", ",", "j"}], "]"}], ",", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "30"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "30"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30076],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->68120586]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55685281],

Cell["\<\
Plot a table of values of five sine waves in random directions:\
\>", "ExampleText",
 CellID->29355813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{"10", ",", "2"}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", "5", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5", ",", ".1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "5", ",", ".1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651630216],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43157878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21054],

Cell["Plot image-processed data:", "ExampleText",
 CellID->10167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"ListConvolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"30", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19212],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58288310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30129],

Cell["Plot a color map:", "ExampleText",
 CellID->5793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "1", ",", ".01"}], "]"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", 
    RowBox[{"1", "/", "4"}]}], ",", 
   RowBox[{"ColorFunction", "->", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11977],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt0aFPQmEYR+GX3cvcLBSDFudmMVEsFgpBCgaTQcqdw8Gck6EWi8lioVgs
FIrJYrFYLBSLyWKxWCwWC+XzgNU/QLfD9rvnVQzCs1WcdNqHxUl3r1hp9Ite
p7t3vLJ51OdXWSmi1ImI3cXgTlyzTR/dmL2y2c/T1yxtVvpX75R5ZHygPFUi
S8usyl2jTdqiB+yM+5Je0xt6z8bcL/SdfkU2SZF/pMhe2RP3A72lQzpg59w9
WtBtWmfr3Kt0gZZppPk80hJdYxvcDbpD9+kpu+C+oiN6Rx/ZM/cb/aQpi0/2
lvJ4po/0jo7oFb1gp9z7dIc26AZb416i8ykvR8oW2GqkfJ3W6TYtaI+eswH3
kN7SB/rEXrk/6ISm+OI7fWcv3GN6T2/oNbvkPqMHtEWbtEarbJm7MvWYU0st
tdRSSy211FJLLbXUUksttdRSSy211FJLLbXUUksttdRSSy211FJLLbXUUkst
tdRSSy211FJLLbXUUksttdRSSy211FJLLbXUUksttdRSSy211FJLLbXUUkst
tdRSSy211FJLLbXUUksttdRSSy211FJLLbXUUksttdRSSy211FJLLbXUUkst
tdRSSy211FJLLbXUUksttdRS61et6aP9h97hH43uz9+UvgH6Fl+m\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->828279726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15012],

Cell["Use a special color for non-numeric data:", "ExampleText",
 CellID->6831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{"ComplexInfinity", "->", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14889],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->323284975],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj1qxDAQhWWcUtNvuadJqhzCLAu7xZKw2d53SJHr+AK+gwuDK4NtjH+b
zTwR0i9RIeInkEcz8/R1wwhLr8ntdLwkt/Mh2b9ck/fT+fCxf367aiiOjDFf
mDuj67uu3ERIR4y1G+ZTP9Hj0affqA5Z11WWZZF5nu00TTKOowzD4Cx8jbu8
6mIyyCDj7wzkodV9tu97adtWmqZxFj54yKuODDLI8MBAXULXdZ2t61qqqpKy
LJ2Fr3GXVx0ZZJDhgYGaRH2q3hZFIXmeS5ZlzsIHB3nVkUEGGR4YOIeiL2qd
WuxL01RU4Cx81C/yqiODDDI8MNAHcR7V/mhRr9h/1wkLH30TedWRQQYZHhih
1D4ZZGyFEcoZlwwytsII5V8OGWRshRHKnQUZZGyFEcrdPBlk/F/GA+/Eft6b
Rd/zc2na\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->144865440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11299],

Cell["Digits of powers of 3 in base 2:", "ExampleText",
 CellID->2489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"PadLeft", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"IntegerDigits", "[", 
      RowBox[{
       RowBox[{"3", "^", "n"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "70"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29674],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy9ltFh20AMQ8lu0mU6QEfIAtn/r0l8wAPV2LEtya7rqtbpQJAAzr/f3v++
/aqqPx9/3+vy6vX++PP5/vioy7Xufn5e7rS+XYu16nJHT7QWfC1vgzQgpVtt
AO5+7dDC8xes6vUYt1pbUeBlD+ipLu+g+x218cyGQS+u7dpbIKuM1bt4r++1
g+5Hl+MZd4ClrqDLJVWwUnn+pJ/aTosa/KImj7NVFY2NYZiPa+/iP7mDukFn
VmtXu5BZzQqy0cHHAqh4JBXgHTzbVls9b2BCo2PEsGMw2m0oYO7QloNqC6Gr
KLsEkSY7FeqRo6GpTF9Hg0Pow4sVD6R3TTCmgz80JtThVjoHTGp4sVz39G40
NybNe8D6uuBCp3GsWouAevsaSgmLDNjYOGxcIh8BYOur2P8B0YwLQnkxqhix
eiidpv1CFN/BOS7CHN42yPCV9c6+YT/6+C27ZvUwB+kCd5fUrj6l6NmOgr8j
SPmYY6ZAND/cIq5WG1dX2SXxNEcGhwXi3lO9FclQ7J3rBKN52oMGIY8gxTOp
Nvp7Ha6p3h0aDepEd8LwDB1Pq98EzA6EmQuQ8EiESsoUdd9m15vkCTOH8bSz
m+3nHGIZUT8BbjtkB7sedSv839Hk5p+f4TABdSdohF4kZ6Qz4XIPu27ETr4Q
FgoCmkAuGIKkvuuVPYKIB8Zn29czeLz+Tjz0SbxEeG1l4pmqlV5/L2DqBclA
Z8qkaft2/b0EGUqcAJ00LB84KQpi/d2ADCWm1x6Uby5etenrI+y8hZLXZpI0
8wLX2w8Pzc4EBSbrgb65GPohNx8maKI+VCAxLoZ+HvDdJNjRqx7oDZuAQ9NP
wEX+azZq6ZirxFqh6afgiF1JVNPKzkagx4SfezkxEaAPOPl6Faa0fth3EzCU
r/1i52aEisBnZyeCBvAUNcKO4UVa72DXmlWNKWaUIilT3QMnfRDAwrdTxJEw
3QnoPduwcdqaY4TpPkB0F7DzaJpq3YlndSSsvBK67SPYtc8dy7OjtanbQ9i1
HMUB4FM9k3On7yZgHoFx7OKTp86763gLlWNN6gynHMauOZXSdxxI8uOBL0+u
8tqDPHB2a0dbzTjk3EG+m4CpUOcy59/BcL1RKF7fed7dAIyYLAo40ncTkJjU
zwxF9xlwJuN+Et3nvCrNJ8Wexa49qPjddLzvJqDmpmGeNruFZ9j5I+ZEwHnG
nsruC5AT/jTfDbz4YXE+uxaaj6Hz8fz3FewEdLLvJiA//l6Dd855dwPwZbNb
eC9l9wlY/wBSyBir
   "], {{0, 0}, {111, 70}}],
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24207492],

Cell["Plot a sparse matrix in black and white: ", "ExampleText",
 CellID->20067],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<LinearAlgebraExamples\>\"", ",", "\"\<Data\>\""}], "}"}], 
      ",", "\"\<west0381.mtx\>\""}], "]"}], "]"}]}], ";"}]], "Input",
 CellTags->"ArrayPlot",
 CellLabel->"In[1]:=",
 CellID->30265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Monochrome\>\""}]}], 
  "]"}]], "Input",
 CellTags->"ArrayPlot",
 CellLabel->"In[2]:=",
 CellID->20840],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"ArrayPlot",
 CellLabel->"Out[2]=",
 CellID->824443893]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6612],

Cell["An empty array yields a blank picture:", "ExampleText",
 CellID->15369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{"{", "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3282],

Cell[BoxData[
 GraphicsBox[{}]], "Output",
 ImageSize->{92, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{88., Automatic}},
 CellLabel->"Out[1]=",
 CellID->287756919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2091170219],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " arranges elements the same way as ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->24387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0.5", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0.3", ",", "1"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11957],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{0, 1, 0.7, 0}, {0, 0.5, 0, 0}, {0, 1, 1, 1}}, {{0, 0}, {4, 3}}],
  
  AspectRatio->Automatic,
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{154, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->15503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0.5", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0.3", ",", "1"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19491],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0", "0", "0"},
    {"1", "0.5`", "1", "1"},
    {"1", "0", "0.3`", "1"}
   }],
  "Grid"]], "Output",
 ImageSize->{84, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Raster",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Raster"]], "InlineFormula"],
 " arranges elements upside down and with colors reversed relative to ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Raster", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "/", "3"}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[{{1, 0}, {3, 2}}, {{0, 0}, {2, 2}}, {0, 3}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    PlotRangeClipping->True], ",", 
   GraphicsBox[
    RasterBox[
     NCache[{{0, Rational[1, 3]}, {Rational[2, 3], 1}}, {{
       0, 0.3333333333333333}, {0.6666666666666666, 1}}]]]}], "}"}]], "Output",\

 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5818117]
}, Open  ]],

Cell[TextData[{
 "Make the array be shown the same way as in ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", 
   RowBox[{"Reverse", "[", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "/", "3"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15597],

Cell[BoxData[
 GraphicsBox[
  RasterBox[
   NCache[{{Rational[1, 3], 0}, {1, Rational[2, 3]}}, {{
     0.3333333333333333, 0}, {1, 0.6666666666666666}}]]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->31651424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293421914],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " when entries have a big range and many different values: "
}], "ExampleText",
 CellID->11066808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"Fourier", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"UnitStep", "[", 
       RowBox[{"i", ",", 
        RowBox[{"4", "-", "i"}]}], "]"}], " ", 
      RowBox[{"UnitStep", "[", 
       RowBox[{"j", ",", 
        RowBox[{"7", "-", "j"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "50"}], ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51760159],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztvQeUVueRJny5zb3j/+zuWY9ln/HsjD322OOwtpzkIEsIAUZZAmUhJCEJ
ZEkIiZyDCE0WOefUJAWykEQQICRE6tzQNHTTuRvYvOfs7uzu2Rn9T7j3o9W0
7La947Me8CkL6P6+G96qt94KT1Xd9+zgF3/9yrODe/d69mt3DHy2/4u9ew36
2u39BuJHWW2CIHgb/9/65QB//wR/0//f/uQT/Hnlf7+I/2bhA9fhz7b4M8Sf
If78En/LH3yS/o8//WLyZ9Zn/Pu65Gphk5/z33+ue+maWZlr6tNB5H9n/qvv
Nv3UFz79JC184vP8T9z0E3/Y5/685TtGTVeDT/qFFt/qi616Xn4giDJP0fSK
/8+8SdN/t8SZz7f0+0/drbXvw+cMW7zCdf+kb/DZ9+X1sv7gd/r9n/z/0spd
cbc/jiSleuFLn3xaP7SsVdJPpVqjJa3S9N/pn77XZ2k2/nZO5lNB2+QBgyC4
Uj+1bfFdvtxsDf6y2b+b/77Fz19x1fSezZ9B69kCH1te5+iP+MRtW/lMWb/7
GzS594xm/27tdX73u2bpL52+Uf+P/QJQxx/U/vdh+Hz7ByuDuH5Km5vHlVWt
/jro4aVFUw+dCxv3PxFEj68suHRsIOhi7ij8PAhrNv0kiO947XTVir/+1dRS
UNXKr94x43RYs/knQfTgoqLG/U/23VoIqixbFYTLTtYE8YW8sU+tzW/YfR/o
/oXFtW/8PLx3bkkQ1W7+aZf5xfU7bgN1W1EQhJdODA3iqtIlL7yRd/HjfqBe
m3MbCiaF9UXTgviZ9XmN+7o9urwQ1PBOl8dWFIYXDvXMGrijCHc4+Ax+Wr/r
LtBDS4rqd98X4sGD+OKRV8btPTP6vdOgi7mj+20rDKvOLAuiiydHPr6qAFS/
8w48QhDWbr4hiO+ZU4K36DK/BORHCvHiQZS9v2xNQT1owr4zuGIQPrqsMIhr
37zprlmnqlf/LajztNKqFV8Jb3/tdBDVbPzhg4uLLp0YDrr44YtByGWL67b/
Ct+qLZ4FqtvWqdOU0rByZpsgvuXZiv8yOujwixrQPwwIPmmyL/9pJO/y5/6x
fxB2+lZdEP+fAUGHm2r+85gAdEuvCjxXiOcDf968sdemXPAAhKUOwudfzw3i
vlsLsL5gIKh67bfw6mHV8r8KYvyles0375l9ClS3rWO3lQXhxZMjgmjh0SpI
AWgMeHDk5SAE5yBvOzp3nV9c+/rPQPfNK8Fihli1IGrY87BvOPdI5aUTw4Lw
6Zw88PGjPr3fzK8sWwkC7yBNYcOeR4K2uFTj3kd7rMsHZTXmjw/iJ9fkN7zT
FTJAMdhx+8NLisKGdx8IYnzlQu6Y82WrQUPfLmnMzw4XHasKoj5b8iHnIHyy
9q2bA0lmXLPxRxCG2jd+AXpgUTGuEEL8gqi+cCrEGgQpgpAGYeOeR4P4gYXF
+AI2Aahq1d/cNu10WL3mG0F0NxZie+dfv54LwgMGIYQqiPHadVs7dF9dAHpy
bX71uu+E7caXBVHdlDbtH6r8b8MDUMcf1pq3fxS9cE0mrg6ZSP9If9LUpmgm
Bx2/Xxf+Q/8giDteX/v3Q4Nb76oCXcpuc/Pgc+H5hf8a7zHrFFa7+vRiUM+N
uUEI9RrEjXnjoIdr37gRdOfMU1WrvhZCBKDTV34FurFmww9A9y8obnjvoRBS
FETVpUuqTy8EWekHOnNiKMy6rbdCL4Nwoa4LirFKtwcRFPKl40NA1aWL+fXw
wgfPiYsXP+4L/oHGvFeKv4dPrC4Iosa9j3VfVXDh8AugIbug4wftLPZJsawQ
ah+E06p+5+3hI9DmWY37u/fclAvljLMA/2k76t3TFq0Lea+GECBI59v34NEt
nTwpNv04hJCCR1tvxRUufPBr0LC3S4JwIWQorjqzHPKEL4Lqd95539ySsDrn
3wYxlgEnrOWCJ8WiIp160YVDvSBUIMo+xM1ygcMLb1+55Iugm4eeAwPCW++E
hP79kCv525KlaIY38yT/1+AgpDDF/3tQ0OGXNf91VABq/8T52mltwlsmQOqw
ZR9aXIStAeIG8sphecFxPA6oZv338SIhjv4ghmjjC5BrEHYL+B9eOto/iGZ+
WDHx/TJQVelSLEUQUtxjbBvs6bott4Ak9e3Dh7zHH6Fe2ZQ758j5S8cGBSG2
AeTp/afwrUsnh4OWHK/us6UgvHD4+SB6YnX+hQM9sP1ADQUTITf5EyQJDe/c
j8uBcN5ybet33R3EkBscxHgJ0Mq8WvA3XAq7JILpAAkCQSKgnQLxM4aBw30u
PsNaqX/7Xj1LhJWAlIJgDsw8XAGJ/7hvEON1695q57evXvdtrgr+CKJ75nCf
P7c5F8SvhxATWxgbrsdtQHjjxvefDCEHQVQxJ6td7/L/ODYAdehYfcU+/3xL
fOzQvib8n0O4R39W8z+GBRAM0L8b36bdK+VhxZy2QYStB4b0WJcHWny8OrAd
BX0FLQMbBITngboOb5t+GhK76muUyQ3Xg8AZmFjWbzWn5tcXTQeN3VOq98YG
DGLaTm/fbZHFq0HdYa3vwh6FvXhiKCjVCxcOPB3E2IiN4NeGPBD4VVf0mvc/
mEn+Hu0PGr77VBBCyLBHP3juMVhzO+8E8fLbfxVCc0t2sJug60EzDpfP+eh8
eP7sGshOwaSn1+eBGt57EEzHDn7zl0EMpQ2rzmsNYYNSwbP0CKL+2wtnfVgB
aiiYDBkNwle2wlJs3Pc4vmqu06yDBoYCw9tv+omsOb7ShYPPBiF0AGRkw/X4
LXYBiDJSNE33jDpMOlP9Wptbnj4Pgll3jY9XEx+hRcMOt1YHMbyqDh2q8T1Q
+8fP101tE9786tkgqlz2F3gZGCcgOCRBOP2D8iCesL8MC2XrpPb1n+Ohw+q1
f6eTonrtt1O9ehPOmPDiRy8FEVyzEe+cAkHnzeJ72wPyWu+6E8Rzbcdt4SNL
C6G19nWzEppLvTowwNlIvbq3G89GKb8X38yD8RLCSQsicBrmmL8A+QpCsCSI
e+SQIzCGQGAiWBni3AxiPBLOaxyboPrCaRXn1oer8+uCCKfwpaMDQPDB8DjJ
WsNswsFm+0l69W6f0zhga04tAA3YUcTbhbUlc4MYJh68xeS02fRjmBshmBVE
WECc3E316pZ2QUxOr/lmcqpu+jF9Q7wfT7JvwKuFFUVD6rHzreNj+4crQzI9
vvW2avD01q6VoEsT2rTrUx6en9UmiDpOPgM7Bm8PglschBVn10GWTs1/Frvi
na4gPvTGH0nyYhwHlLGNPwLh53gr2a8RXhNbCAS5hQjDsz41P4ixnbCmOJBo
pey6m9KO6wURXgemLwgmk/YjjkacbCsLIEtgKQju8sh3ToU4neDf5o7C+sDU
Br26pzQIYc7QYn4JRyEWHgQZ0X7E2RvX774XagCMBw3eWQzTJaw4twFPWDzr
+TfyQLgXjaQQmka2Kjho6wwag0+IcyyI8BrTDpWDLuSOfnlLAd8HfMSTUArk
43eZB6vpJyGUFa79xo2QJr+S/IiulBGYSNBhsJdBd844jZM1hIcQRLhV5ZLr
bh5+DtQ4qU3r+HhhYpuw/SOVQfyfXg3ad638D+MCEDa09uMY7sfF10FwvGe0
pjjcgxjmG1YNDw3CEQ6tA8n7gWQMEnjvnBIQ9JD2I9z7aMqBs4N3FYOgzaiC
8N4LsMPyx4HLsEFBDljIx4mgurDhQPM+rrx0HJbYE7Qt4TKAM7BBQfgabGlF
TiLYk/g7rgqqK56RaH6IGbY1tjfIZiz24x3Yj0vp+eD7IOyq1z4oDzcUNwTR
jMMVNuago2F6B9bC4B3WHEsMwpaGeev9iBvWlMwF9X4rX96W9MukA2cvHn7B
clm3rUOX+SUhpCCIcAlYSLDdQU+t035sr7UCBztPLQXhPIIGC6FBoI32P4Ed
en7e50DtBpy7xseriY/t+paH4GUQt+9+/t+Pb3PLk+dB2M3t+p8LK6RXcerm
fBfLAFLkDA8bxFBFUErwj0BYGbDsU/746z8HwWyBlgyfXi+9OgemOggeNtyG
IKRTFmMRsQg4MUBgJWN7WPsgoveYOwoELwUqM7FzoFcb9jzsECG0E34Rwtah
DTUPriQOXtCk988G4fh9Z4IY/Icl1vDu/SAoNfDQnIFexYXsGb70Vj79jpwi
8LHyzHK7q1DZPKbC+t33BTHdom0d8Cag+h2dKZeNtHOgS6cePAe6dHKEpJsv
FU85eA6XtKTRX97WQadsBBUNMb14chSIrlKIq2Gt1n+PenX5vwGBlbQVqW8j
WIOQmk5TSkFkQav4yFgQeAk7bnKbW3pWgINk4kvlsJhCnLZ4vyVfxIlXt70T
6Cmd0UXTgxhGBlYAbwDC4uJ1QwZXYkZ6Xv95cp5s/xWsGNg5fbAfD54dtLMI
BItN3r4iDLBcwQG4XiAYkRBEWTQR5MXba8HRqksnwPWn5D/u68b9qN1Lk/Pj
fvJlo/Nn12Ib4lAEgae0OWYHMU46MLvbikIQeMc4EW1h2Tl7HnFECSoFTjnO
x/VBlFNYj6uAXtAX0ygWDtfFMMA6gyAGkAnFDyLsW+9H3EYxr2fBTMbGce/E
k33vId0Tnn/Eb+55+OWtBSCa7yGWJoixAatWf91x98rlfwmehtgGjIwUQv+A
y6BbJ565xseriY/ts8ucS2g38BzORLiNoJrpbW4eeTasmPe5IMLmhmFlH4/q
LYSdGMTzP65cmVfrA0UR0i4hna6YgZkFDEeC/PQhDirZq9arYCIDPI78wnKt
Pr2wz5Z8EFYDKxtC2wURvoIlAcGa7P1mfqCfyn/c+6jPZBiVWBBJQzT5wNm5
RyqdHZn14fkgnHboHG3H0Tx79z0OgjjRcqZPA//x/sdXJt4LWEavTX7H8pM1
9ggv5I2Dg5pEE+kWvX0PdCSIGll5o15B1HdbIe4Cgj4VZ+hdxXgpvGiyKmtx
zD5oPwrLQ49Jr8TAjy1n+BoM6K34K5BSYV+xt1m3rSOkyyuOc7N1fIRuVvwt
hiaGnVs1ow0ITKyYHYbts88EET4AP8j7keaGvbPq04vwynDqQeALTiycJ/f6
PNn+K0fDbOE7m4U3tp2D/UjGhjRfYqwGPP36wikgrCkuZK7jQ9inoMXHq8kq
xRLixvd74HrmDJ7k4oe9Q5hCioWDE2YCDtQghGwE8YDtRZc+7udYKCwkagbF
3xmp398d3iUITIBLHJ6HJxVVnVlWcS4HBNtfJ7gih4kQvHM/CH+BSrAfBYZg
64OYNYTCcXYALwB7B74y6NLxQdAtyg4wrgH3HwYFSNoIsiHdVb3uO9iGPiWZ
v6APHsFhbdzX3Sc4jY5W8ZEefOWyL8POyT5TMTeGKgVVzI20T5dcF0S4CXY7
+APSfkwtlLrimefPrgH13VqIwzvsxhwmJI/24e57QXzvAz1CGiqM59h/pJ1z
tF8Q0jiIYbzC/YZRCoKRAq6ENP6iPm/lm7mVZSv7by9k9LKfIqbYhs47XDj4
DOynkEo3gm0CaXBaYwkjTrga9zrvBfMRBBMTuthPiL/gnxACEG4IIQhX5WE/
zj1yvvLMCpCde0jasQG+577u+KKc127kDNVoBIbMOFwOwit4Px5+QVlf/Btr
A4LKv3jklUQLH3iagaKCySDJCKyeIMZBdDdDAd8AdZ52umrlVzM5WUZXSmaD
yPBrfLyK+IhzLLyLkRgo6Y6Tz5xf9HlQh4lnYN6EUNpBVL3u29joRg/IzpFe
BV+gkRyaqiuagRXTucGIKQ54WxfQSTzx8GbKdzgul7HTjw0KYiilxvxsGDOg
CfvLcHyGULXwoPLGWWXDP1R2hLIQY+GZlDz4LAhe2MUjfXTKRpAAOADwhEAM
lYZgRhC/uqf0Qu5oW2JQUFDEOPGeDGIwEU8K9Q2CZwM5gl5di/fUSQFaU1AH
yz8IcWbjnh/3xa3ABxBYggs5potFcG4ODgiFLJN1fU6gDP+aGRkehxH4CzWL
W4EU/YEwBTHzWZtvwJEIAiuVHaFeZRZ06624LYhr1So+4sy3pWnYBZS0YBd/
TesJHk0QMcm8pZ3jcvJ9RtDOmf5BObYLjmMQDB4sZdhzEy02rRi2DUg5xFcU
QY6qS3EMTgNhdZiaC3uJMydH4Dyx5GHxx+4tlZREuIV/CLaMfPc0rdtRQcw4
6kcv+WQDT2EhOu+NvVFbPHvpiRrQusL6IFxOfAy+rbADo3Vk2eEXfOLBvHma
yzoYxMBB0Wvej+CgT7yFx6oUAWYKLMaOxaHnADrvuSHP9xz97mlsYBAOStvf
2KWx+DUYGgRUXboErytpwHk/DH4lFBhIuT/nPnfd3XV+cc2mH4GwlS5H1Tf+
sKvSuSAGs1vFR0ZFHuMur9vS/t45JY6+Myqz/vtJbPDNX0KjwvAEyULB02E/
nl4AuxVKCTT7o/NTDpwNL+S9GsRgD97IljeYiP2ibGA0/2glvHMQ3lsWqPxm
Os3YentLQVCKEOFwAiOmsP6tnLDC2O1B2H877Dt8paesXRB4CnHwKjUUZDOx
eWY5iKEZR4DBC9ii+CLISsA5QrwDdIHDRVhT3M92DvajPXv8hY5IiGsy4jTh
JUVsQHg3PII1Bp6wqnQZaIhkJTknLh0dgP1oexXvCi0TNhRODiLYXLiQDVya
+7ZuYXExDisfrWbzDdgw8Dt+qKi6Q2EgmoPX+HgV8RGGekhYmzylHbffv6CY
OIc3b8KOV9Y6ggPhlB1IkURFvcA78BPaBVRbMgcrF4IX8oQZcVTOHgtF/AQ+
wajXCnwMBCuJDA9fZr4Of4PuqyuaDprz0fkVubXwGRYFETjobDvcgCkHzwVa
jbjftkKctY5SYu1gDDlvZS288GgViKkLxdli3BHSZXMJdgs0s7wUSMMIcAZ3
Bg3fjW/Osf8IF9R6dcbhCqEX6cLEeFmICe4MAnOIIaS+jfBU8IlAkGMyVtqW
/iP+9KfxC/w6nH6onJG2aTiujZeBak285wsHhFsUGoXIyDdvCglHjBTKLXIu
CUdI6/gIeQpx+gr12J1GyoOgR5fBb+4iq4oYCwVPGHPpxyeuYaYNkghJxuEC
mnTgLBbN8XMclzjh7CrCQmFuidGVaFnqZePzyvVidYQOwSpP2FcGAgOxniHO
OPpyy2F4gnDc4dUD5adifJRx1LxxIHCGZ/KI3fSbi17DMWJjcy3PR27KGKc2
nmjygbMgrOOw3SXGewzayW/a6MKuwiM5noN7+gmhFbCREmnA3XFvH+1WQJJj
7l5DwLBrlX8cQI0B0cASOdIrxi1yjhqiAQFZdLwaBBkl8mScznuY3d1WFICw
3MyJMfEZ4S/4p+MdjGi3io9YzxCvHMSj3j0Nabd9B7sL9pcjatRgJ4f77GYi
wVY9lrv69AJrCpis2Al+bwgxfmIjZdL7Z8HzEMYAY2frvNAw1clY6c8Ysgkh
gO0Lmv9xJd7ZuUA8EL4AKi/fuORENT37xUEMnVdbPMvqGbybsO+MZUS7d6kh
ftqP+FYQV5RvhL1j5Yd15L7LTu6JP60cYEVXnlnuODm+bNUMJlaeWRlol8ZQ
Ebj2zMMVM8UKvJs1BrYafg/Ckyk2z4h9DBMe/Lb1h8tji+N9cqCNylaDgzCL
Qbhh8vb2tIw9xr6DFa68DrM9NBE/egkER+AaH/9Z8zH+5DdiI8El6YIYq4g3
wkODsFJ4Cet6cA2HY9WZZSAqQT0p81ir8uv8pOBCxdmccD35iiXC2bkqr3YV
WbMWdovfDL+EzgThNlirIISKCmIsPO6N7/MS53Lw5azy8k3heurJDcWNuAmc
OxCuxLNU38H640/8E4Sf47eUhSzpVnwZPPWN8Eh4Br/bcn40uQ8eAL8F7zcF
Eb64tqAehJvjv3i38g26Cr+voJ1ecp1PVHwaVwet5g/XJPUADEacqHZUQvdZ
ZznBA+FqeG+/euAnWXSsCi6ZjTpwHlo65AEaQUhri2f6VCB0IuvTXGrGw8+J
s+JkK6p+muFq4fmFTNvGeA3czd4vjEOYA/YZcVrgPLNNK2tF/jkeH7JiJ1oB
0SU6E2O8Ht7cMQH8EAZuWFm2Moiwnstza0DYF/LrhAiZdgiSNR8CRZkqpUBZ
PrCqWDUQlo3ufUhoWOyvet9LgcwPCfYi0hYL6agUF9uyh2tgM5vL2JlQFNqD
8UydnbDH5uie4Jp2PvMttnnwfkKiVVK+8NxYGPMTLimkPlx0rJqfXoPzGEQW
nl4YhFAz8nbBQ+sxPCF2ecjQVKToRo4lUfKuJ5lA62uiK0qgLOHAGl1KW/xo
f0NGGX5pxv1mPA1a4HH0O0uE62cgDM4WWRiSaJGlwakrS0NIABWtRGtnC0MS
Ebc0OA5gaQhpqESWBgOPtbsgDM15SmkIIQv8NKXBu47s8TlhcTCb/M1UjigN
1reWBls0OdpvIAtD4DPL0mDdZmkI5yT3hDR4U1+WOosDhAFkaQhpQEeWBggD
SPuf9llscbDLZGlw3s7SYHPR0hBSDUSQBj+IhSEIIQvy6XqlPp2lQXGrLEhD
yvGUj63gb/QpzX8lrr5ZRc6FD55zxA5uC5TSy1sKQJeODWDkVWgSxleODYQj
BNIz46AUJgU6y/VIEA9mIJm25JmP9XOsERLDs10cxgr7GIGgMfkaMsQUwxUa
+c5pgzlxQpI3WLEsHtDc0TIg6GfoS6/J+6LFDTMEVgYIJjrPKkkclG9GbVPB
e0fDsMAz4Ci1ZzAWzymdi2eDiHqPslTC0izJmmeTG5KARwgX8tr4Jax56z99
ehUlC0I4dk+pdeigncUX8sYZmYJVgqFdc2ouCIsB8z894VfCqshm7HScEBqK
JxNwsecReKzKCXWFm2NkyuOrCjL6vyky/kqO/tkfciLwfkS9xbAiWCQgvx08
v3Dg6bC7qg/ef4oBXFkgdHQt4WAKgZvye2D0MRos7mBNsDMcNochxh3BPUvJ
t+IHEwiplbfLXB1UjPHskAXGIWQ54dPr080sO4sOSmw3zZ4MXBtcwbnzhoLJ
sPZgaoKoZpJ9X7bKxwEIF+WTKGoD9wz8gt8EwhWJSRJ3cDRDBEH4oZCGlBPG
XHkcnFkJ8rEt3Q/tsdS+Fr6gXSHMLhxm5j5UMSfHfKwjBtgM0CS2Z3ighAxa
M/Jz8cPecHDp46qsJyR4P4L/XLelfYKf2Xn7H+VEaJZlUHYaNiYOA2MSLh55
+YnVBYqFR0p5P5nJdgaOlmB1IAW938wH4af4r3kMR547XyEQrm7xTK8g1s5q
AnzgB0MshyIaL76RZyATeIzNHvJooidsGwFbW+e1tA2uDVmAFIEu5o5WFCV3
jE42fNMWleIfsh5xIGUugxOMKCahSRvysyl/BdmgUQoB2eaDCDucM5wiAx7T
s6cU4hix5oA6gG9iDwOHit2LuqIZDNU5uicc8ivGmUOrvvBGXogdE0QQWBj5
FTqoJOFEh/IkeEqpetBDKi5xZQ4jY3MIHgd1mVfye0vEb/EHrnH+T43zn7Tk
GzTz3u+dW+KaHah66Btb61BT1PDMlrIq8XGBCUBGEsDeg3U7Fzrt0okhoGfh
3x8bFLKwDR7peDDTusxHK1ZhjnxjKEsQFkx5MwZYiQK/dHyQUe5gLFbb+EOc
BPbeYeSJT8LJ4MYDGd4cDYIwMNLcm2gMsHborhLncnT+0s6O7YxYN+Ma4Die
fEoQD97JgBwuNFA4fGp+ZQ3xtGm9wfh+zDiTH/Gw3SW6Ki07LAxe23KHM8OO
gJKTYwLZZESe91iXb8TO0zmy1RjKZ44RdpHzmnQNjTAjDEtlesKodhJyl9Ft
5v1yvutsIosBWhWFqVn/PeNF67Z3At+8Slhs7EUjQAUse/SJNfmgS0cHJFlD
vAwMySSH+mFvZdTxy1jm3GSYxiBClkpme3fijR07JqwT/kjy3h/3lWnKYgjK
DvxFXp1ratkHH+XrCGsMkcbaYls7b0DUqXL+zHXkj8eCgmB/07tcLqsLEmSr
C8YDruDob2N+NpMGsjHwMNQfPNkjOa4T7UypaqHPFsXfx+KJ/OgyQSpUf0FJ
W3qiGgTh6iO5hNcVk4kHn/FaEWeANWSagbU40A6ZqEQS5cU6EFi2uwuI0e3N
Pw3BQsjI2r9jcYsq51n+1io+Mndcs/77QYz9XL/rLqP4sBrYZ0YOQtVS0R7o
AVK2iUUVMR5LuCBGfJjmPtQrwQcdH9xvW1KPjyemPSOLCzxx6A3LyE0kzJTQ
Cx+95NwUtjR1tXJTeE17d/SdmPmZc+S8NB4hDtLJMmyGGunhxICjBPIFaYHT
H4Zysz8MoaJfpljDMFYkMzquuphsfMb7EQ9s0w9XV81sJh+Wn0AKKhlsWybr
j/aZ96M6IIDrXJoYywAr1ehhQkYO9QwJmGPdyJg9pf6C+CjPkS7toV7Jftx6
671zWMv63SAi9G3lV5M8/MqvXuPj1cRHYnK4eYnDx+ZueO9hEAwKvK49YD9Y
kjUkrmn4bmjhifvLoNNsC1mVCFXTFo8NdeGDJoQ4hAyA2eZh2CPVqsZGffTS
08JVGOYAr0FZXmaPrJgZUiUXFYUDb7HsiYd+YpgiSKy45imT96qtterSJUm2
D74x/B2vP7T02oL6zBmrPBgBsNKqM6xV5ZeOtyFntAj1Pu6Du9nHxdfpy4KB
QYRns96HF84EtPOuRFLtfyJBxe57nHYjfdzo+ddzIfsLj1WBFKuHOlZsm4ip
dx8EPUCteoOxGFWrvm40MYiwplZxER8Mq1Z/XZia2jd+YZTshcPPM/8s5BEO
bOp6VV8I1ZTuRh5nh58HYdOyjlk4EfyTBWw6e6YcOMv35qrSM4UNOJO1mpNo
tmZ2I77gOheXHQoJEEHEHcCAVUCATLiK+QIcUCNo+TJrS6xLuhuxbSDYzvIy
RBXiWNbeHcEk3xRjfxh7reKpqWzuJENa8ZcJTXajtyg2t6w5YWUVXBzhXxBN
kEVTmra1vVjY8ReIiU32Yk/Bmx9LFNj+J0IW0mRBQ0FyhIZlpp2MjMfuPQP1
Y+xc3Y7OaXeAyPBT12NULvuLVuL4l33ZXRaq134LVi+cYRBNU1gbtOwi2KGZ
dYaaTfDfE98/y50o/Uvw4KoCRzQctvB+gcPNDLYyubA6zZWR754WEjix7JjP
MpZQmKIhIc3YCDc2x7GDuA3NQ2hLKtUdRYOUjn/+jQTVqL04xrtfWWLuFuLb
YK64VAb7j5aq4oeQBFg6xgziVWpTCwcmq0WPAGb2EHh2o5DAiekFGsnLL3Qm
DC/llAgsJGXDJZN4+8t7ce+jXBWWBDBXdyFvnCPiMx2bn6fILFSeMWRsFvLm
jeHdsnDWfKMz9uKyL4PYNuUaH68iPrK3U9WKv1aXrJoNP3ANc8M7XXHE6URi
ZR5YaRzG82/kZTzH2bRwMqjc/d0VSYzhXgo8S3QgjlC+t3IxcCR92oG5fm96
jnRXPuqd0ak87VRhAZfc0QOsPPz6yxmqTD6rr7A18lbZH0sWThOdCnsIh9aQ
XSWOJOKYZ2xZulZR7VnGfuIz8HMTnVoyO7FwTo7oKeShUFQbKbz2cmCcMR7A
aEOkzCh9WzyRkIeKr+uASSoNpFW7uxuHISxOC6jyR5gkGA5sIqC3b3j3ftgl
Yc2mHwcRm/Cs/GpSb9Navcp6DO/HNd+8m8fjjS5aZgRgMCOoOFewUO7lI5sM
NoNy6fipcZj4aPfVyX4k9EZZZxAWkLtAqwQhtu1peHCQYJSODaRJ9FEfkGyc
od6P2CpOhYL9slpkqeJC2Gn2EHFtnIfCobJ2EA5eauNoPy5JokDZ9vTxafxO
sQjm8bAlHC/AcjILwd3Oylh8noY0/NLjQ5KKJ9h0zr2BBup4dEZhfVGDu6XB
bFM/HOGieNYffNYIdbBS+/Fgz6RO6FVnpaYcPBs4FoG7wwE1dk5d2m5P4jrr
vydj9SugVts46ka16mvYjzNOw/NwJ4n6HberIoZaCxoEmsmaRZEoxbDx+EQ+
H3kFZHy96mq5H4nKVScJmgXQWrIK4MrbtoP/LFwUTYNYoP4BjiNYg+nn3o/z
FffPYarHEQAsIBSZERQjFXEJubWZX4bEOXvDLRfO477Dxud+lKp00Cac4F2w
tLJs5fRD5SBcaMbhcuEaWb06bHcJCBqB6AdrSqJQjg82qhHCQrS4sgkQMAdm
sPfVC0J4PXyFlrvQ4tyYWBVaOdGlo/2hQGpOLwAJhaJaCDwSvm1r68IHv2bW
pG5r+yCC6wHPA6wUN//mGh+vJj7iUA1xNLIzxnfY20QdQQgUfi+pNMTiZF5R
iDxGFmPV9Y11txEckez3xkYujEm5KIH42byxzKnK51gvXA2IQFXmTpVlvHhS
rrzaiLlFhlG5UDuvHS4HrSHwaFESWcXfYJGASSC4fGC24gVtBzP8PclopCz5
jUJLTkx1Kl1EZ6ugqbH0+AhoxuEKoh3AEOEIfbwK0joiOe3AQD0UdSpBYYVT
7f3jnIZYMuh7ZgVDa6H62rkA1ZYfC0awIvIbZeMkOlUIKqElGeMvmuZsLG4C
Jawq9aj2zZvumcPAKqjV0bi7Zp5yPzMwsGbTT7rOL+7KTp63s/OKvH/sKBxK
jstgbZJ9ATds6K4SY4MzlQ6sKvnwRTvyoAHbi1LLgmej3xsul95E3idWBqeb
JZ0o4C0FQmHab+TrZfYi8a3TPyivOrPMuCv8nddmFr1tQ+FkfMFPmKUIDlSA
2+qAlOCYGLJNDyyzOdAMy3NrlwuyRt9YOFMw04ECfN6xe550bjuQ2Dd540bj
dKWBwoiUU7OQKIZjbL1DVT0n4DtIQY0XHcGBUgLD/Drah/AhhUrFDrT53lCQ
zfirst7YPbVv/hJOwz3C4V/j4dXCw5rNN4RQwng/9tItcdX2w6zafiSpjs0d
DU3m7JXsZGFMYbFDtxitxDLgjXmORJGBx4c4JwkVQ11Ki5HItAwwS0guigMR
GwIUjAEJ9jRWfb8YhzNqAUagvEDpUtwdtqp5CFGAmaz4aNuxe0vxp9FAWfJK
CPMunJrq/4nUusIgQHogfGYAznqcjWEO8UHMP0kERuw+BecukKXMzkPw6WwN
+NA1OlMh0Q1GJsoTkpXAYgw1TQLhfGfNhzIbWAgwyf7iVNUhEO3OUoC8sba3
8Z70m1TNCJ+DbHzrZtB981pZL0wvpW7LLUFMBMO2ju4EBn+RNrJwwngdrJBh
l8Kza5XwHgo+0jBnaPPk8JDGAGOPLrsADXP+hzyPBMVLoGLKBsrzHYtzq3Ay
NvRQenbZjN4Kt6a15qGFrynGrb0vOM8iY8tW59cxqqY1xe5S+QslXYhXRSqx
Q2DIO05O8BFOM2W+8WlJwhoBBHOIU5VHW3kmMXYEWSlJTjloCqx1gnbRoatn
obUH7ucQdrr+fNkaIqzKZUuxW4y4rsT6iBBeiywvPIJfSTtXWT6WH2wvcgQC
njQ9ITo40RNr8hvefSDteNaplXjvtD9B/dv3sOxCVXFus6aKQz6D0tiGA64N
Qqb+YqmSBVZCkHYYrq6HEspnbBI1KZo2BftFvauxC42P5nvzKvO5o8HM7LSK
A0JJDalOYHhXMBuEhWIAVLgy5oDnpEW9ECriO2nFtMUvsWEXHK0EZQl9i4/B
DjYAC0LI7AX7ozL7CO7bUC4v38Teb0SURlKvhC7geVV/NSpBrGEX2+DB0zFr
anxb2WrvRfiZ/LolG9cWiKAEBBHAMSRJgK3tnDNfR1EJZYuVX8nG5V3Kw+5l
bPcaYfsyCLSvG4hlatd4eJXw8Kl1iWfAauZDPZMq3COv2GcbE0QjdBM/AxVP
liwBnIn25CaSB/AXZDdAaY3ZU2rA75SDRiufyKCVQbDmVTlIFRQvVDmAHQlw
E+pSCEnWMDpjgNsJ56BcBOHfZ5bjciBIAS4ZYumDtjjYhKZl9i5LtRJYUthS
1q/TPyhPUd1xdeliPLYvDZnC8qco/RxfFkykWnRPReh08H3SgbOsDCmZS2Qw
nyNalVdrkI+B/kl9Bn41k8Uds53YpDTy1GemBJf0PRURFqoby2ORBU0hiGi1
87DqfDYqqX35sPfvV3FBVBNdcfqhTWUwg43CogthTNtC6HbVNqwvbsBC2ObD
mmKlmFlU5xv86bwalpjnj7CM+JKNC1YhFKcYefyKNRBla0CupNCeZ7xybWE9
iGULzDZq1VzBYccTa8naDIpY27U6p2xEZamKxkUaBvxjubh/FQdVkcY6n/aS
zg3FjfZmhaXH1XXaqZIglRTixfED/MIRO1k3m0ACgG0MJBWM70EfGHUOznE9
iCRhxY3lx2opEHabsgx94hAzZAFPGRKSzu4shHTK4CLi85+w7iKNm9Bmtiq1
JYDTOuStaXdAB/n96Vb7Pcn3s+v8nnhy1gpdrmpY5GJ4vAW2hyOwmUobcyiR
Hlsmmd4ZtDadPylbYxiXgPbrkhPgvDhom2YV9foG70RXyjggKk4IpS0mrjbS
HZxYJE5Aa1IRlK3GbylD59bjDuFl7udknihQn3pGuwnRUx2WRHml9ActPQP0
ffOkLkCVRGvSuoBlrGJinWfkgoM1+XUgpl90QsUuOLA5hqNtvmqe1ql3HXac
secwz/+IdReEn7kIV8KQYKEtDbbELQ2upQF/vAMsDMl+sTQ0qWpY5Bo6S4P1
h84wikFscbDzmtipqmqwNFi+tBcpeq67WJdUWSX7maevpcEPY4bg8/Wq30nO
TQlDgs6zNPhUtzS454OlAcIA0hOqpszi4JPM0iANF1karPmkm6RxfHerektD
WjNEafCRb2kI11CLsO5W1QcWhkC2fmxpcKrG0qBIVxakIeX471x38XvqB/rO
zOrppD/wtLs7Xjj8a2baFBHuu5VJLJzbLsMJ5C+yRmL5yRrOHkhNnMxZD0vH
EFaYSjxl2cs/spEGEr9XB+If+apjmdoExzKRc4q3YnGsNFhhSeStqqlllS2C
JTZHuofSoewlFtGldiBeNkzO+5X4nM2RKSySmROyrIwWoioLWUy5nCWZ660f
cCkLnkufk6iJ0cO2+3CI0xrRjsc3re9ciJegfekWHq+2jcHKEZytqo+Gmk/g
/GWrhD5UdwMsawYPQ+8aJzS9/Ej18FPcD45h6T9EP7Q8h6xZJQ7jmOrX1/DO
/bTY1YXzMbXmUe/A6OLH/fpsSfAhLMKRzmfFIt7aMdJMZHe867gy3mbhZOJD
xFWwJbWoeCYG0jJcM5mNrts5S5tYKFjW7cq8wCIL+aGd07Tybbr6G6j/C70B
PMvSkzVLeYKsS54QWxLsdkU9Nhi7o6lrrApgZ7tWBOxmxaZOGmgFG2X8Itjv
jChkGp4u3gRE4S6eYT5BdG2ksIKVmUF5IBBCvJeBczDkWPPPaF2kb870Kylr
rm4MDB6pCItw5RND2aNKaDo8wOh3Tzt7x0Y2zW2+lvn6ZxlL8LdPb2v2bUYs
1ceNre523OaOXPW77mQPVXV9g1q4dGyAK63VfUEoHKw7dKsrYJw4TepRckex
DCV3NMjI+ASBn1ZjqQkA9CEdGJz8XLNM7Q69q8u1UkkERXtSPhfuY5fCXgXn
bClbgb2fsTao8G1VuALHERQFw7LhFzkfMyaNe8oAWqUK4MhwYgbpSl07rbiZ
vKvxbsKZdHLQE85TB0gX+ii2pYjQvCOVWBjrHiM3XC+Eb+KefiW6EyFbgcXg
O1O76pDHTMyHvdUvKcLXsAmefz0XdOHgM5aBlufStCAF/G/TyXjRNX7/KfK7
2Y5tytEWay44U8k9rbd1vH9BsafEqB3y7ck0g72P9ViXYGEYlLCtCp0Ji8Yn
MY5uVmurC9fzb+RBA7lbDFiLlRRPeP7BChR6n+XkgdEPWJ0cVqgsEhPOXvZ3
S2b72GblBqVAKA8GTd8uMaB+pPWqMnUQDfDfMRVFdmQDClYxw/ENsAZSaetV
2d6Jtl6hs+kHKBJKV0/aWWU3s5MIDATW5i+bk7B6MNteUKaDCaRL3cUVnWeI
43i1OwjWKcPsXjmEIRdOdkRbb69+vDCZiM9QVV3jvm7GS/UKouc25+LBfE8e
p62KwGh/spO5etr80hP1at+8iZFu/jx6dHlh4/tPOSrAI8MRLfBFG4LeHA5e
en+ucVLjYGfqmZjIG2fOuO8TiFFm9s9I3nsudrvPKqwB48UM5xCpa+bCBpb0
C3XlNjRGeOJJ1OWGMgJRwuds9tGllmdF23fs3lJznXHp3NFJFUXumIFaVpAn
HrmjAfaaPTEc1KoVF7qFc4dyx+CLIFxiwPYi4/sgQHYq8ASSbp2yY95jUazd
P7WomRiy8SP7ng4THAwkrgs3dOHw8+r9w7gl+9VjR6laCWYy7ga5Bn12HKYZ
H9kZ0vtxS/su85Je6+zz/NZN4QOL2D/87XvY2UaofPlkwpnDetXyMVwBbjAX
rv3I1MqxQYm9cHI4OymRbRHY5Roo/MsdhfjeY/eyONVXcU/NcCy5jr+46AUm
GTduJpLPFJTi/mrck61qGGIlcPlMf4tkP0Kha0sIz5A3BlKmHo6x20L5585i
2UqvTNtnLM+tURZttPfjeCJLlK33N4Vx5z0txOOTenXNz4IyV/0O9SlYRklT
ZRuYiQ/ZElWWVTg+lrXtedidvOp33aV+0m/fq2qlix++aKuQ2MFrfLyK+Aiz
Rt+WXn3jxvvmlnCizus/A081r0Hdxt97KOlwTkSikDNO/fokWHC0knk42T14
QHbFOzYIlFSnjXKntpXucC7o0oQkbw1mZspk4AcSv0i1Y72qjP3ZdZMy/TAI
a5FZxXLt3NE88fjzLHwafo96e7E6QDXn+C60qnP2eLAUhRobF9CYPw7kVqyO
QDKAJRcYOnZ2JofgtJ87LniER/M+bUXTYRAFzszg+Rrysz2gDgLI81sZB7By
GJvm0kZUFkC4nMYDPR5L58tycs62Tp5MyX2TDuZhgWaruHjp+GB7rHXbPe9S
u1GjkZKpDDtug+qGFQVSZZAsSU+eM6YMT4y/uxKTtRDHh6Re2LCX8d46TXD4
wyUFYd3Z0iwTLwP/vU3XEqO5IKThSCvHOXvtxhT3haXCgWt7C3+hhAj5iqXE
1sukNALFBmMYFFhHGBogfDTtWSyc0smRsFj6EdI0hZ2ekj5ty2xZqRJ1ZRJZ
YIWihAfUWwl82cCM9Vr4IAqX65/xIXzaJy+UFTFyevvBKu8wdJ0Gm6edPbFa
LQM8IXBrB9iY3jdstrf7PsePyPVrfLyK+AhtrolymbmjslZf/zm1au1b7TTV
GndLKoQz/S/nCFZo250KsHSJc1QGZdpapTMEG5Eoocv9L4cm/S9fSfpfukiX
WdHjLKU20khwCtVACRCf9PjtK+3ooVwGKNmmH6kqfKs58ZF6kvjRiSx+a4Lu
f745QiTpf6l4ryJODGXh1dTtTZgPHAmQT9eRgEvUq2xYzXpil3+DT33Z4cT9
LyUjScUU26CvE5aVuHVi0GWAU1O6q3Lj+0+yFnFHZ5Cajv4y6X+55RYBQmnF
qqlPa/moWhZ8KTNjlCNkcVXPxtnRGXfDPUG8vTvL4YHwZMaA4FH5xEIEqRYs
WWu8Wt/MfjxW7UYJWAXNiZJNhMXBKqWTSBYw/6N+Sfi7D941iZUjGUlL2Hhu
qGPoSKNQWXfPA5K2hfo/KW4PphJH/O5pENhNrqtW1GuNB+vLCXITVVfjfrSL
DaeCJAkvtIhRfryUJQ/kJlVGa2X2I/tKsB4okZGhqmpgtTwemdKtTDbjGerU
CuI2sGZ4QhOWPbkJW0Y75/Wfc25biUfEsaoQW6zVelUn+pMaGo89DcL21i7f
2sH9aLEfVxeAVI8gj9zVhe5XqlBvuatWoFAyeijtLvNe03601nKBcEKpHpKH
BzXGXAjbTUQO22syxXoGUO3JQRFe3o/aVUYYDGHbhRleJUV0xUcoWcJ+lTuz
taIuCHGilFPEFqPI6qcBLX653SO2one1+plPdYQaL0PvUZ3IcUK4LSmeTB2H
LneSGJL0LM4bx9NG18Z72xQDaeqxLC62XWATYE7rwxHGk4zDiCMwk8N6t3cG
8ci7xseriI/0OqQpk2Kct+8BaVpZJ00MimAUe6AF6Dnr1enUqwsYiFRVA90w
WNjKbTGGkZ+dSeXCJFf+kFa9E3UeiRnYk7Pl4HktuCw9OUVWYP37uLPxk6B1
4Cj0oSdHO0ctoke6PyMcC3gYdlPocmTRAYlsiak+fJJnaTASJodllJ8Pv5h0
WasuzECodCILS2JAvu0WJcQm+LSH9+QWKzgPJJXGZh4b1FPWHUhFy1NDOGTJ
yTvPKF1dW2eKx/wZD2rPHVr1Z5pKA+8PPqDHU7c+BkBHkxXu8DzdqxjfTqdj
RXBQ4anCXwXJylE0Dc6sY11sV5Y3jt6uer7hgFKwmD2AEpy1soXYaG4mAg9a
Vo6tu5MjeUAqWzhao7rU2TBSCJxNA3FeJp7ca4rJ4auJ7yiXHFaOdiNFAFuP
Nqu6CZ7NUVR/yYlq39SVbQlmRO0YLX/qD550KZqVlriN3XtGuQF1SYM6gMDi
RwbECnPMmAZ2qfN++JerLHny9pLbnOnPw8iIuqbgKnNtBsOFZqyYpzr7FXAG
qvYNJ2K8dZOr2WxjgrMghmdaHVtlAI91v4wfHurJWWcrCxjpc5dvAxZVm8+Q
oLtQgGnDyBEiaBypsJVecS6n5tRc1246Rej459ITNa4zZO90eR3cGwpYjnGV
ixtGGUFWnjYRxd5UvtMeQOFkhzod7aQlrMglbo7daFOTYVXXFAsBl+MoPh5B
cRXWrTAwKw3iDqvEG7jz3OlFyX4smq54i6L4bpUAZoDwU6K+ky7fC51swQ/p
blljN40su8uOrVWFfVYtP1kDklzqSRisfv8pLLJ7tjOaXfvmTbJyYGMm+3Hn
Hdf4eDXxkfzSjELOsS6Zm9ShHeqlOnz2lyITDz7rjmaqt9eawqDAstpPAiuZ
ndGpiZNgkcx9py54ak495O5vdp6UuMwOQrbi+lSXenZiK56dYP3Z1XO9cWDG
+hMP4uyeuW7xSTG5bJ9vH1t6VfgDtfxe7wCo4rYzku6jKuX3iccmKafmu6JN
KGNaOXxsengQbHlXOYX1doGS7s3qezb3SKXZAhFhWMBy+YLMr8Tnyh2lvsu0
DSBKhqeCmPJL5lmfHNFjXTKbl6O1dtyuaaf0Hpk9VP+E30mvMnHJCQ6QZ1uO
nEnyYW9N44kufPDrZ5rUiyaYWuwStu1SFUZyDjInx9oHHEyuHMTBRGkXjoTl
hE7JFc/UPA8y05MMxsNcGsYOCaqgV78YnI+Gn61P+r0pT6Zi+9P267F2zBIT
isfpe1hfi4m6ijGxHBvhagQinpYZaGmSMcpMJ8g5jl1MpyeULrUd5irwJGoF
MxxyYBQsZJdcJ5gmypRlERUIUzqZRp872maUAwa0ipJM5QI8k6P4Qh7J04Yg
Xjo2wFGbhj2PMIuv6Qkav3lbMsGwtdO+iPvR9CQIEkyNZhPUhqqni1vGcO56
4eQgJKCF+gbPYv/d7Shsi8BH4HsLn8WGyKWLXeVekXbdn5bkXFOM/Ih0tk1S
Qa/9iN2b9ljetMoYy+VaU28XKzgjfKazs3lZJl6f5JDXBfFSYY+9dmq/vyTk
yKVPo4oOsV+/uyZngEnQ7ooEsrw+NjLJSUm82HyhQJcqd5N23Web5SR3Y9fE
k3AgoLSKFPOfqaChMY16QnU3FvCrwD1vNR3OyCxWRRGZ5cmNrfU6rvHxnwcf
1SOQ9el9tnByoZ02LDZRNoONMxlvTx8kPIL9qrJV01OUOasPimc6l8VW0opx
sv942WpiuIXJ9WJ6Pbmc7rcsb22mGxQ3rXhYQVjsBlWmNgofqzls+NVsqjZ6
Ek1Ql6y/mZNa9cLHC/8JQfLwArXQ3qD6G6JR5hAOuijt179kyfHqpLqtbJXB
9PitcIjyozxbEYbTKnY6Jg4w7dKz1ie4y1KSjoo4DF1IB4KYEbmqJ6wuXbI8
7cpOiKvR5FOkkpPe+SeGERV74fCvhY7yrD8XyHwGH//s03z8pEUkFi0tnj2s
u5tKjO1yEBaE8qgqPcHH5ycTYXlyK+O3huMCVs4/Win8+hJj0Zcp0oll9d5Q
E7ccZ/zclg/kSo5AuNxP4d8XqZTDlRn4mnep4NINSdf5BHMvZ64J5p5o7iaY
+3TGyZp0woWqMDYxnptYt0kRiCdqMFrMWxBv7sPRhakpmltnr7Eb+Ng69TRf
L2n1E4LNOgclOQISL7IdpkKFSksrm/yfXbdeVoB6tAtvjrsosERLUZbdZOO2
sNH7ZlBC267cpWGLfP1cSzxvXYXGNf7/KfP/NyKw2wbplm/y8eYIbGpy2bxQ
1a+pUB/kWSZ+ftVbLfV0NlmxigMa9ZyOE1m+MK2BIcj+7JrMynOagCJ+5kIy
Rec3VkDB6mVJn1eY1TyNmfqH5hUanHbQFg/qsTgg12a5FsjlXdKqm5KKEA7q
SWb4uHrT3F/Laoq1nrmjCgHNucHDuB9uIpDFDZqWE0kyLxeVpPVWLuFwvZUK
elzJohKOHHNf0qxqHtxr0bFq2/pTZavbwgYz1H17kkvlruB+yxxtMguhOTL/
Cuy9q3GeEvYTxLo+Ik2UZ8ZWx4pOOXB2yoFkIIDtjKmZKSgMnZcnPoUdRU+d
wnENY8TygpX12CMDO5O5ES5tMDBl0gFWMqYZ77lEwisCrr2kyhhW/mQGKJWt
5mqqF52GTc133hwHMPcYHiupsixblZElrfoGe8JE/Wt4lQs2L0/DKVttFeaq
zARP+9ph1shb2iEBrOGSfyw5oPzicuqKMCWpm7Qjlp7o08OJOOmz8JB4Ztkm
lDJJ5SIBGkfsPsU+B7ljWM+qrg1s5HOoZ3KeH3z2kyaVE7+Rm5cR962aecLa
aM37bNzXDez3XNohu4pZrSufXuDWbHuxws4IL71IFvkVlcAxK4GLprvWACxg
7Wpau2j16rRJYN2SyHWmjiG1fMB0lzmtT3q+qgJwmexAXzuD0Z4RtBXwYq7B
Cq6NXkDuLU6tNY46c3YGTyRDjhkDl9y418SitErYldrJ0+FvKhii5ajiqLXW
85ZkFoGcWaa5UKrgUBp2rLvwQ0n3V+ZnYhApmrLAAThP/KL04Uk0/JT6vOem
XFaid19VoPggrHFHlQmObrkO8xrXr3H903UVv9WmVz+S7Z2CmH1k3n0gwb0c
H8KYMquEiOXIdJgnaNNoUawjc116Yg2AHeHYbNp+ZbrARuU8obVKWFijnfH2
ivsKN5h6qoUejwNx8eQD2JF2wKAJtUrS8mCmwo60gcbupRo1gjFx28Wype6c
XCPfUROn+Gl52EtsiSxm2dsinwnGa2QiYXYdWY3xdkkSqxu6i8FPZ4o4CvQy
Zj/HNqqDe5eRVxmkh7sKuY8jLkU0pULZqkxU9yIIISQ2wdp81Icx5IZ3ugrX
yZIIRabZKuZ3selb6BjE7FNc+9bNxNioXo69KU+OdD8HDm7IG5vmP7OT+n7G
qwuyk2klxwerPw7nITgBliBti2eyAjVZjQ1+OSy0sPn09SkLfdK4oHpTjvPc
V+xWH685LEpcGWTm5HkGilhASLF2TFs4HG4jC3LHIFlAMzwN2s2EHJnBVlId
5TwPmHT3tXpl5N2qwJsyg8Uao24wjPyOI2p5of0J7GSbo3CzJanSZFqIIcmE
iCOvsIeS4lLO67r+IOmcM08YXDyAa4zYnHTPI+HD7L5Wt7UD0w6bfwpiI6dW
d+5SD30OOdGQbaGlHlQvKbCMCCAnUT1eOTN9auHAHUWOYDMZ8eGL7qHv3tuZ
zrqM7aoPL9bfhSx4AwKljVN8ScOd3ccUm/xlde6aID2Wdu1eL9SR+uJBRy9O
8xmjGbR2dVFbD+51ItaduyAD/IB0PStqil5zXMxVWMnuLJlrLLfyRgs9SM1J
/wR/xnZiuaOsP6CnGEmXTSlr210QK6XBNeX30gm1MPvwRRALiw6/4A6EeEFs
c9uUQhe4sqR4Fh4maRP+4YuqctlxexB1nV9cs+knd88+BWJDtWs8vEp4qE6W
nIFQnfPde+acqn3zJhB0NSOm6k2P94Pyy3TaDeSx0Afhqe6eKM06WR552dkv
qBhifBShUGcBBq6Vxp0aKPtKTAULMWSPJZ0s+yWdLA2RYIdg+hmK6aoucUOS
Ci6aTsQCtVhbV6Bd0clykhE3eOY0Vsw6QZcOgqRLFxk1Cn/Hwdu+n+5kOYT4
wZOjQOo8Od2nCwMZ8stxL+lSoZn5/B/1aaGT5Sa29HT06PKsTeh/SLO7qILV
7BsqNH7tG78g99Z9B8QGo63vKrvyb4KYI2lyvgsdDKrb2p49Ti988GuhTuYe
OW+PWlaA9mHN6QV4X0+ffGpdk66yB57mlK9jA0EvG+GjDhOZwbxYNxa0+L2F
+R5sScAX5NGxq6zfkCN5zq5L+vfMCWLaQGUrjQ7VKMxJyrZFSquX2MJiQ1l3
5cbiEJyWxoEYqVO3QlwKp1raEXBBZi9CZbhA8ULaVZbne6bdrQpECAU10sWz
i0DQDLJ20urQp9XoGZR2lVUN/pFXoGNsj+nT/TVjPXcM5NBGoLFl3oswT6AZ
sbHYtnvV11rfrZstoeOqlV8BK2vWfw/EBsE7bw8fp+WMO8wWZlU96aYkeRTv
RZ/iFw72dNb+cc2XdON1915nXzz1M4L5YPnF6qk3VtJVdqRmkfYDcerX8SHu
Ogcrz8EQ+DiXa/KxAm6oDwI3aFdL+0pJZBvDod7eiljIqB7bDH89Qdl8/N5h
JzotsGYVZ3iNs8QIZta8k6HJdApsL01Uo1wSQkiEBHuLsQ+AdCquoh2ma3Pr
fvSSIwqN7z/JHuYQ7CB6mosx0uBiofGFU9NGH2kdQpE78LRtm9o3brx71qnq
Nd8EsZH6NT5eRXzkFAS22o/BzKqVX/Vurtn0Y3qX8DjwDLCCCyY5ei+cgexk
qEeWjmk2wpOci9M9fHxlAaMPnItjNBS7F+O91WlDUUIuHYeK+r2zbd9w/l4e
CBfqySkIOJoimC1OsOILrpenZw42wSywxW7TQr4bUaPSq+7WfT6JbKQ9m1kt
mGBMhfLDy+CJfFCDG/SE5EVCx1qvQrNrsgzO+CBmn9iPeif9xE8Mcw3ldMXK
fU7Ai1KnVU1NwsM/k+pVz1XSaRPhkMQj+JVkGQjhyalzGxPsPp6EeT95kV0X
FNds+AFORhAHVLR6KglHX8T4S+eppTB5QByH8OaNlg4oefh0aWfNeUkeHksF
784nmyfjhI17Hw1iT8bBiclY0rGBfG/1JsCR5IMAIqz3TjvruvE6e69vzEun
KfLEc+keLJJanif6NPaKiqWTWXaebDg1iFyon1TqaAoCzKJYw4TGuDuAQUfe
BYM4y+A1Z+3d48c5KLyW7RzuR6LVwRGs9eEXxErOaeA4BFb7MAKBWziA7dHO
yezal5VW99tzP2pWy1NBBLMHj+DqbKGCON6FMgJpBytBuC9x5twLUd22jnAa
qtd+C9Tq/chJT9qPYCZ07G3TT4Ng6XL2UN2OzkHUbWUB1tdxDcbRZQ2y/som
pgeqBMlu3PsYYW3CLFLh4q3Z2TULm9CVmZoLHlKxxpmZSgLNDuyV7kX83Ol9
7EUjFWjbeSyTtTsvBW2oWn+8/whNHgapc366F92EBkRj+MTQpAo+79XMVEPw
cHnabQlcsb+BD3iWdLIXsc7pVLiBxBsLiQ+OJ12VSpeqYnUKEQiQPbyDNZHV
qufW4Z+QVb8Sm+Z4VtmFQ704P0uTL59/PZf1XfhgED28tAjm6l2zToE4gOsa
D68SHnJunuwbj2mrWvV10J0zT3GOm9CLDe8+iOPZmE7FLtW7BkcTHsj9VTwg
yPZNok+F2oeV3WdLvnHrsM8TtEnpYr23enBjSTwFz4PwuNaaw2pvEwR9KhQU
K8PiFJnD3BSn2BXUC0fKKEF94TTXrgslrKkyDv6m+nSo5+wNk85rKMj25WWl
rHc+d75mSIHgC8CHT+2bD3tLn7ITAd1jnK58lrYw2pwfgCeYJawAhAO/Na7W
HBJ+M6L7BV26vwykLtIcPsgOcZ6RCILfTzuwDy07OI+wSGo2/gj0O80i5aDE
2AMTPf/CzqNmBkdwHvFIxqYJvaNodWXZqjF7Sh391EP39ISndHgjZ+wxlJE7
KqlsKlsF7oGcVU/mvqpXfTol9uTwF5JzS7ZNuhfHey9mG3WdPy7JzhTPYLRa
Mfym0yoV6VFfeDDa8yhAyV5U3YpnEJtdc9QSIu3YvcKMhaxSkEKO62o2ZXNg
b/UFyw4iyFAai5rPoguvCp4Y97SC4i4+1MuTSHAJ2jaX96Lko/FAD030IuYX
W5ZTQ9XxECdo/a67uswr6TKv9d3zr/HxnwcfOePZcbjVf0sOrv07ECdabv5p
eL906u4uTnGAND9FTyzjcZbjjH5oI8A93NjRqEtH+3M2hexIaGOnDAU5qAgy
U+xkSrIio49cu7DvVldHOEUhnToz1anqOG+8uIzVBfYSoNbgQqZ50eUJClJg
//FXTISOPZZizHunx6gtBjuTCodCngggwSe6XHWmwUX2qTyyy5W/6m/CHI2y
YrOTuBHECmxyHw18k5OvWafCSV34pl9JWT/Fh7BWsOtdTda4r1sPRa8nasYd
Z1tu7wTi+O1W8ZEz1znYO8Z5iG3ok7Vm4w85AbxuWyfvR/VSACnXLJwNzIIZ
LFNjhI5ZmaP9HRPHca3hQDxLeNzDfhZGRn2jGMYUonZukntbdIyBLE+dwOL2
S6sjaIRoTbEfhU+VjTNQ1SyOkiYVNMKhVp5ZOYvoLWaQ1f1TnXpZe72rJJ1K
oAntL8pTSxrOJScsEWzi43lNLXKWiqH2y313jg+63CFiS9LhZPoH5enEqjkM
BrjaAz4kXFzX3HmQoua2Rdhq0GaurJHPqJp5OJbYjw17HgaBcfT9KTucrQHu
Z2YGt46PdVs7hF2UY9x8A6eZbL4BdB9L3W4JH2KktuG9B1llKJsPIhyoNjeu
KN8I0bfd6OmP0EMD1JsMpk0SJT05nJlzWqWUdpfmsrSWvr8QtesKNcVOOm4E
oVATVXMfqXSQTfvSfkNGert8MT8bpAqaWUZ6swDqzHLDe4ToEkZLk0mmJBU0
ymW6ZrSvinAc8cGuWizM76b0Km7+pViVMhYcfMP+DSNASSWza0ZPLUj6uAnQ
lWQLmME4s8zXxkc5s5o1iJFHtDiiT8PdlYnYgLBm07mXj2mWMOxjdvBka9MD
PUAZ3MA1Pl4dfGQuo37n7UH8AOED7RMcgYqjHBmCI4hd7nNGs9KgDKVBsMYu
Phit6GXaj2+4QoW0Ll5R6wkj8eg5KgxklEVSWaumMKuc+8NqCBNIRAe+YqvI
Y9uT2l8sIPSrMW5wMlgvxkwTzlDrV/zFLfOrTy9IrKNMfQOYorPVOSu2Y8J1
cXuhQIk0SntsTkgrtvW9V917w4M6LG+qFVzhjn/zWZUh6wUyR4tJaBeshxs5
ui56hOqiF8see3lrAchxnkDxHUWhDzxtSwryxm4E0q5g8Sfp/4jR+0JL3CP2
h5HvGLtN9RddQY8tLySGoHsSBVRIlH2yZN2oNzHhy4X1xtfWnJrLdVcPGRX/
jcvM04EZ6oj4qrxaNxJP0YzahQuPssjE4E21AZ/n/sGsw9Cn1eF4SQbNqKpq
rSEWmXUzyn5VqsjEVQ7qSK9KGPclSzscT2P8XN0YRitzbEsDi7r0hPCWWeqc
v0QtqhNMSNH0ke+cVoVLpGzzdH9HNrZQVCznKJnrcjYIcToDmTYba3VS1CUn
D6vTt8wIwj9o+xwbmMb4PnyRkyKPDQDh0GVdiKoSsegtcC/FTX9G71p1J2Vn
AyUa+qcTJfvLX6Y+gPGIB5iw7wxIkwglh0IkpwBSrsFie/RNq4Y8gkkWh3uW
MxSNnaz1EGIeWwg72hmLSoGvnWEW7p5R9Mx8Elqfc9izfGEGj05Mv3poENSs
UhOQ9laCSF5D4VFXdaNs07lfhP9bMfg+tnE8mkLI/hzNjNI9VYAzf9qh8mlp
4YDrmrDj08deqald6qq+QIDyzEQwRprYepfSqZqrJBafSCeYnUFUuMmg8pCR
I/cum2L0oyXM9Kf71jbtUt0MYfvZqKxrnP/T4Pz/1xRH99t4bCj971w3M0/1
MfNliUD7mOfQnpn6aJxcOBqtYlWTrfoDz6Zx4t0F0e5L60b+duY8hsS9LjIz
JvAv9a9RDQuW3aNpWFJRvoFxPSEANB/Ck/E2aQ6KtDSH36jUzXMK2G+efTfa
rktLI0BZycSUDR5qkymESOsgXCqz1lUWxNV7qonKWTKDai575byfivn8TU8e
ydTM4FPqmC0Nj8epUJVAjn93Nse4J7ft9evoxEnmfyyTmNGiUWXSPHdthoxD
oJyw4Wr/vjUzn2vy08/SCK6fgL2aDA7/6CVCJNyBTpGHZ5OJVR/3y3TUn8DQ
qUur1rKZl+pWYrVZqMz0CoC55HgTDk8aVwJyqV5RUz4M23E8HbuU9aVCN65m
jmtlproh8amxnLidNYB7DLlW260LDTDCtlVUnhGkjKQJhL00sf2gmibsS+wB
hqlglSfzmhZDXpMqTsqlqsKUvV7jsDU2xyR1GJ2pt89MPNCellzCsGAliCwB
/Hpa0lmdT77waFIyK5zSAldUYss5lctoD9StY/sXP+qTyd8l8Wb6E1l4oJSH
wWdUxvxe3G8iRdBImrPKGH7D7i7ukla/6078N8S/1SP2wsFn0i7Z45I1XURz
bl6mCw6tY6HRm3YHF4x1kjpNXO4c4VmMSa4UwqLGrZSRHKEg3N9NZXr0dNIu
9sJ+eaRq2lF+wrDdJc4y0NgqXWLsumqTmGogdt1DWu25sfpf6CC3/3AS1Td3
hfOStJ8r+CR51bQmGoWFUzw7D7slten5hGm0Y/blDgruE2nsAh6JWVu6kpEN
UaMMhNxQbyCCC9aw1wCIXbJ3dwlhWcufpSukWeFEaV0xuaJVcvB7TrO5Jg9/
GvLwe0yz+S3z7aiLezBiCceOPfLeagdS58qbHL+u33kHO8keeAbE9ozWxVgw
tWOkUsNpRptOPe0d+k9yhSdH9CW2hPHrph3W1MuKIeLYMP8kW8uJ86vc2QNC
5SkJq5t1rlS+gjEP43TFS+Z2OfZPfmJylm+Q9wiuQFocIVechQhf42aSGoPC
yVPSXkDglAMhaQcTZYjhbA1OrbeX3bly2Kc6Vyo48WrSAR+6vbeCMaCxe0th
HdiiGs3C+WkOq17uXPmkJr2mnWRv7To/6QV0/wKNwl5eCGKRXWum3DXz24kF
4Qzh+JFlhXVbbrl3bgmoZuMP75l9KqzZfAP7DeEetz22ohAEMyDZiTizsEMc
y8DacCcKbeYp08bC6KQa4Y7VEGSPpyQeleeaOqvi5dQIiVlkbHvGLdR/Rp4C
dz/O0AmZSfLEoR4blNQyfNxX1R3M78NIhmwZf6sparLzsDM1iIC93zjm6cRQ
n6XwZXqqKYeDe6zW0uwydw8CTVCr8CQGx5bfeZfzX4yHqZctXtbhOjy5ZP3i
x684F3XkZbwaCLyGrBlPDMEm3P30AhCHnzi71LDnYY/T9kTtmvXfD++axcjc
+u8T3auOa62eJ3qNj/88+Ihj1dUIDe89RCjcxh+CmGla953wrpm86qYfYf/X
77obxHHeXlOoWmffQOphMs14BycNE2QpXglevN4bdilUDQic5Uu4yxsDSEf7
u38n1C+9W0WcoGXNFqywahrcmf/4YOKohThhCiutacAloQnt87Nlib1CTQyZ
7VwUbwqu6549BKRI6gxyR41897SmJkQZlczwHyPOqqHCTwcK5kOkj3PGeF1y
ZprjtGzNDxa621nj+08JE8M5QBAWnunyu+SHTHG0V1lCImW8c9phw4Cq137r
tumnQwIQo87TSqtX/63zfLVv3dz6rITk9Kl1+VDZSc3G2r9jNr96zTeCyGia
BxYVgxr3PpbMg8f5fen4oIRfH/dlVlcRTiyCyw8SV+Djfq7Qwy+dUmTq8INf
B5rwTnw/S9+VS6U0FE03WldJP+/HtcL3K2P3rKEp6nDbuP9JYVRYU0BQZO5o
IxITj2aN/B9sa+91Ht1H+iiDHrsiwuX2CvRmy0cjDsdFmEpbjA+EBGZkBJ9I
cDjHBmV0ALhhdw4nbw9Fpokf6raCQ64fX1XwOLFgvViBoJwMQ/7MLROxz4Sn
uV6/66775pZUr/s26FdTSyuXfDHsMPEMbMpFn+84+UzVir8CcSu1rgJq1ilP
8YLkPbSkyPsRTCRCqvM0YigNNH3rZhBbIjoz0lAwmXvjwNPuYYPD2XM5oJ2I
BzJ/D7/wDPPWJ0cypluebI0jLxPkFTbu7Yb3XlnQuK970u302ADWJ6tfSWak
I/ajrGPZFFh4clBohW5KyGTwt1gxh4xV65d2/YBpZkv10onhzKALV9BdFREJ
Vuvjfuy/pw4P7Lf0Vn4fKRl1ehR2G9eDIBmzwITZ0X7OGWjSFtlCUTjQI3B1
dv3uex9ZWtjwThcQ87eHnzcKAYIFBWajStUrxH/HUKo1G39k/GDlkuvaZ5eF
FXOjILp5XFnF3Lh99hlQ5bIvX+Pj1cRHVl4QqhFDRWFNPV0GelUVUsv/TRAR
bLruO/fNK2E5Bhhu5AArBQ4+i2dl89I9j4A1sJYGBfHUQ+dYqagKKYdYjN3G
iWfjHD9kg0y/N1uKLefQThBhNyeHh0wos6raDWVg5zC4dTk7ur+7LS6Y7/hm
2Ljn0SCCHF36uJ9tLlkoigh5xpCzPfRZPuwdPkFdjltB6zW+3wNEYYOdx0gZ
K75cYOn4fNJTG9yFNLh+H+fzsxuSel8cyIbtXDo2kGm6ECzUZMK67b9KJhPu
vpe1TbwUdXbmqJBe1ZPUbe+EHYJFBoFlFbPD8OaR8FarZrS5efi5illtQLdM
KGsdHykFLJuKcfyxxYr6YOJMrFr5FSFPIyhpVtZs+jGIaXxYZn3p2Y3l5DBJ
HkXwvQfDJ9e6fr+2ZG7iTQoO5mwF3jhpZnCoF06R5L0Zsnj7HvtNjfufUM8x
TkfCSzukS06wHtx9yj94jsEO1aDznkmviQicociogkFd2md96L6XcEed48Mv
+CTKripF/qhn10F2aYGqXhRvlBQEaVZhghTGqa2jfbLxtEQLUY6JgTUohiWF
ex4OkolZWzt0TScRag5IF9kBEVYF9o5jlYo6aD9ixatz/m2nKaWginmfAw/D
multgqjdK+V1U9u0G3gOVDmzTSsrL2a2CW/F6RrXrP8epARrDPJ2DyuX/2UQ
ET68+uu2fyBsSbYSHjIe313D4ZawvzdOeFneUNDeeiwPOfKyqkXYqdzAJLnC
9yfvXb+jMyX37btB2GTEOGr3wvrPKazPUX8k1W/Kn8fqNqpxZ5MpV7s15Yrf
dEWrEGaq8fEcWucDoPJpccm2olIWioytRtiEfLh7NNLwVHkvdIvw6/o0hBYb
1fO2XFrj/ThoZ5Hn5UDjUJhCLk3cRQN6rLvc+SAkk2mJQaycORGiTHYO9iM2
DMwbEHRp9WttwnYvlUNGJrW5pWdFw+Q2oHZ9y6/x8WriIz4YQg+r+qLurXau
t4VygEMTdpZeVUmGKxYJ5bfvc/HkKBg9dds6gdSWuEMIJSm0MPxKB+SgUDN2
OlwAFwnCKAAboFd3dDZyZ1uH9Dy5j5VDWG/VNjkzlFPUoPkPQuhA4eE0ButA
FJ+dd7hWC3LRnbM2iNFVDEzIJNW5FTszBB+UKFNNVcehZTSgAYH8uTKycG1s
/IC/YDQtscc05QN2T8ZC4QlujAv1KlNUsJ8INlKVQwwm0qEX7h5GBxFlmvCK
wwQGhVNJwoIpIg7NW53z3Y6TzoDAgnb9z4VgYRDd8uT5fz++Tfvu50EXJrZS
r+KDYbsB54L4/LzP3THjNCQRhOMOu0/nZtSZZRl/Y6+UY6XshWHb1L99L/jt
gRpd5hOT2iGIH11WCPMRzwpSa4ZhrhnFfvQBBgtT1hInLcYQHJ4nW28FeVpf
0l06d4xD+BuKG4SG0pQ6mkh7H8XCsL31zjuwDJ6fin9i7X246TRVVJ77K3e0
MeJwEGnPCAcLSeN+3PMoSK18BhsbxyFQApLRinqnS6C+89y9vK3QRDClWacq
+xt2jmtgwRHJJRvRxPeCiRuuT5C6G34gpO72zkHEcZInR7imUvggeez1u+7E
5yoXXwe6ecxZnInhLU+fD6L/MC5o37XyP70agNo/UtlKO+fhSklBDBMJxi80
AwhGI5Y4vHMGbEcw0fVRIA5ks1SDQdgLtW/cCKIIbvqJMY7QsXxoofprTs0l
upY9yWHnlLsAoPH9J7lxVRkgPfTGL7rOL+Y8lW2d2LNalXzPp1B3yK+yqep7
AyXNySnej7IMk8kpb9/NQZBCKGviqzI3Bu37SbL3l7GHMfd6TLW591HvR4/P
VSSKFdE2frC99IT1u+6WXEKujRaWEz/Zs1Dgd9jOYQHu7vsCzaqLsQ0VCqNn
j7/gn55hh0tCxuyoKHKouAZeF8yGyw86j/3Ypzy8NAH78daulf91VHDrbdWg
/zI6uMbHq4mP+EbY/jHma6a04WGrSmG8DXuswNMIIijb6jXfTPVqu8D+BZYI
Oi2Jqm+4Hn6QPh3jsfFaeDkQ3pL5S2WaoJOcCpJevTtQhiwGEz16EcTcza47
XSt76egAQ27drjOZkM6I5f4nEjtn5+3QzLIuInY8e+9B4y/knSmfRiYeeTmp
Zc4bywyZKxQ/eI7Tsvd2A7GG5dhAox3p0Mv40VCC2wLJCHUfzBjHdHFOMAIs
bMeId07BVQZBdqRXa9+6KYgV0vx2UpGkYhZPVMOZge9P2F8GEkrTc4/2PorV
q1z2F6CbX5Vebf84ngS869Ch+r8PC0Adbq1uHR87tK8JyfQYqhkWU4dJZ0C1
b/6SMziUjaxZ/32K1obrQfdrP7J7DYw2hiM2/QSURtVnsd/I6z/D+9uzh+DO
xHsTs0uP0PBZHEDejzxPaNZtvsHSwLZIi2j1PqiOBY7GsuUb0blsi8J+DU7g
MYe3RPvR84x3Xl5rlro4dwlXj/1lVPWJzcQ6fyFi4aTC1kr8xwNPaz8Sy4s3
8iaFKSx7ThoDN4DYOWJ66fgQdi0dq86rRdO9vZ6hnYPTFBoF+3HD9e5iAqIS
g60IZcUa7k6wxByT0AkujE6PdXkwajtPKwVVzGkLtzH8d+O5H++s+h/Dgo4/
qwH9zyGt3I//a3AQduiIq/7HsUG73uUVc7JANHjefxI28yPus7LhejzOPex4
c+vl/YgT/J45p0BQIoqqr/u2JBIa2VNTYLPzvQk2Zs7WRSb4NqdRJfvx9Z9Z
KYNYMbCtozPqFn7QUo3+SJA/9B4yM6l23U2uaz9qQtz9ibHJ/knmF8OGPbDj
QGAlI/mK18Hk7KFWPCBao8cGhXO4H8Frp/aV422fcCaZMSnZ4dfys23dTny/
zHFyiIuilUxMaD+u+eZt006DXCqo7l3sqYALO0aoSh3ljGDN4V7umHHLhLLa
adiPT+BJoCI7/LLmfw8KQB1/WHuNj1cTHzt+vy78e2zeGLv5Unabm4eeA8Ex
xa2T+vgdt3meN4hqDHZOL+vVRUlUnapk9ddDPDV7jrHuH5oOxOpmvjejXjC4
7QLACbSdTq1FGdn0Y8sILs8ZjHRKGDH1aVpZtlLAN02N0vnYHeTzMUisnJ13
uAAPpDVi3jq+cPgFnYKu5CyASGliO/ud4u/mOaSFfr1m2kBnJgKy43ZZc7Df
ZIdlJoXiaGbNEN2GyJN1QWT+ew8FmuQKrfoDJRi+AmLt7qqvhXcyg4tLgdVO
imnWkrwOKHPwFoYF6PzCf33z4HMh1h9a9a6qvx8adLy+FvQP/T9Lq/6LT4zZ
bNYX9x/7ByFZH/+34UH7hyph84DajS/jucf9F0G9M3goy1JWgKaZwCXGrkxy
lmu+ASmEz/k3QczmOBt/hFMGBDdN739mmWoVfUjwVHn3gcSLhJHT1HuGZCe9
WPY/0WdLPmjRsSpNiVLN6fmy1RBkcwLXUFRnx+1BW/qf73R1d6AsyTv3z95H
k7j6nkfUh42IdQgH50enOVL6uKwVjXptznXJoLL0NwVJZ9HXf6Z37gwiJOLI
y47lwyd1W2wYxjhVIZnbOgbxPdqRPvOqlv8Vsw04JYMI71W/+z5PtxV+QFY/
kQObcmvfvBHUaUopY2u39KoIov88JuhwU83/GRCAOn2rrgW8Dnn4L8XRf9mM
z1nXOPunxtnmKMom//4XreFxp2/Uh/8wALq4wy9qYOve8mwFCLdk1ypVGkMN
suJ1+69Ask4Vh7p0YrhSbmmGc8VXQjbgiQ1icP9HxoOOvOL5c2sK6l1XD99A
kTKKC3RdSc3mnyS6ePMNUH2O6sCgdJoQ8iF8nmoSYeDjdDAGkWMkd9+nyG5b
GKWZ6fJZnrp1qKcjOSCqwX3dHEmGfUkYgzA3cEAzupX2baKJb+PY7bB280+D
mFL3xs9dIwgHTN0piWsBjx1e7bsVDumTiVeDF+GhtPKrIMaxV/x1yNaLEcwF
LJt9X1VSuefM/ifg6FjL4yCDlxjWT4Embv9gJTyUjj+oBf1jvys1cet5bHT9
J30pKiCcz7f+qjqQFR23G3Du/MJ/5R0KduJ8DB9Z5rlGTjfDqyMjQggueLrm
G5RbYRqc+fTUTqw7d5tyxWwmDF9hQRC/+AYzktiAjEm8dbMq2enzJm6M4rZs
gBU+/3qeauyxLsmswNwxnGLkuO3BZ+C3ZLp7c7agd/C4FKmYxAKVYnM2Gl/E
9x36d7jBnSFwI9wQZARV4NwuHspqBYRHZScxVqJzMptHxOGtVI/AmbC0GvDe
zi9jGbSDibDBAmGhjGaiiKmjG6MJWFOH+LHEWGvHWbH4YIKtJfCk6Xnaun0b
NavICb7c7FN/2ezfzX/f4uevuOqfyhPxvymKeE4TFOq/0m/f/o3//WKy+td9
8ukqxS990vy85E+/+Mmnca7N/33dJ5dnTaQ/57//XPf6UrOnv67JO342YrqZ
1dzCJ2SXtQJf39rP/XnLd7yCG19o8a2+2KrnbXnuyhf+n3qTpv9uiTOfb+n3
n7pba9+Hz9nynILr/knf4LPvy+tl/cHv9Ps/+f+llbvibn8cSUr1wpc++bR+
aFmrpJ9KtUZLWqXpv9M/fa8rdVrQ5v8HCb71dA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181803728]
}, Open  ]],

Cell["Or for large sparse matrices: ", "ExampleText",
 CellID->271774514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExampleData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Matrix\>\"", ",", "\"\<WEST2021\>\""}], "}"}], ",", 
   "\"\<Matrix\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->248888787],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "7310", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 7310, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"2021", ",", "2021"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->998892080]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2048813144],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->363369811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1871207140],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ReliefPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReliefPlot"]], "InlineFormula"],
 " for medical and geographic data: "
}], "ExampleText",
 CellID->2031439707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReliefPlot", "[", 
  RowBox[{
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/hailey.dem.gz\>\"", ",", "\"\<Data\>\""}], "]"}],
    ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<GreenBrownTerrain\>\""}], ",", 
   " ", 
   RowBox[{"MaxPlotPoints", " ", "\[Rule]", " ", "200"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1493140122],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108689758]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1246016405],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " for structured or unstructured data sampled from continuous densities:"
}], "ExampleText",
 CellID->941736265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"3", "x"}], "+", 
        RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SunsetColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170331606],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324270584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163923673],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " for visualizing adjacency matrices: "
}], "ExampleText",
 CellID->18007595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.99"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243750562],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxFU3k01Akcn5HbDjMMY4xjxk1lS+gQ820d06mMlauLRoc2ap6stRq1TcVa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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 44}, {3, 81}, {4, 14}, {4, 19}, {4, 83}, {4, 90}, {5, 
       50}, {9, 91}, {10, 9}, {13, 16}, {13, 49}, {13, 55}, {13, 80}, {14, 
       17}, {16, 28}, {16, 51}, {17, 99}, {18, 58}, {19, 93}, {20, 14}, {20, 
       69}, {20, 86}, {24, 4}, {25, 70}, {25, 81}, {26, 28}, {26, 59}, {27, 
       40}, {27, 96}, {28, 9}, {28, 79}, {29, 61}, {29, 93}, {30, 41}, {31, 
       2}, {31, 81}, {32, 87}, {34, 80}, {36, 5}, {36, 23}, {36, 29}, {36, 
       71}, {36, 79}, {36, 95}, {37, 49}, {37, 54}, {38, 28}, {39, 16}, {40, 
       71}, {40, 94}, {41, 26}, {41, 89}, {43, 19}, {43, 27}, {43, 44}, {44, 
       52}, {47, 73}, {47, 74}, {48, 74}, {49, 89}, {50, 40}, {51, 3}, {53, 
       32}, {53, 81}, {55, 42}, {56, 54}, {58, 47}, {59, 20}, {59, 35}, {59, 
       84}, {60, 78}, {61, 16}, {61, 62}, {62, 43}, {62, 50}, {63, 20}, {64, 
       37}, {68, 4}, {69, 66}, {70, 17}, {71, 45}, {71, 78}, {72, 82}, {73, 
       32}, {74, 12}, {74, 93}, {75, 47}, {76, 4}, {76, 90}, {76, 93}, {77, 
       24}, {77, 41}, {77, 44}, {79, 76}, {79, 84}, {79, 92}, {80, 65}, {80, 
       68}, {81, 48}, {81, 84}, {86, 36}, {88, 14}, {88, 76}, {89, 1}, {91, 
       85}, {91, 94}, {91, 99}, {95, 1}, {95, 28}, {97, 28}, {98, 78}, {99, 
       14}, {100, 54}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxFU3k01Akcn5HbDjMMY4xjxk1lS+gQ820d06mMlauLRoc2ap6stRq1TcVa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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->319249633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14437],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " may not be able to distinguish between large numbers of different values: \
"
}], "ExampleText",
 CellID->673875203],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"HankelMatrix", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", "i"}], "/", "i"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "25"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77828817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->264752064],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGCQhOIdcq2vA3e8s2cAgw9Dll69CgTe2Q91/7zyza+6PPvd
kPdPj96uF4u63w15/8x7XglE74a8f9LA4N2Q9w/vU9Mp1wPeDXn/9D22AKJ3
Q94/cmDwbpj4592Q98+9uyDwdsj7J+/2ttzb294Oef/Mu9E590bn2yHvn1Aw
eDvk/SMeW3LRVfztkPfP2TMg8GbI+0fmeCEQvRkm/nkz5P0Ddlbu6yHvH4j+
V0PeP7NmgsDLYeKfF0PePxB3PB0m/nkwTPwDA0PXPwDTtrDl
   "], {{0, 0}, {25, 25}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->422922620]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " instead (or provide a custom ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 "):"
}], "ExampleText",
 CellID->287802431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->290350689],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjFLQlEUfg85QVNLQzQJ0dTUVEOTRLU4RC1OJVZoEIpZDVEQUSAYQUVQ
Qy1NLi0tDi01BIVYGVIQhqJUv6LekSOY6FGflT7fefDkcu8534fnfvfjHnh2
Z8A9u+AMeFxO66jf6XN7XIvWEa9fm7KoiqIc4tulaOMvbZR7cUp7LDjOPcqe
9qPWNdt2fJcKNetK8vkUV7eNtLp/k8QI0CI2mjviLXGEUUD/Z7UVo0JXrxgJ
VA2MXDJLZOrpAKOBKpVXg6+1orcuXzADqC6FmpiXjJ8Z6fguZgFVuFhHM5JV
OWs9ksBMoOqXUuqUZOrLzDwEMRtoZ8qp2yHZhdnLF3FEAKo7p+kJQfhbhGxs
E1GAdpQ7B4hiF5T/R/Ge3yMS0G5zJy/vV2OCVA/Se3QN0YD2jztjhX5nE7Tm
RZsLRxERSCXcuSz2ziFBNBbi5+0KogIpiHOFUre9AUE1Pur0WRSRgdTFOUm5
+2u/IDcS+ePajehA+uA8grv59gm6edAdJzFkAFIl5yuVbuO9wmBuhmxkElmA
FMu5XDW9hlVYjMQyfviITEA64zyr2s6kW5iEqRqmdHgQ2YCUzvlcLd1Sp7AJ
m1624WACGYFOAefAtXZwHcIojL/JmNxRkRXohHCuradfbRdWM7HaejLIDKRj
znP1drMWYRbmBjBX+vKSvuBUvwH0Ew/g\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->257045118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->549550512],

Cell["\<\
Entries of very small relative absolute values may not be differentiable from \
zero:\
\>", "ExampleText",
 CellID->1219481138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"10000", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1395404006],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFiYwkGIPs/kAXG
ICEgYAaxwYBhA5BgJF2UBS4KBNpATsuo3KjcqNyo3OCVo7jUg5aejACQqGn+
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->517648775]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " scales entries so that entries with small relative absolute values can \
still be seen:"
}], "ExampleText",
 CellID->2042672109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"10000", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1703333677],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFiHwkGIPs/kAXG
W/7/B9LIpCyQZAZKKQNpFigN4quBZEGM/2DAIAdWLYcmqozEZ8CiS5koU1TQ
+KpofEWo2+Sx6kZXrQQkmIBcZFNBblMgSje6i5WhpmHXDbKLgQXBxwwBJRT9
slCeKpIbcYc2ZmwhkxxAcgkDhIaSSCaIEAhjQnx0/WxYbbEmYAq6PJIpiFAD
AvX/eQzqTy52qdftvKY1qmdUz6geKuthYIFQEMBC2AQUWZBxTGADmNBMZybJ
Lei6GXGaCeKCGUDTgAhYYiJM1YDKsxBtGi1cOBjNhBgCAayEzUORZYJrH8zp
eFTPqB6660ESXUCUKvq0vmhnC6Jdib8NOtp7wO/iwdV7YGAEAM0R4nY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->891923632]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3179],

Cell[TextData[{
 "Plot the ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " function at integer points:"
}], "ExampleText",
 CellID->19654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "40"}], ",", "40"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "40"}], ",", "40"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24652],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->204426200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28350],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"GCD", ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "50"}], "}"}]}], "]"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"#", "+", "a"}], ",", "1"}], "]"}], "]"}], "&"}], ")"}]}], 
     ",", 
     RowBox[{"ColorFunctionScaling", "->", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30132]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12460],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReliefPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReliefPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListDensityPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListDensityPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DensityPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DensityPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Raster",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Raster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellularAutomaton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellularAutomaton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24105]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ArrayPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ArrayPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->327404093],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->343244644],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->780267871],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->815604283],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->288679700],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->75550249],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->48028635]
}, Open  ]],

Cell["New in 5.1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArrayPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 47.2217188}", "context" -> "System`", 
    "keywords" -> {
     "matrix structure plot", "cellular automaton", "discrete data plot", 
      "ragged array plot", "image plot", "colormap plot", "elements plot"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ArrayPlot[array] generates a plot in which the values in an array are \
shown in a discrete array of squares. ", "synonyms" -> {"array plot"}, 
    "title" -> "ArrayPlot", "type" -> "Symbol", "uri" -> "ref/ArrayPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[37219, 1206, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->649688704]},
 "ArrayPlot"->{
  Cell[199176, 5831, 352, 11, 70, "Input",
   CellTags->"ArrayPlot",
   CellID->30265],
  Cell[199553, 5846, 213, 7, 70, "Input",
   CellTags->"ArrayPlot",
   CellID->20840],
  Cell[199769, 5855, 2616, 48, 70, "Output",
   Evaluatable->False,
   CellTags->"ArrayPlot",
   CellID->824443893]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 444361, 10649},
 {"ArrayPlot", 444499, 10653}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3385, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4008, 95, 4193, 83, 70, "ObjectNameGrid"],
Cell[8204, 180, 541, 16, 70, "Usage",
 CellID->16344]
}, Open  ]],
Cell[CellGroupData[{
Cell[8782, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9260, 218, 538, 17, 70, "Notes",
 CellID->11830],
Cell[9801, 237, 204, 7, 70, "Notes",
 CellID->6382],
Cell[10008, 246, 414, 12, 70, "Notes",
 CellID->27261],
Cell[10425, 260, 525, 16, 70, "Notes",
 CellID->26395],
Cell[10953, 278, 327, 10, 70, "Notes",
 CellID->27151],
Cell[11283, 290, 861, 20, 70, "2ColumnTableMod",
 CellID->20666],
Cell[12147, 312, 394, 13, 70, "Notes",
 CellID->83],
Cell[12544, 327, 362, 12, 70, "Notes",
 CellID->28710],
Cell[12909, 341, 6137, 171, 70, "3ColumnTableMod",
 CellID->26758],
Cell[19049, 514, 637, 21, 70, "Notes",
 CellID->7372],
Cell[19689, 537, 381, 13, 70, "Notes",
 CellID->2295],
Cell[20073, 552, 667, 24, 70, "Notes",
 CellID->17906],
Cell[20743, 578, 772, 27, 70, "Notes",
 CellID->30014],
Cell[21518, 607, 458, 16, 70, "Notes",
 CellID->13452],
Cell[21979, 625, 390, 11, 70, "Notes",
 CellID->20284],
Cell[22372, 638, 271, 7, 70, "Notes",
 CellID->29905],
Cell[22646, 647, 520, 16, 70, "Notes",
 CellID->25812],
Cell[23169, 665, 482, 16, 70, "Notes",
 CellID->28021],
Cell[23654, 683, 595, 22, 70, "Notes",
 CellID->6341],
Cell[24252, 707, 526, 17, 70, "Notes",
 CellID->564445753],
Cell[24781, 726, 460, 15, 70, "Notes",
 CellID->6575],
Cell[25244, 743, 802, 29, 70, "Notes",
 CellID->22290],
Cell[26049, 774, 789, 32, 70, "Notes",
 CellID->17525],
Cell[26841, 808, 1667, 58, 70, "Notes",
 CellID->6611],
Cell[28511, 868, 639, 23, 70, "Notes",
 CellID->22167],
Cell[29153, 893, 869, 32, 70, "Notes",
 CellID->26982],
Cell[30025, 927, 311, 11, 70, "Notes",
 CellID->5783],
Cell[30339, 940, 585, 22, 70, "Notes",
 CellID->587951441],
Cell[30927, 964, 556, 21, 70, "Notes",
 CellID->23387],
Cell[31486, 987, 613, 21, 70, "Notes",
 CellID->156382324],
Cell[32102, 1010, 1887, 71, 70, "Notes",
 CellID->402621626],
Cell[33992, 1083, 1064, 39, 70, "Notes",
 CellID->28793],
Cell[35059, 1124, 524, 20, 70, "Notes",
 CellID->28050],
Cell[35586, 1146, 1038, 34, 70, "Notes",
 CellID->19679],
Cell[36627, 1182, 555, 19, 70, "Notes",
 CellID->18268]
}, Closed]],
Cell[CellGroupData[{
Cell[37219, 1206, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->649688704],
Cell[CellGroupData[{
Cell[37604, 1220, 148, 5, 70, "ExampleSection",
 CellID->121525386],
Cell[37755, 1227, 68, 1, 70, "ExampleText",
 CellID->423618593],
Cell[CellGroupData[{
Cell[37848, 1232, 380, 12, 28, "Input",
 CellID->27550],
Cell[38231, 1246, 411, 11, 60, "Output",
 Evaluatable->False,
 CellID->8517297]
}, Open  ]],
Cell[38657, 1260, 120, 3, 70, "ExampleDelimiter",
 CellID->8060],
Cell[38780, 1265, 165, 4, 70, "ExampleText",
 CellID->19801],
Cell[CellGroupData[{
Cell[38970, 1273, 382, 12, 28, "Input",
 CellID->30759],
Cell[39355, 1287, 412, 11, 60, "Output",
 Evaluatable->False,
 CellID->10338215]
}, Open  ]],
Cell[39782, 1301, 120, 3, 70, "ExampleDelimiter",
 CellID->2923],
Cell[39905, 1306, 64, 1, 70, "ExampleText",
 CellID->67],
Cell[CellGroupData[{
Cell[39994, 1311, 566, 17, 47, "Input",
 CellID->7300],
Cell[40563, 1330, 417, 11, 60, "Output",
 Evaluatable->False,
 CellID->279756211]
}, Open  ]],
Cell[40995, 1344, 120, 3, 70, "ExampleDelimiter",
 CellID->8256],
Cell[41118, 1349, 54, 1, 70, "ExampleText",
 CellID->19140],
Cell[CellGroupData[{
Cell[41197, 1354, 444, 13, 28, "Input",
 CellID->10048],
Cell[41644, 1369, 462, 12, 60, "Output",
 Evaluatable->False,
 CellID->658582804]
}, Open  ]],
Cell[42121, 1384, 120, 3, 70, "ExampleDelimiter",
 CellID->1807],
Cell[42244, 1389, 60, 1, 70, "ExampleText",
 CellID->14449],
Cell[CellGroupData[{
Cell[42329, 1394, 214, 7, 28, "Input",
 CellID->8491],
Cell[42546, 1403, 1357, 26, 80, "Output",
 Evaluatable->False,
 CellID->355634617]
}, Open  ]],
Cell[43918, 1432, 125, 3, 70, "ExampleDelimiter",
 CellID->825369802],
Cell[44046, 1437, 83, 1, 70, "ExampleText",
 CellID->21049225],
Cell[CellGroupData[{
Cell[44154, 1442, 303, 10, 28, "Input",
 CellID->55105224],
Cell[44460, 1454, 1431, 28, 82, "Output",
 Evaluatable->False,
 CellID->84210091]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45940, 1488, 215, 7, 70, "ExampleSection",
 CellID->4836],
Cell[46158, 1497, 139, 2, 70, "ExampleText",
 CellID->30219],
Cell[CellGroupData[{
Cell[46322, 1503, 292, 10, 70, "Input",
 CellID->30270],
Cell[46617, 1515, 421, 11, 70, "Output",
 Evaluatable->False,
 CellID->360441916]
}, Open  ]],
Cell[47053, 1529, 120, 3, 70, "ExampleDelimiter",
 CellID->6631],
Cell[47176, 1534, 84, 1, 70, "ExampleText",
 CellID->8324],
Cell[CellGroupData[{
Cell[47285, 1539, 292, 10, 70, "Input",
 CellID->25807],
Cell[47580, 1551, 422, 11, 70, "Output",
 Evaluatable->False,
 CellID->468147397]
}, Open  ]],
Cell[48017, 1565, 121, 3, 70, "ExampleDelimiter",
 CellID->22301],
Cell[48141, 1570, 77, 1, 70, "ExampleText",
 CellID->30283],
Cell[CellGroupData[{
Cell[48243, 1575, 285, 9, 70, "Input",
 CellID->3969],
Cell[48531, 1586, 476, 12, 70, "Output",
 Evaluatable->False,
 CellID->252572751]
}, Open  ]],
Cell[49022, 1601, 121, 3, 70, "ExampleDelimiter",
 CellID->24955],
Cell[49146, 1606, 129, 2, 70, "ExampleText",
 CellID->16028],
Cell[CellGroupData[{
Cell[49300, 1612, 449, 14, 70, "Input",
 CellID->1661],
Cell[49752, 1628, 428, 11, 70, "Output",
 Evaluatable->False,
 CellID->173169589]
}, Open  ]],
Cell[50195, 1642, 121, 3, 70, "ExampleDelimiter",
 CellID->21164],
Cell[50319, 1647, 221, 8, 70, "ExampleText",
 CellID->13963],
Cell[CellGroupData[{
Cell[50565, 1659, 594, 19, 70, "Input",
 CellID->24124],
Cell[51162, 1680, 479, 12, 70, "Output",
 Evaluatable->False,
 CellID->180834107]
}, Open  ]],
Cell[51656, 1695, 121, 3, 70, "ExampleDelimiter",
 CellID->27770],
Cell[51780, 1700, 106, 2, 70, "ExampleText",
 CellID->2851],
Cell[CellGroupData[{
Cell[51911, 1706, 694, 23, 70, "Input",
 CellID->13997],
Cell[52608, 1731, 1496, 31, 110, "Output",
 CellID->23724]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54153, 1768, 223, 7, 70, "ExampleSection",
 CellID->153527982],
Cell[CellGroupData[{
Cell[54401, 1779, 228, 7, 70, "ExampleSubsection",
 CellID->16139],
Cell[54632, 1788, 61, 1, 70, "ExampleText",
 CellID->32666],
Cell[CellGroupData[{
Cell[54718, 1793, 366, 12, 70, "Input",
 CellID->22237],
Cell[55087, 1807, 520, 14, 171, "Output",
 CellID->32048]
}, Open  ]],
Cell[55622, 1824, 121, 3, 70, "ExampleDelimiter",
 CellID->24848],
Cell[55746, 1829, 73, 1, 70, "ExampleText",
 CellID->2061226372],
Cell[CellGroupData[{
Cell[55844, 1834, 383, 13, 70, "Input",
 CellID->24404],
Cell[56230, 1849, 523, 14, 97, "Output",
 CellID->7048]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56802, 1869, 227, 7, 70, "ExampleSubsection",
 CellID->22133],
Cell[57032, 1878, 220, 7, 70, "ExampleText",
 CellID->13175],
Cell[CellGroupData[{
Cell[57277, 1889, 444, 13, 70, "Input",
 CellID->6241],
Cell[57724, 1904, 405, 13, 135, "Output",
 CellID->32514]
}, Open  ]],
Cell[58144, 1920, 121, 3, 70, "ExampleDelimiter",
 CellID->12147],
Cell[58268, 1925, 234, 8, 70, "ExampleText",
 CellID->17362],
Cell[CellGroupData[{
Cell[58527, 1937, 450, 13, 70, "Input",
 CellID->23954],
Cell[58980, 1952, 435, 11, 70, "Output",
 Evaluatable->False,
 CellID->406335879]
}, Open  ]],
Cell[59430, 1966, 120, 3, 70, "ExampleDelimiter",
 CellID->3454],
Cell[59553, 1971, 242, 7, 70, "ExampleText",
 CellID->21658],
Cell[CellGroupData[{
Cell[59820, 1982, 540, 16, 70, "Input",
 CellID->1721],
Cell[60363, 2000, 439, 11, 70, "Output",
 Evaluatable->False,
 CellID->291746426]
}, Open  ]],
Cell[60817, 2014, 121, 3, 70, "ExampleDelimiter",
 CellID->10688],
Cell[60941, 2019, 211, 7, 70, "ExampleText",
 CellID->10466],
Cell[CellGroupData[{
Cell[61177, 2030, 590, 17, 70, "Input",
 CellID->16116],
Cell[61770, 2049, 435, 11, 70, "Output",
 Evaluatable->False,
 CellID->126265801]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62254, 2066, 230, 7, 70, "ExampleSubsection",
 CellID->30180],
Cell[62487, 2075, 126, 4, 70, "ExampleText",
 CellID->26429],
Cell[CellGroupData[{
Cell[62638, 2083, 502, 17, 70, "Input",
 CellID->24537],
Cell[63143, 2102, 876, 19, 70, "Output",
 Evaluatable->False,
 CellID->479464228]
}, Open  ]],
Cell[64034, 2124, 121, 3, 70, "ExampleDelimiter",
 CellID->18389],
Cell[64158, 2129, 80, 1, 70, "ExampleText",
 CellID->9843],
Cell[CellGroupData[{
Cell[64263, 2134, 550, 18, 70, "Input",
 CellID->7004],
Cell[64816, 2154, 835, 18, 70, "Output",
 Evaluatable->False,
 CellID->742732782]
}, Open  ]],
Cell[65666, 2175, 121, 3, 70, "ExampleDelimiter",
 CellID->29384],
Cell[65790, 2180, 86, 1, 70, "ExampleText",
 CellID->12920],
Cell[CellGroupData[{
Cell[65901, 2185, 605, 20, 70, "Input",
 CellID->31987],
Cell[66509, 2207, 770, 19, 159, "Output",
 CellID->39406103]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67328, 2232, 230, 7, 70, "ExampleSubsection",
 CellID->29052],
Cell[67561, 2241, 216, 8, 70, "ExampleText",
 CellID->7582],
Cell[CellGroupData[{
Cell[67802, 2253, 280, 9, 70, "Input",
 CellID->1528],
Cell[68085, 2264, 1169, 23, 70, "Output",
 Evaluatable->False,
 CellID->24415271]
}, Open  ]],
Cell[69269, 2290, 120, 3, 70, "ExampleDelimiter",
 CellID->1472],
Cell[69392, 2295, 81, 1, 70, "ExampleText",
 CellID->29193],
Cell[CellGroupData[{
Cell[69498, 2300, 419, 15, 70, "Input",
 CellID->26958],
Cell[69920, 2317, 1057, 22, 70, "Output",
 Evaluatable->False,
 CellID->459131135]
}, Open  ]],
Cell[70992, 2342, 125, 3, 70, "ExampleDelimiter",
 CellID->376159212],
Cell[71120, 2347, 218, 8, 70, "ExampleText",
 CellID->627316388],
Cell[CellGroupData[{
Cell[71363, 2359, 301, 9, 70, "Input",
 CellID->302081367],
Cell[71667, 2370, 1324, 26, 70, "Output",
 Evaluatable->False,
 CellID->45508453]
}, Open  ]],
Cell[73006, 2399, 121, 3, 70, "ExampleDelimiter",
 CellID->28983],
Cell[73130, 2404, 107, 3, 70, "ExampleText",
 CellID->5987],
Cell[CellGroupData[{
Cell[73262, 2411, 500, 16, 70, "Input",
 CellID->10823],
Cell[73765, 2429, 692, 16, 70, "Output",
 Evaluatable->False,
 CellID->139948800]
}, Open  ]],
Cell[74472, 2448, 121, 3, 70, "ExampleDelimiter",
 CellID->14520],
Cell[74596, 2453, 411, 13, 70, "ExampleText",
 CellID->30503],
Cell[CellGroupData[{
Cell[75032, 2470, 335, 10, 70, "Input",
 CellID->13472],
Cell[75370, 2482, 895, 19, 70, "Output",
 Evaluatable->False,
 CellID->396529706]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76314, 2507, 226, 7, 70, "ExampleSubsection",
 CellID->1932],
Cell[76543, 2516, 138, 2, 70, "ExampleText",
 CellID->4953],
Cell[CellGroupData[{
Cell[76706, 2522, 469, 15, 70, "Input",
 CellID->10824],
Cell[77178, 2539, 686, 17, 171, "Output",
 CellID->5033]
}, Open  ]],
Cell[77879, 2559, 121, 3, 70, "ExampleDelimiter",
 CellID->30057],
Cell[78003, 2564, 216, 7, 70, "ExampleText",
 CellID->15665],
Cell[CellGroupData[{
Cell[78244, 2575, 326, 11, 70, "Input",
 CellID->2732],
Cell[78573, 2588, 854, 20, 171, "Output",
 CellID->12280]
}, Open  ]],
Cell[79442, 2611, 121, 3, 70, "ExampleDelimiter",
 CellID->25167],
Cell[79566, 2616, 77, 1, 70, "ExampleText",
 CellID->16966],
Cell[CellGroupData[{
Cell[79668, 2621, 495, 15, 70, "Input",
 CellID->25690],
Cell[80166, 2638, 876, 19, 99, "Output",
 CellID->868]
}, Open  ]],
Cell[81057, 2660, 121, 3, 70, "ExampleDelimiter",
 CellID->29926],
Cell[81181, 2665, 149, 5, 70, "ExampleText",
 CellID->22828],
Cell[CellGroupData[{
Cell[81355, 2674, 562, 18, 70, "Input",
 CellID->21479],
Cell[81920, 2694, 409, 11, 70, "Output",
 Evaluatable->False,
 CellID->264692365]
}, Open  ]],
Cell[82344, 2708, 121, 3, 70, "ExampleDelimiter",
 CellID->29703],
Cell[82468, 2713, 202, 8, 70, "ExampleText",
 CellID->9449],
Cell[CellGroupData[{
Cell[82695, 2725, 791, 27, 70, "Input",
 CellID->18833],
Cell[83489, 2754, 423, 11, 70, "Output",
 Evaluatable->False,
 CellID->3311126]
}, Open  ]],
Cell[83927, 2768, 121, 3, 70, "ExampleDelimiter",
 CellID->22910],
Cell[84051, 2773, 72, 1, 70, "ExampleText",
 CellID->3240],
Cell[CellGroupData[{
Cell[84148, 2778, 487, 16, 70, "Input",
 CellID->21027],
Cell[84638, 2796, 349, 10, 70, "Output",
 Evaluatable->False,
 CellID->429192562]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[85036, 2812, 229, 7, 70, "ExampleSubsection",
 CellID->19251],
Cell[85268, 2821, 65, 1, 70, "ExampleText",
 CellID->27318],
Cell[CellGroupData[{
Cell[85358, 2826, 326, 10, 70, "Input",
 CellID->12081],
Cell[85687, 2838, 544, 13, 70, "Output",
 Evaluatable->False,
 CellID->15392878]
}, Open  ]],
Cell[86246, 2854, 121, 3, 70, "ExampleDelimiter",
 CellID->28103],
Cell[86370, 2859, 84, 1, 70, "ExampleText",
 CellID->6358],
Cell[CellGroupData[{
Cell[86479, 2864, 378, 11, 70, "Input",
 CellID->15238],
Cell[86860, 2877, 1179, 23, 70, "Output",
 Evaluatable->False,
 CellID->22628163]
}, Open  ]],
Cell[88054, 2903, 125, 3, 70, "ExampleDelimiter",
 CellID->397656376],
Cell[88182, 2908, 80, 1, 70, "ExampleText",
 CellID->37924591],
Cell[CellGroupData[{
Cell[88287, 2913, 442, 13, 70, "Input",
 CellID->1256446094],
Cell[88732, 2928, 1143, 23, 70, "Output",
 Evaluatable->False,
 CellID->91976504]
}, Open  ]],
Cell[89890, 2954, 125, 3, 70, "ExampleDelimiter",
 CellID->781706421],
Cell[90018, 2959, 73, 1, 70, "ExampleText",
 CellID->1319406549],
Cell[CellGroupData[{
Cell[90116, 2964, 442, 13, 70, "Input",
 CellID->351150676],
Cell[90561, 2979, 1119, 22, 70, "Output",
 Evaluatable->False,
 CellID->425406777]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[91729, 3007, 223, 7, 70, "ExampleSubsection",
 CellID->17464],
Cell[91955, 3016, 209, 8, 70, "ExampleText",
 CellID->17457],
Cell[CellGroupData[{
Cell[92189, 3028, 494, 17, 70, "Input",
 CellID->6572],
Cell[92686, 3047, 1148, 24, 119, "Output",
 CellID->542262072]
}, Open  ]],
Cell[93849, 3074, 121, 3, 70, "ExampleDelimiter",
 CellID->16922],
Cell[93973, 3079, 71, 1, 70, "ExampleText",
 CellID->25756],
Cell[CellGroupData[{
Cell[94069, 3084, 544, 18, 70, "Input",
 CellID->10867],
Cell[94616, 3104, 1167, 25, 119, "Output",
 CellID->216761815]
}, Open  ]],
Cell[95798, 3132, 120, 3, 70, "ExampleDelimiter",
 CellID->9298],
Cell[95921, 3137, 331, 12, 70, "ExampleText",
 CellID->25343],
Cell[CellGroupData[{
Cell[96277, 3153, 500, 17, 70, "Input",
 CellID->5234],
Cell[96780, 3172, 974, 20, 70, "Output",
 Evaluatable->False,
 CellID->8041371]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[97803, 3198, 224, 7, 70, "ExampleSubsection",
 CellID->2430381],
Cell[98030, 3207, 61, 1, 70, "ExampleText",
 CellID->84973523],
Cell[CellGroupData[{
Cell[98116, 3212, 365, 12, 70, "Input",
 CellID->181395948],
Cell[98484, 3226, 572, 15, 171, "Output",
 CellID->71070408]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[99105, 3247, 227, 7, 70, "ExampleSubsection",
 CellID->24019],
Cell[99335, 3256, 120, 2, 70, "ExampleText",
 CellID->25352],
Cell[CellGroupData[{
Cell[99480, 3262, 365, 12, 70, "Input",
 CellID->14062],
Cell[99848, 3276, 773, 20, 171, "Output",
 CellID->8411]
}, Open  ]],
Cell[100636, 3299, 121, 3, 70, "ExampleDelimiter",
 CellID->16811],
Cell[100760, 3304, 122, 2, 70, "ExampleText",
 CellID->21793],
Cell[CellGroupData[{
Cell[100907, 3310, 359, 12, 70, "Input",
 CellID->17405],
Cell[101269, 3324, 878, 23, 171, "Output",
 CellID->6881]
}, Open  ]],
Cell[102162, 3350, 120, 3, 70, "ExampleDelimiter",
 CellID->3651],
Cell[102285, 3355, 70, 1, 70, "ExampleText",
 CellID->25760],
Cell[CellGroupData[{
Cell[102380, 3360, 558, 19, 70, "Input",
 CellID->17898],
Cell[102941, 3381, 819, 21, 171, "Output",
 CellID->21271]
}, Open  ]],
Cell[103775, 3405, 121, 3, 70, "ExampleDelimiter",
 CellID->16500],
Cell[103899, 3410, 75, 1, 70, "ExampleText",
 CellID->10955],
Cell[CellGroupData[{
Cell[103999, 3415, 526, 16, 70, "Input",
 CellID->31155],
Cell[104528, 3433, 1232, 24, 70, "Output",
 Evaluatable->False,
 CellID->324874581]
}, Open  ]],
Cell[105775, 3460, 119, 3, 70, "ExampleDelimiter",
 CellID->650],
Cell[105897, 3465, 337, 12, 70, "ExampleText",
 CellID->6688],
Cell[CellGroupData[{
Cell[106259, 3481, 443, 14, 70, "Input",
 CellID->5939],
Cell[106705, 3497, 1448, 28, 70, "Output",
 Evaluatable->False,
 CellID->703778151]
}, Open  ]],
Cell[108168, 3528, 121, 3, 70, "ExampleDelimiter",
 CellID->26017],
Cell[108292, 3533, 64, 1, 70, "ExampleText",
 CellID->14932],
Cell[CellGroupData[{
Cell[108381, 3538, 609, 18, 70, "Input",
 CellID->14948],
Cell[108993, 3558, 1440, 28, 70, "Output",
 Evaluatable->False,
 CellID->388735625]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110482, 3592, 229, 7, 70, "ExampleSubsection",
 CellID->3495],
Cell[110714, 3601, 262, 8, 70, "ExampleText",
 CellID->26419],
Cell[CellGroupData[{
Cell[111001, 3613, 263, 9, 70, "Input",
 CellID->14648],
Cell[111267, 3624, 1928, 36, 201, "Output",
 CellID->388670963]
}, Open  ]],
Cell[CellGroupData[{
Cell[113232, 3665, 326, 10, 70, "Input",
 CellID->10171],
Cell[113561, 3677, 1254, 25, 201, "Output",
 CellID->13302610]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[114864, 3708, 220, 7, 70, "ExampleSubsection",
 CellID->3695],
Cell[115087, 3717, 75, 1, 70, "ExampleText",
 CellID->11223],
Cell[CellGroupData[{
Cell[115187, 3722, 316, 10, 70, "Input",
 CellID->3637],
Cell[115506, 3734, 1864, 32, 119, "Output",
 CellID->16649]
}, Open  ]],
Cell[117385, 3769, 121, 3, 70, "ExampleDelimiter",
 CellID->15800],
Cell[117509, 3774, 88, 1, 70, "ExampleText",
 CellID->24407],
Cell[CellGroupData[{
Cell[117622, 3779, 367, 12, 70, "Input",
 CellID->28134],
Cell[117992, 3793, 1536, 29, 70, "Output",
 Evaluatable->False,
 CellID->80344429]
}, Open  ]],
Cell[119543, 3825, 121, 3, 70, "ExampleDelimiter",
 CellID->14812],
Cell[119667, 3830, 86, 1, 70, "ExampleText",
 CellID->20641],
Cell[CellGroupData[{
Cell[119778, 3835, 434, 14, 70, "Input",
 CellID->25304],
Cell[120215, 3851, 1021, 21, 70, "Output",
 Evaluatable->False,
 CellID->106792977]
}, Open  ]],
Cell[121251, 3875, 121, 3, 70, "ExampleDelimiter",
 CellID->23162],
Cell[121375, 3880, 83, 1, 70, "ExampleText",
 CellID->12537],
Cell[CellGroupData[{
Cell[121483, 3885, 636, 21, 70, "Input",
 CellID->18551],
Cell[122122, 3908, 1199, 24, 70, "Output",
 Evaluatable->False,
 CellID->20282337]
}, Open  ]],
Cell[123336, 3935, 125, 3, 70, "ExampleDelimiter",
 CellID->278954835],
Cell[123464, 3940, 91, 1, 70, "ExampleText",
 CellID->8658608],
Cell[CellGroupData[{
Cell[123580, 3945, 436, 15, 70, "Input",
 CellID->268138055],
Cell[124019, 3962, 593, 14, 70, "Output",
 Evaluatable->False,
 CellID->40867824]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[124661, 3982, 226, 7, 70, "ExampleSubsection",
 CellID->31565],
Cell[124890, 3991, 58, 1, 70, "ExampleText",
 CellID->18938],
Cell[CellGroupData[{
Cell[124973, 3996, 272, 9, 70, "Input",
 CellID->27445],
Cell[125248, 4007, 3303, 60, 138, "Output",
 CellID->21228]
}, Open  ]],
Cell[128566, 4070, 120, 3, 70, "ExampleDelimiter",
 CellID->8194],
Cell[128689, 4075, 58, 1, 70, "ExampleText",
 CellID->14526],
Cell[CellGroupData[{
Cell[128772, 4080, 317, 10, 70, "Input",
 CellID->2178],
Cell[129092, 4092, 1866, 35, 70, "Output",
 Evaluatable->False,
 CellID->27294806]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[131007, 4133, 232, 7, 70, "ExampleSubsection",
 CellID->6928],
Cell[131242, 4142, 346, 12, 70, "ExampleText",
 CellID->4205],
Cell[CellGroupData[{
Cell[131613, 4158, 331, 10, 70, "Input",
 CellID->15149],
Cell[131947, 4170, 3030, 56, 122, "Output",
 CellID->15257]
}, Open  ]],
Cell[134992, 4229, 123, 3, 70, "ExampleDelimiter",
 CellID->2728699],
Cell[135118, 4234, 165, 4, 70, "ExampleText",
 CellID->5312],
Cell[CellGroupData[{
Cell[135308, 4242, 262, 9, 70, "Input",
 CellID->9401],
Cell[135573, 4253, 3017, 56, 209, "Output",
 CellID->25199]
}, Open  ]],
Cell[138605, 4312, 121, 3, 70, "ExampleDelimiter",
 CellID->24727],
Cell[138729, 4317, 73, 1, 70, "ExampleText",
 CellID->32692],
Cell[CellGroupData[{
Cell[138827, 4322, 328, 10, 70, "Input",
 CellID->22353],
Cell[139158, 4334, 3010, 55, 122, "Output",
 CellID->27795]
}, Open  ]],
Cell[142183, 4392, 124, 3, 70, "ExampleDelimiter",
 CellID->94429312],
Cell[142310, 4397, 94, 3, 70, "ExampleText",
 CellID->26542],
Cell[CellGroupData[{
Cell[142429, 4404, 328, 10, 70, "Input",
 CellID->22567],
Cell[142760, 4416, 3028, 56, 223, "Output",
 CellID->104860292]
}, Open  ]],
Cell[145803, 4475, 125, 3, 70, "ExampleDelimiter",
 CellID->264472866],
Cell[145931, 4480, 94, 3, 70, "ExampleText",
 CellID->12376],
Cell[CellGroupData[{
Cell[146050, 4487, 379, 12, 70, "Input",
 CellID->14255],
Cell[146432, 4501, 3010, 55, 122, "Output",
 CellID->26742]
}, Open  ]],
Cell[149457, 4559, 121, 3, 70, "ExampleDelimiter",
 CellID->16748],
Cell[149581, 4564, 135, 4, 70, "ExampleText",
 CellID->30103],
Cell[CellGroupData[{
Cell[149741, 4572, 378, 11, 70, "Input",
 CellID->22815],
Cell[150122, 4585, 3010, 55, 223, "Output",
 CellID->14047]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153181, 4646, 226, 7, 70, "ExampleSubsection",
 CellID->11073],
Cell[153410, 4655, 57, 1, 70, "ExampleText",
 CellID->28965],
Cell[CellGroupData[{
Cell[153492, 4660, 211, 7, 70, "Input",
 CellID->4749],
Cell[153706, 4669, 622, 14, 70, "Output",
 Evaluatable->False,
 CellID->19224512]
}, Open  ]],
Cell[154343, 4686, 121, 3, 70, "ExampleDelimiter",
 CellID->32169],
Cell[154467, 4691, 158, 4, 70, "ExampleText",
 CellID->14331],
Cell[CellGroupData[{
Cell[154650, 4699, 271, 9, 70, "Input",
 CellID->7970],
Cell[154924, 4710, 579, 14, 70, "Output",
 Evaluatable->False,
 CellID->597899402]
}, Open  ]],
Cell[155518, 4727, 120, 3, 70, "ExampleDelimiter",
 CellID->8768],
Cell[155641, 4732, 303, 9, 70, "ExampleText",
 CellID->28052],
Cell[CellGroupData[{
Cell[155969, 4745, 393, 14, 70, "Input",
 CellID->13178],
Cell[156365, 4761, 502, 12, 70, "Output",
 Evaluatable->False,
 CellID->93260406]
}, Open  ]],
Cell[156882, 4776, 121, 3, 70, "ExampleDelimiter",
 CellID->24981],
Cell[157006, 4781, 489, 18, 70, "ExampleText",
 CellID->312815653],
Cell[CellGroupData[{
Cell[157520, 4803, 773, 27, 70, "Input",
 CellID->17586],
Cell[158296, 4832, 645, 18, 123, "Output",
 CellID->742576207]
}, Open  ]],
Cell[158956, 4853, 119, 3, 70, "ExampleDelimiter",
 CellID->731],
Cell[159078, 4858, 66, 1, 70, "ExampleText",
 CellID->4278],
Cell[CellGroupData[{
Cell[159169, 4863, 406, 14, 70, "Input",
 CellID->17859],
Cell[159578, 4879, 956, 20, 70, "Output",
 Evaluatable->False,
 CellID->553879007]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[160595, 4906, 223, 7, 70, "ExampleSection",
 CellID->8752],
Cell[160821, 4915, 82, 1, 70, "ExampleText",
 CellID->5089],
Cell[CellGroupData[{
Cell[160928, 4920, 262, 9, 70, "Input",
 CellID->31958],
Cell[161193, 4931, 1086, 23, 116, "Output",
 CellID->20238]
}, Open  ]],
Cell[162294, 4957, 120, 3, 70, "ExampleDelimiter",
 CellID->7054],
Cell[162417, 4962, 83, 1, 70, "ExampleText",
 CellID->27972],
Cell[CellGroupData[{
Cell[162525, 4967, 369, 13, 70, "Input",
 CellID->4208],
Cell[162897, 4982, 2716, 50, 139, "Output",
 CellID->222206474]
}, Open  ]],
Cell[165628, 5035, 79, 1, 70, "ExampleText",
 CellID->126333391],
Cell[CellGroupData[{
Cell[165732, 5040, 589, 19, 70, "Input",
 CellID->24171],
Cell[166324, 5061, 5023, 87, 70, "Output",
 Evaluatable->False,
 CellID->982759361]
}, Open  ]],
Cell[171362, 5151, 120, 3, 70, "ExampleDelimiter",
 CellID->8503],
Cell[171485, 5156, 112, 3, 70, "ExampleText",
 CellID->19511],
Cell[CellGroupData[{
Cell[171622, 5163, 450, 14, 70, "Input",
 CellID->32174],
Cell[172075, 5179, 1032, 21, 70, "Output",
 Evaluatable->False,
 CellID->81169542]
}, Open  ]],
Cell[173122, 5203, 121, 3, 70, "ExampleDelimiter",
 CellID->26107],
Cell[173246, 5208, 113, 3, 70, "ExampleText",
 CellID->12205],
Cell[CellGroupData[{
Cell[173384, 5215, 545, 18, 70, "Input",
 CellID->22599],
Cell[173932, 5235, 1607, 31, 70, "Output",
 Evaluatable->False,
 CellID->365770297]
}, Open  ]],
Cell[175554, 5269, 91, 1, 70, "ExampleText",
 CellID->13261],
Cell[CellGroupData[{
Cell[175670, 5274, 780, 26, 70, "Input",
 CellID->29045],
Cell[176453, 5302, 683, 15, 70, "Output",
 Evaluatable->False,
 CellID->541496659]
}, Open  ]],
Cell[177151, 5320, 120, 3, 70, "ExampleDelimiter",
 CellID->7492],
Cell[177274, 5325, 67, 1, 70, "ExampleText",
 CellID->5732],
Cell[CellGroupData[{
Cell[177366, 5330, 531, 17, 70, "Input",
 CellID->30076],
Cell[177900, 5349, 2830, 51, 70, "Output",
 Evaluatable->False,
 CellID->68120586]
}, Open  ]],
Cell[180745, 5403, 124, 3, 70, "ExampleDelimiter",
 CellID->55685281],
Cell[180872, 5408, 113, 3, 70, "ExampleText",
 CellID->29355813],
Cell[CellGroupData[{
Cell[181010, 5415, 644, 20, 70, "Input",
 CellID->651630216],
Cell[181657, 5437, 7999, 135, 70, "Output",
 Evaluatable->False,
 CellID->43157878]
}, Open  ]],
Cell[189671, 5575, 121, 3, 70, "ExampleDelimiter",
 CellID->21054],
Cell[189795, 5580, 65, 1, 70, "ExampleText",
 CellID->10167],
Cell[CellGroupData[{
Cell[189885, 5585, 592, 19, 70, "Input",
 CellID->19212],
Cell[190480, 5606, 2817, 50, 70, "Output",
 Evaluatable->False,
 CellID->58288310]
}, Open  ]],
Cell[193312, 5659, 121, 3, 70, "ExampleDelimiter",
 CellID->30129],
Cell[193436, 5664, 55, 1, 70, "ExampleText",
 CellID->5793],
Cell[CellGroupData[{
Cell[193516, 5669, 329, 10, 70, "Input",
 CellID->11977],
Cell[193848, 5681, 932, 19, 70, "Output",
 Evaluatable->False,
 CellID->828279726]
}, Open  ]],
Cell[194795, 5703, 121, 3, 70, "ExampleDelimiter",
 CellID->15012],
Cell[194919, 5708, 79, 1, 70, "ExampleText",
 CellID->6831],
Cell[CellGroupData[{
Cell[195023, 5713, 605, 20, 70, "Input",
 CellID->14889],
Cell[195631, 5735, 367, 7, 70, "Message",
 CellID->323284975],
Cell[196001, 5744, 700, 16, 70, "Output",
 Evaluatable->False,
 CellID->144865440]
}, Open  ]],
Cell[196716, 5763, 121, 3, 70, "ExampleDelimiter",
 CellID->11299],
Cell[196840, 5768, 70, 1, 70, "ExampleText",
 CellID->2489],
Cell[CellGroupData[{
Cell[196935, 5773, 345, 11, 70, "Input",
 CellID->29674],
Cell[197283, 5786, 1668, 34, 166, "Output",
 CellID->25836]
}, Open  ]],
Cell[198966, 5823, 124, 3, 70, "ExampleDelimiter",
 CellID->24207492],
Cell[199093, 5828, 80, 1, 70, "ExampleText",
 CellID->20067],
Cell[199176, 5831, 352, 11, 70, "Input",
 CellTags->"ArrayPlot",
 CellID->30265],
Cell[CellGroupData[{
Cell[199553, 5846, 213, 7, 70, "Input",
 CellTags->"ArrayPlot",
 CellID->20840],
Cell[199769, 5855, 2616, 48, 70, "Output",
 Evaluatable->False,
 CellTags->"ArrayPlot",
 CellID->824443893]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[202434, 5909, 232, 7, 70, "ExampleSection",
 CellID->6612],
Cell[202669, 5918, 77, 1, 70, "ExampleText",
 CellID->15369],
Cell[CellGroupData[{
Cell[202771, 5923, 142, 5, 70, "Input",
 CellID->3282],
Cell[202916, 5930, 224, 7, 109, "Output",
 CellID->287756919]
}, Open  ]],
Cell[203155, 5940, 126, 3, 70, "ExampleDelimiter",
 CellID->2091170219],
Cell[203284, 5945, 375, 13, 70, "ExampleText",
 CellID->24387],
Cell[CellGroupData[{
Cell[203684, 5962, 378, 12, 70, "Input",
 CellID->11957],
Cell[204065, 5976, 375, 12, 135, "Output",
 CellID->15503]
}, Open  ]],
Cell[CellGroupData[{
Cell[204477, 5993, 373, 12, 70, "Input",
 CellID->19491],
Cell[204853, 6007, 269, 11, 64, "Output",
 CellID->10482]
}, Open  ]],
Cell[205137, 6021, 120, 3, 70, "ExampleDelimiter",
 CellID->2829],
Cell[205260, 6026, 364, 12, 70, "ExampleText",
 CellID->27027],
Cell[CellGroupData[{
Cell[205649, 6042, 582, 21, 70, "Input",
 CellID->13361],
Cell[206234, 6065, 597, 18, 123, "Output",
 CellID->5818117]
}, Open  ]],
Cell[206846, 6086, 224, 8, 70, "ExampleText",
 CellID->15183],
Cell[CellGroupData[{
Cell[207095, 6098, 395, 14, 70, "Input",
 CellID->15597],
Cell[207493, 6114, 349, 10, 121, "Output",
 CellID->31651424]
}, Open  ]],
Cell[207857, 6127, 125, 3, 70, "ExampleDelimiter",
 CellID->293421914],
Cell[207985, 6132, 247, 8, 70, "ExampleText",
 CellID->11066808],
Cell[CellGroupData[{
Cell[208257, 6144, 604, 20, 70, "Input",
 CellID->51760159],
Cell[208864, 6166, 33681, 556, 70, "Output",
 Evaluatable->False,
 CellID->181803728]
}, Open  ]],
Cell[242560, 6725, 73, 1, 70, "ExampleText",
 CellID->271774514],
Cell[CellGroupData[{
Cell[242658, 6730, 224, 7, 70, "Input",
 CellID->248888787],
Cell[242885, 6739, 491, 17, 36, "Output",
 CellID->998892080]
}, Open  ]],
Cell[CellGroupData[{
Cell[243413, 6761, 107, 3, 70, "Input",
 CellID->2048813144],
Cell[243523, 6766, 3881, 68, 70, "Output",
 Evaluatable->False,
 CellID->363369811]
}, Open  ]],
Cell[247419, 6837, 126, 3, 70, "ExampleDelimiter",
 CellID->1871207140],
Cell[247548, 6842, 225, 8, 70, "ExampleText",
 CellID->2031439707],
Cell[CellGroupData[{
Cell[247798, 6854, 375, 10, 70, "Input",
 CellID->1493140122],
Cell[248176, 6866, 96410, 1585, 70, "Output",
 Evaluatable->False,
 CellID->108689758]
}, Open  ]],
Cell[344601, 8454, 126, 3, 70, "ExampleDelimiter",
 CellID->1246016405],
Cell[344730, 8459, 271, 8, 70, "ExampleText",
 CellID->941736265],
Cell[CellGroupData[{
Cell[345026, 8471, 603, 19, 70, "Input",
 CellID->170331606],
Cell[345632, 8492, 54645, 900, 70, "Output",
 Evaluatable->False,
 CellID->324270584]
}, Open  ]],
Cell[400292, 9395, 125, 3, 70, "ExampleDelimiter",
 CellID->163923673],
Cell[400420, 9400, 224, 8, 70, "ExampleText",
 CellID->18007595],
Cell[CellGroupData[{
Cell[400669, 9412, 366, 12, 70, "Input",
 CellID->243750562],
Cell[401038, 9426, 16161, 504, 70, "Output",
 CellID->319249633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[417248, 9936, 226, 7, 70, "ExampleSection",
 CellID->14437],
Cell[417477, 9945, 256, 8, 70, "ExampleText",
 CellID->673875203],
Cell[417736, 9955, 377, 13, 70, "Input",
 CellID->77828817],
Cell[CellGroupData[{
Cell[418138, 9972, 108, 3, 70, "Input",
 CellID->264752064],
Cell[418249, 9977, 699, 17, 171, "Output",
 CellID->422922620]
}, Open  ]],
Cell[418963, 9997, 356, 13, 70, "ExampleText",
 CellID->287802431],
Cell[CellGroupData[{
Cell[419344, 10014, 174, 5, 70, "Input",
 CellID->290350689],
Cell[419521, 10021, 968, 20, 70, "Output",
 Evaluatable->False,
 CellID->257045118]
}, Open  ]],
Cell[420504, 10044, 125, 3, 70, "ExampleDelimiter",
 CellID->549550512],
Cell[420632, 10049, 137, 4, 70, "ExampleText",
 CellID->1219481138],
Cell[CellGroupData[{
Cell[420794, 10057, 223, 7, 70, "Input",
 CellID->1395404006],
Cell[421020, 10066, 334, 10, 70, "Output",
 Evaluatable->False,
 CellID->517648775]
}, Open  ]],
Cell[421369, 10079, 270, 8, 70, "ExampleText",
 CellID->2042672109],
Cell[CellGroupData[{
Cell[421664, 10091, 224, 7, 70, "Input",
 CellID->1703333677],
Cell[421891, 10100, 634, 14, 70, "Output",
 Evaluatable->False,
 CellID->891923632]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[422574, 10120, 223, 7, 70, "ExampleSection",
 CellID->3179],
Cell[422800, 10129, 205, 8, 70, "ExampleText",
 CellID->19654],
Cell[CellGroupData[{
Cell[423030, 10141, 395, 13, 70, "Input",
 CellID->24652],
Cell[423428, 10156, 13058, 218, 70, "Output",
 Evaluatable->False,
 CellID->204426200]
}, Open  ]],
Cell[436501, 10377, 121, 3, 70, "ExampleDelimiter",
 CellID->28350],
Cell[436625, 10382, 659, 21, 70, "Input",
 CellID->30132]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[437333, 10409, 311, 9, 70, "SeeAlsoSection",
 CellID->12460],
Cell[437647, 10420, 3453, 125, 70, "SeeAlso",
 CellID->24105]
}, Open  ]],
Cell[CellGroupData[{
Cell[441137, 10550, 305, 8, 70, "RelatedLinksSection"],
Cell[441445, 10560, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[441845, 10577, 319, 9, 70, "MoreAboutSection",
 CellID->327404093],
Cell[442167, 10588, 165, 3, 70, "MoreAbout",
 CellID->343244644],
Cell[442335, 10593, 147, 3, 70, "MoreAbout",
 CellID->780267871],
Cell[442485, 10598, 155, 3, 70, "MoreAbout",
 CellID->815604283],
Cell[442643, 10603, 143, 3, 70, "MoreAbout",
 CellID->288679700],
Cell[442789, 10608, 138, 3, 70, "MoreAbout",
 CellID->75550249],
Cell[442930, 10613, 165, 3, 70, "MoreAbout",
 CellID->48028635]
}, Open  ]],
Cell[443110, 10619, 52, 0, 70, "History"],
Cell[443165, 10621, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

