(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42809,       1495]
NotebookOptionsPosition[     36471,       1279]
NotebookOutlinePosition[     37836,       1317]
CellTagsIndexPosition[     37750,       1312]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arrow" :> Documentation`HelpLookup["paclet:ref/Arrow"], 
          "Inset" :> Documentation`HelpLookup["paclet:ref/Inset"], 
          "PlotMarkers" :> Documentation`HelpLookup["paclet:ref/PlotMarkers"],
           "EdgeRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/EdgeRenderingFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Arrow\"\>", 
       2->"\<\"Inset\"\>", 3->"\<\"PlotMarkers\"\>", 
       4->"\<\"EdgeRenderingFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Arrowheads", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Arrowheads",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Arrowheads"], "[", 
       StyleBox["spec", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that arrows \
which follow should have arrowheads with sizes, positions and forms specified \
by ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27077]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"], "[", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"], "]"}]], "InlineFormula"],
 " a single arrowhead is placed at the head of each arrow. "
}], "Notes",
 CellID->13009],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " specifies that arrowheads should have a length that is a fraction ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " of the total width of the graphic. The default is 0.04. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->403],

Cell[TextData[{
 "The symbolic values ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 " can be used for ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". With these values the size of the arrowhead is independent of the total \
width of the graphic. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21576],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " specifies that arrows should include several arrowhead elements. "
}], "Notes",
 CellID->10540],

Cell["Each arrowhead element can be specified as follows: ", "Notes",
 CellID->26023],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["s", "TI"], Cell[TextData[{
     "default arrowhead with scaled size ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      StyleBox["pos", "TI"]}], "}"}], Cell[TextData[{
     "default arrowhead at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["pos", "TI"]}], "}"}], Cell[TextData[{
     "scaled default arrowhead at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["pos", "TI"], ",", 
      StyleBox["g", "TI"]}], "}"}], Cell[TextData[{
     "arrowhead drawn as graphic ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["pos", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["g", "TI"], ",", "\[Delta]"}], "}"}]}], "}"}], Cell[
    TextData[{
     "shaft foreshortened by ",
     Cell[BoxData[
      StyleBox["\[Delta]", "TR"]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 CellFrameLabels->{{None, None}, {None, None}},
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->22574],

Cell[TextData[{
 "The position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 " runs from 0 to 1 from the tail to the head of the arrow. "
}], "Notes",
 CellID->15454],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["0", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " specifies arrowheads with scaled sizes ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " at positions ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "/", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->369],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      StyleBox["s", "TI"]}], ",", 
     StyleBox["s", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " gives double\[Hyphen]headed arrows. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->11906],

Cell[TextData[{
 "The graphic ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is placed so that the origin ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], TraditionalForm]]],
 " of its coordinates lies at position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 " along each arrow. "
}], "Notes",
 CellID->32485],

Cell[TextData[{
 "The graphic ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is oriented so that its positive ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis is aligned with the direction of the shaft at position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24999],

Cell[TextData[{
 "The graphic ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is scaled so that one unit of its coordinates corresponds to a fraction ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " of the width of the whole graphic in which the arrow is being drawn. "
}], "Notes",
 CellID->28048],

Cell[TextData[{
 "The graphic ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is always assumed to have ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AspectRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AspectRatio"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23930],

Cell[TextData[{
 "With the specification ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["pos", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["\[Delta]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ", the shaft of the arrow is foreshortened by ",
 Cell[BoxData[
  StyleBox["\[Delta]", "TR"]], "InlineFormula"],
 " in the coordinate system of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". This can prevent a thick shaft from \[OpenCurlyDoubleQuote]poking through\
\[CloseCurlyDoubleQuote] arrowheads at the head or tail of the arrow. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->573]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->347240046],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->240571924],

Cell[TextData[{
 "Arrowheads with scaled sizes:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->403,
  ButtonNote->"403"]
}], "ExampleText",
 CellID->33649936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "i", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{".1", ",", ".2", ",", ".4"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->123337004],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Arrowheads[0.1], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Arrowheads[0.2], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Arrowheads[0.4], ArrowBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{341, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->208065842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39119071],

Cell[TextData[{
 "Symbolic values to specify predefined absolute sizes of arrowheads: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21576,
  ButtonNote->"21576"]
}], "ExampleText",
 CellID->435478837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "i", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->585857968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Arrowheads[Tiny], ArrowBox[{{0, 0}, {2, 1}}]},
    PlotRange->{{0, 2}, {0, 1}}], ",", 
   GraphicsBox[
    {Arrowheads[Small], ArrowBox[{{0, 0}, {2, 1}}]},
    PlotRange->{{0, 2}, {0, 1}}], ",", 
   GraphicsBox[
    {Arrowheads[Medium], ArrowBox[{{0, 0}, {2, 1}}]},
    PlotRange->{{0, 2}, {0, 1}}], ",", 
   GraphicsBox[
    {Arrowheads[Large], ArrowBox[{{0, 0}, {2, 1}}]},
    PlotRange->{{0, 2}, {0, 1}}]}], "}"}]], "Output",
 ImageSize->{452, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->677240493]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->419856425],

Cell[TextData[{
 "Double-headed arrow:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->11906,
  ButtonNote->"11906"]
}], "ExampleText",
 CellID->3028548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".1"}], ",", ".1"}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->560105963],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[{-0.1, 0.1}], ArrowBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{154, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->373727996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450417770],

Cell[TextData[{
 "Uniformly spaced arrowheads with specific sizes:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->369,
  ButtonNote->"369"]
}], "ExampleText",
 CellID->267926154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{".05", ",", ".1", ",", ".1", ",", ".05"}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4934856],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[{0.05, 0.1, 0.1, 0.05}], ArrowBox[{{0, 0}, {2, 1}}]}]], "Output",\

 ImageSize->{154, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->117822312]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20987],

Cell["Specify arrowhead size and position:", "ExampleText",
 CellID->305325938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{".1", ",", "i"}], "}"}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "0.5", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->382814481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Arrowheads[{{0.1, 0.2}}], 
     ArrowBox[NCache[{{0, 0}, {1, Rational[1, 3]}}, {{0, 0}, {
        1, 0.3333333333333333}}]]}], ",", 
   GraphicsBox[
    {Arrowheads[{{0.1, 0.5}}], 
     ArrowBox[NCache[{{0, 0}, {1, Rational[1, 3]}}, {{0, 0}, {
        1, 0.3333333333333333}}]]}], ",", 
   GraphicsBox[
    {Arrowheads[{{0.1, 1}}], 
     ArrowBox[NCache[{{0, 0}, {1, Rational[1, 3]}}, {{0, 0}, {
        1, 0.3333333333333333}}]]}]}], "}"}]], "Output",
 ImageSize->{491, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->192631964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311590829],

Cell["Multiple arrowheads with specific sizes and positions:", "ExampleText",
 CellID->127288586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{".1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".2", ",", ".5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".3", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->202572481],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[{{0.1, 0}, {0.2, 0.5}, {0.3, 1}}], 
   ArrowBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{154, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70134080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263853984],

Cell["Reversed arrowheads by assigning negative size:", "ExampleText",
 CellID->8662514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", ".4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".1"}], ",", ".6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177532160],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[{{-0.1, 0}, {0.1, 0.4}, {-0.1, 0.6}, {0.1, 1}}], 
   ArrowBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->874461518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->832046501],

Cell["Graphics can be used as an arrowhead:", "ExampleText",
 CellID->876064785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], "}"}]}], "}"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->874236904],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{{-1, Rational[1, 2]}, {0, 0}, {-1, Rational[-1, 2]}}, {{
      0, Rational[1, 2]}, {1, 0}, {0, Rational[-1, 2]}}, {{
      1, Rational[1, 2]}, {2, 0}, {1, Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 
      0}, {-1, -0.5}}, {{0, 0.5}, {1, 0}, {0, -0.5}}, {{1, 0.5}, {2, 0}, {
      1, -0.5}}}]]]], "Output",
 ImageSize->{104, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->629473707]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic", ",", "h"}], "}"}], "}"}], "]"}],
     ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3029004],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[{{Automatic, Automatic, 
      GraphicsBox[
       LineBox[
        NCache[{{{-1, 
            Rational[1, 2]}, {0, 0}, {-1, 
            Rational[-1, 2]}}, {{0, 
            Rational[1, 2]}, {1, 0}, {0, 
            Rational[-1, 2]}}, {{1, 
            Rational[1, 2]}, {2, 0}, {1, 
            Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}, {{0, 0.5}, {
           1, 0}, {0, -0.5}}, {{1, 0.5}, {2, 0}, {1, -0.5}}}]]]}}], 
   ArrowBox[{{0, 0}, {1, 1}}], ArrowBox[{{0, 0}, {0, 1}}], 
   ArrowBox[{{0, 0}, {1, 0}}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->391342303]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56130908],

Cell[TextData[{
 "Foreshorten the shaft:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->573,
  ButtonNote->"573"]
}], "ExampleText",
 CellID->290673252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125534677],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{-1, Rational[1, 2]}, {0, 
     0}, {-1, Rational[-1, 2]}, {-1, Rational[1, 2]}}, {{-1, 0.5}, {0, 
     0}, {-1, -0.5}, {-1, 0.5}}]]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->329308224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"Arrowheads", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{".5", ",", "1", ",", 
          RowBox[{"{", 
           RowBox[{"h", ",", "i"}], "}"}]}], "}"}], "}"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", ".5", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29654482],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Large], Arrowheads[{{0.5, 1, {
         GraphicsBox[
          LineBox[
           NCache[{{-1, 
              Rational[1, 2]}, {0, 0}, {-1, 
              Rational[-1, 2]}, {-1, 
              Rational[1, 2]}}, {{-1, 0.5}, {0, 0}, {-1, -0.5}, {-1, 0.5}}]]],
          0}}}], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], Arrowheads[{{0.5, 1, {
         GraphicsBox[
          LineBox[
           NCache[{{-1, 
              Rational[1, 2]}, {0, 0}, {-1, 
              Rational[-1, 2]}, {-1, 
              Rational[1, 2]}}, {{-1, 0.5}, {0, 0}, {-1, -0.5}, {-1, 0.5}}]]],
          0.5}}}], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], Arrowheads[{{0.5, 1, {
         GraphicsBox[
          LineBox[
           NCache[{{-1, 
              Rational[1, 2]}, {0, 0}, {-1, 
              Rational[-1, 2]}, {-1, 
              Rational[1, 2]}}, {{-1, 0.5}, {0, 0}, {-1, -0.5}, {-1, 0.5}}]]],
          1}}}], ArrowBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{341, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->151588526]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31657],

Cell["Moving arrowheads:", "ExampleText",
 CellID->441384296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{".1", ",", "t"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".1", ",", 
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{"t", "+", 
               RowBox[{"1", "/", "3"}]}], ",", "1"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{".1", ",", 
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{"t", "+", 
               RowBox[{"2", "/", "3"}]}], ",", "1"}], "]"}]}], "}"}]}], "}"}],
         "]"}], ",", "Thick", ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "5"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRangePadding", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15174320],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 1}}, Typeset`size$$ = {180., {50., 55.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$35329$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$35329$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Arrowheads[{{0.1, $CellContext`t$$}, {0.1, 
            Mod[$CellContext`t$$ + 1/3, 1]}, {0.1, 
            Mod[$CellContext`t$$ + 2/3, 1]}}], Thick, 
         Arrow[{{0, 0}, {10, 5}}]}, PlotRangePadding -> 1], 
      "Specifications" :> {{$CellContext`t$$, 0, 1, AnimationRunning -> False,
          AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {87., 92.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231359878]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20031],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotMarkers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotMarkers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Arrowheads",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Arrowheads"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->4942214],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->800244645]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Arrowheads - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 54.1281456}", "context" -> "System`", 
    "keywords" -> {
     "arrowhead form", "arrow head", "arrowhead size", "plot arrow shape"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Arrowheads[spec] is a graphics directive which specifies that arrows \
which follow should have arrowheads with sizes, positions and forms specified \
by spec. ", "synonyms" -> {}, "title" -> "Arrowheads", "type" -> "Symbol", 
    "uri" -> "ref/Arrowheads"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12737, 428, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->347240046]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37606, 1305}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1487, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2110, 62, 1575, 37, 70, "ObjectNameGrid"],
Cell[3688, 101, 665, 20, 70, "Usage",
 CellID->27077]
}, Open  ]],
Cell[CellGroupData[{
Cell[4390, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4868, 143, 367, 12, 70, "Notes",
 CellID->13009],
Cell[5238, 157, 454, 13, 70, "Notes",
 CellID->403],
Cell[5695, 172, 774, 28, 70, "Notes",
 CellID->21576],
Cell[6472, 202, 507, 17, 70, "Notes",
 CellID->10540],
Cell[6982, 221, 85, 1, 70, "Notes",
 CellID->26023],
Cell[7070, 224, 2033, 61, 70, "2ColumnTableMod",
 CellID->22574],
Cell[9106, 287, 183, 6, 70, "Notes",
 CellID->15454],
Cell[9292, 295, 829, 31, 70, "Notes",
 CellID->369],
Cell[10124, 328, 402, 14, 70, "Notes",
 CellID->11906],
Cell[10529, 344, 376, 14, 70, "Notes",
 CellID->32485],
Cell[10908, 360, 345, 12, 70, "Notes",
 CellID->24999],
Cell[11256, 374, 327, 9, 70, "Notes",
 CellID->28048],
Cell[11586, 385, 394, 15, 70, "Notes",
 CellID->23930],
Cell[11983, 402, 717, 21, 70, "Notes",
 CellID->573]
}, Closed]],
Cell[CellGroupData[{
Cell[12737, 428, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->347240046],
Cell[CellGroupData[{
Cell[13122, 442, 148, 5, 70, "ExampleSection",
 CellID->240571924],
Cell[13273, 449, 188, 7, 70, "ExampleText",
 CellID->33649936],
Cell[CellGroupData[{
Cell[13486, 460, 588, 21, 28, "Input",
 CellID->123337004],
Cell[14077, 483, 458, 14, 75, "Output",
 CellID->208065842]
}, Open  ]],
Cell[14550, 500, 124, 3, 70, "ExampleDelimiter",
 CellID->39119071],
Cell[14677, 505, 232, 7, 70, "ExampleText",
 CellID->435478837],
Cell[CellGroupData[{
Cell[14934, 516, 858, 28, 70, "Input",
 CellID->585857968],
Cell[15795, 546, 672, 20, 73, "Output",
 CellID->677240493]
}, Open  ]],
Cell[16482, 569, 125, 3, 70, "ExampleDelimiter",
 CellID->419856425],
Cell[16610, 574, 182, 7, 70, "ExampleText",
 CellID->3028548],
Cell[CellGroupData[{
Cell[16817, 585, 472, 17, 70, "Input",
 CellID->560105963],
Cell[17292, 604, 279, 8, 99, "Output",
 CellID->373727996]
}, Open  ]],
Cell[17586, 615, 125, 3, 70, "ExampleDelimiter",
 CellID->450417770],
Cell[17714, 620, 208, 7, 70, "ExampleText",
 CellID->267926154],
Cell[CellGroupData[{
Cell[17947, 631, 471, 16, 70, "Input",
 CellID->4934856],
Cell[18421, 649, 292, 9, 99, "Output",
 CellID->117822312]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18762, 664, 216, 7, 70, "ExampleSection",
 CellID->20987],
Cell[18981, 673, 79, 1, 70, "ExampleText",
 CellID->305325938],
Cell[CellGroupData[{
Cell[19085, 678, 709, 25, 70, "Input",
 CellID->382814481],
Cell[19797, 705, 696, 20, 77, "Output",
 CellID->192631964]
}, Open  ]],
Cell[20508, 728, 125, 3, 70, "ExampleDelimiter",
 CellID->311590829],
Cell[20636, 733, 97, 1, 70, "ExampleText",
 CellID->127288586],
Cell[CellGroupData[{
Cell[20758, 738, 632, 22, 70, "Input",
 CellID->202572481],
Cell[21393, 762, 303, 9, 99, "Output",
 CellID->70134080]
}, Open  ]],
Cell[21711, 774, 125, 3, 70, "ExampleDelimiter",
 CellID->263853984],
Cell[21839, 779, 88, 1, 70, "ExampleText",
 CellID->8662514],
Cell[CellGroupData[{
Cell[21952, 784, 751, 26, 70, "Input",
 CellID->177532160],
Cell[22706, 812, 266, 8, 115, "Output",
 CellID->874461518]
}, Open  ]],
Cell[22987, 823, 125, 3, 70, "ExampleDelimiter",
 CellID->832046501],
Cell[23115, 828, 80, 1, 70, "ExampleText",
 CellID->876064785],
Cell[CellGroupData[{
Cell[23220, 833, 1269, 43, 70, "Input",
 CellID->874236904],
Cell[24492, 878, 529, 12, 58, "Output",
 CellID->629473707]
}, Open  ]],
Cell[CellGroupData[{
Cell[25058, 895, 926, 32, 70, "Input",
 CellID->3029004],
Cell[25987, 929, 761, 20, 171, "Output",
 CellID->391342303]
}, Open  ]],
Cell[26763, 952, 124, 3, 70, "ExampleDelimiter",
 CellID->56130908],
Cell[26890, 957, 182, 7, 70, "ExampleText",
 CellID->290673252],
Cell[CellGroupData[{
Cell[27097, 968, 634, 22, 70, "Input",
 CellID->125534677],
Cell[27734, 992, 375, 10, 121, "Output",
 CellID->329308224]
}, Open  ]],
Cell[CellGroupData[{
Cell[28146, 1007, 758, 25, 70, "Input",
 CellID->29654482],
Cell[28907, 1034, 1267, 35, 75, "Output",
 CellID->151588526]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30223, 1075, 224, 7, 70, "ExampleSection",
 CellID->31657],
Cell[30450, 1084, 61, 1, 70, "ExampleText",
 CellID->441384296],
Cell[CellGroupData[{
Cell[30536, 1089, 1243, 37, 70, "Input",
 CellID->15174320],
Cell[31782, 1128, 2065, 45, 70, "Output",
 CellID->231359878]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33908, 1180, 311, 9, 70, "SeeAlsoSection",
 CellID->20031],
Cell[34222, 1191, 961, 35, 70, "SeeAlso",
 CellID->22604]
}, Open  ]],
Cell[CellGroupData[{
Cell[35220, 1231, 305, 8, 70, "RelatedLinksSection"],
Cell[35528, 1241, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35930, 1258, 317, 9, 70, "MoreAboutSection",
 CellID->4942214],
Cell[36250, 1269, 149, 3, 70, "MoreAbout",
 CellID->800244645]
}, Open  ]],
Cell[36414, 1275, 27, 0, 70, "History"],
Cell[36444, 1277, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

