(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    385191,       7284]
NotebookOptionsPosition[    376428,       6982]
NotebookOutlinePosition[    377863,       7022]
CellTagsIndexPosition[    377776,       7017]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Three\[Hyphen]Dimensional Surface Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalSurfacePlots"], 
          "Two\[Hyphen]Dimensional Graphics Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TwoDimensionalGraphicsElements"], 
          "Coordinate Systems for Two\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CoordinateSystemsForTwoDimensionalGraphics"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/TheStructureOfGraphics"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Three\[Hyphen]Dimensional Surface Plots\"\>", 
       3->"\<\"Two\[Hyphen]Dimensional Graphics Elements\"\>", 
       4->"\<\"Coordinate Systems for Two\[Hyphen]Dimensional Graphics\"\>", 
       5->"\<\"The Structure of Graphics\"\>", 
       6->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxRatios" :> Documentation`HelpLookup["paclet:ref/BoxRatios"],
           "PlotRegion" :> Documentation`HelpLookup["paclet:ref/PlotRegion"], 
          "Options" :> Documentation`HelpLookup["paclet:ref/Options"], 
          "AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BoxRatios\"\>", 
       2->"\<\"PlotRegion\"\>", 3->"\<\"Options\"\>", 
       4->"\<\"AbsoluteOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup[
           "paclet:guide/PlottingAndImageRegions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Options & Styling\"\>", 
       2->"\<\"Graphics Shape & Size\"\>", 
       3->"\<\"Plotting and Image Regions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AspectRatio", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AspectRatio",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " and related functions which specifies the ratio of height to width for \
a plot. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " determines the scaling for the final image shape. "
}], "Notes",
 CellID->21197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AspectRatio", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " determines the ratio of height to width from the actual coordinate values \
in the plot. "
}], "Notes",
 CellID->8595],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AspectRatio", "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " specifies that a graphic should be stretched so as to fill out its \
enclosing region in a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " or related construct. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2125]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165447204],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->72238496],

Cell["Use numerical values to specify the height-to-width ratio:", \
"ExampleText",
 CellID->480601013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"1", "/", "k"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->965244531],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    AspectRatio->1], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    AspectRatio->NCache[
      Rational[1, 2], 0.5]], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    AspectRatio->NCache[
      Rational[1, 3], 0.3333333333333333]]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->59876946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54442601],

Cell["Choose the ratio from the actual plot values:", "ExampleText",
 CellID->847152041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324302993],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWF2I1VUQP95vXcvcu+v6VakpSCRCiESkmV+lpeJ3oltdb9quYIqtL/qi
L/lSL/miIplZQdmDkSiCgiiIQiiEgmggCqIPiqD0sBBcfzNz5u/5zz3r9W5e
7t7/mfOf+c2cmTln5uyCSk/Xuo2Vnu5qZcz7Wyqbu7qrX42Zu2kLprIDnHNH
8Td9uMO4hhH/Ha3V8Kz/LeI3C4YMUTSo8cdlMDzEHCXzJks/uSe0c3nDsU+m
s/KgT0bJhjjEsIHI/P37/144f+vA93/hu7XnmMtu+vLPDMYui+k7dx4S02v9
tPAL1nDp4u3d351bufyXxYsOkQZGzwEdL+TLM3m8E6ZdX58+e+aGG9tPrZ/T
TwHrOvzb3wDEejDASgbr/PFjV7dvO/HhvAMwC/OvNKGHPFxVv8mqBMS18uyj
R72iFWsAhxudRJ8kC8Ez1PUZy/b2/gc/QBYIGLsOtgDGwiVQAuiRjNbhUViK
/Ni5+te9ey5AZBTjigH4dSMS/lBbJ8sBDjbC5+oBmoGa7q4jMLwjKrmG6SuX
71bX/g673DilYQHRw1L2CTeWBEjy0PhAL76wty2qZRXT4EPkKDEmMg184Ny8
+cCVUz4N8133gPpZkK5fuwd7kWbudaWBBL9JzCQaqUgXY7kQ0CuZRo76lb2h
FsOd5PehtdjOlEQN1DTUs0LjiXSljJjMNIK0c8dJooc0YT+RZf9sx5ME2jxN
OBnA2rzU9+yn3KmT/4gd3rstfWjXfRJDC+l2EzmbB4OYhj4kC3nVrsryv8Q0
4oqouMhZW3qKvSGf2t9u5oc1oAeqvfAS7YaC9/Jww8fZkUcWYsofsPjwapOs
1qe1zfrQ+qAcxsbvIcr00HekbYSRa1WvgJ8yWu3RvWx9YfVau0qBfpwP7JuM
S+MRO+/GVHwaIbfVxc9KFALd5OVBge66/CMknHfCOjBqQbkWt71k9AyO5Afx
65NLqyxX4pEgLmRJ+B3nFCHNMMjFqF0fqZSP2UwjVUjpsNyzDXc+qmO+kZpr
pHJRqXlG6gMjJQcjRfIHl9r50obUd0mGbmnw/v/S9uR6JvmCbGeEMNnUrc/D
rnxCC6g/Z57farNJDClPqBeboxw+foujUSbOWSbSS55w5kK7ifc9w7s0pVdq
H9jQytBwOtOo9557WdQGkfr5p0uoETR8h2mp8CS1PKVDTlOczdJ+uLeVGzqQ
nVJv63QkUr4Kv8W01BmS4m6AT4O++hGtKEWV9PqmGuSPWaaY9l6kntsIynuc
s8ClrnMK06iZfp2r+olbCrxJ+/bNmvQJq5vAyyYZK5Gnzl76GKmUVNnX9IGn
frNVUDoDeNDLT1J82En4nU/BC3FyHv8Fnpe+iuIifSI6Rn8ef5KKsNbmnEET
FHRJvk+dqLnpo/1pNLte1Dz3PfUEphFFoGAruEoqg7nHyUlPhGYTbOM0h9CD
U6VdG9UyVDMPWshDrzIOxAECKJhXTekp63t4WII/SjXLHQVQ66KapD7LHQHI
CApz0O1GLiaQp5xcn/i0r3uxjRb3W3QfAggChfCwlXQTg5PlJkbZ38XI9pSs
v89p9LkXyiNuiJPYRzHnaBbgGGl7cQdDNAC/oQn0kIPvbi1wB/DhGuABFWO5
B0vJIL9k6KJSwItvvzkLPtxSsVaEbGMTeonhZSJLMBiycrWX5b07be+cWfsz
IPi0/ePIFVrt5n6uat8zyh1Moh3ez37k2fr/lrgBjwHomJti\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8749955]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " can be given to choose the ratio from the actual plot values:"
}], "ExampleText",
 CellID->288183114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576816622],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->80829863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6456693],

Cell["\<\
Specify the height-to-width ratio of a graphic by numerical values:\
\>", "ExampleText",
 CellID->899880153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "u", "]"}], ",", 
       RowBox[{
        RowBox[{"1", "/", "10"}], 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "u", "]"}], ",", 
       RowBox[{
        RowBox[{"1", "/", "10"}], 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"1", "/", "2"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79540013],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19735278]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29343],

Cell["\<\
In 3D, the aspect ratio determines the ratio of the final displayed 2D image:\
\
\>", "ExampleText",
 CellID->197467626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"Sphere", "[", "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"1", "/", "k"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32775646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     AspectRatio->1,
     ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
    StripOnInput->False], ",", 
   FrameBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     AspectRatio->NCache[
       Rational[1, 2], 0.5],
     ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
    StripOnInput->False], ",", 
   FrameBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     AspectRatio->NCache[
       Rational[1, 3], 0.3333333333333333],
     ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->187818819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92177244],

Cell[TextData[{
 "Use the ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " setting to preserve the natural 3D projection: "
}], "ExampleText",
 CellID->6510802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "ar"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ar", ",", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120886374],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 275},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->668823612]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14568],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " determines the ratio of ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ", not ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->182942527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "2"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"200", ",", "100"}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400592340],

Cell[BoxData[
 FrameBox[
  GraphicsBox[
   {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
   AspectRatio->2,
   Frame->True,
   ImageSize->{200, 100},
   PlotRange->{{-1, 1}, {-1, 1}}],
  StripOnInput->False]], "Output",
 ImageSize->{214, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167058661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->759781],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " by default:"
}], "ExampleText",
 CellID->480680334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66853089],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Frame->True,
  PlotRange->{{-2, 2}, {-1, 1}}]], "Output",
 ImageSize->{184, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405458902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127049118],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " use the ratio ",
 Cell[BoxData[
  RowBox[{"1", "/", 
   ButtonBox["GoldenRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GoldenRatio"]}]], "InlineFormula"],
 " by default:"
}], "ExampleText",
 CellID->72621968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"1", "/", "GoldenRatio"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229282428],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->695180696]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198741895],

Cell[TextData[{
 "Some plots, such as ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ", use ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " by default:"
}], "ExampleText",
 CellID->515921717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"u", " ", 
      RowBox[{
       RowBox[{"Sin", "[", "u", "]"}], "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->717758698],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->654002882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610868956],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1lVFSwzAMRCVuwhm4CUdghm/u/0eLrd2VsWM3iUPJtImj9dNKyvvXz+fX
m5l9PP6/7Xm4Pz7PU/3+OD//vP76u1dXxMVyo1zFfSsRLBaXBYxZbnpdEI8b
49TdaKi4+vcLUjVK2WeNkjaHBVgXcTxwPQHWy+YiFYtlg7I5wwKsi1wiB1ge
YQ3wErMBTZsb+IIoVHGgCTyhkQpNAFm6voSd4gDRAE9opCInYOKLR0KQO0FD
4VnwMxU5ARNfkH4XeT5pjImNwtJWZdovJvLMHsPDisi8t8dKv6h8fCS8bJQ3
+ixH/aLykT0JHxXiodRVmfQL86XZU9vdRXakMukXXmb2JDxaZsQx9cU1X6bM
6I3I85hj6oucPDNHAbLYDjTm/ZKnFtqSbdjtjxHLqF8wPGBxJeMUnnAoy6Bf
MDyMsODwyPSKykG/eAyP+IKxiOcXNGb94t58Mczlw/4YsfR8MUkSTAq2JT9a
lo4voiylxIJb1jjyRZWl/Vhwr6n0fUnKrLD++2OVpfUlKTsrbK0/RiytLwzK
CgPfGZWOLzJNWGpl/QmNkS8yTZDFV/pjxKK+mEri9XWWQ1nUF5kmGO/nOZRF
fUHHsNMvcCiLjlyO/MC4ptHzhSO/il/kUBadJhr8OgdCuvqSg9+h8d+X6MfX
3h8LKsmX6JNr/dFRSb6A6zaOqqK+ROZu5Kgq6ks4c6tG68vZ98eCSop+P0dV
SdF3aCRfNvghKuHLJo6qgjG/79Axv1Vlox+ispmjqOzXOMXxC/ECEP0=
   "], {{0, 0}, {101, 51}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->698597316]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93197379],

Cell[TextData[{
 "Others, such as ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 ", use the ratio ",
 Cell[BoxData["1"], "InlineFormula"],
 " by default:"
}], "ExampleText",
 CellID->17312459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179478673],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1vYd7XEd2Jf7cTWr3930/rz1RpChOkgBSE3Y89ng8Ye0JHskjjag8mlGO
lEiJoijmBIAgco4EM5gpBjHnBBAEQeScc6fXsnftP0Hf7rm3wqv3ugE2x7v6
IKDRTQBVferce+6tW7cWvLVy0cKP3lq5+J23vvUvy99atmjxOyu+9djHy/GU
/y8sy6rC/9WzLDz+33jE/1d98cUXeMH4/P/hsw8v3Y+vM/B1Nj3rx4Mv+D9+
nl6fZfw7etknv/fzb/mv9HmG81Pi36nfY8X5vV+P+YnYZ+6PeYb+Kk3tL+jr
FH95Vpy/NCPub/u/9Re9c/uaZ+6z4v4dX9xX/py/93Xjt/njzuLPm1fs+6NW
wd3RTOQvqrWnfusDnt9qrjnzq/8Lc+3Frmnzs/xH/F+FeOga1Qx8KXD+Wcxr
Jo7xxuflyl1fd/2Fqf4qzS7HNcs4I/uKfqZ9JNg1GugZm+gfGx8cHxueGB2d
HJmYHA4EhkLBwUhw0A4NfB7q/9dw3/8M9/2vSK/l+3d88v9HpOc/bPqwfPQp
+T8ivXger//PSN+/hfv+NdwfDQ1EQgP4HcHA0GRgeGxyZGRidGh8bGB8vHd0
omtksmM40DoYbB4I3ekP3+6L1PXYtd3R613Rq23Ry03RC7ej5+qiZ25ET12L
nrwc/exC9Ni56NEz0SOno0dORj89GZ3x6YmolYTHR07R83gV/+bEpeipq/RT
+Fn8hkuN0ast0ettdm2HXdcVud0TvtMbau4P4e/ir3eNTvZi3uPjGBXGhhFO
BNS8QwMY/+fh/n9T88bsMEdrBs12Dmb/73rCNNu+z8WEgzRh/Aq8gWLCeEvx
xuLtxR/DW906HGoaCt8ZjNQP2HV90Zqe6PXO6JWWKK9wE++/+M8iF3aQ6zeR
+65Gjj7wOGHg+jVwQwZwvQq4zhjgrkZPxAA3k1BLvitqVxi1GkatvptQa/pP
oIZp+uPh9m8OboNT4xaIj1vHdLgZlmPmFKj1GaiNx0Pt39yo9U6Dmnf1BYxZ
KNTaGTW8jXf6wvWMWk0Xo9YavSRQu6lQu2Sgdoq45mPUDp+Ifio+NHxn3fDd
jF6oZ/iao9db48DXzvDpJXtX+HjuMz0rVrwjs0zq2TEQDmsIRyc7p4DwGkMY
H0H2aF83UcNvwe+Kh9qQQC2qUAMmeun5MGDff8iZPDzlsgu4lx0AG2bABhRg
PZG6bgYMY26ltzgOYGcdwACS7/BnAreHJFynCdLjAq4rEq7z9dGLdwiua4Cr
3b7ZSXA19IYNuAJeuBzfIOHy+IYZgnECLHrGRy/dL4wLlrYCa8gDVp8BVguD
1cBg3QRY3RKsKfjGaH01HloTEq0JQgvWLBiLlrPS/IJW/65mkmSYxZhlFvAs
MwlZC0OGtxCQ3WTIxMgJsvro2ZvR0x7IThM4RxgyS2P2HcLspMtCnrwSPX09
erZWYdYUB7MWxsxcqTGYueyLz5y5MI5i5rPdDoFmjrcNb96kF7MJwmwkBrNe
nnkbLa3pMHPsYhswGwl0M2aQCEMTY6MTo+OTIxozYR00ZhaN/T4vSnJ9heMZ
A15fE52xKHXZNZ0KpTv09uJNxluNNxxv+/HzhNIRRgnIACCgdJzZZT0sbeFp
+if4h59dNFC6Fb3YQP7wWot9o41QuuVCKWaFOigNebyAsCd+7wolVs2aAqRh
rPZRnjjeS/yNbgapjUFqZJBu9ds3e+wbnQTS5ebprKCB0XCwgzHqFRjx8pIY
xbPgDkYPxcXIM1S1nhyMGvsIo1vdhBENtZ0wwuLHm0sYCWV4MXrccFXMIcsP
iA4dj+Kz+P4hICVc1nHmE34OPx0Hpo7IrS6CqZFhwoTNRTkcsyhjzb51n7J4
s4Spd2ETEBNmRTUxFh+b/sitXigq+0YH+WYMbRpsvubBZjpxFG9RWTMJneT/
RVqizxxvxD1eTHvYHO/wZFssQB0EENaSAOhMjVu6GwwCLP5Dx6AoCKLPohKb
04acuEY/TmoQ2EDDNxM2tQKbnjD+aCw2eDvNxaix0YtRTJjn+4BYjS7lHvJq
Jxmq8HzxzuLPNQ+FGgcoVLnVE6nttG+021fZFSeED+SHwMcU7CY+XtLziK37
CKSHHep4BjvpGqwCJ6DBuc3g1DI4V5noWO0kz2tcTggWTIgGoDFDIyPAOSmR
gX2TQq9G6nSJTKtd207I3GZkmgeCbUOOmZhOp7uWIvsia65QtRoft2gYiKvw
XBANclDSE4bwxHpBDHG1mSCazge5MJLyPJ5hNhnPqkdZuZk08uTYAWuPaVq4
frGmOPxtGww0C5h6GKZO+3pHvChKeyGDQEDJd/Bo1EdoPSTQEjzSrsjR5LfJ
rwGq6wxVXWf4dreAKiSgklZj6gSAtnGWjyZ8n+CSCZSPXrxfLE/lgL1T71OB
MP5k61AQcTgCAwwFA6ppi1xvsa802RhoYli1MFZwovElQ9x1xuMHqR4hYyc+
wiaxPG5pxAOaDH0HAk19QYwcqgurDEHO9TalyYXAY+mg3RIIBMQOMWIAzPIf
PBK1HsGjQ0fpKbx25KRj/Ez9cIlVHgVSBJoKpAZCrQRaUJiSaeMRKc4N+ydU
Or0HD7inPhDxTN0w+GCDiIJhdZtg8HtC9V3hm+3hmtbItWb7SqN98XZi+gGY
aZnXG2O1TTMoFpxFq4pWHI94nhixZpgzaJeXMlYagt7BQEt/oKk3KAfdGYFi
vtZKslTLCDgbmacQhvCEpBcgIqj8Bz6F0jtwhL4nvDTPzrBJvOw4K7wNQkh4
VflQ0IxIvEIi4KhbsVSZSzMFZHqZ8nthzfJYw7iCQkRRJChgXHpDDd2hW53h
2rbwjZbI1Sb78h0b6zShOKp5OGxKvlhbHjTXGo/dT6N8RCPlIZeOnqZUFcCr
L9jYE7wtBt0egeO/2kLvq8dx4b0Xmo/IxWABIoLKt/8w/NeBw/SNg5piGTjp
SVdchmlk7VdLEj2itF8oNiCJK6i0M+CZz4038wFXRDKNvhgIAa7bXaG69nBt
a/h6c+Rqo33pto1lmphNRPjFMiMY16A7ZjE4IAcuWDaTRp6scTIt+JQDFs4L
drA7eLszVNeB9RWBpRLeVuQmtB0U6o/s4HFJKkADlHz7D0UJLR/B9h2YQ8mt
uLawIYq1KzO53RHoGvh5ePu4IcmYO5bS3ML8fBIp+mrN/txgkye+dXKe2mUN
k8ckw98VrmsL17SErzVFrjTYF+vt83XTIvQlEyHtuOJaA20ELR+GZfn18rJm
0qekzxU+Ef5Xiv+u9JEc8TCnjwiiUH1nyLHXTa4ICgbMFBdEJYUP4LH8+w4y
TrCAh+kVh0tnlCJk83eezR98AZk/kffrjQCipsGQUlWTnlT1uLEkTSsiUbLm
/itTSKxL096H4pl8b7Z2AIEJ5h2+CbvXHL7WGLl82754y8a6TIxLjYyU110Z
y8sx3ZJONHbLh7Faj8gxy2HzAnObAG38XHmvYc5L9AWFxb7JFvsaLHaj2/gJ
ZWEwiuA6FAVS+w5gdnv3R615ew/QN3gKL+BlsoKKXGQCL1IK8DSbwItkAu1r
HGLdBGw9kQaCbbp1ahp/05iI2c91z35A2/2gx57EDYCBG8Sw8FcwgHcil+rt
C3U2Fut0uDmZ2jtDkWYyg/F1rYdkkZCEDuP3Y7Q+fGXePaRHjH8eP8rCiIek
hyVn1aFGDJPd4LaAFyS9DjO9NFiAiKDy7dkHdu3dR9/sdUMmmCaNocpYXCBj
aMMYUuDVQbEoItLGQe9q7Y+3WsWslWVhsgE1mrn1gETKWKee3Iw31AJYItTq
ZOPfDFsYuXTLPn/TPnsjsZj4zmBEuKy4C00NnBaaCZc1E0PlOTwsjGCspPCO
FsHGQFAGGx0cbGC0d+BbDTsoJIXBKlhAjRIw8u/ZC5zwQEBFOCmLCF6RtDjv
SAuYQzhumENENRRydRFIdwbC5tJ0qfcJZ2mK6UYETliRA9Zc4ZU1QhFlA01j
MhQj18lhDZGfrCeQIpi2dFgwg7X2mesJ+qyGwYg2hrFa0CSV5cOwLL+BFH1K
1ijJEcfQSYwYugWRTVO/dLE3O5TDukMBhjZ/JCjOOsJP0EmjVL0nWl0d9eGL
lVy9NwrMCLEDbk5xkCyStXgXztXCBtJfwd/Ce0TKvYewcpbm1B7AsSQ8Z57v
AxHtndngmRbESQAYNo+y5v2cie6M3Ghli99gXwBINbQwp8Hoy/rZ24N2ozR8
cdJMLjIFhkyUImQKIm6U1Kg97lWPWkSCjRwJkp+CSG8hu8ejVhHwZdpqovD3
BHke8ITodIDIA0wAz26gtHt31ErCAyBGuO2hV/Fv8C8PaF6pKEsbv8vK+N1k
49fQr1bn1CZf+ivGyvKRuJoZUWtUgCWenaWVBd4rnn2czIU0fUPh233hW10R
sPt6ixLqbPqwRhOKruoHbGEA46YyPNQSgyfQrO8KpMIxeDnE0qbAHDS0a4+M
LkCs601sAVm76qAKSl0QS4gKMn8ar93RXbuiu3ZGffjCyD0E5PCaaQsluc6p
9FONMITRK02cexLSHYZwUC5VM9tmxljjilzCFvJiteZ6523YP++8jU3fZrHp
20spFDIopgnk/HRievBWn90w4Fpq2hCKpeYxCwyYsIi0tphzSQoqZbXZtbpU
halfe0L1HSGpX++QfoUOOlfrqArJrmPEFrKB+wkOgCKg2rkT6n3nDjAMj4Ab
nqo2AAO8JsNIXlxXSYxG3g1pt2922/V9kQZzkcaYwlF+8ycMwPSc/TTn2QIm
HaU4FiXGDtLmxwBxGswmi4I5Q/sRp+zTLHsTU4B1vfbtfqyxsGEOjTXmtgsa
LAwc4x7y0QSS9ZgnjOBqKFZXDAvJSiqIBGBL+Hpj+KqhgmSq4hzJbsEqYQXJ
UVVLPgGiHdujvh3b8D++EmK/Iaz2OJ7LYdZZySwyhfWc1W2JXm+3a7vsW5j1
AOnA5qG4ptAxKJ5Zh5hi+IzHzrwn5fo0WOU2gUMhvMP4i2B0TbtUfxfr7PM1
YJUtdn2mqmn6QtfGyG8clt3sscFU2HQnAPESTZsIuejAJus+Eh/JJl4eapmh
odREkIIwhKBWQ/hyfeTiTbhbNgiaWielvCAruJ/wEKQSeG3fGt1eFfXhi5W0
fVsU6OFJvAruCeSAskMxFocnr8gSJ1lx0Rat6bSxWLUfiGMQDfetkbP8NNu5
AithTtTMpR30EkwblUEiWH0/ERvRHgmN20Swc9ft01dsEVdOwTHvs363L8MC
rBOByIBrAQqNOzDuEiICOh8G7aOZzBcTMOcwGo9wbr1EuTpSHoi4QLi6yIVa
++x1+9QVN+FMw7ib8NHQbdsS9W2tjPrw1Xp4WxU9i9d2KQTxM5J4x6VLw+8l
DcLbKZebaJvmRmcU6/VWPzsGrFeet7NemXjSkyuvhhnSvAlB+mrNdqbMsKkF
6+VaI3MNfwpvNG1qNbLnxpSv2acu2Z+dp2z0vSDnWEusQTLzIF1fGE4Hk3CR
jsFTkxjR4GHYfhr/vAllKzRqevEZwj7QSrMIQ6LCMsNi1DoWI3L+hn3mqrQY
xzTthJlkd7ZLoQaogNjWCsy0qjxqza+qoG/wFF4w4cOPEfsOOw4Ov1rKkVtc
ntZKdVS13dG6PjKa7CpCGKInDHXgm4yd+RzXzAV4Yr0afq19GCENaBdCOFGP
mfdFa7rsa628Z1LPBgczv2hTOufUveBHtb3Wl/HgBqYB288J0UZOiLYOmdRz
WU0BoA9Dtr5La3FSTEDPQaIXZw0q2pGQ6uOCGW09IEluONZD0w5GU0RjZDQ1
ehVRAFdVFp2xpQx2E4/xjAu8ajadBvEoWSWkyU0u1GimQp2a7ujNvmi9m3jx
DI4LPAszH7a+oecca2riiGamXgNT72YvMZ5KMu5QHHK2hnJoJy7YYtF+YVZc
x+Wc4+Wuw/R3qGSbWRKkaGfaTGE+MEzrPgzXShrlpwROsYGZ8G+yxKePzAVt
oDSp6AQWEkQ77yIaNIbQ9/BsJk7AqLIUGrKyJOrbggffwRMaL2AqRMpejteg
bMA0U56c50JQspJdn9f2RjEWEmUDnBCGjRl2OXbt6jAzH6bqo5nOFQAJjNSs
JUwupwAVRiQL47eTecGse2VZNZVz8S46eXXO7nD91p9jJ4E7FHFtp31L1JHz
9jmRTZS0mtaSzYZGjubjx1cr2YTNnfiQSlIwDLE8VAHs8nUyFJSfheg/I0Lq
816GSa+2TcIGiAAVEKsojlYU2b6KIng3PK4spierTAB3sKncJ2MBYttpGQg4
KqWF7GRN7+cm22Lcu7QxAkAfJmnNFAuWYSPkLH52lrYteJ/k5Ecm24e5FmCQ
ZDR59T7iWU3P56C5rFbhfAJtU3BwSnUP8XWlt+ba4RvNo92gXJ+knHDX5jwG
GBwBn3UfjXo+1pyGbAqyRWQ9XTfXBDXblxpgF6Ok/68or8ZxGogilSS7NKgO
AVlliV1RbAOv8kK7LN8uK7DLC2wfvrEeAoAATjMPQONnHX1ylGgM2lFC/5qK
CoQ46YrijcSohIOLTWa5gRuzfJiyn/hHU589xLOmKSubGEO2iEO2rs9FJRTV
TooknYpOaQc9oaiNJBUoZvizO4Y/E8kRAyZn4P5hhZI2Duy9eiW9Jj30ovJv
qk4V9GI/DHpB+F+SKwxUOCDotZdsHGmPKlIZVWVMLIFSgV2WZ5fm2r7SPNsH
zKxvlxdEXWBVsU/bpdTI9BQjKRLFyCjX6nFoBliWDxO0/os2MPwxJqASr90v
4BKLVJsW7cVI+qtq6vjsOk4eIbEqaxHGELG0hOyXElJkirtGjaXGppHGOIMG
m+xFin2u14UNsDno4eK1FsEqW7DqhGIVhdSs8CEdhP8ipMoFUlHQCNgAppIc
21eSjf9zbOs7+B6oufCqVCaRBchdmNUZre2RzGo0MlmdLrzGfXK+PszXT9jM
1mxS8Hi11e0BiiZqe9SxDJNQFx1CYWlOh9D9+lmqbmhUtOq2xVYR70LITVnv
Ehsb1+SyZuCrlaQH3KNCyY6RoEOnAdKD8ihJG1UrsbfiFIBJp0+JAtWCTuyq
SF6U0vtflh8FFoAF6BRnRSxfUWbEV5wFy4cn8LQJFH7IZQIVq+KE1y1UiopB
meG1TtxJY6KAsnyYJKFlzRWrUuAknJS2Is7aVBXUZpm7LqyMJRPv8U2NlpPD
py30Bq7r58wApUL6IuCASIW0ifBEAebDwKwZGjN8+PHImq+HbC4wyahBkke3
elU5qBay8RglpcUOsmNV5faWUnJPsHrEJUYKOBVmRArTw4Wb8RHxFWVErEfw
ZEl2pDQ3AtZVFNqEmbKEQmxMxyy9TCEVByN3hhRmI7GYEWx6sQqsLB+etmY5
eAnjp9k1xOxiRQyTdbVlOnZhpSaUEzazcCQOuzkLp3KP5nrrYkB6GBzrPhpp
kgFTwLW4Bnk3qJcP/HTSYK/w4jp/k0WgoNVJSSuh3cGH7dvIiDFM4bL8cGlu
uDgrXJTB6KSHCjaFLF9+atBKyk8L4ht84NmijFBxVqgkJ1SWHwHDQEhtB6ur
p6VXs7lGbbFBiKFro6LRsvw0Yb9AjKbN63Z2TwxKLinVR/4Ecu1aq1P4JfeU
3MSibYiE1IXYkqUKFXFsRgy9X6b0xdD1QpNgMV40Xn8P4dVtDLhd28DBsDwE
2e2UhF8WlaCqWOOYWln7D8o8FGk/toGVxbBuAItwKNwcKkgPFqQFgVPexknL
l7thwnoYj/JS8BHITw0UbAoUbg7gn4JgMIrQ9I5F3DUtu6j6l4/Bdtow1mIH
RltEDZmvmwDr0euUsZrTY5gTPXu8XWZGQC5VUW19ZzpeYakmtt9CubYaUezA
pcttTpJbmwZnvbHYwACt+2gOC1xACRMgCsPFWQWuAiX5J6pARYTI0dVR4a+E
Tq+m0IoURQV5H6i+0rwwAxUoSCM8gA0wylk3nr1mNHvtWM46fIznrB/P3TCe
lzJesGmSCAZzCBdWGNW28C7sMrdfOtll90uV4UGLZutXiHXzh+WjJ2fFRck5
tkAocU3R7al5Vc17Eol4LbmHznVEuvyL5GC/sAsaKhq5D+Oy/GLwNNQZ9Okj
oKc5RXZgkApLGjRUHbywWmRVPG0vc7UG1jilMIS3MqQF5BzrCvgpGECYukBe
yoTGKWv1SObK4cxVw1n4WD3CyI3mrgdgkzCKcGLwbtAkZA5ZFk7PLVGYKMo8
qOhXlk8Jm+IGTGImjUuXMPts+RVWtEyFm6Y4mKsBKM3WIiussUy9pDqqohRe
ponxSpSoELXqZB2RtAtELWXKFWTgjhi+dR8GaiWZMIkwULkqaf3M0mqRdqEq
AE5ZSG9VLUSFDVEB6wdFUZIDLQGYgoAA5NEYZSwftHybPxmwkvAoY8Vg5ooh
PIuXc9dPwB5KtHIi5LyKI1vKInfnFle66cNEai+aYmMTLcsvVumIxMeiVeuj
F+53QBLaV8y8g2wJV1aTsY3JV9gHDtt799u7d9s7ttvbttiJRVei/lVTSxoF
phaHHiRqDaho7D41+A6GzeLvF7TptSUlu1SBN5W8EIfMYql10KAWyYuKSGVJ
pLwwQtoiE6oCjioALICIQAtYpX/cv+mj3vSlfekf46N/87J+PKlQG2fUgkWZ
wZKcYHl+CL9ta4UtCbZ3aufVIMsHZP6mlzSxcAHNbN/aeJ3ybP0KqdltBqOU
/ONZdxFRiVRN9JvP39IJC/voGfvwZ/bBI/a+g3b1HnvnTns7LdNIYryiUXMx
7NkaVa8sXG4X7/H1O45LQ4YBWjNp6PMkoxRGIvYVkVVtzMlHyavz8XhF5g9a
Llyax5IiPUQYbWCMVgwxQH0AKG1JT+oHXZYv7cNu61F8g6c2Le1lqIbwT3Ok
OZwszpwszQ2WF4aJXVtsD7u8yYwGsUhZCXeZ9sSBSky6TRmWNmlL1OQVVBRc
9ZNSke6qhSXVbZNa9pGT9qFjkf2HInv2RXbvjuzYFtlaSQs0sZq2o+bYbyqv
SxEIEUwA1sBBiOXDmCy/Hr81kz49qYfbKCN3maoQR/SvtsmeCrq2MA6lSFgg
RIqUFYRLsqEqgvlpjNVa8GkI1NFApSzq3Ph+Rwo+FnWmLsZHV9oH3Xh18zIB
2EjO+rH8lLHC9InirEAZiFUcqaqIbN9qu4h1IqZ6QLbZkEKerMqgCzAfJumj
2foFRPSQnrNmmUjhh8RZYvwaceD7kj7/KROBxKsDn0b2HQhXV4d37ghvqwpX
lYWxTBNilmMSrhoHo0TmqYtHTnBFBFyNPDKMz5pJI32y2cEpwrl1Xlm9lGS5
0WWkwerctFLB1W6HVghoyfSxryLpB8UHywYMNn3kgLRhYduGd1o3vNuKBxsX
tm98rx2w4VVGqx8cBFq5G8by0yaKMgKIvKD+t5SCW5Gd2238LUgvya1TqihH
c4tjLpF7quunXKFGS65QRTKB0Rw9cxdSovdFNy9SYfc9OUCilU202hvetSu8
Y1toawUsNULEUGJ+iwpVThsVRTflSdFrKrkrALstAHOPXwxWMC5ZEEsMm1t2
8MYAN5pxTtuJ01tT0osCLOgDKEFEV/kpAUh0SD8YOuABGmnA1r/dsu7NJt+6
t5qtJDxezxBuNJEDz9aO5m0cZ6sYLMsLVRSH4Ru2b43s2mlTivfglHtgIhkl
8vGEHLsC3kuh1cqz9WHyfpr1bDnrAZkLxL+v7eWVajoAI8VOzILHOhBhZoW2
bQltKQtVFCJEnBYvR797Ri33yBXBYA+5tIMd2KDtAxyWX9CMxj6DPiXpAdfz
mHn/xukHNCW79pvs4vAqF0owjAgYVhAaEJKCYPqgCyxarzBa+3qj5Vvz2h3r
sTWvN659Ax9N695sBoQb3+sAouAi0IK2J5OYOoFQDaa1vCC0pTS8rTKyY3tk
d7UtSHbIJJlep5zgxdAxAUKrj9IbeqnyvKWFaRQWhY0KrVHeuYJdkWu0Q+Zv
9YlQXVzJ7LLhtMCu7VvBrmBlcbAsP1icFUwop2vahxOeobfKbHxtjy1MRP2g
tBJi9NYMfLWebOBMMxClBdYnFtjn5tF9J3URj1ZVRCsKsBDbQmGQbGeXBW0B
QUFgKaSA0+pXbq96qX7Vy/WrXrmNx6tfbcCTeHU9IdbOiPUCaBKIGyYQVkMd
YulWFIWqysPbq0AuGCJbk4tKOYzKUmkWmVy13VSMI6WWXKkzxLQFSvzM7IZB
WzKrl32WblzldgOKXNGDklwRclsgVynkEPRrAOY7scyT9r6usd/SbXfk9s/N
vmjdQPTWgDbsYgbPNDCCwgSS8eYNHEKs+/M4HUv0DrHJsO2aYdHSXBtBE+mM
9WNZq2EI+zct6UlZ1AE0QCQN18o/3Vrx4s0VL9at/GMdHq986RYAxKtrNW4f
dEHkw53lrB0D/oXpoFkQNIOj2FoJp0GKDCEPleAY5VMyZq53SnAkboJpvFx9
mKofM6ev1ux6bfp76E26odq0mHZQLNMjXM2gmAW7HCa/BWblgVkIOyYTQ0uI
20O69OQSn0BUBMOg8ffx1tf2fn6zn4z5LcKMxuinseOrlcQoEZ611GTqc8dd
Cf16wzkS5Arhd9kQbFUVHBSDWll2QXowbyOU+whi3/SlbAcXtsFDgUIaouUv
1Fq+T56vsZLxaPkf8EGo4WX8IwAKIgIskFLZxHFAj5ULUU8MKwttrwrv3BlB
sIOQR5yNOBrru5VNJLB6nIXKs/1GvVqcYn3ieTH5GtZXLjtYq1SGWcRwwFbc
ghAKSW5tDuSnTiak401566nzwhoBqa+Kddb9ueUDayw/Db+P+G/NpE/zJFRc
chDHCqpzQRjwoeORA4fDe/eFd+8O79gexjqHU4F+K8khcZGXwsIdUMEKsssC
VGteawB3BE5Aadmz1z9++trHz1yzfHhoJX3y3A08i5cdwN5phY7UJhH4e6kF
D7bb9lLrokzpSM/NeoMA61aA9REqlo9mPFc4aaEt8ALNXmPV5m7fog7biFKh
/YejJAp3hrZvDVaVByqKJsvyIIZgtcchaROLkquVxo1LMSwUgqxNDh6MF9bB
ug8DtRbgkQDqumiq5W5cJ88aS4+FYCNUXR3cuSO4rSpYVYb1Dr9CuQf4GGgD
t7sCUHeAAdgjUXrm2tKnrn705OWPFlxZio+nrn789FU86ULrzSZoRzKEH/fh
t0FZ5qdNkvfKm9Z7iVPNutOhsCkGWrRIfTRlvwCNJs7fz8YrEih2WLKl2G3j
vI3KCMhkezUM8eTWionKkony/PGSLASIWFGjsChTYDVD1WM79tATQUqKXZEU
070a5Qw6actVTILG7KfJ/J4sQTeZwWsdjiJ0Hbtztokje/eFdu0KbN+KcU9W
Fk+W5U8WZ8G9TAhLCH+VtqQbERUM25rX78ApAQ6wSOO15PeXPnz84hJ8PHEJ
jwWCGjhwEYwEL6EVEVkjDIAPzNs4xhyLpxJj3Ze2LAZwlg8L1YdpW9/ApMGn
m4xULS/gG0JgsHr3NjEwHddhOmlDkrBqsqp0rKJwtDRnpGjzSH7qcM66ocyV
g9PX0hvfOFyT6Zq4dFONr+QCbCNwxBq07gNg1nwJmcgOckgvUpumPKKiJkjD
g3AgoZ07AtsqJ7aUjpUXjJXkjBVthvymHREMHc4rZXHn+ndaoAhXvXx7xR/r
AAcIpfH64F/OL37s3Af4+Jfzvg9/d8F6BAgq4G4IxuFnN2jjuGIwZx3emvGi
zMA0kZhDN2Ff6qVLcBjXJa1MTY8wLPTY8uFpa9Z1lXO7LI7LuyWWi2d7ouS/
KrFex8ryhoszhwrSBnM3YG31Z3zSfw+1hg5yOie6L5Z4RttGMZerCjxrBkDD
6D+3kuToBXSNqpmQ9mdGXcbe/XAooR3bAlvLJyqKRktzR4ozRwrSRnI3jAiB
KGwkFDuk4UoB3TPXAJ3GbfFvz1q+Rf98xkpa9Nsz+Gbxo4DyPCH45GW4O9AT
COKHEaZtXNie9gHESF/WKrxDo+A1+7aYFMhh13o1W05dMhC0fDTpb2LCmDe5
727y4HjueoeaPWPntFJSHsLhHG8h79iGBTRZUThWmjNcmD6Qt7Evew3EbW/6
0p4pLKXf86zqaG59BQ+cfYhY6l2LmUoLA4jZzKDZzKOxd7C9UOA51tJ97ktF
ZRHyyFWBLaUT5QWjJVmYwVDexqHstUMQI5tAvUVEPVjLlXBwL9Que+Y6mEXg
PXYOeL3/m9Pv//qU5X/vVyetZDzC94DShd/zNdCacJCwubC8CLAzlvfnrB3K
Tx0typiAt/NkG036Hb8glaSwN46HZ/wwT57zg3LObXLOAjKnN8+lOIzbtTPK
0dhkef5YceZwQdpA7rqerJVYW11pH3Z9YdZix8PKmqW/d/b4pjId5tibCDBJ
unaCyY9HVpIJlraTzuEvswiqGv4FUX+gsni8LG+0OGM4PxXWbCBrFe2WgGwQ
FUy2BrKTz92A/FjyxEXQDLC89+tTC395YuE/nbD87/7jZ9a8hf/4Gb5/71en
XJA9cx06Bq4RcnLDuxAonekf92StGshdP1ywaawke5L9nEznO3w7JndezL5h
0kU0OoYGE7b8tFjn4JEQIdrCeBaprjB3aLY9yjHZZGku/MNwfkp/9pqejE9g
0TtSFrUn3gHbUSdU/jA12cQ8zqp5YFnB2wnK+TAdP7WTTQKiDmx1rqaFR93l
UBxVImgKVBSOl+TAeEE6QKT3ZSzvhU/iIBo0a2QdWUs28veXYSAJtl+dBGbv
/o/j7/zimOV7++dHreR3fn4M3+ApQGjiB7TJXv6xDgKTdUr7piVd+APZawby
U4aLMsZLc7FwENra2801K44HnnZOSpOREV5C4eej2X6DUGwlLAVwYvISO2PN
HvOs2T1yhxkRY3nhZEn2WOGm4dwNCCl7Nn/cmfpB24aFrQnWZDvYVZZGp6Ge
01aLp4EhEnxMQB8G7sdXKwkWlIwjA+csvYuu4YsCqZ07ImQuSgJl+ePFmaMF
acO56wezVvaBGmZczdLkBqQk7CM8GYADz979xfF3fn707Z8esXxv/cOn1vy3
fnoE37z9s6MA0QXfE5dgLmFisQLWkFppSV3cnv5xd+bKPvwxuNTirPHyggBx
r0pW3+/d55XW0uSwj5DwqXn7MW9rjlyvd6RbIEtTIxuhSivpruATpUaUwKdY
bYz05Nr+zBU9mz7qTHm/bf3bTYnFbRVca7Q9ZoddkM3peysGzuYSA7RmUuvF
5ItunMymhkdjSg7ZGSNcm2ArMZKfMpS9pp855gh/4crAMehH+LH3f30aOIFQ
AAUQvfmTw743fnzIeuzNvz+Mx3gGkOFVkBAeDk4PtIShRJwnhQkRrW3Tkk6D
aGOludBzIb1Cq3mFHjBPJbGBEf6BHHo97aRIM9NIlkbDRPxSxgX/3qTYIU8R
H+9ZUKiaM8HB2mD26r7Ny7rTPuzYuLBl7RuNCWFVXmhvKeW6MKPq8tBR56y3
YxtrHbismQTYPDFYqjUxVpbTwcZjEqrCwgWXZI0UbBrKXQ831kvj/aATbgwO
CG4IzgjvNN5vYQwBAngDQN76yadv/v2hN/7u4Os/OmD5Xv/bA1YyvgFuePZt
A6/Fj56FA0S48MkLNQjgKA5gr7Z5Gbxaf+6G4ULh1QpDrgW6n/yO49VYiJBF
uSH9uTAqPprzXAmTgZSwJvoCAyfWOUScldsWVXQiAIwuzhojg7KuP3NlT/rS
ztRFbevfaUKgmViNdll+pLLYBuwAn+qa9ULTB77dYxeA0fDroYAJuGfwSA77
pmuNyS5RJ5wAU4x8a2WYvfBIUcZQfspAzlqI3W4yCIsodQ+pBzu4jKUHgjHw
5b1fnoSrAmYg1Bs/PgisXvub/a/+cO+rP9z32t/se+1H+1/Hx98ewKsM3HEC
7jenXSx7tYHkI0VvPZkr+hHSQj4WZyK+D8UuVTMReUJYlmvSk4vJ+2jqczF1
MXEyg9qwqJbQTicL8yiHLJKNluUFijJG81Pgv3szPulKW9K+8b2WdW/eWfVK
fWJ54tLccEVhZEuZLW25e8WJPoOfmWOvJVONYfqomd9z4Ne5OjVqhZhDNNGB
yD3wqnL8RfjekcJNA3kb+sj3LutM+7B948JW6EXE1aQ6nr5KYvHRs1CKsIgw
h8Dk9b87CIhe++G+V//73le+X/3K9/e88oM9eAwAgR5ehY18+2dHgDBwhtcT
bFv+Qg1F3W80Ucz2YTcCwew1iCug+SdJ83Mxo1yxe9RZ9+NOtyrdrx6z03P3
09zn0MRvSrhO83l7Ojp63nXkXnptsjDkd+B9IHxgESmsXtmd/nFH6uLWDSDZ
67dX/qkuMZ4VZwXL8sNUc1Rp74gVT6pvrrCNWEZ67Fh21gxqP/YRDVgjpdsa
mie7xBmUquiWsnB5wWQxrGIq6IUl35W+tD11Uev6d5rJff3pFlSeMIkgijCJ
QIGJxTD9YM/L39v90iO7Xvrurpe/u/vl71UTcD/Yg1ffkHgdBb4ukv2xjmK0
d1pTF0PwY3kMcYA9WZITErWMIJmzUA2SmTew0JxvONMmmG7KJSrmLlriO+5A
nbA3tYbYaSrJDhSkjSKwyVzevWlJW8r7zeveurP6lVsrXqxNDC+1TcG5nSp7
pz7ycdhpqiAazZB1vEpL6bQYew1iFHy1kk289BqLQy4pkcKQSEUZUBwDHJd0
pH3YuvG95nVvNkIjwIuR3HhCyUI2h3BWMIQMVjWQ+tP8nb4/zdvhw1frtwAP
yDFm+4EZvB0wJoIpdwa6grSUFCGR30N7aesgTLFoQlTbXeJVx5pgwofLeV8z
MKsxoLrh8l+6EbFsaHFAVmLr2uayArs4MwCbDP2T8Qn8d+uGdxvXvnF71Usk
iBOyiLTWsgO8URHeSklU22PQzZ6RDmTXo36M14evVpJESt8+o8ilzyjvdCRS
mCXSSB4MwqoeNgjNG95pXPs6bbh88nyN9F1Sb7AZ/NsDYBbTaidQ+mPydsv/
YtI2a94fk7bje4CG1yRePyYFstAgGOhKSRCpPWANsURG81MnizJDVCysxbE+
mqlORB8xWqeDPHrSFs3amoNH+J7mraygQyz3wTahNkDl0jwb1IAlzlo9gOgC
hnD923dWv0rEWvbstcS8V0HaBJX25QWMnQrbsePH1Mj11SOXpVH0Y7TWvFN6
yJfk6jpm8EpqJJc5CJdkTxRsGsmFOaDQo4PNQcPqVyl/v+yZ6yzjyRSS0yJe
HYS7evn71SDRH5N3vPjwthcf2mr5//CdKuvRPzy0Fd8DvZcYMEBKyuMnh6EX
wUtm1yUw1dQcbA4RrE8Wbg6V5lItvkdzSC9wPM6NK9IXMGaElHvm4voW4tVx
2ShGnu9QOoMMYY5dmB7IXT+auXKAY5hWGMJVL9ctfwGB5pXE8MpLGS/cPMG5
G8SP5j6g6rulLYMYOxsHDNOH0frx1UqSUJ1XYz7h2AKnwreSDvzDSxZnTuSn
juSsHchY3sOxR/PaNxrIFrxQg+BYSoxfnSIr+A+fMrH2SKiStgGgF75dZfle
+NYWa/4L397yh29XATjGbAf+EeQHebEfH4TkWPhPny0Cw353gdIez7PeeLNJ
mENK8a8fL9gUonJ8YQ4roiLn4XED8lYPtohiqWK+fszbmoMH0p7oK0JOOm2Y
9Elso6QlWpxt0wbhutGM5QNpS7ohrta+AX9d98lzCGEuJYZW7oaxgk1EMKjM
iuJgVXlo+9aw3gp0EeysAxgstY+akc0/wUOWo1Z4udhlCA0ljkJFmyfyNo5k
rx5AXJT6QfuGdyE0GlZCxz/L+V5hC3/JQuPvD0MPQlDA6mm8nv9Wpe/5b1RY
jz3/zcoXvlVJuAG0pG1/0iz70QHyYb84DtwXP3oOjNWiYwNExwddyiYiHKJD
m7BUOjvnHKrllWreKEGgGbhpuPRalV2J9ZFsfSxRHfSgkpZMOy8lgL+OMWAk
G95tFTHMx7AsT1xMDDMsNtq+VaURbBR3KqMozLn2YXLoDNsMjNeaL0esr6E5
4bSO8kijiiIbkqwwfRyRK+LX9KVdFC++3bT61duwWawxLuH9ReAr2AXtgHef
2JW0HZCAVUDoubnlzz1Y9uyDZT48sh4CcMAMr5IrA2Dfr2aKHYJKhPsD8B8+
LhUHZTu0TVw9AptYlBHx2ESX4jApRr2hMEvrmwIxvUglVgbBTJ9thl0QNmQO
N0eowG/VMAaBoWBALLBqKe/2uwuJcSxnLbvfDC4WE/XpVbapb02aCZsuIPNj
wDyLZBe3tFGIHXOhXZIdKtg0RvuwK3o5bwYTDlFYv5zN4YePS53B4RYpQsjB
P83b+eLDINYWYPPcg+XPzil79oFS3zMPlFrznp1TimeeI8y2gHzkyr67S/gx
4A3U3/81qQ6XTXy/fdNHvZkroeknCjfDmUbKC2xHIrpVh+vOFr7wjaZL87bm
CKjIYaurDg55rIopCmWFXxjkyFgxBKsM24zRYEwQhRS+PHYusexh9hosNbiw
YElOuFyEzab7ZWvuEIxHfoxWG8ZqfY/GLIZ93rjiTtsEVht65GTIS+hUEWQ0
bUCvHVQurAWGXMhZvLMUeIFhv5D+C7KP/RcxjOhFgJU+80DJ07NLnp5VbPme
mV1izcdTYNzz36yAuYQ7A9FeIaLthz0laU/i49xHbBbhL0gqLmxD4JyxfDBn
HTmy4izEF5Tq0WkqbRZ1s1N9qeJxXq4COn4XHhCY6dXqmBfR2Gy7OKdN5qU0
T1TRhnLWjpEX+7AbohVR5wp2BjDcCGES4hjHkHBl0PWIZm15PFj7YNUg7ZC6
EEMD5ydT8cixcy64tFmQfb2Mw+UVXPJWlBnMTxnLXjO4eVm38mAI7zl7+PvL
ix87h7cYbzQHXfuIYvNBsW0gEWwg+AVuAaun7i96+v4iy0ewPQLYwDq8jH/0
IjFtB0KyV39omMbfnqFgTMtF7chgXdKCRRkhSvMURUT07OnmcdC4rkCARjbm
nOSX5cMT1mxzsYoWuKaBEccKQAjQAn8MvpN82LL+1MVdUK4YEEWdT1+D9abt
9YSYlsmlEaTvs4JlBbbO01BkUu10+xFd/PW9kNZMGu1TUPGy//VnbrugB1xp
0zkIWmMIQoJ5G8eyVg9yEAIX1shyvlaEyYt+e5Ys4k+PvE7+aw8snGTXNypA
Io3VU18rfOrr+CDQ8AwBRhQTvmwbOAm7SNHzT4+IdAf8g8uRUa6jnxxZSoCs
S7Y8T+G1i4piItGDOfoAjPUNgZlYpMQsN7m8NhHiuCQCcUxndag0cxJ/lz1Y
x7q3mle9XE/iWFmWhPgFcmavHeYyliD1Syg2FJNqYidNulhobBsxVh+A4hkk
y0vV9KhV9FVdrXoC0Akjm2vr4XeD4HPWqsH0pd0pi9rYh91a/gf4MKEPKfoi
e/ijAyQODXZJuL5etOBrhf4FXy2wHl3AuBFikl+V4BdZxB/s0UIRb4N0Yy/U
4O1Z92Zzyvsd6UtFLIZoMMAZOXEK0Om+4njvo64lShQTLDuj4Dolr+rRvYq1
OCRhTIo+UpYXKs4MwoTBccJ9womSC3ujaSVc2HPShVHpQ0LckjnQlDGSHaxw
tWHw9Iw06WX51Hqbp9fYlOMmByYrgDluDOZSqSLFjRvfb1v3ZiM7sOtLF1wW
ywzvMkJfVhy7oeaF9yJbOLsE5FrwtYIFX823fE9+Od/35FfyrWQ8QVQDyeaQ
HyOSwSR+z+XE8IZQvuP5GzL7i2jsox5SHlogU8FVhKyKXqnCqhx2LpnQqNG8
af7WA+Yy1c3APd0QYGqpRjNjMj+VTmsjBkxb0kMbSa83rvzTrWXP3iDn9ehZ
hDHT4DXbwYvqjIaovm9zUGtcZ0dPdBvX5tAYOFl0hsryEYBJ2ntpE+72uuzA
8rhme1MwZ91YxoqBTRQ7tonYcRliRxq4dGBv/vgQfBBZRFb0EIKKX4XgFsCy
fL//Up41/8kv5wE1PAWy4WXpyb69BT/mcmO/PIH3hIQH56jWvmEKj7H8lHHK
2NOJiohsFmG4MddqZQOD+TJeDx4xrqX1msQ97sP25L+ChZsn81LGs9eOwX2m
fdCtYzDK7jxxCY524T9+lpBVTF/aK4QHVj84UK6D/61Gg0ilGM2h+wmrZ8Xd
8IeFxz0aM+jt6iwf+7DizAj8PLy9qZNE0Oz4sJ8dVTHYTgTEAIAsoiRY4YKv
5AOn3/917u+/hI88jRledUzjwy5PhjdiEe2yqAD69Tv4u2kqqcg6mbL2rJPd
y1X17RYeQUycbjzlmc/RFzjKmR+W7dtND8YxWKQkO1iYPknee82IlBvvtK55
tUEEoEJuIA6ZqvZN1XLcb2LGJgJikTATCZuqCqPN4F7VJ/KIJNthQTYaPU1h
qckxCZpyYyw8qLWNcGNFAC01qKL9biPaZ+Hxz7TS8DYLWa/cWCV0hckxwPXE
X+U88dc5AjqBG151FIj2ZzIs+wy/ecnjUiyqrZYuvH0yuKH0N4OmuujsYsm1
VxtHVsoaNME1ya8TMYZxn9HPrELCVpwtPNmYEh6dSiXSxh9cOAQSPELiFYsG
60R4mSMQ5A4YlUbFB7m3vYaSOupMxa9uh09y4DusnJpYeaozkYQvIyKFrkjW
vMPwmStPqJC/PSBSVAACvgrBF+AD4QATYffXOZbvib/KtpIligwh/BsZyjml
UJmwrPhh/AqhRyisduSjyg0r+Zi7QeFXwPgpybxbSWZz5fJsvyEg1JwTNwYK
/WUGOFKJUDAdgd6R+K0agQ6SwvGV28tfqIUEUx792D3g9zUDvx6W/oRfsehg
ouXkdlfEpi+D4k6odE888W+eOQ25DN3ChPUv9aWkfh0ZEZlwg/X4gK3Ha2w9
RLDyG60k97/8/WpoDO3myGgS/8hiAjnL//h/ExgSDQGgNpwKQMpl/Wg/RI4A
kATlU1fxhomyHZ3IAoB0MJe2ziLaXegQ27xSRBhOxnCuQM9lNNVlMp6w2gEw
bZKOzq0aJgDf7+Cd93qx3/TBY+ff+9UpOPipKhk9tXBcL/xVPIDIEc66IC0I
DVEmkqdGzOmy/cYsZtAskj2Dd60+mcpxwYa3Sxl9sh4SNrYelHL8yad4w6En
KV77toLt6wZs/y3b9/hfZlnJgE6TDzoT/+aZB0qkREneTrJSAGdGAs9zJEDA
dSjgxhi4IJXBCJ9R5fYZxoqlm7z9NOcHnaWq7ynZr/oLOr21GDM68TNBMnrV
8KalvRvf71j7ZhPtEbL8p6zCL0/CxX9xD92bWVyJHIGT7HZyBGakzWZDDN66
jwiX5PJwvA8r1hkbCptzV9RCr3BzOC9FRJiedMBVDZWU/t/dTULSgcrRJIDK
YqzmSaz+SmF1vwer3TIE+MUxgdVHXIeKEMCM2ti/G1iVO539qve61AkmeUjd
vD7XsSzHXQ5i7z6XKKPdTSBGyatgftpEDm2YDTsBG+t/ygM9eg6K9+2fHbmH
yvy42KXGYLft3rGTzc2rdNimsJPZgX46+EL57Qad3xZ5R8Zun8DOkZRfF+4t
D6Qiw+g3eAY4tUJ57sEyBOYUBxBw+wRw7wG4x9ReNQHX5AKOdnwZuOK7A+fC
7bOpcdvm4FaaFybcKG4bNQLtRoWbjNu4inZ6VenG6pN7wMpcdY/o0Zt2Ig5u
1IWKWkgVU4sIxm2VIa7UvoR2zrR5pnH71pbnHmTchCxhl/b4X4Jzv/v/s5h3
SZAoEjgRw2ngvrv7tR8CuEMcdJ+SQTcDx+n+DpiqTDqwCxvjBm6LCzjHOrJP
sO6C3P4pkMsIGMj1OMg9lwhy//UeUds9DWqHp0FN2QoXalnU3TKXUGOPvKiT
CrkNSfWeRo1CbqDGKS3EAi7Usgk1P1AD2/4yC2aTQPty/oIY0ETU7cqUEGi3
5L41iehhvI8StLyEQPtPYDZOjRfEzsxCE7PL/48xk1ZxJo08WWvGhKDaMJEp
oRJp09vLVdpUiCfaQWOoXLG21v1/RYaR+AWf9pdZbBqzTdOowXpJp0h+ftQL
1hsaLKq5wtKfBqxEfdr+eLZxixetkYwVQ2kaLa1ChE/7v4/W/sPO4GPQOnwX
tAoEWitJNpHUZbRkkpuk7kkTrThu7MtwY1otfp+gcjmyInZk5V60fkZoLb5X
tEyNfNhBS2dJBFg+ehtmmdHN3cAalJuebzS5wToJsBLKZgm9kTOVVtzl2pU5
6IlQ/Fp1xEYmO7TqUN6L4TLtoAwtF7jt4F1VB+M138HrS9Ph9Y7JrueFYmT/
5TGFhmLcuV2p+xhTqPT9HJcH8NhBU9+T6mCw1o1k6h3qN5wdaq3vE6sq4Ehs
gEdNaIk+oHEisZhReyMxd4JbRWLc7E12o7qL1HDkvY7EaB+mRERiBBbkvOQW
LGH24wqrBVokqmTxSy6tIbAyIjGPSEwsEqOFOUMgpXNXZrLV2+XYRMrQ9bKW
oEZvxNwFKSPfIUrEqGI2cI/5DmhDI+6fNuNBgFG+lLZnzXjMSbwtNeIxT8bj
eZHYv6eMhwrGDE3vbKHpjEe/CpzFLu//u4xHuDgzIKLn2IzHR3fPeHjYJXNU
FEUGzBzjtng5xoNGjpEyVH7BsOPT5BhtzjFGRBcxzjHGS3Q8fuF9nZ9y5Rhp
48zJMUrAsn0E2qM6Sywl4ZwyM8XoJDo4xagzVFglKkU8qlLEQVeK0Y2Xaf91
ljhuijHGDyi8srwpYrk3/byzN30XvJys/iad1U+fMqsfZ+BGVv8pT1Z/nyer
v4Ub1nPjN9qKAWRrRzd/olOKrrRwvKw+xV9OVv8rnqx+XoJZfSwJWVTgLgHJ
S+H+cTlTZvX3G1l95tcMkdUXkLFSnHXXrD6XE0xieajaD+UNXtAJg6mz+h6r
KCqdKZu9OUR7Z4WuvTOX1DDoZc2k/aPkT9W+9KGjzoWy7m2zqNw2y4pQkaxr
26xRbZtd0qUfunSRsHJtmwms8nyAyZpPO2fmtpmSGbRtprH6KRcLG+U6VHf6
bquzz5k6wQdGwhihI4XdbuDQUWOXV+4Xzjly0msOHbFh7prRJid1fhd9nsTe
hbArqkiHKyim3DXzcIsaclHvmQmzJt2z2aerGD1706KiIN7OdExpFafUqIxP
7UzLquY2T/ghRNIbtDO911Hzemf6a+BXPu1M+2lnOons4FdldPyMsS2tdzn1
trQoE175R10PJzLd46p2k+CKsy192LUtzbvwU+5KxxYpyZXKzVozOCe1diwj
zq70xXvYlebN2RGAT0VhMbUf3u1No27Ffw+VH/IkDnwjLC41qUL8wekYt9M9
R05Xi3lR+SEc2IOy8oMBK7D8VPUxT1QQCAEvChhV4QfpwjjpDC4i0KeSuPAj
wDFXmKoXpy38OKIrynjeczz1SXEKP6p04YcAa5IKP5YPcpDcFpvSSEwdcop3
hGwCnc+5e2UVoUVVcGZN1QnH4ep9dFVTxddBiFpmirrGqZsYdVrpUNmnGrmh
Z+hC6ISXhNv6tqypAh5PM1Y+AuuxBboWThd7cNmi2sbcL065eDdTdLpw5TB1
0JRlVeHKEttTVqWjFlGCr+tcRPGiUwJnllV5NLFTVhXmfZVJLA6Kuz6ifZWY
RXoywYrFAVWxGEq0YvGMrFhMFhWLR046BtzjtvQxHN55RtA1QV2NlvWlckMq
QxVelDXcym1RkCxk/DddFYs+4GXNm75i8fW/O/jWPxyBuHD0YLzSe9XaLwwR
5KpYdJsSXf8makrnOiWLZxItWVSy0Cm6X+8uuofGmI5ZTrccKs1ZP4LIg4sd
7LhOy1UT7K6M9VFpbLI8KnDaKFz8NJ7v4tvBiknLT4LOGdSLqmvDwta1r3NV
lahlZt/llAV/31MWzCSbVewDctZ8B7I5sjTnD66q4IOxVcGy0MM53jJZRJJQ
9MS3TQfglOZ8Ju2JnjtXcD9IFdyekujjzo3wLvdVGqG+ktlB1huTsQdbpPv6
5zMJaY3sNRAa3GyLzgLbLsc1dfW9qD/nEx88/qTY2vv9cWrvyS4WZ4dhhxwH
9n67a5/cSHCQXfyBUR3MR1tE7b2o4Z7/9OwSCZisvd9yt9p7bhEBraF31TeR
9+ISuHBVue2952+K2ns+I/LgceO8RJzae/OOtLJIRSHd5EReTJ4gYy8Wkz1M
7HwLZTpl6Z7nzECC51uSpjzf4m6FwEcUw3REkQpThtI/5lZGbzevflV2FDDD
L7KNP9znOt/yzQpRf2/x6RZ5SgIKng8lybJ77wGX38QecOlQB1yo7q84O8Qu
LCzvB/EccDnuPuCi553w+ZaqikhlcbiM78iAMM4V/UCVBzdLcu7hxN+kx/G6
jPlR43ipcXrMd+IS/sfIn5GH/e52gkyeAYZYItMwBmpTiz7TNBhm8e2f84Ek
wTFxguwhgVnlc1yHT+eQ5hJSxCxpDbfzIU06Qfam9wTZNaqceqVBubHerNVD
iFuhiPlYj+jiZ8eeIJM+7IwDFibrp3Nzc1ynx7Q/OBp7ekxk4uQ9Gfij+NNw
ZLJy8TWncjExfWhE9pQ08pwF9p7QPC+PA1sz6XxmsnMyU4F12H1WwrSGWBCc
9xzLWTucsbyfM9Qq+DJPIumzfpJdOyAmwB0+8SdOZn4PqD3/rUo6NMbHacFA
8luCVsbJzI+ckIsiZO6U04d1whsn4dK8MFcC2445iT2ZeU5iRCf8LjsnMy1a
rdZsfSzVJJjHGnKFrbwtIx8Rs1im5L1dxdyJsYt6Vmci6opwsGiLg366x4+n
uYA+sK5OAc87dYUPbF92nad18ctjEAvC1DE8bSxn3XDmiv5NS3sMYW8YRHWY
9nXFL0ZtO6Chg+p+Ov+cJM/ROoefq+XhZ3WgxZTyvInctmlJNzVYJElMB684
G29PefjZPEcLcHzxzz7zfe9OW4E4Z59tueeXhvhrhOrXP+o2406MMcHOAlR+
yIOmMwLU0pw6C7iPkx6dsrPAx875+svGwGM6C+xUtpA7CwQKN43J07Qf96Qu
7lC5Qz77PHVnAYgIWDuCi3n2h+9sfXGq3gKic4dojeP0FmhOWdSevrQnc+VA
7npqtUK3Msa03vL0FhBtgU5cTqC3gLKI3t4COqjhmj78XdFbIJ3Wabty3FQo
9ufdc0/nS2HOaVeBblTasc3etctOpI+HjzpazBedR6j5yLWYuahmHvsOuMwk
NfPIDRRuHsvbOJy9un/zsp60DzpI53P0T6vvqatLHhc9B07qM5vczEO2XQG7
fNTLYz74B/h0Ow/8G3g/0c7D1S+HshzCQLakkYHszV49yAd7AlR9Ga+dh+yf
dtrV38jVw8TTzeNS/G4e1Z5uHnQsKyAO0mEYqZj4Oy3k0NiT3wuCjncrygxz
eypxa5doq6taxsd0zqFZiI4kM++pZ47oFkE9cwJFGWP5KcPcpa9n05KOje+1
0kmll+k8u+j8pjuxsCChXc1X//se2EL4r5ce4Z45VhIAk/2OHNgQRX+quQer
yxsrsJS38PvxV7g1Zh+sdH7aOG+EyWx3Il1zLO44803d7Uh3OBIA3rVtjtMw
gqrexrPXDmV80pf2YadsGMHePfEu62znwzCZW0UjXepjbXt7U+kmTaKhWA31
ZvKdw//UoCpZ9tMyofN00HF1krHLC0Ml2ZMFm0Zz1w9xI8zu1MXt1MH0tTui
y3Mc0v3dQdmeiqHzAS8r+SVqT7X7ZdmeSrY6itOe6sXa1a/eWv92Y8qi1vSl
XdwTc7gwfRyhdJz2VKp7juyjJtqBXpUtuXyYqh/ztuZQl6oaZ9pxO1O5WtE4
0Q6M5ggbzW42mk0i2pmycttSLdbdldugGR/T4W66kmZGFzg29ydUb0yzCxx1
QvPhq5Xkwc0zARffqNgDAi5YlDGenzLCnZp605Z0kqDUDeCo7az0eAt1Azij
rZjlB3hWkugA52on9j+Oq/45stniqpfq1r5ev+HdxrQPWjcv68pe3Qf7XLR5
HCNwtX9z80ybx1NG+zfLp7q/Peh0f6tR3d90I1CTaJ7ub3mcHU4Zz14ztJmJ
pvJAt74wK7dj+s16+iyqTtW6UbzqnJtIn8V5Tp/FWnefxfPeRnDqYiubUzkh
aoYGjbJ+OHNlP/vpDs20KfosHpJd+/5mn+V/9Yd7rXmQLa8ZXRbfjdNlsQ6L
eN1bdza+17RpSWvG8q6ctX35qcPFmeNl+UFTlbi6zp52mlOJvsG6y6Ke94PT
tFk8fs7FNm6TbLRZ1KlHZhu3P2pf9xa1kk+wX7DZ1TSiAkzb227xbl1Nk83G
ngK5OF1ND8rUCN3DU45gI8SHUSfyUkapKQGtui4q3GNNLCKBJU9w+1nVwo+Q
+8lhyA2A56O2pt8DXtTUFCSTvTE9TU1lu+C1pESaUhe3pC9ty1zZlbu+r3DT
cEn2eEVhkJTIVqlEYtssxm1qqvvQ0tQZwdlTdjU1Gy5WG6lX6GpxpnPjWPbq
IUqYf9BJOYbX7/x5moSODJeLcCBOL12nf3BtnP7BS+nyiWn7BzudWcnU23wR
aIjvVAvQ5TTS1PeKvLfOk/AlBhcAxfvcLdPsH0xtaKkT7RT9g3934aMFV5Y5
jboRt7VsWtKW8Uln9uruvI19RZuHS3PHdf9gsxGeybl77R981t3b9cjpeF4C
qoxSW8GizElVGCfOj1M0l1B2hLcjbLOBn5SNZ4wlpzpU687c1kzqT53s6ac+
VVtuZeIRzcN/ynufCqmH1RibeL52QpONHJsSktx/ceE/fUb91H8OxI5wV+55
oiU3BKan0bPsyk3NFuvpbPS7LamL29KXdmau7M5Z11uQ2l+cOVyWP76lNOS5
Plre/HLW29z6gmqqDogs6kVuzXWaqavJn69Xnbl1O3zjFiXXzYd0h1SQpdg4
37kxpHanWhOLuDmXY5sG4nDcHvj17h74rVH/1Vb4NN0L3tMFn67muex4NqND
t01X7cq71QLi+icu6lOXTTDDoIDZRHKHbtEF/9en4N8gSrhGgoqQvita4IN6
gPM9BzDZBX+lINfbLRvf5+bcn3Rnr+7N29hfmD5Ukj1SUTheVR6KbeR6dNou
+PLyBr7LgO4AsB5wbjAw+qmb137RDcuaYkL7l4e5RfckxFAehBi0/3I+8P9e
e0KIOQ1op2r/Lm6caHBunKARt0dn0M0Lz+t7MjzXTZw0bzdxrpuAMI3IiwsL
AiXZExDdHG7SzbXybhfufe+E2k/w3SD/THeDvPcrunGCECKQTtBtE788aUJF
dlBeOHFbXjhBh2q7M1f25qzrL0gdKs4cKcsbqyye2FoZim2UnMiFE+KmEL7v
he7amG3eaiPuLTjtvpPooMsbcLfrkiC3vx8vSBvh65QG0j/uxUATyxYnep9L
o/s+l5l0t8nS+Je5GDfxyItN5GUu8I+R7VUhurCsMFCaO0Fan+5RomMe6Uv7
aBNQ3A/yqrof5Clxmct5+DHC7NfA7CRgk3e5mNe5qJuwXNe5LOlGFIHYPW/j
UGH6SEn2WHnhRFVZYHtV2Imh9fUSas6x17lonOj6Hb6iTGDmLNaYS13MDvi6
o/w26iiPlToJ9cPtXYeyVg+w9upOaK9zmqtcprk5SVwEZc2gm5+SxO1BV827
k6bgF98PHeG7AEOVdLfEZHHWBNvxUTpkS7cM9/D1O6188xW3wmc/BjTgysAy
gCbuTnpsEV2cxHcnKV7p26/47qSmjfKyuR7EzjnrBgpI2Y+W5UFlTG6tCPKd
ZVNTy7hwSNy9c73DdQEWPouL5aa6OinOxUPytgabfYFYq3y9xLrBzBWIcnoT
4tY0xNJ3lDl3rWHQdNkTuEV3lD1d0y3vLbzWxteaxF6G6r0rKcr0CsNzVBRh
yJOQ96omnfeT6C4QZQ/lNWXXAAWcmIYMZAJEeAztaABVo68pM+5w7KOgecNA
YTrE/Gh5AVTG5LaqELcC9Xos58bNegaqyXtNmeWjOc+t7eF7ynocyK61xVxT
ds2lEA8YlyZBKrDcEp5AZFwR2/Qndrf3vd0GSJdyRX3mXYALHMTanUt3PQbR
dXULXV8b2VYZ3kJ6PlCcBZk0weXNwxmg1xIXveLfBfgE3QX4Ed8FuNR1FyBd
aEvq4r0OdUHqAHiVnzpQlAH1PlpZNL61YnLHthBfZRvvLsBa4y7AFoKB7o3m
y+T4rlG6apTvHJ0t0BL3a8ZeA+i5YtPwWzZf2yI0Fu9GrRxMTBN6RKy+9u9c
nFs2P6/hWzXFLaEz6JrQBXV8hWGNXmDmVZt1Mvz6LP7l0BEWR4icA6qN0wjd
AGhQ6z911ebS3swVgxBc7K2GSrKGy/NHt5SMb9syuXNHqHpPJL7V11dtmhej
8j2bcsZzbqoLe8Vl6xqq2Gt71a3QBqW2cguowlCpiGAoXTCcWBVwrAD03l7b
Jm+vpQuHgYpx57A1A1/N+2u75S3ectgsCz0XFroC/S0Rjj0oOSW6ASHwoi1q
9lkQckJlTHN/7UNT3F/Ld8Tx3ZpwhAVpo/BT4FNF4WhV+fj2rZO7d4X27ou4
Fqe+I64+5v7aXpq05asbiPpovn6+ZpjeAn7OmoVX415fq80gyYw43IpWltpl
+SG+G3oid/3oPdwOPdX168bt0EwnINUvb4eeWT/IN0NHTbjE5cj6PlSPNfBe
uk4ZqXBpXsg58Ea86oXtgozbABvIcMXeDP3wtDdDdyHazFw1JMuNNo+X5IyT
nwKlKsd3bp+srg7tOxiZ8u71JueuXgEUY/QtcZO3vBl60LgZeoD+jXkz9OWm
OBIjHr/45AEVVwXyUyYSUhaaWI4Qcl+QDLbUOEDRKG+DVX7PreuDtnOfdy9f
QN5G97br+1BdDHNUoY7uVSUfXWELwzBE2ohR2/j+vd+6vpgsYMYKKm7mq6En
S7LoilyWgJOg1q6dk3v2hfYfjniWKMhwoV46Z7YnEi5x3fxUt64baEmz4hYY
UsB7bvhzmoyFCtID09lB5xZvSarYq8ebKbAgt9rDl8STJaBbx2fcHohgtHfw
MRSZgS/Wk/hW3ENOF1v30eW7N7DC4GwRc93m+6yMO3dj6cWbK5FSqmuehLPN
3TBC1pB1bCrf5g3CwCBCaGi4AM6qV27jMRhFUsJAyTCAuvyQbqBGWLetiu6k
Jl4dCB08EqH1ecYR6pJXzWJ9SpTqGCXMzkdrc4aYNX0AL3pmdoO6g92BrFNd
tZwgu2iLJVKUGZoOry/rZ2kz3Igw5M3jjWQBhQbCwAGCoBSP0Y/BNg6F8WHN
oE9J+N6E7GaPXdNpO9y6FT2nMocubpmZM9k6N8gifix3/UjW6kE4sPSlPRKy
d1o1apYPEFmPrXm9ce0b+Gha92bzBo3Wkh7IP2UFJ4x6NnUbNBTgvghodehY
RNJKRSiCVuKSeVqkBlp6gTbSR7iJZ9+okBOTv2Vght8gORYbJMflGG1lRhLS
7fp2SEkuc5XxreMACyAALDFojNKH8Vr+Zh43PeTvkzEDDF8DV9dr13bZN9pt
L9HE2OMTTVQbcd3OZgHcMAPXB9akLu6EXYTY09j5IBmtJDxe/07Lhndb8SrA
RXBFiK0Ykqf0qGI0QudJ9Wk3dw5AbpYoNSgn30YUI/tvICaw4tn6MHk/zXq2
OWuBGJQiflZQTCYIjMt56QrGeBQry7MTyzgJcsFWnfIsMmkJ7Vt9dn0/g6XW
FgZrzWwZDllPNg+HmuVyIywFUviZmi77ers0iabTndJ3yeN+VA3H7otqGCE6
oBjAGKAAmSjAApMADR5A4YNSKR6M1ozywZRgcRZdNRC73W9KqpNuSSXmTNbE
jZFenZgsTdpHn+bomTd5ABP86qRfJ6Sx9GGXZbwZqw4FvxJDC++ea3UJgQF7
gNUFavXa9X2RhgHCQuAkx3xfK6HV4qAVvqMGTNEXJJJyuhdMpzsVqUropoJS
OqnOR7Y3UG0wgiVgACTSDMAADx6AaTB9aR90b1rau/mTgcyVjNP6cSq2zIjw
cV/bvHXFjPsdw29IdmkA+0jxapyaeLaEjo9m628dDuJrq0JsVrMXK/oF8B/X
2BYKJS91cYzzMusDEsLpmAqDz+rl1UaeElqBQbJv90fuDEgytfAwMV7rvraR
oJXcyqBhMgIqZ7wcMArHJXW8ySpvzOWcyeQuENR3KXc9oKL2FYAh/eN+4MFo
dfsgEq0kUA34pRsg5QCk1ABfA0F9ovWJDu/NrMrgu2weG3yMWVt7DVKLxKUN
U/4Gptw+EsTnNgIsKCdvgFXPrBLRMiSaSOQIOexh1R43qxLyV5JOWla0EBdq
OkEnsnwMU6RxEDDJUWOUPozX1zESsJ7p4LGL4WPsBmo88EEeuJBIKgChPYSp
2GWck+COwWF4G8QgErWVwxngmAIufWlf+sf4oKu8Ga9hJtUEtadPDwv7B5aK
gt4dHl7F2nyxQLuEg5YG38QL08YcaeZ+zJy+WrOdSRtokcDqc9lA0vGxvDrg
8liJ5TCczJJYYa0kvKEKQCkA1WAAJYaLUWKwnfgYDVgz8NVKwvftcqnRvxPD
lgqjX0bKjjkQ9LoQh17bVecKOptJjYLDBenBvJRJMAY4ZK1muJYPWj5gYyXh
EbAD7zJXDQsfBVoVpIeLMmH+ImT+ikW5uZdZMmHrtvdk/gSzsEC1sVcwETS8
OmeIidPHSIBQs2a1exCDZemP4LfAdwhLKMlVF4dcZnVbwn31ZCisRQVRy77Z
Ld0U4Gpi8yeGLbDqAlb3dY1OWkkYuYSLhk3UMhyXMght8Xl16KirRkhf4QTl
BodDcG0iuOCFctaNEWKrRiwfMLPmASJ8AwSz144JPhVsCpGfguzjcwHOEUq1
rXoollLa5nNkRTZfLFACyj3jUZ6xj2Y8t3t0skt+0FshZq8Rw9uFX4G3jrRw
j5y9JFjtdAS7l/6VjmUUVHOMeSdR7VZP5HYflpwEDrAY05j0YQL+HvHVStbz
EBDKSbBDI7r1qUikVUYiWClS13rottMUHgrCDIIwP4WOmuYoFH0Q6VZSztox
PCNJxthBsmtzSEcFBM/2KJ595uLZeTfPKLjssxv6hXFxYdfFk7Zcs56NZ/TC
FdAR0wbCkmmcjhM5jrsy7c/rO+oiXBdLjh67vjfS0B9uYvtIXswADaPuGZuw
ZvbiUzIe9fBTNA1lKx1DOcD2vZc8+zV2xXGYd8x7S6toyyScGoQEIZcegvgD
tfI2TvoBlJWcu3ES3+anBuG8CDDhv7Rh3OIqY9C7jnp3xNRYMGYsOVhgDYZb
hlxko9nyhHm+D+BBN8/XwCyEH8EPwvETZv229uBa0McRiVyxkTheXNf7JTxw
KEai9nNh1fVqM6ESI7d8GLevj/8fp69WEp4Q09CYtSohAmsJX072opsc8hXh
kONRTdsLWVFZxpgVKMwyqdUsyJSfBmkNmKyk/LQgvi/cHCnKpKYfgEspRCrp
8hQSSoqp0EVsOkit1cWKQypEsT7dcI1NEFT+PvFpHF/pIb0P1uweMWsDPPwC
MpRsYzgUZbZN49c4z8O4TF3ba6CXExdj9RP02fwJ+g0PeH5iluf7+xN5fYbz
vdk72icr/Av0s1Uxn62/+D8HG/gJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->772544055]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->124303645],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0fQd4lcXWdXol7aRDyjlJ7F0RUNR3rGBFsRsFVCygKKKCikoUURELYkHB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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuM1cUVx39778rCsrC797Lvu7GNgNC0KRCkRSplF3n3kWKLi7JgqW0V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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlV9olnUUx890vq97t7n5vnvf59neZ0wRocLwD4gaiJCSxeiiTac3ypoT
coKxQEJzohcyLVPLyjmr/bso1P6oddNIsFVbIblpBrbU9KJtuQmapJte+Dl8
vTjwe37nnO/59z2/Z2bd61VbJpnZRiQXaSszO5s1u1Fo9j4Xl9NmFdzlFJiN
xcxqys0+424UXVmx2Zeh2WbkRp7ZjoTZEOd/kGawziSka8bnerFs/uZ7IGn2
FbqvkQuR2W9Iw2Sz0iKz1SVmb2TM1k01W0Fib6NbT7zFxE7FzRLoD5PfEr5f
IYe74N1BPiJeN3h7A7MM/pvBqiPeL+hexucKuhZkA7o+bFrQtYJXW66YHmsF
OR4i3nvIEPU25KrWn/meXqSaE5zzkEPEWzjN7GjKbA75LC2Uzbd8nyDmBPWc
Q/aCP5+7bTnUDv4YtqPISrAukc868PeBNyuuGjfR6wakmvg7wRzE9yfwFsSE
OYz9BPbLsS9CBsg9QHoca4rZ79T2JzbbqK8DiTividS7a+i/w7YbWcb5Nj0+
ltJMfZZbwa/Dv5P4LcRfTs6nS81CMP6aohwvJDVDn92L3PWDPRBpdifJsQ28
+dT3PLlvB28c3f1Iub6AzU58m5BJ9DuWEDcaQvXGOeK5DyL/x1RDPfN6jnw7
6VcV+Vbw3YRPW7FmcB3faUjfZHHqV/QrsT+F/TfYf1omTjuXvedrwd4TqXbv
6Tj1LAqVi3PoNWzvclfHOYe7+0nV7LX6TPbTn3cC1dZLTfXUu5WYPziXqOl8
Ujl4bO/xvJQ451xzDhwg1sFQ3Gzk7kP029Gfj2sHdqF7C/w4WJXEL6PW0nJh
b6J/HeTXjhwp0IweUcvDSFzzuz78h1Pi+hFkmO+RULvoPe+h/qvYPw1WLVJT
oh1w7nvPnEtJ7G/miVMHyOVdZDf4XfTrGr6tKXHlmSLtWliu3HznNgTikHPH
OVON7RD5HgWrmPg1+GfT4qLv8CfYfhxo17yH3ovLgbjrPYlnlLPn6pz3Xd6Y
ERd8p5/i/CbyqnMZ/UhKPfDaPealQDPzWbWDOcF8/kBmTxXHGvHNR16K682p
wv8w8Zpi4pyf+0u0W37XFehN9LfQfTz2xUDYnsN/xL4X6i3yGVaA9yAS9yvR
/8tu3Mpq951ja+ndGmQsVzvjuX2eVq89R5/Vj2n12meWz3dBpLfHOd8J/nH0
t3I1ow/Azi/R2+iYz2b1pvhb4m/ULPKdG4rb/qb7Ls3IPNldONCE71BG3HTM
Xp9PWr31N/P7rGryWvwfMR2sL0K9/c6ZEWKtSmnW/oY+BvMb7ds=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4090500898564789, 0.25846085353969583`, 0.691949701897151], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmguQVdWVhg8N3X1vd9N9u2/fRz8YYyCoQIKIEXRCExWC5RRMBOVhRh4B
IhDRiChqSjQVMCKiKKCoqDwjQhRQgcwoJtEYaLAioAk0GjCpQcFoEkUUzYDz
f/yLSlXvOufus/faa6+9Hv9au0///nVDry1JkmRY+yTRX/Kn5iR5JZckrWVJ
0qY2pzxJpuh5TmWSHEwnyax2STJJz5+q/+easC/G3Kn+2zolyWl5fxuu90ez
SfK4vj+aSpIDmrNE9Meqf3h9krzcQb/1frXWGqgxmzRvT12SrNWYH6s/rd+X
iM6ajknSojZP/U8Xk6RWbafW7R/9N+v9bo3foP7bK5Lkv9Qmaq2bNPeamiSZ
oectGjNQYwZrrTO01o3l/g4/8DU93n+v9zbto5vaYvHcpt/Xqf9nmvtD0e8j
2qM7Wg4n+dTv/Xpf2d40bgw6M+Kddedrn3frfbqE3L42SUrU9rXzN+bA/wDx
uaAqSZ4Rb/8t2ZRrrW+VJsnfdBZvi+dj6t+cSZIfafxDyFNtmt6v1dy0xlYU
zetj6r9B/dPEQ3vxVqJ2s94HiedL1FZr/EKNm5Ayrce05lHx8p9qT7X3OMa0
ZTyfuZU6h+vVntU+tqivRWuM0ftGvS/Rc6Tag3ovVyvVe0/x0jnvPT+i89/f
bJ66imZn7f1L7atvQXOz3ntzjXlbX+bzRC70Z8TbPM0brfFbq6WXepZ0sE7S
P0a/L0pbtz7Te/+mJPm22ukVpsVekENjrXXlUo0ZoHO8SOv+m+ZvV1+r2g6N
KZT4/T7JYayeYzr6rGeXWB+6q/Xv4HProVavM/me9rBLNAenrVNdy0wDulM1
b0za+sv7Mj2Xqj2TWAc61JrmKZ2Abj/NP09rTtf7a5Jhj8Yk+Qt2VGf+4O1K
yXCU2iTxcpHGD0vZ7o6VWi/RSeSDvSK330n2T+Zsg8gF/Ua3V4nGyox/99b3
S7SXUo35jtqPRDtfYlsaJ5pv6CzWiZ//aPJvZIOMsMEq0a9U66PzWVRp/odo
3R0hB2RbKX1eqLm/0O/Jov2C2tWif0zzTtNZ9GlnG/9FnP0O0Vob9r5LY3aq
NUlHzpc+pDV3VWL+E601VI/Bot9aNN2v6/mNor8N0b7ekQy7aU8Xi96itO1y
Zo11C/kMEe3FGnNf6Br92NoB9d0pnvdWWe85L87qoH5fLjrnaOzktPUMmz2u
7zdV2GaXif7SGvuF0aJ/t2xhWsp7WhP7wmcOCr/aEv3s/QHJsLvobNX7XM0f
n/a4pIP7sVPOE9/KmfZL20+9pXWnFO2n0NsZarXl9l0vaR9PaD+LxPttGjNT
7VJ9vz7OGb1aIv5vkEyni2ZG8l8nms/p+wrxMVJjr9GzTHqYL7etPdnR3weW
uA/9ox85IS90+zPt/XO1gZJFu5RtYGp7vycp20N/8V+v50SNX1+0H0fv0Gtk
hG4fqDK/+JrF6nu6zHEH/d2g9VZk7IP4Dp0/a68DpVdvad5hyWpO3mt8KNl+
UGl+e2RME3/1aKVjG36Js8WuLiwzv8vDx27S+I1ql1W5b1nY8ip9+6iD/X9P
yfkbTfY12ystt+Xq383+Ut479A9VeY2+kvN5ah93sG1eF/bJ3uiD9j7x/6Zs
86jGP6k9PSQZjdO4Zsm1k9oQzb9fz/lqb+r9co053Og1ponWE2nL8V79PqLW
ovPqIntZIz5f6+g4sjz2gr2+Fr6L862t9hmvTJt/9kGcb4tzwXa3NNl+P9Dz
wybPYZ1PYi38AjESGRFviDuc4T8q7YOxX/rpeyj8elv4rnVxvowZk7I9YAt/
lB5+ofYEWCXnGInNXqW1xqi9KrktUf9WyW1Omb99XuZ4gf3jB4jNo6s95waN
nyqZ7RbNnRq3gLin9k3t63i1bQO74OyvCvrjI35yLsTEd6ocF88Vnd5qef0+
Tc8/iI8ZafsGbBJ7xEfcFO8/rfNa/K7qYL/yovoXaN5QybemxHYJD8SAD3V2
vZu9z9M4Fz0ni59HZGNb2tu3wxsxHv6uKDouol/jtdaZ+IwS+0fOANmODp+O
P98vWylo3dPb2a4Yiy3je/BB+KXLUrYl7Gh/o30lfpI4uLHW57o+43diYudK
+wni5q/E795S84pOoBvYDrI/3GD5Y3sXhY5xZgf0PqnEeANfgJ0/qTVHSQ6P
6/dvqn1mnNfDpaaB7ZydMV/nafyr4rmP2sN6HyN+NtVa3/D794auEn97lTu+
LBf970t/WtKOh/gk4uDLNZ6LXb+i98217vtQvM+XrK+s8PfNQf999R+p91m9
LX4HN3st8OPokDn+GvnjQxdW2fYGBh6ZGv756ni+kBgn7tTexuu9t8723Cbj
J+RMP3PBXugdMYu4WBUxt5u+7xFv2/FF4q1X0TivS8r9+MM/Fuw36wOzfVrj
ve8oGpeASVhnV6z1canjGzTBSPMDJ4Eh96kN0Pe3pVO/09yFFcZxs6uN5WZJ
354SH9emTAca4B9wBOcxJGTCWuybWDqh4PVGaN5wtR6V3kNbrIXOoC/oT17j
7yoYK4PfnwkMz173xn67aK+rC45Ffy/1kzjC+Y8PHeCcwFyzwidwNtgjmBnM
Dc6cmDcWQd7Y16rAV8RhaBCjt0EzbxsifjEGG/ysxnLG3kfKFkaoTdO3jilj
BPxzQbR31ZuPcdp3q96/0PdNej8jZ/kdDF7h862c4wc+qnvG++X8sVviIPr2
62rbD7aDb98X2LEt7B/b3yOeu+YsG/wxfplvHdR/vMH5Qt+UsTgYgJyDc56c
2D7RAfIMcoDWkBW517Iy50qf6EyOFO1HD+t5qGhbv7XGGAt8tZI4VeYYOlP0
bsv491e17vMVjv/zxM+9aj/QnLSe94vOJynPpW95xPTdgUPAGNMiPk6McfT/
Vfb0fpNxEFhjUsRk4j84YLre35N/GJY1Htyic+jQaN0bWuUxxIrb9dwW+HA9
5yNZrS0zbpsQuRpyIFdFFif9ScZ+Y674v6fgb1/JO68mpyb+gQmJ2zPUf2be
c8fqPN+utF8iPrEOfnVGxriNc0GfsIv5OtO7tLc7q/9li7yDS3n+LN45M2yK
HBCfjY3it7dJroez9ilgqAcDR1EzKM/7jPEdxArsqAm82my66OCe0MOfqN2R
8XgwIjkw8nolZf+FH0E/v6x13CCeIR/0+V3x8F7RZz+rznEUDL5Lz3fU/xPx
vETye6zgMz5RazroOeNPxHtDrffPflmDfvbK2a0PXeU3tInbxPMVBftWdHNc
5Jr4ZrA0/hkchm4Rw+gjftB/hcbvqXaORRwinpJ74wuwSbDKH0T71rxj+MQ6
x1Fi6EbJb7PaiWrnM0PSjuU7640V8Bun4i7+BPtcF/H7UtGcm/O5pySbHaK7
N+3YQg5wMq6kXIO5PuIjOgiuQN7o5dHAZ4ujHxz3dPxGH/Gv6OQ80e/WZOxL
XCUODBM/98s+VjQ7FoMLwArsa4H6FjZbLiO0TqueMzV+c6VjLrIbLd7v1pjt
1eYROSLXbdXuQ4cvkBwm5J1f7i7YNrALajv/rHSdBVxOLYB8i3PnnZoA+Qq1
KHJ9dKEh+sHOYyIPeUDrT8r57KZoL5MbbeunaKE/V9S7tgWtlRp/tNE4+Erx
05Q1NjsiH/APjWtOGy8OSzvO/Vhj7ij6NxiQPAEcdAv2l/Fe+uj753Wus0yJ
GhBxIaP+y/P2wYwtr7Pdv6S1tjQ4v8Ef4b/AunVFxxLiCDa5I/QfP8Fc9PAe
8qaccS/+Cl+F3wPjdG8yztkunlvVHg47oI6DLRzLG+uAc9CTxhrryieRg6AD
1MDQTXQDPZ9QZ30ltqLj1A1+LxqvN3t+/7x9KH4NjED9CZwwseD4TcxGdweG
zaEj34n381LOk4m/+OANQYfcpn/ksBV51xyp1xCzic3EQOLdyrAp/NnIyDHB
IzsDk+B3t4fv/W3O9dPWqOVsqDKfPSSzh7OWITHzg4ib5AmJ1qtOGQNMDl+R
1FgOyP9YypiLs6YOti10vl/GuB8+8ZVgPextUNTLwFeM3Ro2tTNyOPLZ0XnX
R7oFVn4w7HplxPa2qAdujHiHfyoL3VipeYcaPKc1+IE+/vXXgSU+kp58rPZi
hfdxPPayRnOXZx1r0XXwdr+omx2Pc8duPg3bIe+hH6z1crXpt2h/vUTjrk7G
MWBX1kEn8Itnldk3ws+JiB1/y7n2h49kPn3Esl7URrKuD2HrgwIDbaUGXm8/
cHvEKWIT58o7cWFR1JjJJS+WHh7Muj7FmrMiHr0rOu9GP34IPHKy5lvhmIWs
eM6Kd2hNj7oxdnUs6iTniM4H9c5ZoQUuJk8pD+xeGrGEmEKNiPoTdSjiIPtY
n/deyIHATIxbpjWX19kP4/cujfoqtcxl0T+n0nGfGPhN7fHPWY95QTT/p96y
JK9kPDnjmTnjUbAo9kZtijx3hGQ/Uq0pY7/bEH4YHSI3Qvfw9eQZ6P9srXVX
zjVU7BM7JX8EI4AVqDkQR4h3nCm+hDPHn3SL84ef5cEbPJJ/DG40NuX7WTGe
/Oz8gvloydiuiAXY9oBYC12h1osP/1/JYEPedWf8LE9wbJY8osHjOHvOlbx+
qdZc1ug84I7APejSsxFzwNjcUyAb6hOjIucCw+MbqFdSD6GeCLYD1z0kHvoV
XJejtvd41Pfezzl/A3+RG/y7+p5PjH3BzNTzqKWCafHJ+Jxj4XdujjsI8kri
CHtjX9QYwAScEXwxhzOib2z4vWPRDw4h/x0T/ez39rAXYgg+BX9C/Px6k2Po
isirGf+U+jrXu348qsI+C3/1S8n1rJxrzOARxlP/WaNzOJE3z0cDQ9NPfGIt
fOwbwfdJDKZ1h6v1q3KOznhwDXELPsHqYODZ4WMPZY13T+XPPKnPPCUaq9We
EJ2Rzc4BwP+cP3cD6AC1wG3Nxh2cPfaALcytdEziN3VIcjNqGvu11jN52ww+
5Hhg0dVZ51rsZYFoVtS7low+YOfoBPkE+RUy7pV3rk7MGCoe3xMPF1RZZugA
8jmlu+QFxHzOG9/O85Z439bguwHuBch/iBPowLIYh24cFS9zG6wHYBLyVXSV
tXknZvGsjn5wIefNWX+quZs196vi/eKs7+fwPeRSL4U8F6v/7IJxCzhzSo2x
JnEOfIlPuCzvOzPwOfEbLAsWOBK1HWz8Psnj3qJ1anaT8Sg4hFyb+hrxZXrG
7+BkniMjB+deAvvEJzeIx8ZO5uPCqEuhD9QXW6pcq1pL/pq1j/9Csj8kGQ6q
cV6IvqP/xM9VOfs/eIbfqeFzsEP08EZqHVnHpVtq3I+e479HRi3ua5Wu+yAH
1i4NnuCbGgK8PUAuXHC+Qt/IuE/C//XMWD7oERgRXWKdW4MH6mfU0RiLTKaF
fE6tAf17Ko3dwQDQYzyyBZvgS8clPoue0b9O+/pNvXFKsZNrNJzpL7kryRn7
UAtPoh5OPrQo65yI2snZWedMrdrHkTrXGYhRu6Ku+GiN4xLvyKZLpeWGLtwX
OtNV656et1znV1mO9IPpOsf4Z8XjZQ2eTww5I2LK6+TTdY6tQ/X9uXrPp4Y3
Oup4j2V9x8k95qCIWfh8sH/fZuN/7ljmBwYFjzbHPTIxoV9gsEGRV02JWhhY
ibhP7sD79MB7+BPk/0/R/j+1S2qMC8BE4OVq6eSBon0G9yLgJOIkPA2Iswar
YovQ/EvW8Z5Yj84MD12Cr5Y4U+rZrINvm5Z3/kPuw5otwdvwqGWhb9Ts/h41
Pnwp38g9qVnhj7m7/FbBfgE+/sTcRtvVbO1pZM4YkLj37Yh9k8Mv49t3i4eD
dcaQgwrOe9FV8Bf4LB33eO3jLu+Hon1No2vG5ON9AhfB19Vh14PEy/a890tc
5v6VGEc8GRXv5FG8E69HcLY511e4K8Cm8F3QxW6xWe4KhkX+hx3hR6hVkvfx
zrofi4dJ4u27Grs65zsP/Da1ky5Ra8WXQB89JJdBn9Al6ifMo4ZCnkL9FAz1
onT17JzvuajJtUVdjv+JuCofuK/c93NgzpP3gXEnOCEwFDiLmh7zwJnYes/w
D9SCekQso945r9Ixjj3ilziLotZ6tsE+g1oQsQ/sms/67gH7wn7xHcicWJHE
3RnPdvG+PHJGMCq6UBX6QM5H7QAsSawj5kGDsRNj/Llaa24nj1sfdRLyux/k
/P8o5JDoxKrAWufkHAvZA3Jj/8Qm7JVxKwNfdA0dAHNdELirR8R6bJQcfVjk
6eCGx0OG7Ase4X9iqXHb85Ff8L8s5Bj4AmQC/uSOjDst6tzUCN+IOiG5GpgH
fWuL7+gVNke9DZ3hbJA5OSz/H8F4sBnxuWPkmdSGwB3EU3TqlfBT5BecO/XA
3trHWdzV1ng/4AjsF3lOjFweOuQPe6PO/KvI3ZAHGAh/hY7MDT1B55AFcvio
3vaJfN+j/llvLPic3l+tty/ELl+rs56wP/bJvjY12xfgB9hrj9Ax7vbhF9nR
3y3kUJD8igVj7QmRE6Hr+CDyGPzYRp3/V3K+n4ffe4J/4v6BkPVfNebnOdcC
ltRYj+ENXI4NkkeAtcqiPoPtLo0cbY32ulZtqfp+W+/69alckSdxBPkcC0y1
ODAZeIwcmDsN4g41Yu6O+TZHcrgqFzm6aHZv9Hzs9UjgIu71loYeDi/6vpC7
wi8lv82a837KPuOFBvuNtGhWNPvempwCvZ0a99X0caeHToG/b4hYvCTiMTJY
EHKgRvt6xNBxWdeMqBc9EnIjdlO3wG6Q8/KIg+QCxPD5Ecex8ZmBac8Pu8PP
gy+uaPD83XFfz1xslH1gp9wTPhj1D3KBTXGXhy4fC32+UFhxVdF4hHn8nwBz
v5bzvQg6x94/ivt69H5C+MmxWv/Nets0+eb4yJHBrtS/kD//DwVP5CicXd/4
f4BXteZbWd9rQqsk/l+Ie75B8b9S3P9UF+wvSiKuMQYZnB/+B5vh/h4ZYOPo
ODj8/wGqDnUP
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHeQ1dUVxy91K7uwb997v33vEaSpNKUNEKOYoAZCBpRFiiSwEAHBoURC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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.524980267632514, 0.4600321240085154, 0.8549035911838851], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mYlMXxx1+OXWZ3ZmfPmdmZXbyIQUEWcYmAoAGPGOMJAaMiRtCgQsQo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXm4juUWxl/D3va3B1u+eVCozPPemTumVBLioCSOoaRU5+o0nJxKcUrh
EE0UUqbMQ4pKKCo0UxG2MUMomelKOr/7uvtjXd963jU86xnWetZaX5UB/+x2
X+kgCMaUCoKy/P6UDIKZ0SDYkBcE64Hb00GwJhIEHcsHweMFQdApFQSfJoKg
SVYQNMxHBv6RlYJgS4UgeCg3CGbFg6BBLAgKoD0SCoJzyLbgWxXwacjcDf9g
YAh4G/SXQ9d78FQH3wpPaeabjL5HLgmCO7ODoAe8H0GvDb0WsAP+Ydj3ALYu
YL6noR+F3hvarcCaivAz/4KcIIgyxxvMPR04yLgB4znwh5EfAe9woDG8w5hv
OvZvLxcEDzKOs8Zz0NozHgHvokwQdEF+EPakmf9DdEyFfhR7DzDfZmTWQB+K
/jLQOyBfl/Vvgt6C8Xns6w9/LvaWw5acuHX1ZOP7obs2c7zI/r4ADEH2BPy3
g/dAx53QpmDfGPbjGmTeY+66fJuIvpeBpug/CX9f8Bz0L4deQ/oYvwDkoe8Q
46PgR4DT2DoH/mvQvxubl0N/BxjLeAHzzceeJ+E/yfgE8BzjsUBL5t7MeAS2
D4d+Cvw21ncMXcV8S4FPZP0VwL/lWxPm+h39rTjPHth4OfvbnfuzEfpnwG/Q
usHfCrwe+ibBfwU6RsK/G3uexpbJ8L8PXoC+QdzPJXxbxfpWA6/A3xv5gfDv
DPtuPgYch/cU9M3QJ0Hvjf4I+v/LuBn6u+huaT/KsF/Y9EDMZ66z/lL7y1rH
Qc9GtnRhEHSGvw/6G3NW2fCXgncl9HvR1RKZ8aztF+b7HP1TkP8G3tfhuSzb
c6yH9yL07dC/4Nv12FPEt5m6z+i4HHvnpn13huKACfRt5lsR9J+gn2T9p4CT
rP0E0Aa8LfAE9NXoa4G9zTL2rcGcyRFkuzEeDj6eb7Plz8BXWZaZhGxn6I9D
38y3mtjbP+a1D9Aeg69DxwnO51XgFPgR5DdqffCPAn8GeAm8D99WcP/XIbMw
x3vWFtosZKLQIsAq5vsAOAPtbex/lP3Mhf9fzDeJ/fwe3kszviuD4FkB/g7w
EPQ/sbEme/UuOs/IFuhnpQvoA/0M+gaxd2vRcSO8wzn/9uzvtcA0+PPYzxLk
j6Hvas5yFTFjAPjAjH3tJvSFYrZJtnymOAj/DcjXYe8fZo4V6P4TniL0Nc6y
Lw6K/sWLTxZhSzFQiC0/ch/uwJ49YdvyJLAB2xvBP4O9mA50AI9Ab4++yujv
hS1vIn8A3aOxqT3620HfzFkcxubnmDuKDSvQ9RAy78L7Xsq+sBhYif4G8p/y
9omZ0GYAoxhPhj4X/U9A/5XxMWA0+vrybTz4S6zh74y7A12Zvxz7tZT7Nxob
TrEfw3Ida6VDsoq5rXXfsW8atAKgddo+Lt/uAezR/VLMhH8789cHvwP5H1jr
74qP7G3puGPtDqAs+Bz0dUD2V9a3irXekvFeHM/xXVzPuGKh7+RFbJ0HvAh+
COjA+rchfxZfS7P+AH0LoE+EdhQIMf4YHZ2Y+3VsaMB4EvwtmS+meJO0z8hX
9IbUVzwCzpexjgx4GvgC1TMYfwLvMvRPzfGdrML6bs3Ytw9l2Xdvht4ixz78
g3w97rfwNDy/wLuVby1YT3PgJPMvYbwJ3m+ACQnbLFt7s79jo45JikUNiEGd
2d8uunPsbRGQgv82dBQj25/5z8lXgMXIf8e3Ys6mCFia7T3eqLcIejNo3eE/
rFiJD08I/ObLV3Yy598K7TOjWMthxo9j//2sKYFt8bjv+n6gIfN3R0dNZC+w
ZxHR+XYI/ovw90ff9+ifHPiN6wnvzUm/5Rfhn8Na5gLJkH3gAvN1Bhrm+M2u
DW1DxG9FedbbBH2/RvzWfJ3tt0Zvst5ivTm9lQ9wvtNzvCd6m5dnHEv0Ro9W
PGHcL+QYk4W92UBz8D/wuV3wx5C/Ft4NwGXw79YbzV78yJxF4L8w5wvgVaB3
ZXwTcB/re4I5OoGXANULHWNnw9su6be2KjLVof3Ity7Y1hP6o9j+GFDEWZfi
fIuhN8KeBPb1g34ee/qHHev2oaMf9vwPnvq5tnkSum6IOpbszPHaOyBfO+Q9
kO8dkM7Cv3wQfUsjzoW2cX7l474Tugsl0PMZtwauDPmNDpQ/hB1Ld2Lz28jn
QT+X4xh7ENpB9Beh/zXGi6DvCvtsr0bnyzqriHOxEuhbovYB3X3tmXS9hcyU
HOvcjuyN7NdlefbBpdD2hx2b5MN7wa+ST2LfK/AfYNyOcfWQfTKO/i4Zn4Xe
wLrQ/2DcodA5XDzsM9bZXpfju71FOWLId1yx/7q432a9AdrLn8P2fe3pHMZX
6E3BlmEh43fwrU3I33qB/wD/8/A35dsonVfUb4nuXDXwrfDMCFlGcx+JWpds
UK67OOa1KeddzbgsZ7A3zz5Wwl3ZCczn/NeyP88i+zQ6Hsj2myrdV/Ktdchz
1IO3LvA+vMeB/0AfGvddU063M+6YqVg5F/7d4HsVL5lrHuNP8d2zSceS7xgH
6PqIb10Dr7Eqc/XO2BcPs/79yDfF/kXwLg4Z3xW3bn3TWenO6K7ozBQrYsDB
kGPGVnQvR+Z16HtCvotXA5eHfCdXYMtZ7Hstyzmuaos66CvOdY3RC/qnEb/t
ulO5iqcJ38Vixs3izmmUy0zNsu6JyLco8BzNGdcIOxeuzHgBa6vGuE8p58S1
lM8g3xbZ/HzXLl1j1q0aRrFLd0BnrxjWELxq2G9xPOS7uy/s3Ep3uGnGOaty
VeX8E7H1TehvlnHMHqrYjs5wvs9Eb+9AvrXI8xus2qVOzL6sGmYutKcY9wtc
4yjXCGLOVZVz1MT++jHbngeMB1+PzBvwPgx9NfQ1Kefiv8mmuHMG5Qq6U6c4
n40VXfspJ/oCez8HXsWWybmuDUvCfgtUIyqXWMK30xWcUzRF39Sw37ZL0deV
ud9i/Q2z/KYXMHdZZDrjr0lsXhBxTaVaSjGhI/zz+VYD/vo5rj0r6z0v5Ro0
DX5r3Ll+VeZoCv1RZMqDL0Vns4RrJtVKIeA38JXIbMLetYzvZ9yY8VT0VWD/
WyFfK+zceGuh79q4jGsh3bk2CedEyoU0R8uEaz7VenlA9bDvlO6SYnYX9vIm
oFGWcxblSn1jjkXKmZTLfYC9r+Y5p7uZ/dhZ0bmrcsh7Uq4RVRv2BHqB35Ly
26+c43fwAYp50C4oJwW/h/d/JPd7CdBTsinXTvKx/IhzSuWSi6FvYv7XsDeE
vfuynWtsizp3Uc7xNeOvUt4b8XwC/nHKuV01xu2Zb2/Kud+37NkU8MnAVugt
oU9QbZd2bTcy37Vyx5jPUjXz7rBzaOXOcwu8luFx15pak3Lh84pBuc6JF+j+
wPMMe/NsnvH2yPcq8DfVfqr5VeurBlQtNCPpt1g10XH2Nsx5tivvmFai3AZY
GLKPd0TX4oRzYZ2JdC8Lu9ehOQLGA8PuVZRiPATZe+K+u7pDOdi7gDVOx/Y5
Ba5td6W8N6px70P+3rR7ATqjKWH7iHyjdYF7IXWi9kX1RIbAe3faucoI6POw
vZJylCzn+EtVG6Sci6omnw8+DziY5RxrO2vJjrh3ojdkMLruSluXYtwieEOK
n+Az8m37wpRxraEPZ9WJ+YrLOkday7gN/Nnl3XNRrT4x7bummv39qHMU5SYr
2aNbmH9h0melO1EL+j8yrm1UI6q2m8n4p/Ku8a6Hd27EuX0KGAz/89C3QB+H
/tmq5eHZCu8r2b4bsYh9WXfkELzdUs5tlKPorfk66lxGb45iV8OYc0vFMNW2
V2Wce6nGPQN+NuPeSe/Ate6HFb0W1by1WOvYhOfWG/I2cy1L+S2shP5Z0Nqk
XRvpDd6ArnqMp2W7plkD/mHavQvFsAmc/fPAU+X8BtyOPQOSro0V83U2E9L2
DZ3RbOaalXJuqpyxMmt7J+lcXWdeBXurVXKtJJ3XgB+LOhc4VGhb6qd912TT
i6qNM+41aY+no6si/F9muaZXL6tt3L6unlaZSn5D9HYoZquWrJDw262achd7
lUy4l7E4cC+oZ8KxWT2h69H9YMa5oXom+yo6ZitWb4Z/mXL/pHsVeiNUSzRP
OHarplAvSj0r9arUk/ocek7CvUS9gX3A+yb89spHlJsrp1YurRx9B+MPou6l
qKezTblNyrF7GfLbmH9I0rWMepY/M26Uce2oGqAGttaLuZZVTVeTcVHMtZFq
qOpR9+TUi1PNrV5bqbRjhXpuqtUvpByrVbP/O+qek3pN2vNKzJUB1mFLU3TM
yDiGKnbKR9T7eDnt2K0eiHKjlnH3SpQj9Q2756Vel3pYqvXuTfntUM0XqDZK
u7ZUj0m5cr2wezXKmdX7HZ927FIPeGbEPR71dhQz5fvqUak3pRig3qJ8Vr6q
HuM48LHA9FKueT6JuoZV7aqaar9qgYx7V6pRmrF3B+LOPQvZ8zLwlk75LuxX
T0ixI+ne0w5gj/LVuHlVo6v3rBxHuY160Mqd1VNQL0E5tHKpBnyrmO+cSr3R
fnG/TeqRtg3bR+Qb6sGMUT0dca6oGJOVdE6gXEA123fQ+iV9Nqqp1YttErfv
qyer3qZ6turVqscZS3kNsl095vqM9yFzSb5tEq4aUbWhvtVJOcdSbqUe08/I
/qGeR557juodtIq5FlUPYR5ndUXEvUTVBIrV6impl6SYXTvtnqV6leqBqFdw
OulaQj2DpVH3JNSLUA91VtT/Cei/APUAS2R70r6sHrR6m+rBq/euHqdsU09H
vRzZqFwnK+HaQTnPGGwpDjt2KydU7nlX0v8FKAddJ1uS9j312NUrVQ9NvTP1
TJvEXGOottAb/X9p+odq
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6204995429372554, 0.6186322969987493, 0.9107908405498403], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXe4VNXVxuf2O7ff6XNnrh0VIxCUpphYUSkKikYpYgdULLHXLwoYjYKi
YkHsiCS22HtBqsaCSjRoYqGYWKIoKioqfu+Pd/Hkj/OcPfvssnZbe613rb1n
86NOPvCkykQi0bM+kajS+6X2ROKXpkTiiOpEon8+kfguk0gcU5FInJdMJBr0
/FSbSKSaE4lL9X60JpGY3JhIXKe8Vyh8ZY3f41VOqS6RyCvNH/R7hNKkk/7+
fJXfpKnPKm8xkZiv3wmFpxVd5nrlu0fv8/TcpWe2nieVZEpbInF5m9N/L7r6
FxKJWQqPVfkvNSQSDyucivfnSr+rynxTZWZV3kOq/0E9baL1M+W9WPFXUZfe
i7MOb69vKb33UN6FSvtSjX+/p7bsqXd/9cP8XCLxeCqR6K00Vyjfk+VE4iyV
/6b66ws9X6kzD9TvnxVuUvps0mXvrvCCCsd3Ud4R6ufVCq9R+jWip5/aMlPp
eqnPv9Dvg5V2L/XzYQ0u93nGoZRIDFCaAYr/uMH5LyRvh8ZF4bPUD8NrTfd/
RPPPte7DJerzg/W+UGUuEf3viv45Cdf3ttIcKhqW6v13PQsU/kR5P9Vzrr6f
pPKnpBOJzVXGePXV8Xp2Uz3/VbuO0fd5Kmeu4koF/56tPpyg90sJ1085zBn6
/ZMos5doOKdoGp/X87mer0XbFxG+OOE+fz/6nXwf68lUu6xPInyPaKhK+tsn
eif07QilP7AlkfiN6jtR4aHV7rNz9Xme2jJWfThQv29Vnlv0DFV4imhJi/5D
FN611nFni55l6qdblX64fq9K+vujKueGlOOOVF+NqHZ5f1L8Yo3pEIVvUPhk
5R+s8NWQpbx3ip7T9Hu05u8oPcPUhzvrOTX6sLbW9D6n8Bqln6P0J+n3IpX/
sZ6D1P+rFf++0o2u8RjQz4Rf07d/K83eeh/Uqr5TeEuFT1V7F4n+D/V7kNp6
tvIeJLouVni+wmP0XFvp+EP03kPxhyt8QsJ9eUKt23iJaBmhcE55k/XOd7iS
fKp+/qTFeepavQ7hCyvivVx5N9HcvER9O7HW9ZwTdY0XfRcr/E/StPv79yr/
EOZjrdcgc/oyheuVdiZrucN5ZmvNzSm7/v9T/D9V/pGKv6LR7/1UZjfRM1nr
5I1ajwNvxmKoythfz8v63V1pLlGaN5mnsQbWVngMiWMcWRPEXwb/Uf/MU3jn
GvfBguiHP7W5vGEqY72+HUffwgdE/9EKD1f4QtF5T9m/k6r3StE6jbVa7Xd3
tXGQ1tlVSveJaOivchYrflCl5+pVCt8Ya+o/sY4+1LxdoWeuyvpeffhdu9f+
Z0FbD4XP1Jz5iLWn39OoV09O8fWKq9Pztsp6i/Ue6VsUbtLTjz5I+r1djdv+
Za3pekHr93mtgV4Jz9lPk56352q+/Zj1XJyaNu+Ab9ytcfqLngx9U+f52IN9
QGnOVJrfKLyF5umWenbQeGymd536qrvC97Lv1HveDWp3/0PDr0XD7Lx5xHJ9
m6pnc8Xvpf7YW09efXK+6ryAt56ynq7sRaLzz6rzG+Xvot9Z7XUZPZXKf029
4w5OOD/hgp6Bmi9VBee/GX4Lv6OvVEaT4g8UDV/VerygrU15f6X3EJWzUmVO
q3cfLlFbnq91mW8Fv2Ve3a4yd1eZmyj+9aTLHqz4Hiq/a4fbCF+EP9JvvFdH
+G71wVfq8+kK52q977Ln5iN8j+ZST33bJvjq9gpvpfAkhbtFeI3S3KX+3lzj
8ZsKx3WJeOYCc6Knwq+qHV0V/kbhh+rNL+AV60TjhXn/5vu2kaZ3m/kOPOdS
jd1+Cg+B52rvOjLpb9s2OG6g0lwQ9UIjZWwT5RC3ddDDWvylzut0M7Wzu+hY
rfRL2dM6NYf0+1HRMkR997Xin1b853p2EZ17K65P0fv8lk1+w2fWqbycwj/U
eW9hr2JPebvd5b2kcr5RH5/ZaTqGKO4BvfcQDU/o/Tj0qZz5jR5XxjStuZul
nArz2t3rzDOog/jdKvzORZoHQjZhXe+gfttO6aarnIHqnwOT/n2T3iOU5kmF
G0MWYx9EXoIv/DNhuWl9hOlX+vxLld8Q65px3LPV87Ih1jnxzE/KWB8yw1/r
3EbmVbPeV7Afsyc2Oky+T0PGgOYrFZ4WfUKdQ6Pe/YOG00XPjlVOR5q5CjfG
/KH8xqCN8n4K+uFJnwVfWhY8qnuNedtnwXuZm82RtznmKrTdpznwvcbsFtVz
X6SBfvJ9unH/qjVfJJzXOs7kvb/eqfeyrGUPeN5Xsa77ac7covb/U7/vVR/e
Xu/0yKDEHVPpdbltrM23NO+OLFvG+ofK+7zs8i6OfaRXhflOFfxBeXsn/Zsw
84pxJnx+0uG0ypyv9wI9Zyac74lIw7cnYh5+HnIV631YnfOwN41udPx+qveA
KIfv7AX/qHPf8mZP+Fbl/az3+li/yB8vKpyPfmM86DvSL4u8G3+Tt1Fl/qvO
cj51zg16XojwQaLnq0bTRlvG1nkdIqexJgizLg6o8JphvRD3Y8Sz/qEPuWtc
xFPGuIiH5m2DT24TzxdBw2h4iZ5RQQs0/U7raEy9w9C2dYPpR+bn/V6Et200
P34v8tMnD1aath+C/hejfPqKMWGc4BF3Jb1XvR1z+a3oN/SHkYq/VzScIB41
Ife/dT4i5kMP8ea/aV8cpt+vq+CTc+Yry/Q+O2e+vb/SHK/woUozR3xuYs57
2auah2tT7md4EHspMsz2+v5/nd5fF4nnLGzz/Buh8vfPeRyREZgf0Em+hsg7
J+nfrJ1/xByiXVOV7996Tq+3HHqy3guQ9RT3x5x/n6K8+9e7z7cWzfdqXexX
b/4Bb4U/DK92HDLULzEPGXNoXNDm/iSOb+gsCZWdUVkFpVmutdaWtv7VqPco
fdtdZa2qdt/crHemxX2JnjtcfH4n2qnwiWr7yJz56mXVzsfa6q24QR3uD2Qe
9Is2ff9ZtHdTHWdUeE0jJ8ErkNeuDpltluh5Rumu1e9rNA7TU9ZP66r8u0bv
q/W+Ss9OCk+udjxpGtr9jXhkvIkpy3mkJf6xBsvmF6Usn0+Lco6scB5+99N7
it5TUx4LxoUwOsLANqch/eUppztf9d7Z5N+ESUf4uwrXMzHqmhrp+d4umq5N
uU0fKnyGwheKtnP1Pk/PaNV5Z8q/eynNgW2OP77C73MjfG30D+Xw5vcilTNH
9Jyj8OWiJ6XyT4p48p0TeanzTD2XKPyL+PldnU73ucKzFT5R4eXtTvNhyMu0
B53jRYUnpKzDTWxwWZTT2O589DNpwEeYM6R9McLrmxxGX5ivds3T04J8kvLv
hHjGFgpvnvLcrWx0PGmW6v2mnn4KD6x2GP0FmXRRrMfetU7XL/aLhTH/eShv
oeIfRfdR+Ci9P2i0njks6l0YdaF3Eo98CI4CnsIaqVD5KxW+rMLYCt96iIbH
RMMKhR/Ve3mbwyMr//f7djXtWXRIhZ+J93VtXoPj2vybcFo03KjwcIVPEM0z
2qxvEZ9K+feEOqfh+9V6X9XmvZu4mZGXOL6xju8OGqBn65T7Z0fRMKnV/d9T
8YOinD1DP76mzToy+BbjyLi90+r4far8nh7hP2u9XqB1+1/xiRPES9+RjL6H
+vNhzaXn0p4jzKUV7Z4nt2l+3a5nE3hts+O/1XtsynHMgXXq20Ep69Qz9B6c
Ms+B3k1TpnlAm+PPr/A6uyjWO/rT96HfbaZyX1M4ofSHtDs8s9rfSAtmxRw/
I+Y5dEArOv2ZsQagmd98BzOhzkFR77p20wPNfRTeC7yr3c+eCq9Xml4qs5/C
s5Ss3Ox45GTmb5eU5zDtYs4z9xZEmPHhvUXEj9B7JOlF/xltDoOV8R4V8ZS9
V5QPnUOi3/Zuc3hA5BsRed+pcRjdmT6k3+BXZ7a5TOph/Y2NNjJ3ma99Eu7L
JdGfyP7oANUKz0qZf8G7zo0wfKfc7m/E76N5MkfzpKgyeyk8JeO1fkLK/AJe
cbrm1b6aV/dqPG+p9rcNe1CNcSXaNUrf90173e+pcu5SOblGj88NMX94z4j0
0HNj0PBxjcPw28GRZlDQOiv4JzyOeutVzoIWGKr6o8XrkPV4psrJ613Q06x+
61rp34SLEQ/PYY4wV5i3zHH6k/Zu3uw+ZJ7S9z9E/09udX7yUgbh0yr9m/KR
XZEvPg8ZY7zo+bHdYwOG8EOsA+r8MerlG78ZO+Yq4/VS8I106n9tIgwPocxx
wZfQkUcFP4RXEgajO0B9v6/W8m76finzotayH+sLfLVH9Bt9tmPo2eje6NpP
tJsXMXa/VTtakNESfrdGGCyWssFjE+3GHMEb0fH611rve0Nlv97i38vFp9bW
O91A0ba3aOtba7r6Bm1TNa+uLDvfI42un/0CfA3atqw0Dp4POmkrYdrL3s2e
yn7a2W48DixuhyrPb8Izq7z+WfusB/oarPt9jfFghd9rdlzviN+22eWyj8+K
dcLcu7HKdTBXd9M8P138tFhr2W1g1uPyhuSs1zscD/3FoBn9frec1+VifT9Z
eetqjR1C841Bb2fQDF4EbehZ4KykBWvdUnX9VmUtV9ydrC89/wdmo/qPUB+u
rTHfRa7agEdWOo4xYi3Bx+GTj4qGx/Tco/F5Ru9n9TyscDfsAkWnO0x17d9p
TPMazf/L6o0B/SQ58+ucw9PA10uWF6+LfZN9dZXy/0XvGVW2GzxSa9vBVk3+
Dt/6VvV8p2dpo+0k4I93J7wHQDv4xg/N3uPZ33dQ/Uv17RjF/0F0/qVszPSq
RtdFnbPUjjv13NhkXHIFWFaFMcsHG/z7umr3H1gN5f09yoTvvhP2jv+o/MYO
4wwXNRjjBidk//kw9qN+DcZLofumRmPOxHdX/IV15meLVMYpRec/uNo07l9h
Psd35lJOfVtqdhuYi4w9cjj7Rp/gCU+rPeMUHqXxHNviMPsX7/ERv5PqXdVm
+0bPZuORe1V532D/YD/iG/IS9o7VqneSwgfCi1pcDmUfpWeswke2GHOd2G7c
dSk6SOwv8KKJwcfYx4nHHoSseyx8s8LvsRGmrGNjHWFTol76ee8a0/ZJ8Lfj
2lwXMvbwNu8FB0UYrJX3gRHu3eQw8jPy0uCQu0hDnuXVLm988Ez47viQr+CN
YN9gC5dFeM+g5Yygh/45I+iE3snRV6QjP7yrT/BZysGmhW2MfqK8ywJbn9Jq
ubQp9KxBsa6hc2S720j/jYg+RCZBd0IHatK7Wc/LlZbnif+bwk82+NtNVY7j
G3I+cgU6IXsre1hT5EU2OCTkrmrWlMJVzZ4vH4X8DB+F71VXWaeknKOrzedJ
f5TCX6ot69rcN/D0RMTTT+ui3yiXeHgOc21VlI+9ZXq7sQ7e17Zb9x+W9N6z
UVcgzN6ELYP9nr2e/feBdstgYHJgsuBy/avcLvqNPedPMYfRaRaHXoP8Rl72
6sfUrlvbPe/GBR3QwN5zWbvLYG+kfDBIyiMeO/K4KJ/w4/UeO+YYc4YyWV/Y
dWgXbW1osk6NPDBfPHN22nz+IPGt4WVjBl9oH1hd8Hj2ajMuACaAftwQY/pQ
g/kG/AM7FHYvMCLwIsK08ffqw5PrjMtPTRrXByfDRgMfBH/uJlnssE5jA9gx
rg9bBpgPGBlYEPYceCR5khH3ZcJ47zOVxrIyKmd0p+cGtjJs1ssDP/wi8Krn
2bciL/hiRWCM2M7YF5cnrC99GmXmYr9kr5xSZdwCmYr6oeOxCtvTLq62TQ27
7g5ho0HGoy7SY6e+qNL2nbn6vmOnx7pZ+9XwTmO6T6mMY6tND7gV6ZtDrjst
wqdo7C6o9J5F+RdEW/pojPZvMP5/GnbtTvcl9EI37b4oaawd7L9vyjZOdLcd
W4wt8RveDI8Gz9mlyus4Eeua8NGB3eFzAA55iNL+rtl7Vd8qyzTIMxtk5irv
I8Txjf2Ob2AnVyvvd9rLzuq0fWNMhdMQj7yBnARP3rvBGDeyx50hbyN38514
cK0H1OdzCqZpSLVxcDDwd1uti6J7rmm1frVC/fey6l1Rtl0BOw6yADYRsCRs
ocwFxm1KjDVznDTsj8wLZHnsEcyLIVWeM4vCnpyPuXFQ9PmVqmtKzjZa9s09
Q+8bJVpG6hlfZ7wHDAlcCDlvZvRVfcx1xrdTZSzIe//eJOQx+reAzNnm/JQD
pgR2hM0aewO2Btbfy9VevxnJRFk9naq70Pw/e+kx6FhF+1ywX/w9/CjGKn6z
on8fVO3v0Dgi9lb2lMOVplB0HUtCd4bHM4+Zz39gDivNLar3hGr35d+q3ecX
aHzHVltuB7u8EWxS4UX1Lps9Pau8V+acjn5dXO2+ZY28EOsEPII5C34Cv3us
2roqONiBsV/PVP1r9DzSbDsafG1Ute3YVdWee/iFVEcbc6r3+4LrzWmNPFHv
NQquTL3Uf1qsVdZmH6V/VeXfCsapsndrcxi9EL2U/WJCtcugb3or/Uslf6Ps
W2P9fy3ZbA0ycLSNN3yDfmG+grez7yVirwQbAY+gb8H3wDnREbBhM1c/q7SN
aMcIjwk/F/r3aq2dLbNeI+CC7aGzsH8x/sz5aeIbh9UZ40cX7BP6O3ZD1gNr
AbsUcutGG2j3mMMHRV8SZo13i/jKmN/MbfSauuCl2Em7RTmjwx5QE5guGC5h
eBXYE/yql/pwYcl7xgSNVbJoeRNbGfI0dL2l78v0rGs2Pk1/gw88rj6eIf5z
X2BX7M3gV+w9lIf/zBKV9VqD5+UY1XVcznMXnAZ+Ag13tFr/xCeINrEX0Bb2
H2gGc/6ZNij8b+QZlfNtwfIJ+zW8kvm5OPBx5vb9deZx8DfWS8/gP+DK4Mvw
0HtVRrOe+VXm+9h/2Ye3F5/olrd/GAzpvbx59RLReY7a8m7SfjD4w4DJP6U2
3dzp3+wPr9R7X56p+P/mjAMsF80f5G2XxBdrab31J+QLZBfW3FtK+7aeefXe
E3nTF/iI3RM+RU/FXGeeL9GaWlNvX5ILNQ8PyHu/Pkh1Laef9e1lvT/IWaYa
XmcZAvnhIcU15q2X3dzqPYh2YfN9KOy+XfX9zbRt2Q/iR5Gz38a9dba1s0dg
k/kp7DIlpS/n7f9Up7WzKOm8c1P2UcM/DTsqPnvYUkvhW7BGab4q2Q9sTsJr
BdrZC7D/Lwtb0icqs3/Sul0l9eSNy+QKtpVi93wHnb1ov4nJWpeTlOawpDEF
/J1S6rdladuToBk8ZO+ksZB1Sn9/3mt5ld59c7YZbt9ifgov5fefk97DwbXx
wYL3dlf6HnoySWMatVHnaqXZJ8ofqO+fpW2jwW8DH0V8P+5K2zaMjsNePjFp
OyH2rHvDpvWuaOksmg705Z2jH7C5nxd2d3wVkFGQT75otN8bPm+naOxW5jwv
0YPx/0P3weeROY5/5D0t9qkCE2PO3h7z9uNG9yU2O+xM2AuxqTEPoA9b2+Fg
Blnb/l5T+LWS5yjty0T52DFvSdqWSVrshaTHD2Vp0r4pyN2sZ9byArCxov19
/qP+SXTYtj2p2XY49hv0FDAofOO+E/1f11u3GKTyb8hY3/wxb1wDTAPsZETS
GMQPSnN2xrj9DkWvVdqLHDklaV1kV8W/nbbPxgvgsppjr+rbqyrvNT0z4QNK
d03StgL8PviOz8/z+j4372/YD0mL7wJ4CO3AdxQ7HnZ0ZEzW4iM5r8frRdd1
Gfsm3ZszD4L/bN/k9YIfzgzFVeTtP4BfH/s3eze2hUGhLyO7LWu1jHpYs32X
+jRZD90p5EzscvBEfp+hOrcsWvdhLIaHrn1qhWXZ6bGH7hy89AzVf2beet5V
YQOBjsUqY1rOc4+0/SM9+lz/kIeZB9hckVmQi3cJ2ZhvO0dd/XJeh6y5u9T3
tdg59G0fjcmLObd9TJ33V/a6bRW/s9IfrvgtFO6Ztw/P9mn7DaPfTW815rUk
xmlq+Orgt/hLvX0X8c35PGf/HHx9t0163PAl+Cjsy+/nTR+0gZHiDwMumlV8
Lu+y4KEPBt/+b9rrn7VfoX5OdZqHnsOekHf+NVprBySNPaAr06/oy2tZ9ylj
Wes1bx9R+kvD74Y3tvg3VP4PRWN5YFv40uA/s0uTeRQ+omBa8EL8APsr/dC8
9TKwO/INSHi+46vEnEe+R/9E95yttt6Vc3+B+9N/+IzRtqrYD2el7fuFzHx+
8H+wPub4TeEv8qna/seieRB8BN8DxgF/1Ypq+07g51hbbf2X98hq68S1qv+H
Dvt04buEzw2+A8iqA0Jexf6LLRl5Hpwd+Q0Z6+fww6D8r1qNd6BjItuCN4E7
wRsODXwVfAxMAkwJfB0bJBj71FavS8LgTuvCFkDb8KtgLWM36Bp6K3LuRjkU
Xzz4L3TWRptoI3ZD1jDrdyfpVf3LxiRmN9nmDTaFbIIOhHwCHz0leCnrtl+s
5T83GacDl8OPGoz4kApjDz+Hr0JT6BasOeyK2BeRBZm7rHPWHfoh5Rwfuia0
Idtnmu1Dhrw0NMo/O3Chbo2eV+jTXUO/7pMy76FcMOiHmizjXaQ5PDFvv1Nw
XmzM2Obwfb65zuVim0LuB+vpG+2DhoebXQ66ALLPRl9a9jxkX2TowzTH2krW
y8Apjw3ME76OXAtvZ9/AH4J29FX64RnrDz3bzH/gczsqvG+D1zd6L1htY6V1
P3go+C087+bge8hyYEbgErsEn6M/0TXLYV+Y0WSZGvkcnyhkZeRksKkNvnGV
9v95Pnx+8DXBV5f07G9vBn6G3RtbM3ZvfLnWxnggf4Md4c8MlsfcQS9G3gSr
R+YcElgN9hdkQfytoAF8p2fo8mA3a2O9oBMzD78L+wtvsAX8pOBVYKQl9d9t
Jetn+L+g26AvHxr45MzYs8fEOGKfYN6PDBrAtfAFOkU85KBO/8YXbH7Qhz4x
POhcE7oU8uGYCKPX8KDvPBZpXgz9h++HRfoFgZ9RF/a4GWHfx55/Y9j8qYM6
8UlD3wDXxIdqsmhL5VzW8CiHtMuqTQf1wytPDqwPW8QFMSfLylfuMP7AHGeu
44cD77k5wvQtest3gf+QFowCOQn/PLDl8RnLi+zv8yIeHkg+8AqwiwcijO7D
+/4IM9/x22bO49uIHI8MDy23Bg3MIeiBb5DulliPyDn0DVghfov4L24sgzB7
8co4FwLGkW12HtIjyx4Xcx3/EPBaeCMy2lNZy2nYXcGCwQPui3IpHz9+xuCE
0AEJMxb41uHfNjbGGMzoscAYwZ7QAT8OnRDMA514TKy767TWKpvtS9K12foz
etaMsGVjTwPbB3MENwCbIAxPAzsHiwcjBevaaA98UmU90WS7DHgHfA694Hi1
8ehOzxF02WWhg5e0Vsol109bwKzxIUT/AFNABwHDHhdt5D0+0kxqsI6OzaeX
+u+kgu1Qi/HPabJNF7+b41qso+ALCl4CjoR9NRs21meCp2Fj+gmf97LlHcaM
NQEPwE43IfAWMBLsYNj68VXAlwh/it8F5gSugr/hATFGp4m2wZ3Wdzf49rR6
3zwg+Au85afAfcEzft9kfPYD+JPoOblov7ZF6o/RJccvhbfnbec6NfYaMBB0
O+yp6HfY67BzQic2PPYl5OoK0dNU8nku/ITxq0ZvQj+jz9DRkoFBMJfqgqcQ
xjaI7xh+KWAZh0Sb4bXs4+D2+ExuxLTwr6wMH8uugT0zf8CQWOfgsdidsD9h
N8O/FCye/sPGyT4B35/bYD0HrKO76N8177aBje3aZhwAbPHgwBu7Jq1fzA48
mTkPXsSaZj9nXQ8M/yP2dXw8wL3oqy80vo82G9/BXoK9hb17RPi8DIqx4/wS
45vUWNwvnjZMv/+i8L5Fn09ArkOm26Bfczar6PMHR+l9TNFnjKAVmtELsEuA
c0En8iSyJLgKvpbICOyB3UNORFZ/Nmu9Dp0On0fSI1cvyRoLAAdgr2O+0Of4
4wwOnxzOXcFHoH9FszElfm+wi9XYvsY+NTz2qk1F79iCaWVfZq5vwA+r3W76
48akZXl4VqX64YqS5VH8jpBt8HkA40FOpR9HhX8RtjX4GZg7/K1Wed8tOA8+
DNiMKWd3xc/LWY7ER5X5Bx345COvMBeb4aUdlpWf1PuJDp8DY26OCLn6PsXd
2+Hxo230K/zwvmb3NW3GVjwubG3gEPBt+DeYO7g6WORs/M6KPuuwt9J1xlmW
n+rtQwKWh66wXd76wh1KvybnsyTo++j66Bf4hSFr4xeAvzY+u+hYq/C1UB+u
bLJfP/sN/vPXhp8MPga/Uj8t0LM+6XFFDrqgwjrHZjFPwGnwiQarmRe6AjY7
sJNrwucAPAnbC+H7Gozv0f/rwl6MDPW0aD8pb3zv/UbbtPDPATeaHf40SWwi
WesJyMDwM/jSh+Jdx5Y8X8Am0Q/Ymz5X/G4F86s3wf8L5i3oCew18AtsjfB+
5gh64Ub/mglJ62v0A/ZP7KDoKuip8DvW/oOxB0IDttoNdroan4s6MdZL99gX
wSpZB0MCX50uer7LxzlT0Xl0yWsEP6eXQvc5W20d2mlMhbMa6Jzom8zZ/qHj
YCu/NOzvWzV4P8e2hG8k/nisj6dVTkXOviPsJ5vGnrJdg2UwZEswg51Dnp4Y
tn5kBvwqwJJnhI63NvaVq5PeK9kzL9E8/VPR5wy6BHYLhoA+gJzFmdbnQ45D
3gMv2SV0Fnw5zg2/tWuVvkej5exXWqxzwD+R2ZHnwRmwM+bDl+zTZsuIyK3f
tFhmR2cBU0ceJA/2HuwnyIoVwUtYp/eHHAd9rMkDY70if50QMhXrfOP6RqZn
zuCH0DN0F/gq/GlolEu/bha+hdjA8a8DE0bvYCzAGbB9YLsAb+e9OMKPN1lW
wr8InsoeDV/l++FNTjNVc+HKTvs0MMd2bbJfDTLGs02WPbB349ODPXCB1vjC
Dn/7Cj+9DmOhh/LucP6ji14nrBH8LaY1ej5MUtz6gv0ZsLUid6E7QxcyBGuP
vfHpqHeiypuk59Sw/Z4SaR4NmQ2+gT71WOgjCdVbUfT57e2wu3W6rZ2aq3eX
faYT2wTfkemwAeKHxD52etF+YPh1zU+5bbRrHmfKiz6rs0OL7cTojfhB41ON
3+nQFu+N85T+Oa2/Z/OeyzfofX3e6350znIVMtV7Co/K2HZaXTBmCl66XOEV
BftF7a18A/KWCz7M2V4OxvmK4l7Oe++CbtKyB9epvPeV9/4G+4shcyBvcPaE
OGzELUrzmdI8rt/Xt3iMkSE574y/FDIiMik+Usil7CeMxayE/R7Ih28/diPs
4uB+fH8mxus8je9/C/aHAZ98LNIzt8AvyPNr1XNzg3EtZO+nYhxfUJ3zOvyb
uXBqjHVPtWOR2nOb8r2m70v0vKhvN7ZYbkb+O65o7BLccgfVv1jPtapjnOJe
0bNA8cPyPsOPDI1vXN8m6033iW/c2mhcl/Px5MPGhz9g76znA/VQ560VTntb
pP88aZkeeZ7z8k/EmXl8pfHp3ih38mZNPcu5m6L91ziryHwEN+D7RZEGuREf
TWTH11vtf4kc8o7yvVt0HeCC2I/RU9i38dcn/DRYYsHfHtF7/5LpY19kf6Sc
s9UPZ+W9L+E78GDac4Nz1Tdk7f8I9oYNdYOtX3X+S89TjcbYnmw0Nkj/9Yk+
zGCrKtonlnn0VPje9Y40YHSs1ydjrBco7cKi+5LxQ/fBl/Ui0fLXom21xC2O
PmeOrYh5uDLC4DmrmvybMLYw/BbBWvGdmNfocj5qsN0Xm+87WZ/ZhiddmTfu
CeZ5veJXln3m8pui/SAp62r1yTUFzwv8KKhr3yrryofFPKGeuVEXbe0dfYLc
3juwuKT40GrVMVxlTFC9J+Stu4zBxpW3LAN2whlg8BP8Yk5Ke72zV49Je7/G
j/jorMccv93RWcsWuypcU7S9Fl/UTbLGMPopvCJlf2T8Rs/KegzxwXktZbxr
ZKfPSGNj2EbhI3K2e6D/HZo2v7q+ZDmVvetmhed2eCwLCudL9tE+Tu/xJdt5
hpRsk0bXfUXhl0vWUebq/XzJ8ns1e06H7V1dFLeVnt6Kv6pk/YQ98BuFvy7Z
B6FrybYZ7DLPKPxkybL2vJJ9cGnviwovLnkP37xsTH+DbUB1pTPW/dkTfi54
X/hAaTbNen/iPOXbWZ+p/EjhY8vmkc+Vbd/Fpsv9HFOz1hcXKDysw+tgftl+
t/CV91T2vwqWSfG1+VvWeHyZc95FYy1FdJ2U+W676D07bZ+Uh8q2fYL1j4e2
vO2R+NVyNwGY60zRX1kyDoINvzVjfowdG3kXWfeOTvN6+PWsTu+FtBc844SM
sQz8pLjTAV8pziJ/m7UN/EvVVdPhexfwTds+Y/kXf6W1Wds5OefXJ2f/+j8q
XK12vdpgWZQ38mjvsmU45DfwiR8zxig2UdyOBa/LGsUfpfhu6udfVOf6DkAb
8Zyc7abYTA/N2L+NsdtC/fFRxrbTkZwxFz2XK+9tSvt62nbQo3I+34i/wyqF
f5/xWXPGs0fWY8ree2ba++8NzFv4oOp9W+FdsJcr/G/R8lGHecxy1fth3rb8
j/TeKWd7+4qczyJyDvEblf+Ryt9Da/wWpXlD4dOQ/dXeazO2q3+U87lKzg1+
rzTPpXw3zJGczU9bR7xO8QfnfX63RnQNy9luvFJx/8pbN7pD79vzvo8hzTng
lPVs0g6N9PvkfEadc+mbMIczllPaFb5N4d1aLMNwdgY9ZAx8jnsJGlx/Q9Y0
1Cr9qznbdyvL9nlC/h2k8EUd3qt/UhtfyPo899GMadly99/Vn2+U7KdzYNk2
JOxHKZXfnrfeeTpyUc525pVF82L48BU5n//E52WK8h6h+NdUZoXCo1VOF+4K
UXg77ttR+B3RXqP4uznDyLnVnH0EalVPTd42h+dF73MdlouvztofER74qurt
i/+66q1X2rq8Mfv7Vf5Exa9V+Xso3+56tgZPV11rC96rsWf9o9E2LbAfMCB0
is2UdnM9lezljb5vBRslvhO/hC2Y+xi4e4IzwMStj3iwkTVhm8OvDP4KDs+Z
0cFxbhRMGt84sOb9Sua58Fvu79kp7vBBx0HOQMZgv/ltg/fbJ9Pm+/D8yxXe
VHm7KfyA+mGrnH2mzm+1vyx699Yqb7uczxjjP0s8fBL5B9kHuRef4pXh6z5R
ZXaWLOf/ojJzHbaJsD9SJ/LANurbFRnfD8C8qQzMYJOc73lBDvkofJVpFzoy
/v3oyYNzvkcDX4yNd8SADeKfi30H+RMbO/Zm8G3iOiMevZ89B91/K30/smC5
hbjVEY8swzfisZ2BiaO7odei36Jvsmds0HUrbZPDNoeey5lIzkz+IfRczhGg
6xL3YcQzh7o02W6LXyT0YSe7omybN/buc/ROl5y/j8K/L3j86qLf6fMzFXdW
wbrMPg2We8AnWRuZsPdVct9Ih+vHBpiJtowMmyC4NPhlOuKR03rGOQX0HMLo
aEXR9teM70/AtjYw7Gv44+G/Ds5Z0+wwuO21YdPCTnqRxuKotHFRcFToRF5i
jPcJmifoe73a29js+7TWx51aR+R99gOc4mj8SUrW9bAnrwubMjZMbJnYNLfP
xh4ZdgLepGdPrQna2GM4t4mt7f5mtwcsjvF5P8YIrIgwtjbuBtsl7gejHT92
uC3sW5RFOfggDw0/ZMpeH+XTH1VR76VFrwfWAvsNecAR5hd8twh+C7/u8J1W
/wkbGvcagB3Bi7lfBmwaHgcmAh6yTYN1PM4+oNOnQvcHswG74S4L9Ah84MhT
VP+dn/YZBMazS4fHFKxt69AT0Ym4kwKe1aPFtg7sLOi03cJ3F7lzm6j3grTL
pcyuodvAA/GpxEYDHwAz2z1wM+4n2ynuKKN9a6KNp6jdNTnzVHRrzi2jX8Mn
enSYV0AHZYLtI0+TH5vgpQX70uFHt/HuNsKk7Ro0nFe0TDwszhWyZqGZvY0z
QtjuusC7OvwbfrdZo+8rANPBlgru9IC+P6jnribvx9zjAF6J3f+uSIP9lvTY
cJmf3Rtty1hSsF6KTvqM2rVdh/PDS25qMm/h/jPsJRtsJTXGFug3fF24qws9
dzb1dzgPZ4mJZ3/hDr2LG41d4CP2x0b7cV3R6XGivfh3TY40We6SKjoPPm6j
isYYsdVj++cugs3SlvOQ7cDSaA9rjX334fANoK2zo+3YErjzCN+zy8Mfgv5g
Pl7d5DmJXL5r0LxIbR1RdB+dqvdpevZtNNY2I/ZT7ETEnRo4HjZo/IWwpd8d
OBJ+FH9psq1kSot/41Nxoso7Sc9egXeDe+O7yF5AHP36sPrykQ7np7x7ovy7
RdugovOw35Qj736K27/o+cFdbuAaYBr4LOCDgZ2de+Bezvg7679bzAGwyB7R
h4fkjCODE6Arzgn6ketnlCzb4zu2SdTL9z9HmnuUZnDR37hT6t6Mafy94t7L
uK/gU/Qh9gLmwuSYD/i/bDiTnTCuj50HbB+5kPCQhH2BuPMKXB4s9KGYD/j9
Ep6T8P1Vt2Qs18zJ+U4rwjOZmx0e73VK82PRclJK8+2OosudVfSZSc5LcmcV
9gZsDZxPAW8D+wbvx5cRnP9o7gUsGO9iz18Z+/6vWry/49exVeyt4NL4lG2T
9ji+r3prO5ynzLkfha9SunMVzpUsG4DNkx98Hjn+45jD+PCwL+HHQ9lbxd6N
zYK7n8BDSPtJ0Dmg6DtTyAtecn5gJpzlZl3gf7W5vm9R9N2L7FOPBk77EHeY
FI23PxHxzO3t0tbzN/pkvxZ7Fv7slIEtEZkLjBVehy6xJNJylhq7L+epz8rY
XxD/QNoNZkfbjy34LAQ+AANKpgMaOoo+C0H54ExHBdbEXZvJsJvskfcdmuyP
YPLofOxxffO+jxI+vzAwMuwQ9Nv5Ma/Aso6KNbTh7rRG83zkurGB1+L7xxyh
z6eq3iuwRzYaN2EMsQMNAR9Lm7dtF/Yq5jM4DtgQ9gPwgg+a7Y+R7fC8ZE7+
o2Q/GOzlnPF9P9Jgw9tw/rPS8ZwT5PcazqJqLH7XagweLB4Z+9fY8kquY63k
pW/Lvh+rLeMzGJy/wA+KN2sHv5uOqHeI6Pln3n66B7e6bPzhOIfBORB8Ex6N
/NgjFrX43Dj4P36j2IbBWrEhs3eDT85V/bdn7T+yLM4EgdniO/ZO+Jfy8A27
CVjj6yEn4GfV1Oq8u0Qa8iJHkAYsEUxxSYQ5c3xH1hgI9d8XNCBD8BvbLmdz
Do52wUNmxfkB3vymT26JdtLGLlE+YwdWeF/IJKPVrptKllGv0pgvLDvMOZti
xnZxzvN1yflMH77m6DPoMhOwT6btx8e9Gpwfxj+C8yt9w5cM/eaCVus4+Q7r
qOin3N/xadxRuU2H9wD4PzbbpoztOsxFfPLBIaGbMHLaw2mvK9YUZ8cOjfg9
aUfJv7urnm07XTf5Dok0+ORWdXrfh+/SV+y5G/bomEv4x/272XYqznvg/8EZ
T/pjaZw/gp/+EOeT+rPWFf9ds8eEsQELrVL802EHf0HvHTMuE38k0mDfoox1
4V+CfHtkq+V/9KRxrfYfmq+8C0qmibrpY3wVcmpHvtPp6H+wAe4PeTfve5HQ
bYn7LuLrFZfudB30CWuZvsWfE78U/HyuaPVvwqyJhS22kcEfsbNvOD/UZrs7
fn3YJHtGeITm7CVl52Fcsd1iS8U+i18TNsEdIy/loSvsGGHwiFdbvL/wXhL2
RdKSBv0IezQ+q5zDzUcYmZA3v/FlvbjVdXHOgrhCxOMLy++N6b+KcjYPWyu2
Y3yNFwUfeEHtmFf2ugVP5G5QbFx/VdzFWfsR76y5enPW51TqSj6nx74G/a9E
W7iTmTtY4cHo3OtanPcBlfNg2b+/bbHvPvbRtfEb2YA5iazA+kWOokzsra9E
X9E/nMdlHXE25JvISzncaYqPKb4jxH0TZYLfc08xex1nj8DiweHB4wljD2Dv
xj+cPQIf4GnRn/g7E4/PCTzv3eBj2FEXxDzBFwe7IzYs+nl1jBH5pkeZ2K+v
DL/iSXH3KeVPibnXI+z//Maey341PfzVGduLw0cOf93Xwz9naYvPORNHGVeE
j3KzxuWMtMeBs85/inPQu8bZOuwdnOPj7Cv65j5t9m3DtsJ7QITxn+E3vjGc
+SMP/k70//Q4Ez0pfCU4VzIq0mHXJt8+4S+Hj/vSoBN5hPKRVXJg7GX7kuCr
3CvKR6/tE2cM+0S9hOGtu4XvEzadXaMtxO0eYdpLn4CBgJVzbzX2lsnh102f
YydgHjAH4P2jg/+Dj2AXBOPiru7fhr2P+z+4HwSfP+594R4ZfCKWqJ8PK7sc
7oThLA3naLZvtf6A7vCyyikXjLmgM3KmaON9PsidyJzcz3B0pMd3Gh8cbFXM
MWz2yAdgjvgvIuutUnkrC7arn6/3eQXzFWi7O2i4VnHTC577e4nGAXpO1bfd
c/b5A0tHbsJXENnppw7ftQH+uE7fdyn722YF46FgoZMVnlTw+DCnxoWvGPcH
US9zj4e+YT5j80D/R+euKPmOEvSinQu+jxL/5d4F35dKf7AOGRfaznmU00PO
xK92uxbjxq8VfO8V9tEHMsaVwB+uK/lObc4TTCv5jnJ8vj7N+V5y8Ez81Lhv
F/0S/3ZkHnjLwDg7g2/c4AgjC3F3wdbhr8K5735x9huZbevwncAf6s6MZVG+
kw766RfGknVKXJ+I7xNpkJvGRx9iQ5+A/JmxLrkyY3wTvAL/sXSLfcguzdnH
Hf/2VMnnKsEGd+Ie2YIx4Crlqy67v8CRuFuQM5vYDPA/AJPjHO6WLT6j8IvK
SZT9G5/5o2Ie8sZXBn18lco/t2CsDRyD+MtjHXEGnj5ZLVr6lj2Pd9Be3Kts
LAJMiXkHnnKAxv+dlO8uHabvB+i5sMW+7dx9jUzFWcbVZWMvnJvgO2cnThad
p+i5tNm4Wr9WY2tDlTafdZqdFV5Vdn+i34DNsc++o7h39WylPKP03iLr9QlG
z73bb4Y9n7NSYMzYIPGNwwfnRNV5Usn0YQPgLm/OHuDPwj0vYLTwgFeCD/CN
u77xJQQjHRU46jPcDY5M2eozyvj24de3WmV/WfIY03fwDvp/H8Xtq2d0s/+L
AB9WdNUN+mCL9R/KHh3l42v2Qdr+RGAJ9BN+Evj/0278IllbjBnj9WPIYMh4
CzmjVLaPD/62/CZ8n+o9tGDcZbLCk4r+/4RtlGbbkuU0sLyRgQN3T/sOSvZc
+uOatPvk7IL9obEbct/5wqxt6GDGI4P+45ExS+670aqno2B/IvwW6zP2Z9qS
sSv7Tv0tOnzvBvL5SKX/NO12o1/Tx+jv+GMijyKL/j+i2xMC
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnm8z9X2xj/nOPOAzncejgwpZCihuShjKSI/MxkKmRIR6V7RnLnQpUmF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7057350489054575, 0.7555820380578514, 0.9127339475569689], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXeYVUUSxR+T5828mXk5zWDCiLtiXtE1J0ygrrprFowogjlHFLOomHMC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmgm8luPWxp/d3u9uz3u333nYzQOVIzSgSKc0KqVMqZAGzRGV6dNEhhQN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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7880818437123851, 0.8554851782163343, 0.9026290448241829], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mUVNW1xqvpqXruqurqrqquEkWcAmjee4lGBCUOOCEIMjhFSZaaaBgU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHmcz+UWx7/MDLPPmN/8fvPbBslWobr3lmylTWkIg0m031KqsVOJbOHO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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.864629113096601, 0.8810116528817475, 0.8683359367365598], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUVdWVhm8N1Fyv6k01vPtKBgVEWjHadguJSogmNkpUlpIIWW0EIgKK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll3eQldUZxg/s3X7Zhf3uvXv3ltBBdAJGY8LioFRFigrJGAEnqBgxoCxt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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGmMldUZx9+7zH7vnRnuzDDcO4BgAyJqP9kPbREBNekSE0uIGpQamhpT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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEls1VUUxk95nV7T98D+30Df7ROoLqw1sNKFCihFF+rKhWKYTA2KWoog
pQOUwkKLgQImxrgw0CgmDMaJBYGggZ1CIjGxYKLEGTAsNI474u/LtzjJufec
8535LOjf+PjgrIh4DmqExmsR+SxioD3iReipFPEkdCUXsakQ8WA54vmuiIPF
iENF636C/HLBNmPw26D9vG+CNwQ/DGYCfC9/V0sRd2C/AtvfkD86N+JfMA63
RVShm8iXIN+AfA141UpEVz1icHbES9CdyHqg4zljLKhbR7It0Fp8rZVPfD2M
/Q5kn0FHWyO6w9ib0Fndbh/PwPdDYy0Rz6IzA7+YeF4l3ovojIP1Cn/zeb8B
5kr4J/gbgO9DvhL/Q+SwC/nCORGjyIeRTyHv4u88/t6nZu81RzyNj9vRT8Sz
Df71PH7Q/ysz9jB4v2fGFFYF+1vh61Ap5xr8h3w3Nco1OadJ7Nv5a2qIGMF+
J+8JaB62G9VD/E+hn0d/mnxHiO0P9A8U3KMNyN8mnluwfxf5F8geQP8Y9uPC
hz9A/GPN9jlDrn+j0418fatnYVnZ2JqJ3cjOVJ1blZiv4O9b6Aj6Dcg78ZWI
byjvmqv33yXLNAPytZS/qUb7HAC/r+zY3oE2Y3tb1bOjHo7VXHPVej3vrcKG
9pBbv+YXrEPY7212TkvJ5wwxHGl1TPfBr0ie7U7+rsI/hE4RX+3QZbCWgHGW
+nwF3te87+f9Ae8vefeqF5l9TYJ3F73az18btXqNfo2Cd6yD+oZr/gvvDvTn
YJ8Hf6LiGdVsqmd/ItueHItm7mf4ZSXrtkKLSu6ReqMa1bDdXvHsaqY+hW8h
385G59iI7sdgXML3OmJcTHwtmXfzAvFdT+6ZeqWcp6ntJO9Kzj06CVYvNpOz
PUPCFoZs5WMefHfduzeK/9MdroFy7w3n+kKXb4VyPo79/Lp1tRP7yGcQ+eGi
a9ZXcs7KtQ1aWHIPVPtvyOHD5Jqr1jMFz752SLujHVhe9sxoVoSp29SWeRd0
o37k/ROUK3qndNs+SsbSjVOtmjLPkmr2CPN+Itm3Zl61+TU5NtXoB/jvoXyD
MYv43pJ86+4t+vaN1Fx73cA1yD7PvKu6UTt5TyTX6k3ed8Pfk3x7deOmyedg
2bdDM6xenKLGPeGe6BadyzyLuknLS55hzW4B+gfZjmTstwrejUs13zbtyCzk
L9d8a2+EZ3VVzbdNM7sV26OZd1037UaHb6xuq2LQbuxKxtaO6JZcS/atm1JE
/thc33bVSLvTU/Jt0w79D8100K8=
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4866, 6771, 7578, 5374, 7230, 6769, 6770, 5923, 5350, 7208, 
         7210, 7209, 6709, 6965, 6966, 6782, 6781, 4873, 7090, 4874, 6784, 
         6783, 5105, 5759, 5758, 5822, 5111, 5256, 7526, 5255, 5520, 4927, 
         7489, 5167, 5065, 5184, 4953, 5535, 7535, 5536, 5534, 7370, 5548, 
         7369, 5547, 7456, 5656, 7455, 7458, 7457, 5655, 7452, 7454, 7453, 
         6047, 4998, 7137, 7138, 7134, 7136, 7135, 4879, 6402, 4878, 6220, 
         6219, 5110, 7132, 7133, 7131, 5183, 5820, 5821, 5383, 7485, 4871, 
         5971, 4872, 7034, 7035, 7032, 5104, 7033, 4778, 6748, 6747, 6998, 
         5057, 7574, 6868, 4924, 5161, 6395, 7027, 5103, 7515, 6261, 6867}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4925, 6869, 6870, 6773, 6774, 4867, 5163, 7087, 7088, 6999, 
         7001, 7000, 5691, 7036, 5106, 6788, 6789, 7037, 5107, 6790, 4876, 
         6791, 7575, 5064, 7006, 7007, 6751, 4843, 4786, 5823, 4793, 7467, 
         5559, 5261, 7275, 5442, 7273, 5441, 7274, 4882, 7140, 5186, 7139, 
         5187, 7141, 4999, 6048, 5588, 6683, 5657, 6184, 6754, 6755, 5756, 
         5658, 7459, 5659, 7460, 5651, 6076, 5000, 7144, 5189, 7142, 5188, 
         7143, 5788, 7277, 5443, 7276, 5444, 7278, 5262, 5263, 7468, 4794, 
         5824, 5761, 7039, 7040, 7038, 5109, 7041, 4926, 6871, 5166, 7091, 
         6218, 6217, 5108, 6357, 5033, 7030, 7031, 6777, 6778, 4869, 7089, 
         4868, 6776, 6775, 7029, 7028, 7182}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1, 6629, 6631, 6630, 4991, 6418, 6419, 6417, 6768, 6767, 
         4865, 7551, 7552, 7482, 6356, 6353, 6355, 6354, 5757, 7409, 7410, 
         6663, 5599, 6664, 5381, 5970, 6780, 6216, 5382, 6545, 5034, 6967, 
         6968, 6296, 7553, 7555, 7554, 4877, 6792, 6611, 6612, 7216, 7215, 
         5351, 6127, 4788, 5790, 6718, 6717, 6132, 5264, 6555, 5390, 6554, 
         5389, 5631, 7500, 4955, 6013, 4956, 7501, 5492, 6795, 6794, 5115, 
         7042, 5283, 7186, 7043, 7044, 6796, 6797, 4885, 5493, 7532, 5494, 
         5266, 5561, 7469, 4796, 4846, 5612, 7429, 7431, 7430, 5445, 7281, 
         7282, 7279, 5446, 7280, 4883, 6223, 6222, 7513, 5035, 6297, 6182, 
         6183, 6716, 6524, 5352, 6525, 5257, 6128, 6129, 4790, 5785, 6439, 
         6335, 6336, 6334, 7003, 5060, 7002, 6436, 5246, 5778, 5059, 5924, 
         5058, 5777, 6119}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4782, 7383, 5557, 7382, 5558, 7384, 5378, 7240, 5380, 7238, 
         5379, 7239, 5864, 5784, 6125, 6124, 6123, 5253, 7213, 7214, 6752, 
         6753, 4844, 4787, 6553, 5387, 6552, 5388, 5926, 5925, 6526, 6527, 
         6300, 5037, 6299, 5036, 6359, 5114, 6225, 6226, 7285, 7286, 6875, 
         6876, 6877, 6002, 6874, 6873, 6872, 5613, 7432, 5704, 5705, 6726, 
         6725, 5566, 5878, 5877, 4960, 7505, 5499, 6807, 6806, 7050, 7049, 
         7188, 7047, 7048, 6804, 6805, 5498, 7504, 4959, 6015, 5497, 7441, 
         5635, 7440, 5634, 5828, 5113, 5451, 7490, 4928, 6001, 4929, 7491, 
         5452, 6613, 6224, 5112, 6358, 6131, 6298, 6971, 6970, 6969, 6221, 
         6793, 4881, 5975, 5976, 5604, 6665, 5603, 7411, 5760, 6547, 6548, 
         6441, 5249, 6440, 5250, 5782, 5781, 4781, 4841, 6178, 6177, 6331, 
         6330, 6437}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4838, 4864, 5628, 7438, 5629, 7439, 5484, 7323, 5486, 7321, 
         5485, 7322, 4920, 7160, 5200, 7159, 7162, 7161, 5158, 7083, 5157, 
         7084, 4839, 7086, 5159, 7085, 5160, 7165, 7166, 7163, 5201, 7164, 
         4921, 5489, 7328, 5490, 7329, 5487, 7327, 5488, 7324, 7326, 7325, 
         5843, 5844}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4917, 6860, 5154, 7079, 5153, 7129, 5181, 6892, 6893, 6894, 
         5219, 6897, 6896, 6895, 5182, 7130, 5735, 5736, 5198, 7157, 5199, 
         7158, 5152, 7077, 5151, 7078, 4835, 7481, 5343, 5342, 5483, 7531, 
         5482, 5530, 5433, 7529, 5434, 5432, 7425, 7426, 7422, 7424, 7423}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4779, 7379, 5556, 7378, 7381, 7380, 5375, 7234, 7235, 7231, 
         7233, 7232, 7330, 6546, 4784, 6121, 6120, 5247, 5698, 4842, 4785, 
         6122, 5786, 5066, 5972, 5699, 6448, 6449, 6447, 5258, 5791, 5071, 
         6453, 5267, 7183, 7184, 6757, 6756, 4847, 4797, 5692, 5392, 6798, 
         6799, 6800, 5928, 6530, 6307, 6308, 6305, 5039, 6306, 5120, 7192, 
         5294, 7191, 5293, 5882, 4934, 6883, 6882, 5458, 7293, 5079, 7145, 
         5190, 6903, 6904, 6360, 5119, 7053, 5118, 6614, 5456, 7287, 7289, 
         7288, 5455, 7291, 7292, 7290, 5457, 4890, 6673, 6674, 6672, 6676, 
         6675, 5636, 5742, 5741, 6561, 6459, 6460, 6458, 5279, 6461, 5265, 
         5872, 6134, 6133, 5560, 6648, 5070, 7008, 7009, 6446, 6445, 6549, 
         7243, 4789}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4780, 6710, 6711, 6329, 6333, 6332, 6438, 5779, 5780, 6036, 
         6035, 5063, 5783, 5251, 6442, 5252, 6443, 5067, 5974, 5700, 5701, 
         6130, 4792, 5795, 6724, 6723, 6138, 5273, 6559, 6560, 6557, 5391, 
         6558, 7571, 5038, 6972, 6973, 6302, 7556, 6301, 7557, 4888, 6802, 
         6803, 6403, 7576, 5075, 7010, 5076, 5693, 4802, 5830, 4807, 7472, 
         5568, 5300, 7296, 5460, 7294, 5459, 7295, 4893, 6412, 5193, 6411, 
         5194, 6413, 6942, 5001, 5931, 6639, 5549, 6638, 5550, 6640, 6962, 
         6294, 5551, 6641, 6282, 6283, 6681, 6680, 5002, 7570, 6415, 7569, 
         6416, 6414, 5195, 7150, 5803, 7298, 5461, 7297, 5462, 7299, 5301, 
         5302, 7473, 4808, 5831, 5763, 7052, 5116, 7051, 5117, 7095, 7096, 
         7092, 7094, 7093, 4889, 6227, 6228, 6304, 6974, 6303, 6185, 6186, 
         6727, 6528, 5353, 6529, 5276, 6141, 6142, 6143, 5796, 5870, 5871, 
         5789, 5069, 5927, 5068, 6444, 5254, 6126, 6715, 6181, 6180, 6179, 
         6338, 6337, 4783, 6750, 6749, 7211, 7212, 6215, 7483, 6214, 7484, 
         4870, 6779, 5524, 7354, 5525, 6622, 6950, 6422, 5210, 6420, 5209, 
         6421, 5228}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4840, 6746, 6213, 6212, 6211, 5373, 5966, 5965, 4922, 6327, 
         6328, 6997, 6996, 5056, 7573, 6394, 5150, 7074, 7076, 7075, 4951, 
         5918, 7401, 7402, 7400, 7404, 7403, 5149, 6494, 6495, 6493, 7195, 
         7194, 5913, 4968, 6274, 5647, 6922, 6923, 4980, 6073, 4979, 7445, 
         5648, 7444, 5649, 6064, 6063, 6067, 6065, 6066, 5671, 6691, 5670, 
         6692, 6074, 6054, 4973, 6278, 6277, 5644, 6273, 4967, 6020, 4966, 
         6918, 6917, 7348, 7347, 5148, 7205, 7206, 7204, 5340, 5917, 4950, 
         6890, 6891, 7026, 7025, 6766, 6207, 7588, 6206, 6326, 6995, 6994, 
         6993, 6258, 6259, 4919, 5999, 6000, 5437, 6606, 5436, 6607, 6609, 
         6608}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5920, 5817, 6518, 6519, 6517, 5344, 6520, 6859, 6858, 7271, 
         7270, 6175, 6325, 5055, 6992, 6991, 6253, 6616, 5476, 7498, 4949, 
         5914, 5335, 5584, 7479, 4832, 5840, 4827, 7478, 5325, 5324, 5511, 
         5750, 6085, 6086, 5993, 5992, 6057, 5991, 4978, 6921, 6408, 5177, 
         6407, 5176, 5718, 5717, 5582, 7539, 5581, 5907, 4965, 7506, 5510, 
         6621, 6502, 5334, 6501, 7200, 7199, 4862, 4831, 6173, 5430, 6256, 
         6856, 6857, 5963, 5964, 7318, 7319, 7317, 5481, 7320, 4990, 6938, 
         5529, 7355, 7437, 7436}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4836, 6176, 5721, 5720, 5994, 5102, 6509, 6510, 6508, 5338, 
         7201, 5909, 5910, 5336, 6174, 6596, 6597, 5425, 6598, 4828, 5697, 
         5372, 7229, 5371, 5956, 4914, 7344, 7345, 7343, 5509, 7346, 5508, 
         6019, 6916, 6915, 5640, 7443, 5138, 6389, 6391, 6390, 4944, 5898, 
         7361, 7362, 7360, 5537, 7363, 5008, 6945, 5538, 7364, 6736, 6985, 
         5049, 7514, 6944, 7175, 5007, 5238, 7525, 5239, 5237, 6435, 5236, 
         7174, 5837, 4901, 6685, 5660, 6684, 5661, 6084, 6083, 5029, 5662, 
         6686, 6279, 5528, 6628, 6266, 6265, 5526, 6624, 6626, 6625, 6627, 
         5527, 7395, 5579, 7394, 5578, 6043, 5012, 7171, 7172, 7170, 5215, 
         6424, 6423, 7064, 6248, 6276, 6275, 4971, 6022, 4972, 6920, 6919, 
         5519, 5772, 5771, 7173, 5218, 6911, 6910, 6909, 5196, 5730, 4911, 
         7114, 5173, 7113, 7116, 7115, 5137, 7066, 5136, 7067, 7154, 7153, 
         5839, 4826, 7477, 5322, 5906, 5905, 4945, 7496, 5475, 5369, 7528, 
         5370, 7228, 6540, 6163, 5323, 6490, 5098, 7023, 7024, 6352, 6351, 
         6503, 6604, 6605, 5431}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1HlM13Ucx/EPla40TVFQAi00M1ltBdq5qZWKebVSV6aUYq3SBLYCqWjz
yKNFiZZaJIkY0Dpmy1qlgWhqh0ipZYJdWLalNo9sRpr2+Pzx/L0+7/v9+f5+
3196bv7deQkhhEYfa7qHcGtKCFX0RHIIx9E1LYRK9mD+oRiCvd1C+LBHCGPE
x+KCniFsTQxhvNjHcs/QzUkhXH5pCOkol/sqEpCt9gs1X6KRvSP61ST2CqE9
X5v8fzGHv0SPN81/hlbTWtQgXY99covxJOrl1uF5/stSQyi1zwiajZF4h90J
CWqnmNWZ7xIkm9kD/Z2vwgBs0qcBSfqWiHWnP7vPFXpP02M1Xy6dy17H/16M
yelj5wn6j0c/dn95U+lOvZpQhiVYq+4tetydOsg5QTvSfHsdkL8ACzGLPZH/
Bfl5zqU0k2bzjXJeqm4ZGviy+Jo8/0Z1R93hGJbgPLEX6fl0I/0Un+Ba9gba
W58H1GzS5xs75TsXoB2S4vfgbqdxZ7ynmhR3W0f7iV2JjHhPOlZ8HJr1aMEg
/lH8ozEG+/lO8VWjBhnsAdht/g3qluvZxh4iN1t8BK7nf5n/FP8/qHe/VXEG
WrASF9p7Bb2IHkCh59BKu+g7RY/HnUfz3cs+zG62fwty3H17zKHb6B18ozDX
/HmYjz/kH8IcO9zIvgk3o0LPernfie3Fo+Kp+qRhnl696Hx61m+kzOxztIae
oWtphvzX6X/sJ/QbptdwPMdejDlq73Lfo3zH0E7OT2a2p4GWuW8CvdicTiiU
XydvCX+IMRTpMxvFmGHedPNm0gVyN+r9LE20+wS+VvoDfsRkdpFYCZ1Nr6E5
aq+mHdmT5fxi9td6zHR+DGfZH7CXYwUmogNfpn2vw0D7lKqv1GcNstiZeE3t
EaxBFV5RtxK7zGkTr9PjNPsM/hIvj799/lo6jI7A8GhjnvhJz+BgfKfM/J3e
ry4HafqV893jWdzmed2OYahht0cz2uk5iX6v12S1I9UUqi3CfeyFek+ii+iO
+H8QnwM6Ybw75cn/KL4/9DO9t2IzsvTdQvvyD5bXW483nN+We9K5iO9vWiDv
V70WYTFy2F3UdUWx/E3mrrdbqx0PYDoexENR43sploZUVMpfxv8SMvE5BmIQ
9niHas0casZUdd31T8JTapLp0/SIvFI5f9JqeohW0c7yDzs/THPZj9Aa+e/G
99MdivnaovIf1H+c2Iz4/8zuE58BlvJti//BWMWuQIPvZjO2xO9I7rT4vsbd
MMW5Gz1t731YLb9nfH9oCt1Dv8Uu3MLeTXfasQnrUW/e+7SOfuXZDLRfHnu7
WQXs/WryaV/79ME5M1qxwd4VZm+kee43K/4O4n88Paimlv5G/wch5BG7
         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5539, 7356, 5531, 6866, 6865, 6864, 5440, 6260, 4923, 5967, 
         5968, 5439, 6610, 5438, 7272, 5919, 5816, 6514, 6515, 6513, 5341, 
         6516, 6855, 6255, 5429, 6603, 6172, 6324, 6990, 6989, 6988, 6252, 
         6409, 7561, 4915, 7126, 5180, 7125, 7128, 7127, 5147, 7072, 5146, 
         7073, 7156, 7155, 5838, 7118, 5174, 7117, 5175, 5203, 7519, 5202, 
         6886, 6885, 6884, 7120, 7119, 7261, 7372, 5011, 6949, 6948, 5243, 
         5774, 5773, 5862, 5242, 5627, 7545, 5626, 6062, 5010, 5411, 7488, 
         4907, 6839, 7577, 5135, 7065, 6382, 6383, 7565, 7567, 7566, 4989, 
         6937, 4988, 6936, 6935, 5217, 5851, 5850, 6429, 5221, 6430, 6195, 
         6293, 6292, 5025, 6433, 6434, 6426, 5222, 6432, 6431, 6246, 6372, 
         6371, 6580, 7371, 4985, 6931, 6930, 5214, 5737, 4939, 5860, 5233, 
         5623, 7543, 5622, 6060, 5006, 5235, 7524, 5234, 7110, 5172, 7109, 
         7112, 7111, 4977, 6072, 4976, 7508, 5646, 6156, 4813, 4854, 7433, 
         5615, 6671, 5616, 6008, 6007, 4937, 7494, 5468, 6235, 6234, 5127, 
         6366, 5040, 6311, 5041, 6312, 6532, 6531, 5932, 5933, 5398, 6570, 
         5397, 6571, 4803, 4849, 6758, 6759, 7190, 7189, 5290, 6474, 5077, 
         5799, 5277, 6456, 5278, 6457, 6188, 6187, 6340, 6339, 4795, 4845, 
         5869}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4805, 5800, 5881, 7413, 7414, 6667, 5607, 5984, 5983, 6812, 
         6811, 6232, 6573, 6572, 5042, 6981, 5043, 6313, 6404, 7558, 4896, 
         5169, 7103, 7104, 7011, 5085, 7012, 5311, 7056, 5128, 6828, 6829, 
         6830, 5129, 7057, 5087, 7013, 5088, 7014, 5314, 7062, 5132, 6840, 
         6841, 6842, 5133, 7063, 5091, 7020, 7022, 7021, 7393, 5895, 5896, 
         5507, 7341, 5506, 7342, 4909, 7421, 4910, 6845, 6844, 5418, 7263, 
         5050, 5775, 5141, 6392, 5142, 6393, 5051, 6164, 6740}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV01tMzmEcwPHnRd2YC0RRLuqCJsJmIRtiKDPRDZGm2BBjDpvDRQ4bNw5z
47C1mUNM2CjUHCax1dgIm2POhs15eXGh8PlffH3/z+/0HLyll68sWhELIWT4
516fEA4mh5CO1v4h3MFtjBVflRJCTu8QlsktxyexHnLdBoTQFXv6htDSL4Sl
qMASPElSz62cpCfZjL5o1Rv0fjBvsvgUXNB/Ht1913GxvmZ9c7iFy9NCWIgF
yNJfxg96hZBr3hiMRru6UfpzcN78c6hDhvp56m/yKP6mLoe/8ki1tWrO4gzS
1cyVa+bV7tXCf51hGz6p384fuUhNslwhz8JM3HKeOB6Kf7F+xJlmZLtPptlD
uav9ukRn9F0pN4TfWGfxH9Safdj6CDqtOzAjeg/rx96rxndw1yb7fEdv+1Tr
mehcx/gI97LvdPGevA4z7DNfb6UZpVxovV78ru9D5k31vUZ9Pq/lfebsR7a6
Rns0qbmOPLF29/iBOILaf6ney5xdei9a7+Yd6gbrbdB7Q981HmZ9Se6A3DSu
sC7gJL1BzUbrGF8WazPnCk+wRx4m4ph7HUc1jiLmDY6bNcl3Fcf1nuB86xou
iH5/Zpe4c6HcTCToaXaWX3K/8RNxdBevV/uMn+MpEs1o40rnqHGeTXySB3CJ
+HyUYoT5GXqrnfEoOvAH5WJb5LZii55TejfzaR4ot9e7LcFSLMYyVOCVfIKe
RJRFbxn95nknD9KXK57J9fa4gJiegIViXbgq+k2pX6T+qnwjxukZj+zo/8h9
h/IlfoY2NOKFd+nnPim47+6zvVenWLH+OegvXqJuXvR3YK8C8z5zg7o036l4
hdfIFXvPY/gdv4ziZm7QO1JsuHnD8EZskHO+5Y1yu7EL/wF9Rqul
         "]],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5586, 6657, 5587, 6659, 6658, 4834, 7480, 6523, 6210, 6209, 
         6208, 5101, 6499, 6500, 6498, 5333, 7198, 5903, 5904, 5331, 6171, 
         6592, 6593, 6595, 6594, 4825, 6737, 6205, 6204, 6203, 5368, 5954, 
         5953, 6853, 6852, 6851, 5423, 7269, 7397, 7396, 7226, 7227, 7225, 
         5367, 5947, 4908, 7310, 7311, 7309, 5474, 6010, 6009, 4940, 6267, 
         6268, 6247, 6405, 7487, 4906, 6406, 4905, 5729, 5576, 6097, 5747, 
         5748, 6679, 6678, 6655, 6536, 6537, 6535, 7221, 7220, 5938, 6822, 
         6821, 6239, 5407, 7391, 5573, 6734, 6735, 5593, 7540, 5592, 6052, 
         6053, 5680, 6697, 5679, 6698, 5308, 6108, 6115, 5687, 6116, 5688, 
         6110, 6109, 5888, 5804, 5805, 5935, 5934, 5082, 6476, 5292, 6147, 
         6729, 5707, 5706, 6475, 5291, 6146, 6728}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5303, 5887, 4851, 4809, 6733, 6342, 5084, 6192, 6193, 6484, 
         5310, 6660, 5309, 7256, 7257, 6823, 6824, 6825, 5939, 6827, 6826, 
         6240, 5408, 6581, 5047, 5769, 5609, 6102, 5610, 6056, 5412, 5989, 
         5414, 6103, 5413, 5988, 5770, 7262, 5415, 6582, 5416, 6583, 5366, 
         5948, 6843, 6249, 5417, 6584, 5317, 5811, 5093, 5955, 5094, 7398, 
         7399, 6738, 6739, 5902, 5321, 6497, 5332, 6496, 7197, 7196}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6880, 5454, 5726, 4887, 5854, 4886, 5725, 5453, 7493, 4931, 
         6003, 4930, 7492, 5614, 6670, 6190, 6189, 6309, 6977, 6976, 6975, 
         6229, 6230, 4891, 5978, 5979, 5396, 6568, 5395, 6569, 5764, 6574, 
         4811, 6152, 6151, 5305, 5713, 4853, 6154, 6153, 5806, 5086, 5985, 
         5714, 6486, 6487, 6485, 5313, 5807, 5089, 5941, 5090, 5808, 5315, 
         7367, 7368, 6958, 6959, 5020, 5944, 5021, 6289, 5897, 5316, 6682, 
         6159, 5809, 5092, 5990, 5715, 5716, 6160, 4823, 5814, 6742, 6741, 
         6165, 5326, 6589, 6590, 6587, 5424, 6588, 7572, 5052, 6987, 6319, 
         6321, 7562, 6320, 7563, 4916, 5480, 7314, 7316, 7315, 5477, 5479, 
         7580, 5478, 5841, 5641, 7547, 5642, 5512, 6021, 4969, 7082, 5156, 
         7080, 5155, 7081, 4837, 5842, 7350, 7351, 7349, 5514, 7352, 5513, 
         5516, 7533, 5515, 5962, 5959, 5960, 5427, 6600, 5426, 6601, 6743, 
         4829, 4860, 5596, 7406, 5597, 7465, 5683, 6702, 5682, 5912, 5911, 
         6707, 6708, 6701, 6700, 6348, 6347, 5681, 6699, 5320, 6089, 6090, 
         5901, 5900, 5952, 5949, 5015, 6954, 6285, 5542, 6635, 5580, 6539, 
         5365, 6538, 5364, 5945, 5363, 6634, 5541, 6632, 5540, 6633, 4818, 
         6765, 6764, 6763, 5361, 7224, 5360, 6643, 5553, 6642, 5552, 5695, 
         5694, 7219, 5357, 7217, 5356, 7218, 5936, 5016, 6955, 6288, 6637, 
         6636, 6653, 5892, 5032, 6964, 6963, 5555, 6295, 5031, 6033, 6034, 
         5666, 7461, 5665, 7462, 5886, 5802, 6481, 5298, 6480, 5299, 6482, 
         6809, 6808, 7246, 7245, 7388, 5880, 4961, 6902, 6901, 7332, 7331, 
         6801, 7045, 7046, 6879, 6878, 4932, 6004, 4933, 6881, 6880}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5849, 4856, 4816, 6374, 6375, 6373, 6377, 6376, 4941, 6269, 
         6270, 6198, 6199, 4857, 4820, 6385, 6386, 6384, 6388, 6387, 4943, 
         6011, 6272, 6271}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7301, 5464, 7300, 5463, 6341, 5083, 6315, 5045, 6314, 5044, 
         7419, 7420, 6816, 6817, 6818, 5986, 5987, 5401, 6577, 5400, 6578, 
         5619, 7305, 5469, 7304, 5470, 7306, 5402, 7255, 5404, 7253, 5403, 
         7254, 5471, 7059, 5130, 7058, 5131, 7060, 7451, 7511, 7512, 6960, 
         6961, 5023, 6082, 5022, 6027, 6028, 6099, 6098, 5751, 5672, 7534, 
         5532, 6087, 6088, 5731, 4912, 6668, 4913, 7560, 6250, 7559, 6251, 
         6318, 6986, 6317, 6161, 6162, 5143, 5329, 7527, 5328, 5523, 4946, 
         7497, 5178, 5732, 5733, 5197, 6345, 5096, 6344, 5097, 6346, 6887, 
         4947, 6012, 4948, 6889, 6888, 7313, 7312, 5734, 6044, 6045, 5673, 
         5749, 4964, 6070, 6025, 7449, 7450, 7448, 5654, 6024, 6023, 6287, 
         6286, 5863, 5245, 6104, 5755, 5546, 5026, 6029, 6030, 5545, 7536, 
         5544, 4822, 4858, 5595, 5594, 6100, 6101, 5754, 5013, 6081, 5014, 
         7374, 7375, 7373, 7377, 7376, 5554, 5664, 7549, 5663, 7181, 7177, 
         7178, 7176, 7180, 7179, 5048, 6158, 6367, 7476, 4817, 6368, 4815, 
         4855, 6762, 6761, 6957, 6956, 5017, 7366, 5543, 7510, 5019, 6026, 
         5018, 7390, 5572, 7389, 5571, 5639, 7537, 5570, 7418, 5608, 7415, 
         7417, 7416, 4895, 7101, 7102, 6815, 6814, 6813, 5124, 7148, 7149, 
         6410, 7147, 7146, 5829, 5847, 4850, 6760, 6191, 5667, 6687, 5589, 
         6051, 4970, 5643, 5745, 5746, 5205, 7520, 5206, 5192, 7518, 5191, 
         5834, 4812, 7474, 5307, 5306, 7301}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0, 10}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->83743237]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32684],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " may yield a graphic with an extreme aspect ratio:"
}], "ExampleText",
 CellID->19236343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"Exp", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318201230],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWr2LE0EU32Q2m6idX1hccf+IWIiKiIiFWIhFDEJS6MkZG2200UYbbTwQ
rzgV/ChOhBPhBEEQD8QD8eBQmxPkLDwED4uAsL7ZNztvdmf2a5KFJAuZ7M77
vTfvvXnvzewkR5vd9tlzzW6n1Zw8NN280O60Lk4enJqGLlZxHGcCPqt7HLj3
4S74TPg+fKvtDmg9ILHgaTdvXY4MLripBl87oeXdAsbJTkVSmMDxQXkvUnYJ
HiafOM6Vo6ryHDkSarWdt4z0qAe926CtQmfNSN2q6e6WgGtITe3oXH/HI6vR
lyGPZmHrzLOvX34JjaRXns+v3Lr5Nt67vv7n5IlHaq8Y/cjh2c3Nnif7Ax3Y
pe7C0vvvvLOmcczcXXr4YNnT+l8urN64/kbvX/74Y+r8C71/be336VOP9f5e
79+B/ffiGsHN8WNzGxt/VY1q0oOd9vzK559mGhpjpoHGoLeZhoaqNCUOqrP3
Pxi5hP+JJvVHB5nHQicVp0EAQBgIGm9dES8yUggrYgCxnkKTLUaaamVUAlz7
9s4ICXUthk3cLLQeGAOGANpQkInjeuq4OPm23GA3WO9KLynUaJblluIJHzPV
1xE0hqRLsxahwozCvOalVqV+164uvl78Ftwm8GJIJ0lOp0LkQvwqVFel8pjv
n0a2PH3y6c7td2m2YMokaVseFVPOpDNS0nSO80apEBIQGElUTFGkxvLLT4qz
FJ5cUa3yhxVEpDiJwbyN8GGdVnIqnpHa+sakPlgMpD4ym8x8mv4D50/xdSav
tjIEz+AacFAWCitKFBVWFTM1n4xyUbBsw+KdhcIaZoMiD9jLKBdF+6M0FNZa
GxR5wF7GoFDGlS6Tq9AqG3vm6wUrLCWsLnbc6TrIypVZW4hP3WFJloJj132q
a0m+J7RpPotQKepg3wu736xIwTV0NFBk23Doo6OgoEBZyULR/qMoijxgL8MW
hbseQuWrKbgzIa5+8rlsaek7ENr5jKJNxWbJHAH2qKqstLTzqhhlsDFFjYsH
cGqTbDNR88kYFEocTogrXHOTot8sQ89/Ndfy7ABGQS5znJHQM8ecK6fM4UwX
m/F+IhCXThsU5Y29jGFFjbNtOurK5VcpHsCNY5aMMlHhWRBevkjDpDcSs4wg
F7dIFApU25zZa5Qb58p1Jp1PHlOeB6flAKUOoCJq8124IpYdo+VkAx49Z6Hg
BXkIUOSB4dBnXG2L7gADTOapsFmSXWUqLjfltD6frKS3ReM7rDwd0uVofso+
L5PnMSVKU6uZa5Rsns+4HHP82KMo6sseqVwU/lyQjKJ/HHCLGxkYvdep/Aeq
SWXv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{28, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299411925]
}, Open  ]],

Cell[TextData[{
 "Use an explicit ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " to get a reasonable result:"
}], "ExampleText",
 CellID->66799044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"Exp", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "GoldenRatio"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->362891803],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxV1PdT03ccBvAYaBhhh7YgQyJwaASxInt83gVlN7UYVEgZ+SIFq7KqWGqK
SMuIDQQ4RSGWKYKCUTB6MqReEAULSNWivUNGgygWGQ3LAEk/Xo8ffO6ee+71
Dzx0IjEklkwikZi47/fDzCD3lq9bJzaEIco7Z6cAypoPonRh7dgZrTWnoV2d
uiIH4zXz0GC8r45g+5pLEMm4ZvhO7JovI7sFr5vkvjU3I1mq6wzn0izi2sST
Dm99iIRd13KrK2WIeQJsJ1OeION6q5BC0TwKpZccE4v+Qu2SlfGY8UWkaG+d
GXIZQWGb5BaOBXKUKSLPVURL0dl45+Hx3atobxo/V6VnHKkd956t/pIEsTFt
WxJt3qCV4p8PZpqRoUZnp6lRwFt0o+pBsJ9cBYSBao+27ZtBDazowX4nCnAT
zjvNTc4i1bkdk6o56iCv5Fq3/SBDWyvqNWPVqGDhQ45gMeYRun6kNEBdB4bu
ObhT7yygd7yp7uBCPdgpphBFyUvIUr7M9EswAP8btnrm5nLkfF0ovZpqCGNF
igNdV5eRNGZd4AXBJ7BpJJnsE7WKylv6M9iGxqCqU+g7KFMgdjpLY1pkAvee
1k1sDCWBo6PkjuCROYReaZKF2a6DwZgUZacpHbYnGXxlMb8O3Ks7g5TDG0E6
KXnc10eGfNcDt0ZWrWAkrLtWq1QFuKeuWvG22kADM+1uMEcVpDeGfnrL3wzB
8rTVo64fAWXzjk7NWFtwKe7Ps1WhgHtJIv27UHtYen3cu+cFBZI+jirOT/gM
cjq63BLEajBiatlQznYAIj8xu5yrDvkUk/mM/Y6grxe3cDtUA5KyNC8XtzqD
dqa4mWOhCTb2nal8Bzd4dqL+rtYrTTjKaIx6MuQBx2xl/5S3U+HUvgJ3oQZA
dG/Bt5IcLbj2puqcf+PnsMH6pHYvRxviGmXU9SIfYBzpUImz0wGeUWGTuG0X
qHo2eqrM60C1kD9LLPhBU8e0MKdXF8wHJFeSqwJhr5nkUm+QHnCU3pm5sV+A
p1hcGNSsB/VGR3O/Ye8Gqi637KGVPmh2K9+MMkJAyZli6fP0wcCjdDxSgwUR
ejyznnl9EL8oUcj99sLft/oETLYB3F7Oe3GgdD8w6ROWj9sNIISvMHIyY4PV
qy0Puxk0qA0P76PSI8Gixng9T0ADQW3UIa/yaMhut+e2rdDA5VZcs0k6AXyl
1+lu7FTHi4b7sYuAeX4Au6KpJukMdpnksHgGu+P6IkP7JAE371+etFqlQRH5
eZ0Ce6zPMiIP286e3z16igCf4U+9IhU0mPZ5WlaXRYC/hU3wofeOvGnwEpvJ
cQr/Hju4i51DzyYgXMpKLcK2LlhKKcVOeVUouo/d4payh59DQNU0dYO9kgbm
9vGuSTwC6raZ2Hlg10eUNzdgi5IZ7gHYA+QLbhPYLTL/fTHYtNaXXsRpAv5Y
zBKcwxZtbt3N+oWAAZezv17ELttj/qwAezDtYn0jdqi6X2Qv9utlyYPfsU1M
JxJ8+QRMeTz+8zn2jgxiKRN77sdR6Utselpl5m/Y8vaZ2X+xD2pc0l7B/v/H
DEHgkFTikkfAf3cSNa4=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 5.}, {0., 148.4131591025766}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398903346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64357142],

Cell[TextData[{
 "Using an explicit ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " may distort shapes: "
}], "ExampleText",
 CellID->339795846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->825992465],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116791642]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204693763],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmAlsVFUUhoeCoolFVGICBspSAYmIAsUagYPBmKAYKIuiCUogLBI2IawV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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1Gl8CAQYBvDNNrPLsHs228zYfR92JXSJrhEpJZOKakN3SclRuuhQObov
R+VIpwihVKKD7nJ3UBRdCP/9+vB/3s/Ph+fNaGxuaAoMCAg4QbTcVgQRTAit
CaUNYYQTQSRRtCWadrSnAzHEEkc8CSSSRDIdSSGVTqSRTgadyaQLWXSlG9nk
kEse+RRQSBHFlFBKGeVUUEkV3ammhlrqqG/pTQ9OpCe96M1JnMwpnMpp9OF0
+tKPMziTszibc2igPwM4l4EM4jwGcz4XMIQLuYihXMwwGhnOJYzgUi7jckYy
iiu4kqtoopnRjGEsV3MN13Id13MDN3ITNzOOWxjPrdzGBG5nIpOYzBTu4E6m
chd3cw/3ch/TmM79PMCDPMQMHuYRHmUms5jNHB7jcZ7gSZ7iaZ7hWZ7jeV5g
LvOYzwJe5CVeZiGLWMwSXmEpr/Iar/MGb/IWy3ib5azgHVayitW8yxrWso73
eJ/1fMCHfMQGPmYjm/iET/mMz9nMFr7gS77ia77hW77je35gK9vYzg52sovd
/MhP/Mwv7GEvv/Ib+9jP7/zBAQ7yJ3/xN//wL4c4zBH+4yjHaBl/IK0IIpgQ
WhNKG8IIJ4JIomhLNO1oTwdiiCWOeBJIJIlkOpJCKp1II50MOpNJF7LoSjey
ySGXPPIpoJAiiimhlDLKqaCSKrpTTQ211FEf+P/fOw6q4YlT
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, 
       "Tooltip"]& ]}}],
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Frame->True,
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491200763]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " when shape distortion is undesirable: "
}], "ExampleText",
 CellID->462069548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->369893005],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->91225629]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->546465433],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmAlsVFUUhoeCoolFVGICBspSAYmIAsUagYPBmKAYKIuiCUogLBI2IawV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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1Gl8CAQYBvDNNrPLsHs228zYfR92JXSJrhEpJZOKakN3SclRuuhQObov
R+VIpwihVKKD7nJ3UBRdCP/9+vB/3s/Ph+fNaGxuaAoMCAg4QbTcVgQRTAit
CaUNYYQTQSRRtCWadrSnAzHEEkc8CSSSRDIdSSGVTqSRTgadyaQLWXSlG9nk
kEse+RRQSBHFlFBKGeVUUEkV3ammhlrqqG/pTQ9OpCe96M1JnMwpnMpp9OF0
+tKPMziTszibc2igPwM4l4EM4jwGcz4XMIQLuYihXMwwGhnOJYzgUi7jckYy
iiu4kqtoopnRjGEsV3MN13Id13MDN3ITNzOOWxjPrdzGBG5nIpOYzBTu4E6m
chd3cw/3ch/TmM79PMCDPMQMHuYRHmUms5jNHB7jcZ7gSZ7iaZ7hWZ7jeV5g
LvOYzwJe5CVeZiGLWMwSXmEpr/Iar/MGb/IWy3ib5azgHVayitW8yxrWso73
eJ/1fMCHfMQGPmYjm/iET/mMz9nMFr7gS77ia77hW77je35gK9vYzg52sovd
/MhP/Mwv7GEvv/Ib+9jP7/zBAQ7yJ3/xN//wL4c4zBH+4yjHaBl/IK0IIpgQ
WhNKG8IIJ4JIomhLNO1oTwdiiCWOeBJIJIlkOpJCKp1II50MOpNJF7LoSjey
ySGXPPIpoJAiiimhlDLKqaCSKrpTTQ211FEf+P/fOw6q4YlT
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, 
       "Tooltip"]& ]}}],
  Frame->True,
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[4]=",
 CellID->125774234]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5472],

Cell["A collection of boxes with random aspect ratios: ", "ExampleText",
 CellID->47639659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", "=", 
        RowBox[{"ColorData", "[", 
         RowBox[{"14", ",", 
          RowBox[{"RandomInteger", "[", "31", "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Lighter", "[", "c", "]"}], ",", 
          RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "10"}], ",", 
            RowBox[{"3", "/", "2"}]}], "}"}], "]"}]}], ",", 
        RowBox[{"Background", "\[Rule]", "c"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"FrameTicks", "\[Rule]", "False"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "50"}], ",", 
        RowBox[{"PlotRangePadding", "\[Rule]", ".1"}]}], "]"}]}], "]"}], ",", 
    
    RowBox[{"{", "6", "}"}], ",", 
    RowBox[{"{", "6", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65732531],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{340, 387},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184853112]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8709],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxRatios",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoxRatios"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRegion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5485],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Surface Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ThreeDimensionalSurfacePlots"]], "Tutorials",
 CellID->29229],

Cell[TextData[ButtonBox["Two\[Hyphen]Dimensional Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TwoDimensionalGraphicsElements"]], "Tutorials",
 CellID->27560],

Cell[TextData[ButtonBox["Coordinate Systems for Two\[Hyphen]Dimensional \
Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/CoordinateSystemsForTwoDimensionalGraphics"]], "Tutorials",\

 CellID->7718],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->95890638],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->442437776],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->41032738],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->653632452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with AspectRatio",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=AspectRatio"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
AspectRatio"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AspectRatio - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 56.1281968}", "context" -> "System`", 
    "keywords" -> {
     "distortion", "elongation", "plots", "shape", "squashing", "width", 
      "shape of graphics", "shape of plots", "portrait shape", 
      "landscape shape"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AspectRatio is an option for Graphics and related functions which \
specifies the ratio of height to width for a plot. ", 
    "synonyms" -> {"aspect ratio"}, "title" -> "AspectRatio", "type" -> 
    "Symbol", "uri" -> "ref/AspectRatio"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10508, 269, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->165447204]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 377632, 7010}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3422, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4045, 101, 4195, 83, 70, "ObjectNameGrid"],
Cell[8243, 186, 632, 19, 70, "Usage",
 CellID->24161]
}, Open  ]],
Cell[CellGroupData[{
Cell[8912, 210, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9390, 227, 224, 7, 70, "Notes",
 CellID->21197],
Cell[9617, 236, 295, 9, 70, "Notes",
 CellID->8595],
Cell[9915, 247, 556, 17, 70, "Notes",
 CellID->2125]
}, Closed]],
Cell[CellGroupData[{
Cell[10508, 269, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165447204],
Cell[CellGroupData[{
Cell[10893, 283, 147, 5, 70, "ExampleSection",
 CellID->72238496],
Cell[11043, 290, 103, 2, 70, "ExampleText",
 CellID->480601013],
Cell[CellGroupData[{
Cell[11171, 296, 344, 11, 28, "Input",
 CellID->965244531],
Cell[11518, 309, 500, 16, 123, "Output",
 CellID->59876946]
}, Open  ]],
Cell[12033, 328, 124, 3, 70, "ExampleDelimiter",
 CellID->54442601],
Cell[12160, 333, 88, 1, 70, "ExampleText",
 CellID->847152041],
Cell[CellGroupData[{
Cell[12273, 338, 293, 9, 28, "Input",
 CellID->324302993],
Cell[12569, 349, 1966, 36, 83, "Output",
 Evaluatable->False,
 CellID->8749955]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14584, 391, 216, 7, 70, "ExampleSection",
 CellID->28815],
Cell[14803, 400, 241, 7, 70, "ExampleText",
 CellID->288183114],
Cell[CellGroupData[{
Cell[15069, 411, 596, 20, 70, "Input",
 CellID->576816622],
Cell[15668, 433, 3846, 67, 70, "Output",
 Evaluatable->False,
 CellID->80829863]
}, Open  ]],
Cell[19529, 503, 123, 3, 70, "ExampleDelimiter",
 CellID->6456693],
Cell[19655, 508, 118, 3, 70, "ExampleText",
 CellID->899880153],
Cell[CellGroupData[{
Cell[19798, 515, 878, 28, 70, "Input",
 CellID->79540013],
Cell[20679, 545, 4346, 75, 70, "Output",
 Evaluatable->False,
 CellID->19735278]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25074, 626, 239, 7, 70, "ExampleSection",
 CellID->29343],
Cell[25316, 635, 130, 4, 70, "ExampleText",
 CellID->197467626],
Cell[CellGroupData[{
Cell[25471, 643, 379, 12, 70, "Input",
 CellID->32775646],
Cell[25853, 657, 23132, 395, 133, "Output",
 CellID->187818819]
}, Open  ]],
Cell[49000, 1055, 124, 3, 70, "ExampleDelimiter",
 CellID->92177244],
Cell[49127, 1060, 238, 8, 70, "ExampleText",
 CellID->6510802],
Cell[CellGroupData[{
Cell[49390, 1072, 543, 17, 70, "Input",
 CellID->120886374],
Cell[49936, 1091, 43825, 723, 70, "Output",
 Evaluatable->False,
 CellID->668823612]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[93810, 1820, 233, 7, 70, "ExampleSection",
 CellID->14568],
Cell[94046, 1829, 467, 17, 70, "ExampleText",
 CellID->182942527],
Cell[CellGroupData[{
Cell[94538, 1850, 706, 22, 70, "Input",
 CellID->400592340],
Cell[95247, 1874, 347, 13, 133, "Output",
 CellID->167058661]
}, Open  ]],
Cell[95609, 1890, 122, 3, 70, "ExampleDelimiter",
 CellID->759781],
Cell[95734, 1895, 321, 12, 70, "ExampleText",
 CellID->480680334],
Cell[CellGroupData[{
Cell[96080, 1911, 501, 17, 70, "Input",
 CellID->66853089],
Cell[96584, 1930, 262, 9, 120, "Output",
 CellID->405458902]
}, Open  ]],
Cell[96861, 1942, 125, 3, 70, "ExampleDelimiter",
 CellID->127049118],
Cell[96989, 1947, 614, 23, 70, "ExampleText",
 CellID->72621968],
Cell[CellGroupData[{
Cell[97628, 1974, 558, 18, 70, "Input",
 CellID->229282428],
Cell[98189, 1994, 4047, 70, 70, "Output",
 Evaluatable->False,
 CellID->695180696]
}, Open  ]],
Cell[102251, 2067, 125, 3, 70, "ExampleDelimiter",
 CellID->198741895],
Cell[102379, 2072, 489, 18, 70, "ExampleText",
 CellID->515921717],
Cell[CellGroupData[{
Cell[102893, 2094, 411, 14, 70, "Input",
 CellID->717758698],
Cell[103307, 2110, 3278, 58, 70, "Output",
 Evaluatable->False,
 CellID->654002882]
}, Open  ]],
Cell[CellGroupData[{
Cell[106622, 2173, 266, 9, 70, "Input",
 CellID->610868956],
Cell[106891, 2184, 1143, 24, 116, "Output",
 CellID->698597316]
}, Open  ]],
Cell[108049, 2211, 124, 3, 70, "ExampleDelimiter",
 CellID->93197379],
Cell[108176, 2216, 409, 15, 70, "ExampleText",
 CellID->17312459],
Cell[CellGroupData[{
Cell[108610, 2235, 347, 11, 70, "Input",
 CellID->179478673],
Cell[108960, 2248, 30061, 497, 70, "Output",
 Evaluatable->False,
 CellID->772544055]
}, Open  ]],
Cell[CellGroupData[{
Cell[139058, 2750, 347, 11, 70, "Input",
 CellID->124303645],
Cell[139408, 2763, 205976, 3420, 70, "Output",
 CellID->83743237]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[345433, 6189, 226, 7, 70, "ExampleSection",
 CellID->32684],
Cell[345662, 6198, 255, 8, 70, "ExampleText",
 CellID->19236343],
Cell[CellGroupData[{
Cell[345942, 6210, 274, 9, 70, "Input",
 CellID->318201230],
Cell[346219, 6221, 1558, 30, 70, "Output",
 Evaluatable->False,
 CellID->299411925]
}, Open  ]],
Cell[347792, 6254, 231, 8, 70, "ExampleText",
 CellID->66799044],
Cell[CellGroupData[{
Cell[348048, 6266, 359, 11, 70, "Input",
 CellID->362891803],
Cell[348410, 6279, 2085, 43, 137, "Output",
 CellID->398903346]
}, Open  ]],
Cell[350510, 6325, 124, 3, 70, "ExampleDelimiter",
 CellID->64357142],
Cell[350637, 6330, 227, 8, 70, "ExampleText",
 CellID->339795846],
Cell[CellGroupData[{
Cell[350889, 6342, 425, 13, 70, "Input",
 CellID->825992465],
Cell[351317, 6357, 3144, 56, 70, "Output",
 Evaluatable->False,
 CellID->116791642]
}, Open  ]],
Cell[CellGroupData[{
Cell[354498, 6418, 483, 16, 70, "Input",
 CellID->204693763],
Cell[354984, 6436, 4068, 80, 70, "Output",
 CellID->491200763]
}, Open  ]],
Cell[359067, 6519, 227, 8, 70, "ExampleText",
 CellID->462069548],
Cell[CellGroupData[{
Cell[359319, 6531, 408, 12, 70, "Input",
 CellID->369893005],
Cell[359730, 6545, 3574, 63, 70, "Output",
 Evaluatable->False,
 CellID->91225629]
}, Open  ]],
Cell[CellGroupData[{
Cell[363341, 6613, 466, 15, 70, "Input",
 CellID->546465433],
Cell[363810, 6630, 4072, 79, 70, "Output",
 CellID->125774234]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[367931, 6715, 223, 7, 70, "ExampleSection",
 CellID->5472],
Cell[368157, 6724, 91, 1, 70, "ExampleText",
 CellID->47639659],
Cell[CellGroupData[{
Cell[368273, 6729, 1156, 32, 70, "Input",
 CellID->65732531],
Cell[369432, 6763, 2226, 41, 70, "Output",
 Evaluatable->False,
 CellID->184853112]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[371719, 6811, 310, 9, 70, "SeeAlsoSection",
 CellID->8709],
Cell[372032, 6822, 958, 35, 70, "SeeAlso",
 CellID->9662]
}, Open  ]],
Cell[CellGroupData[{
Cell[373027, 6862, 313, 9, 70, "TutorialsSection",
 CellID->5485],
Cell[373343, 6873, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[373484, 6878, 178, 3, 70, "Tutorials",
 CellID->29229],
Cell[373665, 6883, 182, 3, 70, "Tutorials",
 CellID->27560],
Cell[373850, 6888, 214, 6, 70, "Tutorials",
 CellID->7718],
Cell[374067, 6896, 162, 3, 70, "Tutorials",
 CellID->659944600],
Cell[374232, 6901, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[374426, 6909, 318, 9, 70, "MoreAboutSection",
 CellID->95890638],
Cell[374747, 6920, 163, 3, 70, "MoreAbout",
 CellID->442437776],
Cell[374913, 6925, 152, 3, 70, "MoreAbout",
 CellID->41032738],
Cell[375068, 6930, 161, 3, 70, "MoreAbout",
 CellID->653632452]
}, Open  ]],
Cell[CellGroupData[{
Cell[375266, 6938, 305, 8, 70, "RelatedLinksSection"],
Cell[375574, 6948, 367, 12, 70, "RelatedLinks"],
Cell[375944, 6962, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[376348, 6978, 50, 0, 70, "History"],
Cell[376401, 6980, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

