(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29409,        803]
NotebookOptionsPosition[     25130,        667]
NotebookOutlinePosition[     26941,        718]
CellTagsIndexPosition[     26823,        712]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LineIndent" :> 
          Documentation`HelpLookup["paclet:ref/LineIndent"], 
          "ParagraphIndent" :> 
          Documentation`HelpLookup["paclet:ref/ParagraphIndent"], 
          "ShowAutoStyles" :> 
          Documentation`HelpLookup["paclet:ref/ShowAutoStyles"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LineIndent\"\>", 
       2->"\<\"ParagraphIndent\"\>", 
       3->"\<\"ShowAutoStyles\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Automatic Text Styling Features\"\>", 2->"\<\"Stylesheets\"\>",
        3->"\<\"Text Layout Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AutoIndent", "ObjectName",
 CellID->31544],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AutoIndent",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AutoIndent"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies what automatic indentation should be done at the \
beginning of a new line after an explicit return character has been entered. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15370]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["AutoIndent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoIndent"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->13257],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "do no indentation ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "indent the same as the previous line ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
indent according to the structure of the expression (default) \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->88],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"AutoIndent", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", tabs or spaces used for indentation on the previous line are explicitly \
inserted at the beginning of the new line. "
}], "Notes",
 CellID->6129],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"AutoIndent", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", line breaks are always indicated by an ",
 Cell[TextData[ButtonBox["\\[IndentingNewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/IndentingNewLine"]], 
  "InlineCharacterName"],
 " character even if they were originally entered using ",
 Cell[BoxData["\[ReturnIndicator]"], "InlineFormula"],
 " or ",
 Cell[TextData[ButtonBox["\\[NewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NewLine"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->20297],

Cell[TextData[{
 "Indentation after an ",
 Cell[TextData[ButtonBox["\\[IndentingNewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/IndentingNewLine"]], 
  "InlineCharacterName"],
 " is automatically redone every time an expression is displayed. "
}], "Notes",
 CellID->3340],

Cell[TextData[{
 "The amount of indentation after an ",
 Cell[TextData[ButtonBox["\\[IndentingNewLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/IndentingNewLine"]], 
  "InlineCharacterName"],
 " is determined by the settings for the ",
 Cell[BoxData[
  ButtonBox["LineIndent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineIndent"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LineIndentMaxFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineIndentMaxFraction"]], "InlineFormula"],
 " options. "
}], "Notes",
 CellID->19923]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->222885179],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->51488923],

Cell[TextData[{
 "Create a cell with ",
 Cell[BoxData[
  RowBox[{"AutoIndent", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25399047],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"ExpressionCell", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\"\<Input\>\"", ",", 
      RowBox[{"AutoIndent", "\[Rule]", "True"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74562189],

Cell["Type some spaces at the beginning of a line:", "ExampleText",
 CellID->6091626],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVFUcx3Ganjf9Cz3vr+jH05wan1QzJU6i1TSOjQ+aaaYHTfbLbDIV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   "], {{0, 0}, {458, 111}}, {0, 255}],
  ImageSize->{458 0.75, 111 0.75},
  PlotRange->{{0, 458}, {0, 111}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->9974718],

Cell[TextData[{
 "When you press the ",
 Cell[BoxData[
  FormBox[
   DynamicBox[ToBoxes[
     If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
    ImageSizeCache->{36., {0., 8.}}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " key, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " inserts the same indentation in the next line:"
}], "ExampleText",
 CellID->128077075],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlFUcx/Ftum/6F7rvr+jHbU2NN9VMiZNoNY1j00UzzXThZJZWk6ng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   "], {{0, 0}, {458, 111}}, {0, 255}],
  ImageSize->{458 0.75, 111 0.75},
  PlotRange->{{0, 458}, {0, 111}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->470701443],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->786637302],

Cell[TextData[{
 "Create a cell with ",
 Cell[BoxData[
  RowBox[{"AutoIndent", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->507094859],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"ExpressionCell", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\"\<Input\>\"", ",", 
      RowBox[{"AutoIndent", "\[Rule]", "Automatic"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229886874],

Cell[TextData[{
 "Every time you press ",
 Cell[BoxData[
  FormBox[
   DynamicBox[ToBoxes[
     If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
    ImageSizeCache->{36., {0., 8.}}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " in this cell, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " indents according to expression structure:"
}], "ExampleText",
 CellID->134745888],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3V1PXNUex/Ex3hvfgve+Cs/xVqPxRk+ipbG0aozReHEST7wwpz5VjbUt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   "], {{0, 0}, {458, 124}}, {0, 255}],
  ImageSize->{458 0.75, 124 0.75},
  PlotRange->{{0, 458}, {0, 124}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->378972983],

Cell["\<\
As you edit the cell further, the structural indentation shifts \
appropriately:\
\>", "ExampleText",
 CellID->32007479],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtzVdUdB/B0+t7xX+h7/4peXnXa8aXtTAWngNZxHDs+dMaZPjhVW6md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   "], {{0, 0}, {458, 152}}, {0, 255}],
  ImageSize->{458 0.75, 152 0.75},
  PlotRange->{{0, 458}, {0, 152}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->375923099]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27500],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LineIndent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineIndent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParagraphIndent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParagraphIndent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowAutoStyles",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowAutoStyles"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27901],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->783034695],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->105496655],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->474051779],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->14100470]
}, Open  ]],

Cell["New in 3  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AutoIndent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 7.6441166}", "context" -> "System`", 
    "keywords" -> {"indentation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AutoIndent is an option for Style and Cell which specifies what \
automatic indentation should be done at the beginning of a new line after an \
explicit return character has been entered. ", "synonyms" -> {"auto indent"}, 
    "title" -> "AutoIndent", "type" -> "Symbol", "uri" -> "ref/AutoIndent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7482, 240, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->222885179]},
 "Notebook Image"->{
  Cell[8653, 287, 2952, 51, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->9974718],
  Cell[12024, 355, 2970, 51, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->470701443],
  Cell[16113, 451, 2999, 52, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->378972983],
  Cell[19248, 511, 3340, 57, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->375923099]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26245, 692},
 {"Notebook Image", 26386, 696}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2371, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2994, 85, 48, 1, 70, "ObjectName",
 CellID->31544],
Cell[3045, 88, 830, 25, 70, "Usage",
 CellID->15370]
}, Open  ]],
Cell[CellGroupData[{
Cell[3912, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4390, 135, 204, 8, 70, "Notes",
 CellID->13257],
Cell[4597, 145, 975, 26, 70, "2ColumnTableMod",
 CellID->88],
Cell[5575, 173, 323, 10, 70, "Notes",
 CellID->6129],
Cell[5901, 185, 673, 20, 70, "Notes",
 CellID->20297],
Cell[6577, 207, 291, 8, 70, "Notes",
 CellID->3340],
Cell[6871, 217, 574, 18, 70, "Notes",
 CellID->19923]
}, Closed]],
Cell[CellGroupData[{
Cell[7482, 240, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->222885179],
Cell[CellGroupData[{
Cell[7867, 254, 147, 5, 70, "ExampleSection",
 CellID->51488923],
Cell[8017, 261, 229, 9, 70, "ExampleText",
 CellID->25399047],
Cell[8249, 272, 313, 10, 70, "Input",
 CellID->74562189],
Cell[8565, 284, 85, 1, 70, "ExampleText",
 CellID->6091626],
Cell[8653, 287, 2952, 51, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->9974718],
Cell[11608, 340, 413, 13, 70, "ExampleText",
 CellID->128077075],
Cell[12024, 355, 2970, 51, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->470701443],
Cell[14997, 408, 125, 3, 70, "ExampleDelimiter",
 CellID->786637302],
Cell[15125, 413, 240, 9, 70, "ExampleText",
 CellID->507094859],
Cell[15368, 424, 319, 10, 70, "Input",
 CellID->229886874],
Cell[15690, 436, 420, 13, 70, "ExampleText",
 CellID->134745888],
Cell[16113, 451, 2999, 52, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->378972983],
Cell[19115, 505, 130, 4, 70, "ExampleText",
 CellID->32007479],
Cell[19248, 511, 3340, 57, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->375923099]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22637, 574, 311, 9, 70, "SeeAlsoSection",
 CellID->27500],
Cell[22951, 585, 726, 26, 70, "SeeAlso",
 CellID->15648]
}, Open  ]],
Cell[CellGroupData[{
Cell[23714, 616, 314, 9, 70, "TutorialsSection",
 CellID->27901],
Cell[24031, 627, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[24255, 636, 319, 9, 70, "MoreAboutSection",
 CellID->783034695],
Cell[24577, 647, 171, 3, 70, "MoreAbout",
 CellID->105496655],
Cell[24751, 652, 134, 3, 70, "MoreAbout",
 CellID->474051779],
Cell[24888, 657, 147, 3, 70, "MoreAbout",
 CellID->14100470]
}, Open  ]],
Cell[25050, 663, 50, 0, 70, "History"],
Cell[25103, 665, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

