(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17491,        588]
NotebookOptionsPosition[     13594,        462]
NotebookOutlinePosition[     15111,        503]
CellTagsIndexPosition[     15026,        498]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"], "ShowAutoStyles" :> 
          Documentation`HelpLookup["paclet:ref/ShowAutoStyles"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberForm\"\>", 
       2->"\<\"ShowAutoStyles\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Automatic Text Styling Features\"\>", 
       2->"\<\"Math Typesetting Options & Tweaking\"\>", 
       3->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AutoMultiplicationSymbol", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AutoMultiplicationSymbol",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AutoMultiplicationSymbol"]], "InlineFormula"],
     " \[LineSeparator]is an option for objects such as ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     " which specifies whether to automatically display a multiplication \
symbol between numbers which would be multiplied if evaluated."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"AutoMultiplicationSymbol", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " uses the character specified by the setting of the ",
 Cell[BoxData[
  ButtonBox["NumberMultiplier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberMultiplier"]], "InlineFormula"],
 " option. ",
 "The default is ",
 Cell[BoxData["\"\<\[Backslash][Times]\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "You can change the global setting for ",
 Cell[BoxData[
  ButtonBox["AutoMultiplicationSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoMultiplicationSymbol"]], "InlineFormula"],
 " in the ",
 StyleBox["Preferences", "DialogElementName"],
 " dialog. "
}], "Notes",
 CellID->503283781]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->115368713],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->40579199],

Cell["Format an expression with automatic multiplication symbols:", \
"ExampleText",
 CellID->183693809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{
    RowBox[{"HoldForm", "[", 
     RowBox[{"2", "*", "3", "*", "5"}], "]"}], ",", "\"\<Output\>\"", ",", 
    RowBox[{"AutoMultiplicationSymbol", "\[Rule]", "True"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217101384],

Cell[BoxData[
 TagBox[
  RowBox[{"2", " ", "3", " ", "5"}],
  HoldForm]], "Output",
 AutoMultiplicationSymbol->True,
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->797310131]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130046764],

Cell["\<\
Format an expression without automatic multiplication symbols:\
\>", "ExampleText",
 CellID->62209545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{
    RowBox[{"HoldForm", "[", 
     RowBox[{"2", "*", "3", "*", "5"}], "]"}], ",", "\"\<Output\>\"", ",", 
    RowBox[{"AutoMultiplicationSymbol", "\[Rule]", "False"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->309741641],

Cell[BoxData[
 TagBox[
  RowBox[{"2", " ", "3", " ", "5"}],
  HoldForm]], "Output",
 AutoMultiplicationSymbol->False,
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197973872]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Multiplication symbols are not inserted where explicit ",
 Cell[BoxData["*"], "InlineFormula"],
 " or ",
 Cell[BoxData["\[Times]"], "InlineFormula"],
 " operators are present:"
}], "ExampleText",
 CellID->203861236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
       "\"\<2\>\"", ",", "\"\< \>\"", ",", "\"\<3\>\"", ",", "\"\<*\>\"", 
        ",", "\"\<5\>\"", ",", "\"\<\[Times]\>\"", ",", "\"\<7\>\""}], "}"}], 
      "]"}], "]"}], ",", "\"\<Output\>\"", ",", 
    RowBox[{"AutoMultiplicationSymbol", "\[Rule]", "True"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49178882],

Cell[BoxData[
 RowBox[{"2", " ", "3", "*", "5", "\[Times]", "7"}]], "Output",
 AutoMultiplicationSymbol->True,
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253347523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136491554],

Cell["\<\
Automatic multiplication symbols are inserted only between explicit numbers:\
\>", "ExampleText",
 CellID->141591108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
       "\"\<2.1\>\"", ",", "\"\< \>\"", ",", "\"\<3\>\"", ",", "\"\< \>\"", 
        ",", "\"\<z\>\"", ",", "\"\< \>\"", ",", "\"\<7\>\""}], "}"}], "]"}], 
     "]"}], ",", "\"\<Output\>\"", ",", 
    RowBox[{"AutoMultiplicationSymbol", "\[Rule]", "True"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248157606],

Cell[BoxData[
 RowBox[{"2.1", " ", "3", " ", "z", " ", "7"}]], "Output",
 AutoMultiplicationSymbol->True,
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290357935]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowAutoStyles",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowAutoStyles"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->177600954],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->281034226],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->88011737]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AutoMultiplicationSymbol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 14.6911720}", "context" -> "System`", 
    "keywords" -> {
     "implicit multiplication", "multiplication symbol", "times sign", 
      "multiplication sign"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AutoMultiplicationSymbol is an option for objects such as Cell and \
Notebook which specifies whether to automatically display a multiplication \
symbol between numbers which would be multiplied if evaluated.", 
    "synonyms" -> {"auto multiplication symbol"}, "title" -> 
    "AutoMultiplicationSymbol", "type" -> "Symbol", "uri" -> 
    "ref/AutoMultiplicationSymbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6850, 203, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->115368713]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14883, 491}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2363, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2986, 84, 1589, 37, 70, "ObjectNameGrid"],
Cell[4578, 123, 869, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5484, 152, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5962, 169, 533, 17, 70, "Notes",
 CellID->1067943069],
Cell[6498, 188, 315, 10, 70, "Notes",
 CellID->503283781]
}, Closed]],
Cell[CellGroupData[{
Cell[6850, 203, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->115368713],
Cell[CellGroupData[{
Cell[7235, 217, 147, 5, 70, "ExampleSection",
 CellID->40579199],
Cell[7385, 224, 104, 2, 70, "ExampleText",
 CellID->183693809],
Cell[CellGroupData[{
Cell[7514, 230, 326, 9, 47, "Input",
 CellID->217101384],
Cell[7843, 241, 246, 9, 36, "Output",
 CellID->797310131]
}, Open  ]],
Cell[8104, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->130046764],
Cell[8232, 258, 112, 3, 70, "ExampleText",
 CellID->62209545],
Cell[CellGroupData[{
Cell[8369, 265, 327, 9, 70, "Input",
 CellID->309741641],
Cell[8699, 276, 247, 9, 36, "Output",
 CellID->197973872]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8995, 291, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9219, 300, 233, 7, 70, "ExampleText",
 CellID->203861236],
Cell[CellGroupData[{
Cell[9477, 311, 506, 14, 70, "Input",
 CellID->49178882],
Cell[9986, 327, 240, 7, 36, "Output",
 CellID->253347523]
}, Open  ]],
Cell[10241, 337, 125, 3, 70, "ExampleDelimiter",
 CellID->136491554],
Cell[10369, 342, 127, 3, 70, "ExampleText",
 CellID->141591108],
Cell[CellGroupData[{
Cell[10521, 349, 501, 14, 70, "Input",
 CellID->248157606],
Cell[11025, 365, 235, 7, 36, "Output",
 CellID->290357935]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11321, 379, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[11640, 390, 471, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12148, 412, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[12469, 423, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[12693, 432, 299, 8, 70, "MoreAboutSection"],
Cell[12995, 442, 171, 3, 70, "MoreAbout",
 CellID->177600954],
Cell[13169, 447, 180, 3, 70, "MoreAbout",
 CellID->281034226],
Cell[13352, 452, 170, 3, 70, "MoreAbout",
 CellID->88011737]
}, Open  ]],
Cell[13537, 458, 27, 0, 70, "History"],
Cell[13567, 460, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

