(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23916,        737]
NotebookOptionsPosition[     20346,        623]
NotebookOutlinePosition[     21793,        663]
CellTagsIndexPosition[     21708,        658]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Animate" :> Documentation`HelpLookup["paclet:ref/Animate"], 
          "Manipulator" :> Documentation`HelpLookup["paclet:ref/Manipulator"],
           "Animator" :> Documentation`HelpLookup["paclet:ref/Animator"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Animate\"\>", 
       2->"\<\"Manipulator\"\>", 3->"\<\"Animator\"\>", 
       4->"\<\"Export\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Creating Web Pages\"\>", 
       2->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AutorunSequencing", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AutorunSequencing",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AutorunSequencing"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " that specifies how autorun should use the controls provided."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings include:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "sequentially run each variable", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      StyleBox["t", "TI"]}], "}"}], Cell[TextData[{
     "run sequentially for ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds in total"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["i", "TI"], Cell[TextData[{
     "run only variable ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "run variable ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ", then ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     ", ..."
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["i", "TI"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "run variable ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds, etc."
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "run all variables together", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"], ",", 
      StyleBox["t", "TI"]}], "}"}], Cell[TextData[{
     "run all variables together for ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->337209793],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", 
    StyleBox["t", "TI"]}], "}"}]], "InlineFormula"],
 ", each variable is allocated the same time."
}], "Notes",
 CellID->537797325],

Cell["\<\
Each variable always starts from the initial value specified for it, and \
returns to the same value.\
\>", "Notes",
 CellID->52299510],

Cell[TextData[{
 "Controls are numbered sequentially based on their appearance in the \
original ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " expression. The numbering is not affected by which controls are visible."
}], "Notes",
 CellID->298119993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AutorunSequencing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutorunSequencing"]], "InlineFormula"],
 " is used when a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " expression is exported using ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " to a dynamic format. "
}], "Notes",
 CellID->239341169]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30763245],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->237775000],

Cell[TextData[{
 "Control the order of the variables when ",
 StyleBox["Autorun", "MenuName"],
 " is chosen from the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " menu:"
}], "ExampleText",
 CellID->182917000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1940685960],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 
    1, $CellContext`z$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 1, 2}, {
      Hold[$CellContext`z$$], 2, 3}}, Typeset`size$$ = {57.375, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$19749$$ = 0, $CellContext`y$19750$$ = 
    0, $CellContext`z$19751$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        1, $CellContext`z$$ = 2}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$19749$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$19750$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$19751$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 1, 
         2}, {$CellContext`z$$, 2, 3}}, 
      "Options" :> {AutorunSequencing -> {2, 1, 3}}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {75., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18585042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1275140441],

Cell["Specify a different duration for each variable (default 5):", \
"ExampleText",
 CellID->1546078474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1236920143],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 
    1, $CellContext`z$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 1, 2}, {
      Hold[$CellContext`z$$], 2, 3}}, Typeset`size$$ = {64.625, {2., 9.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$916$$ = 0, $CellContext`y$917$$ = 
    0, $CellContext`z$918$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        1, $CellContext`z$$ = 2}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$916$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$917$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$918$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 1, 
         2}, {$CellContext`z$$, 2, 3}}, 
      "Options" :> {AutorunSequencing -> {2, {1, 8}, {3, 1}}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {75., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->836153243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1042765021],

Cell[TextData[{
 "Specify ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " to run through all variables simultaneously: "
}], "ExampleText",
 CellID->137664780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1644374952],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 
    1, $CellContext`z$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 1, 2}, {
      Hold[$CellContext`z$$], 2, 3}}, Typeset`size$$ = {64.625, {2., 9.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$20952$$ = 0, $CellContext`y$20953$$ = 
    0, $CellContext`z$20954$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        1, $CellContext`z$$ = 2}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$20952$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$20953$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$20954$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 1, 
         2}, {$CellContext`z$$, 2, 3}}, 
      "Options" :> {AutorunSequencing -> All}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {75., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498596854]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->161579926],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout",
 CellID->72852861],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->347155355]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AutorunSequencing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 15.4724420}", "context" -> "System`", 
    "keywords" -> {
     "automatic sequencing", "autoplay duration", "autoplay order", 
      "autoplay sequence", "controls order", "controls use order", 
      "image play sequence"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AutorunSequencing is an option for Manipulate that specifies how autorun \
should use the controls provided.", "synonyms" -> {"autorun sequencing"}, 
    "title" -> "AutorunSequencing", "type" -> "Symbol", "uri" -> 
    "ref/AutorunSequencing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8974, 283, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->30763245]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21566, 651}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1676, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2299, 65, 1582, 37, 70, "ObjectNameGrid"],
Cell[3884, 104, 632, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4553, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5031, 144, 64, 1, 70, "Notes",
 CellID->1067943069],
Cell[5098, 147, 2533, 82, 70, "2ColumnTableMod",
 CellID->337209793],
Cell[7634, 231, 312, 11, 70, "Notes",
 CellID->537797325],
Cell[7949, 244, 145, 4, 70, "Notes",
 CellID->52299510],
Cell[8097, 250, 332, 9, 70, "Notes",
 CellID->298119993],
Cell[8432, 261, 505, 17, 70, "Notes",
 CellID->239341169]
}, Closed]],
Cell[CellGroupData[{
Cell[8974, 283, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30763245],
Cell[CellGroupData[{
Cell[9358, 297, 148, 5, 70, "ExampleSection",
 CellID->237775000],
Cell[9509, 304, 291, 10, 70, "ExampleText",
 CellID->182917000],
Cell[CellGroupData[{
Cell[9825, 318, 503, 15, 28, "Input",
 CellID->1940685960],
Cell[10331, 335, 2058, 44, 178, "Output",
 CellID->18585042]
}, Open  ]],
Cell[12404, 382, 126, 3, 70, "ExampleDelimiter",
 CellID->1275140441],
Cell[12533, 387, 105, 2, 70, "ExampleText",
 CellID->1546078474],
Cell[CellGroupData[{
Cell[12663, 393, 613, 19, 70, "Input",
 CellID->1236920143],
Cell[13279, 414, 2064, 45, 70, "Output",
 CellID->836153243]
}, Open  ]],
Cell[15358, 462, 126, 3, 70, "ExampleDelimiter",
 CellID->1042765021],
Cell[15487, 467, 226, 8, 70, "ExampleText",
 CellID->137664780],
Cell[CellGroupData[{
Cell[15738, 479, 444, 13, 70, "Input",
 CellID->1644374952],
Cell[16185, 494, 2053, 44, 70, "Output",
 CellID->498596854]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18299, 545, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18618, 556, 945, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[19600, 596, 319, 9, 70, "MoreAboutSection",
 CellID->161579926],
Cell[19922, 607, 145, 3, 70, "MoreAbout",
 CellID->72852861],
Cell[20070, 612, 204, 4, 70, "MoreAbout",
 CellID->347155355]
}, Open  ]],
Cell[20289, 619, 27, 0, 70, "History"],
Cell[20319, 621, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

