(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48771,       1284]
NotebookOptionsPosition[     43653,       1106]
NotebookOutlinePosition[     45061,       1145]
CellTagsIndexPosition[     44975,       1140]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Axes" :> Documentation`HelpLookup["paclet:ref/Axes"], 
          "AxesEdge" :> Documentation`HelpLookup["paclet:ref/AxesEdge"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Axes\"\>", 
       2->"\<\"AxesEdge\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Annotation & Appearance\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AxesOrigin", "ObjectName",
 CellID->27098],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AxesOrigin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AxesOrigin"]], "InlineFormula"],
     "\[LineSeparator]is an option for two\[Hyphen]dimensional graphics \
functions which specifies where any axes drawn should cross. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21797]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AxesOrigin", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies that the axes should cross at the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12066],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AxesOrigin", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses an internal algorithm to determine where the axes should cross. If \
the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], TraditionalForm]], "InlineMath"],
 " is within, or close to, the plotting region, then it is usually chosen as \
the axes origin. "
}], "Notes",
 CellID->6460],

Cell[TextData[{
 "In contour and density plots, ",
 Cell[BoxData[
  RowBox[{"AxesOrigin", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " puts axes outside the plotting area. "
}], "Notes",
 CellID->20391]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74801684],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->35706100],

Cell["Determine the axes origin automatically:", "ExampleText",
 CellID->180501439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92125971],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  AxesOrigin->Automatic]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->260121860]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->440134790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFtonEUUnuy/yWYTk80m1lRrNbX1br2hrVaDtLnUJE3bWGMtxYcYhORB
KzW+aB8seHnRF4ViQeyDF/DyUBEqQgvFglgQC2JBVJAKUh8sgsWHgDB+Z87M
PzNnZ7fdFFyS3XPmP/fL/GdmcmZh7qmnZxbmZ2cGNu+deXZufva5gdE9e7GU
tSilDuB/13IFWAMy/we0xm/4XcJ3hkcFwgjQ5qMKAF8xFO3iSUZfRY8r1Soo
9vFyxj/0KTi0KTk7DX7+/OKp737HnyrQV7a4+K99vrIJ+4hg2jw+8dWvL77w
5cTYIVXc88znKhsZegf4F0d+bEpeSLHDUMC42Sc/hSgoaDMrAF579fjO6Q9P
fvPbiiXKnjIU8Png2ydh7s8//dlhVs6e/fv5hSMQj0dX5pmkOLcFv6Gk7S6a
4Pvg/VOq2+Dwe37uMKSp5UZKv+VmaqzDJwp7j8GhHkYQdX9OHerY6rgsVa/D
oQO86ook12Sgi7guF1KWRZYxNdwOZWZnzvwFHN4xd42OLQbn7BDIz5EYRIPA
viTXBOk89O63V5l1RA1ZILA3ST1u8NM//AFLCFwhdFYjP8ZdPqzXVwu8mtQx
JmSuFDp7klwPu1yjYAi81uBwBi4RWElybTb4uXP/PLH7I4rsgIs8LES8Ay7y
h3UgnAgqgauEZd1RlYa7gdshZMWOGvzY0V/2v3SUwNUGf+vNrz/5+HsCuwwv
91rYQyUhR+48Iy7S8AveqTXOL7Qq4SxX7l/cmoGai9Tj7b1e+HNZE/YTOqxt
DyKisFbdKCLeWUdeq07vCCwPTYYGJ5DlIbPIL8lvJC+UI/Ehg/M+S+DNIg4d
USW4Xyllk8sKskT9cIvIUkdUfawTCqCGwFsN/tnh02+8foLAck4d6tgoKmGt
weE+gkxgewMu789a4W97ZFmPzR51SzHA+V0ArfCHoi3fDd2WrtfKMb1kn7Ul
7eoReCXASUBfMm8oRpRkbnfwvJqwyFUC7byqTnykHRLvFXhR27pG4Aks2UhJ
OqO/NaxExJy75YI2SF8q2ldfuJ+GvZeKWa0NMDqwgWRKXRKXtkn/y4Ec95sp
uyNxui6yAsKMsbXSH96zfMWHumt8aMvxvGxbk3ZUdNoDrjjfKZ0J+wtRzQPg
RlNpTYPC/nt13FXFKDODQv96HXdyltTxoNCxXuhIcz2g4x3pfqGrkOTaoONd
boPQxVw0Ee03b6Z+V4/sESeZLfJVeuHVqEaa5k6vlsWqd+r/t2VpscCnxUc5
42annW+Nwy1r3i2c7vrPLS66lwtS3afj3G/MqbgX/Jt+nY5ry1MG+zNsXSck
bvJ03nfe/GzneJlJWhar7tE6mgyHIkv5LOnfK3fruPI9tSqFsfZVfpeTb/Hh
OF42igUh906BD0dWZULmHVpH09RIUgdz+cn/doP790UjLh93nhD8LDya5CqK
DNym433Hc/lpzj/l+chPl2Z6N2/oevN2eo6Tc5v3wkz4/K5rOK/Ku4Q2EbOb
DO5PH5cm1783eX7FrIiqpIyONSE3y9d9/dwg7K4nz83XMp4lET+e//2Zc7yB
vNq68Hi7yNNqp8eeyyaizLv5WkoxE3Gwp1wnsjIRVZuZtoOOXyVivyWnDnUw
lzx3+rP7ZJKrU1h2jeZT+NYG1N4yPhHjSIODDYGei/zoErHjM7o/AWxL6uiy
FsgTfZqab1b8ucrcrAR9vT2yqOKq1t7DyJuJqaSOnAvxJ6+XORyRJvyRJFd4
i0NUfQLfkeSqOotgIcWoKrgejfzJZdocs6XYl+z9zHRenfXuHWX99wW+0s2V
OTcXIQu+YrNDOT1mZJYFX+00IXvA3BXZ2zUIR1bb3QrShZJA6T6+RNnmXqoL
ez7KBZKgARFEe2IZi4gHrJ/a9h7OpxTTXU1oIQJTU2WIQ0BQKFDw0OBBRBjx
gM0U591LtHvfJfG5XcfdQr5sVmvvnVXLf1dRxvg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->27571355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288243120],

Cell["Specify the axes origin explicitly:", "ExampleText",
 CellID->93392161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345832742],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  AxesOrigin->{0, -1}]], "Output",
 ImageSize->{154, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->224232822]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Pi", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->728952763],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->392719770]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22893],

Cell[TextData[{
 "By default, if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], TraditionalForm]], "InlineMath"],
 " is within the range, it is chosen to be the axes origin:"
}], "ExampleText",
 CellID->401138957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5"}], "}"}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], ",", "\[IndentingNewLine]",
    
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".5"}], ",", 
        RowBox[{"-", ".5"}]}], "}"}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->433833549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0.5, 0.5}],
    Axes->True], ",", 
   GraphicsBox[CircleBox[{-0.5, -0.5}],
    Axes->True]}], "}"}]], "Output",
 ImageSize->{330, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->98996072]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", ".5"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "-", ".5"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->801167005],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->13973669]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373992682],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], TraditionalForm]], "InlineMath"],
 " is not within the range, an internal algorithm determines the axes \
origin:"
}], "ExampleText",
 CellID->42743599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{"{", 
     RowBox[{"3.2", ",", "3.6"}], "}"}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82487840],

Cell[BoxData[
 GraphicsBox[CircleBox[{3.2, 3.6}],
  Axes->True]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->214764057]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", "2.5"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"3", "Pi"}], ",", 
     RowBox[{"5", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72308150],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->105443209]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4218],

Cell[TextData[{
 "In 3D, ",
 Cell[BoxData[
  ButtonBox["AxesEdge",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesEdge"]], "InlineFormula"],
 " specifies on which bounding box edge the axes should be drawn:"
}], "ExampleText",
 CellID->933767291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None", ",", "None"}], 
       "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "None"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56144690],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{{-1, 1}, None, None},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, {1, -1}, None},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {1, -1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->650986509]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1670],

Cell["Move the axes origin using a locator:", "ExampleText",
 CellID->109965688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
     RowBox[{"Framed", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
        RowBox[{"ImagePadding", "\[Rule]", "20"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"AxesOrigin", "\[Rule]", "p"}]}], "]"}], "]"}], ",", "p"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", "Locator"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->705423511],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = {-0.7799999999999998, 
    0.30000000000000027`}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {},
     Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], {0, 0}}, Automatic}}, Typeset`size$$ = {
    190., {108., 97.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = {0, 0}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Labeled[
        Framed[
         Graphics[
          Circle[{0, 0}, 3], PlotRange -> 3, ImagePadding -> 20, Axes -> True,
           AxesOrigin -> $CellContext`p$$]], $CellContext`p$$], 
      "Specifications" :> {{{$CellContext`p$$, {0, 0}}, Automatic, 
         ControlType -> Locator}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{236., {128., 133.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{240, 263},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15229065]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16396],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesEdge",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesEdge"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27518]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30573],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->909247534],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->614801954]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AxesOrigin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 27.2227428}", "context" -> "System`", 
    "keywords" -> {
     "axis position", "origin", "position of axes", "position of 2D axes", 
      "position of two-dimensional axes", "axis", "x axis", "y axis"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AxesOrigin is an option for two-dimensional graphics functions which \
specifies where any axes drawn should cross. ", "synonyms" -> {"axes origin"},
     "title" -> "AxesOrigin", "type" -> "Symbol", "uri" -> 
    "ref/AxesOrigin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4914, 164, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->74801684]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44833, 1133}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2006, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2629, 77, 48, 1, 70, "ObjectName",
 CellID->27098],
Cell[2680, 80, 500, 14, 70, "Usage",
 CellID->21797]
}, Open  ]],
Cell[CellGroupData[{
Cell[3217, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3695, 116, 397, 15, 70, "Notes",
 CellID->12066],
Cell[4095, 133, 501, 15, 70, "Notes",
 CellID->6460],
Cell[4599, 150, 278, 9, 70, "Notes",
 CellID->20391]
}, Closed]],
Cell[CellGroupData[{
Cell[4914, 164, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74801684],
Cell[CellGroupData[{
Cell[5298, 178, 147, 5, 70, "ExampleSection",
 CellID->35706100],
Cell[5448, 185, 83, 1, 70, "ExampleText",
 CellID->180501439],
Cell[CellGroupData[{
Cell[5556, 190, 248, 7, 28, "Input",
 CellID->92125971],
Cell[5807, 199, 280, 9, 167, "Output",
 CellID->260121860]
}, Open  ]],
Cell[CellGroupData[{
Cell[6124, 213, 292, 9, 28, "Input",
 CellID->440134790],
Cell[6419, 224, 2255, 41, 110, "Output",
 Evaluatable->False,
 CellID->27571355]
}, Open  ]],
Cell[8689, 268, 125, 3, 70, "ExampleDelimiter",
 CellID->288243120],
Cell[8817, 273, 77, 1, 70, "ExampleText",
 CellID->93392161],
Cell[CellGroupData[{
Cell[8919, 278, 314, 10, 70, "Input",
 CellID->345832742],
Cell[9236, 290, 278, 9, 176, "Output",
 CellID->224232822]
}, Open  ]],
Cell[CellGroupData[{
Cell[9551, 304, 336, 11, 28, "Input",
 CellID->728952763],
Cell[9890, 317, 2481, 45, 122, "Output",
 Evaluatable->False,
 CellID->392719770]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12420, 368, 216, 7, 70, "ExampleSection",
 CellID->22893],
Cell[12639, 377, 248, 8, 70, "ExampleText",
 CellID->401138957],
Cell[CellGroupData[{
Cell[12912, 389, 574, 19, 70, "Input",
 CellID->433833549],
Cell[13489, 410, 360, 12, 169, "Output",
 CellID->98996072]
}, Open  ]],
Cell[CellGroupData[{
Cell[13886, 427, 527, 18, 70, "Input",
 CellID->801167005],
Cell[14416, 447, 4176, 73, 70, "Output",
 Evaluatable->False,
 CellID->13973669]
}, Open  ]],
Cell[18607, 523, 125, 3, 70, "ExampleDelimiter",
 CellID->373992682],
Cell[18735, 528, 255, 9, 70, "ExampleText",
 CellID->42743599],
Cell[CellGroupData[{
Cell[19015, 541, 251, 8, 70, "Input",
 CellID->82487840],
Cell[19269, 551, 259, 8, 171, "Output",
 CellID->214764057]
}, Open  ]],
Cell[CellGroupData[{
Cell[19565, 564, 283, 10, 70, "Input",
 CellID->72308150],
Cell[19851, 576, 2513, 45, 70, "Output",
 Evaluatable->False,
 CellID->105443209]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22413, 627, 232, 7, 70, "ExampleSection",
 CellID->4218],
Cell[22648, 636, 252, 8, 70, "ExampleText",
 CellID->933767291],
Cell[CellGroupData[{
Cell[22925, 648, 1199, 36, 70, "Input",
 CellID->56144690],
Cell[24127, 686, 14514, 250, 140, "Output",
 CellID->650986509]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38690, 942, 223, 7, 70, "ExampleSection",
 CellID->1670],
Cell[38916, 951, 80, 1, 70, "ExampleText",
 CellID->109965688],
Cell[CellGroupData[{
Cell[39021, 956, 802, 25, 70, "Input",
 CellID->705423511],
Cell[39826, 983, 1751, 38, 70, "Output",
 CellID->15229065]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41638, 1028, 311, 9, 70, "SeeAlsoSection",
 CellID->16396],
Cell[41952, 1039, 443, 17, 70, "SeeAlso",
 CellID->27518]
}, Open  ]],
Cell[CellGroupData[{
Cell[42432, 1061, 314, 9, 70, "TutorialsSection",
 CellID->30573],
Cell[42749, 1072, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[42890, 1077, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[43084, 1085, 319, 9, 70, "MoreAboutSection",
 CellID->909247534],
Cell[43406, 1096, 175, 3, 70, "MoreAbout",
 CellID->614801954]
}, Open  ]],
Cell[43596, 1102, 27, 0, 70, "History"],
Cell[43626, 1104, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

