(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     86054,       2076]
NotebookOptionsPosition[     79246,       1840]
NotebookOutlinePosition[     80572,       1878]
CellTagsIndexPosition[     80486,       1873]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Axes" :> Documentation`HelpLookup["paclet:ref/Axes"], "Prolog" :> 
          Documentation`HelpLookup["paclet:ref/Prolog"], "Epilog" :> 
          Documentation`HelpLookup["paclet:ref/Epilog"], "PlotStyle" :> 
          Documentation`HelpLookup["paclet:ref/PlotStyle"], "TicksStyle" :> 
          Documentation`HelpLookup["paclet:ref/TicksStyle"], "GridLinesStyle" :> 
          Documentation`HelpLookup["paclet:ref/GridLinesStyle"], "FrameStyle" :> 
          Documentation`HelpLookup["paclet:ref/FrameStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Axes\"\>", 2->"\<\"Prolog\"\>", 
       3->"\<\"Epilog\"\>", 4->"\<\"PlotStyle\"\>", 5->"\<\"TicksStyle\"\>", 
       6->"\<\"GridLinesStyle\"\>", 
       7->"\<\"FrameStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Styling in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsStylingInNotebooks"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>", 
       3->"\<\"Graphics Styling in Notebooks\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AxesStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AxesStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions which specifies how \
axes should be rendered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics. "
}], "Notes",
 CellID->3196],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AxesStyle", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that all axes are to be generated with the specified style."
}], "Notes",
 CellID->6849],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AxesStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["xstyle", "TI"], ",", 
     StyleBox["ystyle", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that axes should use graphics directives ",
 Cell[BoxData[
  StyleBox["xstyle", "TI"]], "InlineFormula"],
 ", \[Ellipsis]. "
}], "Notes",
 CellID->24023],

Cell[TextData[{
 "Styles can be specified using graphics directives such as ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 " as well as ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and combinations given by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15125],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 " gives both the style of the axes themselves, and the default style for \
labels and ticks. ",
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " overrides specifications for ticks."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->298004344]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->709711015],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->399407540],

Cell["\<\
Specify overall axes style, including the ticks and the tick labels:\
\>", "ExampleText",
 CellID->7911699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170076932],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174564446]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250467504],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesStyle->RGBColor[1, 0.5, 0]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->267671068,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->644306891],

Cell["Specify the style of each axes:", "ExampleText",
 CellID->25797943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "12"}], "]"}], ",", "Blue"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144070148],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536107828]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111620456],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesStyle->{
    RGBColor[1, 0, 0], 
    RGBColor[0, 1, 0], 
    RGBColor[0, 0, 1]}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->618981887,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27443],

Cell["Styles associated with lines affect the axes and ticks", "ExampleText",
 CellID->356019607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457869047],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587052676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13225709],

Cell["Styles associated with fonts affect tick labels:", "ExampleText",
 CellID->23472827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", "Italic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140553305],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25290577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->466432450],

Cell[TextData[{
 "Styles can be combined by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21248147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Italic"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348130125],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVWVuIVlUUPvNf5uI4l38c5/bP1Rkbs4s56kymppnXvHcloodJAg3KMHup
l3qpl3qpl6LQwAq6PBiJERhEQiREQiREBWEQ9pAESQ9C8PfttfY+6+zvPxPO
w/yz99l7f2utb1323ufsmT126PEnZ48dPjg7uv3o7NOHDh98ZnTbkaN4VGxI
kuQ0/p7oS9CuoSV/p2s1/M/+NuG3iKGkKN3E/RbwU0D7pDxqdr9FHXLNUqbv
Fpb87Lel79aWAlxmlfRL1tcZbsIWGbnw3e8njn/7xdlfrlz55z6Z0HLdCJtd
t/mTUxcP7Dt55KlPgfPiC2fRfvmlL69evXZgHmjOjrtk5Nq1fwHy6ivnoI9a
/NmZHw8+9vHPP/2Z7JcFC/IQM7wEvE3yHHjPP/c57BPGk+Lly38fPnTKoe1L
9XOzG/3/eDVUgXgxU/owC7oAI9krq3s8E3fK6Ecffv/6a1+7pup46dJfmA0N
kj3R7A0yCh2giRtdSKt3p7MLKbZS4Jpt0gffcJ1r7opmbyCsdpIVz14vo6D6
0Uc+gG1Jp/SxFACueU+k9zoa7QyroRx+afYdYfShB953krtIs52RJozdFbyH
1Q47ns3Y3YS9I9JkLWF3B2zEqrM6nn178DRGHXYPrd4eabKWJPcEz4PRuWab
L3ul/+yxM+e/+c01t0WzVRMMYYJr9kn/3Fe/IqLj2U7vGRnFECa4Zr/0YQRo
cs2t0ezpwCAmuOaAk4kMVswmr0GBcw3Nsh9Tee+9e+HNN84HhCzixsByNk99
Flq2NpGEQoQO9yLZXLNK1m0IXvI8S61Iq6AomS0ykt95cqaJ40Hpo14g9U0O
ahxKkskRraMqlofvumvkOSqiryODFHuKb9k8F35gveRxVwecXTtPuCgdlj6U
hKquqfkE8kChayoh2T0l7CG8xxRSrY0FRYeKUNTQzfeKHmpp2etYjNAsykfI
t5rNcCTSxtBCpK4Knvb5OOojVVchkZBOrtmYs8r8NlqL81IzEerDiHh1IWXX
vDImfZTQiz/84ZqamZZb8epVxP0S0mWG2GzKWW3c6mrLqxnydFNk91QtrjDj
ZMk0aR6vXkmaT5DmayhbmiPNp0jzCdKccyFe7eqHC/lu4rpMMVqthZOTmuSe
9flnvZnsclNCDQs7u0mrUiYsIss5n2W+z0jw4fXNIojsknGT1J1MChHXVZLQ
ReyVPB+DGcluJ5xDcjnlNSstqiENkfxBkl8h3kt162VFOfsEHtCdI0n8zmeV
rV6+e9IQ6eHWDZMeHf/jCWfXUOp/Dcrg/+ycxRSn16tLtW5ehbzC+xd5B7az
d1QXi3qJisasjDzvhChnrzR7TYf8/2xuhyzg802ow+F/LOlW4nt5Lc75FcRl
a8TYCuJnOaGtIOvzVpsFN5G1qhu2OJhRv1pHrb7cTLrcIn2rs3LOFnaOp9kY
9wKyaOz9E+K7naS1+ueDWXaxL/X6/iKSHm4YZZKk21oe82qf7VnKjp1E2wjJ
dtjlxKvybDusjtsObEhFsn6ZzLTd9zZvpSLATXCWa7YTAnwWIcD9CioIWatu
lL7txO1kFRpqiJ9pVq4kK5ZRPwdJya2zaop0mCTrOsg6i4JJsm6KVk56vjoJ
wayaJKtWkRU3kO86IqsKFDNLa7XoXLiaLFtK7HfmoJl1OtvOgavJuqXeukqE
UiSL9BwACAC55hqycIIsjLkqEMPjZOG012GCLKvkoJjHx8myaVo97lG7IstK
ZNkS6s+QJUuoX8lBMx3GAvv+VqunTKtnY8R+nm7GyxhFhqJZZR6jyDC0Yopm
PtPzs1XmtdQfJZ/modkeMkK66FnebtEjZKnU0nTvy7uVhpuLnhbsfDvs/biO
uFUJVktNQt3t1M4DkQxbO0xeVll2Vx0KnvH7cbfJqr9DRtLCfTt7zxkibvQd
jr0VGKKomp80tc3uD3pKtP17fbDFv5dRabbTzCUt3F/DGaSJPK6nYcvPOyk6
qxQxcqqK3i4mSf19NpZm3lc0yw2VZtlfJekqbUEtvt+Gm0Uz+XuAONxYi3Nl
gGJU0UOuNJE/+8n/m0j3fprfE6GpbpaXelK22+Mm4r2fbDE0Z6nybRUpvW/5
mrOZ0HsD734/6c1BM6/0UkxsJst7ySsxmr5ztazsIS/cTZG6mCK5L+KthWTz
jWILsa7jtkvFaAuI1W7qbyVdu6nfF1kqp2Cujhld5R1epgIsyouoFG0h6dJF
/W2BJ6AjQzya6WZoxRzdKtTfQbpUqD8QobFunSR7J/U7gq7+HX81slTfnCMR
kOUu3jpItry/zpzYOygeY7R2isY2iid5i5+pnG0h2v279sEcNGO5jTJpN63W
cTt5GFoxRbO3/q0UvXupr+NWU4YitA6K7ZbAI9Cdpfsp81pIuuyPUonm+uIV
du9KQMKO7Zpp3fas3Euc6rh+Z3GajAg0f3PiL2dhV+gKHEOg07McYtV/b7o/
RJ/3cDmw5r8ByZkn/3tU3buG9EbYApIQIeAaIuBJhB/sAVMO8UGZgZiCl2Ei
DINVGqDwlLNwbB4yi0FmI1bCTKiNOg0sQD8szyEAwiEM9VmzbHye+G9JtzVv
fobxd1LU7Lc2fVr/bTRp+A+wLqqg\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239911813]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19448],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Arrowheads",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arrowheads"]], "InlineFormula"],
 " to style the axes: "
}], "ExampleText",
 CellID->130459707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.05"}], ",", "0.05"}], "}"}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->318764515],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165051813]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10204],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 " affects the axes, axes labels, ticks and tick labels:"
}], "ExampleText",
 CellID->730034636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178370624],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137768934]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172046868],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " offers overall style of all the label-like elements, including axes and \
tick labels:"
}], "ExampleText",
 CellID->287688071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->852841955],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36971455]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 " can be used to together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->16302533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"AxesStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610817034],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->255677792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->657512805],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " affects ticks and tick labels, but nothing else:"
}], "ExampleText",
 CellID->715340404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423721885],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172955850]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 " can be used together with ",
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 ", but has lower priority:"
}], "ExampleText",
 CellID->271652939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", 
      RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131785817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->137659676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194259969],

Cell[TextData[{
 "In 3D, ",
 Cell[BoxData[
  ButtonBox["BoxStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxStyle"]], "InlineFormula"],
 " is used to specify the styles of the bounding box edges, excluding the \
axes:"
}], "ExampleText",
 CellID->859706241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Gray"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154223676],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  BoxStyle->Directive[
    Dashing[{Small, Small}], 
    GrayLevel[0.5]]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->94578223,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13156],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prolog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prolog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Epilog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Epilog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TicksStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TicksStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridLinesStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridLinesStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23298]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5714],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->242403382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->22224893],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->111897431],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->191968876],

Cell[TextData[ButtonBox["Graphics Styling in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsStylingInNotebooks"]], "MoreAbout",
 CellID->280193051]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AxesStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 27.9415112}", "context" -> "System`", 
    "keywords" -> {
     "style of axis", "coordinate axis", "coordinate axes", "graph axes", 
      "plot axes"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "AxesStyle is an option for graphics functions which specifies how axes \
should be rendered. ", "synonyms" -> {"axes style"}, "title" -> "AxesStyle", 
    "type" -> "Symbol", "uri" -> "ref/AxesStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11051, 301, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->709711015]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 80342, 1866}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2782, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3405, 89, 4193, 83, 70, "ObjectNameGrid"],
Cell[7601, 174, 468, 14, 70, "Usage",
 CellID->32224]
}, Open  ]],
Cell[CellGroupData[{
Cell[8106, 193, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8584, 210, 242, 7, 70, "Notes",
 CellID->3196],
Cell[8829, 219, 211, 6, 70, "Notes",
 CellID->6849],
Cell[9043, 227, 397, 13, 70, "Notes",
 CellID->24023],
Cell[9443, 242, 1009, 36, 70, "Notes",
 CellID->15125],
Cell[10455, 280, 559, 16, 70, "Notes",
 CellID->298004344]
}, Closed]],
Cell[CellGroupData[{
Cell[11051, 301, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->709711015],
Cell[CellGroupData[{
Cell[11436, 315, 148, 5, 70, "ExampleSection",
 CellID->399407540],
Cell[11587, 322, 117, 3, 70, "ExampleText",
 CellID->7911699],
Cell[CellGroupData[{
Cell[11729, 329, 333, 10, 28, "Input",
 CellID->170076932],
Cell[12065, 341, 2506, 45, 126, "Output",
 Evaluatable->False,
 CellID->174564446]
}, Open  ]],
Cell[CellGroupData[{
Cell[14608, 391, 249, 7, 28, "Input",
 CellID->250467504],
Cell[14860, 400, 7471, 128, 194, 126, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->267671068]
}, Open  ]],
Cell[22346, 531, 125, 3, 70, "ExampleDelimiter",
 CellID->644306891],
Cell[22474, 536, 73, 1, 70, "ExampleText",
 CellID->25797943],
Cell[CellGroupData[{
Cell[22572, 541, 391, 13, 28, "Input",
 CellID->144070148],
Cell[22966, 556, 2457, 44, 125, "Output",
 Evaluatable->False,
 CellID->536107828]
}, Open  ]],
Cell[CellGroupData[{
Cell[25460, 605, 314, 9, 70, "Input",
 CellID->111620456],
Cell[25777, 616, 7630, 133, 194, 179, 6, "CachedBoxData", "BoxData", "Output",
 
 CellID->618981887]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33456, 755, 216, 7, 70, "ExampleSection",
 CellID->27443],
Cell[33675, 764, 97, 1, 70, "ExampleText",
 CellID->356019607],
Cell[CellGroupData[{
Cell[33797, 769, 266, 8, 70, "Input",
 CellID->457869047],
Cell[34066, 779, 2819, 50, 70, "Output",
 Evaluatable->False,
 CellID->587052676]
}, Open  ]],
Cell[36900, 832, 124, 3, 70, "ExampleDelimiter",
 CellID->13225709],
Cell[37027, 837, 90, 1, 70, "ExampleText",
 CellID->23472827],
Cell[CellGroupData[{
Cell[37142, 842, 267, 8, 70, "Input",
 CellID->140553305],
Cell[37412, 852, 2969, 53, 70, "Output",
 Evaluatable->False,
 CellID->25290577]
}, Open  ]],
Cell[40396, 908, 125, 3, 70, "ExampleDelimiter",
 CellID->466432450],
Cell[40524, 913, 210, 8, 70, "ExampleText",
 CellID->21248147],
Cell[CellGroupData[{
Cell[40759, 925, 335, 10, 70, "Input",
 CellID->348130125],
Cell[41097, 937, 2864, 51, 70, "Output",
 Evaluatable->False,
 CellID->239911813]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44010, 994, 239, 7, 70, "ExampleSection",
 CellID->19448],
Cell[44252, 1003, 210, 8, 70, "ExampleText",
 CellID->130459707],
Cell[CellGroupData[{
Cell[44487, 1015, 398, 14, 70, "Input",
 CellID->318764515],
Cell[44888, 1031, 2502, 45, 70, "Output",
 Evaluatable->False,
 CellID->165051813]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47439, 1082, 233, 7, 70, "ExampleSection",
 CellID->10204],
Cell[47675, 1091, 233, 7, 70, "ExampleText",
 CellID->730034636],
Cell[CellGroupData[{
Cell[47933, 1102, 487, 15, 70, "Input",
 CellID->178370624],
Cell[48423, 1119, 3067, 54, 70, "Output",
 Evaluatable->False,
 CellID->137768934]
}, Open  ]],
Cell[51505, 1176, 125, 3, 70, "ExampleDelimiter",
 CellID->172046868],
Cell[51633, 1181, 268, 8, 70, "ExampleText",
 CellID->287688071],
Cell[CellGroupData[{
Cell[51926, 1193, 611, 19, 70, "Input",
 CellID->852841955],
Cell[52540, 1214, 3058, 54, 70, "Output",
 Evaluatable->False,
 CellID->36971455]
}, Open  ]],
Cell[55613, 1271, 362, 12, 70, "ExampleText",
 CellID->16302533],
Cell[CellGroupData[{
Cell[56000, 1287, 665, 20, 70, "Input",
 CellID->610817034],
Cell[56668, 1309, 3059, 54, 70, "Output",
 Evaluatable->False,
 CellID->255677792]
}, Open  ]],
Cell[59742, 1366, 125, 3, 70, "ExampleDelimiter",
 CellID->657512805],
Cell[59870, 1371, 230, 7, 70, "ExampleText",
 CellID->715340404],
Cell[CellGroupData[{
Cell[60125, 1382, 488, 15, 70, "Input",
 CellID->423721885],
Cell[60616, 1399, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->172955850]
}, Open  ]],
Cell[63711, 1457, 359, 12, 70, "ExampleText",
 CellID->271652939],
Cell[CellGroupData[{
Cell[64095, 1473, 644, 19, 70, "Input",
 CellID->131785817],
Cell[64742, 1494, 3027, 54, 70, "Output",
 Evaluatable->False,
 CellID->137659676]
}, Open  ]],
Cell[67784, 1551, 125, 3, 70, "ExampleDelimiter",
 CellID->194259969],
Cell[67912, 1556, 268, 9, 70, "ExampleText",
 CellID->859706241],
Cell[CellGroupData[{
Cell[68205, 1569, 315, 9, 70, "Input",
 CellID->154223676],
Cell[68523, 1580, 7172, 124, 194, 166, 5, "CachedBoxData", "BoxData", \
"Output",
 CellID->94578223]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75756, 1711, 311, 9, 70, "SeeAlsoSection",
 CellID->13156],
Cell[76070, 1722, 1682, 62, 70, "SeeAlso",
 CellID->23298]
}, Open  ]],
Cell[CellGroupData[{
Cell[77789, 1789, 313, 9, 70, "TutorialsSection",
 CellID->5714],
Cell[78105, 1800, 192, 4, 70, "Tutorials",
 CellID->242403382]
}, Open  ]],
Cell[CellGroupData[{
Cell[78334, 1809, 318, 9, 70, "MoreAboutSection",
 CellID->22224893],
Cell[78655, 1820, 148, 3, 70, "MoreAbout",
 CellID->111897431],
Cell[78806, 1825, 175, 3, 70, "MoreAbout",
 CellID->191968876],
Cell[78984, 1830, 167, 3, 70, "MoreAbout",
 CellID->280193051]
}, Open  ]],
Cell[79166, 1836, 50, 0, 70, "History"],
Cell[79219, 1838, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

