(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51004,       1141]
NotebookOptionsPosition[     47348,       1018]
NotebookOutlinePosition[     48670,       1056]
CellTagsIndexPosition[     48584,       1051]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Baseline" :> Documentation`HelpLookup["paclet:ref/Baseline"], 
         "Center" :> Documentation`HelpLookup["paclet:ref/Center"], "Top" :> 
         Documentation`HelpLookup["paclet:ref/Top"], "Bottom" :> 
         Documentation`HelpLookup["paclet:ref/Bottom"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Baseline\"\>", 2->"\<\"Center\"\>", 
      3->"\<\"Top\"\>", 4->"\<\"Bottom\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Axis", "ObjectName",
 CellID->3968],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Axis",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Axis"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that represents the axis for purposes of \
alignment and positioning. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15927]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Typical interpretations of axis include: the displayed axis of a plot, the \
position of constructs like fraction bars in mathematical expressions, and \
the center of a font character.\
\>", "Notes",
 CellID->2094]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->224795112],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->827724998],

Cell["Align the axis of a graphic with the baseline of text:", "ExampleText",
 CellID->311039298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Axis"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->899223134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   GraphicsBox[CircleBox[{0, 1}],
    Axes->True,
    BaselinePosition->Axis], ",", "y"}], "}"}]], "Output",
 ImageSize->{155, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->38201970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108792991],

Cell["Align the center of the grid with the axis of text:", "ExampleText",
 CellID->325219977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"Center", "\[Rule]", "Axis"}], ")"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", "#"}], ")"}]}], "&"}], ",", "x", ",", "4"}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451644084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->(Center -> Axis),
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", 
   FractionBox["x", 
    RowBox[{"1", "+", 
     FractionBox["x", 
      RowBox[{"1", "+", 
       FractionBox["x", 
        RowBox[{"1", "+", 
         FractionBox["x", 
          RowBox[{"1", "+", "x"}]]}]]}]]}]]}], "}"}]], "Output",
 ImageSize->{155, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17127559]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216694019],

Cell[TextData[{
 "Fill to the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->35162160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614530118],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->377845771]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23833],

Cell[TextData[{
 "Fill to the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "-axis:"
}], "ExampleText",
 CellID->81726023],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1rE1EQ32QT+5HkpGDa9VB6M/0PBFEQvw6iSD+8hlKbCG2l9m/QQ+sf
oGgVa7xZo0YFvQhFURS9KArSg/XQgwpWCIglrjPvY3fz9u1H9qMGSWDfe/Pe
zG9mZ2Zn970cK86VJqaKc+Xx4sDh2eLZUnn83MChmVmYUhOKotTgmswrMNZh
RK6arkNvb7ugVYEhiRQOdPJTkjBcIhzdwoqKTcqkFSUtcFym0yrt8JfkpCcO
Mhwhy0s33uzbe+niwopyPKAdFGfkZAVwDh64EhLnyeNPZ8rVRw8/hsJJfvta
P2F4Hv2yzdI7c+9kXEdts+4y8a2iNVnCVbn5lkVqjytGhtBjI7dYPKzSC/Mr
iiag5XygvXyxdnpi+UHtA0Mz0TWBdkej0qur3zc3G03opck7d6vvGRrQ5VJ1
+fa7FtEo/WXtR73+G4cUbX3958bGL75u924uNEq0NrUz2v/tL14rrDWU11Wx
boTTRNCaqliXgC/W8aD6hvTmp32QqhPeGrSIWsyR2qMatSioHaPDvE4M/hM/
PH/2GeoYvl2c9Kd1+XsinF4QAlEcuum16hPpaPXzTOd9vNrCVg5n1Hht7qB3
ohkFeg80+LArKoXHuT4uQ5UYXzpZ5t1drCc4TAb18F2E8Z7y1N6rm7UGWjBB
c9CdsXBS5n7LDMAJM5QHrcHtUAJ71wzJcL3U0cQH1C/UzZwnalu8I0/9gsM8
NmnDW54e0iRxysdgV5+hx56VGZYXWiwe6rF4xEghguxkT1ZAjCdyvYYF5nPb
z2WEuOUYryxaPFtVXXyqOlVu69B3QLvI8sCuS/w+SUW1zmwLLN9o/HFexwyk
hUS+js+RfN3LnhT3oSs+7MphCr+2U1KvagKdlUTMzm/eVZbfBQQdhzmBPyNE
mvLD7h5Y8BtcblVBsKLAtcKUTKsmaNkeMypWhSFfaNevvWa7rihtHB2uNJ29
RIMKUZmeuodRiQa14AtlN6Hp7vTC+afMr35QMAoFnuXMH/6l7TaQ+7+P9x8M
ZawtpdBLp9rSsvbwgnn63YoOM+OoVLfufG4kVmY5ImTfzDTJPopITkFcz0XE
fxJE3P0t4CAZRj6IHfycxcs/bvJub0g5Do8UP/fwJ+WUQ+aqP4yt5+pY3b5W
L159xWqPG5d5YurGZdYPORf7rzDxF6hepVE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->589063183],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84719071],

Cell[TextData[{
 "Fill to the ",
 Cell[BoxData[
  FormBox["xy", TraditionalForm]], "InlineMath"],
 " plane at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "\[LongEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->212424707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->868679978],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579026022]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149085840],

Cell[BoxData[
 Graphics3DBox[{
   {Hue[0.67, 0.6, 0.6], Point3DBox[CompressedData["
1:eJxd1H9Qk3UcB/AHTfdIFA9rwaM+yuPjk2cjPQg6qWPucyZ3ohA7jFoI16Bh
JBgeQUGkoFc2OPBQQiw4jwQtwktuGGqBG4hgCV7OAcOR0DZg48cc5QkXdfX8
0bO7fbjjuHvx3nvPe8+z74aM3KTMZQRBaIXf5YT441GKf1nTkvbCD31KXyeA
aApSlcB9g6+TwP4T6VmT24Ocgo6bVvWCxoFcBq2fZiRYEy2onwZqxjxX9JMN
5RkolZhClvvpkbOg66U/qGJdyDkwrw3Vny20I+fhibj3aiyRboN3z///t3xd
fm2XZFDp6wQY+ajntqePojwJO7OuV6bEu1Gegh6jQnFm0Y5cBoTfa28eUowi
p6F/+EDNJZhGzgBzIvZvebITvS8Lix9+dDKq61fkHDi3yivX+M+hHh5U8unh
4u/uGMTrFvc29BVdn4oZQ04ANHaHaVpvKH2dhMWXyir+ChxBTkFqdIs2tnwS
9chAFe7XliidQ06Daqqj6hnNHOphIIALfnm7G+dZiH9kuze8zY6cA5057qD6
hBn18NCQBBc1yeIuyruXhuq35VcmlL5OwCfHo/OrpS6UJ8Fp7494aj92CpwD
Y6qZ2inUI+yNqiAlVx0oT8Oou0Qa1o6dgZxmq+Xal9Ooh4XNkc21y46OIBfu
b3L0CpqcRM4DnNtR2vSG1SBeh7g3vDJ4wtJ3FzkBZMi8pe7VB0pfFz4/1pxi
4i6jPAXjhz7/d9LThVwGdLWmxVQ/jJyGfEdcaNEeF3IGLGfvWdbxU8hZ8Hiy
TIElNuQcVF2StuRzPeg6eSDCNuoVE3Xe80LcazwZKx2SOJAL399Y5pvS/Z3I
SQhoVszq/hCfN9EpaDi/44WtW6ZQXgbGwcj3X/+qE+VpUK9PTHAEOlFeOK96
9y3lPMb9LLRmZ55TJhiRczAeEiHJGDIh50F9ur3s24IZ7zko7u3XxTWu7LMj
J4Bt2rT78K455CREN8p7DqePIacg4GHXn9t+Eb+/osuAmU9LGZj4HTkN4fYg
Mtv6M+phhF36xLtOE8qzcObF6CO6G3bkHLCh8wb/1FnUw4PxaEFb7tJvBvH1
4l7zhcqPZ49MIyegYfUrN802I3ISdB2RO7WbncgpgDRXJ5RZkMsgSxOx3pll
U/q68DxPyG8XHHAhZ0B3pWZVQp4V9bBQ6l7rbnDcR3kO+HWw6dTlhyjPg/Z0
+6Pui6Jz3r0xT2YoNpbPIiegZ6Q9c+Et8b6LToI6vCYhr38I5SlQ92YntcVY
UF7Ye/74AKPEPcL9jQjOf37GhnqE82pV4aTpsQs5CzH8MfbpWifq4cC4ek9d
sR338FCYdGvLZ3fE55P37q1InT72ThB2Akr1jHTDih+Rk1C/VLwvL20cuXAu
ln9xsDvze+QyuHrrXW194CByGjwLA/XP7hV3iS6cV66Blbc7HqA8C2pFrzFx
tx3lOdCkx3f7x7pQnofxvVzOuKpN+R90jv62
     "]]}, 
   {RGBColor[0.6236000000000002, 0.62, 0.8], Line3DBox[CompressedData["
1:eJx11wtsE3UcwPEDhB2IrswKBQocRyU4hGwOwzQrv1+QJQyYW4Zo5RHL3HDy
EIJDQQQGUSwLIzwcoCxk8lKECNlwgA7+ZYwNZSNSCisMYa57tHtxKAHiNHrG
nE1/++2Spusn3/577S/32Mj0pWmZvSRJytAfPfXHv3//t2lgPCuezoxD31UC
dSls+/81SgcGpK7Dm6KLs72Myl9x2pCl5YI635uw9EKt46GzQVDnezMe/zg9
uTbFB9T53oKmVm/7qh/qBXW+t2JOhGdQrx5FgjrfK+iqsLy3VQkK6nyvonfo
iKK9K/2COt/b8LGkd/J9cR2CenhvzEMD35e5p6dGXAPqfC+h2zbhmUnzbwnq
fC/jlKyzebNndAB1vjdhudtu3/3ID9T5Xp9jj1deX2a/BV2c7S1YVbMw/xi2
AHW+t6J1S+Kf0bMCgjrfK/jo/Q+2TTj3s6DO9yoGxkfnDenXDtT53oap0S01
q7+5LKiH58bvq0Fh5aqzzQl3BHW+lxD3l411Hj9Pj8Nu1pfx0QubNv8ReQOo
870J58YfyUjMbRLU+d6MqTE9ilOi2gV1vrdganPp1qec7UCd763YXx344qQO
uj6dr+EKzrhff7Vmol9Q53sVXd6kJY4tXqDO9zYsTMOjzll0XnS+xu+lgQV3
vBl9shGo872EH22Mz94RZZx/Qs73Mgb8VbFPLKA9na/hJgxU30lt3dUM1Ple
n++EzXLEqQZBne8teKtjXdTYEtrT+RpuxcWHa32nP28B6nyv4Ji4w7t6rr8B
1PleP35nxfe2yE1Ane9tiPsm5xx4rVZQD++N769BTN7ARl/lFUGd7yWUB93z
7Xn5Nr3OdbO+PkfFO9ujnhBdnO1NWLfs07+btHOCOt+b0bLDecRTUCOo870F
sxuSRqyaHhTU+d6Kvr1XfcNszYI63yuoaVmeyHX1gjrfq7j1WNSRbLUcqPO9
Psexo4rsjXugi4dtxvfRwL0tMep6RANQ53v9+pto/SpnwRl6X9LN+jL2P2xv
c/1mnN9CzvcmLDw4+bnx45qBOt+b0X0t7t1XvzgjqPO9BR3DU5IbIgNAne/1
+6uKOZ2LH9D9p/M1XMHjizL3QbJbUOd7FesGxUakX/cI6nxvQ8fOkk1fr2gF
6uG9sX8aVLmS9vepNO5nQs73EioHRk9bM7UdqPO9jPH7o8vXzL8D1PnehP3v
nvt94k/G9TfkfG9G6715s6sbfxXU+d6CMf4B8qLaH4E631v1eRWlXAl4BHW+
V3D38/FrXef9gjrfq6iMuCf6zW0D6nxvQ/f6FcVLO38R1MN74/M08B7K+7Bt
bYugzvcSFg5+6YK33i2o872MrtK4KRljAoI635sQ5wXP4CafoM73Zsxyxg4P
ZNUDdb7Xz8+N0ZdWLAwCdb63outkft/k5bWCOt8rmNMxtKOw4SZQ53sVbcNw
9PYTdwV1vrdhxs6S+2VHaU/na7xfg4TH0+2jctsEdb6XsPxGSebDN4zjPeR8
L6MjJj95edV1QZ3vTeioWJRWnOAD6nyvz/fgxmor0P2h8zVcP35jB2Y/21ov
qPO9fn/Vd2WT50FQUOd7BRNsG5QndwWAOt+r6B48fc9qP90ftZvehivTLo77
5HI7UA/vjdcabJ7bsuGtAUYfcr6XMKfIGjWy9/f0/+pu1pexoHP1nOXz6oA6
3+tzzP1sSVnmt9DF2d6Mpy6+nVEQeQ2o870FtYfVBU/PNOYVcr7X76+C1X0u
ld4G6nyvoMNe4U6Z5hfU+V5F5/wZZf0Sg0Cd721YN1NdXJdaDNSN8h9iN1Ls

     "]]}},
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  PlotRange->{All, All, Automatic},
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->587190474,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27396],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Baseline",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Baseline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Top",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Top"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bottom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Bottom"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5417]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Axis - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 29.2227940}", "context" -> "System`", 
    "keywords" -> {
     "alignment marker", "alignment symbol", "axis alignment", 
      "aligning graphics", "aligning plots", "filled plots"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Axis is a symbol that represents the axis for purposes of alignment and \
positioning. ", "synonyms" -> {}, "title" -> "Axis", "type" -> "Symbol", 
    "uri" -> "ref/Axis"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2718, 93, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->224795112]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48442, 1044}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 816, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1439, 44, 41, 1, 70, "ObjectName",
 CellID->3968],
Cell[1483, 47, 458, 14, 70, "Usage",
 CellID->15927]
}, Open  ]],
Cell[CellGroupData[{
Cell[1978, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2456, 83, 225, 5, 70, "Notes",
 CellID->2094]
}, Closed]],
Cell[CellGroupData[{
Cell[2718, 93, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->224795112],
Cell[CellGroupData[{
Cell[3103, 107, 148, 5, 70, "ExampleSection",
 CellID->827724998],
Cell[3254, 114, 97, 1, 70, "ExampleText",
 CellID->311039298],
Cell[CellGroupData[{
Cell[3376, 119, 378, 12, 28, "Input",
 CellID->899223134],
Cell[3757, 133, 341, 11, 128, "Output",
 CellID->38201970]
}, Open  ]],
Cell[4113, 147, 125, 3, 70, "ExampleDelimiter",
 CellID->108792991],
Cell[4241, 152, 94, 1, 70, "ExampleText",
 CellID->325219977],
Cell[CellGroupData[{
Cell[4360, 157, 690, 23, 70, "Input",
 CellID->451644084],
Cell[5053, 182, 729, 25, 75, "Output",
 CellID->17127559]
}, Open  ]],
Cell[5797, 210, 125, 3, 70, "ExampleDelimiter",
 CellID->216694019],
Cell[5925, 215, 144, 6, 70, "ExampleText",
 CellID->35162160],
Cell[CellGroupData[{
Cell[6094, 225, 309, 10, 28, "Input",
 CellID->614530118],
Cell[6406, 237, 6239, 106, 128, "Output",
 Evaluatable->False,
 CellID->377845771]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12694, 349, 216, 7, 70, "ExampleSection",
 CellID->23833],
Cell[12913, 358, 144, 6, 70, "ExampleText",
 CellID->81726023],
Cell[13060, 366, 1408, 27, 70, "Output",
 Evaluatable->False,
 CellID->589063183],
Cell[14471, 395, 124, 3, 70, "ExampleDelimiter",
 CellID->84719071],
Cell[14598, 400, 255, 10, 70, "ExampleText",
 CellID->212424707],
Cell[CellGroupData[{
Cell[14878, 414, 358, 11, 70, "Input",
 CellID->868679978],
Cell[15239, 427, 21811, 362, 70, "Output",
 Evaluatable->False,
 CellID->579026022]
}, Open  ]],
Cell[CellGroupData[{
Cell[37087, 794, 367, 12, 70, "Input",
 CellID->149085840],
Cell[37457, 808, 8522, 150, 160, 3634, 65, "CachedBoxData", "BoxData", \
"Output",
 CellID->587190474]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46040, 965, 311, 9, 70, "SeeAlsoSection",
 CellID->27396],
Cell[46354, 976, 922, 35, 70, "SeeAlso",
 CellID->5417]
}, Open  ]],
Cell[47291, 1014, 27, 0, 70, "History"],
Cell[47321, 1016, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

