(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79390,       2517]
NotebookOptionsPosition[     69493,       2180]
NotebookOutlinePosition[     71011,       2220]
CellTagsIndexPosition[     70925,       2215]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/StructuralOperations"], 
          "Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Structural Operations\"\>", 
       2->"\<\"Vectors and Matrices\"\>", 
       3->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Minors" :> 
          Documentation`HelpLookup["paclet:ref/Minors"], "DiagonalMatrix" :> 
          Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "Span" :> 
          Documentation`HelpLookup["paclet:ref/Span"], "Diagonal" :> 
          Documentation`HelpLookup["paclet:ref/Diagonal"], "Extract" :> 
          Documentation`HelpLookup["paclet:ref/Extract"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ArrayFlatten\"\>", 2->"\<\"SparseArray\"\>", 
       3->"\<\"Minors\"\>", 4->"\<\"DiagonalMatrix\"\>", 5->"\<\"Take\"\>", 
       6->"\<\"Span\"\>", 7->"\<\"Diagonal\"\>", 
       8->"\<\"Extract\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"New in 6.0: Core Language\"\>", 
       3->"\<\"New in 6.0: List Manipulation\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Band", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Band",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Band"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["i", "TI"], ",", 
         StyleBox["j", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents the sequence of positions on the diagonal \
band that starts with ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "}"}]], "InlineFormula"],
     " in a sparse array."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Band",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Band"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["min", "TI"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents the positions between ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["min", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["max", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Band",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Band"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["min", "TI"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["di", "TI"], ",", 
          StyleBox["dj", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents positions starting with ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["min", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " and then moving with step ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["di", "TI"], ",", 
        StyleBox["dj", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12351]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Band", "[", 
    StyleBox["pos", "TI"], "]"}], "->", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " represents values ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " that repeat along the diagonal band starting at ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6923],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Band", "[", 
    StyleBox["pos", "TI"], "]"}], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " represents a sequence of values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 " along the diagonal band starting at ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7118],

Cell[TextData[{
 "With an array ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " of the same rank as the whole sparse array, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Band", "[", 
    StyleBox["start", "TI"], "]"}], "->", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 " by default inserts ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " at the position specified by ",
 Cell[BoxData[
  StyleBox["start", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31550],

Cell[TextData[{
 "With arrays ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 " of the same rank as the whole sparse array, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Band", "[", 
    StyleBox["pos", "TI"], "]"}], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " represents a sequence of non-overlapping subarrays."
}], "Notes",
 CellID->2097],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"], "[", 
   StyleBox["start", "TI"], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"], "[", 
   RowBox[{
    StyleBox["start", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11836],

Cell[TextData[{
 "For scalar values, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"], "[", 
   RowBox[{
    StyleBox["start", "TI"], ",", 
    StyleBox["end", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"], "[", 
   RowBox[{
    StyleBox["start", "TI"], ",", 
    StyleBox["end", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10591],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"], "[", 
   RowBox[{
    StyleBox["start", "TI"], ",", 
    StyleBox["end", "TI"], ",", 
    StyleBox["step", "TI"]}], "]"}]], "InlineFormula"],
 " stops when any coordinate first exceeds its value in ",
 Cell[BoxData[
  StyleBox["end", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13406],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Band", "[", 
    RowBox[{
     StyleBox["start", "TI"], ",", 
     StyleBox["end", "TI"]}], "]"}], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " takes the values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 " to repeat cyclically until ",
 Cell[BoxData[
  StyleBox["end", "TI"]], "InlineFormula"],
 " is reached."
}], "Notes",
 CellID->4510],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Band", "[", 
    RowBox[{
     StyleBox["start", "TI"], ",", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     StyleBox["step", "TI"]}], "]"}], "->", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 " continues until the edge of the array is reached."
}], "Notes",
 CellID->281249886],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Band", "[", 
    RowBox[{
     StyleBox["start", "TI"], ",", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     StyleBox["step", "TI"]}], "]"}], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " continues until the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are exhausted."
}], "Notes",
 CellID->63620143]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92236471],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->823247460],

Cell["Create a band diagonal matrix:", "ExampleText",
 CellID->76326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "x"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "y"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69978601],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWL9PAjEULgen4OFgjIkxDkaNGjcH9R/wRxyYnYkx0cFo1IGNkZGRkT+B
8UZGRkZGRkZGxufrj6N3Z8HWlhNJ7q5tXvt97XvvO+5Vqp9Pjy/Vz+eH6t7t
e/Xt6fnhY+/m9R2H8jlCyD1ed9sE24Atdt0D4JPfL/FewMFd1vPpPd9ut4H9
yBnr0zm8v8X69Xpd9PNsVoE1B4NBGIa0Sft0Ujn1XE+tVsKbh11PPFci9H6/
n1691WrFMf3pKsyGkDWD0bLACxhZyYeQVQYwmUxqtZpkkI9GOQnOyIpBEDuJ
OKMSG280GghGm94U3+v1er4b3MSOgwQyOhDdmERmZz8ajdzsfM5oglcRkjEV
5yPjz54P3Td1BF8q+hUhGZnTuOCpsTA2R9F5i6GcEscHdX4dp+zUsyv/2mof
uF7p7fUQkopzpDUrfb4/6VYg7Epaq5tEyWylCpT2RecMZilVOUt8pWJlxUBX
sbLyiJ5iqee6Z3NigZPOs1MwyaNlVSg9q03gOnahZc3/d8loOzc6X139ivxg
o2OmiuU+Ts0Ua0H4BoqVVabqKpZ7PjaK5Z6NWrFscKI8i/TLLI+WVaH0rOgZ
06C61rLmX3gyBq9+Nesn/TI7/xVwoVi28WOrWNb41oq1IB37E4/QvlvFsmGz
nxHOAdjk0bIqlIlVs9nUsJL1sbgVfrWPx2MQ0aOjT9GTe2c4HHY6HdqMVxfC
MBTVMBaKjrNBPcqrHd1uV1ELwi0Klj640oh5LNAjiVpYuhpYyISFjADJwkO/
ZOcT9pbCk+eCxBV7egrgWpdmc/hWiRVvL14gpM2NhaJLHI6+A/Nzi337iFo3
yX0BF4n3xA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->263139086]
}, Open  ]],

Cell["Convert to normal lists:", "ExampleText",
 CellID->56295398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172647432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "y", ",", "x", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "y", ",", "x", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "y", ",", "x"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177231698]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24514],

Cell[TextData[{
 "Mix ",
 Cell[BoxData[
  ButtonBox["Band",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Band"]], "InlineFormula"],
 " with other ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " element specifications:"
}], "ExampleText",
 CellID->190835228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "x"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}], "\[Rule]", "b"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->508265366],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWCtzwkAQPvKgvCqqSlvDr2kHgUZnmM6A6LRDETgkEonkJyAjkUgkEolE
Iq97rzyOJE3gcmRamElus7Pc93G7+wHbcUb99w9nNOg5rbeh89Uf9L5br59D
cJklhFAXrnYTgY3BolcXY1iDd5vczcVigekLtenzZDLhzyaNsqi53W5d1yUm
eTZhw0bMWoPVgNXga1mgbDYbedf5fB7EsglP8UJ8LwVey/OCcUfhjsfjeDz2
+ZjCyygxfjnwqfNTqVK86XQKkMQ0PBbGer22taBDQiGtYXSak/1+n+cZnOak
gsM1FuTj12NefKo4XLFehbDW0MzmUWSBu0qR6KRCkrqwKcVH79K5Rf1ynrKa
1bm/mmpXRTUS6pV6ZFxFEx+hII0bi8LlRtax6ChdbJ4uQI/rxhecpfuKqjXX
V7c4VSN+Oz91S9Erumo2WUH+F4ssuRFVg0w/vqycUTolC/JGSLxPLZNoFatJ
J1BLhSt3oVAzca6NVLsUVWOup2pxaiZ/e1xcHWfrl/pOPkc5/iqLouUmg3pp
YJOgYErRRTcKVTuv+4qqNVmiZrNZiih/7haMgv/9h8OBmjidqomVZWm32y2X
S2IGpxau6/LpG60Rxb0S7WVTlNVqFTFjgo/IWdpYlYIksYCMhOZs8vTR0sLC
rwCfhQF50ZcT8kvNgJOniGz+a3mngFWrVjyHk8kvn0WzwSMxH3JF93EY+jNO
7q17GsWm5qj0AwMTQog=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->52935072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398569332],

Cell["Give explicit values to fill in on the band:", "ExampleText",
 CellID->178408108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357673702],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"x", "0", "0", "0", "0"},
     {"0", "y", "0", "0", "0"},
     {"0", "0", "z", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 1, 2, 3, 3, 3}, {{1}, {2}, {
       3}}}, {$CellContext`x, $CellContext`y, $CellContext`z}}]]]]], "Output",\

 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->84465292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->313781650],

Cell["Repeat the values cyclically:", "ExampleText",
 CellID->327729340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19059945],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"x", "0", "0", "0", "0"},
     {"0", "y", "0", "0", "0"},
     {"0", "0", "z", "0", "0"},
     {"0", "0", "0", "x", "0"},
     {"0", "0", "0", "0", "y"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 1, 2, 3, 4, 5}, {{1}, {2}, {3}, {4}, {
       5}}}, {$CellContext`x, $CellContext`y, $CellContext`z, $CellContext`x, \
$CellContext`y}}]]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->446495099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->456452117],

Cell["Start the band at any position in the matrix:", "ExampleText",
 CellID->158699571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], "]"}], "\[Rule]", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13205183],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "x", "0", "0", "0"},
     {"0", "0", "x", "0", "0"},
     {"0", "0", "0", "x", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 0, 0, 1, 2, 3}, {{2}, {3}, {
       4}}}, {$CellContext`x, $CellContext`x, $CellContext`x}}]]]]], "Output",\

 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->334821871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->218758912],

Cell["Specify any start and end locations:", "ExampleText",
 CellID->162314312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "\[Rule]", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35646345],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "x", "0", "0", "0"},
     {"0", "0", "x", "0", "0"},
     {"0", "0", "0", "x", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 1, 2, 3, 3, 3}, {{2}, {3}, {
       4}}}, {$CellContext`x, $CellContext`x, $CellContext`x}}]]]]], "Output",\

 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->800959095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->359255213],

Cell["Step by 2 between elements on the band:", "ExampleText",
 CellID->477190748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5"}], "}"}], ",", "2"}], "]"}], "\[Rule]", "x"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228027596],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"x", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "x", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "x"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 1, 1, 2, 2, 3}, {{1}, {3}, {
       5}}}, {$CellContext`x, $CellContext`x, $CellContext`x}}]]]]], "Output",\

 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->6036175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->115121617],

Cell["Any step can be used:", "ExampleText",
 CellID->451494755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[Rule]", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99576899],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"x", "0", "0", "0", "0"},
     {"0", "0", "x", "0", "0"},
     {"0", "0", "0", "0", "x"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 1, 2, 3, 3, 3}, {{1}, {3}, {
       5}}}, {$CellContext`x, $CellContext`x, $CellContext`x}}]]]]], "Output",\

 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->63108112]
}, Open  ]],

Cell["Automatically continue the band to the edge of the array:", \
"ExampleText",
 CellID->85042583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[Rule]", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2313214],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"x", "0", "0", "0", "0"},
     {"0", "0", "x", "0", "0"},
     {"0", "0", "0", "0", "x"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 1, 2, 3, 3, 3}, {{1}, {3}, {
       5}}}, {$CellContext`x, $CellContext`x, $CellContext`x}}]]]]], "Output",\

 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->274986009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151481095],

Cell["Specify a band that is part of a row:", "ExampleText",
 CellID->528628135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], ",", "Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "\[Rule]", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->403655273],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "x", "x", "x"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 0, 0, 3, 3, 3}, {{5}, {3}, {
       4}}}, {$CellContext`x, $CellContext`x, $CellContext`x}}]]]]], "Output",\

 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->14232645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64779127],

Cell["Insert a submatrix beginning at position 3, 3:", "ExampleText",
 CellID->34929309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "]"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219036098],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "a", "b", "0"},
     {"0", "0", "c", "d", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 0, 0, 2, 4, 4}, {{3}, {4}, {4}, {
       3}}}, {$CellContext`a, $CellContext`b, $CellContext`d, \
$CellContext`c}}]]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->142110163]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->439957525],

Cell["Cyclically repeat the submatrix:", "ExampleText",
 CellID->4220784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233388419],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b", "0", "0", "0"},
     {"c", "d", "0", "0", "0"},
     {"0", "0", "a", "b", "0"},
     {"0", "0", "c", "d", "0"},
     {"0", "0", "0", "0", "a"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 2, 4, 6, 8, 9}, {{2}, {1}, {2}, {1}, {3}, {4}, {4}, {3}, {
       5}}}, {$CellContext`b, $CellContext`a, $CellContext`d, $CellContext`c, \
$CellContext`a, $CellContext`b, $CellContext`d, $CellContext`c, \
$CellContext`a}}]]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->232655931]
}, Open  ]],

Cell["Alternate the submatrix with a single element:", "ExampleText",
 CellID->2503275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", "x", "}"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222629235],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b", "0", "0", "0"},
     {"c", "d", "0", "0", "0"},
     {"0", "0", "x", "0", "0"},
     {"0", "0", "0", "a", "b"},
     {"0", "0", "0", "c", "d"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 2, 4, 5, 7, 9}, {{2}, {1}, {2}, {1}, {3}, {4}, {5}, {4}, {
       5}}}, {$CellContext`b, $CellContext`a, $CellContext`d, $CellContext`c, \
$CellContext`x, $CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}}]]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->982742534]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19785],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Band",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Band"]], "InlineFormula"],
 " works in sparse arrays of any rank:"
}], "ExampleText",
 CellID->94950818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "/@", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"SparseArray", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Band", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], "\[Rule]", "x"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "10", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
     "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353354589],

Cell[BoxData[
 Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{2, 2, 2}], 
   CuboidBox[{3, 3, 3}], CuboidBox[{4, 4, 4}], CuboidBox[{5, 5, 5}], 
   CuboidBox[{6, 6, 6}], CuboidBox[{7, 7, 7}], CuboidBox[{8, 8, 8}], 
   CuboidBox[{9, 9, 9}], CuboidBox[{10, 10, 10}]},
  ImageMargins->0.,
  ImageSize->Small,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108260319,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "/@", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"SparseArray", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Band", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", "Automatic", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "\[Rule]", 
         "x"}], ",", 
        RowBox[{"{", 
         RowBox[{"30", ",", "30", ",", "30"}], "}"}]}], "]"}], "]"}], ",", 
     "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99413155],

Cell[BoxData[
 Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{2, 3, 4}], 
   CuboidBox[{3, 5, 7}], CuboidBox[{4, 7, 10}], CuboidBox[{5, 9, 13}], 
   CuboidBox[{6, 11, 16}], CuboidBox[{7, 13, 19}], CuboidBox[{8, 15, 22}], 
   CuboidBox[{9, 17, 25}], CuboidBox[{10, 19, 28}]},
  ImageMargins->0.,
  ImageSize->Small,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{125, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124071633,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192208867],

Cell["Fill in a plane of values into a 3D sparse array:", "ExampleText",
 CellID->217342277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "/@", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"SparseArray", "[", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"Table", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", "10", "}"}], ",", 
          RowBox[{"{", "10", "}"}]}], "]"}]}], "]"}], "]"}], ",", "x"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82153020],

Cell[BoxData[
 Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 2, 2}], 
   CuboidBox[{1, 3, 3}], CuboidBox[{1, 4, 4}], CuboidBox[{1, 5, 5}], 
   CuboidBox[{1, 6, 6}], CuboidBox[{1, 7, 7}], CuboidBox[{1, 8, 8}], 
   CuboidBox[{1, 9, 9}], CuboidBox[{1, 10, 10}], CuboidBox[{2, 1, 2}], 
   CuboidBox[{2, 2, 3}], CuboidBox[{2, 3, 4}], CuboidBox[{2, 4, 5}], 
   CuboidBox[{2, 5, 6}], CuboidBox[{2, 6, 7}], CuboidBox[{2, 7, 8}], 
   CuboidBox[{2, 8, 9}], CuboidBox[{2, 9, 10}], CuboidBox[{2, 10, 11}], 
   CuboidBox[{3, 1, 3}], CuboidBox[{3, 2, 4}], CuboidBox[{3, 3, 5}], 
   CuboidBox[{3, 4, 6}], CuboidBox[{3, 5, 7}], CuboidBox[{3, 6, 8}], 
   CuboidBox[{3, 7, 9}], CuboidBox[{3, 8, 10}], CuboidBox[{3, 9, 11}], 
   CuboidBox[{3, 10, 12}], CuboidBox[{4, 1, 4}], CuboidBox[{4, 2, 5}], 
   CuboidBox[{4, 3, 6}], CuboidBox[{4, 4, 7}], CuboidBox[{4, 5, 8}], 
   CuboidBox[{4, 6, 9}], CuboidBox[{4, 7, 10}], CuboidBox[{4, 8, 11}], 
   CuboidBox[{4, 9, 12}], CuboidBox[{4, 10, 13}], CuboidBox[{5, 1, 5}], 
   CuboidBox[{5, 2, 6}], CuboidBox[{5, 3, 7}], CuboidBox[{5, 4, 8}], 
   CuboidBox[{5, 5, 9}], CuboidBox[{5, 6, 10}], CuboidBox[{5, 7, 11}], 
   CuboidBox[{5, 8, 12}], CuboidBox[{5, 9, 13}], CuboidBox[{5, 10, 14}], 
   CuboidBox[{6, 1, 6}], CuboidBox[{6, 2, 7}], CuboidBox[{6, 3, 8}], 
   CuboidBox[{6, 4, 9}], CuboidBox[{6, 5, 10}], CuboidBox[{6, 6, 11}], 
   CuboidBox[{6, 7, 12}], CuboidBox[{6, 8, 13}], CuboidBox[{6, 9, 14}], 
   CuboidBox[{6, 10, 15}], CuboidBox[{7, 1, 7}], CuboidBox[{7, 2, 8}], 
   CuboidBox[{7, 3, 9}], CuboidBox[{7, 4, 10}], CuboidBox[{7, 5, 11}], 
   CuboidBox[{7, 6, 12}], CuboidBox[{7, 7, 13}], CuboidBox[{7, 8, 14}], 
   CuboidBox[{7, 9, 15}], CuboidBox[{7, 10, 16}], CuboidBox[{8, 1, 8}], 
   CuboidBox[{8, 2, 9}], CuboidBox[{8, 3, 10}], CuboidBox[{8, 4, 11}], 
   CuboidBox[{8, 5, 12}], CuboidBox[{8, 6, 13}], CuboidBox[{8, 7, 14}], 
   CuboidBox[{8, 8, 15}], CuboidBox[{8, 9, 16}], CuboidBox[{8, 10, 17}], 
   CuboidBox[{9, 1, 9}], CuboidBox[{9, 2, 10}], CuboidBox[{9, 3, 11}], 
   CuboidBox[{9, 4, 12}], CuboidBox[{9, 5, 13}], CuboidBox[{9, 6, 14}], 
   CuboidBox[{9, 7, 15}], CuboidBox[{9, 8, 16}], CuboidBox[{9, 9, 17}], 
   CuboidBox[{9, 10, 18}], CuboidBox[{10, 1, 10}], CuboidBox[{10, 2, 11}], 
   CuboidBox[{10, 3, 12}], CuboidBox[{10, 4, 13}], CuboidBox[{10, 5, 14}], 
   CuboidBox[{10, 6, 15}], CuboidBox[{10, 7, 16}], CuboidBox[{10, 8, 17}], 
   CuboidBox[{10, 9, 18}], CuboidBox[{10, 10, 19}]},
  ImageMargins->0.,
  ImageSize->Small,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{142, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10009343,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28356],

Cell["Make a tridiagonal matrix:", "ExampleText",
 CellID->115143986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "a"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "b"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "c"}]}], "}"}], 
    ",", "5"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891302092],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"b", "c", "0", "0", "0"},
     {"a", "b", "c", "0", "0"},
     {"0", "a", "b", "c", "0"},
     {"0", "0", "a", "b", "c"},
     {"0", "0", "0", "a", "b"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 2, 5, 8, 11, 13}, {{2}, {1}, {2}, {3}, {1}, {3}, {4}, {2}, {4}, {
       5}, {3}, {4}, {
       5}}}, {$CellContext`c, $CellContext`b, $CellContext`b, $CellContext`c, \
$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`a, $CellContext`a, \
$CellContext`b}}]]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->93253892]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95519218],

Cell["Build a tridiagonal linear system:", "ExampleText",
 CellID->197721738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "a"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "b"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "c"}]}], "}"}], 
    ",", "5"}], "]"}], ".", 
  RowBox[{"Array", "[", 
   RowBox[{"x", ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299785946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", 
     RowBox[{"x", "[", "1", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "[", "2", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "[", "1", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "[", "2", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "[", "3", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "[", "2", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "[", "3", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "[", "4", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "[", "3", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "[", "4", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "[", "5", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "[", "4", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "[", "5", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{408, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41727144]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23917],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Band",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Band"]], "InlineFormula"],
 " works in ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 "; use ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " to convert to normal lists:"
}], "ExampleText",
 CellID->32246847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Band", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "x"}], ",", 
     RowBox[{
      RowBox[{"Band", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "y"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493712321],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "9", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 9, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121317153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->383475961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "y", ",", "x", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "y", ",", "x", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "y", ",", "x"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->242855204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->620992124],

Cell[TextData[{
 "The simplest case of ",
 Cell[BoxData[
  ButtonBox["Band",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Band"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["DiagonalMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->225682700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], "]"}], "//",
   "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80169501],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "0", "0", "0", "0"},
     {"0", "b", "0", "0", "0"},
     {"0", "0", "c", "0", "0"},
     {"0", "0", "0", "d", "0"},
     {"0", "0", "0", "0", "e"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->245985058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"Band", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], "]"}], "//",
   "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121014745],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "0", "0", "0", "0"},
     {"0", "b", "0", "0", "0"},
     {"0", "0", "c", "0", "0"},
     {"0", "0", "0", "d", "0"},
     {"0", "0", "0", "0", "e"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "Rows" -> {0.2, {0.4}, 0.2}}], 
   "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 1, 2, 3, 4, 5}, {{1}, {2}, {3}, {4}, {
       5}}}, {$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`e}}]]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->227408167]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54469056]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24743],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiagonalMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiagonalMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Span",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Span"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Diagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Diagonal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7741]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25813],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->2230],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->30248],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->126766972],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->753479739],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->399070],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->92712870],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->21208569],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->97682450]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Band - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 36.6761098}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Band[{i, j}] represents the sequence of positions on the diagonal band \
that starts with {i, j} in a sparse array. Band[{i_min, j_min, ...}, {i_max, \
j_max, ...}] represents the positions between {i_min, j_min, ...} and {i_max, \
j_max, ...}. Band[{i_min, j_min, ...}, {i_max, j_max, ...}, {di, dj, ...}] \
represents positions starting with {i_min, j_min, ...} and then moving with \
step {di, dj, ...}.", "synonyms" -> {}, "title" -> "Band", "type" -> "Symbol",
     "uri" -> "ref/Band"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15602, 513, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->92236471]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70782, 2208}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3481, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4104, 101, 1569, 37, 70, "ObjectNameGrid"],
Cell[5676, 140, 3832, 124, 70, "Usage",
 CellID->12351]
}, Open  ]],
Cell[CellGroupData[{
Cell[9545, 269, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10023, 286, 379, 14, 70, "Notes",
 CellID->6923],
Cell[10405, 302, 638, 24, 70, "Notes",
 CellID->7118],
Cell[11046, 328, 493, 18, 70, "Notes",
 CellID->31550],
Cell[11542, 348, 616, 22, 70, "Notes",
 CellID->2097],
Cell[12161, 372, 579, 22, 70, "Notes",
 CellID->11836],
Cell[12743, 396, 628, 24, 70, "Notes",
 CellID->10591],
Cell[13374, 422, 415, 15, 70, "Notes",
 CellID->13406],
Cell[13792, 439, 676, 26, 70, "Notes",
 CellID->4510],
Cell[14471, 467, 394, 13, 70, "Notes",
 CellID->281249886],
Cell[14868, 482, 697, 26, 70, "Notes",
 CellID->63620143]
}, Closed]],
Cell[CellGroupData[{
Cell[15602, 513, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92236471],
Cell[CellGroupData[{
Cell[15986, 527, 148, 5, 70, "ExampleSection",
 CellID->823247460],
Cell[16137, 534, 69, 1, 70, "ExampleText",
 CellID->76326],
Cell[CellGroupData[{
Cell[16231, 539, 526, 18, 28, "Input",
 CellID->69978601],
Cell[16760, 559, 1089, 22, 108, "Output",
 Evaluatable->False,
 CellID->263139086]
}, Open  ]],
Cell[17864, 584, 66, 1, 70, "ExampleText",
 CellID->56295398],
Cell[CellGroupData[{
Cell[17955, 589, 102, 3, 70, "Input",
 CellID->172647432],
Cell[18060, 594, 632, 18, 36, "Output",
 CellID->177231698]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18741, 618, 217, 7, 70, "ExampleSection",
 CellID->24514],
Cell[18961, 627, 344, 13, 70, "ExampleText",
 CellID->190835228],
Cell[CellGroupData[{
Cell[19330, 644, 484, 16, 70, "Input",
 CellID->508265366],
Cell[19817, 662, 974, 20, 70, "Output",
 Evaluatable->False,
 CellID->52935072]
}, Open  ]],
Cell[20806, 685, 125, 3, 70, "ExampleDelimiter",
 CellID->398569332],
Cell[20934, 690, 87, 1, 70, "ExampleText",
 CellID->178408108],
Cell[CellGroupData[{
Cell[21046, 695, 398, 13, 70, "Input",
 CellID->357673702],
Cell[21447, 710, 739, 24, 108, "Output",
 CellID->84465292]
}, Open  ]],
Cell[22201, 737, 125, 3, 70, "ExampleDelimiter",
 CellID->313781650],
Cell[22329, 742, 72, 1, 70, "ExampleText",
 CellID->327729340],
Cell[CellGroupData[{
Cell[22426, 747, 483, 16, 70, "Input",
 CellID->19059945],
Cell[22912, 765, 782, 24, 108, "Output",
 CellID->446495099]
}, Open  ]],
Cell[23709, 792, 125, 3, 70, "ExampleDelimiter",
 CellID->456452117],
Cell[23837, 797, 88, 1, 70, "ExampleText",
 CellID->158699571],
Cell[CellGroupData[{
Cell[23950, 802, 334, 11, 70, "Input",
 CellID->13205183],
Cell[24287, 815, 740, 24, 108, "Output",
 CellID->334821871]
}, Open  ]],
Cell[25042, 842, 125, 3, 70, "ExampleDelimiter",
 CellID->218758912],
Cell[25170, 847, 79, 1, 70, "ExampleText",
 CellID->162314312],
Cell[CellGroupData[{
Cell[25274, 852, 420, 14, 70, "Input",
 CellID->35646345],
Cell[25697, 868, 740, 24, 108, "Output",
 CellID->800959095]
}, Open  ]],
Cell[26452, 895, 125, 3, 70, "ExampleDelimiter",
 CellID->359255213],
Cell[26580, 900, 82, 1, 70, "ExampleText",
 CellID->477190748],
Cell[CellGroupData[{
Cell[26687, 905, 436, 15, 70, "Input",
 CellID->228027596],
Cell[27126, 922, 738, 24, 108, "Output",
 CellID->6036175]
}, Open  ]],
Cell[27879, 949, 125, 3, 70, "ExampleDelimiter",
 CellID->115121617],
Cell[28007, 954, 64, 1, 70, "ExampleText",
 CellID->451494755],
Cell[CellGroupData[{
Cell[28096, 959, 487, 16, 70, "Input",
 CellID->99576899],
Cell[28586, 977, 739, 24, 108, "Output",
 CellID->63108112]
}, Open  ]],
Cell[29340, 1004, 101, 2, 70, "ExampleText",
 CellID->85042583],
Cell[CellGroupData[{
Cell[29466, 1010, 437, 14, 70, "Input",
 CellID->2313214],
Cell[29906, 1026, 740, 24, 108, "Output",
 CellID->274986009]
}, Open  ]],
Cell[30661, 1053, 125, 3, 70, "ExampleDelimiter",
 CellID->151481095],
Cell[30789, 1058, 80, 1, 70, "ExampleText",
 CellID->528628135],
Cell[CellGroupData[{
Cell[30894, 1063, 439, 14, 70, "Input",
 CellID->403655273],
Cell[31336, 1079, 739, 24, 108, "Output",
 CellID->14232645]
}, Open  ]],
Cell[32090, 1106, 124, 3, 70, "ExampleDelimiter",
 CellID->64779127],
Cell[32217, 1111, 88, 1, 70, "ExampleText",
 CellID->34929309],
Cell[CellGroupData[{
Cell[32330, 1116, 502, 17, 70, "Input",
 CellID->219036098],
Cell[32835, 1135, 761, 24, 108, "Output",
 CellID->142110163]
}, Open  ]],
Cell[33611, 1162, 125, 3, 70, "ExampleDelimiter",
 CellID->439957525],
Cell[33739, 1167, 73, 1, 70, "ExampleText",
 CellID->4220784],
Cell[CellGroupData[{
Cell[33837, 1172, 620, 21, 70, "Input",
 CellID->233388419],
Cell[34460, 1195, 868, 25, 108, "Output",
 CellID->232655931]
}, Open  ]],
Cell[35343, 1223, 87, 1, 70, "ExampleText",
 CellID->2503275],
Cell[CellGroupData[{
Cell[35455, 1228, 710, 24, 70, "Input",
 CellID->222629235],
Cell[36168, 1254, 868, 25, 108, "Output",
 CellID->982742534]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37085, 1285, 239, 7, 70, "ExampleSection",
 CellID->19785],
Cell[37327, 1294, 204, 7, 70, "ExampleText",
 CellID->94950818],
Cell[CellGroupData[{
Cell[37556, 1305, 535, 17, 70, "Input",
 CellID->353354589],
Cell[38094, 1324, 4439, 80, 216, 426, 10, "CachedBoxData", "BoxData", \
"Output",
 CellID->108260319]
}, Open  ]],
Cell[CellGroupData[{
Cell[42570, 1409, 661, 20, 70, "Input",
 CellID->99413155],
Cell[43234, 1431, 3465, 64, 237, 436, 10, "CachedBoxData", "BoxData", \
"Output",
 CellID->124071633]
}, Open  ]],
Cell[46714, 1498, 125, 3, 70, "ExampleDelimiter",
 CellID->192208867],
Cell[46842, 1503, 92, 1, 70, "ExampleText",
 CellID->217342277],
Cell[CellGroupData[{
Cell[46959, 1508, 562, 17, 70, "Input",
 CellID->82153020],
Cell[47524, 1527, 8363, 139, 237, 2598, 40, "CachedBoxData", "BoxData", \
"Output",
 CellID->10009343]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55936, 1672, 223, 7, 70, "ExampleSection",
 CellID->28356],
Cell[56162, 1681, 69, 1, 70, "ExampleText",
 CellID->115143986],
Cell[CellGroupData[{
Cell[56256, 1686, 614, 20, 70, "Input",
 CellID->891302092],
Cell[56873, 1708, 963, 27, 108, "Output",
 CellID->93253892]
}, Open  ]],
Cell[57851, 1738, 124, 3, 70, "ExampleDelimiter",
 CellID->95519218],
Cell[57978, 1743, 77, 1, 70, "ExampleText",
 CellID->197721738],
Cell[CellGroupData[{
Cell[58080, 1748, 660, 22, 70, "Input",
 CellID->299785946],
Cell[58743, 1772, 1108, 38, 54, "Output",
 CellID->30352]
}, Open  ]],
Cell[59866, 1813, 124, 3, 70, "ExampleDelimiter",
 CellID->41727144]
}, Closed]],
Cell[CellGroupData[{
Cell[60027, 1821, 233, 7, 70, "ExampleSection",
 CellID->23917],
Cell[60263, 1830, 462, 17, 70, "ExampleText",
 CellID->32246847],
Cell[CellGroupData[{
Cell[60750, 1851, 480, 17, 70, "Input",
 CellID->493712321],
Cell[61233, 1870, 479, 17, 36, "Output",
 CellID->121317153]
}, Open  ]],
Cell[CellGroupData[{
Cell[61749, 1892, 102, 3, 70, "Input",
 CellID->383475961],
Cell[61854, 1897, 632, 18, 36, "Output",
 CellID->242855204]
}, Open  ]],
Cell[62501, 1918, 125, 3, 70, "ExampleDelimiter",
 CellID->620992124],
Cell[62629, 1923, 350, 13, 70, "ExampleText",
 CellID->225682700],
Cell[CellGroupData[{
Cell[63004, 1940, 224, 7, 70, "Input",
 CellID->80169501],
Cell[63231, 1949, 598, 19, 108, "Output",
 CellID->245985058]
}, Open  ]],
Cell[CellGroupData[{
Cell[63866, 1973, 340, 11, 70, "Input",
 CellID->121014745],
Cell[64209, 1986, 782, 24, 108, "Output",
 CellID->227408167]
}, Open  ]],
Cell[65006, 2013, 124, 3, 70, "ExampleDelimiter",
 CellID->54469056]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65179, 2022, 311, 9, 70, "SeeAlsoSection",
 CellID->24743],
Cell[65493, 2033, 1924, 71, 70, "SeeAlso",
 CellID->7741]
}, Open  ]],
Cell[CellGroupData[{
Cell[67454, 2109, 314, 9, 70, "TutorialsSection",
 CellID->25813],
Cell[67771, 2120, 151, 3, 70, "Tutorials",
 CellID->2230],
Cell[67925, 2125, 149, 3, 70, "Tutorials",
 CellID->30248],
Cell[68077, 2130, 129, 3, 70, "Tutorials",
 CellID->493403696]
}, Open  ]],
Cell[CellGroupData[{
Cell[68243, 2138, 319, 9, 70, "MoreAboutSection",
 CellID->126766972],
Cell[68565, 2149, 153, 3, 70, "MoreAbout",
 CellID->753479739],
Cell[68721, 2154, 153, 3, 70, "MoreAbout",
 CellID->399070],
Cell[68877, 2159, 163, 3, 70, "MoreAbout",
 CellID->92712870],
Cell[69043, 2164, 178, 3, 70, "MoreAbout",
 CellID->21208569],
Cell[69224, 2169, 197, 4, 70, "MoreAbout",
 CellID->97682450]
}, Open  ]],
Cell[69436, 2176, 27, 0, 70, "History"],
Cell[69466, 2178, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

