(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34950,        957]
NotebookOptionsPosition[     30734,        818]
NotebookOutlinePosition[     32101,        856]
CellTagsIndexPosition[     32016,        851]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"], 
          "Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Tables and Matrices\"\>", 
       2->"\<\"Formatted Output\"\>", 3->"\<\"Options for Graphics\"\>", 
       4->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Style" :> Documentation`HelpLookup["paclet:ref/Style"], 
          "LabelStyle" :> Documentation`HelpLookup["paclet:ref/LabelStyle"], 
          "FormatType" :> 
          Documentation`HelpLookup["paclet:ref/FormatType"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Style\"\>", 2->"\<\"LabelStyle\"\>",
        3->"\<\"FormatType\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Styling in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsStylingInNotebooks"],
           "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Controls Options\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>", 
       3->"\<\"Graphics Styling in Notebooks\"\>", 
       4->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BaseStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["BaseStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for formatting and related constructs \
that specifies the base style to use for them. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option setting ",
 Cell[BoxData[
  RowBox[{"BaseStyle", "->", 
   StyleBox["spec", "TI"]}]], "InlineFormula"],
 " in a construct ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 " specifies that the construct should always automatically be displayed as \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->443689268],

Cell[TextData[{
 "Any style specification as used in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " can be used as a setting for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17692],

Cell["Typical forms of settings include: ", "Notes",
 CellID->21787],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", Cell[
    "a named style from the current stylesheets ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["opt", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "a list of explicit option settings ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["opt", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "a named style modified by option settings ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->28532],

Cell[TextData[{
 "Color directives such as ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", as well as text specifications such as ",
 Cell[BoxData[
  ButtonBox["Bold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bold"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", can be given in place of options, just as in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30556],

Cell[TextData[{
 "Any outside styles not explicitly overridden by settings in ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " will still be used."
}], "Notes",
 CellID->3447],

Cell[TextData[{
 "Style specifications given in ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are typically added to default specifications given in the current \
stylesheet."
}], "Notes",
 CellID->76966315],

Cell[TextData[{
 "For an object of type ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ", the default style specifications are typically those associated with a \
style named ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"obj\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->57919065]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->576210327],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->165522591],

Cell["Set the starting style: ", "ExampleText",
 CellID->65039657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "]"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323696755],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], DiskBox[{3, 0}]},
  BaseStyle->RGBColor[0, 0, 1]]], "Output",
 ImageSize->{184, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11790520]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"BaseStyle", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74506459],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], CylinderBox[{{3, 0, -1}, {3, 0, 1}}]},
  BaseStyle->RGBColor[1, 1, 0]]], "Output",
 ImageSize->{184, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81183992,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360737958],

Cell["Use a named style: ", "ExampleText",
 CellID->682617663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"InputField", "[", 
      RowBox[{"\"\<name\>\"", ",", "String"}], "]"}], ",", 
     RowBox[{"InputField", "[", 
      RowBox[{"0", ",", "Number"}], "]"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "\"\<Panel\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94628193],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = "name"}, 
       InputFieldBox[Dynamic[Typeset`i$$], String],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], String]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = 0}, 
       InputFieldBox[Dynamic[Typeset`i$$], Number],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], Number]& ]}
   },
   BaseStyle->"Panel",
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{174, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139024126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489687695],

Cell["Set multiple font option settings:", "ExampleText",
 CellID->51209257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xyz", ",", "\"\<ABC\>\""}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Large", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", "Italic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57419728],

Cell[BoxData[
 TagBox[GridBox[{
    {"xyz"},
    {"\<\"ABC\"\>"}
   },
   BaseStyle->{Large, FontFamily -> "Times", Italic},
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{51, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97549678]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28583],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LabelStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LabelStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FormatType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormatType"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18283],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->444657240],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->9816535],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->206144],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->449316805],

Cell[TextData[ButtonBox["Graphics Styling in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsStylingInNotebooks"]], "MoreAbout",
 CellID->352117192],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->171802920]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BaseStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 38.8324150}", "context" -> "System`", 
    "keywords" -> {
     "base appearance", "default appearance", "default style", 
      "root element appearance", "root element style"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BaseStyle is an option for formatting and related constructs that \
specifies the base style to use for them. ", "synonyms" -> {"base style"}, 
    "title" -> "BaseStyle", "type" -> "Symbol", "uri" -> "ref/BaseStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10001, 309, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->576210327]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31872, 844}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2924, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3547, 93, 1574, 37, 70, "ObjectNameGrid"],
Cell[5124, 132, 486, 14, 70, "Usage",
 CellID->11367]
}, Open  ]],
Cell[CellGroupData[{
Cell[5647, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6125, 168, 545, 20, 70, "Notes",
 CellID->443689268],
Cell[6673, 190, 358, 13, 70, "Notes",
 CellID->17692],
Cell[7034, 205, 68, 1, 70, "Notes",
 CellID->21787],
Cell[7105, 208, 1365, 38, 70, "2ColumnTableMod",
 CellID->28532],
Cell[8473, 248, 632, 23, 70, "Notes",
 CellID->30556],
Cell[9108, 273, 253, 8, 70, "Notes",
 CellID->3447],
Cell[9364, 283, 288, 9, 70, "Notes",
 CellID->76966315],
Cell[9655, 294, 309, 10, 70, "Notes",
 CellID->57919065]
}, Closed]],
Cell[CellGroupData[{
Cell[10001, 309, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->576210327],
Cell[CellGroupData[{
Cell[10386, 323, 148, 5, 70, "ExampleSection",
 CellID->165522591],
Cell[10537, 330, 66, 1, 70, "ExampleText",
 CellID->65039657],
Cell[CellGroupData[{
Cell[10628, 335, 455, 15, 28, "Input",
 CellID->323696755],
Cell[11086, 352, 238, 7, 98, "Output",
 CellID->11790520]
}, Open  ]],
Cell[CellGroupData[{
Cell[11361, 364, 512, 17, 28, "Input",
 CellID->74506459],
Cell[11876, 383, 13308, 222, 154, 134, 2, "CachedBoxData", "BoxData", \
"Output",
 CellID->81183992]
}, Open  ]],
Cell[25199, 608, 125, 3, 70, "ExampleDelimiter",
 CellID->360737958],
Cell[25327, 613, 62, 1, 70, "ExampleText",
 CellID->682617663],
Cell[CellGroupData[{
Cell[25414, 618, 378, 11, 70, "Input",
 CellID->94628193],
Cell[25795, 631, 780, 27, 70, "Output",
 CellID->139024126]
}, Open  ]],
Cell[26590, 661, 125, 3, 70, "ExampleDelimiter",
 CellID->489687695],
Cell[26718, 666, 76, 1, 70, "ExampleText",
 CellID->51209257],
Cell[CellGroupData[{
Cell[26819, 671, 353, 11, 70, "Input",
 CellID->57419728],
Cell[27175, 684, 444, 15, 78, "Output",
 CellID->97549678]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27680, 706, 311, 9, 70, "SeeAlsoSection",
 CellID->28583],
Cell[27994, 717, 698, 26, 70, "SeeAlso",
 CellID->26948]
}, Open  ]],
Cell[CellGroupData[{
Cell[28729, 748, 314, 9, 70, "TutorialsSection",
 CellID->18283],
Cell[29046, 759, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[29196, 764, 146, 3, 70, "Tutorials",
 CellID->444657240],
Cell[29345, 769, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[29486, 774, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[29680, 782, 317, 9, 70, "MoreAboutSection",
 CellID->9816535],
Cell[30000, 793, 140, 3, 70, "MoreAbout",
 CellID->206144],
Cell[30143, 798, 175, 3, 70, "MoreAbout",
 CellID->449316805],
Cell[30321, 803, 167, 3, 70, "MoreAbout",
 CellID->352117192],
Cell[30491, 808, 171, 3, 70, "MoreAbout",
 CellID->171802920]
}, Open  ]],
Cell[30677, 814, 27, 0, 70, "History"],
Cell[30707, 816, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

