(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10313,        379]
NotebookOptionsPosition[      7423,        284]
NotebookOutlinePosition[      8762,        322]
CellTagsIndexPosition[      8678,        317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Center" :> Documentation`HelpLookup["paclet:ref/Center"], 
         "Axis" :> Documentation`HelpLookup["paclet:ref/Axis"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Center\"\>", 
      2->"\<\"Axis\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Baseline", "ObjectName",
 CellID->8001],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Baseline",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Baseline"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that represents the baseline for purposes \
of alignment and positioning. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The baseline of a font character is typically the bottom of the character, \
excluding any descenders.\
\>", "Notes",
 CellID->32487]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->261456493],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->104910051],

Cell["Align the contents of a grid by their baseline:", "ExampleText",
 CellID->94306447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      SqrtBox["x"], ",", "b", ",", 
      FractionBox["x", "y"], ",", "c"}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Baseline"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "All"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176068346],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", 
     SqrtBox["x"], "b", 
     FractionBox["x", "y"], "c"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Automatic}}, "Rows" -> {{Baseline}}},
   GridBoxFrame->{"Columns" -> True, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{102, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87977489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91973617],

Cell["\<\
Align the baseline of the second row of a grid with the baseline of the \
surrounding text:\
\>", "ExampleText",
 CellID->133074856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "Baseline"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "y"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->570395130],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->{2, Baseline},
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6818250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->452423766],

Cell["\<\
Align the baseline of text to the center of the enclosing graphic:\
\>", "ExampleText",
 CellID->125552549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", "Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Baseline"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209953326],

Cell[BoxData[
 GraphicsBox[{
   InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.5}], {Automatic, Baseline}],
    CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->191647144]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15863],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axis"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27327]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Baseline - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 37.6448846}", "context" -> "System`", 
    "keywords" -> {
     "baseline alignment", "baseline of fonts", "baseline of formulas", 
      "baseline of tables", "alignment of tables"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Baseline is a symbol that represents the baseline for purposes of \
alignment and positioning. ", "synonyms" -> {}, "title" -> "Baseline", "type" -> 
    "Symbol", "uri" -> "ref/Baseline"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2469, 90, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->261456493]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8536, 310}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 633, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1256, 42, 45, 1, 70, "ObjectName",
 CellID->8001],
Cell[1304, 45, 470, 14, 70, "Usage",
 CellID->22015]
}, Open  ]],
Cell[CellGroupData[{
Cell[1811, 64, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2289, 81, 143, 4, 70, "Notes",
 CellID->32487]
}, Closed]],
Cell[CellGroupData[{
Cell[2469, 90, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->261456493],
Cell[CellGroupData[{
Cell[2854, 104, 148, 5, 70, "ExampleSection",
 CellID->104910051],
Cell[3005, 111, 89, 1, 70, "ExampleText",
 CellID->94306447],
Cell[CellGroupData[{
Cell[3119, 116, 473, 15, 42, "Input",
 CellID->176068346],
Cell[3595, 133, 512, 16, 52, "Output",
 CellID->87977489]
}, Open  ]],
Cell[4122, 152, 124, 3, 70, "ExampleDelimiter",
 CellID->91973617],
Cell[4249, 157, 142, 4, 70, "ExampleText",
 CellID->133074856],
Cell[CellGroupData[{
Cell[4416, 165, 508, 17, 70, "Input",
 CellID->570395130],
Cell[4927, 184, 512, 17, 57, "Output",
 CellID->6818250]
}, Open  ]],
Cell[5454, 204, 125, 3, 70, "ExampleDelimiter",
 CellID->452423766],
Cell[5582, 209, 117, 3, 70, "ExampleText",
 CellID->125552549],
Cell[CellGroupData[{
Cell[5724, 216, 454, 13, 70, "Input",
 CellID->209953326],
Cell[6181, 231, 356, 11, 121, "Output",
 CellID->191647144]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6598, 249, 311, 9, 70, "SeeAlsoSection",
 CellID->15863],
Cell[6912, 260, 439, 17, 70, "SeeAlso",
 CellID->27327]
}, Open  ]],
Cell[7366, 280, 27, 0, 70, "History"],
Cell[7396, 282, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

