(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13713,        457]
NotebookOptionsPosition[     10958,        364]
NotebookOutlinePosition[     12117,        399]
CellTagsIndexPosition[     12032,        394]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfSound"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Representation of Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EmitSound" :> Documentation`HelpLookup["paclet:ref/EmitSound"],
           "Play" :> Documentation`HelpLookup["paclet:ref/Play"], "SoundNote" :> 
          Documentation`HelpLookup["paclet:ref/SoundNote"], "Monitor" :> 
          Documentation`HelpLookup["paclet:ref/Monitor"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"], "MessageDialog" :> 
          Documentation`HelpLookup["paclet:ref/MessageDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EmitSound\"\>", 2->"\<\"Play\"\>", 
       3->"\<\"SoundNote\"\>", 4->"\<\"Monitor\"\>", 5->"\<\"Message\"\>", 
       6->"\<\"MessageDialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], "Messages" :> 
          Documentation`HelpLookup["paclet:guide/Messages"], 
          "Sound and Sonification" :> 
          Documentation`HelpLookup["paclet:guide/SoundAndSonification"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 2->"\<\"Messages\"\>", 
       3->"\<\"Sound and Sonification\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Beep", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Beep",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Beep"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]generates an audible beep when evaluated. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23668]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Beep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beep"]], "InlineFormula"],
 " generates sound through the notebook front end. "
}], "Notes",
 CellID->9359]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52051644],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->163134533],

Cell["Make a beep:", "ExampleText",
 CellID->26913],

Cell[BoxData[
 RowBox[{"Beep", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17431]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29122],

Cell["Beep before each calculation:", "ExampleText",
 CellID->25260],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Beep", "[", "]"}], ";", 
     RowBox[{"FactorInteger", "[", 
      RowBox[{
       RowBox[{"2", "^", 
        RowBox[{"(", 
         RowBox[{"50", "i"}], ")"}]}], "-", "1"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13883]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24332],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EmitSound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EmitSound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Play",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Play"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SoundNote",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SoundNote"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21866]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6395],

Cell[TextData[ButtonBox["The Representation of Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfSound"]], "Tutorials",
 CellID->9642]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->95978074],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->328061975],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->201238875],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "MoreAbout",
 CellID->43790382],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->549337352]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Beep - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 39.6293104}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Beep[] generates an audible beep when evaluated. ", "synonyms" -> {}, 
    "title" -> "Beep", "type" -> "Symbol", "uri" -> "ref/Beep"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6165, 176, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->52051644]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11890, 387}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2764, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3387, 89, 1569, 37, 70, "ObjectNameGrid"],
Cell[4959, 128, 447, 14, 70, "Usage",
 CellID->23668]
}, Open  ]],
Cell[CellGroupData[{
Cell[5443, 147, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5921, 164, 207, 7, 70, "Notes",
 CellID->9359]
}, Closed]],
Cell[CellGroupData[{
Cell[6165, 176, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52051644],
Cell[CellGroupData[{
Cell[6549, 190, 148, 5, 70, "ExampleSection",
 CellID->163134533],
Cell[6700, 197, 51, 1, 70, "ExampleText",
 CellID->26913],
Cell[6754, 200, 91, 3, 70, "Input",
 CellID->17431]
}, Open  ]],
Cell[CellGroupData[{
Cell[6882, 208, 223, 7, 70, "ExampleSection",
 CellID->29122],
Cell[7108, 217, 68, 1, 70, "ExampleText",
 CellID->25260],
Cell[7179, 220, 397, 14, 70, "Input",
 CellID->13883]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7625, 240, 311, 9, 70, "SeeAlsoSection",
 CellID->24332],
Cell[7939, 251, 1433, 53, 70, "SeeAlso",
 CellID->21866]
}, Open  ]],
Cell[CellGroupData[{
Cell[9409, 309, 313, 9, 70, "TutorialsSection",
 CellID->6395],
Cell[9725, 320, 161, 3, 70, "Tutorials",
 CellID->9642]
}, Open  ]],
Cell[CellGroupData[{
Cell[9923, 328, 318, 9, 70, "MoreAboutSection",
 CellID->95978074],
Cell[10244, 339, 173, 3, 70, "MoreAbout",
 CellID->328061975],
Cell[10420, 344, 128, 3, 70, "MoreAbout",
 CellID->201238875],
Cell[10551, 349, 153, 3, 70, "MoreAbout",
 CellID->43790382],
Cell[10707, 354, 179, 3, 70, "MoreAbout",
 CellID->549337352]
}, Open  ]],
Cell[10901, 360, 27, 0, 70, "History"],
Cell[10931, 362, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

