(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9997,        366]
NotebookOptionsPosition[      6993,        268]
NotebookOutlinePosition[      8348,        306]
CellTagsIndexPosition[      8264,        301]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EndDialogPacket" :> 
          Documentation`HelpLookup["paclet:ref/EndDialogPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EndDialogPacket\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BeginDialogPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BeginDialogPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BeginDialogPacket"], "[", 
       StyleBox["integer", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet that indicates the start of the ",
     Cell[BoxData[
      ButtonBox["Dialog",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
     " subsession referenced by ",
     Cell[BoxData[
      StyleBox["integer", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->663584992],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->1215824468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312144257],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "280", ",", "7"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598890214]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->625050465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2053461425],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138802497]
}, Open  ]],

Cell[TextData[{
 "Write the packet representing the text ",
 Cell[BoxData["\"\<Dialog[]\>\""], "InlineFormula"],
 " to enter:"
}], "ExampleText",
 CellID->316479038],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<Dialog[]\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1893681694],

Cell[TextData[{
 "Read the ",
 Cell[BoxData[
  ButtonBox["BeginDialogPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginDialogPacket"]], "InlineFormula"],
 " expression indicating the start of a dialog subsession:"
}], "ExampleText",
 CellID->1400582518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1420596703],

Cell[BoxData[
 RowBox[{"BeginDialogPacket", "[", "1", "]"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->554367545]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1054932471],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EndDialogPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndDialogPacket"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BeginDialogPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 39.9886946}", "context" -> "System`", 
    "keywords" -> {
     "MathLink packet", "begin dialog packet", "subsession packet"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BeginDialogPacket[integer] is a MathLink packet that indicates the start \
of the Dialog subsession referenced by integer.", 
    "synonyms" -> {"begin dialog packet"}, "title" -> "BeginDialogPacket", 
    "type" -> "Symbol", "uri" -> "ref/BeginDialogPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2811, 94, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8130, 294}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1262, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1885, 60, 60, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1948, 63, 826, 26, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2811, 94, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3188, 108, 148, 5, 70, "ExampleSection",
 CellID->663584992],
Cell[3339, 115, 149, 6, 70, "ExampleText",
 CellID->1215824468],
Cell[CellGroupData[{
Cell[3513, 125, 234, 7, 28, "Input",
 CellID->312144257],
Cell[3750, 134, 260, 8, 36, "Output",
 CellID->598890214]
}, Open  ]],
Cell[4025, 145, 65, 1, 70, "ExampleText",
 CellID->625050465],
Cell[CellGroupData[{
Cell[4115, 150, 108, 3, 28, "Input",
 CellID->2053461425],
Cell[4226, 155, 215, 6, 36, "Output",
 CellID->138802497]
}, Open  ]],
Cell[4456, 164, 165, 5, 70, "ExampleText",
 CellID->316479038],
Cell[4624, 171, 193, 6, 70, "Input",
 CellID->1893681694],
Cell[4820, 179, 266, 8, 70, "ExampleText",
 CellID->1400582518],
Cell[CellGroupData[{
Cell[5111, 191, 108, 3, 70, "Input",
 CellID->1420596703],
Cell[5222, 196, 202, 6, 36, "Output",
 CellID->554367545]
}, Open  ]],
Cell[5439, 205, 59, 1, 70, "ExampleText",
 CellID->1054932471],
Cell[5501, 208, 109, 3, 70, "Input",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5659, 217, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[5978, 228, 214, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[6229, 239, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[6550, 250, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[6936, 264, 27, 0, 70, "History"],
Cell[6966, 266, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

