(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20779,        738]
NotebookOptionsPosition[     15706,        570]
NotebookOutlinePosition[     17424,        616]
CellTagsIndexPosition[     17298,        610]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"], 
          "Setting Up Mathematica Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpMathematicaPackages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematica Packages\"\>", 
       2->"\<\"Setting Up Mathematica Packages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EndPackage" :> 
          Documentation`HelpLookup["paclet:ref/EndPackage"], "Begin" :> 
          Documentation`HelpLookup["paclet:ref/Begin"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EndPackage\"\>", 
       2->"\<\"Begin\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Namespace Management\"\>", 
       2->"\<\"Package Bulletproofing\"\>", 
       3->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BeginPackage", "ObjectName",
 CellID->24966],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BeginPackage",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BeginPackage"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]makes ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["context", "TI"], "`"}]]], "InlineFormula"],
     " and ",
     Cell[BoxData["System`"], "InlineFormula"],
     " the only active contexts. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BeginPackage",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BeginPackage"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"need\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)`\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"need\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)`\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]calls ",
     Cell[BoxData[
      ButtonBox["Needs",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Needs"]], "InlineFormula"],
     " on the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["need", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21067]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " is typically used at the beginning of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package. "
}], "Notes",
 CellID->15778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " resets the values of both ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1173],

Cell[TextData[{
 "The interpretation of symbol names depends on context. ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " thus affects the parsing of input expressions. "
}], "Notes",
 CellID->3843]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177264638],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->657021756],

Cell["Commands to define a simple package:", "ExampleText",
 CellID->135240015],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", "\"\<square`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216743888],

Cell[TextData[{
 "The context for symbol creation and has been changed to ",
 Cell[BoxData["square`"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4940055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30309271],

Cell[BoxData["\<\"square`\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90578355]
}, Open  ]],

Cell[TextData[{
 "The context path for symbol lookup includes ",
 Cell[BoxData["square`"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4671383],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[3]:=",
 CellID->213616284],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"square`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5930937]
}, Open  ]],

Cell["Here are the commands defining the function in the package:", \
"ExampleText",
 CellID->3753811],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"square", "::", "usage"}], "=", "\"\<square[x] gives x^2\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->206922758],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"square", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->122955943],

Cell[TextData[{
 "Restore the context, but leave ",
 Cell[BoxData["square`"], "InlineFormula"],
 " on the context path for symbol lookup:"
}], "ExampleText",
 CellID->890268628],

Cell[BoxData[
 RowBox[{"EndPackage", "[", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->493486123],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " leaves ",
 Cell[BoxData["square`square"], "InlineFormula"],
 " on the context path, the function defined is visible:"
}], "ExampleText",
 CellID->610051904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "square"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->113564403],

Cell[BoxData[
 StyleBox["\<\"square[x] gives x^2\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3384172910-1686632",
 CellID->186564675]
}, Open  ]],

Cell["Get the square of 12:", "ExampleText",
 CellID->795895584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"square", "[", "12", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->142942269],

Cell[BoxData["144"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->527365391]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21661],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " to start and end a package in a file:"
}], "ExampleText",
 CellID->22834368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/Collatz.m\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767735881],

Cell["\<\
BeginPackage[\"Collatz`\"]

Collatz::usage =
        \"Collatz[n] gives a list of the iterates in the 3n+1 problem,
        starting from n. The conjecture is that this sequence always
        terminates.\"

Begin[\"`Private`\"]

Collatz[1] := {1}

Collatz[n_Integer]  := Prepend[Collatz[3 n + 1], n] /; OddQ[n] && n > 0

Collatz[n_Integer] := Prepend[Collatz[n/2], n] /; EvenQ[n] && n > 0

End[ ]

EndPackage[ ]\
\>", "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->132533267]
}, Open  ]],

Cell[TextData[{
 "The package can be loaded with ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->298023655],

Cell[BoxData[
 RowBox[{"<<", "ExampleData/Collatz.m"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->361285986],

Cell["Once loaded the definitions work:", "ExampleText",
 CellID->194831791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collatz", "[", "47", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->310618805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "47", ",", "142", ",", "71", ",", "214", ",", "107", ",", "322", ",", "161",
    ",", "484", ",", "242", ",", "121", ",", "364", ",", "182", ",", "91", 
   ",", "274", ",", "137", ",", "412", ",", "206", ",", "103", ",", "310", 
   ",", "155", ",", "466", ",", "233", ",", "700", ",", "350", ",", "175", 
   ",", "526", ",", "263", ",", "790", ",", "395", ",", "1186", ",", "593", 
   ",", "1780", ",", "890", ",", "445", ",", "1336", ",", "668", ",", "334", 
   ",", "167", ",", "502", ",", "251", ",", "754", ",", "377", ",", "1132", 
   ",", "566", ",", "283", ",", "850", ",", "425", ",", "1276", ",", "638", 
   ",", "319", ",", "958", ",", "479", ",", "1438", ",", "719", ",", "2158", 
   ",", "1079", ",", "3238", ",", "1619", ",", "4858", ",", "2429", ",", 
   "7288", ",", "3644", ",", "1822", ",", "911", ",", "2734", ",", "1367", 
   ",", "4102", ",", "2051", ",", "6154", ",", "3077", ",", "9232", ",", 
   "4616", ",", "2308", ",", "1154", ",", "577", ",", "1732", ",", "866", ",",
    "433", ",", "1300", ",", "650", ",", "325", ",", "976", ",", "488", ",", 
   "244", ",", "122", ",", "61", ",", "184", ",", "92", ",", "46", ",", "23", 
   ",", "70", ",", "35", ",", "106", ",", "53", ",", "160", ",", "80", ",", 
   "40", ",", "20", ",", "10", ",", "5", ",", "16", ",", "8", ",", "4", ",", 
   "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{510, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->204983724]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29598],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndPackage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EndPackage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Begin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Begin"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24335]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9048],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "Tutorials",
 CellID->269768039],

Cell[TextData[{
 ButtonBox["Setting Up ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"]
}], "Tutorials",
 CellID->5932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->167175330],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->65231253],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->434503752],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->24755655]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BeginPackage - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 40.5043328}", "context" -> "System`", 
    "keywords" -> {
     "package", "extensibility", "contexts", "change context", "namespace", 
      "packaging functionality", "application package", 
      "encapsulating functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BeginPackage[\"StyleBox[ context`]\"] makes context` and System` the \
only active contexts. BeginPackage[\"StyleBox[ context`]\", {\"SubscriptBox[ \
need, 1]`\", \"SubscriptBox[ need, 2]`\", ...}] calls Needs on the need_i. ", 
    "synonyms" -> {"begin package"}, "title" -> "BeginPackage", "type" -> 
    "Symbol", "uri" -> "ref/BeginPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6174, 202, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->177264638]},
 "Info3384172910-1686632"->{
  Cell[9079, 328, 143, 3, 70, "Print",
   CellTags->"Info3384172910-1686632",
   CellID->186564675]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17024, 599},
 {"Info3384172910-1686632", 17173, 603}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2321, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2944, 82, 50, 1, 70, "ObjectName",
 CellID->24966],
Cell[2997, 85, 1593, 51, 70, "Usage",
 CellID->21067]
}, Open  ]],
Cell[CellGroupData[{
Cell[4627, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5105, 158, 280, 10, 70, "Notes",
 CellID->15778],
Cell[5388, 170, 464, 17, 70, "Notes",
 CellID->1173],
Cell[5855, 189, 282, 8, 70, "Notes",
 CellID->3843]
}, Closed]],
Cell[CellGroupData[{
Cell[6174, 202, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177264638],
Cell[CellGroupData[{
Cell[6559, 216, 148, 5, 70, "ExampleSection",
 CellID->657021756],
Cell[6710, 223, 79, 1, 70, "ExampleText",
 CellID->135240015],
Cell[6792, 226, 140, 4, 70, "Input",
 CellID->216743888],
Cell[6935, 232, 162, 5, 70, "ExampleText",
 CellID->4940055],
Cell[CellGroupData[{
Cell[7122, 241, 97, 3, 28, "Input",
 CellID->30309271],
Cell[7222, 246, 171, 5, 36, "Output",
 CellID->90578355]
}, Open  ]],
Cell[7408, 254, 150, 5, 70, "ExampleText",
 CellID->4671383],
Cell[CellGroupData[{
Cell[7583, 263, 81, 2, 70, "Input",
 CellID->213616284],
Cell[7667, 267, 230, 7, 36, "Output",
 CellID->5930937]
}, Open  ]],
Cell[7912, 277, 102, 2, 70, "ExampleText",
 CellID->3753811],
Cell[8017, 281, 173, 6, 70, "Input",
 CellID->206922758],
Cell[8193, 289, 170, 6, 70, "Input",
 CellID->122955943],
Cell[8366, 297, 177, 5, 70, "ExampleText",
 CellID->890268628],
Cell[8546, 304, 101, 3, 70, "Input",
 CellID->493486123],
Cell[8650, 309, 309, 10, 70, "ExampleText",
 CellID->610051904],
Cell[CellGroupData[{
Cell[8984, 323, 92, 3, 70, "Input",
 CellID->113564403],
Cell[9079, 328, 143, 3, 70, "Print",
 CellTags->"Info3384172910-1686632",
 CellID->186564675]
}, Open  ]],
Cell[9237, 334, 64, 1, 70, "ExampleText",
 CellID->795895584],
Cell[CellGroupData[{
Cell[9326, 339, 103, 3, 70, "Input",
 CellID->142942269],
Cell[9432, 344, 160, 5, 36, "Output",
 CellID->527365391]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9641, 355, 216, 7, 70, "ExampleSection",
 CellID->21661],
Cell[9860, 364, 364, 13, 70, "ExampleText",
 CellID->22834368],
Cell[CellGroupData[{
Cell[10249, 381, 133, 3, 70, "Input",
 CellID->767735881],
Cell[10385, 386, 501, 21, 70, "Print",
 CellID->132533267]
}, Open  ]],
Cell[10901, 410, 204, 8, 70, "ExampleText",
 CellID->298023655],
Cell[11108, 420, 108, 3, 70, "Input",
 CellID->361285986],
Cell[11219, 425, 76, 1, 70, "ExampleText",
 CellID->194831791],
Cell[CellGroupData[{
Cell[11320, 430, 104, 3, 70, "Input",
 CellID->310618805],
Cell[11427, 435, 1518, 25, 139, "Output",
 CellID->204983724]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13006, 467, 311, 9, 70, "SeeAlsoSection",
 CellID->29598],
Cell[13320, 478, 449, 17, 70, "SeeAlso",
 CellID->24335]
}, Open  ]],
Cell[CellGroupData[{
Cell[13806, 500, 313, 9, 70, "TutorialsSection",
 CellID->9048],
Cell[14122, 511, 284, 9, 70, "Tutorials",
 CellID->269768039],
Cell[14409, 522, 407, 12, 70, "Tutorials",
 CellID->5932]
}, Open  ]],
Cell[CellGroupData[{
Cell[14853, 539, 319, 9, 70, "MoreAboutSection",
 CellID->167175330],
Cell[15175, 550, 150, 3, 70, "MoreAbout",
 CellID->65231253],
Cell[15328, 555, 155, 3, 70, "MoreAbout",
 CellID->434503752],
Cell[15486, 560, 148, 3, 70, "MoreAbout",
 CellID->24755655]
}, Open  ]],
Cell[15649, 566, 27, 0, 70, "History"],
Cell[15679, 568, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

