(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30071,       1099]
NotebookOptionsPosition[     23632,        870]
NotebookOutlinePosition[     25006,        909]
CellTagsIndexPosition[     24921,        904]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DiscreteDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Discrete Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinomialDistribution" :> 
          Documentation`HelpLookup["paclet:ref/BinomialDistribution"], 
          "NegativeBinomialDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NegativeBinomialDistribution"],
           "GeometricDistribution" :> 
          Documentation`HelpLookup["paclet:ref/GeometricDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"BinomialDistribution\"\>", 
       2->"\<\"NegativeBinomialDistribution\"\>", 
       3->"\<\"GeometricDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/DiscreteStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Discrete Statistical Distributions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BernoulliDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BernoulliDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BernoulliDistribution"], "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a Bernoulli distribution with probability \
parameter ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Bernoulli distribution gives value ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 " with probability ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 " with probability ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "-", "p"}], TraditionalForm]], "InlineMath"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->32599,
  ButtonNote->"32599"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BernoulliDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20799,
  ButtonNote->"20799"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61427972],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->274531550],

Cell["Mean and variance of a Bernoulli distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BernoulliDistribution", "[", "p", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13362],

Cell[BoxData["p"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24671768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"BernoulliDistribution", "[", "p", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6219],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "p"}], ")"}], " ", "p"}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24329689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26664],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->32599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->608],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVM1OwzAMzpqUDY3lso11QkLdFSR4BjgMiQ1pr1BNk7YDAo29f7BTt41c
txS1Uup+jv058U8/ssvx8JldTvssfTtn38fT/iddf51BpQdKqR2su0TBt4Mv
v3bOgRzDWwN89egG3widf9SL12qyuQJpQKYgI5DK+G16pgBikFHpEzKhr4pL
TI7IpExllcfQNe5rxvbvGGSFeNGTC42GPU8ZFXkK9Pe1XNx24ouLaujqLCt2
Z9yfd2J7ZLhbth7oDAlJI1q9e21ENtsShTabFq3Mx7UJ1eZZ3F0y/NRYIyy+
dXnHT5zU8TOKpEWOEcPWSR01qVVdnoCh6C1Xg0eO6Tam+QRBr8x7RGq+Y/PU
9LmZdfIsjWtZnf0RBZ05e1n1YLIsyxbuT1u4LeNMGW7LdhF/5arpqvot/3+r
wS+xS+CD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{80, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->632377851]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7507],

Cell["\<\
Generate a set of pseudorandom numbers that are Bernoulli distributed:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->22622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"BernoulliDistribution", "[", "0.7", "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466398837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20320],

Cell["Properties based on higher-order moments:", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"BernoulliDistribution", "[", "p", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26999],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "p"}]}], 
  SqrtBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], " ", "p"}]]]], "Output",
 ImageSize->{76, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->489709917]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"BernoulliDistribution", "[", "p", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18386],

Cell[BoxData[
 RowBox[{"3", "+", 
  FractionBox[
   RowBox[{"1", "-", 
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "p"}], ")"}], " ", "p"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], " ", "p"}]]}]], "Output",
 ImageSize->{108, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21934887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8552],

Cell["Second moment of a Bernoulli distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"k", "^", "2"}], ",", 
   RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32524],

Cell[BoxData["p"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458444433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a Bernoulli distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4591],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9U8EOgjAMHWxTNEDiRYleIPotcuIjFmICB6JB/n+WUdE0PSyGuGTr3vra
12ZpZYbm1pmhrU1e9ubRtPUzv957eJKBEKKCfcgE3C3c3K6sBSvhlADLGYkR
Wrf+/HrEWgq0K5Z1IrggWLNRYy4NMAGrwGrij9Cfol+5LCGcIaAtYcdOaMaO
O9XLsVOWLWeFb+7GSylCpYjpXb+rX1Txl97oH9BqY4JD5l84vZFHuwi8FBOM
xgLd2nlwlFf2M8F7NmqN+S9oM5a15Ix95nuaeRG8AKfrH7c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{77, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355631223]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7688],

Cell["Simulate a sequence of fair coin tosses:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->161372085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"BernoulliDistribution", "[", 
    RowBox[{"1", "/", "2"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493029365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
   "1", ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220649643]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4549],

Cell["\<\
The probability of getting anything other than zero and one is zero:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->30012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26020],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191155191]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32476],

Cell[TextData[{
 "Every moment of a Bernoulli random variable is ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ExpectedValue", "[", 
    RowBox[{
     RowBox[{"k", "^", "i"}], ",", 
     RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", "k"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", ",", "p", ",", "p", ",", "p", ",", "p", ",", "p", ",", "p"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->574964391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45709179],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BernoulliDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliDistribution"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["BinomialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinomialDistribution"]], "InlineFormula"],
 " of one trial:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->109559857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114635251],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVM1OwzAMzpqUDY3lso11QkLdFSR4BjgMiQ1pr1BNk7YDAo29f7BTt41c
txS1Uup+jv058U8/ssvx8JldTvssfTtn38fT/iddf51BpQdKqR2su0TBt4Mv
v3bOgRzDWwN89egG3widf9SL12qyuQJpQKYgI5DK+G16pgBikFHpEzKhr4pL
TI7IpExllcfQNe5rxvbvGGSFeNGTC42GPU8ZFXkK9Pe1XNx24ouLaujqLCt2
Z9yfd2J7ZLhbth7oDAlJI1q9e21ENtsShTabFq3Mx7UJ1eZZ3F0y/NRYIyy+
dXnHT5zU8TOKpEWOEcPWSR01qVVdnoCh6C1Xg0eO6Tam+QRBr8x7RGq+Y/PU
9LmZdfIsjWtZnf0RBZ05e1n1YLIsyxbuT1u4LeNMGW7LdhF/5arpqvot/3+r
wS+xS+CD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{80, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134407193]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"BinomialDistribution", "[", 
      RowBox[{"1", ",", "p"}], "]"}], ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3178766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", "p"}], ",", "p"}], "}"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->71100853]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15132],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BernoulliDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is not between zero and one:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->32358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BernoulliDistribution", "[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31788],

Cell[BoxData[
 RowBox[{
  RowBox[{"BernoulliDistribution", "::", "\<\"probparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3\\) is expected to be a probability between 0 \
and 1.\"\>"}]], "Message", "MSG",
 CellID->28381679],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BernoulliDistribution", "[", "3", "]"}], "]"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167885243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8930],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"BernoulliDistribution", "[", "p", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"p", "->", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27649],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327142839]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19490],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinomialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NegativeBinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NegativeBinomialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeometricDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3799]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28208],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Discrete Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteStatisticalDistributions"]], "MoreAbout",
 CellID->12033118]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BernoulliDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 47.2857564}", "context" -> "System`", 
    "keywords" -> {
     "Bernoulli distribution", "Bernoulli trial", "Bernoulli trials", 
      "coin tossing"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BernoulliDistribution[p] represents a Bernoulli distribution with \
probability parameter p.", "synonyms" -> {"bernoulli distribution"}, "title" -> 
    "BernoulliDistribution", "type" -> "Symbol", "uri" -> 
    "ref/BernoulliDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6844, 216, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->61427972]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24779, 897}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2173, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2796, 81, 1586, 37, 70, "ObjectNameGrid"],
Cell[4385, 120, 609, 19, 70, "Usage",
 CellID->20421]
}, Open  ]],
Cell[CellGroupData[{
Cell[5031, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5509, 161, 585, 22, 70, "Notes",
 CellID->429991538],
Cell[6097, 185, 710, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[6844, 216, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61427972],
Cell[CellGroupData[{
Cell[7228, 230, 148, 5, 70, "ExampleSection",
 CellID->274531550],
Cell[7379, 237, 270, 6, 70, "ExampleText",
 CellID->20799],
Cell[CellGroupData[{
Cell[7674, 247, 144, 4, 28, "Input",
 CellID->13362],
Cell[7821, 253, 157, 5, 36, "Output",
 CellID->24671768]
}, Open  ]],
Cell[CellGroupData[{
Cell[8015, 263, 147, 4, 28, "Input",
 CellID->6219],
Cell[8165, 269, 226, 8, 36, "Output",
 CellID->24329689]
}, Open  ]],
Cell[8406, 280, 121, 3, 70, "ExampleDelimiter",
 CellID->26664],
Cell[8530, 285, 253, 6, 70, "ExampleText",
 CellID->32599],
Cell[CellGroupData[{
Cell[8808, 295, 168, 6, 28, "Input",
 CellID->608],
Cell[8979, 303, 646, 15, 48, "Output",
 Evaluatable->False,
 CellID->632377851]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9674, 324, 215, 7, 70, "ExampleSection",
 CellID->7507],
Cell[9892, 333, 254, 7, 70, "ExampleText",
 CellID->22622],
Cell[CellGroupData[{
Cell[10171, 344, 182, 6, 70, "Input",
 CellID->8327],
Cell[10356, 352, 291, 9, 36, "Output",
 CellID->466398837]
}, Open  ]],
Cell[10662, 364, 121, 3, 70, "ExampleDelimiter",
 CellID->20320],
Cell[10786, 369, 83, 1, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[10894, 374, 148, 4, 70, "Input",
 CellID->26999],
Cell[11045, 380, 312, 12, 56, "Output",
 CellID->489709917]
}, Open  ]],
Cell[CellGroupData[{
Cell[11394, 397, 148, 4, 70, "Input",
 CellID->18386],
Cell[11545, 403, 388, 14, 53, "Output",
 CellID->21934887]
}, Open  ]],
Cell[11948, 420, 120, 3, 70, "ExampleDelimiter",
 CellID->8552],
Cell[12071, 425, 218, 5, 70, "ExampleText",
 CellID->16217],
Cell[CellGroupData[{
Cell[12314, 434, 214, 7, 70, "Input",
 CellID->32524],
Cell[12531, 443, 158, 5, 36, "Output",
 CellID->458444433]
}, Open  ]],
Cell[12704, 451, 119, 3, 70, "ExampleDelimiter",
 CellID->113],
Cell[12826, 456, 377, 13, 70, "ExampleText",
 CellID->13063],
Cell[CellGroupData[{
Cell[13228, 473, 174, 6, 70, "Input",
 CellID->4591],
Cell[13405, 481, 503, 12, 70, "Output",
 Evaluatable->False,
 CellID->355631223]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13957, 499, 222, 7, 70, "ExampleSection",
 CellID->7688],
Cell[14182, 508, 220, 5, 70, "ExampleText",
 CellID->161372085],
Cell[CellGroupData[{
Cell[14427, 517, 207, 6, 70, "Input",
 CellID->493029365],
Cell[14637, 525, 395, 10, 36, "Output",
 CellID->220649643]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15081, 541, 232, 7, 70, "ExampleSection",
 CellID->4549],
Cell[15316, 550, 252, 7, 70, "ExampleText",
 CellID->30012],
Cell[CellGroupData[{
Cell[15593, 561, 191, 6, 70, "Input",
 CellID->26020],
Cell[15787, 569, 158, 5, 36, "Output",
 CellID->191155191]
}, Open  ]],
Cell[15960, 577, 121, 3, 70, "ExampleDelimiter",
 CellID->32476],
Cell[16084, 582, 299, 10, 70, "ExampleText",
 CellID->691],
Cell[CellGroupData[{
Cell[16408, 596, 336, 11, 70, "Input",
 CellID->30525],
Cell[16747, 609, 257, 8, 36, "Output",
 CellID->574964391]
}, Open  ]],
Cell[17019, 620, 124, 3, 70, "ExampleDelimiter",
 CellID->45709179],
Cell[17146, 625, 520, 16, 70, "ExampleText",
 CellID->109559857],
Cell[CellGroupData[{
Cell[17691, 645, 174, 6, 70, "Input",
 CellID->114635251],
Cell[17868, 653, 646, 15, 70, "Output",
 Evaluatable->False,
 CellID->134407193]
}, Open  ]],
Cell[CellGroupData[{
Cell[18551, 673, 314, 10, 70, "Input",
 CellID->3178766],
Cell[18868, 685, 226, 8, 36, "Output",
 CellID->71100853]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19143, 699, 327, 9, 70, "ExampleSection",
 CellID->15132],
Cell[19473, 710, 448, 14, 70, "ExampleText",
 CellID->32358],
Cell[CellGroupData[{
Cell[19946, 728, 144, 4, 70, "Input",
 CellID->31788],
Cell[20093, 734, 222, 5, 70, "Message",
 CellID->28381679],
Cell[20318, 741, 237, 7, 36, "Output",
 CellID->167885243]
}, Open  ]],
Cell[20570, 751, 120, 3, 70, "ExampleDelimiter",
 CellID->8930],
Cell[20693, 756, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[20999, 768, 217, 7, 70, "Input",
 CellID->27649],
Cell[21219, 777, 158, 5, 36, "Output",
 CellID->327142839]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21438, 789, 311, 9, 70, "SeeAlsoSection",
 CellID->19490],
Cell[21752, 800, 785, 26, 70, "SeeAlso",
 CellID->3799]
}, Open  ]],
Cell[CellGroupData[{
Cell[22574, 831, 314, 9, 70, "TutorialsSection",
 CellID->28208],
Cell[22891, 842, 153, 3, 70, "Tutorials",
 CellID->4738]
}, Open  ]],
Cell[CellGroupData[{
Cell[23081, 850, 299, 8, 70, "MoreAboutSection"],
Cell[23383, 860, 177, 3, 70, "MoreAbout",
 CellID->12033118]
}, Open  ]],
Cell[23575, 866, 27, 0, 70, "History"],
Cell[23605, 868, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

