(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     80872,       2338]
NotebookOptionsPosition[     72906,       2077]
NotebookOutlinePosition[     74754,       2121]
CellTagsIndexPosition[     74668,       2116]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinCounts" :> Documentation`HelpLookup["paclet:ref/BinCounts"],
           "Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], "Union" :> 
          Documentation`HelpLookup["paclet:ref/Union"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "Split" :> 
          Documentation`HelpLookup["paclet:ref/Split"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BinCounts\"\>", 2->"\<\"Cases\"\>", 
       3->"\<\"Union\"\>", 4->"\<\"Sort\"\>", 
       5->"\<\"Split\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Exploratory Data Analysis\"\>", 
       2->"\<\"Discrete & Integer Data\"\>", 3->"\<\"Elements of Lists\"\>", 
       4->"\<\"New in 6.0: List Manipulation\"\>", 
       5->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       6->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BinLists", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinLists",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinLists"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives lists of the elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " whose values lie in successive integer bins."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinLists",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinLists"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives lists of the elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " whose values lie in successive bins of width ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinLists",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinLists"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives lists of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " that lie in successive bins of width ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinLists",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinLists"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives lists of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " that lie in the intervals ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["2", "TR"]]}], ")"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["3", "TR"]]}], ")"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinLists",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinLists"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["xbins", "TI"], ",", 
        StyleBox["ybins", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an array of lists where the first index \
corresponds to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " bins, the second to ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", and so on. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinLists"]], "InlineFormula"],
 " drops elements whose values do not correspond to real numbers."
}], "Notes",
 CellID->989418566],

Cell["\<\
Within each bin, elements appear in the same order as in the original data.\
\>", "Notes",
 CellID->41151434],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
 " takes the bin boundaries to be integer multiples of ",
 Cell[BoxData[
  StyleBox["dx", "TI"]], "InlineFormula"],
 ", with the first bin starting at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      ButtonBox["Min",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Min"], "[", 
      StyleBox["data", "TI"], "]"}], "-", 
     StyleBox["dx", "TI"]}], ",", 
    StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
 " and the last bin ending at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      ButtonBox["Max",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Max"], "[", 
      StyleBox["data", "TI"], "]"}], "+", 
     StyleBox["dx", "TI"]}], ",", 
    StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->205097119],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->210517892],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->126729676],

Cell[TextData[{
 "In the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ", the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " at each end can be ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"+", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->497450453],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " do not form an increasing sequence, they are automatically sorted by ",
 Cell[BoxData[
  ButtonBox["BinLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinLists"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->168774678],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ", elements are put in bin ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " when their values satisfy ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "i"], "\[LessEqual]", "x", "<", 
    SubscriptBox["b", 
     RowBox[{"i", "+", "1"}]]}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->94503541],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " consists of length-",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " sublists, then ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " bin specifications must be given, and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " yields an array of lists of depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinLists"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects."
}], "Notes",
 CellID->553010305]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108604047],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->489506273],

Cell["Make lists of elements in bins of width 1 from 0 to 10:", "ExampleText",
 CellID->18927180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "1", ",", "4", ",", "5", ",", "6", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38712768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84892548]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->689178298],

Cell["List elements in a sequence of ranges:", "ExampleText",
 CellID->26246007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "1", ",", "4", ",", "5", ",", "6", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "Infinity"}], ",", "2", ",", "5", ",", "7", ",", 
      "Infinity"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107309661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268503754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194206092],

Cell["List elements in bins of a specified width:", "ExampleText",
 CellID->245743928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "1", ",", "4", ",", "5", ",", "6", ",", 
     "2"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235360212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", "6", "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->686550130]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
List squares mod 3 and 5 in 2\[Hyphen]dimensional unit bins:\
\>", "ExampleText",
 CellID->422181288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}]}], "]"}], ",", "1", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92857074],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81yEzEM3sZNCAFCCxeOfRdm4MQFOEBPhA6QHhiY0ocDXm5ZOz9lVNmS
bHm9mzgz2URZ6bMsy7veT/Gb1e36y/fV7fXV6uL1zern+vrq18WrHzfdT+ak
aSbTpmlevmi67233zb13rwfd+07cSM/s0ey1mgmQT4G8SNSH5x8C+akQT2r/
qHD7lP0ZYU/Jf+2hOSe0THeYdCI1Oly9xVYPtuuzp/ThKGnj+/ThbJBG/w8r
+lCeK+vbOWkvA9hcs6IR4qfiwRwfmn9cvAUTTy9LbE7C6KXoYXZwrmFXdIkf
XDzqmlLaPy7eYwaePDvgfWAG5CfC87CVKaI/Q3Ie4nDtlj23R9ktPXZS+XfL
mbvUKoA6j/ZuupedD/f7QqHyUKgVSJ++UChLFkqe67P2GLu+nN7JkdEIIlBj
24cPrLgFEcYxnv/rx+Q2ZU+NZe72Kfszwr6O4vGOIsU6wFGmzmNPQLvnOfsJ
V+wYfkgf81cT36f/3KMfxwq02xfGA+lIcG2NjUvo/NDYIm22Zmj9Gzsblto+
lN08Yz2ZQqsSLFksi3XsrJ4U3xc/97s4Wyj2CbtmYmyUveJaET7pUvh94c2Z
eFrxmHl+j/Wfi8dlN0v5Jxn/Ev6ha4SoWZXCgrr1C4tJkHCDeVDnbFTNCGny
0BI9Lk9cyr8h9wOz26xxKGsNPvl+jqJa2VFwlpC6L0l7DNeaUi8pe4pRz90+
ZQ/X6trto/ch8X1iyMx7HrY7hfHKcV7CeB2if+j6seZxzeOR+VfzuObxIfhX
87jm8SH4h+extCLDrazZ3hgkS3yVLKn+uUefsg/5az/hU0XIX0zfVwnUwg/F
QwMfxsdd5/YT/3gqg7nxc1cOh/4//dKVRUp+Zw+9V/q08fqqBPa9XyBXpZA7
vu/bmOyAMlXJsq0Z5BrNrcRptRdbSQr5H1P50d4HoRWf2H0OqXjceHPxKPlt
G5v1nHqEuwOhTxmySpl+27EVlzBqzgqmpl64F7G7OXRQZRHnoHIitlkbaFfI
DOo7r8KFPveL25JWeHAUqs5D+aq9k8UfV86+FJk1L0I+a0r+4Oy1mSd8zvCY
I522pMwGjiJ9YsrN56TEFfYlBYsXvbjxhvLHtmaoH2UcGSrfJRSLw4sajVOz
koc65qyU7pOJQ+FFjEKp+chDrfk4pHzMUQkyW+8MwysJHrfSYRp+pUO6pyw2
HrtKDWcPWUjf11+fPhX/S3vYJ1a+So80O3NXMsamD2V7WLnIpvJ7pdh+bT2f
nRU+q0QKyqWZ6b71sRz8pBbZMfxbP/bf9VbYzFbpPE/lxfo+j+XI11YjR0r/
U0daW7aHb7XntedH1vPUlZ72ilz7PNbztet5u31J18bNyT8LUg79\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{517, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472461111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385637151],

Cell["List random pairs in bins of width 0.25 in both dimensions:", \
"ExampleText",
 CellID->254770907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", ".25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", ".25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112655837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7552964383496081`"}], ",", 
        RowBox[{"-", "0.1194017452257401`"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5467299935357923`"}], ",", 
        RowBox[{"-", "0.5249904874708511`"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.6289917825968825`"}], ",", "0.16682218783202796`"}], 
       "}"}], "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5221464669100437`"}], ",", "0.9305248592976172`"}], 
       "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.21164130258749925`"}], ",", "0.5493355525834058`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.05764709281812008`"}], ",", "0.5713571855762054`"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.049133791454520015`", ",", "0.5033548287431269`"}], "}"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.15781685631788678`", ",", "0.9978482234734503`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.6135269382654158`", ",", 
        RowBox[{"-", "0.22994588220301182`"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.5050923347426735`", ",", "0.8374469199616756`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{531, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14884273]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102656935],

Cell["List multidimensional data in ranges:", "ExampleText",
 CellID->793572346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", ".3", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", ".4"}], ",", ".2", ",", "1"}], "}"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->570033843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.9746040010182329`"}], ",", "0.01667842641339856`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.13255872048929485`"}], ",", 
         RowBox[{"-", "0.3519525833408643`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1967742739144418`"}], ",", 
         RowBox[{"-", "0.34583068293801755`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6359156838372741`"}], ",", 
         RowBox[{"-", "0.38827411691528724`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.13202560138441966`", ",", "0.28749122021604157`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.9947987276777441`"}], ",", "0.28612822837309615`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.11870695216759275`", ",", "0.7207668455705281`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.2869061968832023`"}], ",", "0.7214441848471389`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.902149152613883`"}], ",", "0.3071969052714749`"}], 
        "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.3039065057865056`", ",", 
        RowBox[{"-", "0.2910440124136531`"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{582, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105306913],

Cell["Bin data in any dimension:", "ExampleText",
 CellID->96436699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->782641426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.8718507740198196`"}], ",", "0.21209691503450667`",
             ",", 
            RowBox[{"-", "0.7944201673048803`"}], ",", 
            RowBox[{"-", "0.9980760001066278`"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.8072045235660164`"}], ",", "0.9429230413097498`",
              ",", "0.7453344081432265`", ",", "0.2447670840352787`"}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.1492829784993499`"}], ",", 
             "0.47684441143136747`", ",", "0.3162622163981541`", ",", 
             "0.6667553463545923`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.955653712843239`"}], ",", "0.24516960988135716`",
              ",", "0.10084145105602005`", ",", "0.0900775865704273`"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.912516025089678`"}], ",", "0.9122183023431147`", 
             ",", "0.8868051889693622`", ",", "0.17048314318265367`"}], 
            "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.8816276059611985`", ",", 
            RowBox[{"-", "0.9192375270632964`"}], ",", 
            RowBox[{"-", "0.6123779411152239`"}], ",", 
            RowBox[{"-", "0.9887012907358228`"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.5226753277335603`", ",", 
            RowBox[{"-", "0.856497145526355`"}], ",", 
            RowBox[{"-", "0.8864506989468768`"}], ",", 
            "0.18138187663644123`"}], "}"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.4477774288654661`", ",", 
            RowBox[{"-", "0.8803374941767652`"}], ",", "0.33799815255964427`",
             ",", 
            RowBox[{"-", "0.04877748512132163`"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.3705244511315815`", ",", "0.1326350514743293`", ",", 
            RowBox[{"-", "0.25718989008164694`"}], ",", 
            RowBox[{"-", "0.6093723469941716`"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.4444683749968821`", ",", "0.7722441439803798`", ",", 
            RowBox[{"-", "0.7301326381696565`"}], ",", 
            "0.7250516145233563`"}], "}"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{516, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237230715]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91707437],

Cell["Bin data ignoring values that are not real:", "ExampleText",
 CellID->407025834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5", ",", "3", ",", "a", ",", "2.5", ",", "1", ",", "I"}], 
    "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103395590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2.5`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127966602]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297373174],

Cell["Bin data of any precision:", "ExampleText",
 CellID->25385746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5", ",", "3", ",", 
     RowBox[{"N", "[", 
      RowBox[{"3", ",", "20"}], "]"}], ",", "2.5", ",", "1", ",", "E"}], 
    "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29800496],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3.`20.", ",", "2.5`", ",", "\[ExponentialE]"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65687720]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Visualize 2\[Hyphen]dimensional data in bins:\
\>", "ExampleText",
 CellID->286062020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"BinLists", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{"10", ",", 
        RowBox[{"{", 
         RowBox[{"2500", ",", "2"}], "}"}]}], "]"}], ",", "2", ",", "2"}], 
     "]"}], ",", "1"}], "]"}], "//", "ListPlot"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34502546],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346133553]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "The length of ",
 Cell[BoxData[
  ButtonBox["BinLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinLists"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->649914853],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", "1000"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71746030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"BinLists", "[", "data", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402198174],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "103", ",", "94", ",", "76", ",", "105", ",", "90", ",", "96", ",", "108", 
   ",", "120", ",", "102", ",", "106"}], "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->315393064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->277884677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "103", ",", "94", ",", "76", ",", "105", ",", "90", ",", "96", ",", "108", 
   ",", "120", ",", "102", ",", "106"}], "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->515303957]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->66283699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"BinLists", "[", "data2", "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->15118708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "16", ",", "10", ",", "8", ",", "15", ",", "10", ",", "8", ",", "7", ",", 
     "9", ",", "8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "6", ",", "12", ",", "11", ",", "11", ",", "15", ",", "12", 
     ",", "7", ",", "8", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "8", ",", "14", ",", "9", ",", "4", ",", "16", ",", "8", ",", 
     "17", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "5", ",", "5", ",", "7", ",", "8", ",", "15", ",", "12", ",", 
     "8", ",", "13", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "8", ",", "11", ",", "8", ",", "11", ",", "12", ",", "8", ",", "10", ",", 
     "17", ",", "12", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "8", ",", "9", ",", "12", ",", "12", ",", "8", ",", "7", ",", 
     "12", ",", "12", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "10", ",", "10", ",", "10", ",", "10", ",", "15", ",", "10", 
     ",", "10", ",", "13", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "7", ",", "12", ",", "11", ",", "10", ",", "6", ",", "13", ",",
      "16", ",", "15", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "13", ",", "18", ",", "15", ",", "10", ",", "4", ",", "9", ",",
      "8", ",", "6", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "7", ",", "12", ",", "9", ",", "6", ",", "6", ",", "7", ",", 
     "15", ",", "14", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->329219472]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", "data2", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->511930846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "16", ",", "10", ",", "8", ",", "15", ",", "10", ",", "8", ",", "7", ",", 
     "9", ",", "8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "6", ",", "12", ",", "11", ",", "11", ",", "15", ",", "12", 
     ",", "7", ",", "8", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "8", ",", "14", ",", "9", ",", "4", ",", "16", ",", "8", ",", 
     "17", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "5", ",", "5", ",", "7", ",", "8", ",", "15", ",", "12", ",", 
     "8", ",", "13", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "8", ",", "11", ",", "8", ",", "11", ",", "12", ",", "8", ",", "10", ",", 
     "17", ",", "12", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "8", ",", "9", ",", "12", ",", "12", ",", "8", ",", "7", ",", 
     "12", ",", "12", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "10", ",", "10", ",", "10", ",", "10", ",", "15", ",", "10", 
     ",", "10", ",", "13", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "7", ",", "12", ",", "11", ",", "10", ",", "6", ",", "13", ",",
      "16", ",", "15", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "13", ",", "18", ",", "15", ",", "10", ",", "4", ",", "9", ",",
      "8", ",", "6", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "7", ",", "12", ",", "9", ",", "6", ",", "6", ",", "7", ",", 
     "15", ",", "14", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{511, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->47503208]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["Binning intervals are closed on the left:", "ExampleText",
 CellID->36684001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39370045],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], "}"}]], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188586568]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinLists", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "-", "$MachineEpsilon"}], ",", "2", ",", "3", ",", "4", ",", 
    "5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272316163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.9999999999999998`", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->683682672]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Split",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Split"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->629529526],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->397333027],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->229270904],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->461062636],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->205242599],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->308652038]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BinLists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 6.1143634}", "context" -> "System`", 
    "keywords" -> {
     "aggregating data", "binning of data", "categorizing data"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BinLists[{x_1, x_2, ...}] gives lists of the elements x_i whose values \
lie in successive integer bins. BinLists[{x_1, x_2, ...}, dx] gives lists of \
the elements x_i whose values lie in successive bins of width dx. \
BinLists[{x_1, x_2, ...}, {x_min, x_max, dx}] gives lists of the x_i that lie \
in successive bins of width dx from x_min to x_max. BinLists[{x_1, x_2, ...}, \
{{b_1, b_2, ...}}] gives lists of the x_i that lie in the intervals (b_1, \
b_2), (b_2, b_3), .... BinLists[{{x_1, y_1, ...}, {x_2, y_2, ...}, ...}, \
xbins, ybins, ...] gives an array of lists where the first index corresponds \
to x bins, the second to y, and so on. ", "synonyms" -> {"bin lists"}, 
    "title" -> "BinLists", "type" -> "Symbol", "uri" -> "ref/BinLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17223, 583, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->108604047]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 74524, 2109}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2349, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2972, 77, 1573, 37, 70, "ObjectNameGrid"],
Cell[4548, 116, 6041, 197, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[10626, 318, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11104, 335, 234, 7, 70, "Notes",
 CellID->989418566],
Cell[11341, 344, 119, 3, 70, "Notes",
 CellID->41151434],
Cell[11463, 349, 1221, 44, 70, "Notes",
 CellID->205097119],
Cell[12687, 395, 447, 17, 70, "Notes",
 CellID->210517892],
Cell[13137, 414, 888, 34, 70, "Notes",
 CellID->126729676],
Cell[14028, 450, 973, 39, 70, "Notes",
 CellID->497450453],
Cell[15004, 491, 359, 13, 70, "Notes",
 CellID->168774678],
Cell[15366, 506, 840, 32, 70, "Notes",
 CellID->94503541],
Cell[16209, 540, 652, 24, 70, "Notes",
 CellID->1067943069],
Cell[16864, 566, 322, 12, 70, "Notes",
 CellID->553010305]
}, Closed]],
Cell[CellGroupData[{
Cell[17223, 583, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108604047],
Cell[CellGroupData[{
Cell[17608, 597, 148, 5, 70, "ExampleSection",
 CellID->489506273],
Cell[17759, 604, 97, 1, 70, "ExampleText",
 CellID->18927180],
Cell[CellGroupData[{
Cell[17881, 609, 306, 10, 28, "Input",
 CellID->38712768],
Cell[18190, 621, 553, 19, 36, "Output",
 CellID->84892548]
}, Open  ]],
Cell[18758, 643, 125, 3, 70, "ExampleDelimiter",
 CellID->689178298],
Cell[18886, 648, 80, 1, 70, "ExampleText",
 CellID->26246007],
Cell[CellGroupData[{
Cell[18991, 653, 395, 13, 70, "Input",
 CellID->107309661],
Cell[19389, 668, 410, 14, 36, "Output",
 CellID->268503754]
}, Open  ]],
Cell[19814, 685, 125, 3, 70, "ExampleDelimiter",
 CellID->194206092],
Cell[19942, 690, 86, 1, 70, "ExampleText",
 CellID->245743928],
Cell[CellGroupData[{
Cell[20053, 695, 247, 8, 70, "Input",
 CellID->235360212],
Cell[20303, 705, 405, 14, 36, "Output",
 CellID->686550130]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20757, 725, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[20981, 734, 111, 3, 70, "ExampleText",
 CellID->422181288],
Cell[CellGroupData[{
Cell[21117, 741, 396, 14, 70, "Input",
 CellID->92857074],
Cell[21516, 757, 1606, 30, 70, "Output",
 Evaluatable->False,
 CellID->472461111]
}, Open  ]],
Cell[23137, 790, 125, 3, 70, "ExampleDelimiter",
 CellID->385637151],
Cell[23265, 795, 104, 2, 70, "ExampleText",
 CellID->254770907],
Cell[CellGroupData[{
Cell[23394, 801, 494, 17, 70, "Input",
 CellID->112655837],
Cell[23891, 820, 3746, 124, 156, "Output",
 CellID->14884273]
}, Open  ]],
Cell[27652, 947, 125, 3, 70, "ExampleDelimiter",
 CellID->102656935],
Cell[27780, 952, 80, 1, 70, "ExampleText",
 CellID->793572346],
Cell[CellGroupData[{
Cell[27885, 957, 582, 21, 70, "Input",
 CellID->570033843],
Cell[28470, 980, 1825, 56, 88, "Output",
 CellID->352673]
}, Open  ]],
Cell[30310, 1039, 125, 3, 70, "ExampleDelimiter",
 CellID->105306913],
Cell[30438, 1044, 68, 1, 70, "ExampleText",
 CellID->96436699],
Cell[CellGroupData[{
Cell[30531, 1049, 290, 10, 70, "Input",
 CellID->782641426],
Cell[30824, 1061, 3661, 101, 173, "Output",
 CellID->237230715]
}, Open  ]],
Cell[34500, 1165, 124, 3, 70, "ExampleDelimiter",
 CellID->91707437],
Cell[34627, 1170, 86, 1, 70, "ExampleText",
 CellID->407025834],
Cell[CellGroupData[{
Cell[34738, 1175, 225, 7, 70, "Input",
 CellID->103395590],
Cell[34966, 1184, 308, 11, 36, "Output",
 CellID->127966602]
}, Open  ]],
Cell[35289, 1198, 125, 3, 70, "ExampleDelimiter",
 CellID->297373174],
Cell[35417, 1203, 68, 1, 70, "ExampleText",
 CellID->25385746],
Cell[CellGroupData[{
Cell[35510, 1208, 283, 9, 70, "Input",
 CellID->29800496],
Cell[35796, 1219, 351, 12, 36, "Output",
 CellID->65687720]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36196, 1237, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[36426, 1246, 96, 3, 70, "ExampleText",
 CellID->286062020],
Cell[CellGroupData[{
Cell[36547, 1253, 368, 12, 70, "Input",
 CellID->34502546],
Cell[36918, 1267, 25422, 421, 70, "Output",
 Evaluatable->False,
 CellID->346133553]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62389, 1694, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[62630, 1703, 341, 13, 70, "ExampleText",
 CellID->649914853],
Cell[62974, 1718, 257, 10, 70, "Input",
 CellID->71746030],
Cell[CellGroupData[{
Cell[63256, 1732, 166, 5, 70, "Input",
 CellID->402198174],
Cell[63425, 1739, 307, 9, 36, "Output",
 CellID->315393064]
}, Open  ]],
Cell[CellGroupData[{
Cell[63769, 1753, 108, 3, 70, "Input",
 CellID->277884677],
Cell[63880, 1758, 307, 9, 36, "Output",
 CellID->515303957]
}, Open  ]],
Cell[64202, 1770, 308, 11, 70, "Input",
 CellID->66283699],
Cell[CellGroupData[{
Cell[64535, 1785, 200, 6, 70, "Input",
 CellID->15118708],
Cell[64738, 1793, 1738, 47, 105, "Output",
 CellID->329219472]
}, Open  ]],
Cell[CellGroupData[{
Cell[66513, 1845, 109, 3, 70, "Input",
 CellID->511930846],
Cell[66625, 1850, 1737, 47, 105, "Output",
 CellID->47503208]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[68411, 1903, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[68645, 1912, 83, 1, 70, "ExampleText",
 CellID->36684001],
Cell[CellGroupData[{
Cell[68753, 1917, 183, 6, 70, "Input",
 CellID->39370045],
Cell[68939, 1925, 383, 13, 36, "Output",
 CellID->188586568]
}, Open  ]],
Cell[CellGroupData[{
Cell[69359, 1943, 225, 7, 70, "Input",
 CellID->272316163],
Cell[69587, 1952, 401, 13, 36, "Output",
 CellID->683682672]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70049, 1972, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[70368, 1983, 1166, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[71571, 2032, 299, 8, 70, "MoreAboutSection"],
Cell[71873, 2042, 155, 3, 70, "MoreAbout",
 CellID->629529526],
Cell[72031, 2047, 157, 3, 70, "MoreAbout",
 CellID->397333027],
Cell[72191, 2052, 144, 3, 70, "MoreAbout",
 CellID->229270904],
Cell[72338, 2057, 164, 3, 70, "MoreAbout",
 CellID->461062636],
Cell[72505, 2062, 175, 3, 70, "MoreAbout",
 CellID->205242599],
Cell[72683, 2067, 151, 3, 70, "MoreAbout",
 CellID->308652038]
}, Open  ]],
Cell[72849, 2073, 27, 0, 70, "History"],
Cell[72879, 2075, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

