(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    383459,       7789]
NotebookOptionsPosition[    369436,       7317]
NotebookOutlinePosition[    370742,       7355]
CellTagsIndexPosition[    370655,       7350]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multinomial" :> 
          Documentation`HelpLookup["paclet:ref/Multinomial"], "Pochhammer" :> 
          Documentation`HelpLookup["paclet:ref/Pochhammer"], "Factorial" :> 
          Documentation`HelpLookup["paclet:ref/Factorial"], 
          "BinomialDistribution" :> 
          Documentation`HelpLookup["paclet:ref/BinomialDistribution"], 
          "Subsets" :> Documentation`HelpLookup["paclet:ref/Subsets"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Multinomial\"\>", 
       2->"\<\"Pochhammer\"\>", 3->"\<\"Factorial\"\>", 
       4->"\<\"BinomialDistribution\"\>", 
       5->"\<\"Subsets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/RecurrenceAndSumFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"Functions Used in Statistics\"\>", 
       4->"\<\"Gamma Functions and Related Functions\"\>", 
       5->"\<\"Integer Functions\"\>", 6->"\<\"Mathematical Functions\"\>", 
       7->"\<\"Recurrence and Sum Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Binomial", "ObjectName",
 CellID->30752],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Binomial",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Binomial"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the binomial coefficient ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", GridBox[{
          {"n"},
          {"m"}
         }], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1396]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " is evaluated symbolically when possible. "
}], "Notes",
 CellID->771],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"n"},
      {"m"}
     }], ")"}], TraditionalForm]], "InlineMath"],
 " is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalGamma]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"\[CapitalGamma]", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "\[CapitalGamma]", 
       RowBox[{"(", 
        RowBox[{"n", "-", "m", "+", "1"}], ")"}]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " or suitable limits of this."
}], "Notes",
 CellID->19529],

Cell[TextData[{
 "For integers and certain other special arguments, ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->191084252],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->940447840],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->115704259],

Cell["Evaluate 10 choose 3:", "ExampleText",
 CellID->313630859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"10", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281627810],

Cell[BoxData["120"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221977480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137786803],

Cell["Construct Pascal\[CloseCurlyQuote]s triangle:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "Center"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", "1", "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "3", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "6", ",", "4", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "10", ",", "10", ",", "5", ",", "1"}], 
      "}"}]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Center}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{130, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134786694]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"x", "+", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{103, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99103020]
}, Open  ]],

Cell["Evaluate special cases for symbolic arguments:", "ExampleText",
 CellID->44510365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"n", ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->330634137],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]], "Output",
 ImageSize->{128, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26199194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211611581],

Cell[TextData[{
 "Evaluate ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " for large arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Binomial", "[", 
   RowBox[{"100000", ",", "50000"}], "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"25206083689220033885009001167346", 
   RowBox[{"\[LeftSkeleton]", "30036", "\[RightSkeleton]"}], 
   "340640886651313872846009891416640"}],
  Short]], "Output",
 ImageSize->{573, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->322725026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate for half-integer arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"7", "/", "2"}], ",", " ", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox["35", "16"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208809489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate numerically:", "ExampleText",
 CellID->13889856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"7.3", ",", 
   RowBox[{"-", "3.5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196713376],

Cell[BoxData[
 RowBox[{"-", "0.00040021321680442246`"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145764886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->797776786],

Cell["Evaluate for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"2.5", "+", 
    RowBox[{"3", "I"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.2174760770183128`"}], "+", 
  RowBox[{"0.09841166935524642`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466447723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->800287604],

Cell[TextData[{
 "Compute sums involving ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->46157309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->776392389],

Cell[BoxData[
 SuperscriptBox["2", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->984890341]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->233743718],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["4", "n"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", "n"}], "]"}]}], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{112, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->215406657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at generic point:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["3", "2"]}], "+", "EulerGamma", "+", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}]}], "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"k", "-", "2"}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"k", "-", "2"}], "]"}], "2"],
    SeriesData[$CellContext`k, 2, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`k, 2, {
   Rational[1, 2] (-1 + $CellContext`n) $CellContext`n, 
    Rational[1, 2] (-1 + $CellContext`n) $CellContext`n (Rational[-3, 2] + 
     EulerGamma + PolyGamma[0, -1 + $CellContext`n])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{532, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178498341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "k"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"(", GridBox[{
      {
       TagBox["n",
        Identity,
        Editable->True,
        Selectable->True]},
      {
       TagBox["k",
        Identity,
        Editable->True,
        Selectable->True]}
     }], ")"}],
   InterpretTemplate[Binomial[#, #2]& ],
   Editable->False,
   Selectable->False], TraditionalForm]], "Output",
 ImageSize->{26, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->88087656]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18848],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"Infinity", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144984188]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"-", "Infinity"}], ",", 
   RowBox[{"-", "12"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92315617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "11"}], "}"}], ",", " ", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "10", ",", "35", ",", "165"}], "}"}]], "Output",\

 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125345701]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7971],

Cell["Illustrate the binomial theorem:", "ExampleText",
 CellID->638563130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], 
    RowBox[{"x", "^", "k"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7241833],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "n"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309132385]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187084880],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"10", " ", "x"}], "+", 
  RowBox[{"45", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"252", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"45", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139348934]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4049201],

Cell["Fractional binomial theorem:", "ExampleText",
 CellID->18842332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100841090],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox["x", "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "9"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "3"]}], "81"], "-", 
   FractionBox[
    RowBox[{"10", " ", 
     SuperscriptBox["x", "4"]}], "243"], "+", 
   FractionBox[
    RowBox[{"22", " ", 
     SuperscriptBox["x", "5"]}], "729"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[1, 3], 
    Rational[-1, 9], 
    Rational[5, 81], 
    Rational[-10, 243], 
    Rational[22, 729]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{242, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313436249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"1", "/", "3"}], ",", "k"}], "]"}], 
    RowBox[{"x", "^", "k"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159605382],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["x", "3"], "-", 
  FractionBox[
   SuperscriptBox["x", "2"], "9"], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox["x", "3"]}], "81"], "-", 
  FractionBox[
   RowBox[{"10", " ", 
    SuperscriptBox["x", "4"]}], "243"], "+", 
  FractionBox[
   RowBox[{"22", " ", 
    SuperscriptBox["x", "5"]}], "729"]}]], "Output",
 ImageSize->{196, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->562090038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->335674775],

Cell["Binomial coefficients mod 2:", "ExampleText",
 CellID->294290103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{"i", ",", "j"}], "]"}], ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "i"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->730152507],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1L40AUT0looaJQWaGygrILhQUFQaGgIOzBD1ARVljYQ6Glu/iFH9QK
HoQ9LOxBWPAgeBA8CIIHDx78/57zTLJ5k5mBwY6TDrGQ/DLzfu9lkpn35j3S
9VZ3+9d+q7vTbk0sd1pH2zvt44mlww7r8gue5z3hUfXYNbCr8PAB8AJ/j+wo
hE0fZS8/75GdCiHBaG/ATgFrTkaIA0HxlKSNGBB0wFrw31okm2ZYkmDJDR3y
dmajtzBDEMUDdtjc6GdYo86wznAoG45k3cTrI1CgT3iIc6/Ui7HyPhqd0Qjr
Htd3iWAxwoVUP2KRtEfcs0lmYgASn0IsR2/qa4RlhbyaR2vcXJS90PMHGS4y
HCLtMfs6Eu+qAO8VK8B7zzDw3jKeR2uCf6GfoL+sQuI36Eef7euQJx2NtDbI
qsR2rR/Z3LNWWeMbwzGGX8xzNHaV74r+GKfcsKbcCX4AH/mn3dCRxOYG8LF4
1g5biLdNCONsPRuOZN20U+tk3g5bmNctSLKNDDhk9HuQ7N8GpNzdd71wr+1R
ZiDj9TX1VPor76NxbzTaOX+6Py1fc8+mRsZOUSbfyKM1Zc2ASGuGTfs6Ghl7
BeQZO82TcmdNWTN8gKRmiLMsyzrkSeOKoAp8RdDoR7ZQU3yEsKZomudo7Crj
iv4Yf7phTbkTfAI+4m+5oSOJzTXgY/GeHbYQb7H2xTh7kA1Hsm7SX0Y6dtjC
vMZfKk6y4ZDRx18uTs1Iubvjl4ez3mUGMt7febSmnfP+sa+jkVH+7Ue2Mqc8
N8/RyND+9SNbmaNdmOdIMqpLM1Iha7p6W5mG71/bYSv9+SYbjsRDb81IBS+8
e1uZZB7uzUiF9/jQu4zc8XX/m3kKZYVnOaih/w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21990661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263428904],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " in the arguments' plane:"
}], "ExampleText",
 CellID->197779909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->495344356],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141180514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100309259],

Cell[TextData[{
 "Plot the logarithm of the number of ways to pick ",
 Cell[BoxData["k"], "InlineFormula"],
 " elements out of ",
 Cell[BoxData["n"], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "12"}], "}"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#2", "<=", "#1"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7705859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Compute higher derivatives of a product of two functions: ", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"4", ",", "k"}], "]"}], " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", "z", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "k"}], "}"}]}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"g", "[", "z", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", 
         RowBox[{"4", "-", "k"}]}], "}"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209505400],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWduO0zAQdZuk3UK1F7oLu9y2PCB+AH6BO+IJIR6rFdLuAwIt+yfAT8FH
lTixW+d40jNOUqlxPZ7r8Yxjux9WN5dfv61uri5Wy1fXqx+XVxc/ly+/X5ek
bGTM6K8x5uDUlL/X5a/qaz//yq8x98vnuCTddu1e2WZlOwf6A0efAf0c+s9a
9J0A/cjRC6Avod/m3zHQ8000JvMRrqvRsD8jfeR/CP0J4X9Exp8m+neH8OP4
mPA/JuOnif4dEf7Kn+ppiRa9omxvCVyFn0NAO3dzrOUP+z5XCqdnT6mncPSF
kn/aYjd3/DjO4j3uaNfHiXwszj72JD4WnxbXOntMVjcbSsCBEmL+FZt+rUjE
IebqpgtzECsmE7VImZluS5pHrgVnFT1G/m6+yhgP43GukuqG6ckgHqLWYkAM
pWpSotGrtjISk66qmBa/hlr6xMdB64dpZZWjiS30CsdT/dFVh9YrXT2kYoSV
oPWG5X43bDDrmZb++Y7j3d4iTIuIVqRVpmLWpdrCfGPy0n4g9kralfXHta+v
uhpJRRBrJNUrVivdsMJaYVqatWI/9oSFvor7o3zbj1fFqCaF+uBaEKMJlfDn
xn52WDQiijstiLPfkGC10w1zMWvY2pkUSYSFYHX4Gejvt2qfNjje6cjEbzOb
Galna+tbWOVa2cOgb1yWoi7tmdfvEvD9jfI43qYvvJEwDrnUMzjGgjsFmu0t
ug8E3dq4tDil+JJ6dk/FRRvb9paIamtUBduxzSMJrCOUwMyek4hQHtcPCYFx
Wz3v0ItZrbFDkVH4xeK91xMP28+ErGZ2D6HP5lWaR8kuw63OVC89dW28Xufr
5u30fsSB994L10qehnyz0CZ7hwgz7PX4+/Npiz7k30+0h36fDRQH6l2st3et
ffzFeOv/ExbRvD2JKC9A07ng8a7+c+jjHT2Tfy1Ekgu5/UbJV51hzK9E/D4l
8ktehyscykve7+Kvo/htn9MNteZ1Ehj35wTet4I3Y4HvnZLvbmXnj31Gpzfk
/aLiei/h1cjbj5TjrG5G/wGUvu4G\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87319476]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "z", "]"}], " ", 
    RowBox[{"g", "[", "z", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWduO0zAQdZuk3UK1F7oLu9y2PCB+AH6BO+IJIR6rFdLuAwIt+yfAT8FH
lTixW+d40jNOUqlxPZ7r8Yxjux9WN5dfv61uri5Wy1fXqx+XVxc/ly+/X5ek
bGTM6K8x5uDUlL/X5a/qaz//yq8x98vnuCTddu1e2WZlOwf6A0efAf0c+s9a
9J0A/cjRC6Avod/m3zHQ8000JvMRrqvRsD8jfeR/CP0J4X9Exp8m+neH8OP4
mPA/JuOnif4dEf7Kn+ppiRa9omxvCVyFn0NAO3dzrOUP+z5XCqdnT6mncPSF
kn/aYjd3/DjO4j3uaNfHiXwszj72JD4WnxbXOntMVjcbSsCBEmL+FZt+rUjE
IebqpgtzECsmE7VImZluS5pHrgVnFT1G/m6+yhgP43GukuqG6ckgHqLWYkAM
pWpSotGrtjISk66qmBa/hlr6xMdB64dpZZWjiS30CsdT/dFVh9YrXT2kYoSV
oPWG5X43bDDrmZb++Y7j3d4iTIuIVqRVpmLWpdrCfGPy0n4g9kralfXHta+v
uhpJRRBrJNUrVivdsMJaYVqatWI/9oSFvor7o3zbj1fFqCaF+uBaEKMJlfDn
xn52WDQiijstiLPfkGC10w1zMWvY2pkUSYSFYHX4Gejvt2qfNjje6cjEbzOb
Galna+tbWOVa2cOgb1yWoi7tmdfvEvD9jfI43qYvvJEwDrnUMzjGgjsFmu0t
ug8E3dq4tDil+JJ6dk/FRRvb9paIamtUBduxzSMJrCOUwMyek4hQHtcPCYFx
Wz3v0ItZrbFDkVH4xeK91xMP28+ErGZ2D6HP5lWaR8kuw63OVC89dW28Xufr
5u30fsSB994L10qehnyz0CZ7hwgz7PX4+/Npiz7k30+0h36fDRQH6l2st3et
ffzFeOv/ExbRvD2JKC9A07ng8a7+c+jjHT2Tfy1Ekgu5/UbJV51hzK9E/D4l
8ktehyscykve7+Kvo/htn9MNteZ1Ehj35wTet4I3Y4HvnZLvbmXnj31Gpzfk
/aLiei/h1cjbj5TjrG5G/wGUvu4G\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25592487]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " of the binomial probability distribution: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "20"}], ",", 
     RowBox[{"q", "=", "0.3"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{"BinomialDistribution", "[", 
      RowBox[{"n", ",", "q"}], "]"}], "]"}], "[", "k", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["0.3`", "k"], " ", 
  SuperscriptBox["0.7`", 
   RowBox[{"20", "-", "k"}]], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{"20", ",", "k"}], "]"}]}]], "Output",
 ImageSize->{183, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519451503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVz1PG0EQXd+HJeRUjiIlgOFMlXRJBUEiFAjS4DROlILKoEhYUUJwKCjp
aCB9JKdBkD8QK/kBaaCipc4fOfb21p7duWFuZXOnnORdz+7bNzO7b+6j1TnY
/fCpc9Dd6USve50vu92dr9HGXk8O+RUhxED+eo+F/B/Lf+o3iGPZZ9tF2foS
EOnek70n+zlti0DB9NWQRmCgptTkctIm4Fhdaq0IwE7xJmIW2T6yZ5ImTO1R
m2GpFuR9NpehKM8Nw7474yW9+003f4DQ6yJnL+Zo5OYtNL0JrSRRNddxe/pS
xzivez8GPXpajp5WojmfKtFU9iPE3ydHPyr74vx6deX76cnfVO6MHU6IV1mL
umzPVEXheFJFvH/3Uw6tr/XTXTHmgxw7nHB+UvwofzkE+wH5jPj2Pv/68/tG
z19d/pNDlB3mzOfhPfLU/SFKR4HrciEny9owK3mqSVYB4sO7hvmmyKhqSCtv
EOsKswpi+TZCJXXxAHFsIB/rJOdbxMmhgJtG0XXXt6L8MdZKc7SO8jpmUJDX
sRXFQ5TPEuLcJDlbiJNDATeNKmavUrmnF37iePpOnAxh1erV1j1fKT07YjLe
G0tilhnD8K1mvH3APnFM2bOoxvYzjV4xzrnjKm8zKFAuhwLltq2oppGnI5Lj
CfLEocATjSrnflJ+JZpv3y4KVG8GrAJdqsCN5a5KLDOGwliIihy+VdLnwJ//
q9iuiC0GBRXBoaAiaFQ52m+ivA4trwson0OGA/KhUf9TRdrfv851yXzjOWs5
h4Otyfvwn/ludM4+8w2IYyrmWbgY2wrdZlCgVA4FSqVR5VTeU5TXvuX1Gcpn
n+GAfGjU+JX3AsXYJdc8R7FyKIiVRmkNVW4Bo6bkvw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->279195489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot Bernstein polynomials: ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"n", ",", "k"}], "]"}], 
       RowBox[{"x", "^", "k"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], "^", "k"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->595819472]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6490],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions involving binomial coefficients:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{
     RowBox[{"n", "+", "1"}], ",", 
     RowBox[{"k", "+", "1"}]}], "]"}], "/", 
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153979136],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "n"}], 
  RowBox[{"1", "+", "k"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155932796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand into ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " functions:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "k"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n"}], "]"}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "k"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "k", "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{182, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34472193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Sums involving ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "0"}], "n"], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "k"], 
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", "n", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305352208]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "0"}], "\[Infinity]"], 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], " ", "k"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]], " ", "n"}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->841194581]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"j", "=", "k"}], "n"], 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "j"}], "]"}], " ", 
   RowBox[{"Binomial", "[", 
    RowBox[{"j", ",", "k"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "k"}], "+", "n"}]], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "k"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "k", "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{182, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->574411215]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "\[Infinity]"], 
  FractionBox["1", 
   RowBox[{"Binomial", "[", 
    RowBox[{
     RowBox[{"2", " ", "k"}], ",", "k"}], "]"}]]}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "27"], " ", 
  RowBox[{"(", 
   RowBox[{"9", "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", "\[Pi]"}]}], ")"}]}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->7619762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 "\[CloseCurlyQuote]s generating function:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "0"}], "\[Infinity]"], 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], " ", 
   RowBox[{"x", "^", "k"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "n"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145006230]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2209],

Cell["\<\
Large arguments can give results too large to be computed explicitly:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"10.", "^", "100"}], ",", 
   RowBox[{"10", "^", "99"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->11937757],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->371191398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"10.", "^", "6"}], ",", 
   RowBox[{"10.", "^", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["7.3331919507884341317943164`15.954589770191005*^141178"], \
"Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117899602]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112262177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "As a bivariate function, ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " ",
 "is not continuous in both variables at negative integers:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"-", "3"}], ",", " ", 
   RowBox[{"-", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99497431]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{
   RowBox[{"-", "3.0000001"}], ",", " ", 
   RowBox[{"-", "5.0000001"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["6.000000350000008`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->579171306]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20925],

Cell["Binomial coefficient mod \[Pi]:", "ExampleText",
 CellID->79631414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{"i", ",", "j"}], "]"}], ",", "Pi"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "i"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79662868],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnHuw0NMWxzut1fmlcpuMcoY4EeXqdVIUNeWgukYpRQo9Tg+VdLt6ie5U
ioYS4XIRRSkhUpNnD72NwXg008OpoQe9FHoqqvv9rJw77oy5fwidTr9m2Gfv
vdZ3fXf9fnuvtfb6nRZ5A3p275M3oFfXvErN+uX9o2evrv0rNe3bT0OWUaxY
sdn8l1VMPx/WT0f+s8OH+YE/r+m/jCNdYy7+FHtN/8s4InD0o/7fUf2x8uXL
e7ly5Sw7O9saNGjg8+fPt9NOOw0hK1GihFesWNHy8/OtZMmSPn78eGvZsqXX
rFnTbr/9dq9Xr5717dvXPvroI1++fLl17tw52rfeest79Ohhp556qtetW5fW
1HeNm+ZdctFKL/SF48Iz4brwTXZc9sKu7Lt4sBQXLxM/F8/gK94u/vbqq696
ur6iub5bbrnFX3rpJRs4cKAtW7bMf/jhBzvrrLN8/fr1Vrly5ehv2LDBzj33
XEdm9erVft111yVnnHGGtWnTxgYPHuzt27e3zMxM//DDD2379u1+1113JU8+
+aSpjT7jzCOHvPQypQ9O4IELPnawh13sw4M+vJCBJ3y1niRdT7qewrAe3uWd
O3faiBEj7PLLL/fXX3/devXq5bKLvrdo0cIee+wxe+ihh/zrr7+2Xbt2eV5e
nr3zzjvxnqtv9957b+wLF154obMO8fUqVapY//79o2XdGnfNx74g+cBBXzgm
PAdH+C472Au78Gf94mPi5eIHz+DLXqN1lU7XVTTWddJJJ/nmzZvtqaeesmnT
pnmZMmXs5ptvjvPpwQcf9HfffddWrFhhb7/9tlevXj2ecWQrVarkl112mc2a
NSu4gsW69NzzLiWXXHKJq+U9iHHmkUNeei79sAkeuOBjR/Zcdjmfggd84IWs
eLr4sp6/pOtJ11MY1nPTTTf5Aw88YCeffHK8u3qXQ69OnTp24403eteuXa1f
v37WrFkz/+qrr2zdunXhr+G3rVq1inPFDhw4EL5YjRo1vH79+jZ79my/5557
oqWv8fAZJRfnEHoFfp/wTLgufOyEPexin79n9hb2GvELnvDVesql6zk+1zN9
+nT/4osv8Ont1ltv9SRJ7Msvv/TWrVtHLCF9q1ChguXk5Lj4mZ51HzNmjK1Z
s8Z/+uknWjvzzDN906ZN1rRpU86IZNGiRabW1TfGmUdO8tFKP94Z8MAFH57E
ErLrsm/wgA+8xM/Fk/emfLqO42Mdhw4dCj38Cext3brV9u7d69oT7eWXX/YZ
M2bE3vr+++/HXG5url911VX2yCOPhN/BO4QcMWSpUqViPZ9//nm09BnXfLwD
yKOHPjjgCTd8ZuyAg13sMyc+8Ap+8NQ6stJ1pOv4M9dBfmbcuHE2d+7cyMeM
Hj3aevfu7d99953NmTPHd+/eHVxvuOEGf/TRRyN3gg+xb9++yMGQ98E+GHfe
eWfSp08fV2vqO/yZJ/cjefwUuJhwXHiBK3yXHZM9l12T/YgL4AMG+R3pVEz5
F07+zz33nH/77bfk9OIZxc6AAQN8yJAh1qhRo4gnwcL2/v37I47DHznllFO8
U6dO9uyzz4bvPGrUqIgJ4U5Ln3HmkUMePfTBAQ9c8LGDPexiHx7wgRf8xD87
5Z/y/yP448/g73zyySe2cOHCyF83btzYGzZsaBkZGRGnEWvxLvXs2dOaN2/u
TzzxBO9q8OHdu+aaa/ziiy9O4KPW1Y93n3nWI3mXnkk/3nPWBa7wTXZc9kx2
XfbhEXzIkYh35ZR34eB95ZVX+ptvvmlZWVkRhxMTCdPvv//+yHFdeuml9vHH
H9uCBQv8hRdesOeffz72fnJr7MeKrWKvJgfGWmjpM865QU4NefTQBwc84UYu
DzvYwy724SE+Ll7wrpLyTnkfDW9ytmeffTZ+ic2cOdPly9qqVatcP0duivwE
MWP37t2DU5cuXfzhhx+Ovfq2224j10WuIeH9IifBvQXjzCMn+chPSz9iQvDA
BZ+8BL4zP+MXwQM+4vvXlO+x4as4Jp5V9lieP+4Ovv/++8iDcheF7R07dtig
QYP8gw8+sMcff9x//PFH7p9c5zDPuo0dOzbiG1r6nM/cR0nOJW/ooQ+O8Fy4
kfeUHe4Swi72ebaJq8S3Rsr32PCtX7++c35y/vIzeRv2Ou4otddErEoukzOX
Z7FOnTqu5y/yQFdccYVddNFFCTGL2ugzzjxyyHPWk2sEBzxwwccOuUzOd+xj
WzxzUp4pz1/yJO7Vs45uPNfkuMFj35wwYYLn5uYa9+hPP/102CfObteuna1c
uTLiZvIxvEe0xO8aN8275GIflV7ok78RXuy/nLHcv3IeY5d3jfhfPOumPP8c
nvn5+ZFPefHFF+3qq6+OfTM7OzviP3x7ciz4TtgZOXKkbdmyxalB4nktXrx4
JlzURp9x5pFDHj30wQEPXPCxgz3sYl/86qX8Tkx+3L3xTJPvLVu2rHfo0MEW
LVrkpUqVsqVLlxbcb0TOjpzg/v37oxaHOFjy9sYbb4Qe8afGI7dBLq8gV4i+
cCKnzP2L8EOP2j3scscnuQYpvz+G39ChQ8N/Ip8AL56JqlWrRq3V+vXrY3/b
uHGjyQ+LOgD2r3nz5pFfSKhnJM9An3HmkUOeewVqtMABD1zwsSN7LrvwapTy
Ktq82Hu47+E+lGccH52aEp5V9iP2IeIEfHvOy23btvlnn30W8SE+Pz6U+q5x
ztOIDfDn0UMfHGpMiCl4J6i5xR52xSs35fX78FJMHXlEauTI00yZMoX6zaiv
wCeCAzXSZcqUiRivWrVqPnXq1Mhhqo0+48wjB0d8Juo/8InBAxd87tuJ4cWn
Scrnt/GhvuW+++4Lv4L8GHsD9QvEOdTWcq6QL6Emplu3buGzUk+xdu3aaPF5
NR4+BPkc5NFDHxzwyAMKP+xgT3z+lvIpEnySJUuWUD8VzyG13PItXX5j7BOM
k3uhbpBaPvkjCWcB/gt9xpmn/op7EPxNfFP48B5oPPBlv3lq/9efhwoVKvgr
r7zCtyRxFzh8+PA4b6mj4N+Ou3Hq5ck7cIfIPT1xJi19jTMfcsijhz444IEL
PnbEo2XK4/jiQZ1jkyZNyKnGO81ZgQ5jxBzkF/hOCd9B2Al3KGqjHpdxclDE
BpKPOjbOKPYecrRgcAbJfpvU/q/bp46ZfA57MVj4Uoq7486VfBB3Etz5ym+O
XBC10bT0GWceOeTRQx8c8MhDCR/7bVP7hdM+8fbdd98dcRHfh9SuXduuvfba
2OcL6kW57xR2kpWVFTkZ/Lef60njPJG8SS++V4EXeODKbvvU7hG7fBtw3nnn
GbHp5MmT45uBxYsXR96DPZVngG97iFepQ6Slz78htWHIIY8e+uAIL/Zd2e2Q
2j22dnXW+R133ME+HLmrnJycqG86/fTTIyfB3cqQIUMS6mjURp9x5iUX9y3k
1NjHwQFP9jqfOPZ+8VU7X99EFoBsLxVGeBycaOeff76VLl06PNhatWqZ6w8t
nqnGTfNxa4o8euhTzcEKZK3biWHtf//lWrVq5VWrVo3Ie+vWrRFRkVXlhogv
T6tXr55ZvHjx+CKAPuPMI0eVs/RCHxzZ6ZHa+X3tTJo0KaqF8OjIUn7zzTdR
OffMM8+Ep0d1cdu2baP6GO9a41FJJ7nIhqJHVZJweA56nyh2Cipq2KnJDJJV
AIvXDU+5WrVqYY8+48wjh3xBxY7w/57i/zZ8vEyy51RBUe3CzTOZAnZ8qqO4
zaHKSf3INJCRp+qF6if0fq5061dU8akEouoZjwMPHR0qXkeMGJFwE8GX4AUV
sMwjR9U0FUHCHZji/n9cvsLkDOQ3o/AV3cSJE+PWkawgmQlabhk1Ht4fv6EE
efSEO7io4PLlMlHfBRdcYIpE4hYkPz8/wQY3YvQZZ56bGMnz9/rP4xWPLDBf
Kp5zzjnWsWPH+M04fBnGbzSgpa9x5kMOeeENS/GO4PHlKHv/3r17o9ri+uuv
T9577z1TG5X8jHOLQ8QrnJHHCw7ZsoMHD8ZvViFKL/gam5Y+48wjJ5xRJxrO
sGHD4pabW7g9e/YkVF+ojds9xjXP3+/owqr/6aefxr7InsgNPr4iLX32Es2j
P7ao6vN+U2Un/yOhogE/hD7j0htXWPS4DSATTVzEDSAtGW0q3aX3r8KiR9WS
YrNMKsfURl/y/z5e5FkjZyVxEmcsfweSH3+s5LVXJzzD7OGSm1DY5Mi0s4af
M+KT/iS5hNyN5qcco/nIiGp+2h81r7npRz931L//cvaRuYz/AKekTGE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474623084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198145718],

Cell["\<\
Closed\[Hyphen]form inverse of Hilbert matrices: \
\>", "ExampleText",
 CellID->144715843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", "=", "4"}], "}"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"i", "+", "j"}], ")"}]}], 
       RowBox[{"(", 
        RowBox[{"i", "+", "j", "-", "1"}], ")"}], 
       RowBox[{"Binomial", "[", 
        RowBox[{
         RowBox[{"n", "+", "i", "-", "1"}], ",", 
         RowBox[{"n", "-", "j"}]}], "]"}], 
       RowBox[{"Binomial", "[", 
        RowBox[{
         RowBox[{"n", "+", "j", "-", "1"}], ",", 
         RowBox[{"n", "-", "i"}]}], "]"}], 
       RowBox[{
        RowBox[{"Binomial", "[", 
         RowBox[{
          RowBox[{"i", "+", "j", "-", "2"}], ",", 
          RowBox[{"i", "-", "1"}]}], "]"}], "^", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->753800624],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"16", 
      RowBox[{"-", "120"}], "240", 
      RowBox[{"-", "140"}]},
     {
      RowBox[{"-", "120"}], "1200", 
      RowBox[{"-", "2700"}], "1680"},
     {"240", 
      RowBox[{"-", "2700"}], "6480", 
      RowBox[{"-", "4200"}]},
     {
      RowBox[{"-", "140"}], "1680", 
      RowBox[{"-", "4200"}], "2800"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{185, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->125487889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->361423836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"], ",", 
     FractionBox["1", "7"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{416, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174431131]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Nested binomials over the complex plane:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DensityPlot", "[", 
   RowBox[{
    RowBox[{"Arg", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Binomial", "[", 
         RowBox[{"#", ",", 
          RowBox[{"#", "/", "2"}]}], "]"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "3"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.9"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "0.06"}], ",", "0.06"}], "}"}], ",", 
    RowBox[{"Exclusions", "->", 
     RowBox[{"{", "}"}]}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27029882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " at infinity:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DensityPlot", "[", 
   RowBox[{
    RowBox[{"Arg", "[", 
     RowBox[{"Binomial", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ")"}], ",", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], ")"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"Exclusions", "->", 
     RowBox[{"{", "}"}]}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyN3M+qbUcRx/Hjv7dwoBLFt9iToEQd5REEB/6JwTxChg5UruLA0SZTQeES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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxN3QncfVP1P/Dz3HtPpRAVhcoUJQ0qpMhYIomoaDLToDKUUihTaDI0z8ai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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJyMu3k0VeH/9i8phShpMpQypBQNqBSXJJmFSiHNo9AkUhopGRoUqShURJkK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    "]],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{
      Rational[-1, 2], 
      Rational[1, 2]}, {
      Rational[-1, 2], 
      Rational[1, 2]}}, {{-0.5, 0.5}, {-0.5, 0.5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174600704,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " for complex arguments: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"4.1", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Phi]1"}], "]"}]}], ",", 
      RowBox[{"2.2", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Phi]2"}], "]"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]1", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]2", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"Exclusions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->825152871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Binomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Binomial"]], "InlineFormula"],
 " at Gaussian integers:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "1000"}], "}"}], ",", 
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"Im", "@", 
         RowBox[{"Round", "[", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{"x", " ", "+", 
             RowBox[{"I", " ", "y"}]}], ",", "x"}], " ", "]"}], "]"}]}], ",", 
        "2"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "25"}], ",", "25"}], "}"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyVlNlRA0EQQ7vJhBjIhBBIgPz/KNiR9LSmOOxde46eviTN89v769vTzLyc
d/bz2fPsrGZ71uasn9nnM1qZy0FO5My1dZ297L8srmB7It1GEyNt2f0oV3lx
gDkBjoNBinFkb5erTeYarfcQhcWW5SjZ48a1JB90hpaaj6NoYftsNbiskhn6
EKTUKG3iX62zZbpNyGNUe6hKnhYpJT3ODro5q7Bx4JF6Haxu5BO2TVg0UUMH
Tbqm2oBlAH2TxH0MGqhWRUPyqRq1hgHEeOt7a2lDCM/GpVwAUkuk8q76bB6o
ALc1V4oi8wM5gj1QdxbmN8UYfmO3zFjsDlpucZUfusVERShS1cLNUK/ofkus
9sptbgrRQNzLVu4Q8aabVmjAolgZhUDI1C5njgc43AU0t8XsiKpiMbb8IC5H
2bh10EWUFBsNRBJeJUes31aQ8y7VxbkpzbbgSJppmZAiaAh/H/Yhp0KVr+Pr
gk5FJHG4iZIsdrBQ2Bt9czDyZ5hQEbIBVlMDMAlKK3aGtyCAF2mbltRdcDqn
rC2J3DmWDUFdHnEncyRWqKg49NM6af0ghW/Xwz4qCVR5XF/nN38ef8ep397/
f///+QD8ZAeQ
   "], {{0, 0}, {51, 51}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93520738]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11999],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Multinomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Multinomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pochhammer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pochhammer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factorial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinomialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19615]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5584],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->1447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->6868],

Cell[TextData[{
 ButtonBox["Demonstrations with Binomial",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Binomial"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#9246"], None}]], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/BinomialCoefficient.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/Binomial/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Binomial"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->665329142],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->39092241],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->528822525],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->360284066],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->7362522],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->686386893],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->241082909],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->418013255]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Binomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 10.6301040}", "context" -> "System`", 
    "keywords" -> {
     "binom", "binomials", "choose", "comb", "combinations", "nchoosek", 
      "n-choose-k", "nCk"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Binomial[n, m] gives the binomial coefficient ( { {n}, {m} } ). ", 
    "synonyms" -> {"n-choode-k"}, "title" -> "Binomial", "type" -> "Symbol", 
    "uri" -> "ref/Binomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6831, 220, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->940447840]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 370512, 7343}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3246, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3869, 99, 46, 1, 70, "ObjectName",
 CellID->30752],
Cell[3918, 102, 688, 24, 70, "Usage",
 CellID->1396]
}, Open  ]],
Cell[CellGroupData[{
Cell[4643, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5121, 148, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[5256, 154, 207, 7, 70, "Notes",
 CellID->771],
Cell[5466, 163, 629, 24, 70, "Notes",
 CellID->19529],
Cell[6098, 189, 267, 8, 70, "Notes",
 CellID->191084252],
Cell[6368, 199, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6589, 208, 205, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6831, 220, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->940447840],
Cell[CellGroupData[{
Cell[7216, 234, 148, 5, 70, "ExampleSection",
 CellID->115704259],
Cell[7367, 241, 64, 1, 70, "ExampleText",
 CellID->313630859],
Cell[CellGroupData[{
Cell[7456, 246, 128, 4, 28, "Input",
 CellID->281627810],
Cell[7587, 252, 160, 5, 36, "Output",
 CellID->221977480]
}, Open  ]],
Cell[7762, 260, 125, 3, 70, "ExampleDelimiter",
 CellID->137786803],
Cell[7890, 265, 68, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7983, 269, 372, 12, 70, "Input"],
Cell[8358, 283, 826, 30, 108, "Output",
 CellID->134786694]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9233, 319, 216, 7, 70, "ExampleSection",
 CellID->13631],
Cell[CellGroupData[{
Cell[9474, 330, 144, 5, 70, "Input",
 CellID->41],
Cell[9621, 337, 305, 11, 51, "Output",
 CellID->99103020]
}, Open  ]],
Cell[9941, 351, 88, 1, 70, "ExampleText",
 CellID->44510365],
Cell[CellGroupData[{
Cell[10054, 356, 132, 4, 70, "Input",
 CellID->330634137],
Cell[10189, 362, 355, 13, 51, "Output",
 CellID->26199194]
}, Open  ]],
Cell[10559, 378, 125, 3, 70, "ExampleDelimiter",
 CellID->211611581],
Cell[10687, 383, 192, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10904, 394, 145, 4, 70, "Input"],
Cell[11052, 400, 332, 10, 36, "Output",
 CellID->322725026]
}, Open  ]],
Cell[11399, 413, 105, 2, 70, "ExampleDelimiter"],
Cell[11507, 417, 59, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[11591, 421, 160, 5, 70, "Input"],
Cell[11754, 428, 180, 6, 51, "Output",
 CellID->208809489]
}, Open  ]],
Cell[11949, 437, 105, 2, 70, "ExampleDelimiter"],
Cell[12057, 441, 63, 1, 70, "ExampleText",
 CellID->13889856],
Cell[CellGroupData[{
Cell[12145, 446, 150, 5, 70, "Input",
 CellID->196713376],
Cell[12298, 453, 197, 6, 36, "Output",
 CellID->145764886]
}, Open  ]],
Cell[12510, 462, 125, 3, 70, "ExampleDelimiter",
 CellID->797776786],
Cell[12638, 467, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12717, 471, 197, 7, 70, "Input"],
Cell[12917, 480, 271, 8, 36, "Output",
 CellID->466447723]
}, Open  ]],
Cell[13203, 491, 125, 3, 70, "ExampleDelimiter",
 CellID->800287604],
Cell[13331, 496, 205, 8, 70, "ExampleText",
 CellID->46157309],
Cell[CellGroupData[{
Cell[13561, 508, 242, 8, 70, "Input",
 CellID->776392389],
Cell[13806, 518, 181, 6, 36, "Output",
 CellID->984890341]
}, Open  ]],
Cell[CellGroupData[{
Cell[14024, 529, 268, 9, 70, "Input",
 CellID->233743718],
Cell[14295, 540, 407, 15, 64, "Output",
 CellID->215406657]
}, Open  ]],
Cell[14717, 558, 105, 2, 70, "ExampleDelimiter"],
Cell[14825, 562, 57, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14907, 566, 225, 7, 70, "Input"],
Cell[15135, 575, 1211, 38, 51, "Output",
 CellID->178498341]
}, Open  ]],
Cell[16361, 616, 105, 2, 70, "ExampleDelimiter"],
Cell[16469, 620, 183, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16677, 630, 146, 4, 70, "Input"],
Cell[16826, 636, 527, 22, 66, "Output",
 CellID->88087656]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17402, 664, 239, 7, 70, "ExampleSection",
 CellID->18848],
Cell[17644, 673, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17733, 677, 114, 3, 70, "Input"],
Cell[17850, 682, 168, 5, 36, "Output",
 CellID->144984188]
}, Open  ]],
Cell[CellGroupData[{
Cell[18055, 692, 153, 5, 70, "Input"],
Cell[18211, 699, 157, 5, 36, "Output",
 CellID->92315617]
}, Open  ]],
Cell[18383, 707, 105, 2, 70, "ExampleDelimiter"],
Cell[18491, 711, 198, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18714, 721, 196, 6, 70, "Input"],
Cell[18913, 729, 240, 8, 36, "Output",
 CellID->125345701]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19202, 743, 222, 7, 70, "ExampleSection",
 CellID->7971],
Cell[19427, 752, 75, 1, 70, "ExampleText",
 CellID->638563130],
Cell[CellGroupData[{
Cell[19527, 757, 286, 10, 70, "Input",
 CellID->7241833],
Cell[19816, 769, 228, 8, 36, "Output",
 CellID->309132385]
}, Open  ]],
Cell[CellGroupData[{
Cell[20081, 782, 175, 6, 70, "Input",
 CellID->187084880],
Cell[20259, 790, 717, 24, 36, "Output",
 CellID->139348934]
}, Open  ]],
Cell[20991, 817, 123, 3, 70, "ExampleDelimiter",
 CellID->4049201],
Cell[21117, 822, 70, 1, 70, "ExampleText",
 CellID->18842332],
Cell[CellGroupData[{
Cell[21212, 827, 310, 11, 70, "Input",
 CellID->100841090],
Cell[21525, 840, 881, 31, 54, "Output",
 CellID->313436249]
}, Open  ]],
Cell[CellGroupData[{
Cell[22443, 876, 315, 11, 70, "Input",
 CellID->159605382],
Cell[22761, 889, 508, 18, 54, "Output",
 CellID->562090038]
}, Open  ]],
Cell[23284, 910, 125, 3, 70, "ExampleDelimiter",
 CellID->335674775],
Cell[23412, 915, 71, 1, 70, "ExampleText",
 CellID->294290103],
Cell[CellGroupData[{
Cell[23508, 920, 399, 13, 70, "Input",
 CellID->730152507],
Cell[23910, 935, 1106, 22, 70, "Output",
 Evaluatable->False,
 CellID->21990661]
}, Open  ]],
Cell[25031, 960, 125, 3, 70, "ExampleDelimiter",
 CellID->263428904],
Cell[25159, 965, 212, 8, 70, "ExampleText",
 CellID->197779909],
Cell[CellGroupData[{
Cell[25396, 977, 360, 12, 70, "Input",
 CellID->495344356],
Cell[25759, 991, 24401, 404, 70, "Output",
 Evaluatable->False,
 CellID->141180514]
}, Open  ]],
Cell[50175, 1398, 125, 3, 70, "ExampleDelimiter",
 CellID->100309259],
Cell[50303, 1403, 191, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[50519, 1413, 453, 14, 70, "Input"],
Cell[50975, 1429, 13427, 224, 70, "Output",
 Evaluatable->False,
 CellID->7705859]
}, Open  ]],
Cell[64417, 1656, 105, 2, 70, "ExampleDelimiter"],
Cell[64525, 1660, 83, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[64633, 1665, 623, 21, 70, "Input",
 CellID->209505400],
Cell[65259, 1688, 1276, 25, 70, "Output",
 Evaluatable->False,
 CellID->87319476]
}, Open  ]],
Cell[CellGroupData[{
Cell[66572, 1718, 233, 8, 70, "Input"],
Cell[66808, 1728, 1276, 25, 70, "Output",
 Evaluatable->False,
 CellID->25592487]
}, Open  ]],
Cell[68099, 1756, 105, 2, 70, "ExampleDelimiter"],
Cell[68207, 1760, 190, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[68422, 1770, 348, 12, 70, "Input"],
Cell[68773, 1784, 330, 11, 36, "Output",
 CellID->519451503]
}, Open  ]],
Cell[CellGroupData[{
Cell[69140, 1800, 202, 6, 70, "Input"],
Cell[69345, 1808, 1111, 22, 70, "Output",
 Evaluatable->False,
 CellID->279195489]
}, Open  ]],
Cell[70471, 1833, 105, 2, 70, "ExampleDelimiter"],
Cell[70579, 1837, 51, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[70655, 1841, 609, 19, 70, "Input"],
Cell[71267, 1862, 10888, 183, 70, "Output",
 Evaluatable->False,
 CellID->595819472]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82204, 2051, 232, 7, 70, "ExampleSection",
 CellID->6490],
Cell[82439, 2060, 231, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[82695, 2071, 305, 10, 70, "Input",
 CellID->153979136],
Cell[83003, 2083, 224, 8, 51, "Output",
 CellID->155932796]
}, Open  ]],
Cell[83242, 2094, 105, 2, 70, "ExampleDelimiter"],
Cell[83350, 2098, 323, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[83698, 2114, 149, 4, 70, "Input"],
Cell[83850, 2120, 383, 13, 53, "Output",
 CellID->34472193]
}, Open  ]],
Cell[84248, 2136, 105, 2, 70, "ExampleDelimiter"],
Cell[84356, 2140, 178, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[84559, 2151, 279, 10, 70, "Input"],
Cell[84841, 2163, 199, 6, 36, "Output",
 CellID->305352208]
}, Open  ]],
Cell[CellGroupData[{
Cell[85077, 2174, 223, 7, 70, "Input"],
Cell[85303, 2183, 248, 9, 36, "Output",
 CellID->841194581]
}, Open  ]],
Cell[CellGroupData[{
Cell[85588, 2197, 274, 9, 70, "Input"],
Cell[85865, 2208, 480, 17, 56, "Output",
 CellID->574411215]
}, Open  ]],
Cell[CellGroupData[{
Cell[86382, 2230, 247, 8, 70, "Input"],
Cell[86632, 2240, 302, 11, 51, "Output",
 CellID->7619762]
}, Open  ]],
Cell[86949, 2254, 105, 2, 70, "ExampleDelimiter"],
Cell[87057, 2258, 207, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[87289, 2269, 247, 8, 70, "Input"],
Cell[87539, 2279, 228, 8, 36, "Output",
 CellID->145006230]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[87816, 2293, 225, 7, 70, "ExampleSection",
 CellID->2209],
Cell[88044, 2302, 100, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[88169, 2308, 161, 5, 70, "Input"],
Cell[88333, 2315, 357, 7, 70, "Message",
 CellID->11937757],
Cell[88693, 2324, 187, 6, 36, "Output",
 CellID->371191398]
}, Open  ]],
Cell[88895, 2333, 105, 2, 70, "ExampleDelimiter"],
Cell[89003, 2337, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[89121, 2343, 159, 5, 70, "Input"],
Cell[89283, 2350, 214, 6, 36, "Output",
 CellID->117899602]
}, Open  ]],
Cell[CellGroupData[{
Cell[89534, 2361, 90, 2, 70, "Input"],
Cell[89627, 2365, 162, 5, 36, "Output",
 CellID->112262177]
}, Open  ]],
Cell[89804, 2373, 105, 2, 70, "ExampleDelimiter"],
Cell[89912, 2377, 250, 8, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[90187, 2389, 150, 5, 70, "Input"],
Cell[90340, 2396, 157, 5, 36, "Output",
 CellID->99497431]
}, Open  ]],
Cell[CellGroupData[{
Cell[90534, 2406, 166, 5, 70, "Input"],
Cell[90703, 2413, 175, 5, 36, "Output",
 CellID->579171306]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[90927, 2424, 224, 7, 70, "ExampleSection",
 CellID->20925],
Cell[91154, 2433, 73, 1, 70, "ExampleText",
 CellID->79631414],
Cell[CellGroupData[{
Cell[91252, 2438, 399, 13, 70, "Input",
 CellID->79662868],
Cell[91654, 2453, 4539, 78, 70, "Output",
 Evaluatable->False,
 CellID->474623084]
}, Open  ]],
Cell[96208, 2534, 125, 3, 70, "ExampleDelimiter",
 CellID->198145718],
Cell[96336, 2539, 100, 3, 70, "ExampleText",
 CellID->144715843],
Cell[CellGroupData[{
Cell[96461, 2546, 1086, 35, 70, "Input",
 CellID->753800624],
Cell[97550, 2583, 1016, 32, 92, "Output",
 CellID->125487889]
}, Open  ]],
Cell[CellGroupData[{
Cell[98603, 2620, 103, 3, 70, "Input",
 CellID->361423836],
Cell[98709, 2625, 860, 30, 51, "Output",
 CellID->174431131]
}, Open  ]],
Cell[99584, 2658, 105, 2, 70, "ExampleDelimiter"],
Cell[99692, 2662, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[99780, 2666, 696, 22, 70, "Input"],
Cell[100479, 2690, 46417, 765, 70, "Output",
 Evaluatable->False,
 CellID->27029882]
}, Open  ]],
Cell[146911, 3458, 105, 2, 70, "ExampleDelimiter"],
Cell[147019, 3462, 180, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[147224, 3473, 793, 26, 70, "Input"],
Cell[148020, 3501, 156964, 2589, 238, 73740, 1220, "CachedBoxData", \
"BoxData", "Output",
 CellID->174600704]
}, Open  ]],
Cell[304999, 6093, 105, 2, 70, "ExampleDelimiter"],
Cell[305107, 6097, 191, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[305323, 6108, 652, 20, 70, "Input"],
Cell[305978, 6130, 55938, 921, 70, "Output",
 Evaluatable->False,
 CellID->825152871]
}, Open  ]],
Cell[361931, 7054, 105, 2, 70, "ExampleDelimiter"],
Cell[362039, 7058, 189, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[362253, 7069, 732, 23, 70, "Input"],
Cell[362988, 7094, 1027, 24, 246, "Output",
 CellID->93520738]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[364076, 7125, 311, 9, 70, "SeeAlsoSection",
 CellID->11999],
Cell[364390, 7136, 1220, 44, 70, "SeeAlso",
 CellID->19615]
}, Open  ]],
Cell[CellGroupData[{
Cell[365647, 7185, 313, 9, 70, "TutorialsSection",
 CellID->5584],
Cell[365963, 7196, 155, 3, 70, "Tutorials",
 CellID->1447]
}, Open  ]],
Cell[CellGroupData[{
Cell[366155, 7204, 320, 9, 70, "RelatedLinksSection",
 CellID->6868],
Cell[366478, 7215, 361, 12, 70, "RelatedLinks"],
Cell[366842, 7229, 250, 5, 70, "RelatedLinks"],
Cell[367095, 7236, 190, 4, 70, "RelatedLinks"],
Cell[367288, 7242, 193, 4, 70, "RelatedLinks"],
Cell[367484, 7248, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[367907, 7266, 319, 9, 70, "MoreAboutSection",
 CellID->665329142],
Cell[368229, 7277, 156, 3, 70, "MoreAbout",
 CellID->39092241],
Cell[368388, 7282, 151, 3, 70, "MoreAbout",
 CellID->528822525],
Cell[368542, 7287, 165, 3, 70, "MoreAbout",
 CellID->360284066],
Cell[368710, 7292, 180, 3, 70, "MoreAbout",
 CellID->7362522],
Cell[368893, 7297, 145, 3, 70, "MoreAbout",
 CellID->686386893],
Cell[369041, 7302, 155, 3, 70, "MoreAbout",
 CellID->241082909],
Cell[369199, 7307, 165, 3, 70, "MoreAbout",
 CellID->418013255]
}, Open  ]],
Cell[369379, 7313, 27, 0, 70, "History"],
Cell[369409, 7315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

