(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39644,       1287]
NotebookOptionsPosition[     33284,       1054]
NotebookOutlinePosition[     34475,       1090]
CellTagsIndexPosition[     34389,       1085]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BitAnd" :> Documentation`HelpLookup["paclet:ref/BitAnd"], 
          "BitXor" :> Documentation`HelpLookup["paclet:ref/BitXor"], "BitNot" :> 
          Documentation`HelpLookup["paclet:ref/BitNot"], "BitSet" :> 
          Documentation`HelpLookup["paclet:ref/BitSet"], "Or" :> 
          Documentation`HelpLookup["paclet:ref/Or"], "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BitAnd\"\>", 2->"\<\"BitXor\"\>", 
       3->"\<\"BitNot\"\>", 4->"\<\"BitSet\"\>", 5->"\<\"Or\"\>", 
       6->"\<\"IntegerDigits\"\>", 
       7->"\<\"CellularAutomaton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bitwise Operations" :> 
          Documentation`HelpLookup["paclet:guide/BitwiseOperations"], 
          "Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Bitwise Operations\"\>", 
       2->"\<\"Cryptographic Number Theory\"\>", 
       3->"\<\"Integer Functions\"\>", 
       4->"\<\"Number Digits\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BitOr", "ObjectName",
 CellID->1925],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BitOr",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BitOr"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the bitwise OR of the integers ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21202]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitOr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitOr"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " yields the integer whose binary bit representation has ones at positions \
where the binary bit representations of any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " have ones. "
}], "Notes",
 CellID->9095],

Cell[TextData[{
 "For negative integers ",
 Cell[BoxData[
  ButtonBox["BitOr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitOr"]], "InlineFormula"],
 " assumes a two's complement representation. "
}], "Notes",
 CellID->30628],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitOr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitOr"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->259449840],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->172556513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{"61", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4724],

Cell[BoxData["63"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31686]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerDigits", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"61", ",", "15", ",", "63"}], "}"}], ",", "2", ",", "6"}], "]"}],
   "//", "Column"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15986],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVt0OgiAUPormamvVXZfe9x511UMw16YXLWa9vwH+rB3JwBRaw41zOJ8I
Hxz8ds70kV+u9FFkND2VlOVFdk+Pt5JDJAAAxtthD7xf8Z5srKq4r20kLBGo
fGCJ4s3EMZGrEoSuuAl5uP3gd+i7UDmbQGPo723hCFezxKOiZo84AzbwPtsQ
obFhnk1jPH+gdWZTsxiXOc/CNgsVqqMfrce3rVYlNmj/USlFTBTnkbzB3Sil
ROMulmOg07Nk8K1b1SRKbmslakdB1Wc5D6NvsusZ/RYjFUqa1VrvFdd9bWqq
3G5qU3PNnr9C1fub7NSpelzsVGiey/RcxtSvryo7pKYQPAE014vH\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{112, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99751359]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15868],

Cell["Use numbers of any size:", "ExampleText",
 CellID->17616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{
   RowBox[{"3", "^", "100"}], ",", 
   RowBox[{"5", "^", "100"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16218],

Cell[BoxData[\
"7888609052210118054117297117069515706082347426840895402878464599718897"], \
"Output",
 ImageSize->{543, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitOr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitOr"]], "InlineFormula"],
 " takes any number of arguments:"
}], "ExampleText",
 CellID->13163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{"3333", ",", "5555", ",", "7777", ",", "9999"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10879],

Cell[BoxData["16383"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19372],

Cell["Use negative numbers:", "ExampleText",
 CellID->26843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8807],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26217]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7326],

Cell["Basic symbolic simplifications are done automatically:", "ExampleText",
 CellID->14017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{"x", ",", "y", ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10180],

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30057]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{"1", ",", "2", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19869],

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{"3", ",", "x"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15458],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " corresponds to having all bits on:"
}], "ExampleText",
 CellID->3700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "2", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15622],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7274]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16828],

Cell["Make a nested pattern:", "ExampleText",
 CellID->13914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{"BitOr", "[", 
       RowBox[{"i", ",", "j"}], "]"}], "==", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "63"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "63"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27958],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJylldEJAzEMQ+1u0k06Q0foAt3/r7R3JRebSJF9IQgjLg9jhO+v9/N1M7PH
edufN49573rzflvo6O+Vhh5SV2/qf4zV+jzl2kYvpfrSS6m262uFenqtUM+l
XnuzjnFW/XBkP+RZ9sOV/ZBn2Q95lv2QZ9kPKvuLuW77i7lu+4u5bvu+7m3L
B71t+fD1DR/b3Mc298lHfk/5ZnnPfHw5H1/Ox/ud8w0q52PlfKycj/c75+P9
zvl4v3M+3u+cj/c75+P9zvm45nxcc76W98zX8p75Wt4zX8t75mt5z3wt75k/
q86fVefX5j74tbkPfr33g1/v/eB36PW5D37r9ybd/QNaOg9Q
   "], {{0, 0}, {64, 64}}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BitOr", "[", 
     RowBox[{"i", ",", 
      RowBox[{"2", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "64"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8592],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJxdkstKA0EUBS+uXLpw4cKFioiIhPh+RJ020UQzTkZcKb4gEHDnL+TT+pP8
hESmjuAJhKJucdM0nfXx99NkISLS/PvL5vNTNFxMDOBK+j9fhUtwGy7Dlu3t
2p76GjyFG7ADN+EV3IKFnXsBd6zrXO23rLfhHdxrOL3H92EJD+jyQziCR/Qa
P4byE+u69wM8o1f4ue13bF/31vmX1nVveWE9wWfmeMbjmvkLxDMeXfhKxzMe
PebqPes38IOOZzxumX9CPOPRh+p96wPbH1jXu7/R8YwH/4PpO8QzHkM7f2i/
X9r5pXW9u+6P/92/sv3K9vXu6iPrte3X1h/hV5oBK+Bg5Q==
    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->3921]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BitOr", "[", 
     RowBox[{"i", ",", 
      RowBox[{"2", "i"}], ",", 
      RowBox[{"3", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "64"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5340],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJxdks1KAlEYhg+uWrpw0aJFhkRIiFaaZjnHnzQdnYlWhVASBK30Fs6lzaV4
CV6Cxjxf4DswPLzfM+98HGbK35u3n4Jzzh/uP+bXLsp54hnAU388r8EivIIl
8dbrwTMYwXPYhhewCyvSv8wZUtmbwKr4a2i5Jr4OX2ADPyXfwBjeSv9O9jfF
t8hf5PucmWU79yfs4C0/SL8r/Udo+Ul8T/qReA/feY6ckV2f+QckZ0v8AJLD
QPzweH8Yyv4R5LyB/H/+Z+mTtxv8mDk5jMVPeJ/5iXj77ms8eUV2/AeZ+an0
Z7J/Jj6W/bH4OTRPXplfSH8h/UT2J+JT6afiX+Gv3wMD5GrY
    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17089]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15536],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{"BitOr", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31493],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "1"},
    {"1", "0"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5021],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitOr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitOr"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{"y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27094],

Cell[BoxData[
 RowBox[{"BitOr", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22218]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"BitOr", ",", 
    RowBox[{"{", 
     RowBox[{"63", ",", "63"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29027],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39238897]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Cuboid", "[", 
     RowBox[{"{", 
      RowBox[{"i", ",", "j", ",", 
       RowBox[{"BitOr", "[", 
        RowBox[{"i", ",", "j"}], "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "31"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "31"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22085],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333807284]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24813],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitAnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitAnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitXor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitXor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitNot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitNot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitSet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Or",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellularAutomaton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellularAutomaton"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15546]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16255],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->3396]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->294446152],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "MoreAbout",
 CellID->201427377],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->443511307],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->534865773],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->312459031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with BitOr",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=BitOr"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
BitOr"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BitOr - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 16.5677560}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BitOr[n_1, n_2, ...] gives the bitwise OR of the integers n_i. ", 
    "synonyms" -> {"bit or"}, "title" -> "BitOr", "type" -> "Symbol", "uri" -> 
    "ref/BitOr"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6091, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->259449840]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34246, 1078}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2854, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3477, 91, 42, 1, 70, "ObjectName",
 CellID->1925],
Cell[3522, 94, 809, 27, 70, "Usage",
 CellID->21202]
}, Open  ]],
Cell[CellGroupData[{
Cell[4368, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4846, 143, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4981, 149, 636, 22, 70, "Notes",
 CellID->9095],
Cell[5620, 173, 232, 8, 70, "Notes",
 CellID->30628],
Cell[5855, 183, 199, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6091, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->259449840],
Cell[CellGroupData[{
Cell[6476, 209, 148, 5, 70, "ExampleSection",
 CellID->172556513],
Cell[CellGroupData[{
Cell[6649, 218, 121, 4, 28, "Input",
 CellID->4724],
Cell[6773, 224, 155, 5, 36, "Output",
 CellID->31686]
}, Open  ]],
Cell[CellGroupData[{
Cell[6965, 234, 235, 8, 28, "Input",
 CellID->15986],
Cell[7203, 244, 568, 13, 64, "Output",
 Evaluatable->False,
 CellID->99751359]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7820, 263, 216, 7, 70, "ExampleSection",
 CellID->15868],
Cell[8039, 272, 63, 1, 70, "ExampleText",
 CellID->17616],
Cell[CellGroupData[{
Cell[8127, 277, 172, 6, 70, "Input",
 CellID->16218],
Cell[8302, 285, 227, 7, 36, "Output",
 CellID->8344]
}, Open  ]],
Cell[8544, 295, 121, 3, 70, "ExampleDelimiter",
 CellID->20604],
Cell[8668, 300, 198, 7, 70, "ExampleText",
 CellID->13163],
Cell[CellGroupData[{
Cell[8891, 311, 152, 4, 70, "Input",
 CellID->10879],
Cell[9046, 317, 158, 5, 36, "Output",
 CellID->16015]
}, Open  ]],
Cell[9219, 325, 121, 3, 70, "ExampleDelimiter",
 CellID->19372],
Cell[9343, 330, 60, 1, 70, "ExampleText",
 CellID->26843],
Cell[CellGroupData[{
Cell[9428, 335, 157, 6, 70, "Input",
 CellID->8807],
Cell[9588, 343, 171, 6, 36, "Output",
 CellID->26217]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9808, 355, 238, 7, 70, "ExampleSection",
 CellID->7326],
Cell[10049, 364, 93, 1, 70, "ExampleText",
 CellID->14017],
Cell[CellGroupData[{
Cell[10167, 369, 140, 4, 70, "Input",
 CellID->10180],
Cell[10310, 375, 208, 7, 36, "Output",
 CellID->30057]
}, Open  ]],
Cell[CellGroupData[{
Cell[10555, 387, 130, 4, 70, "Input",
 CellID->19869],
Cell[10688, 393, 208, 7, 36, "Output",
 CellID->22536]
}, Open  ]],
Cell[10911, 403, 121, 3, 70, "ExampleDelimiter",
 CellID->15458],
Cell[11035, 408, 144, 5, 70, "ExampleText",
 CellID->3700],
Cell[CellGroupData[{
Cell[11204, 417, 149, 5, 70, "Input",
 CellID->15622],
Cell[11356, 424, 170, 6, 36, "Output",
 CellID->7274]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11575, 436, 223, 7, 70, "ExampleSection",
 CellID->16828],
Cell[11801, 445, 61, 1, 70, "ExampleText",
 CellID->13914],
Cell[CellGroupData[{
Cell[11887, 450, 416, 13, 70, "Input",
 CellID->27958],
Cell[12306, 465, 697, 17, 246, "Output",
 CellID->25899]
}, Open  ]],
Cell[13018, 485, 121, 3, 70, "ExampleDelimiter",
 CellID->22427],
Cell[CellGroupData[{
Cell[13164, 492, 293, 10, 70, "Input",
 CellID->8592],
Cell[13460, 504, 744, 19, 163, "Output",
 CellID->3921]
}, Open  ]],
Cell[CellGroupData[{
Cell[14241, 528, 325, 11, 70, "Input",
 CellID->5340],
Cell[14569, 541, 673, 17, 136, "Output",
 CellID->17089]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15291, 564, 233, 7, 70, "ExampleSection",
 CellID->15536],
Cell[15527, 573, 183, 8, 70, "ExampleText",
 CellID->18043],
Cell[CellGroupData[{
Cell[15735, 585, 268, 9, 70, "Input",
 CellID->31493],
Cell[16006, 596, 217, 10, 48, "Output",
 CellID->32146]
}, Open  ]],
Cell[16238, 609, 120, 3, 70, "ExampleDelimiter",
 CellID->5021],
Cell[16361, 614, 298, 12, 70, "ExampleText",
 CellID->15828],
Cell[CellGroupData[{
Cell[16684, 630, 120, 4, 70, "Input",
 CellID->27094],
Cell[16807, 636, 208, 7, 36, "Output",
 CellID->22218]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17064, 649, 223, 7, 70, "ExampleSection",
 CellID->9496],
Cell[CellGroupData[{
Cell[17312, 660, 214, 7, 70, "Input",
 CellID->29027],
Cell[17529, 669, 2586, 46, 70, "Output",
 Evaluatable->False,
 CellID->39238897]
}, Open  ]],
Cell[CellGroupData[{
Cell[20152, 720, 436, 14, 70, "Input",
 CellID->22085],
Cell[20591, 736, 7972, 135, 70, "Output",
 Evaluatable->False,
 CellID->333807284]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28624, 878, 311, 9, 70, "SeeAlsoSection",
 CellID->24813],
Cell[28938, 889, 1676, 62, 70, "SeeAlso",
 CellID->15546]
}, Open  ]],
Cell[CellGroupData[{
Cell[30651, 956, 314, 9, 70, "TutorialsSection",
 CellID->16255],
Cell[30968, 967, 197, 4, 70, "Tutorials",
 CellID->3396]
}, Open  ]],
Cell[CellGroupData[{
Cell[31202, 976, 319, 9, 70, "MoreAboutSection",
 CellID->294446152],
Cell[31524, 987, 147, 3, 70, "MoreAbout",
 CellID->201427377],
Cell[31674, 992, 164, 3, 70, "MoreAbout",
 CellID->443511307],
Cell[31841, 997, 145, 3, 70, "MoreAbout",
 CellID->534865773],
Cell[31989, 1002, 137, 3, 70, "MoreAbout",
 CellID->312459031]
}, Open  ]],
Cell[CellGroupData[{
Cell[32163, 1010, 305, 8, 70, "RelatedLinksSection"],
Cell[32471, 1020, 355, 12, 70, "RelatedLinks"],
Cell[32829, 1034, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[33227, 1050, 27, 0, 70, "History"],
Cell[33257, 1052, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

