(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17447,        601]
NotebookOptionsPosition[     13829,        481]
NotebookOutlinePosition[     15194,        519]
CellTagsIndexPosition[     15109,        514]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BitShiftLeft" :> 
          Documentation`HelpLookup["paclet:ref/BitShiftLeft"], "Quotient" :> 
          Documentation`HelpLookup["paclet:ref/Quotient"], "RotateRight" :> 
          Documentation`HelpLookup["paclet:ref/RotateRight"], "BitLength" :> 
          Documentation`HelpLookup["paclet:ref/BitLength"], "BitGet" :> 
          Documentation`HelpLookup["paclet:ref/BitGet"], "MantissaExponent" :> 
          Documentation`HelpLookup["paclet:ref/MantissaExponent"], 
          "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BitShiftLeft\"\>", 
       2->"\<\"Quotient\"\>", 3->"\<\"RotateRight\"\>", 
       4->"\<\"BitLength\"\>", 5->"\<\"BitGet\"\>", 
       6->"\<\"MantissaExponent\"\>", 
       7->"\<\"CellularAutomaton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Bitwise Operations" :> 
          Documentation`HelpLookup["paclet:guide/BitwiseOperations"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Bitwise Operations\"\>", 
       2->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BitShiftRight", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BitShiftRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BitShiftRight"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]shifts the binary bits in the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " to the right by ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " places, dropping bits that are shifted past the unit's position on the \
right.  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BitShiftRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BitShiftRight"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]shifts one bit to the right."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitShiftRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitShiftRight"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"], "[", 
   RowBox[{
    StyleBox["n", "TI"], "/", 
    RowBox[{"2", "^", 
     StyleBox["k", "TI"]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25452],

Cell[TextData[{
 "Negative values of ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " shift to the left. "
}], "Notes",
 CellID->2741]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->716025242],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->154842692],

Cell["Shift 3 places to the right:", "ExampleText",
 CellID->301542513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitShiftRight", "[", 
  RowBox[{"32", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56784263],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->666387624]
}, Open  ]],

Cell["Shift 7 places to the right, leaving no nonzero bits: ", "ExampleText",
 CellID->371336790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitShiftRight", "[", 
  RowBox[{"32", ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29813631],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->612063732]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitShiftRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitShiftRight"]], "InlineFormula"],
 " works with numbers of any size:"
}], "ExampleText",
 CellID->17203584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitShiftRight", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "200"}], "-", "1"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->789683600],

Cell[BoxData["12554203470773361527671578846415332832204710888928069025791"], \
"Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337379539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190170383],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitShiftRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitShiftRight"]], "InlineFormula"],
 " automatically threads itself over lists:"
}], "ExampleText",
 CellID->124216887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitShiftRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "16"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583507249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "1", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342399657]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitShiftLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitShiftLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotateRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateRight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitGet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MantissaExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MantissaExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellularAutomaton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellularAutomaton"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->22869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->659095958],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "MoreAbout",
 CellID->430633176],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->673025727]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BitShiftRight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 18.0834198}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BitShiftRight[n, k] shifts the binary bits in the integer n to the right \
by k places, dropping bits that are shifted past the unit's position on the \
right. BitShiftRight[n] shifts one bit to the right.", 
    "synonyms" -> {"bit shift right"}, "title" -> "BitShiftRight", "type" -> 
    "Symbol", "uri" -> "ref/BitShiftRight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7285, 218, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->716025242]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14966, 507}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2739, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3362, 90, 1578, 37, 70, "ObjectNameGrid"],
Cell[4943, 129, 1092, 33, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6072, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6550, 184, 547, 21, 70, "Notes",
 CellID->25452],
Cell[7100, 207, 148, 6, 70, "Notes",
 CellID->2741]
}, Closed]],
Cell[CellGroupData[{
Cell[7285, 218, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->716025242],
Cell[CellGroupData[{
Cell[7670, 232, 148, 5, 70, "ExampleSection",
 CellID->154842692],
Cell[7821, 239, 71, 1, 70, "ExampleText",
 CellID->301542513],
Cell[CellGroupData[{
Cell[7917, 244, 132, 4, 28, "Input",
 CellID->56784263],
Cell[8052, 250, 158, 5, 36, "Output",
 CellID->666387624]
}, Open  ]],
Cell[8225, 258, 97, 1, 70, "ExampleText",
 CellID->371336790],
Cell[CellGroupData[{
Cell[8347, 263, 132, 4, 28, "Input",
 CellID->29813631],
Cell[8482, 269, 158, 5, 36, "Output",
 CellID->612063732]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8689, 280, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8913, 289, 218, 7, 70, "ExampleText",
 CellID->17203584],
Cell[CellGroupData[{
Cell[9156, 300, 183, 6, 70, "Input",
 CellID->789683600],
Cell[9342, 308, 219, 6, 36, "Output",
 CellID->337379539]
}, Open  ]],
Cell[9576, 317, 125, 3, 70, "ExampleDelimiter",
 CellID->190170383],
Cell[9704, 322, 228, 7, 70, "ExampleText",
 CellID->124216887],
Cell[CellGroupData[{
Cell[9957, 333, 205, 7, 70, "Input",
 CellID->583507249],
Cell[10165, 342, 223, 7, 36, "Output",
 CellID->342399657]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10449, 356, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10768, 367, 1726, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12531, 434, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[12852, 445, 198, 4, 70, "Tutorials",
 CellID->22869]
}, Open  ]],
Cell[CellGroupData[{
Cell[13087, 454, 319, 9, 70, "MoreAboutSection",
 CellID->659095958],
Cell[13409, 465, 147, 3, 70, "MoreAbout",
 CellID->430633176],
Cell[13559, 470, 198, 4, 70, "MoreAbout",
 CellID->673025727]
}, Open  ]],
Cell[13772, 477, 27, 0, 70, "History"],
Cell[13802, 479, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

