(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52680,       1697]
NotebookOptionsPosition[     44297,       1389]
NotebookOutlinePosition[     45537,       1425]
CellTagsIndexPosition[     45451,       1420]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BitAnd" :> Documentation`HelpLookup["paclet:ref/BitAnd"], 
          "BitOr" :> Documentation`HelpLookup["paclet:ref/BitOr"], "BitNot" :> 
          Documentation`HelpLookup["paclet:ref/BitNot"], "Xor" :> 
          Documentation`HelpLookup["paclet:ref/Xor"], "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"], 
          "HammingDistance" :> 
          Documentation`HelpLookup["paclet:ref/HammingDistance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BitAnd\"\>", 2->"\<\"BitOr\"\>", 
       3->"\<\"BitNot\"\>", 4->"\<\"Xor\"\>", 5->"\<\"IntegerDigits\"\>", 
       6->"\<\"CellularAutomaton\"\>", 
       7->"\<\"HammingDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bitwise Operations" :> 
          Documentation`HelpLookup["paclet:guide/BitwiseOperations"], 
          "Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bitwise Operations\"\>", 
       2->"\<\"Cryptographic Number Theory\"\>", 
       3->"\<\"Discrete Mathematics\"\>", 4->"\<\"Integer Functions\"\>", 
       5->"\<\"Number Digits\"\>", 
       6->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BitXor", "ObjectName",
 CellID->28116],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BitXor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BitXor"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the bitwise XOR of the integers ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitXor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitXor"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " yields the integer whose binary bit representation has ones at positions \
where an odd number of the binary bit representations of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " have ones. "
}], "Notes",
 CellID->15203],

Cell[TextData[{
 "For negative integers ",
 Cell[BoxData[
  ButtonBox["BitXor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitXor"]], "InlineFormula"],
 " assumes a two's complement representation. "
}], "Notes",
 CellID->19712],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitXor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitXor"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52724630],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->525246553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"61", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4372],

Cell[BoxData["50"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->630]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerDigits", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"61", ",", "15", ",", "50"}], "}"}], ",", "2", ",", "6"}], "]"}],
   "//", "Column"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10560],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVsEOgjAMLQw0mhj15pG7/6EnP4IQEzgYCfL/uA0wpnSyhWIMQrJ2fWTd
28YevcRler3FZZbE0bmI8zRLHtHpXkhIeACQy3Y8gOxXsqdbXlXS1zZQVihU
P7BC8ZY5FnpWgdC1NL4Mdz1+j8b5ZDaFhtBd28KAL6VRYWiJu+ahWeLRQbNG
fAItrrJD+MJ1TrB8656zy99HKF4lPukNmZtG7cbiGT2rfR2fF71fM69p8KJQ
rE2imaP17zgeXytg/tFOUZVFxaOyXLj538Gtshx4vx4LkpvdfXCN7ZSY3stx
GA053ZnRbzGiUJPCUh5/nf+quK51sCvuqtw8dbAr7q7Zw2vfvtjuNvHUuzxc
eGq2mcv3udjUr6Z6tk9NwXsCbr/BkQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{112, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274217378]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11945],

Cell["Use numbers of any size:", "ExampleText",
 CellID->25993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{
   RowBox[{"3", "^", "100"}], ",", 
   RowBox[{"5", "^", "100"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2621],

Cell[BoxData[\
"7888609052210118054116793203790437104101594041461795136781437785275168"], \
"Output",
 ImageSize->{543, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11465],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitXor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitXor"]], "InlineFormula"],
 " takes any number of arguments:"
}], "ExampleText",
 CellID->12249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"3333", ",", "5555", ",", "7777", ",", "9999"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12158],

Cell[BoxData["8664"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29766],

Cell["Use negative numbers:", "ExampleText",
 CellID->25070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1496],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6693]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18703],

Cell["Basic symbolic simplifications are done automatically:", "ExampleText",
 CellID->29967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"x", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4683],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13460]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"x", ",", "x", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1714],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12444]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"1", ",", "2", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12415],

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"3", ",", "x"}], "]"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9924],

Cell[BoxData[
 RowBox[{"BitNot", "[", "x", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->9961]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26200],

Cell["Make a nested pattern:", "ExampleText",
 CellID->1667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{"BitXor", "[", 
       RowBox[{"i", ",", "j"}], "]"}], "==", 
      RowBox[{"i", "+", "j"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "63"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "63"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29772],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyllcENwzAMA+lu0k06Q0fIAt3/10f8EYHqSsuGIBAMQtgypef1eV8PSa8d
WrM1/YHW7AfTI2jHuf7sDrT3uf69zvVrzvVrzvVVcq5/K5/egSxy/Rq5ft25
fl25fo9Zv8esrxazflVM78Drnr4Dr3v6Drzu6TvwuqfvwP2f9gP3f9oP3P9p
P3D/p/3A/Z/2A/d/2g/c/2k/cP+n/YA+QB4+QB4UkIczIr/6MyIPdUYe6ow8
1Bl5yzEPfkce/I48+B15i5gHvyMPfkce/I78FMP8RwzzHzHMf8Srn/+IYf4j
hvmPGOY/4mnWMP+Y+39nmP+Yp6FhTPdwfQFOWw9Q
   "], {{0, 0}, {64, 64}}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5249]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BitXor", "[", 
     RowBox[{"i", ",", 
      RowBox[{"2", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "64"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12218],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJxdkstKA1EMhoMrly5cdOFCRYqISOv9Vhtrvd+nalttKwiCO18hj3YeyUdo
pV8GTgaGjy8/h5PJZOnrt/ieERGdvP+cPn/NKWeVAqxoXp+Hc3A11DfCuRW4
AJfhItwP9aNw7gRWYSPcuw3X4B5ch5uhrzqswau8btfh3C3cIr8J9z7AHfJH
fBfe533ZHe7f3YYH5Of4IbyEzMUu8GPYgszFznCf2ylskivu7OX11MvPWR/i
2g/3fpDjCRf6sPe8L8XL7x6R4wkX5mCfEFdcfA5DcjzhPjcbQFzx8r+/kOMJ
F/bAXiGuuPgedMnxhPve2BvEFRffg4IcT7jvjXUgrni5d8/keMKFPbQniCsu
zh8dAzzOW4k=
    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29813]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BitXor", "[", 
     RowBox[{"i", ",", 
      RowBox[{"2", "i"}], ",", 
      RowBox[{"3", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "64"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27358],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJxdkstqAkEQRYusXGaRhQsXiYiISND4fk+MifEtWWURIgiCgugv9Cf7CSre
WsxpGA6n7tRU99Avm9PP9sHMoutz432d+xZfUVwT8pz4iPwJnpQ3xJTYEZ/x
fhqegWflC+zjW8zDC+JMfEV/Ed8vwd/gZcytIK/Ca/J/sS6uRf8vv2IT3oK3
0e//8U/swnuY30d/FN9vgNs7cnc//wA53D7kOmdw930P0Q+3T+TycFL9Szyq
DreRqPfDCP1+T3aqw22MXB72qk+Qw22K+VPM93t5UB1uc+Rz9Ps99vPDbYn5
S/SvRLMLv61GQw==
    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10469],

Cell[TextData[{
 "Generate a Gray code sequence ",
 ButtonBox["[more info]",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-901b-text"], None}],
 ":"
}], "ExampleText",
 CellID->25086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BitXor", "[", 
    RowBox[{"i", ",", 
     RowBox[{"Floor", "[", 
      RowBox[{"i", "/", "2"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "16"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "2", ",", "6", ",", "7", ",", "5", ",", "4", ",", "12", 
   ",", "13", ",", "15", ",", "14", ",", "10", ",", "11", ",", "9", ",", "8", 
   ",", "24"}], "}"}]], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32724]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BitXor", "[", 
     RowBox[{"i", ",", 
      RowBox[{"Floor", "[", 
       RowBox[{"i", "/", "2"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "64"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4246],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJyFkTtPAkEURm+sKCkoLCyEEGOIMcpDxBfrKg8fKKGiNrHmL8xP9ieIco4J
kxg22ZycnZ25371T/1gtPvcioli/P9w8X8Nt/i6vn0pGv1fhPqzBgx3f3XcI
j2EDtmATnsIjeJLt87/WP/95rudY9wxewnM4gG14DTvwCnbhHezBIbyAt7AP
b7K6nmNdz7GO+8zhuZ5jTuuY01z2ZS77LuB0w4QnPO7xJ4gHHiV8YR1PeDzg
zxAPPB7hG+t4wmOEv0M88BjDGet4wmOCv0I8cPs2h32bwz6t6xzM9deHdezT
Os7FXM7F3OYos5xl1pdztC/n6Jy8J+foPTk379W5ee9zuCy+Ad9YUHQ=
    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13517],

Cell["Bitwise version of rule 60 cellular automaton:", "ExampleText",
 CellID->10282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"IntegerDigits", "[", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"BitXor", "[", 
        RowBox[{"#", ",", 
         RowBox[{"2", "#"}]}], "]"}], "&"}], ",", "1", ",", "63"}], "]"}], 
    ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2071],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzll2FqBDEIhSPdi/QmPUOPsBfo/f8tLbWIdaJJNGaSBxJC6ui38pC+P78+
n2+llI/feJQfwenxrUPPv/mjDroX5Kc65F6A8HMv8L/f7L0A45d+J5q/0Xvh
cfW70fxN3v+xg+B/KX+Dd5EdBP9rfpK+v3j+JTuQ+V+dlvoL51fZwbD/LfUX
zVfZwbD/LfUXzDexg2H/W+ovlm9mB8H/PfUXym9iB8H/PfUXyW9mB8H/PfUX
yO9iB8H/rTEqh/rd7MhPfsfm04N/4BxiR/7a/h3dz5oG6g+zg+D/1vuoOuu7
sIPgf6k/T7+3ft/b7zw0P3v7vfX73n7noc01au7W70fNHQi/1l+kjPVD2EHw
f7TfJb7I/W7hxz6kM1rR+12L6P2uKXq/axG93zVF73ctZvuda7bfecz2O9ds
v/PImjsqa+5A+DOVyQ6C/2dHJjvykznMPlPZ6fxRE+/p7MhPNemezk35a/s/
4D2dmfOTuYj9O76n80r8tR3o+J7OesVfk9N7OmeNX9nPKt/K+93CT+ak+lni
r5zpfBb+2r628K+83y38nKdFq+93C3+L3yX+O/ld4keOHt3N7xJ/Lzty35Ud
+Ud0Z3bkH4ns/j34yRxbz/T+veaParin9+7FT2W8p/ftyV/b/7v5XeIncxX5
yZnebwT/nf9/9+CvaWd25N95v1v4yZy39/vV/FGnzJ3yU53Ejvwn+V3iP3Hu
fP7ZfSTPP72PrHgBT6Ixww==
   "], {{0, 0}, {64, 64}}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->20340]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12625],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{"BitXor", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9947],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "1"},
    {"1", "0"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17388],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitXor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitXor"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1243],

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32184],

Cell["Even numbers of identical arguments give 0:", "ExampleText",
 CellID->24957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24639],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31094]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29260],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"x", ",", "y", ",", "x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30665],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32237]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitXor", "[", 
  RowBox[{"x", ",", "y", ",", "x", ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15390],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7971]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"BitXor", ",", 
    RowBox[{"{", 
     RowBox[{"63", ",", "63"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28184],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390930556]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Cuboid", "[", 
     RowBox[{"{", 
      RowBox[{"i", ",", "j", ",", 
       RowBox[{"BitXor", "[", 
        RowBox[{"i", ",", "j"}], "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "31"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "31"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16491],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylXeuyJEdxLk3P9eyevbErrdfay1ndVixCkiUQMsjcQmAIZIxlYwiCAAEb
SEHYQyw4/NPPovMMfgY/AO/TYU9VZWZ99WX2nN7wxO6c6e7qqsysvGdV90ef
/PnTJ//2yZ8/++0nD77/9JM/fvrZb//04Hv7p4dTw3Mppf8+/P+f2+nw+38P
v8r//xzHMQ1PnjwZyyf9bf5K/3H4XhxOpuHwo16UK3+SK4P8rWf/ePjOnay6
s/8uR1sYI3f6frn6B7nnJB8tDYLDj6+V65/J3acT138v16/mo5VdlzHeK21+
J2NcP9LmN9LPTaLEgo7fLa1/JT0+T1cHOn6ntP6l9P1Xs1r/Qlr/NV1d0vHf
lNY/E0ju0tUVHb9dWv9U+n4wq/XH0vdDurqm47dK659I36/Mav1jaf3ogtZv
ltY/Eki+SFc3dPzl0vqH0vcbs1r/vbR+k65u6bj0lj4USN6e1fq70ve7dHVH
x18qrb8lfX+Vrp7Q8ePS+u+k7/dntf6GtP46Xb1Ex4XCRTbzyQ/o6mU6fr20
fk/6/tas1u9K39+hq6d0XDijcHnu+8NZrd+S1t+nq1fo+LXS+g2B5Ad09Sod
v1paP5a+fzSr9SPp+x/o6jU6LtJS7sl9/4SuXqfjl0vrl6X1P1/Qd219JpD8
9IK+Xyqt70vfP5/V+q60/gVdvUHHRYOkOwLJL+nqF+j4rLS+LX3/elbrW9L3
b+gq6/Oi+Uofue8ndPUWHd8vra9L69/Pas2zwHexzbhX7ro6gkVN1WbNu0ut
Yv1eHu6tduXwQ9oyvV+g47uur3IiLfZv/Fft5/Onh+8U9f0z6us2Hb/Y+kZb
lkpXpds8yDbo+eP5PXdQD+d/GYfSf+65Ao/jlZ8Fndq+fv8j9c62ulhjp0cW
CvNhzMO/tFCqbRvV9Ef9zlc3Abasg+aNr9xSvJqknwzJiYy1A0zr53vUx53o
2I20kpGWh84Vy/L3cLwCaifAcSH3fDvChXGdxg17lrktNF4hjfOJHbWWWYYm
C4DqgwvoMA1VGfnQW+OvLfFzociqQVJbFWzWyA2NJ5aMqUD5tQtod3sSSuT5
zBHDDNkwKEFW1gLhegLCdyK5ZG3j7HVhyaVJjsK1anA1qMtsb2KJqtjklvWz
FC4pFwRYx0VK76WMVj65FfuA83AZFJfaHfLoEqHOFNsULBt1K5ZruVp+GDL1
R8gdIWf3cs6+8l06fn4al1WjHfJIo7LOfT7FsK0FENUOS8Fhm7xm4FhhPoza
e6b0krg6pYs0xSAwlLvWKKeN5qrlUKsYLZaNPLUXjqju0fGtaSkA+7FkyMH6
bmDOq/JhvbuTu/j8qodYW3Q4ZGyZ2+/T8c0QB7MMo9fXqIErih3XxBqy42vk
PJs5wUBnCUc8CWeHPZ55mF3S2RFdP8XxUzO2UAWlx8L9iA9xk8iJaoheK9v9
nZyzr82cWPxlF4vlYxy7zQ5iwRpWqeA1WKRjN3Cu3DmlycD6KA93dEvNAvEc
ndHxjUlsixiInB2z0muZ0QXgXX4WatndwIMMK+J3jag3uPlmzZV75fzAPCxP
dE5RU6sGVpsIvjz6cmCpQGfzHU62nd/Q08v8kI5ujDFqidpincBDljDtJcL2
ekiD7YQWUhsxBFyuVA8sdqBhCj475hr8RhmvqLF/sJQuqzeAfamr08c0PP/T
uKO+4hnTmEBxFO/TNBrMnfl7sV/YfN6e0zCiWQA0jV+8Jt8kb7VyNFN4UGbz
LmF6bRL/Y1yKo1b7U6Hpvc2l0uPoHLOXvAFKqkXU2Aj90dznJYLRR3BtBPNQ
Gz0FW46HSyTs8nk7vUsmSjm62bFGm2VqEQLGd4MC0mTj8L2i+de78/ktjKrI
95ZGNYz3TSwOMIKg/VNPOR9z/iWmQNaKyFsGD/O20+2Es4zMHoHLK6BMCAVP
hCZe+0/GKzFNjEMycdSjnogGhtG8BPYRroSUumS6s8cA+j78YI+sxtSfP63R
rZeZQfEemrShjVWpUc7bEY0HabN2c7QD6pvGIFlDW5O/ay+NMt6jiGlzOraI
Z4JG0GfoPxx+blIvYb3VRX9J+700Rn4aark8Qu8NN36sx02zZP5dJ7A9a7S6
yfxlriGcTtKk41uFbCOSpeYLrq+YAmCDK5cTRM2LllN51mN/TjMVaufxrhVw
T6VHy501OvY2Qvs7KYQKPMoLKdJ5HEd0h+p3F8UyhUwOXBzY+7Ey1G70HmFt
3Y57Dupj5UwpzJkxd7K0TUWgGm/PoyDaHZ2zxr90VnLm6l8BRSD3pfJoXHG4
NB0BdJY3M9/YItxudnFmdwlyWUnTysD5rOHr3FZebDbIYDncsRMwyEamlk9R
yuVeqoxGktvJg8xt4eeNh7nMeKCB1bJ3s4pyfDTjfSxCanOKGK5EU7WYESwO
UC7q0eWjQ/phK0WAefTSJE29n90keW0ex2jrJrqISpjX/KooDhE5pEynw6Kc
3XbJLbAoxZ9VXbnHjDXnIcxSSKvLRMPOX4Pzz0Y1kl2Rn00IIWrseoF8kTRh
8/YQu8hQEQfNid6HcQz1ufovSDHW3RrjadR1eTalrijDnGNunKO7UMeq37Fh
/d78rqVqAo0I8ldoA4e9j35Rs+qoSNlt39vhn9qQfi6rFTsmk/lz2ebgIppd
FUunOZBjM1sIAF6ntu+8UfGQLBIO6jbD3uezvEXJ+KM3otAon0a9ZJ5ZzcL7
bs8rCWWi9yM4Xjft01l8BZT1EtOz0MRlKdUa+HgFvX7N6hQWIP7Jd3N8XHVV
79XG1OG82X2VGdC4ph82obkyrveZktj7wooOaeu1l8Kp3KbjVYmAmxuB8QR6
qZ0eE6JluWGPNabQC0ohOV6D/8Uca3WWTgcb/7psiuYYMU4rns7hy/t27LH7
WLlq9Wb310ARhSTSILw26ySkxE2x2kXfrI0iNgGUx0yobTkb3vIpyyP6xdUK
nCQucJRIdplrWvx9OJtxO1Ca2lHFQWDLeWqmSEynG2MfN9lw1XcR/asS0ajB
PnlptUabkMxnwaxUXEddKAViv/PcVwRRJ5myNG3V/EwjXLmZuFA5F/zG67M5
7EZgwSPZV1/bZr6XE9D4CbJDRATnG5XByZ9ZuDuR6/rMLPvfxHkgl8qdil+m
ENutIxRqmXLEwmXJo1wbWvgF8ZLijzG5z+KgDjvWWvMYqjvzuc6+gRYzeoHN
C3hr0m5mFo+ymkdkcyC5C2NcrHIjnlGcK5QsiKr/RHkv6c0qLcAlqlKXluUK
uEmoE1UAsRaRP5tJirAk3hyDzEX+ObGeROnBWROfN9RWUQ2fdS7yoQHjKk1d
fabz5+r9NdYo0+k4hylkWbILKXRLKdT556cwk0aPLXIRSopVPIQHurnPmvS8
ryo4/X4kBisV/Y3BZkRAf/N4fuHzp5kavAZxF1LjBfECotwk+0QnPFJqMrQC
TbaHnFSjWqzdLStuXtUxyfWRWKOQ1y5bumP7TFRBjw08X6eBIesG9GkQoYOj
1TLOpuRhtqn3nvDuFn+FfrPRq8ReUzzSWXXGZXgm2lxk1bsM2oZntPFyi7ib
pvF+p8WuoEXObf0G3uurdjpKoWZQ4axKeG/xRmvB9eDM/bzWeZpC6KsbL6yR
OytHFAqtvWLWehzGnb0Xp9F65+uip7hOfUZNRsNrSIaQZzr/un5vYX7qh9fK
V6rw7pPbI62hc/XHiA5hhWeJgWLI72Nfr82nMSrxPmLjA/OKIV80qKEj7day
Yahr8neO6bkKGdOF5Yn9BZUl8npTiyoWgEGB+PwvQX6Ra2han2t6eSzZ2/qx
HLpbSxhXa8sJgAGjH82FsD85nz4sTRh/N4x22miTIJqtMJl+dpFgl5E4x/xp
o/VSSW0I6p2WXRQltDTN3cUwRJ1jsoVe9jj6vSXT0tXnUK067GOnIxX8fGy5
JoSWPNg4Isb4qklYpKnWxjPtnGVWlja2yvehRfbQeFfINqRFXskuM2j+O1bd
NdbkLHNKycUzWKkH/WSs4DzfCU8QLF3vCTZNXPukOcrfV2Zjfn+MaktT8VyY
YXeW12NeqUq2dg/5BNCcvi7VRZyK7Un14zrOcbmNnkt5/RWvjokp9EDlxHSj
ep5R3mkhVKoxZWSFK782nFOXc1Cqmv2wLjCrotpY63/llo4acQ07t+dVURVr
zoWeEZczPRH/E7DTm37GwNcfACIjZagNo1UkRUiU+yumhizWsrQ7s+OjXwcW
Y5wlAVefMB9eVop0Gr+fj3xu3evVBFpqkEA/eU1m2k1m0shX7WBQrVL7xPug
YuxeVJvo4hOdxdOezyfsHPP7Rvvd4Jz389nzcVc56MYCLX5ol7U37+WZxm2i
Ogre3HYSR2+VcpOtk3tbDaw4UyTHWRFdcdVbds0Z3CUsNtO4cT5y2SJG8I7B
Q71Kd6lN0vVSPV4uqyWcmzljl0BGD2Dln6fPBH2lMMt9W9mIuvvaOFFbEZrx
fgOzezKeRTOmPRqlopVCIG0Jcu6k52Jcub52D+Q+gXVrHOir89eVc895ldYl
0Zi4Kj031uqT2kEft9V+FlZUBa9fOIV33sT4ZH0Y739gb/CGtNT+UVMqH6Hd
5XyGW0cPx6U2rkkKmakcKfH+lBiHs3GqEpPhvMVSQnCeipybXIBOy5OW1VXH
rVoVCXhoHrwPx35XGMr0TaLaUuSlzL7ps4QWcRzRei+rxyTRGni3HAlm3HiP
zDR9WU6xIpcpvCI8rk7AzOsmisyXme9trMpLMmNjuV+gNz+RYyb8DEOSnVFd
nLRQyk9VMSCnMIAcKq+j12tRZhen55symryjY32Uy3kFm3kG0usgcCN/dvJX
WaPIm60B6Hw51UjWA9RrYlj5mSwPieJd5IK+GsC2IRkcRdN7zTlIHkIjZfxe
Ke+MdWUjrHMPM6Ivz8LnbOxzDUz3fs5778R2vUhflYnD2rcKfMeDFGOZt93i
kgbnPGweOl7PQNwhfIzXW6YniGV1dgclqM64miOTf/a2OZodzuN4DiGfx325
VR76RcAopan8F0bhxTV1K+sCDmRc0H5rbeK87nfA1Y/z4P8uHBvc7A/1kXyG
e9dwguC7g7jXu97v1TxTtLKI915dDPsoJqB4MarsEMi2X4JoGedWu6wkcVJk
Y/G4XHdr6L4oOrVo/42dr3QHa6c5vvqp3kJ2LxpHwKog8glc/CD+dhyLXwTx
ozGo48q5khFceyyWom8u3JdL0GM2EvnJdobRalP0BlsOjXIsF2KYnwGEq8vq
sNGzQpiCplcn5RzzBbre+mItHOGau+e1HOz9TeMXQzdlQWydz1if7VPy+t5O
tPhzD9UPXblXPqi31GZpS15d6LPVXEfnCOMIvmAZdsBV9VPH9FlPiVvF/14q
XzQ7LsBdXP+Mtab5OG1Nqwn0+v+Fb5UcioZV12097o0CaoU006D6M8rSDMGs
xXqdPd58F1d1787C7jXgvWSSiXZ8mXp7hHj2fI14WS2gq9Ja3NXJSz6RLStX
RBgjfo5DxYjXnr+ucrH185Varbh4Btii7vBiLoMcAO8aAL8tiozYp+BISevp
uS+u/TCmyxBTtXYeD/PelFIwll/1x3mbaE8Mrqfi2M64UfgY6wv1w882C58B
6fDLTw8sqyY0PiBqsn5VODVvdd5l8N1zfs6lgkjzpu3Z+vnqtFEB4maEn5+8
NI1l749EOwYiDpyqudR5x0xq+ZkS28LUMlLHVm8spDd+2sg8/DKXDuJleZsA
tsJVoNsenNRlezAjV2duS9QwDu5WtrF+4Vob5+RjfF4TfHA9Cq952re9IBPr
O3u7zLUknt0BxiA/Ws7wHtt8B+PDFRUhDsQzr2SJy14XUV13ZHf5PsCu8Qv7
nNEu6S7rAtlG568qDZdoyaPcLnOmx+yhzFrOKNWVLU2HTayjCteBU50onHe/
vk2711gB55+9EOZKj8t9waXk1YO9jkq7AtlRi9ZbedvJT3p2cs8MzB2vwWOs
eIYGh9WLgtVVgcL2T7Z6KGjzXluMsvKEqj+BfYhwwbVXrb98J0c44XOROyxu
iwTdVgk6hydg7adWQlt05eJjZ/PA67CatPXFUTJbJA+vPl80S1RkY/xOqhJn
1JFBt+aDYK+1Ujn0YrPPxxkufq6ph/iGQHxP+UQ53Uk0ribuPfLALkyso+rz
rdue4jIXrxDM7O0oDu3MVcHhAVE9f58ksMruOQYSc3T7qSPfTPnF7wRg74+f
VM2+qIf+kvD42RjvnuenQ0Trivzq/cg2BhwIfkDWpK8/M/RboX2ZNTfrDOum
p5lQegtzg2ARn++PR+P8JEOGfeFgXwnsj1S7CGBRBs3NfLhHqITvFKGT9xdq
rTZbNArYlEzcx4QTryH1OC4Ex8fjVHQDKxlBOubEW35NOvuWEQfy89Z5dXDF
YfWkPmu900kT+XGD52iMyk/hdfTe193XbxE8HDd7Guenj2v2dZ1ASp3/ak8/
7Dw9FUlvNbvKqoz25Znwjabjy3PlXVYit7O9JGDDA7sDM8rZvnwjP+U+fP5x
zdM9qU+5x1UP0g/IoNnEWMZcThb05T7Yp5eaBfoKQcZP9amQctb+7bFfgx3B
GlkMhi6MQiHKrDVrfq4/59lEPujsm8KDa+DFyFLQfqIw+slK7L0LoHiuQLEe
21sRcM2JPasBSwB91RRg0h2Ebqduqu8YYGvp4eBc+mOaIV23yTMS8b9GFrje
dR4UO6FGHn2bWgQwaE5LWnf2bZucwmozkS9+g8bivHodmyF6XSlw3urrJ0CV
wnqpzwg0KzTNw5liH9BYvL+wQnRZqKF5tcvj6CuYei5Y26eSpXT4Jo3Cc15H
Zd3zlbGtJonWd1W/kOyGjMjvnuBVsXVE1r9fkhGN37rnzLIO4B15XIfhp6Ln
Xp87HOax6/jXiM7+uba2V534rFvH77S90p1rlhsHAXtar479euo2mtoWlfhO
V7snvnxI/a7dyPqGhlciLg68fcuaTWReGv9lzPn9ICs3PkeEJWJ0XrB7YlsY
ITnNKC3z3fzc/6WDhGPps4DXOHqPniSHx9kO/JD6HdzIL8gclAptlw111nrf
788DLRivOwiyWB9dCA/n6Wx1P1tit5Kh88+JTvyGloUb9w7QoVayprxRfnIJ
64AfHxkrfv62Qm77q0pLsLjhzkAcs7zZYmW9jnUHUB3xbjDilCRnnvmnwgnW
3iC/JxS6P8IK14mYcW8RvOkN8a4/nuids0t3xol4Os4lBvOOvFo//wJjNPqc
CV53QAsp207VOlkWM930vVu1V14NE+1449XWqDcyzX7ecY6+Ecj26bYnz4zq
lnSZNeJRfYtY7e1Vgs/WOS6tM51j9uvp+QsrmdXMfvXm14K5jJ8FtRV5yQxR
93g9GuHNaD637CLs3t/8SPqqz8njnELWsieEQYb+BwJ9feKyvgPq+bG3yPu2
2t5p3b4a9qFAUd9swBHz9dFZ+uSjZKVuJsF3pL/61haOIEsEPrF3oLce3xQ8
63uF3hQ8eR0o7VMVIucGXxc46nuhOG7MNJ/ivwzNe3J3fS+XvvPrCug/XIH9
jsBa32zG71Y7HWP7+JaMUd8/x/Eir+r2OxvekPvrGwC/Orb3EjJG+d5HAmN9
SyG/xYX9dcx55EtaX/qg3P2+jLUL9F6+8yVpXTzKxG94y75VlqV7AlHxvex9
cGuCRO3KHemzeAnlXXNsm3W3VW5VbKjz4y2ahkjlCwJFsSTljXcL0Q356nXp
71/LVfbSucJ4In2Vt4/Zu/a41Vr6LO8R6zzPJ2XRY71a3rdV3o2UF5J9Wo7S
c/8HctnJ0g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 198},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140284368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8890],

Cell[TextData[{
 "\[OpenCurlyDoubleQuote]Munching squares\[CloseCurlyDoubleQuote] ",
 ButtonBox["[more info]",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-871a-text"], None}],
 ":"
}], "ExampleText",
 CellID->8106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Boole", "[", 
        RowBox[{
         RowBox[{"BitXor", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "<", "t"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "7"}], "}"}]}], "]"}], ",", 
     RowBox[{"ImageSize", "->", "50"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7413],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm99u0zAUxk/TpCkb3aTSSkPbRdkkBBOwDfEMcMVDVBPSdoFAY+8fjhun
TU6O/zTNxdR+lerE9hf7+Hes2Olpfi6fH379Xj4/3i8XP56Wfx8e7/8tvv95
4qLhgCi5JqJvZ8TnBZ+tvtXnE3+Jck6/cvFrPt4FjkZ37NCP163RcN0LfRH5
VzvWH4n850B93/3vat+oE6X3nOScpeHqctJ6WnAyEZpjoTnjZBbQTDk5D/Rl
rrkMaDJOPiiaW6X/G1GWgxIogRIogRIogZIgMCK72wroQqSmtq08UhsiltXa
i9Fq5EIakARJkARJkARJkNwXkimniai5CVB6W5T7xZOA7o0lJHXS4qnV5ZZE
F6JjPp90rDP9vosgZjhlq+yqMFtbVUroFtx0bsKWBAzBEAwPg2G60bbX3wZF
r7LBsaGUxFsks7X11i7tihWXdDPOUtWg5q9t9TKWZFU7+pyjCbV3RlNLeB6h
dc3VRPGHaXemtOHSynm3rc7hiaLcvRgrTvk4cirGfbBulXppB9UN3i21l3iU
2j0v45Wu+4Zkl0kPeLSjaF+opXLfn9ZZJNYGp1eCasedptjMNKdXotTuGRyv
9HmlGpPPG1U70gtDYcWgrKopUs0DnvXPdf/ZZZ3U7juaLvQ01WUddVHV1krD
asDnhmJJMmo+g6ZKU5+b3XZvh8yxz10wOPbD0fyTx+xVLwI6s8qecPZc4TP3
lGvtmvJZoUf+5tZX8vetqi4v9EgfGIERGIERGO0boy5xgr0lRNXD8rZxqMxa
drkDkXo+DZBzEZpYO7R4mI/SBbnjXv1E6kAIhEAIhEDoJRIyz84fI8uPrOW5
PW478ip+c6rUX5EeebuqXYdRY9QYNUaNUR/CqH3vR273HmVhP+U7mjT4D5tZ
8lQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{554, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24053469]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15966],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitAnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitAnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitOr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitOr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitNot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitNot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Xor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Xor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellularAutomaton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellularAutomaton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HammingDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HammingDistance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21104]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27117],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->19084]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->127689651],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "MoreAbout",
 CellID->4719774],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->140056113],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->330744959],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->355297389],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->71903114],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->576563354]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with BitXor",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=BitXor"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
BitXor"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BitXor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 18.9115660}", "context" -> "System`", 
    "keywords" -> {"add", "carry", "half adder", "Nim addition"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BitXor[n_1, n_2, ...] gives the bitwise XOR of the integers n_i. ", 
    "synonyms" -> {"bit xor"}, "title" -> "BitXor", "type" -> "Symbol", "uri" -> 
    "ref/BitXor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6475, 202, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->52724630]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45309, 1413}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3216, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3839, 98, 44, 1, 70, "ObjectName",
 CellID->28116],
Cell[3886, 101, 812, 27, 70, "Usage",
 CellID->29723]
}, Open  ]],
Cell[CellGroupData[{
Cell[4735, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5213, 150, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[5348, 156, 649, 22, 70, "Notes",
 CellID->15203],
Cell[6000, 180, 234, 8, 70, "Notes",
 CellID->19712],
Cell[6237, 190, 201, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6475, 202, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52724630],
Cell[CellGroupData[{
Cell[6859, 216, 148, 5, 70, "ExampleSection",
 CellID->525246553],
Cell[CellGroupData[{
Cell[7032, 225, 122, 4, 28, "Input",
 CellID->4372],
Cell[7157, 231, 153, 5, 36, "Output",
 CellID->630]
}, Open  ]],
Cell[CellGroupData[{
Cell[7347, 241, 235, 8, 28, "Input",
 CellID->10560],
Cell[7585, 251, 610, 14, 64, "Output",
 Evaluatable->False,
 CellID->274217378]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8244, 271, 216, 7, 70, "ExampleSection",
 CellID->11945],
Cell[8463, 280, 63, 1, 70, "ExampleText",
 CellID->25993],
Cell[CellGroupData[{
Cell[8551, 285, 172, 6, 70, "Input",
 CellID->2621],
Cell[8726, 293, 228, 7, 36, "Output",
 CellID->26842]
}, Open  ]],
Cell[8969, 303, 121, 3, 70, "ExampleDelimiter",
 CellID->11465],
Cell[9093, 308, 200, 7, 70, "ExampleText",
 CellID->12249],
Cell[CellGroupData[{
Cell[9318, 319, 153, 4, 70, "Input",
 CellID->12158],
Cell[9474, 325, 157, 5, 36, "Output",
 CellID->30148]
}, Open  ]],
Cell[9646, 333, 121, 3, 70, "ExampleDelimiter",
 CellID->29766],
Cell[9770, 338, 60, 1, 70, "ExampleText",
 CellID->25070],
Cell[CellGroupData[{
Cell[9855, 343, 158, 6, 70, "Input",
 CellID->1496],
Cell[10016, 351, 153, 5, 36, "Output",
 CellID->6693]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10218, 362, 239, 7, 70, "ExampleSection",
 CellID->18703],
Cell[10460, 371, 93, 1, 70, "ExampleText",
 CellID->29967],
Cell[CellGroupData[{
Cell[10578, 376, 120, 4, 70, "Input",
 CellID->4683],
Cell[10701, 382, 154, 5, 36, "Output",
 CellID->13460]
}, Open  ]],
Cell[CellGroupData[{
Cell[10892, 392, 130, 4, 70, "Input",
 CellID->1714],
Cell[11025, 398, 154, 5, 36, "Output",
 CellID->12444]
}, Open  ]],
Cell[CellGroupData[{
Cell[11216, 408, 131, 4, 70, "Input",
 CellID->12415],
Cell[11350, 414, 209, 7, 36, "Output",
 CellID->23714]
}, Open  ]],
Cell[CellGroupData[{
Cell[11596, 426, 139, 5, 70, "Input",
 CellID->9924],
Cell[11738, 433, 185, 6, 36, "Output",
 CellID->9961]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11972, 445, 223, 7, 70, "ExampleSection",
 CellID->26200],
Cell[12198, 454, 60, 1, 70, "ExampleText",
 CellID->1667],
Cell[CellGroupData[{
Cell[12283, 459, 444, 14, 70, "Input",
 CellID->29772],
Cell[12730, 475, 688, 17, 246, "Output",
 CellID->5249]
}, Open  ]],
Cell[13433, 495, 121, 3, 70, "ExampleDelimiter",
 CellID->14817],
Cell[CellGroupData[{
Cell[13579, 502, 295, 10, 70, "Input",
 CellID->12218],
Cell[13877, 514, 698, 18, 135, "Output",
 CellID->29813]
}, Open  ]],
Cell[CellGroupData[{
Cell[14612, 537, 327, 11, 70, "Input",
 CellID->27358],
Cell[14942, 550, 641, 17, 137, "Output",
 CellID->21379]
}, Open  ]],
Cell[15598, 570, 121, 3, 70, "ExampleDelimiter",
 CellID->10469],
Cell[15722, 575, 231, 8, 70, "ExampleText",
 CellID->25086],
Cell[CellGroupData[{
Cell[15978, 587, 290, 10, 70, "Input",
 CellID->5475],
Cell[16271, 599, 358, 10, 36, "Output",
 CellID->32724]
}, Open  ]],
Cell[CellGroupData[{
Cell[16666, 614, 336, 11, 70, "Input",
 CellID->4246],
Cell[17005, 627, 680, 17, 139, "Output",
 CellID->5187]
}, Open  ]],
Cell[17700, 647, 121, 3, 70, "ExampleDelimiter",
 CellID->13517],
Cell[17824, 652, 85, 1, 70, "ExampleText",
 CellID->10282],
Cell[CellGroupData[{
Cell[17934, 657, 357, 12, 70, "Input",
 CellID->2071],
Cell[18294, 671, 1100, 24, 246, "Output",
 CellID->20340]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19443, 701, 233, 7, 70, "ExampleSection",
 CellID->12625],
Cell[19679, 710, 185, 8, 70, "ExampleText",
 CellID->23273],
Cell[CellGroupData[{
Cell[19889, 722, 268, 9, 70, "Input",
 CellID->9947],
Cell[20160, 733, 217, 10, 48, "Output",
 CellID->16006]
}, Open  ]],
Cell[20392, 746, 121, 3, 70, "ExampleDelimiter",
 CellID->17388],
Cell[20516, 751, 300, 12, 70, "ExampleText",
 CellID->20917],
Cell[CellGroupData[{
Cell[20841, 767, 120, 4, 70, "Input",
 CellID->1243],
Cell[20964, 773, 209, 7, 36, "Output",
 CellID->29338]
}, Open  ]],
Cell[21188, 783, 121, 3, 70, "ExampleDelimiter",
 CellID->32184],
Cell[21312, 788, 82, 1, 70, "ExampleText",
 CellID->24957],
Cell[CellGroupData[{
Cell[21419, 793, 141, 4, 70, "Input",
 CellID->24639],
Cell[21563, 799, 154, 5, 36, "Output",
 CellID->31094]
}, Open  ]],
Cell[CellGroupData[{
Cell[21754, 809, 151, 4, 70, "Input",
 CellID->29260],
Cell[21908, 815, 154, 5, 36, "Output",
 CellID->27531]
}, Open  ]],
Cell[22077, 823, 119, 3, 70, "ExampleDelimiter",
 CellID->253],
Cell[CellGroupData[{
Cell[22221, 830, 141, 4, 70, "Input",
 CellID->30665],
Cell[22365, 836, 154, 5, 36, "Output",
 CellID->32237]
}, Open  ]],
Cell[CellGroupData[{
Cell[22556, 846, 151, 4, 70, "Input",
 CellID->15390],
Cell[22710, 852, 153, 5, 36, "Output",
 CellID->7971]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22912, 863, 224, 7, 70, "ExampleSection",
 CellID->19460],
Cell[CellGroupData[{
Cell[23161, 874, 215, 7, 70, "Input",
 CellID->28184],
Cell[23379, 883, 5007, 86, 70, "Output",
 Evaluatable->False,
 CellID->390930556]
}, Open  ]],
Cell[28401, 972, 121, 3, 70, "ExampleDelimiter",
 CellID->16099],
Cell[CellGroupData[{
Cell[28547, 979, 437, 14, 70, "Input",
 CellID->16491],
Cell[28987, 995, 8094, 137, 70, "Output",
 Evaluatable->False,
 CellID->140284368]
}, Open  ]],
Cell[37096, 1135, 120, 3, 70, "ExampleDelimiter",
 CellID->8890],
Cell[37219, 1140, 264, 8, 70, "ExampleText",
 CellID->8106],
Cell[CellGroupData[{
Cell[37508, 1152, 599, 19, 70, "Input",
 CellID->7413],
Cell[38110, 1173, 1130, 23, 70, "Output",
 Evaluatable->False,
 CellID->24053469]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39301, 1203, 311, 9, 70, "SeeAlsoSection",
 CellID->15966],
Cell[39615, 1214, 1694, 62, 70, "SeeAlso",
 CellID->21104]
}, Open  ]],
Cell[CellGroupData[{
Cell[41346, 1281, 314, 9, 70, "TutorialsSection",
 CellID->27117],
Cell[41663, 1292, 198, 4, 70, "Tutorials",
 CellID->19084]
}, Open  ]],
Cell[CellGroupData[{
Cell[41898, 1301, 319, 9, 70, "MoreAboutSection",
 CellID->127689651],
Cell[42220, 1312, 145, 3, 70, "MoreAbout",
 CellID->4719774],
Cell[42368, 1317, 164, 3, 70, "MoreAbout",
 CellID->140056113],
Cell[42535, 1322, 151, 3, 70, "MoreAbout",
 CellID->330744959],
Cell[42689, 1327, 145, 3, 70, "MoreAbout",
 CellID->355297389],
Cell[42837, 1332, 136, 3, 70, "MoreAbout",
 CellID->71903114],
Cell[42976, 1337, 160, 3, 70, "MoreAbout",
 CellID->576563354]
}, Open  ]],
Cell[CellGroupData[{
Cell[43173, 1345, 305, 8, 70, "RelatedLinksSection"],
Cell[43481, 1355, 357, 12, 70, "RelatedLinks"],
Cell[43841, 1369, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[44240, 1385, 27, 0, 70, "History"],
Cell[44270, 1387, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

