(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24066,        603]
NotebookOptionsPosition[     21381,        512]
NotebookOutlinePosition[     22611,        548]
CellTagsIndexPosition[     22526,        543]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"],
           "RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "Hue" :> Documentation`HelpLookup["paclet:ref/Hue"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GrayLevel\"\>", 2->"\<\"RGBColor\"\>", 
       3->"\<\"Hue\"\>", 4->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Black", "ObjectName",
 CellID->29766],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Black",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Black"]], "InlineFormula"],
     "\[LineSeparator]represents the color black in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16024]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Black",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Black"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24544]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67715092],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->91555270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Black", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->121135682]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->469666628],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWT1MHEcUXu64gwNjX+6OgxwGnwlxLjbBBFkOjolDFCmmiURJCbIinYso
yHFBYYUmESWdKSkpKSkpKSkpKSkpKTfvzZvZt/Ptz+kAidt5OzPf+3/zs79v
fez+8efWx/fvttpvP2xtd9+/+7v9218f6FVxIAiCz/S/MRlQO6SW+f8chvRM
/g7Rb5EGFJjiRmj+ggI1/zMjhqGnyD+DSgdBCUZ8ktdFefBfwZE9cXjACyZL
R0dHa2try8vLq6urBwcHwa+3lGaJfyo3Nzfr6+sbGxsnJydnZ2enp6fdbpfA
r6+vg19uify9oQmBcI6Pj20/oZPEjLt6J1xSnmTlZtnQ5+fnFvfnyHNs1zI8
eXZhd3e3YmaRXKQ3N9+YWRPA67nDXlxc5OaIoclOZH5u/pQzi6bQRJ11dXXV
brfJ0hmzFgxNviTTc/Oeoff29nZ2dri5Es1iPWQ0oREmIQdjQK+k8vjO0Pv7
+9vb29y8D/Tr1FnzgP0A6NeeZMijCvSPOTwI8PLyUmcpj/RZzwxNgUDhwM2a
oYkRsePmq5xZ5Hhyv866uLjodDr+LNbnmfPe5OQkNxsQf8tevMXz2OV2Gfg/
NTS5lZyriBqLglhOZMIQ4GDNEFwSk4RVXLXhkrNOfH6iEknCxdj25PstyN8E
/UzqFKmoUIYapfrQj0nB16wTfM1Kwd/c3Dw8PMzDL4VaC+J8Os5O1WqV89O4
uUjBQCERRpmp/aUc/Dgu0sKHhCRRuSl8NMMXoL/kRZZ7pqNqPAoqpRF5XVG1
X1BddMtsrU0tQ5OjyF1hlJca/eVodlyGbwyttasF9DxomodCywUtEopCNZ14
s2zz4Jeyp0mdnuyOKuiP0Tpux5u6Yd/V7btGqOt9lM0JOesxOog4qnbIsRGL
FPKu5ePHjsEs0cLkZR7LwVuWAX6mytIA2tTmwciG1ibjBl1G8RoZBGzPeoYU
ZOE+pRgHegx8EN8/MWIzJo+8Il8YXZwnXT12/H05C57nm6ncfX+4cUXjec2x
WgKb3/AOIckx3wZJJFknNZ6dHBO+N2x0p0vi4r2XHTA+CxF/9QJWjmboMkGr
Q82+E2lkrqwNTvr0nJizVnsc+jXsCfii4nnua7CQJCzZhCqtztb+Sirvr0DP
2dCvYXOhX8NGclB0nyIoWsPmgM5DUd6zwFtQ1N6CwvnzT9K2llPq2eAO9CBo
gntwyE4xic2qPrkORXRoah9FRbTFwLGqt7XVLNhqLtXPui/IRpUoj0pi8CgM
vZUF40ziUFf8e758Es5Br1gXFBKOROQmoNjkegxaPgEt26BlDMXWApEbdeqA
TjOg0xhYR+WeAb06oNcM6DWWkEikfwSadUCzGdAshqPRJwoE06Cd7HU1zx6C
dvfTsKzfpkG/p5APD0E/xSq4Qmh9Nw1SCJJmuyDpSSMmVTmeGaLkFMyeB3Tc
Dz3IQBM1BU3r2Txo2QIrZKGJqlMQTbgvbIGvFU1PRaqJ7FH1xLWQ2q+amsXA
1KmsMxbmfgG0Y0Ren56nvE+cVuUkkns2SdwIQfz1OkNIv94R9MO3GNlAzzyy
ByLnkIu4KWcicjU5XPv1zPTFLfUUvnqWa4IciyBHE+TI4uvOZuhHWav0XqAB
kbEEdo7OvNTPO91aDr8kH6TxjK5xsgR0A+Kq5kWsO7sNelpqJWxANAg63jlo
fgg67j0EFe811OcvevTXc1DxjkU9Kqh6+sc7mHTUMmhcdRrbc+jL1H71eyNC
LURRm33n9BK8g/2NHBmz771+6NE/noqKsuId3HKP/jzU7PvAVz36m5495XYU
7yLhDi+nv5kqYwV8ivei5s4ytsZg/0QOKkHSRB41AlG+AlEu/ZTZdtehqKz5
aBi/H9aIeQMayp5Z9wgmTc3brO8FWHFGDZ1yj231WHX9Vg/s/9JwrABq8v4c
K9uoyyQqJ3ovLxU9uu8vyheBtP7WLfmaGKkQQvSlgXjIlwaLbL5h2G8R9Bcf
Yb9FTPXBmweY3LHfSoaHh+23krfmLenmvZ2+pV6f7jTPrRDu+8S/5m3yS1Qw
8D+aZ1vR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->450296615]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->369202442],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Background->GrayLevel[0],
  Boxed->False]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->904190,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12384],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->60590608],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->180168532]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Black - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 20.0834710}", "context" -> "System`", 
    "keywords" -> {"black", "color", "grayscale", "rgb color"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Black represents the color black in graphics or style specifications. ", 
    "synonyms" -> {}, "title" -> "Black", "type" -> "Symbol", "uri" -> 
    "ref/Black"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3369, 116, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->67715092]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22384, 536}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1367, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1990, 59, 43, 1, 70, "ObjectName",
 CellID->29766],
Cell[2036, 62, 443, 14, 70, "Usage",
 CellID->16024]
}, Open  ]],
Cell[CellGroupData[{
Cell[2516, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2994, 98, 338, 13, 70, "Notes",
 CellID->24544]
}, Closed]],
Cell[CellGroupData[{
Cell[3369, 116, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67715092],
Cell[CellGroupData[{
Cell[3753, 130, 147, 5, 70, "ExampleSection",
 CellID->91555270],
Cell[CellGroupData[{
Cell[3925, 139, 183, 6, 28, "Input",
 CellID->511908593],
Cell[4111, 147, 258, 8, 121, "Output",
 CellID->121135682]
}, Open  ]],
Cell[CellGroupData[{
Cell[4406, 160, 266, 8, 28, "Input",
 CellID->469666628],
Cell[4675, 170, 2346, 43, 109, "Output",
 Evaluatable->False,
 CellID->450296615]
}, Open  ]],
Cell[CellGroupData[{
Cell[7058, 218, 249, 7, 70, "Input",
 CellID->369202442],
Cell[7310, 227, 12214, 206, 129, 106, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->904190]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19585, 440, 311, 9, 70, "SeeAlsoSection",
 CellID->12384],
Cell[19899, 451, 926, 35, 70, "SeeAlso",
 CellID->4421]
}, Open  ]],
Cell[CellGroupData[{
Cell[20862, 491, 318, 9, 70, "MoreAboutSection",
 CellID->60590608],
Cell[21183, 502, 124, 3, 70, "MoreAbout",
 CellID->180168532]
}, Open  ]],
Cell[21322, 508, 29, 0, 70, "History"],
Cell[21354, 510, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

