(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15807,        568]
NotebookOptionsPosition[     12127,        444]
NotebookOutlinePosition[     13489,        483]
CellTagsIndexPosition[     13404,        478]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/Introduction-Patterns"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Introduction to Patterns\"\>", 
       2->"\<\"String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BlankSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankSequence"], 
          "BlankNullSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankNullSequence"], "Pattern" :> 
          Documentation`HelpLookup["paclet:ref/Pattern"], "Optional" :> 
          Documentation`HelpLookup["paclet:ref/Optional"], "ForAll" :> 
          Documentation`HelpLookup["paclet:ref/ForAll"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], "Slot" :> 
          Documentation`HelpLookup["paclet:ref/Slot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BlankSequence\"\>", 
       2->"\<\"BlankNullSequence\"\>", 3->"\<\"Pattern\"\>", 
       4->"\<\"Optional\"\>", 5->"\<\"ForAll\"\>", 
       6->"\<\"StringExpression\"\>", 7->"\<\"Slot\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Patterns\"\>", 
       3->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Blank ",
 StyleBox["(_)", "OperatorCharacter"]
}], "ObjectName",
 CellID->22650],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["_"], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Blank",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blank"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]is a pattern object that can stand for any ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      StyleBox[
       RowBox[{"_", 
        StyleBox["h", "TI"]}]]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Blank",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blank"], "[", 
       StyleBox["h", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]can stand for any expression with head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"_", 
    StyleBox["h", "TI"]}]]], "InlineFormula"],
 " cannot itself contain pattern objects. "
}], "Notes",
 CellID->5819]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323800498],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->408252085],

Cell["A pattern that matches any expression:", "ExampleText",
 CellID->18882083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"any", "[", "expression", "]"}], ",", "_"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109463932],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66158186]
}, Open  ]],

Cell["A pattern that matches any symbol:", "ExampleText",
 CellID->671390515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{"symbol", ",", " ", "_Symbol"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->528915184],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158684402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->488271376],

Cell["A function definition that will take any single argument:", \
"ExampleText",
 CellID->170324876],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}], "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61084815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", " ", "+", " ", 
     RowBox[{"b", " ", "c"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298679796],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "a", "+", 
      RowBox[{"b", " ", "c"}]}], ")"}], "2"]}], "}"}]], "Output",
 ImageSize->{112, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->154421022]
}, Open  ]],

Cell["A function definition for integer arguments only:", "ExampleText",
 CellID->284694922],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_Integer", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Prime", "[", "x", "]"}], "-", "x"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->803097311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "10", "]"}], ",", 
   RowBox[{"g", "[", "z", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->479211859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"19", ",", 
   RowBox[{"g", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->73607799]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13705],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankNullSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankNullSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Optional",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Optional"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24644]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5621],

Cell[TextData[ButtonBox["Introduction to Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Introduction-Patterns"]], "Tutorials",
 CellID->19483],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->53917850],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->80418575],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->91976773],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->668766325]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Blank (_) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 20.3803536}", "context" -> "System`", 
    "keywords" -> {
     "any expression", "blank", "pattern variables", "underbar", "underscore",
       "wildcards"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "_or Blank[] is a pattern object that can stand for any Mathematica \
expression. _h or Blank[h] can stand for any expression with head h. ", 
    "synonyms" -> {"_"}, "title" -> "Blank", "type" -> "Symbol", "uri" -> 
    "ref/Blank"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5387, 171, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->323800498]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13261, 471}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2782, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3405, 91, 98, 4, 70, "ObjectName",
 CellID->22650],
Cell[3506, 97, 1071, 36, 70, "Usage",
 CellID->15008]
}, Open  ]],
Cell[CellGroupData[{
Cell[4614, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5092, 155, 258, 11, 70, "Notes",
 CellID->5819]
}, Closed]],
Cell[CellGroupData[{
Cell[5387, 171, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323800498],
Cell[CellGroupData[{
Cell[5772, 185, 148, 5, 70, "ExampleSection",
 CellID->408252085],
Cell[5923, 192, 80, 1, 70, "ExampleText",
 CellID->18882083],
Cell[CellGroupData[{
Cell[6028, 197, 165, 5, 28, "Input",
 CellID->109463932],
Cell[6196, 204, 160, 5, 36, "Output",
 CellID->66158186]
}, Open  ]],
Cell[6371, 212, 77, 1, 70, "ExampleText",
 CellID->671390515],
Cell[CellGroupData[{
Cell[6473, 217, 141, 4, 28, "Input",
 CellID->528915184],
Cell[6617, 223, 161, 5, 36, "Output",
 CellID->158684402]
}, Open  ]],
Cell[6793, 231, 125, 3, 70, "ExampleDelimiter",
 CellID->488271376],
Cell[6921, 236, 102, 2, 70, "ExampleText",
 CellID->170324876],
Cell[7026, 240, 203, 7, 70, "Input",
 CellID->61084815],
Cell[CellGroupData[{
Cell[7254, 251, 234, 8, 70, "Input",
 CellID->298679796],
Cell[7491, 261, 317, 11, 39, "Output",
 CellID->154421022]
}, Open  ]],
Cell[7823, 275, 92, 1, 70, "ExampleText",
 CellID->284694922],
Cell[7918, 278, 195, 6, 70, "Input",
 CellID->803097311],
Cell[CellGroupData[{
Cell[8138, 288, 174, 6, 70, "Input",
 CellID->479211859],
Cell[8315, 296, 232, 8, 36, "Output",
 CellID->73607799]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8608, 311, 311, 9, 70, "SeeAlsoSection",
 CellID->13705],
Cell[8922, 322, 1706, 62, 70, "SeeAlso",
 CellID->24644]
}, Open  ]],
Cell[CellGroupData[{
Cell[10665, 389, 313, 9, 70, "TutorialsSection",
 CellID->5621],
Cell[10981, 400, 156, 3, 70, "Tutorials",
 CellID->19483],
Cell[11140, 405, 139, 3, 70, "Tutorials",
 CellID->8153]
}, Open  ]],
Cell[CellGroupData[{
Cell[11316, 413, 318, 9, 70, "MoreAboutSection",
 CellID->53917850],
Cell[11637, 424, 144, 3, 70, "MoreAbout",
 CellID->80418575],
Cell[11784, 429, 127, 3, 70, "MoreAbout",
 CellID->91976773],
Cell[11914, 434, 141, 3, 70, "MoreAbout",
 CellID->668766325]
}, Open  ]],
Cell[12070, 440, 27, 0, 70, "History"],
Cell[12100, 442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

