(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15432,        539]
NotebookOptionsPosition[     11883,        424]
NotebookOutlinePosition[     13396,        465]
CellTagsIndexPosition[     13311,        460]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions with Variable Numbers of Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionsWithVariableNumbersOfArguments"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Functions with Variable Numbers of Arguments\"\>", 
       2->"\<\"String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BlankNullSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankNullSequence"], "Blank" :> 
          Documentation`HelpLookup["paclet:ref/Blank"], "OptionsPattern" :> 
          Documentation`HelpLookup["paclet:ref/OptionsPattern"], "Repeated" :> 
          Documentation`HelpLookup["paclet:ref/Repeated"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BlankNullSequence\"\>", 
       2->"\<\"Blank\"\>", 3->"\<\"OptionsPattern\"\>", 4->"\<\"Repeated\"\>",
        5->"\<\"Sequence\"\>", 
       6->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Patterns\"\>", 
       3->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "BlankSequence ",
 StyleBox["(__)", "OperatorCharacter"]
}], "ObjectName",
 CellID->19464],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["__"], "InlineFormula"],
     " (two ",
     Cell[BoxData["_"], "InlineFormula"],
     " characters) or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["BlankSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlankSequence"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]is a pattern object that can stand for any sequence of \
one or more ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expressions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      StyleBox[
       RowBox[{"__", 
        StyleBox["h", "TI"]}]]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["BlankSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlankSequence"], "[", 
       StyleBox["h", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]can stand for any sequence of one or more expressions, \
all of which have head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->6847]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->43557585],

Cell["\<\
A function definition that works with any nonzero number of arguments:\
\>", "ExampleText",
 CellID->55988368],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x__", "]"}], ":=", " ", 
  RowBox[{"Length", "[", 
   RowBox[{"{", "x", "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555976817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", " ", 
   RowBox[{"f", "[", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120076177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"f", "[", "]"}]}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->220757372]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->554208347],

Cell["\<\
A function definition that works with any nonzero number of real arguments:\
\>", "ExampleText",
 CellID->127660014],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x__Real", "]"}], ":=", 
  RowBox[{
   RowBox[{"Plus", "[", "x", "]"}], "/", 
   RowBox[{"Length", "[", 
    RowBox[{"{", "x", "}"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15835199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1.", ",", 
     RowBox[{"N", "[", "Pi", "]"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", 
     RowBox[{"N", "[", "Pi", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->163597469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.0707963267948966`", ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "3.141592653589793`"}], "]"}]}], "}"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->507451833]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->415296182],

Cell["\<\
A function definition for a symbol followed by any nonzero number of integer \
arguments:\
\>", "ExampleText",
 CellID->30810454],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_Symbol", ",", " ", "p__Integer"}], "]"}], ":=", " ", 
  RowBox[{"Apply", "[", 
   RowBox[{"Plus", ",", " ", 
    RowBox[{"x", "^", 
     RowBox[{"{", "p", "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165300514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "1", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"0", ",", "1", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "1", ",", "2."}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->843708055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"0", ",", "1", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "1", ",", "2.`"}], "]"}]}], "}"}]], "Output",
 ImageSize->{209, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56131241]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11991],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankNullSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankNullSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blank",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blank"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OptionsPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionsPattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Repeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Repeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28803],

Cell[TextData[ButtonBox["Functions with Variable Numbers of Arguments",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionsWithVariableNumbersOfArguments"]], "Tutorials",
 CellID->6824],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->346532988],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->55645992],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->2432101],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->970084093]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BlankSequence (__) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 20.8803664}", "context" -> "System`", 
    "keywords" -> {
     "one or more", "sequence of expressions", "sequence of arguments", 
      "pattern language"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "__(two _characters) or BlankSequence[] is a pattern object that can \
stand for any sequence of one or more Mathematica expressions. __h or \
BlankSequence[h] can stand for any sequence of one or more expressions, all \
of which have head h. ", "synonyms" -> {"blank sequence", "__", "varargs"}, 
    "title" -> "BlankSequence", "type" -> "Symbol", "uri" -> 
    "ref/BlankSequence"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4769, 141, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13176, 453}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2751, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3374, 89, 107, 4, 70, "ObjectName",
 CellID->19464],
Cell[3484, 95, 1248, 41, 70, "Usage",
 CellID->6847]
}, Open  ]],
Cell[CellGroupData[{
Cell[4769, 141, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5146, 155, 147, 5, 70, "ExampleSection",
 CellID->43557585],
Cell[5296, 162, 120, 3, 70, "ExampleText",
 CellID->55988368],
Cell[5419, 167, 185, 6, 70, "Input",
 CellID->555976817],
Cell[CellGroupData[{
Cell[5629, 177, 208, 7, 28, "Input",
 CellID->120076177],
Cell[5840, 186, 227, 8, 36, "Output",
 CellID->220757372]
}, Open  ]],
Cell[6082, 197, 125, 3, 70, "ExampleDelimiter",
 CellID->554208347],
Cell[6210, 202, 126, 3, 70, "ExampleText",
 CellID->127660014],
Cell[6339, 207, 240, 8, 70, "Input",
 CellID->15835199],
Cell[CellGroupData[{
Cell[6604, 219, 288, 10, 70, "Input",
 CellID->163597469],
Cell[6895, 231, 293, 9, 36, "Output",
 CellID->507451833]
}, Open  ]],
Cell[7203, 243, 125, 3, 70, "ExampleDelimiter",
 CellID->415296182],
Cell[7331, 248, 139, 4, 70, "ExampleText",
 CellID->30810454],
Cell[7473, 254, 286, 9, 70, "Input",
 CellID->165300514],
Cell[CellGroupData[{
Cell[7784, 267, 318, 10, 70, "Input",
 CellID->843708055],
Cell[8105, 279, 393, 13, 39, "Output",
 CellID->56131241]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8559, 299, 311, 9, 70, "SeeAlsoSection",
 CellID->11991],
Cell[8873, 310, 1470, 53, 70, "SeeAlso",
 CellID->8292]
}, Open  ]],
Cell[CellGroupData[{
Cell[10380, 368, 314, 9, 70, "TutorialsSection",
 CellID->28803],
Cell[10697, 379, 196, 4, 70, "Tutorials",
 CellID->6824],
Cell[10896, 385, 139, 3, 70, "Tutorials",
 CellID->8153]
}, Open  ]],
Cell[CellGroupData[{
Cell[11072, 393, 319, 9, 70, "MoreAboutSection",
 CellID->346532988],
Cell[11394, 404, 144, 3, 70, "MoreAbout",
 CellID->55645992],
Cell[11541, 409, 126, 3, 70, "MoreAbout",
 CellID->2432101],
Cell[11670, 414, 141, 3, 70, "MoreAbout",
 CellID->970084093]
}, Open  ]],
Cell[11826, 420, 27, 0, 70, "History"],
Cell[11856, 422, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

