(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    454563,       9024]
NotebookOptionsPosition[    441934,       8592]
NotebookOutlinePosition[    443642,       8635]
CellTagsIndexPosition[    443555,       8630]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"],
           "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], 
          "Opacity" :> Documentation`HelpLookup["paclet:ref/Opacity"], 
          "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"], "GrayLevel" :> 
          Documentation`HelpLookup["paclet:ref/GrayLevel"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"], "Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ColorData\"\>", 
       2->"\<\"Lighter\"\>", 3->"\<\"Darker\"\>", 4->"\<\"Opacity\"\>", 
       5->"\<\"ColorFunction\"\>", 6->"\<\"GrayLevel\"\>", 7->"\<\"Hue\"\>", 
       8->"\<\"RGBColor\"\>", 9->"\<\"ColorSlider\"\>", 
       10->"\<\"Interpolation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Graphics Directives\"\>", 
       3->"\<\"Graphics Options & Styling\"\>", 4->"\<\"Plotting Options\"\>",
        5->"\<\"Symbolic Graphics Language\"\>", 
       6->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Blend", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Blend",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blend"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["col", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["col", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a color obtained by blending a fraction ",
     Cell[BoxData[
      FormBox[
       RowBox[{"1", "-", "x"}], TraditionalForm]], "InlineMath"],
     " of color ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " of color ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Blend",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blend"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["col", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["col", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["col", "TI"], 
           StyleBox["3", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]linearly interpolates between colors ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " varies from 0 to 1."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Blend",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blend"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["col", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["col", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]interpolates to give ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "=", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]]}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Blend",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blend"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["col", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["col", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]blends all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", using fraction ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " of color ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Blend",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blend"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["col", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["col", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]blends equal fractions of all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["n", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are normalized to have total 1. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->337171823]
}], "Notes",
 CellID->10782],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 " implements additive color mixing, as appropriate for color light sources \
or light\[Hyphen]generating displays. "
}], "Notes",
 CellID->24729]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160993291],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->17480994],

Cell["Blend two colors by fractions:", "ExampleText",
 CellID->128950338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blend", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", "Blue"}], "}"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172799001],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
   FractionBox["2", "3"], ",", "0", ",", 
   FractionBox["1", "3"]}], "]"}]], "Output",
 ImageSize->{126, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102791748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->820029580],

Cell["\<\
Generate an array of blended colors ranging from red to blue:\
\>", "ExampleText",
 CellID->6635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Blue"}], "}"}], ",", "x"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"8", "x"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "8"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22881],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
   {RGBColor[
     NCache[
      Rational[7, 8], 0.875], 0, 
     NCache[
      Rational[1, 8], 0.125]], DiskBox[{1, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 4], 0.75], 0, 
     NCache[
      Rational[1, 4], 0.25]], DiskBox[{2, 0}]}, 
   {RGBColor[
     NCache[
      Rational[5, 8], 0.625], 0, 
     NCache[
      Rational[3, 8], 0.375]], DiskBox[{3, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 2], 0.5], 0, 
     NCache[
      Rational[1, 2], 0.5]], DiskBox[{4, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 8], 0.375], 0, 
     NCache[
      Rational[5, 8], 0.625]], DiskBox[{5, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 4], 0.25], 0, 
     NCache[
      Rational[3, 4], 0.75]], DiskBox[{6, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 8], 0.125], 0, 
     NCache[
      Rational[7, 8], 0.875]], DiskBox[{7, 0}]}, 
   {RGBColor[0, 0, 1], DiskBox[{8, 0}]}},
  ImageMargins->0.]], "Output",
 ImageSize->{184, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347773838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13577],

Cell["Represent the height as a blend from yellow to purple: ", "ExampleText",
 CellID->17173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Purple"}], "}"}], ",", "#3"}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23017],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197447223]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158240582],

Cell["Averaging two colors equally:", "ExampleText",
 CellID->95155050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Blend", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow"}], "}"}], "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->611480004],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 
    NCache[
     Rational[1, 2], 0.5], 0], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->59126898]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->187516040],

Cell["Linear interpolation between two color:", "ExampleText",
 CellID->325173071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blend", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green"}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137582791],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"], ",", "0"}], "]"}]], "Output",
 ImageSize->{126, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481166600]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green"}], "}"}], ",", "x"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"8", "x"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "8"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261138928],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
   {RGBColor[
     NCache[
      Rational[7, 8], 0.875], 
     NCache[
      Rational[1, 8], 0.125], 0], DiskBox[{1, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 4], 0.75], 
     NCache[
      Rational[1, 4], 0.25], 0], DiskBox[{2, 0}]}, 
   {RGBColor[
     NCache[
      Rational[5, 8], 0.625], 
     NCache[
      Rational[3, 8], 0.375], 0], DiskBox[{3, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 2], 0.5], 
     NCache[
      Rational[1, 2], 0.5], 0], DiskBox[{4, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 8], 0.375], 
     NCache[
      Rational[5, 8], 0.625], 0], DiskBox[{5, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 4], 0.25], 
     NCache[
      Rational[3, 4], 0.75], 0], DiskBox[{6, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 8], 0.125], 
     NCache[
      Rational[7, 8], 0.875], 0], DiskBox[{7, 0}]}, 
   {RGBColor[0, 1, 0], DiskBox[{8, 0}]}}]], "Output",
 ImageSize->{184, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->471409438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->609915099],

Cell["Linear interpolation between two colors and two opacities:", \
"ExampleText",
 CellID->75834295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blend", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "]"}]}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->509266624],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"], ",", "0", ",", 
   FractionBox["1", "2"]}], "]"}]], "Output",
 ImageSize->{148, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458035993]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0", ",", "1"}], "]"}], ",", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "]"}]}], "}"}], ",", 
        "x"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"8", "x"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "8"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52272376],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], Opacity[1], DiskBox[{0, 0}]}, 
   {RGBColor[
     NCache[
      Rational[7, 8], 0.875], 
     NCache[
      Rational[1, 8], 0.125], 0], Opacity[
     NCache[
      Rational[7, 8], 0.875]], DiskBox[{1, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 4], 0.75], 
     NCache[
      Rational[1, 4], 0.25], 0], Opacity[
     NCache[
      Rational[3, 4], 0.75]], DiskBox[{2, 0}]}, 
   {RGBColor[
     NCache[
      Rational[5, 8], 0.625], 
     NCache[
      Rational[3, 8], 0.375], 0], Opacity[
     NCache[
      Rational[5, 8], 0.625]], DiskBox[{3, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 2], 0.5], 
     NCache[
      Rational[1, 2], 0.5], 0], Opacity[
     NCache[
      Rational[1, 2], 0.5]], DiskBox[{4, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 8], 0.375], 
     NCache[
      Rational[5, 8], 0.625], 0], Opacity[
     NCache[
      Rational[3, 8], 0.375]], DiskBox[{5, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 4], 0.25], 
     NCache[
      Rational[3, 4], 0.75], 0], Opacity[
     NCache[
      Rational[1, 4], 0.25]], DiskBox[{6, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 8], 0.125], 
     NCache[
      Rational[7, 8], 0.875], 0], Opacity[
     NCache[
      Rational[1, 8], 0.125]], DiskBox[{7, 0}]}, 
   {RGBColor[0, 1, 0], Opacity[0], DiskBox[{8, 0}]}}]], "Output",
 ImageSize->{184, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->540082150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131711636],

Cell["Linear interpolation between multiple colors uniformly:", "ExampleText",
 CellID->55785783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Yellow", ",", "Green"}], "}"}], ",", "x"}], 
       "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"8", "x"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "8"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184493667],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
   {RGBColor[1, 
     NCache[
      Rational[1, 4], 0.25], 0], DiskBox[{1, 0}]}, 
   {RGBColor[1, 
     NCache[
      Rational[1, 2], 0.5], 0], DiskBox[{2, 0}]}, 
   {RGBColor[1, 
     NCache[
      Rational[3, 4], 0.75], 0], DiskBox[{3, 0}]}, 
   {RGBColor[1, 1, 0], DiskBox[{4, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 4], 0.75], 1, 0], DiskBox[{5, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 2], 0.5], 1, 0], DiskBox[{6, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 4], 0.25], 1, 0], DiskBox[{7, 0}]}, 
   {RGBColor[0, 1, 0], DiskBox[{8, 0}]}}]], "Output",
 ImageSize->{184, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->431714262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->230501118],

Cell["Linear interpolation between colors at specific values:", "ExampleText",
 CellID->198354028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "Red"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "Yellow"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "Green"}], "}"}]}], "}"}], ",", "x"}], "]"}], 
      ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25684592],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], DiskBox[{1, 0}]}, 
   {RGBColor[1, 
     NCache[
      Rational[1, 2], 0.5], 0], DiskBox[{2, 0}]}, 
   {RGBColor[1, 1, 0], DiskBox[{3, 0}]}, 
   {RGBColor[
     NCache[
      Rational[6, 7], 0.8571428571428571], 1, 0], DiskBox[{4, 0}]}, 
   {RGBColor[
     NCache[
      Rational[5, 7], 0.7142857142857143], 1, 0], DiskBox[{5, 0}]}, 
   {RGBColor[
     NCache[
      Rational[4, 7], 0.5714285714285714], 1, 0], DiskBox[{6, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 7], 0.42857142857142855`], 1, 0], DiskBox[{7, 0}]}, 
   {RGBColor[
     NCache[
      Rational[2, 7], 0.2857142857142857], 1, 0], DiskBox[{8, 0}]}, 
   {RGBColor[
     NCache[
      Rational[1, 7], 0.14285714285714285`], 1, 0], DiskBox[{9, 0}]}, 
   {RGBColor[0, 1, 0], DiskBox[{10, 0}]}}]], "Output",
 ImageSize->{184, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317835398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198770333],

Cell["Blending colors with equal weights:", "ExampleText",
 CellID->120244352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blend", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "1", ",", "0"}], "]"}], ",", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->363983036],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
   FractionBox["1", "3"], ",", 
   FractionBox["1", "3"], ",", 
   FractionBox["1", "3"]}], "]"}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490586267]
}, Open  ]],

Cell["Blending colors with specified weights:", "ExampleText",
 CellID->707436826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blend", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "1", ",", "0"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "8"}], ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"3", "/", "8"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->163460510],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
   FractionBox["1", "8"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["3", "8"]}], "]"}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->311003930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"1", "-", "x"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"1", "-", "x", "-", "y"}]}], "}"}]}], "]"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->133794],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzdmE1MXFUUx0cTNzXRhR8xbBqTduHKpGHRRuUR7UI3NVEX6kISi0ZNhKRp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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxFmQn4l1MWx98bg6KQIjQorVqRNC0SkkTxpxTtRSEtShFRyVqStEklW6mE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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJztmU9s3EcVxxdQewgSRCJBKJcKqT1wIqpycKHkWZAD5VAq4ND2QCpqqlAp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    "]],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{0, 1}, {0, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->202617928,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->109836838],

Cell["\<\
Different colors can be given at the single position to generate \
discontinuity:\
\>", "ExampleText",
 CellID->203857916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Raster", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", "100", "]"}], "/", "100"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Blend", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "Red"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", "Yellow"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", "Green"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "Blue"}], "}"}]}], "}"}], ",", "#"}], "]"}], 
        "&"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", ".3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212444258],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3KFvmmEUxeHTl2IwGMQwpAkGg+nEMDWIYZiowWAgDU0bsox0rcFgMBgM
CoPBYDBNk5oaDAqDwWAwGAwGg3p3b+3S/+CXnPvxnSO/PJpfzeeH1u/m8+Nd
86ry1Ow8PN79vfr558mmxIWkN7sf32Tv0d4+7y1G+/3/eWnPEJNSIqYU0x6F
mLHL+pZTzHusF+yKvn1XLHms33gvK1Y81qt2t77VFOse6w3v94ptj/WO3Ytv
XcWex3rf+0Bx6LE+shv7NlGceqzPvM8VXz3W3+0+fFsoLj3WV3Zr3zaKW4/1
nfe94sFj/Wh38u38+WksQeekEjqldEx7gg6ZoH3Wtl1O27wnaFOwvi5qde0J
WpaCFje2fZT1XvEEvVatz281q3mCpvWgScO2cUujtido2LE+eFG/6wnq9YK6
fdteBuoMPUHtUVBrbFtjovrUE1SbWb+dq/rqCaq8B5U/bLtZqLT0BF2vrBfX
Kmw8QfltUG5nW3avzMETlD5aT52UPHuCfYFLJCABCUhAAhKQgAQkIAEJSEAC
EpCABCQgAQlIQAISkIAEJCABCUhAAhKQgAQkIAEJSEACEpCABCQgAQlIQAIS
kIAEJCABCUhAAhKQgAQkIAEJSEACEpCABCQgAQlIQAISkIAEJCABCUhAAhKQ
gAQkIAEJSEACEpCABCQgAQlIQMIXEr76t39d/AMb7meo\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203030866]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->590578476],

Cell[TextData[{
 "Use Blend to construct a ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " from base colors:"
}], "ExampleText",
 CellID->218910725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", "^", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"LightBlue", ",", "Blue"}], "}"}], ",", "#2"}], "]"}], "&"}],
      ")"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160441923],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45314481]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", " ", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"y", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"RegionFunction", "\[Rule]", " ", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ">", "0.1"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Lighter", "[", 
           RowBox[{"Yellow", ",", ".8"}], "]"}], ",", "Orange", ",", "Red"}], 
         "}"}], ",", "#3"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->640626787],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133919398]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"z", "^", "4"}], "+", 
     RowBox[{"z", "^", "5"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Cyan", ",", "Magenta", ",", "Yellow"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2", ",", "#3"}], "}"}]}], "]"}], "&"}], ")"}]}],
    ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ContourStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.7", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48479714],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27225802]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->146789925],

Cell["\<\
If the sum of weights are greater than 1, they are normalized: \
\>", "ExampleText",
 CellID->337171823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blend", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->642276887],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{
   FractionBox["1", "6"], ",", 
   FractionBox["1", "3"], ",", 
   FractionBox["1", "2"]}], "]"}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112251659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2070450],

Cell["The position values are always sorted:", "ExampleText",
 CellID->2088348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Raster", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", "100", "]"}], "/", "100"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Blend", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "Red"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "Green"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"2", "/", "3"}], ",", "Yellow"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "3"}], ",", "Blue"}], "}"}]}], "}"}], ",", 
          "#"}], "]"}], "&"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", ".3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->483361309],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3PFHnVEcx/F331NiIiPZSJrISMySTWQky6WZyEhM1xU3ya67JjJGRmIi
49qMxERGYkpMZCRmiYmMxFxiIiMxEWff5/l1+g8+j/dznnO+zo+vn59H2Yn8
yHh2YjSXbeotZgv50dzzpofPij4KFcCav/du4Pvou/Rdi9G//6+Vvtpfqgl/
qP1NvYf9otF+0kL4Qds3OjzsK132hR7CZ/o+MeBhHxkifCD3ljEPe0PRXjNF
eMn0C2Y9bJx5wgjvn7LoYU9YtsesEnrZeMCWh91nh3CHvdsceNgtjuwmx4Tr
nF7j3MOMS0JV1UVNzZmH1dWdWENDmdDcfNjauu9h7e3frbNzm9DdvZnJrHtY
f/8KYXBwaXh4wcPy+ZIVCnOEycmZV+mDzcxMEubmCqVS3sMWFoZtaWmQsLLS
v76e8bDNzW7C9nbn7u5dD9vfb7XDw2ZCudxwclLnYWdnNYSLi6rLiIedR+zU
N+E4cpSGHSTnvchOGrbldzaS2WpkOQ1b9Nm7ZDYfmU3DppPzVKSYho35nVwy
G4oMpGF9ybkn0pWGdfidtmTWEmlMw+qTc22kOg1zHpWSIAmSIAmSIAmSIAmS
IAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmS
IAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmS
IAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmSIAmScIWEq/72T8U/
hqmKJg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418219541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78932307],

Cell["\<\
When colors are specified using the same color space, that space is used for \
interpolation:\
\>", "ExampleText",
 CellID->243596499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Blend", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"RGBColor", "[", 
             RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
            RowBox[{"RGBColor", "[", 
             RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "}"}], ",", "#"}], 
         "]"}], "&"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"DensityPlot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Blend", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Hue", "[", "0", "]"}], ",", 
            RowBox[{"Hue", "[", 
             RowBox[{"2", "/", "3"}], "]"}]}], "}"}], ",", "#"}], "]"}], 
        "&"}], ")"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255062638],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->120267126]
}, Open  ]],

Cell["\<\
When colors are specified using different color spaces, interpolation happens \
in the RGB space:\
\>", "ExampleText",
 CellID->184040730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Hue", "[", 
           RowBox[{"2", "/", "3"}], "]"}]}], "}"}], ",", "#"}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47144886],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXF1kHFEYPTs/2bIVFUJK6BLyEEJLCC0hD2mjNpaWsA8ha1P5oWmTbgl5
CKEl5CGElpCHEFpCS8hDCC0htIQ8hNASWkIeQmgJeRjtzO7OdjpzZzqzzQ97
zzCzc39m9p4z3/ftd3Zmbk82P/TocTY/nMsm741nnw4N554l7z4ZN6vUGIAB
c801wNz/Ze4V1gHDMMwGz/aquVXMDqpVUs0do7DAqtMFbbDK5qo52/TycaUe
oiODzupss6oUQVuhPxLWVvvTUhzJ3zWqp0Z3I/D0qHF/Y0Xf4+2ju87rPUb5
D1zhRq2FHOvl44kbImvyWIPranrPHNYmFAGHl4FILY1FjEQNifF8r00UTisZ
W+V47BhWU/rUfcpxH9bjjlEHnacYgfwiaakZ5fjiil+ZEsxgzFZN2sYeqncZ
mffaOEagh+vhKGsR24P6IzIi3D9F7ATaT8SPkThC7SHqDlD/HQ37aPyKG3to
2kXzDlq20foZN7fQton2j7i9gY51dK6haxXd75FaQfotHiyjdwmZRfQtoP81
cvMYnMPILEZnMPYS+WlMTGFyElMTmH6OF2OYGcXsCOYGMT+AV/1Y6MNiBku9
WH6IN2mspPCuG6tdWOvEegc27uBDOzbbsHULn1qx3YKdZuw2YS+JL43Yv45v
9Tiow2EtjhI4voIfGk5iOFUjMYJUsaa6ORFFRfLzT34ccccZudAjAyd2dC36
0jXJbYH4iZ9+X824affET78v584+mqtQZm4Ifz0NsuNiR/g/ENkpseP+70Qx
5NbpIj5oLTY7VOlU6czWma0SP7N1+j3tnvhl9nuPShc+LyKzZVCJRtMWGhWF
SHG57rbLrM9t/IwsZCVYjYueCpLxV5rZGfFLj59+X8W4affEH5wL+L2TIGNc
4B0d3vE6b35kVqj2mx3Sa7HAdz6k9yKXUlUYWZipVz1uZqrET7+n39PuiZ8K
nQqdCv1i7w3KrstpJ/SjM3i2W2JOmKtXO27mqsRPv6ff0+6J304C7UU0f5+s
Kl3IF/Nnh+2QobNhSC7VHp4T9xO+UWe2u5iZ8cLhccwNKFCdxTkGBXMTxn4D
hVR5Mw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->426123718]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167228468],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->466146252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Lighter", "[", 
    RowBox[{"Blue", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"Blend", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", "White"}], "}"}], ",", 
     RowBox[{"1", "/", "3"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402042092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", "1"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", "1"}], "]"}]}], "}"}]], "Output",
 ImageSize->{273, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16958010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Blue", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "White"}], "}"}], ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46634163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 1], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 1], DiskBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->148901650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138610569],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->2308695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Darker", "[", 
    RowBox[{"Blue", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"Blend", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Black"}], "}"}], ",", 
     RowBox[{"1", "/", "3"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188011437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["2", "3"]}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["2", "3"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{265, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36884390]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Blue", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Black"}], "}"}], ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50450238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0, 0, 
      NCache[
       Rational[2, 3], 0.6666666666666666]], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 
      NCache[
       Rational[2, 3], 0.6666666666666666]], DiskBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1929443]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24347857],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " contains a large number of predefined ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 " colors called ",
 Cell[BoxData["\"\<Gradients\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->888736169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136874389],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"DarkRainbow\"\>", ",", "\<\"Rainbow\"\>", 
    ",", "\<\"Pastel\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "45", "\[RightSkeleton]"}], 
    ",", "\<\"TemperatureMap\"\>", ",", "\<\"BrightBands\"\>", 
    ",", "\<\"DarkBands\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{534, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->203798285]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<TemperatureMap\>\"", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->170273010],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt0d9LU3EcxvHj8/knuku6LI2srCzMfpkJGSgkJGGsUU4sVs7wwiKiXyAk
VBd6UVFgF+3GIKEIoyIkEgRbNUVtDVfD4drO2dmPs3POd3XoT+j6uXh4f/jc
vtp8A4Ez530DvX5fdUu/70Kg1x+qPhzs915SpWma7W39Os27/3jXv0ntsQzq
OrJS35lFQ1dWGruz2O/XpblHR2ufLm1BHe0hQzoHDXQNGXLqqgH/9ZwEbuVw
bjgnF0dMXLpnYmjUlGsP8rj9OC93nhZwP1yQsYkiHr0oyvirEp5NlWTinYXJ
aUtefyrj7WxZpiM2ZqK2zC06+Prdkfm4i6WEK7Gki5WUQjKtJJVR+G1URDcV
jIIjZtFCvlSQgmWiVNbFsjOwnTVx3BRcNyGuisFVC6JUBErNev2IinovFTXl
ddJb2LufeB3zOoKKe1Mq7mWvIVFOH9xSjzjmadjZbimnT8BaPS7Fn+0oxI9K
fvkIzGiLGHPNyM4cQubDQUm/OYC1l/sk9bwJq+G9khxvxK+HeyQxuhsrdxsk
PrwLP27slNiVHVge3C5LwW1YPLtVFk7WYb5ji0RbN+NbU618qa9BpGYTPm/Y
qGlUoQpVqEIVqlCFKlShClWoQhWqUIUqVKEKVahCFapQhSpUoQpVqEIVqlCF
KlShClWoQhWqUIUqVKEKVahCFapQ5f9UtKq/hK+4Mw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27977607]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<SunsetColors\>\"", "]"}], "[", "#", 
       "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->161359088],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpABxsgQDkP0fyALj
lL9//wIlMEgeIMkEVMAM4jEDGX/BgAEkxopFjgHEB2IWZDlWuD6oCmw68ZmK
LAcSYsIiB1bPwA0iWRAyEJegijBjiLCi+wBDBRu6jWTZg6mGFc1cTD1MFPiL
OFezEOnWgfcP+19sqQkjNaDFJqbJxKYJJixhOBA+Yoa6BbtPmIn0I23jhpQw
Jcdt5PsHVoaxQWlWHHx2HKHOjuRqfOZASiBcJSlUmgFevqCVX5FQb+L3M0jE
H+Z3olTDfYYZN0guYCVOBRKfhUR5fOoZSPYRgxcrAzsPs5AIm4w0h5oyt4E2
n7WRoKuVcICTWJSnZEqgTE6kXG6iYm6mSm6RWm6VZm6Tdma3Xspkg4Q5xtFL
TMPWWARutvbdZedx0NH5hIvdOXerS96m1/wNbwXr3AvXeBSt/Cxe/mWy1Nt0
sY/Zgl/zeb8Xc/+o4P1Rw/+zUeBnm9CvLuFf/aK/poj/ninxe67Un0XSf5Yp
/Fmt+me99p/NBn92mP3dY/P3gPPfI95/TwT9PRP190Li3yuZf68X/b1d9fde
099H3X+fTP37fP7flyv/vtny992+vx9P/v18+e/Xu39/vPj76xMzSSHC4AMR
Gd5hgq1UJCN8BEdY+CCVO8glF4PvsA6Te5AwgZWukLwkMPzTwj18aWHU/6P+
H833w9nfo+l+1P+j+R7edsbR5wLzR0bbEG+6wD8KNho6yKGDdRxoNHSgoYM+
dsL0F6WfPmzDBlc/HVt4jKYWWOiMyF46/vAZ7aWPttZHW6uj/h/BrfXReB/1
/4j3/wjM9xi9dKzrRUZyyhjtiZLWt2AZ7VFg63GhzbaP5P45zP+jJctoqODv
jWNbFTQSa+nR1tmo/0e8/0fz/TD292i6H/U//rYArj0JI7FcGJ3RGZ3xonX4
jOQeKmxnx4jvi+Hd8zHicxFaT5VptGQZbakPe3+PtlRH/T+a70fz/Wi6H/X/
aA99tIc+2kOn79zgSO+Xj6aT0XxEhbXdIzhMRtvqw93fo23VUf+P5vvRfD+a
7kf9D2sEwgC28/tGai8da3iNtPYz3hOMyAihEXYGFnEhNLLOTSM+TNBX+JJ6
sh19TsYjzj9IZwNi6XVCzhjEcjYhIwCxv9R+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->72991530]
}, Open  ]],

Cell["Gradients can be called by their names only:", "ExampleText",
 CellID->21074454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SunsetColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->390998196],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpABxsgQDkP0fyALj
lL9//wIlMEgeIMkEVMAM4jEDGX/BgAEkxopFjgHEB2IWZDlWuD6oCmw68ZmK
LAcSYsIiB1bPwA0iWRAyEJegijBjiLCi+wBDBRu6jWTZg6mGFc1cTD1MFPiL
OFezEOnWgfcP+19sqQkjNaDFJqbJxKYJJixhOBA+Yoa6BbtPmIn0I23jhpQw
Jcdt5PsHVoaxQWlWHHx2HKHOjuRqfOZASiBcJSlUmgFevqCVX5FQb+L3M0jE
H+Z3olTDfYYZN0guYCVOBRKfhUR5fOoZSPYRgxcrAzsPs5AIm4w0h5oyt4E2
n7WRoKuVcICTWJSnZEqgTE6kXG6iYm6mSm6RWm6VZm6Tdma3Xspkg4Q5xtFL
TMPWWARutvbdZedx0NH5hIvdOXerS96m1/wNbwXr3AvXeBSt/Cxe/mWy1Nt0
sY/Zgl/zeb8Xc/+o4P1Rw/+zUeBnm9CvLuFf/aK/poj/ninxe67Un0XSf5Yp
/Fmt+me99p/NBn92mP3dY/P3gPPfI95/TwT9PRP190Li3yuZf68X/b1d9fde
099H3X+fTP37fP7flyv/vtny992+vx9P/v18+e/Xu39/vPj76xMzSSHC4AMR
Gd5hgq1UJCN8BEdY+CCVO8glF4PvsA6Te5AwgZWukLwkMPzTwj18aWHU/6P+
H833w9nfo+l+1P+j+R7edsbR5wLzR0bbEG+6wD8KNho6yKGDdRxoNHSgoYM+
dsL0F6WfPmzDBlc/HVt4jKYWWOiMyF46/vAZ7aWPttZHW6uj/h/BrfXReB/1
/4j3/wjM9xi9dKzrRUZyyhjtiZLWt2AZ7VFg63GhzbaP5P45zP+jJctoqODv
jWNbFTQSa+nR1tmo/0e8/0fz/TD292i6H/U//rYArj0JI7FcGJ3RGZ3xonX4
jOQeKmxnx4jvi+Hd8zHicxFaT5VptGQZbakPe3+PtlRH/T+a70fz/Wi6H/X/
aA99tIc+2kOn79zgSO+Xj6aT0XxEhbXdIzhMRtvqw93fo23VUf+P5vvRfD+a
7kf9D2sEwgC28/tGai8da3iNtPYz3hOMyAihEXYGFnEhNLLOTSM+TNBX+JJ6
sh19TsYjzj9IZwNi6XVCzhjEcjYhIwCxv9R+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->44206946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556891892],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " supports equal weight blending of ",
 Cell[BoxData[
  ButtonBox["VertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexColors"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->430750263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Red", ",", "Green"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->708314074],

Cell[BoxData[
 GraphicsBox[PolygonBox[{{0, 0}, {1, 0}, {0, 1}},
   VertexColors->{
     RGBColor[0, 0, 1], 
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0]}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->436096022,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"1", "-", "x"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"1", "-", "x", "-", "y"}]}], "}"}]}], "]"}]}], "]"}]}], ",",
    
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73983916],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzdmE1MXFUUx0cTNzXRhR8xbBqTduHKpGHRRuUR7UI3NVEX6kISi0ZNhKRp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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxFmQn4l1MWx98bg6KQIjQorVqRNC0SkkTxpxTtRSEtShFRyVqStEklW6mE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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJztmU9s3EcVxxdQewgSRCJBKJcKqT1wIqpycKHkWZAD5VAq4ND2QCpqqlAp
CSqRQJWKV8GSUzfIW9fUIS21m5oGQoTDYjlWiOqtU2I128qOk6xx1lV/qf8k
UdLgSy+c8M58v295bzXsrrgSRVrt/GbfzHzm+77z5ucv/2j/93786Vwud/JT
udxncql/6zJw70Mb/4vCln3Vib3ViY/RPq3tS7XmvbckPN5b1vaHQseb6D+v
7adr3aprErpXK9p+X/jBCuJUtT3+/iN8z7Sd3+1zzqcq9yIe2ycx3gTGZ/sg
5sf52jhlzOeW6z8te8GD7UcMr3U3z/o/crU8iyI7Kr3n/3VK1racffXg0C3l
vLDROvfomPzw4bfLX/nFTeX81ePZ6pazJ6USnl9XzodqX+85IaH7A6vK+dpq
LfBxmak93rasnB+4qxZpFONnyjnGO4Z5fqCc43yGMZ9F5fx8GPeoPBLGvaKc
vx7iD0pniD+nnGOcfnkixHlXOcf+PehfUs6dof0A2k+1yHlaqE/LuaQ8Lecp
yQKn647zWel6bs/Jz/961XE+g/1adpxPy082en/y+jXHeRz79aHjXBTq1nIe
k49CvAXH+QTGveQ4j8o/wu9mHedhrGvGcR5E/ynHuUcyjN+MMznZfC+C77tO
n9PgMyNPgid/H7//Xdaf2bTx02XlHNd5Tn5Ze/zJNeUc+b4tnw0DZcq5gvVs
D/u2pJzj87/Jd0LgReXM/Yr7e0U5Xw/j/hXjXlTOi+AS47+n62Z+dWEd5LwI
/tuhI3LOoP9O5HFrep4X+qfV85zmu9XzrOrT6vk95Wn1fEG21rp/P3N6npHH
79l261tPfuD0/A5+d9XpeVrot1bPU6pbq+cz8sUw7pzT87gcxrysnsfkBnRh
9TyqeWn1PCgF5E0zzqcxb86PnL8LXzsP/+Q6uZ49Jt/L8hx0Q32S81as81Hw
JOfHwvf35bWNp+vPXFXOvVg/fYCc4zzPY56XlTPzJc7noq4j8i1h3PeVcx94
rWCfyXkN+t+DPCPnPnDMkDfkXID/Z8iD1nyj7nfWNxb1PLK+saD+aX3jiua7
9Y1Lqk/rGxcxzwXnG7PytaCXy843yhrX+saM+q31jXOaT9Y3puRB5I31jdPq
w9Y3xqQDeWB9Yxi6Hm3Kmeuw+VnUc92e79N6DvHT+vui80/6UUVsfVWR+6BL
6tPu97yw7rLzm9NPcmYdxk9ynoT++UnOrM/4Sc5L8P8Mn+Q8CB4FfJLzEdQ/
I/hsxtnOt+r8OVNdW3/+0OmQ/ryk55H156vu3K9oXjDfrT9fVn3a/Z9Xntaf
Z7VOsP58Qf3W+vM7qlvrz1PqD9afx7WusP48qrpuxpn3BK6fnFnXPgyfJmfW
YSvgRs6b4Ms838nlMfjyFnMeVeR38GX6Jzlz/5jv5Ez9U5/kTP8hT3J+HHG/
BJ8m52XsB881cmb9cwM+Tc7L4M7zjpxvwJfz8OlmnG2dMe/OwVXZibrDnoPL
qjd7Dl7Tesmeg5nzyYryt/Uqz8Gr6p/kTP8pYB72HLyk+rTn4JzytOfgBehx
3J2D51S39hw8o/q15+AJrTuacbb+VFbOrJt5PyJn3kMsn7LWzaw/yZl13orJ
34rWJfZ8r6r/kBs50//pn+RMn2K+kzPzivok5/uhA/Lk+jlv1g/kfD/qZvoD
OXewbj4U6+hmnK3fT7t646beN229cV3mzLlc1nsL63lbbyw7XVXUf6wfVrWO
od7Imc95Htl6Y0G52XrjEvL6hKs3ZlWftt6YUZ623phS3dp6Y0zvhc04872G
nX9R32vw/k7Ou8G/ZPKrrPrfjn0mZ95zCma9FfV/q58qfCpz9VKmdU8B5zs5
78Y5XQIfcmb9T/8kZ77XIDdy3o28LeGeR87UGXmS8y6+18B7jmac/XNb133s
2uvvQWw+lBvee9m6rv6ezNZ1Ky5OvY6388tcfddYJ7Hd1nUVN+6aqxcbfdPO
p57nbLd1XdHNs5FzHPeOtrMOZHvcvy55JOzbiGs/AF8a1vaYR92477/q+vfI
iNHVHei7T3IxcVycftUb2+O6BlCvDrj4g+qTbI/1wJCUMI4d96jkMS+2d2De
MU63m88w+h/Q9l3gkrs7choAP0H7z0IB5nV6DLq783/O/yNn68PHlDP5Wt9r
fO73w+7TAPaxgPsy+w9o/zy+p/Ir5uk/XX417x85/wA+Wmixf1fTOoH9I+f9
0M/hFuMfwLnQ17R/3PdnobfeFufT3fT8Zf+oz4NSwmdr8+9RvTXrH/Xci/U+
2+J6+1S3zfp3kPuhuA+t8elX/af62/yt6z3l8/9dn/U8YL+UPlM6TOktpauU
flI6Sekhte+p/U3tY2q/UvvC9l3M27sjJ3JccrwHHO/2OLfOv919aXe/2t3H
dve33X1vVw/t6qRd/bSrq3b11qoOqTPqMO/y2/ePj2+rfibDRcP/3aFLfhru
f3+Bzus+E+/Rf9I4O8G5I1wnJt39qxvvhU5pHOowvh/4o8Z5GfOOdfSEey/R
J4Xaa6xNf3ZxuvXexDiHUZ/wfmrr5wHh/BmH+/5EuB//XuN8E/VJqTb99aJ7
HzUknWG9f3Dz6ZcsPH5D43wD9zfeHxmH9VJhA/LOHW9qnNvh9y+B/+sapwPj
5cHB3r9GZB3j2nUNaf3FODtwL/Xv2W7j952Ixzgrgdcr4PaKxuG+cv6MM4jv
rGMtH/49d8jte1HrOsZ5EOtlf8bZBy4ZODHOF2pq3Tmu4zLOCvab56Dl/Ibe
cxnnxTD/iYb3CYfBnX7IOE9DNyXoiHE+F17QTGp/xtkGbvQlu1/Htd3q+Yze
rxlnH/Izd9d/1s935CnkFX2G7cxr7nsqH1P3F/anz28O6/P6r+dj6r5j59PT
oH+fj6n7EfvTVzeH/R9N5mPqPsX+9Ad7v2jMx9T9i/2j/l+WzWGfR5L5mLqv
Wc5HG9br8zF1v2P/qNvX4FdHkvmYug+yP33Gz9PnY+r+yP7TwU+PaZ2TysfU
fdPqZ7RpPqbup+z/Vnj+Js7Ng8l8TN1n2Z9+lXPtPh9T999vhx/w3N8t+fC7
37r2/ao3tsd5/lzyYd2/cf037kVb476wPXL+leTDvr3o4vTqvrM96u0FiRfs
F1z8fq332L4PcTu3xnHsuC9JHjzZ/jTmnV+L67DzGZLc87Ze8vUM+z8FXrm+
yO/f0vepFQ==
    "]],
  AspectRatio->1,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{0, 1}, {0, 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->174619689,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->744417825],

Cell["Values outside of the 0, 1 range will be clipped:", "ExampleText",
 CellID->318150803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green"}], "}"}], ",", "i"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"4", "i"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"0", "-", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453071729],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl8ENwjAMRX9pV0jEMaP0BCeGiCqk9oBApQN4II69dzRjtypEYgR+5Pz4
RUr0rr7kqb/e8jR0OZ3H/OiH7plO99Gu6grAbDsdYb1at+5Z1c4yG8uXiDQf
Qm2o24PgUXDceWlhheDhLAIrRA/ndoEVgocztg+iR8FhZ10XDrSgBS1oQQta
0IIWtKAFLf7a4jud/E4vqN6fX3r5\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137184918]
}, Open  ]],

Cell[TextData[{
 "In plot functions, use ",
 Cell[BoxData[
  ButtonBox["ColorFunctionScaling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
 " to control global scaling of variables:"
}], "ExampleText",
 CellID->247658414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Blend", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Red", ",", "Green"}], "}"}], ",", "#"}], "]"}], "&"}], 
       ")"}]}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->288136242],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3HmITVEAx/HfmzfzppmxRPaxzWSJyBJZIksYZEKILM08b4axZRojskeW
yBJZIktElsgSWSJLZInIEtnHEtmzRLyec+575o+LP0iM1/fUPeedpXvOvZ/O
fafb6ab783OyR/nzhwX81dPy/Lk5wwJjqncanWeKvB5JBeYYUkHmd8j8co6C
UMik8SbOCgaDSSbNNml8YWnANJLXFIWcoATb0lUWV9haXlMTdIIybBTJ26pE
V32mq973/VlMkmKj5E8evfPpVZKeltLDcrqbrBspulBPR1tqT5o29tGKwZqb
q8mTlTtXg1eoz0al7VHLo6p3QSk3lHxX5R6q1FMlvZLvnTyfpFQFw9cQ7kr2
yuUPZ75IpsMPsbbPNwl6WUzPS9ieH5exnd+vqDuVdauqHcK1GrpSS5fq2LGc
a6AzjXSqiU4007EWOtJKh9roQDvt62DHuKuLdnTTtu7a0lObemtDX63rrzUD
tSrDjn1ZlpYM1aLhWjBS80ZrTp5m5WvGOE2boCmTNHGqxk/X2JkaM9te36j5
GrFQOYuVvVSB5cpcqUGrNWCt+q23191rs3psVfp2dd2pzrvVca/a71fbg2p9
2N6P5sfV9KQan1bDs6p/XnUvqvZl1byq1OuqdlNVbqvSPZV/oLKPVPqJSj5T
8RdKfK34t4p7r5iP0mcpBjfccMMNN9xwww033HDDDTfccMMNN9xwww033HDD
DTfccMMNN9xwww033HDDDTfccMMNN9xwww033HDDDTfccMMNN9xwww033HDD
DTfccPtFt1gTx5hCeZ2sc09TsSuKdrGR2+aE8Dc1HDSfyYa+hXAbBIukYFzh
7AtLObMPRRRRRBHF6FGM+bYajnTuQzVKVO1aOR7NKND0uuZoHKp/QNX95CvM
/+X3At7IXOXJ+7vvB9ySnrBz5D2BjWP/kS1rpN81tXj2Q5/W0lOk5iumf3ae
/ut/VzyjYY2EIooooogiiiiiiCKKKEajIvtA/hvBH+wDYffVfyHHrjnccMMN
N9xwww033HDDDTfccMMNN9xwww033HDDDTfccMMNN9xwww033HDDDTfccMMN
N9xwww033HDDDTfccMMNN9xwww033HDDDbei4GYaZLhaJbrqM396loApdGRC
TlCCibJcZeFvARQ4sTxfARRsSS4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->179780340]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27743],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 " with plots to generate synthesized textures:"
}], "ExampleText",
 CellID->422619592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"RandomReal", "[", 
           RowBox[{"5", ",", "2"}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", "10", "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10", ",", ".05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "10", ",", ".05"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Black", ",", "Red", ",", "Yellow", ",", "Black"}], "}"}], 
        ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71558092],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345512024]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReliefPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"RandomReal", "[", 
           RowBox[{"5", ",", "2"}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", "10", "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10", ",", ".05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "10", ",", ".05"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Darker", "[", 
           RowBox[{"Green", ",", ".8"}], "]"}], ",", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Brown", ",", ".2"}], "]"}], ",", "White"}], "}"}], ",", 
        "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192845890],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204746430]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4051453],

Cell["Simulated colors of stars:", "ExampleText",
 CellID->569399849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "100"}], "]"}], ",", 
       RowBox[{"Blend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Red", ",", "Orange", ",", 
           RowBox[{"Lighter", "[", 
            RowBox[{"Gray", ",", 
             RowBox[{"1", "/", "3"}]}], "]"}], ",", 
           RowBox[{"Lighter", "[", 
            RowBox[{"Blue", ",", 
             RowBox[{"2", "/", "3"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"i", "/", "15"}]}], "]"}], ",", 
       RowBox[{"Sphere", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", "Pi", " ", 
              RowBox[{"i", "/", "15"}]}], "]"}]}], ",", 
           RowBox[{"i", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", "Pi", " ", 
              RowBox[{"i", "/", "15"}]}], "]"}]}], ",", "i"}], "}"}], ",", 
         RowBox[{"i", "/", "6"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", "Top"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", ".15", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46726962],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0.1, 0], Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{Sin[Rational[2, 15] Pi], Cos[Rational[2, 15] Pi], 1}, {
      0.40673664307580015`, 0.9135454576426009, 1}], NCache[
     Rational[1, 6], 0.16666666666666666`]]}, 
   {RGBColor[1, 0.2, 0], Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{2 Cos[Rational[7, 30] Pi], 2 Sin[Rational[7, 30] Pi], 2}, {
      1.4862896509547885`, 1.3382612127177165`, 2}], NCache[
     Rational[1, 3], 0.3333333333333333]]}, 
   {RGBColor[1, 0.30000000000000004`, 0], Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[3, 4] (-1 + 5^Rational[1, 2]), 3}, {
      2.8531695488854605`, 0.9270509831248424, 3}], NCache[
     Rational[1, 2], 0.5]]}, 
   {RGBColor[1, 0.4, 0], Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{4 Cos[Rational[1, 30] Pi], (-4) Sin[Rational[1, 30] Pi], 4}, {
      3.978087581473093, -0.41811385307061383`, 4}], NCache[
     Rational[2, 3], 0.6666666666666666]]}, 
   {RGBColor[1, 0.5, 0], Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{Rational[5, 2] 3^Rational[1, 2], Rational[-5, 2], 5}, {
      4.330127018922193, -2.5, 5}], NCache[
     Rational[5, 6], 0.8333333333333334]]}, 
   {RGBColor[0.9333333333333333, 0.5333333333333333, 0.13333333333333333`], 
    Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{6 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[3, 2] (-1 - 5^Rational[1, 2]), 6}, {
      3.526711513754839, -4.854101966249685, 6}], 1]}, 
   {RGBColor[0.8666666666666667, 0.5666666666666667, 0.26666666666666666`], 
    Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{7 Sin[Rational[1, 15] Pi], (-7) Cos[Rational[1, 15] Pi], 7}, {
      1.4553818357243151`, -6.84703320513664, 7}], NCache[
     Rational[7, 6], 1.1666666666666667`]]}, 
   {RGBColor[0.7999999999999999, 0.6, 0.4], Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{(-8) Sin[Rational[1, 15] Pi], (-8) Cos[Rational[1, 15] Pi], 
       8}, {-1.6632935265420745`, -7.8251808058704455`, 8}], NCache[
     Rational[4, 3], 1.3333333333333333`]]}, 
   {RGBColor[0.7333333333333333, 0.6333333333333333, 0.5333333333333333], 
    Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{(-9) (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[9, 4] (-1 - 5^Rational[1, 2]), 
       9}, {-5.2900672706322585`, -7.281152949374527, 9}], NCache[
     Rational[3, 2], 1.5]]}, 
   {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
    Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{(-5) 3^Rational[1, 2], -5, 10}, {-8.660254037844386, -5, 10}], 
     NCache[Rational[5, 3], 1.6666666666666667`]]}, 
   {RGBColor[0.6666666666666666, 0.6666666666666666, 0.7333333333333333], 
    Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{(-11) Cos[Rational[1, 30] Pi], (-11) Sin[Rational[1, 30] Pi], 
       11}, {-10.939740849051006`, -1.1498130959441881`, 11}], NCache[
     Rational[11, 6], 1.8333333333333333`]]}, 
   {RGBColor[0.6666666666666666, 0.6666666666666666, 0.8], Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{(-12) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 3 (-1 + 5^Rational[1, 2]), 12}, {-11.412678195541842`,
        3.7082039324993694`, 12}], 2]}, 
   {RGBColor[0.6666666666666666, 0.6666666666666666, 0.8666666666666667], 
    Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{(-13) Cos[Rational[7, 30] Pi], 13 Sin[Rational[7, 30] Pi], 
       13}, {-9.660882731206126, 8.698697882665158, 13}], NCache[
     Rational[13, 6], 2.1666666666666665`]]}, 
   {RGBColor[0.6666666666666666, 0.6666666666666666, 0.9333333333333333], 
    Specularity[
     GrayLevel[1], 100], 
    SphereBox[
     NCache[{(-14) Sin[Rational[2, 15] Pi], 14 Cos[Rational[2, 15] Pi], 
       14}, {-5.694313003061202, 12.789636406996411`, 14}], NCache[
     Rational[7, 3], 2.3333333333333335`]]}, 
   {RGBColor[
     NCache[
      Rational[2, 3], 0.6666666666666666], 
     NCache[
      Rational[2, 3], 0.6666666666666666], 1], Specularity[
     GrayLevel[1], 100], 
    SphereBox[{0, 15, 15}, NCache[Rational[5, 2], 2.5]]}},
  Background->GrayLevel[0.15],
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->Top]], "Output",
 ImageSize->{155, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368444669,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12543],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opacity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4306]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Blend",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Blend"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->28649687],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->15380132],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->507959667],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->65840016],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->696218153],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->974299132],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->62094180],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->398452302]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Blend - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 21.5991348}", "context" -> "System`", 
    "keywords" -> {
     "color interpolation", "color blends", "mixing colors", 
      "color gradients", "lighter", "darker"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Blend[{col_1, col_2}, x] gives a color obtained by blending a fraction 1 \
- x of color col_1 and x of color col_2. Blend[{col_1, col_2, col_3, ...}, x] \
linearly interpolates between colors col_i as x varies from 0 to 1. \
Blend[{{x_1, col_1}, {x_2, col_2}, ...}, x] interpolates to give col_i when x \
= x_i. Blend[{col_1, col_2, ...}, {u_1, u_2, ...}] blends all the col_i, \
using fraction u_i of color col_i. Blend[{col_1, col_2, ...}] blends equal \
fractions of all the col_i.", "synonyms" -> {}, "title" -> "Blend", "type" -> 
    "Symbol", "uri" -> "ref/Blend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12306, 376, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160993291]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 443411, 8623}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3082, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3705, 88, 1570, 37, 70, "ObjectNameGrid"],
Cell[5278, 127, 5256, 176, 70, "Usage",
 CellID->18296]
}, Open  ]],
Cell[CellGroupData[{
Cell[10571, 308, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11049, 325, 942, 36, 70, "Notes",
 CellID->10782],
Cell[11994, 363, 275, 8, 70, "Notes",
 CellID->24729]
}, Closed]],
Cell[CellGroupData[{
Cell[12306, 376, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160993291],
Cell[CellGroupData[{
Cell[12691, 390, 147, 5, 70, "ExampleSection",
 CellID->17480994],
Cell[12841, 397, 73, 1, 70, "ExampleText",
 CellID->128950338],
Cell[CellGroupData[{
Cell[12939, 402, 202, 7, 28, "Input",
 CellID->172799001],
Cell[13144, 411, 270, 9, 51, "Output",
 CellID->102791748]
}, Open  ]],
Cell[13429, 423, 125, 3, 70, "ExampleDelimiter",
 CellID->820029580],
Cell[13557, 428, 107, 3, 70, "ExampleText",
 CellID->6635],
Cell[CellGroupData[{
Cell[13689, 435, 550, 18, 70, "Input",
 CellID->22881],
Cell[14242, 455, 1135, 44, 63, "Output",
 CellID->347773838]
}, Open  ]],
Cell[15392, 502, 121, 3, 70, "ExampleDelimiter",
 CellID->13577],
Cell[15516, 507, 94, 1, 70, "ExampleText",
 CellID->17173],
Cell[CellGroupData[{
Cell[15635, 512, 606, 21, 47, "Input",
 CellID->23017],
Cell[16244, 535, 29224, 483, 159, "Output",
 Evaluatable->False,
 CellID->197447223]
}, Open  ]],
Cell[45483, 1021, 125, 3, 70, "ExampleDelimiter",
 CellID->158240582],
Cell[45611, 1026, 71, 1, 70, "ExampleText",
 CellID->95155050],
Cell[CellGroupData[{
Cell[45707, 1031, 273, 9, 70, "Input",
 CellID->611480004],
Cell[45983, 1042, 299, 10, 121, "Output",
 CellID->59126898]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46331, 1058, 220, 7, 70, "ExampleSection",
 CellID->187516040],
Cell[46554, 1067, 82, 1, 70, "ExampleText",
 CellID->325173071],
Cell[CellGroupData[{
Cell[46661, 1072, 203, 7, 70, "Input",
 CellID->137582791],
Cell[46867, 1081, 270, 9, 51, "Output",
 CellID->481166600]
}, Open  ]],
Cell[CellGroupData[{
Cell[47174, 1095, 555, 18, 70, "Input",
 CellID->261138928],
Cell[47732, 1115, 1115, 43, 63, "Output",
 CellID->471409438]
}, Open  ]],
Cell[48862, 1161, 125, 3, 70, "ExampleDelimiter",
 CellID->609915099],
Cell[48990, 1166, 102, 2, 70, "ExampleText",
 CellID->75834295],
Cell[CellGroupData[{
Cell[49117, 1172, 367, 11, 70, "Input",
 CellID->509266624],
Cell[49487, 1185, 302, 10, 51, "Output",
 CellID->458035993]
}, Open  ]],
Cell[CellGroupData[{
Cell[49826, 1200, 747, 23, 70, "Input",
 CellID->52272376],
Cell[50576, 1225, 1506, 57, 63, "Output",
 CellID->540082150]
}, Open  ]],
Cell[52097, 1285, 125, 3, 70, "ExampleDelimiter",
 CellID->131711636],
Cell[52225, 1290, 97, 1, 70, "ExampleText",
 CellID->55785783],
Cell[CellGroupData[{
Cell[52347, 1295, 578, 19, 70, "Input",
 CellID->184493667],
Cell[52928, 1316, 787, 27, 63, "Output",
 CellID->431714262]
}, Open  ]],
Cell[53730, 1346, 125, 3, 70, "ExampleDelimiter",
 CellID->230501118],
Cell[53858, 1351, 98, 1, 70, "ExampleText",
 CellID->198354028],
Cell[CellGroupData[{
Cell[53981, 1356, 705, 23, 70, "Input",
 CellID->25684592],
Cell[54689, 1381, 959, 30, 60, "Output",
 CellID->317835398]
}, Open  ]],
Cell[55663, 1414, 125, 3, 70, "ExampleDelimiter",
 CellID->198770333],
Cell[55791, 1419, 78, 1, 70, "ExampleText",
 CellID->120244352],
Cell[CellGroupData[{
Cell[55894, 1424, 377, 11, 70, "Input",
 CellID->363983036],
Cell[56274, 1437, 292, 10, 51, "Output",
 CellID->490586267]
}, Open  ]],
Cell[56581, 1450, 82, 1, 70, "ExampleText",
 CellID->707436826],
Cell[CellGroupData[{
Cell[56688, 1455, 545, 17, 70, "Input",
 CellID->163460510],
Cell[57236, 1474, 292, 10, 51, "Output",
 CellID->311003930]
}, Open  ]],
Cell[CellGroupData[{
Cell[57565, 1489, 706, 22, 70, "Input",
 CellID->133794],
Cell[58274, 1513, 57092, 950, 200, 10708, 185, "CachedBoxData", "BoxData", \
"Output",
 CellID->202617928]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[115415, 2469, 243, 7, 70, "ExampleSection",
 CellID->109836838],
Cell[115661, 2478, 132, 4, 70, "ExampleText",
 CellID->203857916],
Cell[CellGroupData[{
Cell[115818, 2486, 927, 28, 70, "Input",
 CellID->212444258],
Cell[116748, 2516, 927, 19, 70, "Output",
 Evaluatable->False,
 CellID->203030866]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[117724, 2541, 227, 7, 70, "ExampleSection",
 CellID->590578476],
Cell[117954, 2550, 235, 8, 70, "ExampleText",
 CellID->218910725],
Cell[CellGroupData[{
Cell[118214, 2562, 580, 19, 70, "Input",
 CellID->160441923],
Cell[118797, 2583, 3900, 68, 70, "Output",
 Evaluatable->False,
 CellID->45314481]
}, Open  ]],
Cell[CellGroupData[{
Cell[122734, 2656, 1146, 36, 70, "Input",
 CellID->640626787],
Cell[123883, 2694, 20241, 336, 70, "Output",
 Evaluatable->False,
 CellID->133919398]
}, Open  ]],
Cell[CellGroupData[{
Cell[144161, 3035, 1022, 32, 70, "Input",
 CellID->48479714],
Cell[145186, 3069, 26059, 431, 70, "Output",
 Evaluatable->False,
 CellID->27225802]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[171294, 3506, 237, 7, 70, "ExampleSection",
 CellID->146789925],
Cell[171534, 3515, 114, 3, 70, "ExampleText",
 CellID->337171823],
Cell[CellGroupData[{
Cell[171673, 3522, 251, 8, 70, "Input",
 CellID->642276887],
Cell[171927, 3532, 292, 10, 51, "Output",
 CellID->112251659]
}, Open  ]],
Cell[172234, 3545, 123, 3, 70, "ExampleDelimiter",
 CellID->2070450],
Cell[172360, 3550, 79, 1, 70, "ExampleText",
 CellID->2088348],
Cell[CellGroupData[{
Cell[172464, 3555, 929, 28, 70, "Input",
 CellID->483361309],
Cell[173396, 3585, 1013, 21, 70, "Output",
 Evaluatable->False,
 CellID->418219541]
}, Open  ]],
Cell[174424, 3609, 124, 3, 70, "ExampleDelimiter",
 CellID->78932307],
Cell[174551, 3614, 144, 4, 70, "ExampleText",
 CellID->243596499],
Cell[CellGroupData[{
Cell[174720, 3622, 1296, 39, 70, "Input",
 CellID->255062638],
Cell[176019, 3663, 2339, 43, 70, "Output",
 Evaluatable->False,
 CellID->120267126]
}, Open  ]],
Cell[178373, 3709, 148, 4, 70, "ExampleText",
 CellID->184040730],
Cell[CellGroupData[{
Cell[178546, 3717, 556, 18, 70, "Input",
 CellID->47144886],
Cell[179105, 3737, 1370, 27, 70, "Output",
 Evaluatable->False,
 CellID->426123718]
}, Open  ]],
Cell[180490, 3767, 125, 3, 70, "ExampleDelimiter",
 CellID->167228468],
Cell[180618, 3772, 317, 12, 70, "ExampleText",
 CellID->466146252],
Cell[CellGroupData[{
Cell[180960, 3788, 348, 12, 70, "Input",
 CellID->402042092],
Cell[181311, 3802, 441, 15, 51, "Output",
 CellID->16958010]
}, Open  ]],
Cell[CellGroupData[{
Cell[181789, 3822, 605, 20, 70, "Input",
 CellID->46634163],
Cell[182397, 3844, 594, 21, 123, "Output",
 CellID->148901650]
}, Open  ]],
Cell[183006, 3868, 125, 3, 70, "ExampleDelimiter",
 CellID->138610569],
Cell[183134, 3873, 313, 12, 70, "ExampleText",
 CellID->2308695],
Cell[CellGroupData[{
Cell[183472, 3889, 347, 12, 70, "Input",
 CellID->188011437],
Cell[183822, 3903, 393, 13, 51, "Output",
 CellID->36884390]
}, Open  ]],
Cell[CellGroupData[{
Cell[184252, 3921, 604, 20, 70, "Input",
 CellID->50450238],
Cell[184859, 3943, 480, 17, 123, "Output",
 CellID->1929443]
}, Open  ]],
Cell[185354, 3963, 124, 3, 70, "ExampleDelimiter",
 CellID->24347857],
Cell[185481, 3968, 411, 14, 70, "ExampleText",
 CellID->888736169],
Cell[CellGroupData[{
Cell[185917, 3986, 152, 5, 70, "Input",
 CellID->136874389],
Cell[186072, 3993, 452, 13, 36, "Output",
 CellID->203798285]
}, Open  ]],
Cell[CellGroupData[{
Cell[186561, 4011, 161, 4, 70, "Input",
 CellID->170273010],
Cell[186725, 4017, 926, 19, 70, "Output",
 Evaluatable->False,
 CellID->27977607]
}, Open  ]],
Cell[CellGroupData[{
Cell[187688, 4041, 456, 14, 70, "Input",
 CellID->161359088],
Cell[188147, 4057, 1458, 28, 70, "Output",
 Evaluatable->False,
 CellID->72991530]
}, Open  ]],
Cell[189620, 4088, 86, 1, 70, "ExampleText",
 CellID->21074454],
Cell[CellGroupData[{
Cell[189731, 4093, 332, 10, 70, "Input",
 CellID->390998196],
Cell[190066, 4105, 1458, 28, 70, "Output",
 Evaluatable->False,
 CellID->44206946]
}, Open  ]],
Cell[191539, 4136, 125, 3, 70, "ExampleDelimiter",
 CellID->556891892],
Cell[191667, 4141, 343, 12, 70, "ExampleText",
 CellID->430750263],
Cell[CellGroupData[{
Cell[192035, 4157, 505, 17, 70, "Input",
 CellID->708314074],
Cell[192543, 4176, 18237, 306, 121, 170, 5, "CachedBoxData", "BoxData", \
"Output",
 CellID->436096022]
}, Open  ]],
Cell[CellGroupData[{
Cell[210817, 4487, 757, 23, 70, "Input",
 CellID->73983916],
Cell[211577, 4512, 28792, 485, 121, 10693, 184, "CachedBoxData", "BoxData", \
"Output",
 CellID->174619689]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[240418, 5003, 230, 7, 70, "ExampleSection",
 CellID->744417825],
Cell[240651, 5012, 92, 1, 70, "ExampleText",
 CellID->318150803],
Cell[CellGroupData[{
Cell[240768, 5017, 722, 23, 70, "Input",
 CellID->453071729],
Cell[241493, 5042, 423, 11, 70, "Output",
 Evaluatable->False,
 CellID->137184918]
}, Open  ]],
Cell[241931, 5056, 269, 8, 70, "ExampleText",
 CellID->247658414],
Cell[CellGroupData[{
Cell[242225, 5068, 820, 25, 70, "Input",
 CellID->288136242],
Cell[243048, 5095, 1452, 28, 70, "Output",
 Evaluatable->False,
 CellID->179780340]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[244549, 5129, 224, 7, 70, "ExampleSection",
 CellID->27743],
Cell[244776, 5138, 225, 8, 70, "ExampleText",
 CellID->422619592],
Cell[CellGroupData[{
Cell[245026, 5150, 938, 28, 70, "Input",
 CellID->71558092],
Cell[245967, 5180, 61416, 1011, 70, "Output",
 Evaluatable->False,
 CellID->345512024]
}, Open  ]],
Cell[CellGroupData[{
Cell[307420, 6196, 1076, 32, 70, "Input",
 CellID->192845890],
Cell[308499, 6230, 104836, 1723, 70, "Output",
 Evaluatable->False,
 CellID->204746430]
}, Open  ]],
Cell[413350, 7956, 123, 3, 70, "ExampleDelimiter",
 CellID->4051453],
Cell[413476, 7961, 69, 1, 70, "ExampleText",
 CellID->569399849],
Cell[CellGroupData[{
Cell[413570, 7966, 1494, 41, 70, "Input",
 CellID->46726962],
Cell[415067, 8009, 21808, 392, 237, 4525, 104, "CachedBoxData", "BoxData", \
"Output",
 CellID->368444669]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[436936, 8408, 311, 9, 70, "SeeAlsoSection",
 CellID->12543],
Cell[437250, 8419, 2422, 89, 70, "SeeAlso",
 CellID->4306]
}, Open  ]],
Cell[CellGroupData[{
Cell[439709, 8513, 305, 8, 70, "RelatedLinksSection"],
Cell[440017, 8523, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[440409, 8540, 318, 9, 70, "MoreAboutSection",
 CellID->28649687],
Cell[440730, 8551, 123, 3, 70, "MoreAbout",
 CellID->15380132],
Cell[440856, 8556, 149, 3, 70, "MoreAbout",
 CellID->507959667],
Cell[441008, 8561, 162, 3, 70, "MoreAbout",
 CellID->65840016],
Cell[441173, 8566, 143, 3, 70, "MoreAbout",
 CellID->696218153],
Cell[441319, 8571, 162, 3, 70, "MoreAbout",
 CellID->974299132],
Cell[441484, 8576, 196, 4, 70, "MoreAbout",
 CellID->62094180],
Cell[441683, 8582, 179, 3, 70, "MoreAbout",
 CellID->398452302]
}, Open  ]],
Cell[441877, 8588, 27, 0, 70, "History"],
Cell[441907, 8590, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

