(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43447,       1328]
NotebookOptionsPosition[     37017,       1105]
NotebookOutlinePosition[     38412,       1144]
CellTagsIndexPosition[     38326,       1139]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Blocks and Local Values" :> 
          Documentation`HelpLookup["paclet:tutorial/BlocksAndLocalValues"], 
          "Blocks Compared with Modules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BlocksComparedWithModules"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Blocks and Local Values\"\>", 
       2->"\<\"Blocks Compared with Modules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Module" :> Documentation`HelpLookup["paclet:ref/Module"], 
          "With" :> Documentation`HelpLookup["paclet:ref/With"], 
          "CompoundExpression" :> 
          Documentation`HelpLookup["paclet:ref/CompoundExpression"], 
          "Assuming" :> Documentation`HelpLookup["paclet:ref/Assuming"], 
          "$Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/$Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Module\"\>", 2->"\<\"With\"\>", 
       3->"\<\"CompoundExpression\"\>", 4->"\<\"Assuming\"\>", 
       5->"\<\"$Assumptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Language Overview\"\>", 
       2->"\<\"Package Bulletproofing\"\>", 3->"\<\"Package Development\"\>", 
       4->"\<\"Procedural Programming\"\>", 
       5->"\<\"Scoping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Block", "ObjectName",
 CellID->22686],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Block",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Block"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is to be evaluated with local values for the symbols ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     StyleBox["\[Ellipsis]", "TR"],
     " . "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Block",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Block"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], "=", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]defines initial local values for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     StyleBox["\[Ellipsis]", "TR"],
     " . "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " allows you to set up an environment in which the values of variables can \
temporarily be changed. "
}], "Notes",
 CellID->19539],

Cell[TextData[{
 "When you execute a block, values assigned to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData["\[Ellipsis]"], "InlineFormula"],
 " are cleared. When the execution of the block is finished, the original \
values of these symbols are restored. "
}], "Notes",
 CellID->27365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " affects only the ",
 Cell[BoxData[
  StyleBox["values", "TI"]], "InlineFormula"],
 " of symbols, not their names. "
}], "Notes",
 CellID->25521],

Cell[TextData[{
 "Initial values specified for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData["\[Ellipsis]"], "InlineFormula"],
 " are evaluated before ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData["\[Ellipsis]"], "InlineFormula"],
 " are cleared. "
}], "Notes",
 CellID->21044],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["vars", "TI"], "}"}], ",", 
    RowBox[{
     StyleBox["body", "TI"], "/;", 
     StyleBox["cond", "TI"]}]}], "]"}]], "InlineFormula"],
 " as the right\[Hyphen]hand side of a transformation rule with a condition \
attached. "
}], "Notes",
 CellID->14502],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31057],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " implements dynamic scoping of variables. "
}], "Notes",
 CellID->32120],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " is automatically used to localize values of iterators in iteration \
constructs such as ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30716]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->593381144],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->60586003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$RecursionLimit", "=", "20"}], "}"}], ",", 
   RowBox[{"x", "=", 
    RowBox[{"x", "+", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567489635],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(20\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellID->415253100],

Cell[BoxData[
 RowBox[{"19", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188838617]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18232],

Cell["Temporarily change settings of global system parameters:", "ExampleText",
 CellID->26471464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"$MaxPrecision", "=", "24"}], ",", 
     RowBox[{"$MinPrecision", "=", "24"}]}], "}"}], ",", 
   RowBox[{"Sin", "[", "1`20", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361363810],

Cell[BoxData["0.8414709848078965066525023215471335603684511965659009955173`24.\
"], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687795850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Exp", "[", "200", "]"}], "]"}], ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->813653932],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->617781974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->659042528],

Cell["\<\
Evaluate an expression with a variable temporarily set to a given value:\
\>", "ExampleText",
 CellID->145794883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->618753829],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"5", " ", "x"}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->528797076]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "5"}], "}"}], ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9156690],

Cell[BoxData["7776"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261388390]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[3]:=",
 CellID->109128739],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->256893164]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9765],

Cell["Perform a deeply recursive calculation:", "ExampleText",
 CellID->344857747],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"cl", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cl", "[", 
   RowBox[{"n_Integer", "?", "EvenQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"cl", "[", 
    RowBox[{"n", "/", "2"}], "]"}], "+", "1"}]}], "\n", 
 RowBox[{
  RowBox[{"cl", "[", 
   RowBox[{"n_Integer", "?", "OddQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"cl", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"3", "n"}], "+", "1"}], "2"], "]"}], "+", "1"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->896776907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$RecursionLimit", "=", "Infinity"}], "}"}], ",", 
   RowBox[{"cl", "[", "27988635", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158677212],

Cell[BoxData["400"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->215051938]
}, Open  ]],

Cell[TextData[{
 "The default setting of ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " is too low for this calculation:"
}], "ExampleText",
 CellID->94037378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "[", "27988635", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->475121513],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellID->62431281],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellID->470599501],

Cell[BoxData[
 RowBox[{"254", "+", 
  RowBox[{"cl", "[", "570331687", "]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->630653390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->511401679],

Cell["Use a local expression to visualize a complex map: ", "ExampleText",
 CellID->137374621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", "f", "]"}], ",", 
        RowBox[{"Im", "[", "f", "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219055816],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253285814]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5356],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " localizes values only; it does not create new symbols:"
}], "ExampleText",
 CellID->31192632],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "7"}], ";"}], "\n", 
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Print", "[", "x", "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->609008510],

Cell[BoxData["x"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->490570272]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " creates new symbols:"
}], "ExampleText",
 CellID->60632961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Print", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111113775],

Cell[BoxData["x$358"], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->173668762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->309264165],

Cell[TextData[{
 "Iterators localize their variable in a similar way to ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->74997886],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "5"}], ";"}], "\n", 
 RowBox[{"Table", "[", 
  RowBox[{"i", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "i"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->328248233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53522418]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10439],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["With",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/With"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompoundExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CompoundExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assuming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assuming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10038],

Cell[TextData[ButtonBox["Blocks and Local Values",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BlocksAndLocalValues"]], "Tutorials",
 CellID->25131],

Cell[TextData[ButtonBox["Blocks Compared with Modules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BlocksComparedWithModules"]], "Tutorials",
 CellID->28548028]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->31764315],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->105141671],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->9648799],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->83794179],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->317675370],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->600448080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Block"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Block - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 25.8179928}", "context" -> "System`", 
    "keywords" -> {
     "dynamic scoping", "fluid variables", "local values", "scoping", 
      "temporary values"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Block[{x, y, ...}, expr] specifies that expr is to be evaluated with \
local values for the symbols x, y, ... . Block[{x = x_0, ...}, expr] defines \
initial local values for x, ... . ", "synonyms" -> {}, "title" -> "Block", 
    "type" -> "Symbol", "uri" -> "ref/Block"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8794, 298, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->593381144]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38183, 1132}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2945, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3568, 92, 43, 1, 70, "ObjectName",
 CellID->22686],
Cell[3614, 95, 1658, 55, 70, "Usage",
 CellID->1705]
}, Open  ]],
Cell[CellGroupData[{
Cell[5309, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5787, 172, 261, 8, 70, "Notes",
 CellID->19539],
Cell[6051, 182, 386, 12, 70, "Notes",
 CellID->27365],
Cell[6440, 196, 276, 10, 70, "Notes",
 CellID->25521],
Cell[6719, 208, 475, 19, 70, "Notes",
 CellID->21044],
Cell[7197, 229, 445, 16, 70, "Notes",
 CellID->14502],
Cell[7645, 247, 300, 12, 70, "Notes",
 CellID->31057],
Cell[7948, 261, 203, 7, 70, "Notes",
 CellID->32120],
Cell[8154, 270, 603, 23, 70, "Notes",
 CellID->30716]
}, Closed]],
Cell[CellGroupData[{
Cell[8794, 298, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->593381144],
Cell[CellGroupData[{
Cell[9179, 312, 147, 5, 70, "ExampleSection",
 CellID->60586003],
Cell[CellGroupData[{
Cell[9351, 321, 237, 8, 70, "Input",
 CellID->567489635],
Cell[9591, 331, 186, 5, 19, "Message",
 CellID->415253100],
Cell[9780, 338, 237, 8, 36, "Output",
 CellID->188838617]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10066, 352, 216, 7, 70, "ExampleSection",
 CellID->18232],
Cell[10285, 361, 98, 1, 70, "ExampleText",
 CellID->26471464],
Cell[CellGroupData[{
Cell[10408, 366, 285, 9, 70, "Input",
 CellID->361363810],
Cell[10696, 377, 224, 6, 36, "Output",
 CellID->687795850]
}, Open  ]],
Cell[CellGroupData[{
Cell[10957, 388, 283, 9, 70, "Input",
 CellID->813653932],
Cell[11243, 399, 162, 5, 36, "Output",
 CellID->617781974]
}, Open  ]],
Cell[11420, 407, 125, 3, 70, "ExampleDelimiter",
 CellID->659042528],
Cell[11548, 412, 123, 3, 70, "ExampleText",
 CellID->145794883],
Cell[CellGroupData[{
Cell[11696, 419, 174, 6, 70, "Input",
 CellID->618753829],
Cell[11873, 427, 414, 14, 36, "Output",
 CellID->528797076]
}, Open  ]],
Cell[CellGroupData[{
Cell[12324, 446, 171, 6, 70, "Input",
 CellID->9156690],
Cell[12498, 454, 161, 5, 36, "Output",
 CellID->261388390]
}, Open  ]],
Cell[CellGroupData[{
Cell[12696, 464, 70, 2, 70, "Input",
 CellID->109128739],
Cell[12769, 468, 158, 5, 36, "Output",
 CellID->256893164]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12976, 479, 222, 7, 70, "ExampleSection",
 CellID->9765],
Cell[13201, 488, 82, 1, 70, "ExampleText",
 CellID->344857747],
Cell[13286, 491, 541, 19, 70, "Input",
 CellID->896776907],
Cell[CellGroupData[{
Cell[13852, 514, 231, 7, 70, "Input",
 CellID->158677212],
Cell[14086, 523, 160, 5, 36, "Output",
 CellID->215051938]
}, Open  ]],
Cell[14261, 531, 251, 8, 70, "ExampleText",
 CellID->94037378],
Cell[CellGroupData[{
Cell[14537, 543, 105, 3, 70, "Input",
 CellID->475121513],
Cell[14645, 548, 186, 5, 70, "Message",
 CellID->62431281],
Cell[14834, 555, 187, 5, 70, "Message",
 CellID->470599501],
Cell[15024, 562, 220, 7, 36, "Output",
 CellID->630653390]
}, Open  ]],
Cell[15259, 572, 125, 3, 70, "ExampleDelimiter",
 CellID->511401679],
Cell[15387, 577, 94, 1, 70, "ExampleText",
 CellID->137374621],
Cell[CellGroupData[{
Cell[15506, 582, 675, 22, 70, "Input",
 CellID->219055816],
Cell[16184, 606, 14417, 240, 70, "Output",
 Evaluatable->False,
 CellID->253285814]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30650, 852, 232, 7, 70, "ExampleSection",
 CellID->5356],
Cell[30885, 861, 225, 7, 70, "ExampleText",
 CellID->31192632],
Cell[CellGroupData[{
Cell[31135, 872, 234, 8, 70, "Input",
 CellID->609008510],
Cell[31372, 882, 91, 2, 70, "Print",
 CellID->490570272]
}, Open  ]],
Cell[31478, 887, 193, 7, 70, "ExampleText",
 CellID->60632961],
Cell[CellGroupData[{
Cell[31696, 898, 182, 6, 70, "Input",
 CellID->111113775],
Cell[31881, 906, 95, 2, 70, "Print",
 CellID->173668762]
}, Open  ]],
Cell[31991, 911, 125, 3, 70, "ExampleDelimiter",
 CellID->309264165],
Cell[32119, 916, 230, 8, 70, "ExampleText",
 CellID->74997886],
Cell[CellGroupData[{
Cell[32374, 928, 236, 8, 70, "Input",
 CellID->328248233],
Cell[32613, 938, 232, 7, 36, "Output",
 CellID->53522418]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32906, 952, 311, 9, 70, "SeeAlsoSection",
 CellID->10439],
Cell[33220, 963, 1201, 44, 70, "SeeAlso",
 CellID->7535]
}, Open  ]],
Cell[CellGroupData[{
Cell[34458, 1012, 314, 9, 70, "TutorialsSection",
 CellID->10038],
Cell[34775, 1023, 154, 3, 70, "Tutorials",
 CellID->25131],
Cell[34932, 1028, 167, 3, 70, "Tutorials",
 CellID->28548028]
}, Open  ]],
Cell[CellGroupData[{
Cell[35136, 1036, 318, 9, 70, "MoreAboutSection",
 CellID->31764315],
Cell[35457, 1047, 145, 3, 70, "MoreAbout",
 CellID->105141671],
Cell[35605, 1052, 153, 3, 70, "MoreAbout",
 CellID->9648799],
Cell[35761, 1057, 148, 3, 70, "MoreAbout",
 CellID->83794179],
Cell[35912, 1062, 155, 3, 70, "MoreAbout",
 CellID->317675370],
Cell[36070, 1067, 147, 3, 70, "MoreAbout",
 CellID->600448080]
}, Open  ]],
Cell[CellGroupData[{
Cell[36254, 1075, 305, 8, 70, "RelatedLinksSection"],
Cell[36562, 1085, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[36960, 1101, 27, 0, 70, "History"],
Cell[36990, 1103, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

