(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27273,        979]
NotebookOptionsPosition[     21835,        787]
NotebookOutlinePosition[     23293,        827]
CellTagsIndexPosition[     23208,        822]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pseudorandom Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/PseudorandomNumbers"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RandomNumberGeneration"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Pseudorandom Numbers\"\>", 
       2->"\<\"Random Number Generation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SeedRandom" :> 
          Documentation`HelpLookup["paclet:ref/SeedRandom"], "RandomInteger" :> 
          Documentation`HelpLookup["paclet:ref/RandomInteger"], "RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"], "RandomChoice" :> 
          Documentation`HelpLookup["paclet:ref/RandomChoice"], "RandomSample" :> 
          Documentation`HelpLookup["paclet:ref/RandomSample"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SeedRandom\"\>", 
       2->"\<\"RandomInteger\"\>", 3->"\<\"RandomReal\"\>", 
       4->"\<\"RandomChoice\"\>", 
       5->"\<\"RandomSample\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup["paclet:guide/RandomNumberGeneration"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Package Bulletproofing\"\>", 
       2->"\<\"Random Number Generation\"\>", 
       3->"\<\"Scoping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BlockRandom", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BlockRandom",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlockRandom"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with all pseudorandom generators localized, so that uses of ",
     Cell[BoxData[
      ButtonBox["SeedRandom",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["RandomInteger",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
     " and related functions within the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " do not affect subsequent pseudorandom sequences."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BlockRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlockRandom"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " in effect saves the states of all pseudorandom generators before \
evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", then restores them afterwards."
}], "Notes",
 CellID->6906],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BlockRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlockRandom"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " always gives the same result as just evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", though it can affect values obtained for subsequent expressions."
}], "Notes",
 CellID->12707],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26956],

Cell[TextData[{
 "Many built-in functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively use ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7701]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160999448],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->51801541],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " to localize the use of a pseudorandom generator:"
}], "ExampleText",
 CellID->18787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RandomReal", "[", "]"}], ",", 
   RowBox[{"BlockRandom", "[", 
    RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", "]"}], ",", 
   RowBox[{"RandomReal", "[", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0060950886630148915`", ",", "0.6326076127773479`", ",", 
   "0.6326076127773479`", ",", "0.6327439776743196`"}], "}"}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29569],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " to prevent one use of a randomized algorithm from affecting others:"
}], "ExampleText",
 CellID->2433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"1", ",", "100"}], "]"}], "]"}], ",", 
   RowBox[{"{", "20", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "44", ",", "44", ",", "48", ",", "52", ",", "51", ",", "49", ",", "46", ",",
    "44", ",", "54", ",", "49", ",", "55", ",", "49", ",", "48", ",", "44", 
   ",", "45", ",", "56", ",", "53", ",", "54", ",", "46", ",", "56"}], 
  "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26130]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{"Total", "[", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"1", ",", "100"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", "20", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7204],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "56", ",", "56", ",", "56", ",", "56", ",", "56", ",", "56", ",", "56", ",",
    "56", ",", "56", ",", "56", ",", "56", ",", "56", ",", "56", ",", "56", 
   ",", "56", ",", "56", ",", "56", ",", "56", ",", "56", ",", "56"}], 
  "}"}]], "Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12862]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17230],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " works with all pseudorandom generators in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->24611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.7928599681084061`", ",", "0.94329230664985`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7928599681084061`", ",", "0.94329230664985`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7928599681084061`", ",", "0.94329230664985`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4568]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "5"}], "]"}], "]"}], 
   ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7030],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "c", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "c", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "c", ",", "c", ",", "a"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18138]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3406],

Cell["\<\
Run a randomized algorithm without affecting other random sequences:\
\>", "ExampleText",
 CellID->17804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.918945520383758`", ",", "0.190034567851197`", ",", "0.3326802808466569`",
    ",", "0.20984306585794998`", ",", "0.7086273342689722`"}], 
  "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31673]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28210],

Cell[TextData[{
 "Compute a Monte Carlo approximation to ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BlockRandom", "[", 
  RowBox[{"4.0", " ", 
   RowBox[{"Mean", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Boole", "[", 
       RowBox[{
        RowBox[{"Norm", "[", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], "<", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", "^", "4"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37],

Cell[BoxData["3.1524`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22219]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " prevents other random sequences from being affected:"
}], "ExampleText",
 CellID->9818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"1", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.918945520383758`", ",", "0.190034567851197`", ",", "0.3326802808466569`",
    ",", "0.20984306585794998`", ",", "0.7086273342689722`"}], 
  "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->712]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28646],

Cell["\<\
Get the \[OpenCurlyDoubleQuote]same\[CloseCurlyDoubleQuote] random number at \
different precisions:\
\>", "ExampleText",
 CellID->6718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"WorkingPrecision", "->", "p"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25038],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.25`0.9999999999999999", ",", "0.3046875`2.000000000000001", ",", 
   "0.3046875`3.000000000000001", ",", "0.3050537109375`4.000000000000001", 
   ",", "0.30506134033203125`5.", ",", 
   "0.3050642013549804688`5.999999999999999", ",", "0.3050642609596252441`7.",
    ",", "0.3050642609596252441`8.", ",", "0.3050642646849155426`9.", ",", 
   "0.94151820481056347489356994629`10."}], "}"}]], "Output",
 ImageSize->{346, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9289]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2690],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " effectively does the same as resetting the random seed to its previous \
value:"
}], "ExampleText",
 CellID->9033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "123", "]"}], ";", 
    RowBox[{"RandomReal", "[", "]"}]}], ",", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "123", "]"}], ";", 
    RowBox[{"RandomReal", "[", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3129393306952448`", ",", "0.3129393306952448`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19989]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "123", "]"}], ";", 
    RowBox[{"BlockRandom", "[", 
     RowBox[{"RandomReal", "[", "]"}], "]"}]}], ",", 
   RowBox[{"RandomReal", "[", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25453],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3129393306952448`", ",", "0.3129393306952448`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24544]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1113],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomChoice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomChoice"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomSample",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomSample"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16479],

Cell[TextData[ButtonBox["Pseudorandom Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PseudorandomNumbers"]], "Tutorials",
 CellID->32657],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RandomNumberGeneration"]], "Tutorials",
 CellID->86049371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->754815630],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->65789813],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "MoreAbout",
 CellID->600362776],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->407536881]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BlockRandom - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 26.3023802}", "context" -> "System`", 
    "keywords" -> {
     "localize random generator", "localize random state", 
      "reset random state"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BlockRandom[expr] evaluates expr with all pseudorandom generators \
localized, so that uses of SeedRandom, RandomInteger and related functions \
within the evaluation of expr do not affect subsequent pseudorandom \
sequences.", "synonyms" -> {"block random"}, "title" -> "BlockRandom", "type" -> 
    "Symbol", "uri" -> "ref/BlockRandom"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7908, 238, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160999448]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23065, 815}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2670, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3293, 87, 1576, 37, 70, "ObjectNameGrid"],
Cell[4872, 126, 1078, 31, 70, "Usage",
 CellID->10068]
}, Open  ]],
Cell[CellGroupData[{
Cell[5987, 162, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6465, 179, 402, 13, 70, "Notes",
 CellID->6906],
Cell[6870, 194, 407, 12, 70, "Notes",
 CellID->12707],
Cell[7280, 208, 311, 12, 70, "Notes",
 CellID->26956],
Cell[7594, 222, 277, 11, 70, "Notes",
 CellID->7701]
}, Closed]],
Cell[CellGroupData[{
Cell[7908, 238, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160999448],
Cell[CellGroupData[{
Cell[8293, 252, 147, 5, 70, "ExampleSection",
 CellID->51801541],
Cell[8443, 259, 237, 8, 70, "ExampleText",
 CellID->18787],
Cell[CellGroupData[{
Cell[8705, 271, 300, 9, 28, "Input",
 CellID->90],
Cell[9008, 282, 302, 9, 36, "Output",
 CellID->32197]
}, Open  ]],
Cell[9325, 294, 121, 3, 70, "ExampleDelimiter",
 CellID->29569],
Cell[9449, 299, 255, 8, 70, "ExampleText",
 CellID->2433],
Cell[CellGroupData[{
Cell[9729, 311, 248, 8, 70, "Input",
 CellID->24148],
Cell[9980, 321, 414, 11, 36, "Output",
 CellID->26130]
}, Open  ]],
Cell[CellGroupData[{
Cell[10431, 337, 289, 9, 70, "Input",
 CellID->7204],
Cell[10723, 348, 414, 11, 36, "Output",
 CellID->12862]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11186, 365, 216, 7, 70, "ExampleSection",
 CellID->17230],
Cell[11405, 374, 277, 10, 70, "ExampleText",
 CellID->24611],
Cell[CellGroupData[{
Cell[11707, 388, 247, 8, 70, "Input",
 CellID->4309],
Cell[11957, 398, 461, 14, 36, "Output",
 CellID->4568]
}, Open  ]],
Cell[CellGroupData[{
Cell[12455, 417, 318, 11, 70, "Input",
 CellID->7030],
Cell[12776, 430, 450, 14, 36, "Output",
 CellID->18138]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13275, 450, 222, 7, 70, "ExampleSection",
 CellID->3406],
Cell[13500, 459, 115, 3, 70, "ExampleText",
 CellID->17804],
Cell[CellGroupData[{
Cell[13640, 466, 188, 6, 70, "Input",
 CellID->8579],
Cell[13831, 474, 329, 10, 36, "Output",
 CellID->31673]
}, Open  ]],
Cell[14175, 487, 123, 4, 70, "Input",
 CellID->28210],
Cell[14301, 493, 160, 6, 70, "ExampleText",
 CellID->28965],
Cell[CellGroupData[{
Cell[14486, 503, 449, 14, 70, "Input",
 CellID->37],
Cell[14938, 519, 160, 5, 36, "Output",
 CellID->22219]
}, Open  ]],
Cell[15113, 527, 231, 7, 70, "ExampleText",
 CellID->9818],
Cell[CellGroupData[{
Cell[15369, 538, 125, 4, 70, "Input",
 CellID->25049],
Cell[15497, 544, 327, 10, 36, "Output",
 CellID->712]
}, Open  ]],
Cell[15839, 557, 121, 3, 70, "ExampleDelimiter",
 CellID->28646],
Cell[15963, 562, 146, 4, 70, "ExampleText",
 CellID->6718],
Cell[CellGroupData[{
Cell[16134, 570, 290, 9, 70, "Input",
 CellID->25038],
Cell[16427, 581, 570, 13, 54, "Output",
 CellID->9289]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17046, 600, 232, 7, 70, "ExampleSection",
 CellID->2690],
Cell[17281, 609, 258, 8, 70, "ExampleText",
 CellID->9033],
Cell[CellGroupData[{
Cell[17564, 621, 309, 10, 70, "Input",
 CellID->14672],
Cell[17876, 633, 239, 8, 36, "Output",
 CellID->19989]
}, Open  ]],
Cell[CellGroupData[{
Cell[18152, 646, 284, 9, 70, "Input",
 CellID->25453],
Cell[18439, 657, 239, 8, 36, "Output",
 CellID->24544]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18739, 672, 310, 9, 70, "SeeAlsoSection",
 CellID->1113],
Cell[19052, 683, 1220, 44, 70, "SeeAlso",
 CellID->20646]
}, Open  ]],
Cell[CellGroupData[{
Cell[20309, 732, 314, 9, 70, "TutorialsSection",
 CellID->16479],
Cell[20626, 743, 150, 3, 70, "Tutorials",
 CellID->32657],
Cell[20779, 748, 160, 3, 70, "Tutorials",
 CellID->86049371]
}, Open  ]],
Cell[CellGroupData[{
Cell[20976, 756, 319, 9, 70, "MoreAboutSection",
 CellID->754815630],
Cell[21298, 767, 154, 3, 70, "MoreAbout",
 CellID->65789813],
Cell[21455, 772, 158, 3, 70, "MoreAbout",
 CellID->600362776],
Cell[21616, 777, 147, 3, 70, "MoreAbout",
 CellID->407536881]
}, Open  ]],
Cell[21778, 783, 27, 0, 70, "History"],
Cell[21808, 785, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

