(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     84124,       2348]
NotebookOptionsPosition[     75352,       2036]
NotebookOutlinePosition[     76642,       2074]
CellTagsIndexPosition[     76556,       2069]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"], 
          "Integrals over Regions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralsOverRegions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Piecewise Functions\"\>", 
       2->"\<\"Integrals over Regions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"If" :> Documentation`HelpLookup["paclet:ref/If"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"], "DiscreteDelta" :> 
          Documentation`HelpLookup["paclet:ref/DiscreteDelta"], "UnitStep" :> 
          Documentation`HelpLookup["paclet:ref/UnitStep"], "Unitize" :> 
          Documentation`HelpLookup["paclet:ref/Unitize"], "Pick" :> 
          Documentation`HelpLookup["paclet:ref/Pick"], "RegionPlot" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"If\"\>", 2->"\<\"Piecewise\"\>", 
       3->"\<\"DiscreteDelta\"\>", 4->"\<\"UnitStep\"\>", 
       5->"\<\"Unitize\"\>", 6->"\<\"Pick\"\>", 7->"\<\"RegionPlot\"\>", 
       8->"\<\"True\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Inequalities\"\>", 3->"\<\"Logic & Boolean Algebra\"\>", 
       4->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Boole", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Boole",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Boole"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData["1"], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " and ",
     Cell[BoxData["0"], "InlineFormula"],
     " if it is ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " remains unchanged if ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is neither ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " nor ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32464],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "1", ",", "0"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28222],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->30815],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], " ", 
     RowBox[{"Boole", "[", 
      StyleBox["pred", "TI"], "]"}]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be used to integrate ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " over the region in which ",
 Cell[BoxData[
  StyleBox["pred", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10860]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77823426],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->260434593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Boole", "[", "False", "]"}], ",", 
   RowBox[{"Boole", "[", "True", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287055007]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28316],

Cell["Convert a list of truth values to integers:", "ExampleText",
 CellID->5489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Boole", "[", 
  RowBox[{"{", 
   RowBox[{"True", ",", "False", ",", "True", ",", "True", ",", "False"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27796],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26548]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2664],

Cell[TextData[{
 "Find the area of the disc defined by the inequality ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[LessEqual]", "1"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->25858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", " ", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20543],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121312271]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->216312580],

Cell["Find the area of a region defined by an inequality:", "ExampleText",
 CellID->164348],

Cell[BoxData[
 RowBox[{
  RowBox[{"ineq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", "0"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69396889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", "ineq", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63041100],

Cell[BoxData[
 FractionBox["8", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->856542529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", "ineq", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->595858874],

Cell[BoxData["2.666666666265287`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->727498288]
}, Open  ]],

Cell["Plot the region:", "ExampleText",
 CellID->129594713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->164260969],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3900603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102614469],

Cell["Find the volume of a solid defined by an inequality:", "ExampleText",
 CellID->109786586],

Cell[BoxData[
 RowBox[{
  RowBox[{"ineq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", 
    RowBox[{"-", 
     RowBox[{"z", "^", "2"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121030651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", "ineq", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->288423052],

Cell[BoxData[
 FractionBox[
  RowBox[{"16", " ", "\[Pi]"}], "15"]], "Output",
 ImageSize->{34, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->460853873]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", "ineq", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210882210],

Cell[BoxData["3.3510321469880084`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->282199753]
}, Open  ]],

Cell["Plot the solid:", "ExampleText",
 CellID->428945477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->823679611],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->472964374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106956472],

Cell["\<\
Find the area of the intersection of a circle with a parametric radius and a \
square:\
\>", "ExampleText",
 CellID->22863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", " ", 
      RowBox[{"y", "^", "2"}]}], "<", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9166],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"4", 
     RowBox[{"a", "\[GreaterEqual]", "2"}]},
    {
     RowBox[{"a", " ", "\[Pi]"}], 
     RowBox[{"0", "<", "a", "\[LessEqual]", "1"}]},
    {
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "a"}]]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"ArcCsc", "[", 
          SqrtBox["a"], "]"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"ArcTan", "[", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", "a"}]], "]"}]}]}], ")"}]}], 
     RowBox[{"1", "<", "a", "<", "2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{393, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405870650]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", " ", 
       RowBox[{"y", "^", "2"}]}], "<", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"3", "/", "2"}], ",", 
       RowBox[{"5", "/", "2"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->474463687],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXF1oHUUUnty9uUn6Z3/TmNbSakqUWhR/kKJVkaJ98UHfVBBCCbQPotQ+
+VIQpSiloBYlNqSElGhsaWtqr1ybEm0lNTY0WDFYWgwEAlYqpcUigUL8zszO
nb0zs7uzN3sT0/bS3N35OWe+OefMmXNm9/bFlh1bW99o2bFtS8vqF7a3vLV1
25a3Vz//5nZUeVWMVb3EGHu9geF+Enf8jz4v40/cutytxLcH0gyVPMljkmVw
W4MbunqBNkZ98Ze1tEm62gi6mojxmiqAJYputmCZy/vdo7VwLllVZqzaqKkx
agz+Ro+cnUuApjoWSdM0YQ3hcstincMv9fjOWmxML1czOWyAxYzZxEofdTYG
dVYi+l9IfHaiFnZyx2Pc8RjlWwLVFHerkpasUWNagKSurYg0k2ALp57d2Kam
2WjLc9VwkItum+lJMynWeC63FlZhCbRTZXxNBaPNYNQZbK/V2nPatSkhP729
0vxEVEwiCM9uFkyGR9WtZba9xjnfFauV1hR6vMovpKnQeM+wnc24LpoGivmO
cqj2ZTnPaJlv1Oijm7umtUdwfNw2OGOy7sHexMREPp/f88khlqMvosSVboHZ
qOF9PFWTNXp4vKanp2dsbKx0fHekdbZRAuWalNsJs5dQy8Eem7RyfWIOfMfx
Ll++DMEdP3GRPTz067/MO3Pu2sefHR0aGjJ2yAQjXL9+/f0POtlznOOpn/7q
7u5mMzpXUb506RKk/uPZv9mjHFlXz0B/f//Nmzd9WaQ/V/KPNt+6yb8uD2kX
3C9cuPBpe/7nX/5hj3Puh785XygUCG82hp55wAQaIntWImPiI5CtipHxWpsE
CFFbR4EYPsG5wm4CiKz0kfJJiiKjodigodC9V4oocsUyPrAkaOYpbXTd27mP
HrSJZqlDEimWJ0wWJrCR0x78evjUqVNcEsGe6Wi7WpRv3Lhx6BBfJc8Qr+y+
zr6RkRFh9c1lyVOUQTLOPyxDXx7GKWnX0Pirrbe399uTf/BZZSEGCAMiSYSE
JNTINQgdjY6OQoBg2tbWBjLupXNdXV0oohJN0Cy6Neq68KDuEgmTxxSf8rWw
nKOCMPr6+trb2/e2HYN+Mdtaos7hBkWMiyZ0wN52d5h9iQXhywB0mAorW1vL
uPQhKFgBxHM0/9tCLn3cYGdAJZqWTwuSJRwJ7ATRAoRz8vT4Uo4ENyiiEk3L
KoJE+m3bSbL0sUukLwIlWUODtAvsp1gwvD3oo6N4MU84NGU7QOzbjhu9xfZK
ZmTGgta8J1BexMsDAwOARntQo4wP4BBQ689f9V/qPkKIburdOURqT8bzIWez
EXMWsQkcAIzry8Nn2SrOH3cok4dfZOmfcKSQuS9KzilSBm76puICOWfsYmTH
q7VdTeZ4btqhIiEqjyIMuzy10eM0gR1BHEIjgr2GY4engsNU+oyyUYOzs20a
lAn1YY9RVZlTeOfPn+848D2xvE/GrAjO1dzj5mYdIdEcrRwi5yqjU/0EREpM
zOzKlSsf7vmCGKzlXLDXYCukpnmTpZ5Tp3fxliZN+O5cEnUbPkHPIXme7WEf
xDak0PcP/IkqWi/ztf5T3ZH0PCzjhHKuZj3NnCsKqFKzmGmU/GSNfA+4UMR5
P+eKO8gSm/sMoiyegAVk+ADn1tl9enh4WKIvjRLD7dIlSpyKDDFBMFIoIUOE
tcoSwv1M8YQ7RKa6zy72T9US6ngZDgBugBiu41wRcPpnOnMssyB5rnJAX9Iv
FcsQaOCIyR0X0arsrG7S/pRBniFHWUo4TVLL0fNRPX8QMleebF1AJjaZSz8Z
ZzG1er8Qmddp/Ks4aiF0Eeau0HqIeU5MTOx873Nitp5z3L9/P6rUjNLzFySB
KlwJWZWTTAVC5Ki7P/pKIVR2nDZCuwx1u5X2aHtrRq4kwQmZC+J7hRyYgEzO
jPo1OPCKsm83+vB8xm2l8l4xz4b0MyvBWa3q9VrEpct6WZIxQvS7PAmPKfmu
8iWCbA8p0O0rEa/IUWUauiTk+2Wu6INZTzk0ldb54OBg98HB21fnpkQQ9CH0
UxJRceDslojcG4JZkNoPxEm3y36g07vsASZN2tGxoFK5ppgFNmds0TbdVSbD
kBmxHR3yH8QzdMb2IOeGO4Q0lEvqEdhU0ZVmuvp5q5CFOHFX8eB3P4wdOXKE
mtJGU3pGL7irbGudxe+kmW3Zz5yFDARghWLX7gNXr16trAzMnC6fzx8/cVHl
dAjTEaxTk57TpasJwX10dHRv2zE1OgqokugqrwmBQmUnzZoM0j4biEKh4vlm
LZ6fHhRiFBV9iDMndc6Z9pmTelIf9uSh9CwP6Rf8K2m0SZ4+9PT0oJa3h2UN
Oq+kWYNJH/cUhJ+ZRp5I6/ld8awS+icPfa/00P6TSP2E2dz7Q0dw3vlDOcQ+
w0o21wXaul8j172/48/2uVJRzEHAIX2ukvoUgQ1vt8fkYRzDo/g4ijDs0p71
k7qFEjvcz5lz19hKjh13sEXCvjhWPwZnZ70YlAn1oc9Fj7HFk7Xx8XFstbTq
G2XsAb9CrwvoTxvtc7OOkGiOVg5OXlKeNMpYr/j0mt426ChATfVEn4Vv3NfZ
h5AKXOUz4oYQHi4e0aRJutOKJ0cQEwgRbwHgYo4UkFFE5cjIiP5GVAXfPchh
30DMByow7i38jsU5j6hzuEERle/u6kAHBMjT8x4CH6UGw4FroVBArI4Fh/QP
+y/LgHkGXOjKalCDerSiD3qiP0XxlXtvg/TNz0izGAfLBAkpIoIM+GTe2bmX
riyLClSjEV1WTOqRmwhrlK0gwPBtJeW3i/yVJk7XxPs84INYjqKEcjUT9R7T
pHx5iD1NvKphPZgsdnKx2BNK2fp2FqBD1whJN2oRcgXezqoplvEBZMyF+Dwp
s3L/uV7576DFIjB2ZcgS06edaIOWq1XwPbxA2ZMofFmIdxLp+FqgKO+dRBkB
2N5Nl7ugtIYGh75iV0H6KEyFPSYjDpgLFmaxnwuveFtaaJNR5OmWLmXdp8Zz
EDMUNkk+8RGZA6CMBWHEQQlGiNTUTMxV/E4HrhRuFZYGNT7EsSFRR+QCWzRO
gKZ3tkULivl1kUk9hT4BVLbfC+j7XwxyvWc1vU3HGDY0/OOLgK7ZYFXOqCmv
j6jJ5/P+80T1+4AEcyAenuKatZVNZCn3oJmoHMPNdjY7zzNZT1cMafyi55VJ
6cOD58utMWXxOyBi4fJ/OrCq/wBUiJBb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->373855439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->975206834],

Cell[TextData[{
 "Convert a table of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], ",", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " values to ",
 Cell[BoxData[
  RowBox[{"1", ",", "0"}]], "InlineFormula"],
 " for plotting:"
}], "ExampleText",
 CellID->1861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "b"}], "+", "3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "50"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28300],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzVll0KgCAQhD+7SVfoKB3BC3T/t0RtMX9CsMIdCJLC3ZkdB1d77HYBtvg4
mAiMvBYrjcj7H+ZDfQ91Ov3RsLeVOmVKEKkEMmTfkrNjmv7orCLbqAV0pcYQ
SVeAVCq0SpYE71djD4693EvNwiqAn3J+9l6ucfkpL102MzWQwELWlb9Ga9DI
98nVuYNgqyjXQ+sDrPwFSwZCmo+v3bBOS08Lbw==
   "], {{0, 0}, {50, 50}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->11112818]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->106929937],

Cell[TextData[{
 "The inverse of ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->839798995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"#", "!=", "0"}], ")"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23644]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Boole", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4237],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97224853],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " to convert ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->61991062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Boole", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18976020],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwqACxuAQDkP0fyAJj
lf//gTQzkGQGcuXgPAYQ9z8YDGJRNiDBCuTyQmlGsComIMkE5HGhqeYBEaxw
PlgtRDWURFLLSUW9INexwFWj+4GDBJsI6eWFxiMzUaqFsapih4aeKM1jEpHi
IKmQgREATzdohA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{36, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176485662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153146229],

Cell[TextData[{
 "Correspondence between logic operations on conditions and arithmetic \
operations on ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103374168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"a", "&&", "b"}], "]"}], "-", 
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{"Boole", "[", "a", "]"}], ",", 
     RowBox[{"Boole", "[", "b", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308498953],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340647199]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"a", "||", "b"}], "]"}], "-", 
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"Boole", "[", "a", "]"}], ",", 
     RowBox[{"Boole", "[", "b", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371382927],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->244488905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"a", "&&", "b"}], "]"}], "-", 
   RowBox[{
    RowBox[{"Boole", "[", "a", "]"}], 
    RowBox[{"Boole", "[", "b", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->315328687],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->135908686]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"a", "||", "b"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Boole", "[", "a", "]"}], "+", 
     RowBox[{"Boole", "[", "b", "]"}], "-", 
     RowBox[{
      RowBox[{"Boole", "[", "a", "]"}], 
      RowBox[{"Boole", "[", "b", "]"}]}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->472851597],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->301931271]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"!", "a"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Boole", "[", "a", "]"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->83553751],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->52774908]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267907408],

Cell["\<\
Use Refine, Simplify and FullSimplify transform expressions involving Boole:\
\>", "ExampleText",
 CellID->256367966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "10"}], "&&", 
     RowBox[{"x", ">", "y"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148137403],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34205037]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"x", ">", "y"}], "]"}], ",", 
   RowBox[{"x", "\[Equal]", 
    RowBox[{"y", "+", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21422930],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170996431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120678922],

Cell[TextData[{
 "Reduce equations and optimize functions involving ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->700188291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], 
      RowBox[{"Boole", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "<", "1"}], "]"}]}], "]"}], "<", "1"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328906545],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "0"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{225, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299328118]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Boole", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<=", "1"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81995068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     RowBox[{"Sin", "[", "1", "]"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{165, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96844735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104684567],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " as a characteristic function for integration problems: "
}], "ExampleText",
 CellID->86917634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"3", 
       RowBox[{"y", "^", "4"}]}]}], ")"}], 
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
      RowBox[{"y", ">", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437952509],

Cell[BoxData[
 FractionBox[
  RowBox[{"5", " ", "\[Pi]"}], "16"]], "Output",
 ImageSize->{27, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132868407]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"3", 
       RowBox[{"y", "^", "4"}]}]}], "]"}], 
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
      RowBox[{"y", ">", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4771096],

Cell[BoxData["3.7295503004222716`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195013707]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8091],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiscreteDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiscreteDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitStep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitStep"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unitize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unitize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pick",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pick"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25024]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21989],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->13770],

Cell[TextData[ButtonBox["Integrals over Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntegralsOverRegions"]], "Tutorials",
 CellID->51756815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->594806575],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->77177967],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->7484483],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->11369689],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->212658404]
}, Open  ]],

Cell["New in 5.1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Boole - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 27.7086662}", "context" -> "System`", 
    "keywords" -> {
     "characteristic function", "indicator function", "Iverson's convention", 
      "integrate over a region"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Boole[expr] yields 1 if expr is True and 0 if it is False. ", 
    "synonyms" -> {}, "title" -> "Boole", "type" -> "Symbol", "uri" -> 
    "ref/Boole"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11351, 320, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->77823426]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76413, 2062}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2963, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3586, 91, 4189, 83, 70, "ObjectNameGrid"],
Cell[7778, 176, 924, 32, 70, "Usage",
 CellID->19245]
}, Open  ]],
Cell[CellGroupData[{
Cell[8739, 213, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9217, 230, 555, 22, 70, "Notes",
 CellID->32464],
Cell[9775, 254, 448, 17, 70, "Notes",
 CellID->28222],
Cell[10226, 273, 421, 15, 70, "Notes",
 CellID->30815],
Cell[10650, 290, 664, 25, 70, "Notes",
 CellID->10860]
}, Closed]],
Cell[CellGroupData[{
Cell[11351, 320, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77823426],
Cell[CellGroupData[{
Cell[11735, 334, 148, 5, 70, "ExampleSection",
 CellID->260434593],
Cell[CellGroupData[{
Cell[11908, 343, 184, 6, 28, "Input",
 CellID->19713],
Cell[12095, 351, 203, 7, 36, "Output",
 CellID->287055007]
}, Open  ]],
Cell[12313, 361, 121, 3, 70, "ExampleDelimiter",
 CellID->28316],
Cell[12437, 366, 81, 1, 70, "ExampleText",
 CellID->5489],
Cell[CellGroupData[{
Cell[12543, 371, 195, 6, 28, "Input",
 CellID->27796],
Cell[12741, 379, 229, 7, 36, "Output",
 CellID->26548]
}, Open  ]],
Cell[12985, 389, 120, 3, 70, "ExampleDelimiter",
 CellID->2664],
Cell[13108, 394, 293, 11, 70, "ExampleText",
 CellID->25858],
Cell[CellGroupData[{
Cell[13426, 409, 448, 15, 70, "Input",
 CellID->20543],
Cell[13877, 426, 162, 5, 36, "Output",
 CellID->121312271]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14088, 437, 227, 7, 70, "ExampleSection",
 CellID->216312580],
Cell[14318, 446, 91, 1, 70, "ExampleText",
 CellID->164348],
Cell[14412, 449, 304, 11, 70, "Input",
 CellID->69396889],
Cell[CellGroupData[{
Cell[14741, 464, 361, 11, 70, "Input",
 CellID->63041100],
Cell[15105, 477, 178, 6, 51, "Output",
 CellID->856542529]
}, Open  ]],
Cell[CellGroupData[{
Cell[15320, 488, 363, 11, 70, "Input",
 CellID->595858874],
Cell[15686, 501, 175, 5, 36, "Output",
 CellID->727498288]
}, Open  ]],
Cell[15876, 509, 59, 1, 70, "ExampleText",
 CellID->129594713],
Cell[CellGroupData[{
Cell[15960, 514, 302, 10, 70, "Input",
 CellID->164260969],
Cell[16265, 526, 4940, 85, 70, "Output",
 Evaluatable->False,
 CellID->3900603]
}, Open  ]],
Cell[21220, 614, 125, 3, 70, "ExampleDelimiter",
 CellID->102614469],
Cell[21348, 619, 95, 1, 70, "ExampleText",
 CellID->109786586],
Cell[21446, 622, 351, 13, 70, "Input",
 CellID->121030651],
Cell[CellGroupData[{
Cell[21822, 639, 466, 14, 70, "Input",
 CellID->288423052],
Cell[22291, 655, 207, 7, 51, "Output",
 CellID->460853873]
}, Open  ]],
Cell[CellGroupData[{
Cell[22535, 667, 467, 14, 70, "Input",
 CellID->210882210],
Cell[23005, 683, 176, 5, 36, "Output",
 CellID->282199753]
}, Open  ]],
Cell[23196, 691, 58, 1, 70, "ExampleText",
 CellID->428945477],
Cell[CellGroupData[{
Cell[23279, 696, 394, 13, 70, "Input",
 CellID->823679611],
Cell[23676, 711, 28508, 471, 70, "Output",
 Evaluatable->False,
 CellID->472964374]
}, Open  ]],
Cell[52199, 1185, 125, 3, 70, "ExampleDelimiter",
 CellID->106956472],
Cell[52327, 1190, 133, 4, 70, "ExampleText",
 CellID->22863],
Cell[CellGroupData[{
Cell[52485, 1198, 436, 15, 70, "Input",
 CellID->9166],
Cell[52924, 1215, 1345, 42, 74, "Output",
 CellID->405870650]
}, Open  ]],
Cell[CellGroupData[{
Cell[54306, 1262, 679, 23, 70, "Input",
 CellID->474463687],
Cell[54988, 1287, 3529, 62, 70, "Output",
 Evaluatable->False,
 CellID->373855439]
}, Open  ]],
Cell[58532, 1352, 125, 3, 70, "ExampleDelimiter",
 CellID->975206834],
Cell[58660, 1357, 383, 15, 70, "ExampleText",
 CellID->1861],
Cell[CellGroupData[{
Cell[59068, 1376, 400, 13, 70, "Input",
 CellID->28300],
Cell[59471, 1391, 649, 17, 246, "Output",
 CellID->11112818]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60169, 1414, 237, 7, 70, "ExampleSection",
 CellID->106929937],
Cell[60409, 1423, 192, 8, 70, "ExampleText",
 CellID->839798995],
Cell[CellGroupData[{
Cell[60626, 1435, 234, 8, 70, "Input",
 CellID->30649],
Cell[60863, 1445, 249, 8, 36, "Output",
 CellID->23644]
}, Open  ]],
Cell[CellGroupData[{
Cell[61149, 1458, 96, 3, 70, "Input",
 CellID->4237],
Cell[61248, 1463, 229, 7, 36, "Output",
 CellID->13082]
}, Open  ]],
Cell[61492, 1473, 124, 3, 70, "ExampleDelimiter",
 CellID->97224853],
Cell[61619, 1478, 460, 18, 70, "ExampleText",
 CellID->61991062],
Cell[CellGroupData[{
Cell[62104, 1500, 142, 4, 70, "Input",
 CellID->18976020],
Cell[62249, 1506, 410, 11, 70, "Output",
 Evaluatable->False,
 CellID->176485662]
}, Open  ]],
Cell[62674, 1520, 125, 3, 70, "ExampleDelimiter",
 CellID->153146229],
Cell[62802, 1525, 262, 9, 70, "ExampleText",
 CellID->103374168],
Cell[CellGroupData[{
Cell[63089, 1538, 312, 10, 70, "Input",
 CellID->308498953],
Cell[63404, 1550, 158, 5, 36, "Output",
 CellID->340647199]
}, Open  ]],
Cell[CellGroupData[{
Cell[63599, 1560, 312, 10, 70, "Input",
 CellID->371382927],
Cell[63914, 1572, 158, 5, 36, "Output",
 CellID->244488905]
}, Open  ]],
Cell[CellGroupData[{
Cell[64109, 1582, 273, 9, 70, "Input",
 CellID->315328687],
Cell[64385, 1593, 158, 5, 36, "Output",
 CellID->135908686]
}, Open  ]],
Cell[CellGroupData[{
Cell[64580, 1603, 408, 13, 70, "Input",
 CellID->472851597],
Cell[64991, 1618, 158, 5, 36, "Output",
 CellID->301931271]
}, Open  ]],
Cell[CellGroupData[{
Cell[65186, 1628, 263, 9, 70, "Input",
 CellID->83553751],
Cell[65452, 1639, 157, 5, 36, "Output",
 CellID->52774908]
}, Open  ]],
Cell[65624, 1647, 125, 3, 70, "ExampleDelimiter",
 CellID->267907408],
Cell[65752, 1652, 127, 3, 70, "ExampleText",
 CellID->256367966],
Cell[CellGroupData[{
Cell[65904, 1659, 476, 17, 70, "Input",
 CellID->148137403],
Cell[66383, 1678, 157, 5, 36, "Output",
 CellID->34205037]
}, Open  ]],
Cell[CellGroupData[{
Cell[66577, 1688, 240, 8, 70, "Input",
 CellID->21422930],
Cell[66820, 1698, 158, 5, 36, "Output",
 CellID->170996431]
}, Open  ]],
Cell[66993, 1706, 125, 3, 70, "ExampleDelimiter",
 CellID->120678922],
Cell[67121, 1711, 227, 8, 70, "ExampleText",
 CellID->700188291],
Cell[CellGroupData[{
Cell[67373, 1723, 442, 16, 70, "Input",
 CellID->328906545],
Cell[67818, 1741, 419, 16, 45, "Output",
 CellID->299328118]
}, Open  ]],
Cell[CellGroupData[{
Cell[68274, 1762, 408, 14, 70, "Input",
 CellID->81995068],
Cell[68685, 1778, 430, 15, 39, "Output",
 CellID->96844735]
}, Open  ]],
Cell[69130, 1796, 125, 3, 70, "ExampleDelimiter",
 CellID->104684567],
Cell[69258, 1801, 235, 8, 70, "ExampleText",
 CellID->86917634],
Cell[CellGroupData[{
Cell[69518, 1813, 711, 24, 70, "Input",
 CellID->437952509],
Cell[70232, 1839, 206, 7, 51, "Output",
 CellID->132868407]
}, Open  ]],
Cell[CellGroupData[{
Cell[70475, 1851, 717, 24, 70, "Input",
 CellID->4771096],
Cell[71195, 1877, 176, 5, 36, "Output",
 CellID->195013707]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71432, 1889, 310, 9, 70, "SeeAlsoSection",
 CellID->8091],
Cell[71745, 1900, 1907, 71, 70, "SeeAlso",
 CellID->25024]
}, Open  ]],
Cell[CellGroupData[{
Cell[73689, 1976, 314, 9, 70, "TutorialsSection",
 CellID->21989],
Cell[74006, 1987, 148, 3, 70, "Tutorials",
 CellID->13770],
Cell[74157, 1992, 156, 3, 70, "Tutorials",
 CellID->51756815]
}, Open  ]],
Cell[CellGroupData[{
Cell[74350, 2000, 319, 9, 70, "MoreAboutSection",
 CellID->594806575],
Cell[74672, 2011, 135, 3, 70, "MoreAbout",
 CellID->77177967],
Cell[74810, 2016, 134, 3, 70, "MoreAbout",
 CellID->7484483],
Cell[74947, 2021, 156, 3, 70, "MoreAbout",
 CellID->11369689],
Cell[75106, 2026, 149, 3, 70, "MoreAbout",
 CellID->212658404]
}, Open  ]],
Cell[75270, 2032, 52, 0, 70, "History"],
Cell[75325, 2034, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

