(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    167720,       3086]
NotebookOptionsPosition[    163906,       2965]
NotebookOutlinePosition[    165433,       3006]
CellTagsIndexPosition[    165346,       3001]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExclusionsStyle" :> 
          Documentation`HelpLookup["paclet:ref/ExclusionsStyle"], "MeshStyle" :> 
          Documentation`HelpLookup["paclet:ref/MeshStyle"], "FillingStyle" :> 
          Documentation`HelpLookup["paclet:ref/FillingStyle"], 
          "ClippingStyle" :> 
          Documentation`HelpLookup["paclet:ref/ClippingStyle"], "PlotStyle" :> 
          Documentation`HelpLookup["paclet:ref/PlotStyle"], "RegionFunction" :> 
          Documentation`HelpLookup["paclet:ref/RegionFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExclusionsStyle\"\>", 
       2->"\<\"MeshStyle\"\>", 3->"\<\"FillingStyle\"\>", 
       4->"\<\"ClippingStyle\"\>", 5->"\<\"PlotStyle\"\>", 
       6->"\<\"RegionFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Coordinates\"\>", 
       2->"\<\"Plotting Options\"\>", 
       3->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BoundaryStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["BoundaryStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
     "\[LineSeparator]is an option for plotting functions that specifies the \
style in which boundaries of regions should be drawn. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17318]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used: ", "Notes",
 CellID->20114],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "draw thin black boundary lines ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "draw no boundary lines ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["g", "TI"], Cell[
    "draw with specified graphics directives ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->31613],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " is always used at the boundary of regions defined by ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25374],

Cell[TextData[{
 "For 3D graphics, it is also used at the boundary of regions defined by ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6849]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1921825],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->220397011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412793891],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40782620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->870745220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " applies to intersections with the plot range:"
}], "ExampleText",
 CellID->19749176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1211919394],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyF2nvQpmMdB/ANkRm1HQxGMw45hFEohw7M/QxyNiQpptSYmCGndibFEOM0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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmwnYlmMWx5/neUNGElrIUGjsW8pQokUlQopCiRZrRZa02TPWqOymqGxD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         "]], PolygonBox[CompressedData["
1:eJwllElLllEYhs/7PjYazfOoZVlqZpZhIvpZFFkOZTRbkDQ7oaSVDT+iTZtW
EW1dFFREhUL1JwpauGkhNEhtu27uxQXX4TvvGZ7nPl9pz2DXQJ5SOgxFUBYp
DUF7llILnMRHYJxJJYxX4oNQga+DB/j9sE/BTvwclDN/ivVK8FF4x2974ALe
CVV4NXPa8A74yLgeKvDl8A8/AhvxxVDH3BrG+8N7aG2tWaO94Tvj54y34Mvg
A94Et/Be+Iz/Ys5mfAm811raAy+FAuv/ZnwTXxGee4pxI74LfiSfcR5+CL7g
TzPfNeBS8p1v4NW6M+Nuxtvwy9CAd0IR3gQTfFuAcnwWDDN/GtbjC8K1rIRr
+JXw3Da+34DvgzeZa6i7r4We5BqswYvDtVCPurQ2PM5d00J4T+01yfh6+Iw6
WwfMxvu1p3rD7934Jniduwc78APwid9+ssYcvDm8ljJThc+HZ/gT6MPH9Dvf
tmau9TGYyVxzzc3C2dI3LfjccO21x8FwzVVr9XAvvko9w1/B7nBmlJUXUBs+
g/Z+Cae1FnxN/ka9qwyfRT08Hs6EsvAXFuJ3ldfcPdkevrPuqp424EfhT+aa
t4czrOzqTq3hTClLmqPsKBPKgjKk3qnH6q16uCiccWX7beZaX1SPc9dcvTsR
Ppt6eCf8pvSWlKmt4R6qdzrzvXBNVAvVXFk/H35ryvzt8J7aS286x1fDt+QM
K5vKgHqvjC4Nvym9JZ1Jb+tqOIt6Y/q2LtwLrXEGPxuuvWr+CH8Y/i9Rpv4D
fchusw==
         "]]}]}, {}, {}, {}}, 
    {RGBColor[1, 0, 0], Thickness[Large], 
     LineBox[{643, 1, 540, 251, 16, 31, 46, 61, 76, 91, 751, 102, 111, 122, 
      137, 152, 167, 182, 365, 664, 197, 641, 402, 198, 199, 200, 201, 202, 
      203, 204, 205, 206, 207, 208, 209, 210, 367, 665, 211, 642, 403, 196, 
      181, 166, 151, 136, 121, 762, 110, 101, 90, 75, 60, 45, 30, 253, 644, 
      15, 625, 369, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 368, 643}], 
     LineBox[{840, 801, 843, 781, 845, 844, 846, 827, 828, 815, 872, 814, 829,
       808, 809, 834, 833, 776, 873, 789, 874, 875, 836, 883, 835, 777, 837, 
      811, 876, 890, 889, 817, 810, 788, 867, 850, 882, 849, 866, 848, 802, 
      785, 858, 859, 847, 797, 822, 796, 780, 839, 838, 892, 891, 790, 879, 
      793, 779, 816, 795, 794, 826, 842, 841, 840}], 
     LineBox[{881, 804, 893, 894, 878, 880, 877, 774, 830, 772, 868, 870, 869,
       787, 803, 786, 863, 861, 799, 860, 862, 784, 798, 783, 884, 885, 851, 
      769, 778, 812, 818, 852, 819, 856, 855, 853, 854, 791, 820, 821, 792, 
      770, 823, 771, 857, 813, 825, 824, 886, 800, 887, 864, 865, 806, 871, 
      805, 888, 782, 773, 807, 832, 831, 775, 881}]}},
   VertexColors->CompressedData["
1:eJztenlQzf/3f7aI7BRpl6WERFLkWEJZsmVPEiLaVJIsyZIUUXrby5IKIS2U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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->741762654,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}]}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->750011925],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8972690]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1661341882],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoundaryStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoundaryStyle"]], "InlineFormula"],
 " applies to boundaries formed by the ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->590632480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"BoundaryStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "<", 
       RowBox[{
        RowBox[{"y", "^", "2"}], "+", "1"}]}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1090674926],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1mctvVVUUhyuamDhg4EhMTEAqysDof7CPhhR5xAQifwAmOBAQwsC5DhmI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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmQv819MZx8/55X4n0dB0UXIpl6IQSsslKUpTpCJRLimR24RubrnV3C3m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         "]], 
        PolygonBox[{{174, 264, 54, 446}, {183, 284, 111, 470}, {511, 510, 233,
          234}, {525, 461, 171, 259}, {229, 223, 149, 454}, {484, 464, 238, 
         197}, {507, 462, 235, 231}, {528, 466, 177, 268}, {261, 195, 445, 
         44}, {174, 208, 173, 463}, {228, 207, 30, 440}, {204, 311, 182, 
         494}, {465, 514, 198, 176}, {216, 204, 494, 182}, {224, 228, 440, 
         30}, {218, 229, 454, 149}, {535, 496, 185, 300}, {226, 309, 166, 
         458}, {523, 442, 31, 253}, {456, 183, 470, 111}, {221, 210, 16, 
         439}, {532, 479, 54, 290}, {222, 218, 149, 455}, {194, 224, 459, 
         169}, {183, 215, 181, 471}, {530, 452, 111, 277}, {490, 511, 234, 
         202}, {284, 183, 471, 181}, {504, 174, 446, 54}, {311, 204, 493, 
         121}, {264, 174, 463, 173}, {444, 525, 259, 43}, {448, 528, 268, 
         72}, {515, 467, 537, 199}, {195, 503, 44, 445}, {204, 505, 121, 
         493}, {464, 512, 237, 238}, {462, 483, 196, 235}, {211, 195, 481, 
         172}, {485, 527, 266, 175}, {492, 530, 277, 184}, {474, 531, 286, 
         122}, {480, 532, 290, 171}, {531, 475, 184, 286}, {517, 468, 241, 
         240}, {519, 469, 244, 243}, {536, 497, 134, 313}, {524, 478, 170, 
         256}, {488, 521, 247, 248}, {477, 523, 253, 170}, {495, 535, 300, 
         121}, {195, 261, 172, 481}, {443, 524, 256, 44}, {469, 491, 203, 
         244}, {498, 536, 313, 185}}]}]}, {}, {}, {}}, 
    {RGBColor[1, 0, 0], Thickness[Large], 
     LineBox[{2, 1, 167, 221, 439, 16, 226, 166, 251, 441, 501, 442, 523, 477,
       460, 478, 524, 443, 503, 195, 211, 482, 533, 483, 462, 507, 508, 64, 
      527, 485, 212, 486, 514, 465, 176, 539, 538, 516, 487, 213, 468, 517, 
      94, 518, 510, 511, 490, 534, 489, 215, 183, 456, 452, 530, 492, 472, 
      475, 531, 474, 457, 453, 280, 186, 225, 135, 219, 190, 150, 151, 152, 
      153, 154, 155, 407, 156, 408, 422, 157, 427, 409, 158, 410, 159, 160, 
      161, 162, 163, 164, 191, 222, 455, 149, 223, 187, 304, 499, 506, 497, 
      536, 498, 473, 496, 535, 495, 505, 204, 216, 451, 529, 491, 469, 519, 
      520, 541, 522, 521, 488, 214, 450, 509, 178, 540, 537, 467, 515, 449, 
      209, 466, 528, 448, 72, 513, 512, 464, 484, 526, 447, 208, 174, 504, 
      479, 532, 480, 500, 461, 525, 444, 502, 476, 288, 169, 224, 30, 220, 
      193, 15, 14, 13, 12, 11, 10, 384, 9, 383, 8, 425, 382, 7, 381, 6, 5, 4, 
      3, 2}]}},
   VertexColors->CompressedData["
1:eJztWnk0lmu/RiIlTRJJqVRSGtVuUD+FNCAfDaiwk3YqX5NIRZEKlYadqdBs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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1816828154,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12788],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExclusionsStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExclusionsStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FillingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FillingStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClippingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClippingStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->614195827],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->154428082],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->70408376],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->259459046]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoundaryStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 29.7555936}", "context" -> "System`", 
    "keywords" -> {
     "boundary style", "surface boundary", "clip boundary ", 
      "plot range boundary", "region boundary", "set boundary", 
      "region edges", "edge style", "plot range edges", "surface edges", 
      "boundary lines", "boundary curves"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BoundaryStyle is an option for plotting functions that specifies the \
style in which boundaries of regions should be drawn. ", 
    "synonyms" -> {"boundary style"}, "title" -> "BoundaryStyle", "type" -> 
    "Symbol", "uri" -> "ref/BoundaryStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6955, 203, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1921825]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 165205, 2994}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2110, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2733, 73, 1578, 37, 70, "ObjectNameGrid"],
Cell[4314, 112, 504, 14, 70, "Usage",
 CellID->17318]
}, Open  ]],
Cell[CellGroupData[{
Cell[4855, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5333, 148, 69, 1, 70, "Notes",
 CellID->20114],
Cell[5405, 151, 892, 23, 70, "2ColumnTableMod",
 CellID->31613],
Cell[6300, 176, 369, 12, 70, "Notes",
 CellID->25374],
Cell[6672, 190, 246, 8, 70, "Notes",
 CellID->6849]
}, Closed]],
Cell[CellGroupData[{
Cell[6955, 203, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1921825],
Cell[CellGroupData[{
Cell[7338, 217, 148, 5, 70, "ExampleSection",
 CellID->220397011],
Cell[CellGroupData[{
Cell[7511, 226, 545, 17, 47, "Input",
 CellID->412793891],
Cell[8059, 245, 27259, 451, 159, "Output",
 Evaluatable->False,
 CellID->40782620]
}, Open  ]],
Cell[35333, 699, 125, 3, 70, "ExampleDelimiter",
 CellID->870745220],
Cell[35461, 704, 232, 7, 70, "ExampleText",
 CellID->19749176],
Cell[CellGroupData[{
Cell[35718, 715, 841, 28, 70, "Input",
 CellID->1211919394],
Cell[36562, 745, 60368, 1001, 204, 29108, 484, "CachedBoxData", "BoxData", \
"Output",
 CellID->741762654]
}, Open  ]],
Cell[CellGroupData[{
Cell[96967, 1751, 704, 22, 47, "Input",
 CellID->750011925],
Cell[97674, 1775, 15733, 262, 227, "Output",
 Evaluatable->False,
 CellID->8972690]
}, Open  ]],
Cell[113422, 2040, 126, 3, 70, "ExampleDelimiter",
 CellID->1661341882],
Cell[113551, 2045, 361, 12, 70, "ExampleText",
 CellID->590632480],
Cell[CellGroupData[{
Cell[113937, 2061, 790, 25, 70, "Input",
 CellID->1090674926],
Cell[114730, 2088, 46395, 769, 204, 17407, 289, "CachedBoxData", "BoxData", \
"Output",
 CellID->1816828154]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[161186, 2864, 311, 9, 70, "SeeAlsoSection",
 CellID->12788],
Cell[161500, 2875, 1479, 53, 70, "SeeAlso",
 CellID->27255]
}, Open  ]],
Cell[CellGroupData[{
Cell[163016, 2933, 319, 9, 70, "MoreAboutSection",
 CellID->614195827],
Cell[163338, 2944, 151, 3, 70, "MoreAbout",
 CellID->154428082],
Cell[163492, 2949, 142, 3, 70, "MoreAbout",
 CellID->70408376],
Cell[163637, 2954, 197, 4, 70, "MoreAbout",
 CellID->259459046]
}, Open  ]],
Cell[163849, 2961, 27, 0, 70, "History"],
Cell[163879, 2963, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

