(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52035,       1207]
NotebookOptionsPosition[     47807,       1068]
NotebookOutlinePosition[     49176,       1107]
CellTagsIndexPosition[     49090,       1102]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AxesStyle" :> Documentation`HelpLookup["paclet:ref/AxesStyle"],
           "Prolog" :> Documentation`HelpLookup["paclet:ref/Prolog"], 
          "Epilog" :> Documentation`HelpLookup["paclet:ref/Epilog"], 
          "DisplayFunction" :> 
          Documentation`HelpLookup["paclet:ref/DisplayFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AxesStyle\"\>", 2->"\<\"Prolog\"\>",
        3->"\<\"Epilog\"\>", 
       4->"\<\"DisplayFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Graphics Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxStyle", "ObjectName",
 CellID->30962],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["BoxStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BoxStyle"]], "InlineFormula"],
     "\[LineSeparator]is an option for three\[Hyphen]dimensional graphics \
functions which specifies how the bounding box should be rendered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoxStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxStyle"]], "InlineFormula"],
 " can be set to a list of graphics directives such as ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21428]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->328858063],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->70672879],

Cell["Use dashed lines for the bounding box:", "ExampleText",
 CellID->54309145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", "Dashed", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46897230],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  BoxStyle->Directive[
    Dashing[{Small, Small}]]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70822202,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8667],

Cell[TextData[{
 "Styles associated with lines can be used, combined by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->294989894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Orange", ",", "Thick"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91329484],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  BoxStyle->Directive[
    Dashing[{Small, Small}], 
    RGBColor[1, 0.5, 0], 
    Thickness[Large]]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->26322300,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27154],

Cell["In 3D, the axes are drawn on the bounding box edges:", "ExampleText",
 CellID->152787229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255148411],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->301316807,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->308656599],

Cell[TextData[{
 "Styles of the axes edges are not affected by ",
 Cell[BoxData[
  ButtonBox["BoxStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->49234431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Orange"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40045058],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  BoxStyle->Directive[
    Dashing[{Small, Small}], 
    RGBColor[1, 0.5, 0]]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->632064795,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139168143],

Cell[TextData[{
 "Styles of the axes edges can be specified by ",
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->100353459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Orange"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123972340],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesStyle->{
    RGBColor[1, 0, 0], 
    RGBColor[0, 1, 0], 
    RGBColor[0, 0, 1]},
  BoxStyle->Directive[
    Dashing[{Small, Small}], 
    RGBColor[1, 0.5, 0]]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->778566328,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23286],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prolog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prolog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Epilog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Epilog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DisplayFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DisplayFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14124],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->242403382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with BoxStyle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=BoxStyle"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->229535910],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->197636529]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 38.1464334}", "context" -> "System`", 
    "keywords" -> {
     "3D bounding box style", "style of specimen box", "box style", 
      "frame style", "3D frame style"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BoxStyle is an option for three-dimensional graphics functions which \
specifies how the bounding box should be rendered. ", 
    "synonyms" -> {"box style"}, "title" -> "BoxStyle", "type" -> "Symbol", 
    "uri" -> "ref/BoxStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4572, 150, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->328858063]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48947, 1095}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2115, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2738, 79, 46, 1, 70, "ObjectName",
 CellID->30962],
Cell[2787, 82, 504, 14, 70, "Usage",
 CellID->19990]
}, Open  ]],
Cell[CellGroupData[{
Cell[3328, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3806, 118, 729, 27, 70, "Notes",
 CellID->21428]
}, Closed]],
Cell[CellGroupData[{
Cell[4572, 150, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->328858063],
Cell[CellGroupData[{
Cell[4957, 164, 147, 5, 70, "ExampleSection",
 CellID->70672879],
Cell[5107, 171, 80, 1, 70, "ExampleText",
 CellID->54309145],
Cell[CellGroupData[{
Cell[5212, 176, 239, 7, 28, "Input",
 CellID->46897230],
Cell[5454, 185, 6954, 119, 184, 131, 3, "CachedBoxData", "BoxData", "Output",
 CellID->70822202]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12457, 310, 215, 7, 70, "ExampleSection",
 CellID->8667],
Cell[12675, 319, 239, 8, 70, "ExampleText",
 CellID->294989894],
Cell[CellGroupData[{
Cell[12939, 331, 287, 9, 70, "Input",
 CellID->91329484],
Cell[13229, 342, 7304, 126, 184, 180, 5, "CachedBoxData", "BoxData", "Output",
 
 CellID->26322300]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20582, 474, 233, 7, 70, "ExampleSection",
 CellID->27154],
Cell[20818, 483, 95, 1, 70, "ExampleText",
 CellID->152787229],
Cell[CellGroupData[{
Cell[20938, 488, 196, 6, 70, "Input",
 CellID->255148411],
Cell[21137, 496, 7352, 126, 194, 92, 2, "CachedBoxData", "BoxData", "Output",
 CellID->301316807]
}, Open  ]],
Cell[28504, 625, 125, 3, 70, "ExampleDelimiter",
 CellID->308656599],
Cell[28632, 630, 227, 8, 70, "ExampleText",
 CellID->49234431],
Cell[CellGroupData[{
Cell[28884, 642, 316, 9, 70, "Input",
 CellID->40045058],
Cell[29203, 653, 7174, 124, 194, 171, 5, "CachedBoxData", "BoxData", "Output",
 
 CellID->632064795]
}, Open  ]],
Cell[36392, 780, 125, 3, 70, "ExampleDelimiter",
 CellID->139168143],
Cell[36520, 785, 230, 8, 70, "ExampleText",
 CellID->100353459],
Cell[CellGroupData[{
Cell[36775, 797, 435, 12, 70, "Input",
 CellID->123972340],
Cell[37213, 811, 7440, 131, 194, 258, 9, "CachedBoxData", "BoxData", "Output",
 
 CellID->778566328]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44714, 949, 311, 9, 70, "SeeAlsoSection",
 CellID->23286],
Cell[45028, 960, 948, 35, 70, "SeeAlso",
 CellID->6535]
}, Open  ]],
Cell[CellGroupData[{
Cell[46013, 1000, 314, 9, 70, "TutorialsSection",
 CellID->14124],
Cell[46330, 1011, 192, 4, 70, "Tutorials",
 CellID->242403382]
}, Open  ]],
Cell[CellGroupData[{
Cell[46559, 1020, 305, 8, 70, "RelatedLinksSection"],
Cell[46867, 1030, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47265, 1047, 319, 9, 70, "MoreAboutSection",
 CellID->229535910],
Cell[47587, 1058, 148, 3, 70, "MoreAbout",
 CellID->197636529]
}, Open  ]],
Cell[47750, 1064, 27, 0, 70, "History"],
Cell[47780, 1066, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

