(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59901,       1359]
NotebookOptionsPosition[     55135,       1205]
NotebookOutlinePosition[     56495,       1243]
CellTagsIndexPosition[     56409,       1238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxRatios" :> Documentation`HelpLookup["paclet:ref/BoxRatios"],
           "BoxStyle" :> Documentation`HelpLookup["paclet:ref/BoxStyle"], 
          "Axes" :> Documentation`HelpLookup["paclet:ref/Axes"], "Frame" :> 
          Documentation`HelpLookup["paclet:ref/Frame"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxRatios\"\>", 2->"\<\"BoxStyle\"\>", 
       3->"\<\"Axes\"\>", 4->"\<\"Frame\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsOptionsAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Options & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Boxed", "ObjectName",
 CellID->1491],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Boxed",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Boxed"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " which specifies whether to draw the edges of the bounding box in a \
three\[Hyphen]dimensional picture. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18811]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Boxed", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " draws the box; ",
 Cell[BoxData[
  RowBox[{"Boxed", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " does not. "
}], "Notes",
 CellID->28414]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->508505077],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->271087134],

Cell["Draw the edges of the bounding box:", "ExampleText",
 CellID->780919887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154799522],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Boxed->True]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2315076,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4789136],

Cell["Do not draw the edges of the bounding box:", "ExampleText",
 CellID->18544491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3842994],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Boxed->False]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->238633515,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47691833],

Cell[TextData[{
 "Specify the style of the bounding box, using ",
 Cell[BoxData[
  ButtonBox["BoxStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->298957902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", "Dashed", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->543719544],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  BoxStyle->Directive[
    Dashing[{Small, Small}]]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->454142400,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32112],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoxRatios",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxRatios"]], "InlineFormula"],
 " specifies the ratios between the bounding box edges:"
}], "ExampleText",
 CellID->65064329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300782528],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  BoxRatios->{1, 2, 3}]], "Output",
 ImageSize->{121, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->213280711,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59886176],

Cell["In 3D, the axes are drawn on the bounding box edges:", "ExampleText",
 CellID->152787229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255148411],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->301316807,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->308656599],

Cell[TextData[{
 "Styles of the axes edges are not affected by ",
 Cell[BoxData[
  ButtonBox["BoxStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->49234431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Orange"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40045058],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  BoxStyle->Directive[
    Dashing[{Small, Small}], 
    RGBColor[1, 0.5, 0]]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->632064795,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnQlwVdUZxy9ZZRUSQEBRVGRc5iYBXIoboqNoMYmsYVNBQdaQEAIBkryX
91Dcd0TEXSFaW9va2m3amc502qndW2vVqlWrtWqt1hVRudOe853lnvOdc+47
7yWZjs6Q5L137/fO/3fPPff7/ufca+3S1pXLG5e2rrp86bjpLUubV666fMO4
85payFvF/YIg2En+PT4qIH//l/wF/3ZGUUQ+UH4uJj+LyUdF9BX9I4L/giLy
Zw1scTH6pJj+KIlfB0H1l2I7qpSqKuO/awwW0/knxUrEgLIh/86Fv88zYpej
bx+OXp/guV8F/2748igV5LPvUHVf3uzQsW8p33YoP+6TErZTv2Mw3+8ghjgl
3j9eI1fOfw/k0ftbt17IPx0E3yo/JX8cB59PthyHiPfJQy1aIU5pHAdCBcfC
BpMMZSXGO4fw9oxArZ3gHWEEb9U07z0q+Xee7b2HOGL4TD3LO8IQC7tRSHMJ
en20dkTEuTOIt2Ws196id+CWH4q2LkWvj4K9x0Xus/JQ3o4j0Z5l6DV8Hhxh
EMFn0ggej/bfQeT3qbDZGPKT7sYaqOxu7F9pIUyZlNP3Bj1xavbJM7I/nJr9
8dnbfnrutp9N3/aLr2576sLsb+qzv5+V/dOc7DMN2TKy4YmerR3Gv61UtG/0
zurM7prsfTXZhyZmuydlHzsx+/gpWZ+vfW5B9oXF2Zcuyb6yNPva5dl/XJGB
L5roaIkYRYZZ+qQ4NsG47WHm+jBzc1Xm9urMndWZu2uy99dkH2YtOymPlv1V
b9mbKzNvr8m805gp4UdKPdJHJLRYZWc7F4rEe8dtDrs6w65s2OUj4Xsg4ScF
SXivuev9lq4PN3Z93NZFW0HGrQFI0eHaWYBHWHEkghOawnRrmN4iWn61o+WP
QMu/2ast37c1TVtuuz6w1g+x9JOIj+iHRfrYElQvD1NrwlSz0JPKS89Zvnr+
rut519DzWTr1eSYVCOqqqrGg6mCkxsw8RuOjNHlR2LkkTF1BFaaJwo1IYVXv
K/ynVeEWUJiiCr/Y1hlt7wSdx0Czy/l4UpJT30iuD/hMIX/MDDvmhZ1E5FJd
5FYQuS2nyK/0QORqi8hPO9L7FZHRNR3R9R30QIz3PILDozjvgSM4ZWbYPgtU
LhYq14bp9YbKG6oyt1RldlRndlVn7qnJPpCvynmJKpu6/kNUttpUXgUqr+uI
bmyHY3qUp9IKfizhDJ5K/qgLt14UtjO5DULuCl1uGuRe0xtyn0Vyl1O5bxly
P9HkplS50c3t0W1b5aCunK+HejI4mDPAmSecCdOAyZZ6A8tlCpZNAsuViVi+
Dli+44llUS4smwBLO2DpolgOGFiiHVtsZMbI8Vkdg8VryKzPIX/UhpsV6R1M
+sUgfWWYahTS23sovdYu/WWH9A+EdKJHk351J5V+A0i/lUqPdm62qR8N6o/m
4x2oPRfUttWGW5Dg+SD4ciG4xUPwHlXwafkIXkIFv24T/JG34OiutkBec7Hm
I/kRhnNiOmjeRA4ykj0bZF+iy24D2V09lz3TLXsFlf2vtSB7vS67M/UZkZ21
yb4dZO9qi+7eFIjqBHJBUfEG54PSjXCAmditVrGrHGJvrMrcWpW5ozpzlyp2
ch+I3WwTey2IvQmLje7dyLQexscvOpYHF9SGrXBU7VoXgNZloHWd0NohtF6r
ac3em7/WP+fQmlG17iNjV2eaa73SpvUO0Lqbag141sgqM6qX1l3BDDi2Tslz
QPKliuQNiuSrckn+Vm9J3uAh+RZVchuRHN3fajuXR0oKJbwaCy4EChuSQSw0
QGwGEJlEEI8WDOIyDcS/EYitAIJk2wzEdgBxfYcCYku0azMFcQ8FceDBFjsH
URPZqgxc/8EZUlsbrk9mNRdYLQk7SU2yOkw1cVZdXqxOzo/Vi8DqVWD1RmGs
yGWesLozZhU92GLrN+B0setdYj6EPCQSAEbROuhjDN1GA127QNcJ6FISXSug
63Sje9AH3YUc3R8T0K0CdOsy7zF0Gzk6WdRp6G7U0d1F0G2K7iPoNhx4uJnl
R8JhwXmhSaw4Ut2qmDj1T4N6T26LErldF2ZuqsrcVpXZ2Zfc3ufcuizcrtG5
7bBwC3j169PLrFQVdhChvjZcZ2Wn5uN67ZlSLZHeZDcf2F0s2C2zsDONBLUC
haxcZ3c3sHuAsFt/YO+6gtnBNeAi6GdNtWELwlVn4Fqsl+oqru19hStLcL0p
cTV74mq343qI4uoRrZkKrdYEWg0GrY2K34Zo7dZpfSMXrd8RWrPzpkUq4ZgW
KvmUMoCliJKWrRKqkFdQtQ7EDpDCq1nnhSsHtTi2ul3bw4yV116D149y8Xoe
eP0NeL0mea0RvFp0Xi7nQPLapfPa0+TmNRrxwT4hvJ5ZG67VebW5eF2smwnS
UuoTXpcKXldQXm+bvKTTElsKznoLclTCq4XzwjNB0HP4bFPMC88PlnFejQov
e2ImC/IEXswvLoDXr3uLl6xPUcm2m/GiqSzh9WH3akYGfgp335gZY1xyJKyz
bVw2KVxUH51xua+3ucSzA8Kxi+2KrIOLXuswLh93r1G4GNm7L48FuoOh8thm
8oDpswcn+vGo8+Xxro2HxcfQaj8tjSc51b69a1E/qeQc7JmRWf1eYhhYPhy+
li+HhZwDnTVaBrMsCgfVstQ4uGpgrZyhueV+wgGPtEOs/WQw2qqoN3iljYmM
vHj9Uuf1F+D1AuIl52xMn7PT4GWWf3ou/sXexh7yaspZtaimgmmQmhM/cpq6
j3h9JC1x02NJ4CXzbzyPOdjKCyjOVVeeWNNuo8LDBow0GtPK9FFPWc31YGVa
cKa1YNZ5evLtYNU/cq/boNlBsfBk57A9a8NV1iyclXjIVjBtvHZ9MsoO78T8
4S0W8MwZOE94rkKP5pbr2HgOBM21HqWx88LYweqyWbXhGiP/xvWKnIhd4iB1
pQ+pKX1ASjpYpp0gazyzatnTxEjREalEOFq+xGbrGaUktsWshxcZbp91ukPO
XluJff9MQmybPzE5u/uWSmyDOg9gEEuoW0Qe/kH3Kljblmf/mu3Ov620UohW
Ry5a3b1Hy2KrWz0EKy09C/+IZOF47c0ABz2xngPXxxUxP2teiv0Ek99mG78d
yloJJ79zcvN7ycbPdJg1frJKNqs+jV/zJyRbz4ef6fiZHNflzO8NXyY2TNW5
rJwcv+vH8TkfjqrdbLoN1qpHyfI/Jdktrv/6a1dUsQYMz3NUYmrO7NbqZqnU
pD0vp3YLo/a0ldpyhZpm0mOPxl0r4prgM5LjgntFoLFeN5JTGu5NZbabCpq0
QFQe7hsqzIKXztV+FxU5SSYrpTjzX8d6DaEySFKx9ZmErNXpLDQb9rqc0pHL
ARCdb3vSaRB01HUvK3LRUX0XXEc68vxDrFRg/JlbG64sGMxGTzCT+gRMkiGl
grEWQJDUw5BNek2Fdi5Bb5lTG6724SJLaGTRqRMM6hyghcsphXN5HXFp1rhY
DClUGNrz9aaE/jLH8HmdpbJqLSAucioBcXlA4fI443J6X3GxFMxqEWjLzgeh
KxZc8/kdFWi0mevIxnNwanRY4n3LyTbxYjGurMWyyknk5NTrxazKJSt5vXIy
qsPVsGYlNBp2r5w2QMuWeovRG4UxullhFNctrYwR9X3djBz9aX1yvWI6B8gC
tbHKqqwe63VWLTErMKp0VmpV7KpaqCecLytXTq3VJqbLguxidTpKXfrSQ1Yv
K6zwJF6ryiqdxEqtUJTMmvrGIw02gbiu+bJRXQKVjWrfudg84s3mDyabJRqb
txEbMDwtPhSqfmM2Wv78OcmfGRtRXdjuvitBY5RXpYF8Aqvdeb2x0KBwXmId
eW5eVt/O5KVWaSKzprkj41VmVLfmnXeYpehvCb66Vqkhfhvy4ndSEr+ndH7P
IH6XafzeEfz0Nappi9tyg86PVyZ67u3Pz1rpzlMc4zyKXWTspfXZL3W2GCM8
tRCEryKEYg7MidBuFNizdPvI3xOia3pIlNkHCUT3+BO9yE10WRJRm4XlKJeN
/B7PgJXlRVSOjQ25agFL7SjtK2QDxjOzbpJPFE4Sz1O7SdqMB7WCpCTjioC6
z7h/5kfT6J8NuSoHF9W0MAU1c1Wbv+1Vqnj2vwlTVRZuOepytf7kdZZwqe1U
xXVbrN2yXnNyEmy3ehqmQfh/ILi+ZwRJBQY+P/Wp2fpn/KwGIFQmspqYUBHh
E9TXOarTZEJogk2uCVRv6kxKbAihWYmE0GzuBp1QyiCEPA6tRuU1BXWgGaFK
RAiIDUjOk4sIn2AGqt9NwzAvQk/6E1rkQUixmu0ukFmhiqqLVRLUbe4rQqpD
Zk6i9QqhFxVClhUBirGq+WTID8J1qVZPUOc5gVCDO/dFNTv3N6xeGfNWkwix
u5VyEfqtDyF9avZDF6HtvoRoBoyzjVJJTGYS8xNdaKfB4YKF5sL4sqVehaXM
/NMZsSR70YSFylOlXHCzMsbwc/wc6riYV9ct9R2z+OZ1fcGyPvevWfgBnbkJ
KjE00++I58S05SUJPcygNk3JWT1LeovtaJ0pQ9QeFTcR+lN7VlK7FFNjc6+M
GuM1Qt4NTajlqOzNsmpPk4NahW0kW+CZk1qpqaZan1NbGlMjyszpItWGxNCs
taheOVFne7jkRMcvGP+n+PNhNSUzOkzTMWtMpMk1Jb3C55WlWTjkwVjr5Ehs
PKZTZCsLHbOuVPJ26mkPz9WL1vc1pb29Qek1tO7BbmZzThZHw6waleyc+tkJ
nCbrmZWXQ6Hajrrd7+A0MTennxuc2MgzHoNabgOlPrFBWD90sDGNCksZw5P0
/XvXJnAqRRloQGqYNrpy0F7oIVDMylFBXecN6gcI1AUaKKKS3QP/vMLJsvjB
5WqDoWO3IYzJJJaqf763EY/m4DZIL9u1PlWOYGVmNg8V4fg6R81s9RmtKHd5
o4TedQI+N10oV1hQ4oWqyZUzrnpcGStjad5pV268AzPnxyt5v6UyUqtrD5bx
dJ3K8iEXy2mMYii75a8KYqku+v3UytKcB/bK/v1ZgnM+MNH/pjgDqDRrZaVp
+ozSAy+MJzrNrTxfUHiaiw9y+2IEj6zIzWpKnU/oOc8E9zvmOdLGM23OKSTw
pCtrgslOkjMMkvMdJGGK9J11Ft+Wuz9o5Q9h46pL1fx3uIOcWPcq7nKH8fHY
xLoBl/NW06zNNnuasxsOpsP1hGf1mxxUNi5PW/N9VFeD4MlRUVFbuzKBjjZj
arsyj/XLh3k977AYLXN/0PEPIl82+KGnI/o7ODzZf87hWriro4+6V1dqV1DX
elTQO9pTr1x0YBqGUi8EZ0l6EBCZweHkBzz5cozpDltqZlz9mRMX3CBm+obZ
9Iw0/eEEb8HUA5yIgGImgaqYIFSMTGq5qwSLk2dq3OIxkD3eUjwhGMa5Cj8F
HVIBs9+KeMurSWvhOFQ6G0mufKQBuJE8caXeqbuV+GmswVD/jJ/V17SdJ4s2
DrU07TZond40lit+YeaKCS0rUVtWRJPscmvLINxppEXw/MAhlryVfJuWt/IE
wa8t0CvLhEsYp1aQ8ZepzQngAaNnCTYDLdkeylAqtd4Dqsut3ho0E56TLXT2
T7pSV7qVDICriRafhGYyyKYX0BOmP93Hde1isfGz/kTbGyGY3nba3hmi3eU0
JEGOnI0Ka1R4ijM9m8vQBZBsUk9bSh/8S4dPElBEo06A9T5LiC7P0jI0bpL3
Z9KI9AHBdLRKBWy02te9xh1Nbesg3laYLSxVxwAqezaNDfcDscGErZbyi6yf
DfSBQ3NpNDqkyVPeLxLMXZKN2NYsIm1dA41Ht+MzC+xo8ASP/2d76hM9Y8ST
TGncg3ncJn79mC/jshXP7CkFOJJ5pVfvPmNn1XAeeRWPvECNnAryi1zMYgbi
nCNx1/C4C0Vcun2Kn0MecbWMTbn2yHgfdK+m8fDccj/P+NrKMCX+IrW9NMku
ML6Y1a4oKL54ynOgRBJPdB2WIyL0Gbk6dwjaejHaGj9pi92LkvRkMrVtgwuK
nvu5N2JtysAc8fFTTth9R/k9/UrdYoAXW7/nkBUH4v8n4I5HI/Ujze8Hv/1i
m6tRyvrgW8oj5UnJSuwFKDa+l7rI+C78jJ4B6LtL8/wGNrcxTomq7t2A9sZ3
+LEhWDxNFH/3PLQ3G7ePjtDdk3zrudatxzu2no22Ztd98f+HsLl66plWjKLN
RNGGqjrJuMjYj7EeV/w9RSh2Hc8t4FnS/FiyV/ncyVzEe1AtaukIpYfkaqHo
UVqLUWvP562lcUsS4govQF1vRH9PR+0bk7C/+ewkvV003jm8PUN5e/prx1nU
nmI0F9ehqXyvwZw5u07WKFvRr5rCc2GxFetxE6P4qe3092S+Ff1m2iXYnegT
LD0tiuK8A+c19GXII+GrFHt+2TEGo+SVxAHXTTcYTyKXinGGBB7nHVEQE2dH
xMd9mmiOIlHLLO090ju66B04Aj26ozhTelSP9Y4oRlL87Kh67wjyKsLfmcCZ
1WjHVW95TPwI3ldOgden863G8nenwLtnRnE2RCNPhXcnWXqMGDOKIzVDiFXh
fOysSPRQj7Ncy1BFz5juGUGcz8Zor7w+3zNWKf/uesf2YixZmPC5Gm+BxlOM
AezdMyJ3rlUvj07y1bruS7HdGZHeU5k68//xFfT7HxeQQgg=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139168143],

Cell[TextData[{
 "Styles of the axes edges can be specified by ",
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->100353459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Orange"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123972340],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesStyle->{
    RGBColor[1, 0, 0], 
    RGBColor[0, 1, 0], 
    RGBColor[0, 0, 1]},
  BoxStyle->Directive[
    Dashing[{Small, Small}], 
    RGBColor[1, 0.5, 0]]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->778566328,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32764],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxRatios",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoxRatios"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoxStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26299]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8753],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->242403382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->268012909],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->513142649],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->21330272]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Boxed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 34.5213406}", "context" -> "System`", 
    "keywords" -> {
     "3D bounding box", "3D scene box", "3D graphics box", "3D frame", 
      "3D axis", "3D axes", "specimen box"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Boxed is an option for Graphics3D which specifies whether to draw the \
edges of the bounding box in a three-dimensional picture. ", "synonyms" -> {},
     "title" -> "Boxed", "type" -> "Symbol", "uri" -> "ref/Boxed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4473, 143, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->508505077]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56266, 1231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2240, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2863, 80, 42, 1, 70, "ObjectName",
 CellID->1491],
Cell[2908, 83, 647, 19, 70, "Usage",
 CellID->18811]
}, Open  ]],
Cell[CellGroupData[{
Cell[3592, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4070, 124, 366, 14, 70, "Notes",
 CellID->28414]
}, Closed]],
Cell[CellGroupData[{
Cell[4473, 143, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->508505077],
Cell[CellGroupData[{
Cell[4858, 157, 148, 5, 70, "ExampleSection",
 CellID->271087134],
Cell[5009, 164, 78, 1, 70, "ExampleText",
 CellID->780919887],
Cell[CellGroupData[{
Cell[5112, 169, 197, 6, 28, "Input",
 CellID->154799522],
Cell[5312, 177, 4813, 84, 129, 93, 2, "CachedBoxData", "BoxData", "Output",
 CellID->2315076]
}, Open  ]],
Cell[10140, 264, 123, 3, 70, "ExampleDelimiter",
 CellID->4789136],
Cell[10266, 269, 84, 1, 70, "ExampleText",
 CellID->18544491],
Cell[CellGroupData[{
Cell[10375, 274, 196, 6, 70, "Input",
 CellID->3842994],
Cell[10574, 282, 3881, 69, 129, 94, 2, "CachedBoxData", "BoxData", "Output",
 CellID->238633515]
}, Open  ]],
Cell[14470, 354, 124, 3, 70, "ExampleDelimiter",
 CellID->47691833],
Cell[14597, 359, 228, 8, 70, "ExampleText",
 CellID->298957902],
Cell[CellGroupData[{
Cell[14850, 371, 240, 7, 70, "Input",
 CellID->543719544],
Cell[15093, 380, 4654, 82, 129, 131, 3, "CachedBoxData", "BoxData", "Output",
 CellID->454142400]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19796, 468, 233, 7, 70, "ExampleSection",
 CellID->32112],
Cell[20032, 477, 231, 7, 70, "ExampleText",
 CellID->65064329],
Cell[CellGroupData[{
Cell[20288, 488, 259, 8, 70, "Input",
 CellID->300782528],
Cell[20550, 498, 8015, 136, 237, 102, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->213280711]
}, Open  ]],
Cell[28580, 637, 124, 3, 70, "ExampleDelimiter",
 CellID->59886176],
Cell[28707, 642, 95, 1, 70, "ExampleText",
 CellID->152787229],
Cell[CellGroupData[{
Cell[28827, 647, 196, 6, 70, "Input",
 CellID->255148411],
Cell[29026, 655, 7352, 126, 194, 92, 2, "CachedBoxData", "BoxData", "Output",
 CellID->301316807]
}, Open  ]],
Cell[36393, 784, 125, 3, 70, "ExampleDelimiter",
 CellID->308656599],
Cell[36521, 789, 227, 8, 70, "ExampleText",
 CellID->49234431],
Cell[CellGroupData[{
Cell[36773, 801, 316, 9, 70, "Input",
 CellID->40045058],
Cell[37092, 812, 7174, 124, 194, 171, 5, "CachedBoxData", "BoxData", "Output",
 
 CellID->632064795]
}, Open  ]],
Cell[44281, 939, 125, 3, 70, "ExampleDelimiter",
 CellID->139168143],
Cell[44409, 944, 230, 8, 70, "ExampleText",
 CellID->100353459],
Cell[CellGroupData[{
Cell[44664, 956, 435, 12, 70, "Input",
 CellID->123972340],
Cell[45102, 970, 7440, 131, 194, 258, 9, "CachedBoxData", "BoxData", "Output",
 
 CellID->778566328]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52603, 1108, 311, 9, 70, "SeeAlsoSection",
 CellID->32764],
Cell[52917, 1119, 929, 35, 70, "SeeAlso",
 CellID->26299]
}, Open  ]],
Cell[CellGroupData[{
Cell[53883, 1159, 313, 9, 70, "TutorialsSection",
 CellID->8753],
Cell[54199, 1170, 192, 4, 70, "Tutorials",
 CellID->242403382]
}, Open  ]],
Cell[CellGroupData[{
Cell[54428, 1179, 319, 9, 70, "MoreAboutSection",
 CellID->268012909],
Cell[54750, 1190, 148, 3, 70, "MoreAbout",
 CellID->513142649],
Cell[54901, 1195, 162, 3, 70, "MoreAbout",
 CellID->21330272]
}, Open  ]],
Cell[55078, 1201, 27, 0, 70, "History"],
Cell[55108, 1203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

