(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27769,       1020]
NotebookOptionsPosition[     22419,        835]
NotebookOutlinePosition[     23735,        872]
CellTagsIndexPosition[     23650,        867]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CanberraDistance" :> 
          Documentation`HelpLookup["paclet:ref/CanberraDistance"], 
          "EuclideanDistance" :> 
          Documentation`HelpLookup["paclet:ref/EuclideanDistance"], 
          "ManhattanDistance" :> 
          Documentation`HelpLookup["paclet:ref/ManhattanDistance"], 
          "ChebyshevDistance" :> 
          Documentation`HelpLookup["paclet:ref/ChebyshevDistance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CanberraDistance\"\>", 
       2->"\<\"EuclideanDistance\"\>", 3->"\<\"ManhattanDistance\"\>", 
       4->"\<\"ChebyshevDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BrayCurtisDistance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BrayCurtisDistance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BrayCurtisDistance"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Bray\[Hyphen]Curtis distance between vectors \
",
     Cell[BoxData[
      FormBox["u", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BrayCurtisDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BrayCurtisDistance"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Total",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Total"], "[", 
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     RowBox[{
      StyleBox["u", "TI"], "-", 
      StyleBox["v", "TI"]}], "]"}], "]"}], "/", 
   RowBox[{
    ButtonBox["Total",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Total"], "[", 
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     RowBox[{
      StyleBox["u", "TI"], "+", 
      StyleBox["v", "TI"]}], "]"}], "]"}]}]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->709349618,
  ButtonNote->"709349618"]
}], "Notes",
 CellID->24221]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->83676283],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->502459622],

Cell["\<\
Bray\[Hyphen]Curtis distance between two vectors:\
\>", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BrayCurtisDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196650888],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "+", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "+", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "+", "z"}], "]"}]}]]], "Output",
 ImageSize->{219, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48924475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125461358],

Cell["\<\
Bray\[Hyphen]Curtis distance between numeric vectors:\
\>", "ExampleText",
 CellID->319587507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BrayCurtisDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190454384],

Cell[BoxData[
 FractionBox["1", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153397445]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5030],

Cell["Compute distance between any vectors of equal length:", "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BrayCurtisDistance", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData["0.3260680817512208`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325082601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell["Compute distance between vectors of any precision:", "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BrayCurtisDistance", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "10"}], "}"}], ",", 
     "50"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "15", ",", "20", ",", "5", ",", "5"}], "}"}], ",", 
     "50"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData["0.\
5428571428571428571428571428571428571428571428571428571428571428571`49.\
54635984112986"], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38875978]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25547],

Cell["\<\
Cluster data using Bray\[Hyphen]Curtis distance:\
\>", "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "BrayCurtisDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->569532092]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21153],

Cell["\<\
Bray\[Hyphen]Curtis distance is a ratio of sums of absolute differences and \
sums:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->709349618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BrayCurtisDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418619957],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "+", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "+", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "+", "z"}], "]"}]}]]], "Output",
 ImageSize->{219, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->379632072]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "-", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}], "/", 
  RowBox[{"Total", "[", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "+", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->290219153],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "+", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "+", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "+", "z"}], "]"}]}]]], "Output",
 ImageSize->{219, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3839626]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->533993557],

Cell["\<\
Bray\[Hyphen]Curtis distance is equivalent to a ratio of norms:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->214729278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BrayCurtisDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218507111],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "+", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "+", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "+", "z"}], "]"}]}]]], "Output",
 ImageSize->{219, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87668376]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "-", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", "1"}], "]"}], "/", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "+", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", "1"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21346996],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "+", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "+", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "+", "z"}], "]"}]}]]], "Output",
 ImageSize->{219, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50400614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->604768347],

Cell["\<\
Bray\[Hyphen]Curtis distance is a ratio of Manhattan distances:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->116722353],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->658943477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BrayCurtisDistance", "[", 
  RowBox[{"u", ",", "v"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->378344330],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "+", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "+", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "+", "z"}], "]"}]}]]], "Output",
 ImageSize->{219, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->498839408]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ManhattanDistance", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "/", 
  RowBox[{"ManhattanDistance", "[", 
   RowBox[{"u", ",", 
    RowBox[{"-", "v"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->281060260],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "-", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "-", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "-", "z"}], "]"}]}], 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "+", "x"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"b", "+", "y"}], "]"}], "+", 
   RowBox[{"Abs", "[", 
    RowBox[{"c", "+", "z"}], "]"}]}]]], "Output",
 ImageSize->{219, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->749891315]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10195],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CanberraDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CanberraDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EuclideanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EuclideanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ManhattanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ManhattanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChebyshevDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevDistance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->123],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with BrayCurtisDistance",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
BrayCurtisDistance"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->103274201]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BrayCurtisDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 43.0840598}", "context" -> "System`", 
    "keywords" -> {"Bray Curtis distance", "Bray\\[Hyphen]Curtis distance"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BrayCurtisDistance[u, v] gives the Bray-Curtis distance between vectors \
u and v.", "synonyms" -> {"bray curtis distance"}, "title" -> 
    "BrayCurtisDistance", "type" -> "Symbol", "uri" -> 
    "ref/BrayCurtisDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6839, 213, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->83676283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23508, 860}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2271, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2894, 83, 1583, 37, 70, "ObjectNameGrid"],
Cell[4480, 122, 740, 24, 70, "Usage",
 CellID->9758]
}, Open  ]],
Cell[CellGroupData[{
Cell[5257, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5735, 168, 1067, 40, 70, "Notes",
 CellID->24221]
}, Closed]],
Cell[CellGroupData[{
Cell[6839, 213, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->83676283],
Cell[CellGroupData[{
Cell[7223, 227, 148, 5, 70, "ExampleSection",
 CellID->502459622],
Cell[7374, 234, 100, 3, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[7499, 241, 255, 8, 28, "Input",
 CellID->196650888],
Cell[7757, 251, 580, 20, 53, "Output",
 CellID->48924475]
}, Open  ]],
Cell[8352, 274, 125, 3, 70, "ExampleDelimiter",
 CellID->125461358],
Cell[8480, 279, 104, 3, 70, "ExampleText",
 CellID->319587507],
Cell[CellGroupData[{
Cell[8609, 286, 255, 8, 70, "Input",
 CellID->190454384],
Cell[8867, 296, 178, 6, 51, "Output",
 CellID->153397445]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9094, 308, 215, 7, 70, "ExampleSection",
 CellID->5030],
Cell[9312, 317, 95, 1, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[9432, 322, 267, 8, 70, "Input",
 CellID->488208944],
Cell[9702, 332, 176, 5, 36, "Output",
 CellID->325082601]
}, Open  ]],
Cell[9893, 340, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[10021, 345, 92, 1, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[10138, 350, 428, 14, 70, "Input",
 CellID->323525768],
Cell[10569, 366, 248, 7, 36, "Output",
 CellID->38875978]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10866, 379, 223, 7, 70, "ExampleSection",
 CellID->25547],
Cell[11092, 388, 99, 3, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[11216, 395, 478, 16, 70, "Input",
 CellID->108189764],
Cell[11697, 413, 515, 19, 36, "Output",
 CellID->569532092]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12261, 438, 233, 7, 70, "ExampleSection",
 CellID->21153],
Cell[12497, 447, 182, 5, 70, "ExampleText",
 CellID->709349618],
Cell[CellGroupData[{
Cell[12704, 456, 255, 8, 70, "Input",
 CellID->418619957],
Cell[12962, 466, 581, 20, 53, "Output",
 CellID->379632072]
}, Open  ]],
Cell[CellGroupData[{
Cell[13580, 491, 520, 17, 70, "Input",
 CellID->290219153],
Cell[14103, 510, 579, 20, 53, "Output",
 CellID->3839626]
}, Open  ]],
Cell[14697, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->533993557],
Cell[14825, 538, 162, 4, 70, "ExampleText",
 CellID->214729278],
Cell[CellGroupData[{
Cell[15012, 546, 255, 8, 70, "Input",
 CellID->218507111],
Cell[15270, 556, 580, 20, 53, "Output",
 CellID->87668376]
}, Open  ]],
Cell[CellGroupData[{
Cell[15887, 581, 507, 18, 70, "Input",
 CellID->21346996],
Cell[16397, 601, 580, 20, 53, "Output",
 CellID->50400614]
}, Open  ]],
Cell[16992, 624, 125, 3, 70, "ExampleDelimiter",
 CellID->604768347],
Cell[17120, 629, 162, 4, 70, "ExampleText",
 CellID->116722353],
Cell[17285, 635, 281, 10, 70, "Input",
 CellID->658943477],
Cell[CellGroupData[{
Cell[17591, 649, 137, 4, 70, "Input",
 CellID->378344330],
Cell[17731, 655, 581, 20, 53, "Output",
 CellID->498839408]
}, Open  ]],
Cell[CellGroupData[{
Cell[18349, 680, 248, 8, 70, "Input",
 CellID->281060260],
Cell[18600, 690, 581, 20, 53, "Output",
 CellID->749891315]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19242, 717, 311, 9, 70, "SeeAlsoSection",
 CellID->10195],
Cell[19556, 728, 1011, 35, 70, "SeeAlso",
 CellID->32525]
}, Open  ]],
Cell[CellGroupData[{
Cell[20604, 768, 312, 9, 70, "TutorialsSection",
 CellID->123],
Cell[20919, 779, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[21126, 787, 305, 8, 70, "RelatedLinksSection"],
Cell[21434, 797, 378, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21849, 814, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[22168, 825, 179, 3, 70, "MoreAbout",
 CellID->103274201]
}, Open  ]],
Cell[22362, 831, 27, 0, 70, "History"],
Cell[22392, 833, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

