(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21039,        814]
NotebookOptionsPosition[     16187,        640]
NotebookOutlinePosition[     17394,        676]
CellTagsIndexPosition[     17309,        671]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Loops and Control Structures\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continue" :> Documentation`HelpLookup["paclet:ref/Continue"], 
          "Return" :> Documentation`HelpLookup["paclet:ref/Return"], "Goto" :> 
          Documentation`HelpLookup["paclet:ref/Goto"], "Abort" :> 
          Documentation`HelpLookup["paclet:ref/Abort"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Continue\"\>", 2->"\<\"Return\"\>", 
       3->"\<\"Goto\"\>", 4->"\<\"Abort\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Looping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Break", "ObjectName",
 CellID->18971],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Break",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Break"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]exits the nearest enclosing ",
     Cell[BoxData[
      ButtonBox["Do",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Do"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["For",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/For"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["While",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/While"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28552]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Break",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Break"], "[", "]"}]], "InlineFormula"],
 " takes effect as soon as it is evaluated, even if it appears inside other \
functions. "
}], "Notes",
 CellID->16095],

Cell[TextData[{
 "After a ",
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 " the value ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " is returned from the enclosing control structure. "
}], "Notes",
 CellID->7221],

Cell[TextData[{
 "The function of ",
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 " can also be achieved using ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17301]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->574232893],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->318503686],

Cell[TextData[{
 "Break out of the ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " when ",
 Cell[BoxData["i"], "InlineFormula"],
 " is larger than 2:"
}], "ExampleText",
 CellID->29672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "i", "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"i", ">", "2"}], ",", 
      RowBox[{"Break", "[", "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13521],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->29017],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->7855],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->3023]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1578],

Cell[TextData[{
 "Break out of a ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " loop:"
}], "ExampleText",
 CellID->41556360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "i", "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"i", ">", "2"}], ",", 
      RowBox[{"Break", "[", "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218418024],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->28314801],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->372004416],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->270684663]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Break out of a ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loop:"
}], "ExampleText",
 CellID->592122444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", "10"}], ",", 
    RowBox[{"i", "++"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"i", ">", "2"}], ",", 
      RowBox[{"Break", "[", "]"}]}], "]"}]}], "]"}], ";", "i"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13899219],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->644402466]
}, Open  ]],

Cell[TextData[{
 "Break out of a ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " loop:"
}], "ExampleText",
 CellID->688298674],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"i", "\[LessEqual]", "10"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"i", ">", "2"}], ",", 
       RowBox[{"Break", "[", "]"}]}], "]"}], ";", 
     RowBox[{"i", "++"}]}]}], "]"}], ";", "i"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->161025629],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->405096574]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30388],

Cell["\<\
Test the condition of a loop during or at the end of the loop:\
\>", "ExampleText",
 CellID->417701320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"While", "[", 
  RowBox[{"True", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"Input", "[", "\"\<enter an integer\>\"", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"!", 
        RowBox[{"IntegerQ", "[", "n", "]"}]}], "||", 
       RowBox[{"n", "\[LessEqual]", "0"}]}], ",", 
      RowBox[{"Break", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"n", ",", "\"\<=\>\"", ",", 
      RowBox[{"FactorInteger", "[", "n", "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79845605],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"33", "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[33, "=", {{3, 1}, {11, 1}}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->90399970]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29321],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->418690538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Catch", "[", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "10"}], ",", 
     RowBox[{"i", "++"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"i", ">", "2"}], ",", 
       RowBox[{"Throw", "[", "Null", "]"}]}], "]"}]}], "]"}], "]"}], ";", 
  "i"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->906291983],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187387078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240422180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 " skips the rest of a loop, but resumes with the next iteration:"
}], "ExampleText",
 CellID->26753151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "1"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "*=", "k"}], ";", 
     RowBox[{"Print", "[", "t", "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"k", "<", "3"}], ",", 
       RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
     RowBox[{"t", "+=", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26222],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->128326469],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->50739133],

Cell[BoxData["6"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->259483263],

Cell[BoxData["32"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->157098951],

Cell[BoxData["170"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->160211596]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22091],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Continue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Continue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Goto",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Goto"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27387],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->18727]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->24903112],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->708495791]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Break - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 43.5059456}", "context" -> "System`", 
    "keywords" -> {"loops", "exit", "flow of control"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Break[] exits the nearest enclosing Do, For or While. ", 
    "synonyms" -> {}, "title" -> "Break", "type" -> "Symbol", "uri" -> 
    "ref/Break"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5289, 181, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->574232893]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17166, 664}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2137, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2760, 78, 43, 1, 70, "ObjectName",
 CellID->18971],
Cell[2806, 81, 847, 29, 70, "Usage",
 CellID->28552]
}, Open  ]],
Cell[CellGroupData[{
Cell[3690, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4168, 132, 274, 9, 70, "Notes",
 CellID->16095],
Cell[4445, 143, 351, 13, 70, "Notes",
 CellID->7221],
Cell[4799, 158, 453, 18, 70, "Notes",
 CellID->17301]
}, Closed]],
Cell[CellGroupData[{
Cell[5289, 181, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->574232893],
Cell[CellGroupData[{
Cell[5674, 195, 148, 5, 70, "ExampleSection",
 CellID->318503686],
Cell[5825, 202, 250, 10, 70, "ExampleText",
 CellID->29672],
Cell[CellGroupData[{
Cell[6100, 216, 340, 12, 70, "Input",
 CellID->13521],
Cell[CellGroupData[{
Cell[6465, 232, 88, 2, 70, "Print",
 CellID->29017],
Cell[6556, 236, 87, 2, 70, "Print",
 CellID->7855],
Cell[6646, 240, 87, 2, 70, "Print",
 CellID->3023]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6794, 249, 215, 7, 70, "ExampleSection",
 CellID->1578],
Cell[7012, 258, 190, 8, 70, "ExampleText",
 CellID->41556360],
Cell[CellGroupData[{
Cell[7227, 270, 344, 12, 70, "Input",
 CellID->218418024],
Cell[CellGroupData[{
Cell[7596, 286, 90, 2, 70, "Print",
 CellID->28314801],
Cell[7689, 290, 91, 2, 70, "Print",
 CellID->372004416],
Cell[7783, 294, 91, 2, 70, "Print",
 CellID->270684663]
}, Open  ]]
}, Open  ]],
Cell[7901, 300, 193, 8, 70, "ExampleText",
 CellID->592122444],
Cell[CellGroupData[{
Cell[8119, 312, 363, 12, 70, "Input",
 CellID->13899219],
Cell[8485, 326, 158, 5, 36, "Output",
 CellID->644402466]
}, Open  ]],
Cell[8658, 334, 197, 8, 70, "ExampleText",
 CellID->688298674],
Cell[CellGroupData[{
Cell[8880, 346, 404, 14, 70, "Input",
 CellID->161025629],
Cell[9287, 362, 158, 5, 36, "Output",
 CellID->405096574]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9494, 373, 223, 7, 70, "ExampleSection",
 CellID->30388],
Cell[9720, 382, 113, 3, 70, "ExampleText",
 CellID->417701320],
Cell[CellGroupData[{
Cell[9858, 389, 684, 19, 70, "Input",
 CellID->79845605],
Cell[10545, 410, 404, 12, 70, "Print",
 CellID->90399970]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10998, 428, 233, 7, 70, "ExampleSection",
 CellID->29321],
Cell[11234, 437, 434, 18, 70, "ExampleText",
 CellID->418690538],
Cell[CellGroupData[{
Cell[11693, 459, 416, 14, 70, "Input",
 CellID->906291983],
Cell[12112, 475, 158, 5, 36, "Output",
 CellID->187387078]
}, Open  ]],
Cell[12285, 483, 125, 3, 70, "ExampleDelimiter",
 CellID->240422180],
Cell[12413, 488, 239, 7, 70, "ExampleText",
 CellID->26753151],
Cell[CellGroupData[{
Cell[12677, 499, 471, 16, 70, "Input",
 CellID->26222],
Cell[CellGroupData[{
Cell[13173, 519, 91, 2, 70, "Print",
 CellID->128326469],
Cell[13267, 523, 90, 2, 70, "Print",
 CellID->50739133],
Cell[13360, 527, 91, 2, 70, "Print",
 CellID->259483263],
Cell[13454, 531, 92, 2, 70, "Print",
 CellID->157098951],
Cell[13549, 535, 93, 2, 70, "Print",
 CellID->160211596]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13715, 545, 311, 9, 70, "SeeAlsoSection",
 CellID->22091],
Cell[14029, 556, 922, 35, 70, "SeeAlso",
 CellID->5830]
}, Open  ]],
Cell[CellGroupData[{
Cell[14988, 596, 314, 9, 70, "TutorialsSection",
 CellID->27387],
Cell[15305, 607, 164, 3, 70, "Tutorials",
 CellID->18727]
}, Open  ]],
Cell[CellGroupData[{
Cell[15506, 615, 299, 8, 70, "MoreAboutSection"],
Cell[15808, 625, 134, 3, 70, "MoreAbout",
 CellID->24903112],
Cell[15945, 630, 147, 3, 70, "MoreAbout",
 CellID->708495791]
}, Open  ]],
Cell[16107, 636, 50, 0, 70, "History"],
Cell[16160, 638, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

