(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25727,        644]
NotebookOptionsPosition[     23077,        554]
NotebookOutlinePosition[     24273,        590]
CellTagsIndexPosition[     24188,        585]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LightBrown" :> 
          Documentation`HelpLookup["paclet:ref/LightBrown"], "ColorData" :> 
          Documentation`HelpLookup["paclet:ref/ColorData"], "Lighter" :> 
          Documentation`HelpLookup["paclet:ref/Lighter"], "Darker" :> 
          Documentation`HelpLookup["paclet:ref/Darker"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LightBrown\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Hue\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Brown", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Brown",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Brown"]], "InlineFormula"],
     "\[LineSeparator]represents the color brown in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Brown",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Brown"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"0.6", ",", "0.4", ",", "0.2"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->851624374],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->308328005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Brown", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.6, 0.4, 0.2], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->44897889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Brown"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245967023],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->191425540]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Brown", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82364862],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.6, 0.4, 0.2], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->40567932,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVm4db28j2933Zftteyb33Jlu9y2DAFAMGg22wsY2xTXohEAghjYQQAiG0
EHrv8Ffu876ygGzWye4vyzMIjXSY+X7mnBmNyrQVH92+0V98dOda0RIeKg7e
vnNt2NI4MCQe+u4fMpnsuvh7XyMT9/+fuCf9hn777TfZdzdu3PhN+pGZSxtZ
tbj9QTxokXJV4rZCzH13+ffiqCBuS//4w2cliNvLErhL25+/epa5PPvPUu77
T7WLOybpPHlZ9r9LuR8+nb8swyjZ4Jdl/PoXNuilDfhVG4Nk47+sS1HWEhVl
ea1kDV2WqP4ma/dl2dqys9+V5TWStfOybMM3WdsvrU1lZ78vy0tKZZZLJZay
sz+U5VWStemybPs3Wesvy3aWnf2xLK+UrLWXZXu+yVp9aQ2Vnf2pLC95T9qW
DvrLzv5clpdL1uBl2eg3Wf/v0hovO/tLWV6KNdl/LpWQZWf/WZYHJOt/XZbN
fJP1L5fWXNnZf5Xl/ydZ/3xpLfwfZf9u/Xl/dUimNADyAFgFgLUA2ACAYQBs
BsAIALYBYCsAltdbnv/195L/0NelseA/KABSUvFBAAwBYKNUtlhwBwDGAbAT
AJMA2A2AsoqMuPkuC4A9AFjaLY+Af5fl//t7rV/0/FLEyjQIAOJ/rFwEa7mq
PCHVnAZAscocAOYBsAiAfQB4HQBvAOBNaSvuXwPA8h73F0r+YsSQ+pIZBkAM
AEkA5ACwEgBrALD+swb5pElsg14ALEiCRB23APA2AN4FwHsAeB8A+8UElrbi
/h3J5pL717I6/yMpK2/Jcp5S/FeIwmQaURr9R19dNFdMclRKckzuStd1Sded
C1Eg+EAODsjBhyA4BIIVwyAo+2FYDop/xSMPRIhvVlc+BpXi9jtJ3ZeRJKqL
SmHUJcVQVmq1oiTtJgjeBsG7YKmlBkBwUA4OycFHCnBEAVaMKsGKJyqw4qlS
jDgxI1Y2KAou1/fvr+orH8f+e9V6DjHePpdYdxVvfyax1HogeE8O9ivAQSU4
pAAfKcERFTiqBp+owWca8LkGfKEFx8SkA19KO2K1z9WgKLlc67++qvWrfcgm
ikWkMLzoHZzU8z9v0Jik9lMYltSC8lug/C4ovy+XP1DIB5XyYRU4IirRgE+0
4DMt+EIHjunBlwbwlQEcN4CvjWDFhBGUeuZr8Yi+BDIiNvd/vkl3eV/65SoG
rOhnqiuvxqurIJV3AvJuQJ4FFL2AoggqrssVtxSKOwrFfYXigVLxUK0Y1ihG
tIpRneKpTvFcL39hkL80ysdN8tdmcMIMvrGAkxZxJHorbn4Uaxf/iumNqYQj
uqNc+z+/qr38evHTlXbfp/GIBcDAZd+XNwHyVkDRASgSgCIFKDOAshdQFgHl
NVB5U666o1DdV6oGVKqHGtWwVjWiU43qVc8MqhdG5ZhJ+cqsfG1RTlgVk1bF
W5tiyiaftsvfOcAZRylQxO2MHXxnB6dsJSzRPV+0vqT1i4guH99LPfL7EoET
lYYuBgAFQB4E5CFAEQYUEUDZDigTgDIJqNKAKgeoCqD6mlx9U6G+rVTfU6kf
aNSDWvWwTj2iV48a1E9N6hdm9UuL+pVV/dqmemNXvbWrphyqaafynVM541K8
dylm3fLSiPHdnBuUfT/rAmec4LQdHDeD5WPv1wnKrb7/RICXRjg5D8irAEUt
oGwAlC2AKgqoYoC6C1R3g+qsXJ2Xa/rkmhtKzW2V5q5G26/VDuq0Q3rtiEE7
atI+NWufW7QvrdpXNs1ru+aNQ/PWqZlyqd+51TNu9axHNedVzXuVC5CyRFCx
CMllPy5C4KIXnPeAIs87Jzhh/YLj569ylPur4ooDQQA5CchZQBEAlDWAsh5Q
NQHqVkDdAWgSgCYFajJybU6hLSq115W6WyrdHY3uvlY3oNcNGXSPTLpRs+6p
Rffcqhuz6V45dK+dujcu3VuXdtqtfefRvvdqZyHNHKRZ8KkX/eoPfpUoYQlW
LsGKj7BiyS9f8oMffOACBL53fyPJf8vypR4hjppyGYoCChJQcoCyClCFAHUj
oG4BNFFAGwe0XYAuDep65Lq8Qten0t9U629r9Pd0+gd6/aBRP2wyPLYYnlgN
z2yGF3b9K6f+tUv/xq1/69FPefXvIP17n27Or5v36xZg7SKsXUI0H1GNKGEZ
Va2ICVOuoIplVL6MyD8i4KIfnPWCX0TOT1+l+XRPIlJcJblM5FHIPBigpAGV
AKirAU09oGkCtK2ArgPQdQL6FKjPKPS9Sn1RbbiuMdzSGu7qDf0G44DJOGQ2
jliNozbjU7vxhcP40mUcdxsnPMZJr2EKMrzzGd77DbOwYR7RLyD6D6h+CdN9
xHQruFYUsUpo1gh1xRqhkv24RijXcMUqLl/GwA8I+B76wj8/fpVImv2WIgsS
SUQOBFCigIoE1BygqQS0tYC2EdC1gLo2UB8D9V1yQ1ph6FEa82pjn9Z4Q2e8
ozfdM5oemEwPLaZhq+mx3fTUYXruNI25TK88ptde0yRkmvKZpv2mGdg4ixjn
UeMiZvyAGZZwwzKhXyH1q6RelFOxTmllv2xQmg1avUGpNijlBqVYI+UrOLiE
gtOih8pHpwuer80aJB74Ew8GqHBAQwMaAdAGAV0doA8D+ghoaJcbEgpjSmHM
KE05tamoMV3XmW4ZzHeN5n6zecBiHrKZR+zmUaf5mcv8wm1+6TGPQ+Y3PvNb
v3kaNs8g5lnUPIeZFnDTB8K0RJqWSeMKZVylDetiYkpUm4xOVrHFamU/bbGa
LVa9xag2GcU6LV8lwUUMlPpMaer885+yyPiLIJNQVCigFlFIQMsCugCgrwH0
DYChGTC2gcaY3NSpMHUrTT1qc15j7tOZbxgst02We2bLA6tl0GYZdlgeOy1P
3NbnHuuY1/oKsk74LZOwZQqxvEMt7zHLHG6ZJyyLpHmJMn+kzSu0aZUxrbOm
Dda4yRlFWVu8fpvX7/C6HV67w2t2ePU2p9piFRuMfIUC51BQGm9LAOUzzR++
yif1JvwTHwyoEECNARoC0FKAjgP0VYAhBBgbAWMEMEXlprjC3KUyp9WWnNZS
0FmuGSw3TdY7Zut9q3XAbh1yWB+5bKNu21OP7QVke+mzjfttb2DbW9Q2jdlm
cOssYZ0nrQuU9QNt/chYlhnLKmtZ48wbvHmTN28JJlHZTsC4GzDIKnYDetlP
uwHdXkC7G9DsCKotXrHByZcpULrV+erc9et82Cc4GFAjgBYHdBSgZwCDABir
AWMdYAqD5lbQ3K6wJFSWlMaS0Vp79daiwXrdZLtlsd212vrttkGnfdhlH3Hb
n3jtzyD7mN/+Cra/RuyTqH0Kt78j7O9J+xxlW6Bti4xtibUtc7YVzrrGW9cF
y2bAshWwbFeaRWW7VaaKvSqj7Jf9KsN+lX6/Srdfpd2r0uxUqrYDijVOPkuA
X9xBfp1OGtkrr7xXooMBLQroCEBPAwYOMFYCphrQVA+am+WWNoWlQ2ntVFu7
tbas3pY32vpM9hsW+22b/Z7d/sBpf+hyDHscj72Opz7Hc7/jJewYRx0TmGMS
d0wTjhnSMUs75hn7Amv/wNk/8vYV3r4q2NYDto1K21aldbvKuhO0iOL2qs37
1eaDatNBjfGgxnBQoz+o1u1Xa/eCmt0q1WZAscKBf49PhFNewMGADgX0BGCg
ASMPmKoAcy1oaZBbWhTWqNIaV9u6NLa0zt5jsBdM9msWx02b447dcd/pGHA7
hzzOR5Bz1Od86ne+QJwvUedrzPmGcL4lndOU8z3tnGWc86xjkXMs8Y5lwbEa
cKxV2jeq7JtV9u2gbafatlttFcXt11gOasVkPqw1HYZMRyHjYa3hsFZ3UKPd
r9HsBFUblfJv45PmGEHJf4pPfDBgQAEjAZgYwCwA5iBgCYHWRrk1orS1q+xx
jT2ps6cNjpzJUbA4rtuct+zOu05nv9s56HENQa4Rn+sJ7HqGuMZQ1yvc9Zpw
TZKuKcr1jnG9Z11znGuBd30QnB8DzpVK52qVcz3o2Ag6tqod2zX23Vr7Xq1d
1HcQsh3WWQ/rLEelZD6uNx3XG4/qDId1+oOQdq9WvV2t/CiA5fPtC8rykee/
v1OKIaq5QIQBIwqYSMDMApYAYK0GrHVyW1hhi6jsHRpHQudIGRwZk7PX4iza
nNftrltO1123q9/jGoTcw373Y9j9BHE/x9xjuHuccE9Q7knaPc24Z1j3LO+e
F9yLAfdSpWu5yrUSdK0FXRvVzs0a51atcyfk2A059uocor7DevtRg+2owXpc
SpaTBvNxg+m4wXjcYDiq1+/XaXdr1WtB+d+gJCVH/o4IAyYEMJOAhQWsAcBW
A9rqFfYmlb1V4+jQOTsNzpTJmbW4eq2uPrvrhtN92+2+53E/gNwP/Z5HsOcx
4nmKeZ7jnpekZ5zyvKE9bxnPNOeZ4T2zgmc+4Fms9CxVuZeD7tVq93qNe6PW
tRVybde5dutce/XO/QZnibLRcdRol1Uch22yX07C1pOw5SRsPgmbTsLG40bD
YYNur16zWav8Ysz5/s85CcmVYrTqLyBhwIwAFgKwsqCtUm6vldsblI5mtbNN
64zpXV1GV7fZlbW683Z3n9N9w+257fHcgzwPfJ6HsOcR6h3FvE9x7wvS+5Ly
vma8b1jvW847zXvfC965Su9ClfdD0POx2rNc41mt9ayHPJsh91ade6fevdvg
3mt0HTS6RH1HYWfFcZND9s+TJvtps+202XrabDltNp80mU6ajEdh/UGjbqdO
/W2UUs/kpJj95M0SJQxYEMBKgjZObq9UOGqVjga1s1nratO7YkZ3l9mdtrp7
7J6803PN5bnp8d6BvPd93gHYO4R6RzBolICekdALCnrFQK9Z6A0HTQnQuwD0
vhKaq4IWgtCHau/HGu9KrXct5F2v827We7YaPDuNnr1G937YfdDkLoE2u46b
nSctztMWx2mL/SxiqziLWGU/nraYT1pMx83Gwyb9boNmtVZRHrl/zaqUPHoR
tpegKGAjQTsnd1QpnCGVs1HjatG5ogZ33OROWjxpm6fH4S24vNc83psQdMcH
3YehARQawqARAholfc8o3xjje8X6JnjfpOCbCvjeVfpmq3zz1b7FGmipFvoY
glbqoLV6aKMB2mzwbjd6d8LevSbPfrPnoNkjSjxucZ9EXCcR52mr86zVcdZq
rzhrtcl+PGu1nkbMJxHTUYthr0m32aD6G6yUNNbqrkK3BIoBNhywU4CDlzur
lK6Q2tWodbcY3FGTJ27xJG3etMObc0EFD3TNC93yQXdhXz/iG8B8Q7hvhPQ9
oXzPGN8Y63/F+ycE/2TAP1Xpfxf0z1b75mt8i7W+pZBvuc63Wu9ba/BtNEJb
YWi7Cdpthvaavfst3sOIxNrqOWl1V5y2uWTfnUWd51HHeVTst2dRm+yHszbL
Sav5uNW436LfCmu+eNJxQVv+NkPqq7wUwvoLVFjyKQbYCcBBgU5e4QqqXCGt
O6z3RIyeqNkbt3qTdijjhHJuqOD1Xff5bsG+u4ivH/MP4v5h0j9C+Z8w/mes
f4z3jwv+iYB/sso/FfTPVPtna/zztf7FkH+pzr9c719t9K83+jfCvq0m33az
b7cF2otABxHosNVbom3znEQ9p1H3WbuYXOftzvN2h6zivN0u0rZbT6OW4zbT
QcSw3az9O7TEVRCbJVobAtgxwEGATlru4pXuoMYd0nnCBm/E7G23QnE7lHT6
Mm5fzuMrQL7rfv8txH8X8/fj/kESHqbgxwz8hIWf8/CYAI8H4IkqeDIIT1fD
MzXwbAier4MX6+GlBni5EV4Nw+tN/o1m/1aLf6fFvxvx7bf6Dtp8h21Q6d7q
pN0r+/dph+esw3Pe4T6Puc5jzvOY4zxmP+uwnXZYT9rNB23GnYjub7DWXI2/
JbfCgB0BHBjoJOUuWuHm1Z6g1lOn94ZNUMQCtdughMOXdPkyHn8O8hf9/usw
fAuF7+JwPwEPUvAwgzxmkSc88lxAxgLIeBUyEUTeViPTNchMCJmtQ+brkcUG
ZKkRWQ4jq03wejO80QJvReCdVv9um3+/zX8Q9R22+0SJJx3QSQw6jXnPYp7z
uJjc53HXedx5Hnecxe2nMdtJh+Ww3bTTqv8brNhVCIugNhhwwIATk7tIpZtR
eQSNJ6jzhoxQ2AxFrL52uy/h9Cfd/owXzvngIgxfR+FbOHKXQPopZJBGhlnk
MYc+EdDnAXSsCh0PohPV6GQNOh1CZ+rQ2Xp0vgFdbESXwshyE7Lagqy3IBsR
ZKsV3mmDd6Pwfjt80O4vvfeR/fc45juJQ6dx6CzhPS8lz3nCfd7pOk84zxOO
s4T9JGY97DDvtBnKrzvf/TkrfBXAJadKrC5U7iYUnhKr1hvUQyETFLb4InZ/
u9OfcPuTXjjjg3N+pIgg1zHkFoHcJdF+Gh1k0WEOfSygTwLo80p0LIiNV2MT
tdhkCJuuw2bqsdkGbD6MLjahS83ocgu6GkHXW9GNNmSrDdmJIpIw2f8OY/Bx
3F9ybMJ32uk764TOO73nXWLynHe5z7tcZ53Os07HccJ2GLNsR41/gxSSSC2f
XAqDLkQkVXoYtVfQQUGjL2T2ha3+iMPf7oLjHjgJIRk/kkOQAopex9FbJHqX
RvsZbJDDhnlsJIA9qcSeB7Gxamy8BpsIYZN12HQ9NtOAzYax+SZssRlbasGW
I9hqK7behkp8/9ztQPZiyEEcOUzARwn4uLPEetrlOxNTEqo4T3plP50nPedJ
91nSedrlOO60HSas2x3GL2ZMF6Tlb5+ke1C31FEvHOoUHQqDbljuIVReRgsJ
el/Q5AtZ/I12OOKE291I3IskfUgaRnMoWsDRawR2i8LuMlg/iw3y+HAAH6nE
n1Thz6rxsRp8PIRP1OGT9fhUAz4Txmeb8PlmfLEFX4rgFx5UbbRjWx3Ydgzd
jaN7cfQggRx2IkedyHEXfJKERZOzpO8s5TtPQecp73nKc5Zyn6Vcp0nncZf9
oNO6HTP9DVL7H0ndMOhBFF5MDdE6H2/wBc3+kBVudMAtLiTqQeIQmvSjaQTN
YViBwK5R2E0av8vi/Tw+IOBDlfhIFf6kmnhWQ4zVEq/qiIl6YrKBmGok3jUR
0nMA2a/LbfhKFF9rxzc68K0Yth3HdhPYXie634kedqFHSeQ4iZyk4NMULD0V
Puv2yX4+64bOur1n3Z6zbvdJynmUdOx32rbi5r/BabniLPVPkRORexCVF9VA
pN7HGf1VFrjWBjc4kRY3EvWicR/aBWNpFOvBsQKJX6Pxmwx+hyPuC8RAgBiq
IkaCxGgN8ayWeBEiXtUTrxtIyXeK9y3EXIRYaCU+tBEfo8RKO7HWQWzE8M04
vp3AdzrxvS5svws7SKKHKfQohRx3Iyfdkk/T/oqztE/201kaOkt7T9Pu427X
Ucqx12Vbi5m+MXal51+Gq/7puvAlqoZQrY8w+FkTXGmFax1Igwtt9qBtEBbz
Y10I1o3hPQSep/A+hrjJEnd44n6AGKgkHwbJR9XkaC35LHRBZ3kTJqeayXct
5PsIOddKLrSRH6Lkxw5ypYNYjRHrcWIzQWx14jtd+G4S30/hBynssBs76kaP
0+hJGjnJlEhPM/7TjO80A51mvCcZz3HafdDt3E3alr81biVKrUQpRazcAysg
RO3DdH7C6GfNcMCG1DjQBjfa7MXafFgMxjtRvBvHsySRp4k+lrjBkbcF8l4l
+aCKfFhNXva7Fw3Uy0bqdZh600y9baGmI9T7VmqujVqIkh86yI8xcjlOrsbJ
9QS50UlsdRHbSWI3he914/vd+EEaO0pjFccZVLyjySInWYk06z/N+k6y0HHW
c5Rx76ed2yl7+VPmij9nVH7G6IWVl4ykEWYsSMCOVDvReg/WBGGtfrwDwTsx
IkUQWYroZcg+jrzBkxc9zjlcSz2uo57WU88bqZdharyJmmih3kao6VZqpo2a
jVLz7dRiB7UUp5YT1GonudZJbnSRm0lyO0XsdBN7aWI/jR9k8MMMdpTFjrPo
cQ960oOc9JQYT3p8xz3QUY/3IOveSzs3UrYv3gz8BSEodcnfCWGNH9PDpAmm
rYjgQIMurM6LhX14BMbbUSKBEymSzNCX0XirkrobpPqrqcFaejhEj9TTTxro
52F6rIkeb6YnWujJVnqqjX4XpWfb6fkOejFGf0hQHxPUSie11kWtJ6nNFLnV
Te6kyd0MsZch9rP4QRY/7MGOerDjHFpxnENkPx3nSphHOd9hj3c/69nJuFaT
f8YoBezFwYtvZf57NaiKcD5Y60cMMG5GaBvKO7AqNxby4o1+vAUhohghMflz
HFUQqGsB6mYVfaeavl9DD4TooTp6pIEebaSfNTEvmplXLczrCPOmjZmKMu/a
6fcd9FyMXoiLcPTHTnq5i15NUuspaqOb2kpT2xlyJ0PuZYn9HjHhBzn8MIcd
9YoJPepFjnrhw97SBfQgB+32eLYyrsUu6zey/UsaZH5ng40wZkEoG8o5sUoP
XgtdXs9cMZLsoqlulurhqbxAX6ukbwYluFpmoI55WM88amRGw8xTEa6FeRlh
xluZN1HmbTsz3cHMxJjZODOfYBY7maUuejlJr6TotW56PU1tZqitLLWdJXd7
yL0csS+mXvyglLCKwzwq+/Ewjxz0lpy3l4O2ezxrGefX3hJ+hexn6WookkGw
SiSDYSOCWFDSjkk87nqYaELJVoLsoKhOhurm6CxP9wbovir6RjVzu4a5F2Ie
1DGDDcxwI/O4iX3SzD6PsGOt7HgbOxFlJzvYqRj7Ls68TzBzncxCF/MhyXxM
MSvd9GqaXs/QG1l6UwTroXZy5G6O3Osl9vOErGI/j8t+PshjB3n0II/s5+Hd
fGn+vtHj+Zj+BrKLr/o+YV2MDSTtwgUvEfQRdQgZxsgIQbVTVIKhkxydEehc
JVMMMtermVu1zN06tr+eHWhkh8LsSDM72sI+i7Av2thXUfZ1O/smxr6Ns9MJ
9n0nO9vFzifZxRSz1M0sp5mVDLOWpdez9EYPvZWjtnupnV5yNy8mYq8gJnyv
gO0V0L0CsluAt/P+zV5Imqx/E5HkEQ7WwYgJQa0o5sBIN855iSo/UYuQDTjV
QlJRmo6xdBdPpwNMTxWTDzLXatibIfZOHXu/gR0Isw+b2Ect3GiEe9rKvYhy
L9u58Q5uIsa9TXDTnexMFzubZOdS7EI3+yHNLmWY5SyzmmXWeuj1HL3ZS2/1
Utt5MZE7BXK3QOwW8d0itltEdwrIdgHezPvXeqEPmdJDr3Kmf3zBBFwxlT6u
gwGpa+mkALSiqAMj3DgDEQE/WYOS9TjVRNKtDN3B0Z0Ckwow2Sqmt5ot1rI3
6tjb9ey9Rq4/zA02c8Mt3Egr96SNexblxjq4VzHudZx7k+CmOrl3SW4mxc12
s/NpdjHDfsiwH7Pscg+zmmPWepn1XnojT28WqK0CtV0gZRXbRUL243YR3y5i
W0V0swCv5X3LOW/52F7+5vGK84/3E5/ee6GluYo4+Es9DbZiiAMn3AQNETxM
BlEqRFBhio4wdDvHxAUmWclmgmyuhi3UstfquJsN3J1G7n4TN9DMDUW4R63c
aJR72s6/6OBfxvnxBDfRyU12cVNJ7l2Ke9/NzaW5hQy7mGWXetiPOXall1nt
Zdby9HqB3ihQm0VKVrFZJGU/bRaJzT58s4htFNG1Aryc9831eL64iv3fpKU5
zac3lnDpMqfxf8LE3AQFkRxMVmJUDUE3UHQzw7TxTCzAdlWx3UE2W8PlQ1xf
PXejgbsd5u418w9a+MFWfriNH4nyTzr4ZzF+LM6/SvCvu/g3Sf5tip/u5mbS
3GyGm8tyCz3cYo5dyrEfe9nlPLNSYFYL9FqRllWsi6A/rfeR633Eeh++3oet
FpHlAjyfg754Clc+K/uS8adLb0qjEA2r/bABgS2oCIi6CQwiaZgUMCpI0HU0
HWaZCM+0B9hEFZus5jK1XK6OK9Rz1xv5W038nWb+foQfaOWHovyjdn60g38a
558n+Jed/HgXP5HkJ1P8VJqfzvAzWW42y831cAs5brGXXcqzHwvscoFZKYqJ
Xi1Sq33UWh+52kes9uErRWypgCzk/ZMZzxfvdcqfa3zJd/WWVpqz+Es+FPuk
GYUdGOImUIgkYIrFqEqCrqWZBpZp5tm2ABurYruque5aLlvH5Rv4vkb+RhN/
u4W/F+H72/jBqDDULozEhNG48CwhvOgSXib58RQ/0c1PpvmpDP8uy8/08LM5
bq6XW+jlFvPshwK7VGQ+lhJdsdxHyX5c7iOX+4iPffiHIjpfgKdz0P/1fdgl
2+9fn/722TffvlJomhDYjsEuHIFIHKZojOIJOkgzdSwT5tlIJdse5BI1XDLE
Zer4XANfCPPXmvibLcKdVuF+m/CgXXjYIQzHhMcJ4Umn8KxLeJEUXqWE193C
RIafzPJTWf5dDz+T42Z7ubk8N19gFwrsYpH5IKY+MS4/iFw/fOgjF/uIhSI2
V0Cne/1f/VLsS6oSlPRFOATrYdiKihCwl0BhksQolqADNFPDMvUC21zJtgW5
jhquM8Sn6vlsA98b5ovNwvUW4VarcDcq9LcLAx3CUFx4lBAedwpPk8LzlDDW
LbxKC68zwkSWn+zhp3L8dC8/k+fe57nZAjdXYOeLzHwfs9BHVyyIDN/P95Fz
ffhMAXubh8t70Nf1f35EV9ogJWc4sBKEn8RQiiRojmaqWCYksI2VXEuQi9Zw
8RDfVc+nG/mesJBvFvoiwo1W4XZUuNsu9MeEwbgwlBAedQmjSeFpSnjeLYyl
hVcZYTwrTPTwkzn+bS8/lefe5bmZAjdTZN8Xmdk+MdGzfdT7PnKmSEwX8Td5
9Gtf+/xDzJaU//EqduPqq2JnyQVuHPYRCEJhBE1TjMAy1TxbV8mGg1ykhmsP
8Yl6PtnIp5uEXLNQiAjXWoUbUeF2u3AvFuiPBwY7A0NdgUdJYTQlPO0WnqWF
FxnhZVYY7+Ff5/g3vfxknntb4KYK3HSRlVVMFxnZD+/66Ok+aqpIvi3i4+I0
sPya++MXysufdWkvYsiOig0PwySMUzhFMwwT4NmaAFsf5JpquNYQ31HPJxr5
VJOQaRZyEaHQJlyLCjc7ArdjgXvxQH9nYLArMJQMPEoJj9PCk4zwLCu86BHG
cvyrHD/ey7/OcxN57k2BnSyKiZks0pNF6k2RfF0gxnqx/5Vp+uEL1aUxqfRU
U4oUD+xAxYaGUVJsaJJmWI6pDLA1VVxDDdcc4tvq+Y5GvjMspJqFTETItQmF
qHCtI3AzFrgdD9zrDPR3BQaSgYcpYTgtjGSE0azwtEd41sO/yPFjvfzLPPdK
TAV2vJSY8QL9qkC9yBNPchhYpvP7L3SWfz8l9VAzbINhPyE2LUbRBMuwAltZ
ydZWcw21XHMd39bAd4SFzmYhFREyrUIuKhQ6AtdigRvxwO3OwN2uQH8yMJAS
BruFoYzwKCs87hFGe/gnOf5ZL/e8l5NVPM+zsh9e5JnnefpZnhrtJR5m0Yu5
/V9qLe+XUiQYYD8OEyRK0zjPsAG2MsjW1HANIa65gW8L8x1NQqJFSLUKmaiQ
axfyMaEvLlxPCLe6hDtJ4V5K6O8WBtLCw4wwlOWHe/hHOf5xjqt43MvKvh/t
ZR730o9y1MMeQlVW93dfqLtavyD1Lq0oCWEojGfoSiZQzVbXcvX1XFMj39rE
t7fw8YiQbBPS7UK2Q+iNC8WEcK1TuNEl3EoJd7qFe2n+foZ/kOEHstxgj9he
D3tENYM5ZqCH7s+SN7oxTZmaii/UlI9pUhzqYZqEBZqsYvgaNhhiQ/VcY5hr
aeLbWvhYK98ZFVLtQjom9MSF3oRQ7BL6kvz1FH+zm7+V5m+nuTsZ7m6GvZth
7mToW2kqn8QvxpI/UfL7ehHJSi3uwCyJVtJ0NRMIsdX1bF2YCzdzkQgXbeVj
UT7RzidjfHeczyb4XCfX28Xlk1whxRZLiSmm6FySvFiZ9cPnV8jSmHZRX/l9
ltROis9tkQBB1tBcHRNsZEJNbEML2xRhI21sNMp2dLDxGNsZZ7sSTDLBdCXo
eJyUVhb9YTXIRU3l41b5OivqT/7v19++vi6L/iz/Ow9QZlW+9utqfdqF9dU6
oXIr9g8+KT9bXkdJyXefrJWXZZZblW6Avr+6Q/iCvrx14N8+/y6wPHrLr17e
3y5W9V2sW7hah1Vu5bws82KtUXkcls9JLJdlXqzWMlyWWW5luCxT6i2y8hVr
XxsrS9YXawHNl2WWW8kva7ZJVtays+VXt18vy3RL1rays1+7vylZ+yTrq5V2
5VY/XiqQ1o9J7fZ5pH1/WYYUsTKXuC0tGZDWbMlk//j/TmusyA==\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27445],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightBrown",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LightBrown"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413328406],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->24163540]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Brown - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 43.7403266}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Brown represents the color brown in graphics or style specifications. ", 
    "synonyms" -> {}, "title" -> "Brown", "type" -> "Symbol", "uri" -> 
    "ref/Brown"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3712, 122, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->851624374]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24045, 578}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1674, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2297, 64, 42, 1, 70, "ObjectName",
 CellID->6361],
Cell[2342, 67, 443, 14, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[2822, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3300, 103, 375, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[3712, 122, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->851624374],
Cell[CellGroupData[{
Cell[4097, 136, 148, 5, 70, "ExampleSection",
 CellID->308328005],
Cell[CellGroupData[{
Cell[4270, 145, 183, 6, 28, "Input",
 CellID->511908593],
Cell[4456, 153, 268, 8, 121, "Output",
 CellID->44897889]
}, Open  ]],
Cell[CellGroupData[{
Cell[4761, 166, 266, 8, 28, "Input",
 CellID->245967023],
Cell[5030, 176, 2399, 44, 109, "Output",
 Evaluatable->False,
 CellID->191425540]
}, Open  ]],
Cell[CellGroupData[{
Cell[7466, 225, 186, 6, 70, "Input",
 CellID->82364862],
Cell[7655, 233, 12832, 215, 129, 92, 2, "CachedBoxData", "BoxData", "Output",
 CellID->40567932]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20548, 455, 311, 9, 70, "SeeAlsoSection",
 CellID->27445],
Cell[20862, 466, 1659, 62, 70, "SeeAlso",
 CellID->2524]
}, Open  ]],
Cell[CellGroupData[{
Cell[22558, 533, 319, 9, 70, "MoreAboutSection",
 CellID->413328406],
Cell[22880, 544, 123, 3, 70, "MoreAbout",
 CellID->24163540]
}, Open  ]],
Cell[23018, 550, 29, 0, 70, "History"],
Cell[23050, 552, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

