(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24418,        773]
NotebookOptionsPosition[     20676,        648]
NotebookOutlinePosition[     22002,        686]
CellTagsIndexPosition[     21917,        681]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "ToBoxes" :> Documentation`HelpLookup["paclet:ref/ToBoxes"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Button\"\>", 
       2->"\<\"ToBoxes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ButtonBox", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ButtonBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ButtonBox"], "[", 
       StyleBox["boxes", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level box construct that represents a button \
in a notebook expression."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6530]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ButtonBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
 " is the low-level representation of ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ". Except for low-level notebook expression manipulation, ",
 Cell[BoxData[
  ButtonBox["ButtonBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
 " should not need to be used directly."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23037],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ButtonBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonBox"], "[", 
   StyleBox["boxes", "TI"], "]"}]], "InlineFormula"],
 " displays as ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 " and performs an action when it is clicked. "
}], "Notes",
 CellID->16902],

Cell[TextData[{
 "The default action is to paste ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 " at your current insertion point. Other actions can be specified using \
options. "
}], "Notes",
 CellID->26035],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ButtonBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
 " objects are used to implement palette buttons, hyperlinks and other active \
elements in notebooks. "
}], "Notes",
 CellID->7878],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ButtonBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
 " objects are active when either they or the cell that contains them has the \
option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled",
    ButtonNote->"ObsLink: Active -> Enabled"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8428],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["ButtonBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
 " objects are active, they perform an action whenever they are clicked. \
Otherwise, clicking them simply selects them or their contents. "
}], "Notes",
 CellID->1355],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ButtonBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonBox"], "[", 
   RowBox[{
    StyleBox["boxes", "TI"], ",", 
    RowBox[{
     ButtonBox["BaseStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BaseStyle"], "->", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}]}], "]"}]], "InlineFormula"],
 " takes the properties of the ",
 Cell[BoxData[
  ButtonBox["ButtonBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
 " from the specified style. The style for a ",
 Cell[BoxData[
  ButtonBox["ButtonBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
 " can specify both its appearance and its action. "
}], "Notes",
 CellID->32492],

Cell["\<\
The following options affecting button appearance can be given: \
\>", "Notes",
 CellID->10297],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "button background color ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButtonFrame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ButtonFrame"], "\"\<Palette\>\"", Cell[
    "the type of frame for the button ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButtonExpandable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ButtonExpandable",
     ButtonNote->"ObsLink: No successor for ButtonExpandable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether a button should expand to fill a position in a ",
     Cell[BoxData[
      ButtonBox["GridBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GridBox"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins",
     ButtonNote->"ObsLink: ButtonMargins -> FrameMargins (Button)"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the margin in printer\[CloseCurlyQuote]s points around the contents of a \
button \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButtonMinHeight",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ButtonMinHeight"], "1.0", Cell[
    "the minimum total height of a button in units of font size ", 
     "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->2673],

Cell["The following options affecting button action can be given: ", "Notes",
 CellID->10078],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButtonData",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ButtonData"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the second argument to supply to the button function ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButtonFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ButtonFunction"], Cell[
    "(pasting function) ", "TableText"], Cell[
    "the function to apply when the button is clicked ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ButtonSource",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ButtonSource"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "where to get the first argument of the button function", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled",
     ButtonNote->"ObsLink: Active -> Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to make the button always active ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Evaluator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluator"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to send the button function expression for evaluation ", 
     "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->11274],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ButtonBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonBox"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " if it is given as input to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. "
}], "Notes",
 CellID->22810]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189806670],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->4614197],

Cell["\<\
Display a button that opens a new notebook window when clicked:\
\>", "ExampleText",
 CellID->494414132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ButtonBox", "[", 
   RowBox[{"\"\<new\>\"", ",", 
    RowBox[{"ButtonFunction", "\[Rule]", 
     RowBox[{"FrontEndToken", "[", "\"\<New\>\"", "]"}]}], ",", 
    RowBox[{"ButtonFrame", "\[Rule]", "\"\<DialogBox\>\""}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184198836],

Cell[BoxData[
 TagBox[
  ButtonBox["new",
   ButtonData->"paclet:ref/new",
   ButtonFrame->"DialogBox",
   ButtonFunction:>FrontEndToken["New"]],
  DisplayForm]], "Output",
 ImageSize->{34, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->174081805]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55852675],

Cell[TextData[{
 "Display a button that assigns a random number to ",
 Cell[BoxData["r"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9303239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ButtonBox", "[", 
   RowBox[{"\"\<random\>\"", ",", 
    RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"ButtonFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "=", 
         RowBox[{"RandomReal", "[", "]"}]}], ")"}], "&"}], ")"}]}], ",", 
    RowBox[{"ButtonFrame", "\[Rule]", "\"\<DialogBox\>\""}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517936164],

Cell[BoxData[
 TagBox[
  ButtonBox["random",
   ButtonData->"paclet:ref/random",
   ButtonFrame->"DialogBox",
   ButtonFunction:>(($CellContext`r = RandomReal[])& ),
   Evaluator->Automatic],
  DisplayForm]], "Output",
 ImageSize->{50, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->18770842]
}, Open  ]],

Cell[TextData[{
 "See the value of ",
 Cell[BoxData["r"], "InlineFormula"],
 " after clicking the button:"
}], "ExampleText",
 CellID->157579422],

Cell[CellGroupData[{

Cell[BoxData["r"], "Input",
 CellLabel->"In[2]:=",
 CellID->190785875],

Cell[BoxData["0.2808943395486172`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->677677949]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28598],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12248]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30819],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->24586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->79694629]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButtonBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 44.0372092}", "context" -> "System`", 
    "keywords" -> {
     "active element", "clickable elements", "palette buttons", 
      "palette element"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ButtonBox[boxes] is a low-level box construct that represents a button \
in a notebook expression.", "synonyms" -> {"button box"}, "title" -> 
    "ButtonBox", "type" -> "Symbol", "uri" -> "ref/ButtonBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15786, 452, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->189806670]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21773, 674}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1914, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2537, 76, 4193, 83, 70, "ObjectNameGrid"],
Cell[6733, 161, 528, 16, 70, "Usage",
 CellID->6530]
}, Open  ]],
Cell[CellGroupData[{
Cell[7298, 182, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7776, 199, 675, 20, 70, "Notes",
 CellID->23037],
Cell[8454, 221, 347, 12, 70, "Notes",
 CellID->16902],
Cell[8804, 235, 227, 7, 70, "Notes",
 CellID->26035],
Cell[9034, 244, 269, 8, 70, "Notes",
 CellID->7878],
Cell[9306, 254, 526, 18, 70, "Notes",
 CellID->8428],
Cell[9835, 274, 315, 9, 70, "Notes",
 CellID->1355],
Cell[10153, 285, 783, 25, 70, "Notes",
 CellID->32492],
Cell[10939, 312, 105, 3, 70, "Notes",
 CellID->10297],
Cell[11047, 317, 2103, 54, 70, "3ColumnTableMod",
 CellID->2673],
Cell[13153, 373, 93, 1, 70, "Notes",
 CellID->10078],
Cell[13249, 376, 1961, 50, 70, "3ColumnTableMod",
 CellID->11274],
Cell[15213, 428, 536, 19, 70, "Notes",
 CellID->22810]
}, Closed]],
Cell[CellGroupData[{
Cell[15786, 452, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189806670],
Cell[CellGroupData[{
Cell[16171, 466, 146, 5, 70, "ExampleSection",
 CellID->4614197],
Cell[16320, 473, 114, 3, 70, "ExampleText",
 CellID->494414132],
Cell[CellGroupData[{
Cell[16459, 480, 340, 9, 47, "Input",
 CellID->184198836],
Cell[16802, 491, 315, 11, 60, "Output",
 CellID->174081805]
}, Open  ]],
Cell[17132, 505, 124, 3, 70, "ExampleDelimiter",
 CellID->55852675],
Cell[17259, 510, 149, 5, 70, "ExampleText",
 CellID->9303239],
Cell[CellGroupData[{
Cell[17433, 519, 491, 14, 70, "Input",
 CellID->517936164],
Cell[17927, 535, 360, 12, 70, "Output",
 CellID->18770842]
}, Open  ]],
Cell[18302, 550, 145, 5, 70, "ExampleText",
 CellID->157579422],
Cell[CellGroupData[{
Cell[18472, 559, 70, 2, 70, "Input",
 CellID->190785875],
Cell[18545, 563, 176, 5, 36, "Output",
 CellID->677677949]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18782, 575, 311, 9, 70, "SeeAlsoSection",
 CellID->28598],
Cell[19096, 586, 445, 17, 70, "SeeAlso",
 CellID->12248]
}, Open  ]],
Cell[CellGroupData[{
Cell[19578, 608, 314, 9, 70, "TutorialsSection",
 CellID->30819],
Cell[19895, 619, 179, 4, 70, "Tutorials",
 CellID->24586]
}, Open  ]],
Cell[CellGroupData[{
Cell[20111, 628, 299, 8, 70, "MoreAboutSection"],
Cell[20413, 638, 168, 3, 70, "MoreAbout",
 CellID->79694629]
}, Open  ]],
Cell[20596, 644, 50, 0, 70, "History"],
Cell[20649, 646, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

