(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9558,        334]
NotebookOptionsPosition[      6867,        248]
NotebookOutlinePosition[      8190,        285]
CellTagsIndexPosition[      8106,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
         "WindowFrame" :> 
         Documentation`HelpLookup["paclet:ref/WindowFrame"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Button\"\>", 
      2->"\<\"WindowFrame\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButtonFrame", "ObjectName",
 CellID->5979],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ButtonFrame",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonFrame"]], "InlineFormula"],
     "\[LineSeparator]is an option for the low-level function ",
     Cell[BoxData[
      ButtonBox["ButtonBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
     " which specifies the type of frame to display around a button. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8898]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Typical settings supported include: ", "Notes",
 CellID->16057],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Palette\>\"", Cell[
    "a button in a palette ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DialogBox\>\"", Cell[
    "a button in a dialog box ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no frame ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->20669],

Cell[TextData[{
 "Button frames generated by ",
 Cell[BoxData[
  ButtonBox["ButtonFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonFrame"]], "InlineFormula"],
 " are set up to follow the conventions for particular computer systems. "
}], "Notes",
 CellID->18345],

Cell[TextData[{
 "A button with a particular setting for ",
 Cell[BoxData[
  ButtonBox["ButtonFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonFrame"]], "InlineFormula"],
 " may look slightly different on different computer systems. "
}], "Notes",
 CellID->32748]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166207436],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->353637535],

Cell["Make a button that looks like a typical dialog box button:", \
"ExampleText",
 CellID->574918596],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"ButtonBox", "[", 
      RowBox[{"\"\<button\>\"", ",", 
       RowBox[{"ButtonFrame", "\[Rule]", "\"\<DialogBox\>\""}], ",", 
       RowBox[{"ButtonFunction", "\[Rule]", "Null"}]}], "]"}], "]"}], ",", 
    "\"\<Text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->460257320],

Cell[BoxData[
 ButtonBox["button",
  ButtonData->"paclet:ref/button",
  ButtonFrame->"DialogBox",
  ButtonFunction:>Null]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->19207810],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100275282],

Cell["Make a button with no frame:", "ExampleText",
 CellID->310454550],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"ButtonBox", "[", 
      RowBox[{"\"\<button\>\"", ",", 
       RowBox[{"ButtonFrame", "\[Rule]", "None"}], ",", 
       RowBox[{"ButtonFunction", "\[Rule]", "Null"}]}], "]"}], "]"}], ",", 
    "\"\<Text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199198961],

Cell[BoxData[
 ButtonBox["button",
  ButtonData->"paclet:ref/button",
  ButtonFrame->None,
  ButtonFunction:>Null]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->444106956]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27041],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowFrame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFrame"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12804]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButtonFrame - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 51.0217630}", "context" -> "System`", 
    "keywords" -> {"frames for buttons", "frame style for buttons"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ButtonFrame is an option for the low-level function ButtonBox which \
specifies the type of frame to display around a button. ", 
    "synonyms" -> {"button frame"}, "title" -> "ButtonFrame", "type" -> 
    "Symbol", "uri" -> "ref/ButtonFrame"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3927, 132, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->166207436]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7963, 273}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 664, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1287, 43, 48, 1, 70, "ObjectName",
 CellID->5979],
Cell[1338, 46, 637, 18, 70, "Usage",
 CellID->8898]
}, Open  ]],
Cell[CellGroupData[{
Cell[2012, 69, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2490, 86, 69, 1, 70, "Notes",
 CellID->16057],
Cell[2562, 89, 769, 18, 70, "2ColumnTableMod",
 CellID->20669],
Cell[3334, 109, 276, 8, 70, "Notes",
 CellID->18345],
Cell[3613, 119, 277, 8, 70, "Notes",
 CellID->32748]
}, Closed]],
Cell[CellGroupData[{
Cell[3927, 132, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166207436],
Cell[CellGroupData[{
Cell[4312, 146, 148, 5, 70, "ExampleSection",
 CellID->353637535],
Cell[4463, 153, 103, 2, 70, "ExampleText",
 CellID->574918596],
Cell[4569, 157, 411, 11, 70, "Input",
 CellID->460257320],
Cell[4983, 170, 198, 7, 70, "Text",
 CellID->19207810],
Cell[5184, 179, 125, 3, 70, "ExampleDelimiter",
 CellID->100275282],
Cell[5312, 184, 71, 1, 70, "ExampleText",
 CellID->310454550],
Cell[5386, 187, 398, 11, 70, "Input",
 CellID->199198961],
Cell[5787, 200, 192, 7, 70, "Text",
 CellID->444106956]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6028, 213, 311, 9, 70, "SeeAlsoSection",
 CellID->27041],
Cell[6342, 224, 453, 17, 70, "SeeAlso",
 CellID->12804]
}, Open  ]],
Cell[6810, 244, 27, 0, 70, "History"],
Cell[6840, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

