(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11848,        425]
NotebookOptionsPosition[      8976,        333]
NotebookOutlinePosition[     10383,        372]
CellTagsIndexPosition[     10298,        367]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
         "Evaluator" :> Documentation`HelpLookup["paclet:ref/Evaluator"], 
         "NotebookApply" :> 
         Documentation`HelpLookup["paclet:ref/NotebookApply"], 
         "ButtonNotebook" :> 
         Documentation`HelpLookup["paclet:ref/ButtonNotebook"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Button\"\>", 2->"\<\"Evaluator\"\>", 
      3->"\<\"NotebookApply\"\>", 
      4->"\<\"ButtonNotebook\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButtonFunction", "ObjectName",
 CellID->8190],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ButtonFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonFunction"]], "InlineFormula"],
     "\[LineSeparator]is an option for the low-level function ",
     Cell[BoxData[
      ButtonBox["ButtonBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
     " which specifies the function to execute when the button is active and \
is clicked. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10001]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["ButtonFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonFunction"]], "InlineFormula"],
 " causes the button to paste its contents at your current notebook \
selection. "
}], "Notes",
 CellID->9429],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ButtonFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonFunction"]], "InlineFormula"],
 " is used only with the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled",
    ButtonNote->"ObsLink: Active -> Enabled"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " either for the individual button, or for the cell which contains it. "
}], "Notes",
 CellID->7229],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ButtonFunction", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " the first argument supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is specified by the setting for ",
 Cell[BoxData[
  ButtonBox["ButtonSource",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonSource"]], "InlineFormula"],
 ", and the second argument by the setting for ",
 Cell[BoxData[
  ButtonBox["ButtonData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonData"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9947],

Cell[TextData[{
 "Standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " precedence rules require parentheses in ",
 Cell[BoxData[
  RowBox[{"ButtonFunction", "->", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["body", "TI"], "&"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11187],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["ButtonFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonFunction"]], "InlineFormula"],
 " are often inherited from button styles via the ",
 Cell[BoxData[
  ButtonBox["ButtonStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ButtonStyle"]], "InlineFormula"],
 " option. "
}], "Notes",
 CellID->2431],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Evaluator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Evaluator"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " the expression constructed from the button function is sent to the front \
end for evaluation. "
}], "Notes",
 CellID->23503]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->218456596],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->12272985],

Cell["Create a button that opens a new notebook when pressed: ", "ExampleText",
 CellID->531241327],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"ButtonBox", "[", 
      RowBox[{"\"\<new\>\"", ",", 
       RowBox[{"ButtonFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"FrontEndToken", "[", "\"\<New\>\"", "]"}], "&"}], 
         ")"}]}]}], "]"}], "]"}], ",", "\"\<Text\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10363123],

Cell[BoxData[
 ButtonBox["new",
  ButtonData->"paclet:ref/new",
  ButtonFunction:>(FrontEndToken["New"]& )]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->236390996],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87327221],

Cell[TextData[{
 "The same thing using a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function:"
}], "ExampleText",
 CellID->37359897],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"ButtonBox", "[", 
      RowBox[{"\"\<new\>\"", ",", 
       RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ButtonFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"NotebookCreate", "[", "]"}], "&"}], ")"}]}]}], "]"}], 
     "]"}], ",", "\"\<Text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423253978],

Cell[BoxData[
 ButtonBox["new",
  ButtonData->"paclet:ref/new",
  ButtonFunction:>(NotebookCreate[]& ),
  Evaluator->Automatic]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->183800415]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32069],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Evaluator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Evaluator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookApply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookApply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4322]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButtonFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 51.2092678}", "context" -> "System`", 
    "keywords" -> {
     "callback", "button callback function", "button action function", 
      "button actions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ButtonFunction is an option for the low-level function ButtonBox which \
specifies the function to execute when the button is active and is clicked. ",
     "synonyms" -> {"button function"}, "title" -> "ButtonFunction", "type" -> 
    "Symbol", "uri" -> "ref/ButtonFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5316, 190, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->218456596]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10155, 360}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 900, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1523, 47, 51, 1, 70, "ObjectName",
 CellID->8190],
Cell[1577, 50, 666, 19, 70, "Usage",
 CellID->10001]
}, Open  ]],
Cell[CellGroupData[{
Cell[2280, 74, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2758, 91, 286, 9, 70, "Notes",
 CellID->9429],
Cell[3047, 102, 550, 17, 70, "Notes",
 CellID->7229],
Cell[3600, 121, 586, 20, 70, "Notes",
 CellID->9947],
Cell[4189, 143, 303, 12, 70, "Notes",
 CellID->11187],
Cell[4495, 157, 383, 13, 70, "Notes",
 CellID->2431],
Cell[4881, 172, 398, 13, 70, "Notes",
 CellID->23503]
}, Closed]],
Cell[CellGroupData[{
Cell[5316, 190, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->218456596],
Cell[CellGroupData[{
Cell[5701, 204, 147, 5, 70, "ExampleSection",
 CellID->12272985],
Cell[5851, 211, 99, 1, 70, "ExampleText",
 CellID->531241327],
Cell[5953, 214, 454, 14, 70, "Input",
 CellID->10363123],
Cell[6410, 230, 185, 6, 70, "Text",
 CellID->236390996],
Cell[6598, 238, 124, 3, 70, "ExampleDelimiter",
 CellID->87327221],
Cell[6725, 243, 151, 6, 70, "ExampleText",
 CellID->37359897],
Cell[6879, 251, 494, 14, 70, "Input",
 CellID->423253978],
Cell[7376, 267, 205, 7, 70, "Text",
 CellID->183800415]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7630, 280, 311, 9, 70, "SeeAlsoSection",
 CellID->32069],
Cell[7944, 291, 960, 35, 70, "SeeAlso",
 CellID->4322]
}, Open  ]],
Cell[8919, 329, 27, 0, 70, "History"],
Cell[8949, 331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

