(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8364,        294]
NotebookOptionsPosition[      6013,        220]
NotebookOutlinePosition[      7362,        257]
CellTagsIndexPosition[      7278,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
         "RowMinHeight" :> 
         Documentation`HelpLookup["paclet:ref/RowMinHeight"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Button\"\>", 
      2->"\<\"RowMinHeight\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButtonMinHeight", "ObjectName",
 CellID->5519],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ButtonMinHeight",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonMinHeight"]], "InlineFormula"],
     "\[LineSeparator]is an option for the low-level function ",
     Cell[BoxData[
      ButtonBox["ButtonBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ButtonBox"]], "InlineFormula"],
     " which specifies the minimum total height in units of font size that \
should be allowed for the button. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"ButtonMinHeight", "->", "1"}]], "InlineFormula"],
 " forces a button to have a total height which at least accommodates all the \
characters in the current font. "
}], "Notes",
 CellID->28098],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ButtonMinHeight", "->", "0"}]], "InlineFormula"],
 " reduces the total height of a button as much as possible, allowing buttons \
containing characters such as ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["X"], "InlineFormula"],
 " to be different heights. "
}], "Notes",
 CellID->13266]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105430382],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->481729379],

Cell["Create buttons of varying heights:", "ExampleText",
 CellID->612382882],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"RowBox", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ButtonBox", "[", 
         RowBox[{"\"\<button\>\"", ",", 
          RowBox[{"ButtonMinHeight", "\[Rule]", "h"}], ",", 
          RowBox[{"ButtonFunction", "\[Rule]", "Null"}], ",", 
          RowBox[{"ButtonFrame", "\[Rule]", "\"\<DialogBox\>\""}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"h", ",", "1", ",", "4"}], "}"}]}], "]"}], "]"}], "]"}], 
    ",", "\"\<Text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312598608],

Cell[BoxData[
 RowBox[{
  ButtonBox["button",
   ButtonData->"paclet:ref/button",
   ButtonFrame->"DialogBox",
   ButtonFunction:>Null,
   ButtonMinHeight->1], 
  ButtonBox["button",
   ButtonData->"paclet:ref/button",
   ButtonFrame->"DialogBox",
   ButtonFunction:>Null,
   ButtonMinHeight->2], 
  ButtonBox["button",
   ButtonData->"paclet:ref/button",
   ButtonFrame->"DialogBox",
   ButtonFunction:>Null,
   ButtonMinHeight->3], 
  ButtonBox["button",
   ButtonData->"paclet:ref/button",
   ButtonFrame->"DialogBox",
   ButtonFunction:>Null,
   ButtonMinHeight->4]}]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->60543860]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25215],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowMinHeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowMinHeight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2844]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButtonMinHeight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 51.5686520}", "context" -> "System`", 
    "keywords" -> {"button height"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ButtonMinHeight is an option for the low-level function ButtonBox which \
specifies the minimum total height in units of font size that should be \
allowed for the button. ", "synonyms" -> {"button min height"}, "title" -> 
    "ButtonMinHeight", "type" -> "Symbol", "uri" -> "ref/ButtonMinHeight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3195, 111, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->105430382]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7135, 245}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 667, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1290, 43, 52, 1, 70, "ObjectName",
 CellID->5519],
Cell[1345, 46, 687, 19, 70, "Usage",
 CellID->5619]
}, Open  ]],
Cell[CellGroupData[{
Cell[2069, 70, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2547, 87, 259, 7, 70, "Notes",
 CellID->28098],
Cell[2809, 96, 349, 10, 70, "Notes",
 CellID->13266]
}, Closed]],
Cell[CellGroupData[{
Cell[3195, 111, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105430382],
Cell[CellGroupData[{
Cell[3580, 125, 148, 5, 70, "ExampleSection",
 CellID->481729379],
Cell[3731, 132, 77, 1, 70, "ExampleText",
 CellID->612382882],
Cell[3811, 135, 662, 18, 70, "Input",
 CellID->312598608],
Cell[4476, 155, 648, 24, 70, "Text",
 CellID->60543860]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5173, 185, 311, 9, 70, "SeeAlsoSection",
 CellID->25215],
Cell[5487, 196, 454, 17, 70, "SeeAlso",
 CellID->2844]
}, Open  ]],
Cell[5956, 216, 27, 0, 70, "History"],
Cell[5986, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

